/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3sto.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3STO_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3STO_H_INCLUDED 1


#line 10 "dk3sto.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Create new storage.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new storage on succcess, NULL on error.
	Use dk3sto_close() to destroy the storage when done with it.
*/
dk3_sto_t *
dk3sto_open_app(dk3_app_t *app);

/**	Destroy storage, release memory.
	@param	st	Storage to destroy.
*/
void
dk3sto_close(dk3_sto_t *st);

/**	Remove all pointers from a storage.
	@param	st	Storage.
*/
void
dk3sto_remove_all(dk3_sto_t *st);

/**	Remove one pointer from storage.
	@param	st	Storage.
	@param	o	Object pointer to remove.
	@return	1 on success, 0 on error (not found).
*/
int
dk3sto_remove(dk3_sto_t *st, void *o);

/**	Add object pointer to storage.
	@param	st	Storage.
	@param	o	Object pointer to add.
	@return	1 on success, 0 on error (not enough memory).
*/
int
dk3sto_add(dk3_sto_t *st, void *o);

/**	Create iterator for storage.
	@param	st	Storage.
	@return	Pointer to new iterator on success, NULL on error.
	Use dk3sto_it_close() to destroy the iterator when done with it.
	When closing/destroying a storage all iterators for that
	storage are destroyed automatically.
*/
dk3_sto_it_t *
dk3sto_it_open(dk3_sto_t *st);

/**	Destroy iterator.
	@param	it	Iterator to destroy.
*/
void
dk3sto_it_close(dk3_sto_it_t *it);

/**	Reset iterator (next call to dk3sto_it_next() will return the
	first object pointer.
	@param	it	Iterator.
*/
void
dk3sto_it_reset(dk3_sto_it_t *it);

/**	Return next object pointer.
	@param	it	Iterator.
	@return	Pointer to next object on success, NULL on error
	(no more pointers available).
*/
void *
dk3sto_it_next(dk3_sto_it_t *it);

/**	Find a pointer exactly.
	@param	i	Iterator.
	@param	o	Object pointer.
	@return	Object pointer on success, NULL on error (object not found).
	The next calls to dk3sto_it_next() will return pointers to objects
	after the specified object \a o.
*/
void *
dk3sto_it_find_exact(dk3_sto_it_t *i, void const *o);

/**	Find object pointer for object evaluating equally to \a o.
	@param	i	Iterator.
	@param	o	Object pointer.
	@param	cr	Comparison criteria.
	@return	Object pointer on success, NULL on error (no such object).
*/
void *
dk3sto_it_find_like(dk3_sto_it_t *i, void const *o, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to a char.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_c(dk3_sto_t *st, dk3_fct_eval_c_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to an unsigned char.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_uc(dk3_sto_t *st, dk3_fct_eval_uc_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to a short.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_s(dk3_sto_t *st, dk3_fct_eval_s_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to an unsigned short.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_us(dk3_sto_t *st, dk3_fct_eval_us_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to an int.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_i(dk3_sto_t *st, dk3_fct_eval_i_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to an unsigned int.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_ui(dk3_sto_t *st, dk3_fct_eval_ui_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to a long.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_l(dk3_sto_t *st, dk3_fct_eval_l_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to an unsigned long.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_ul(dk3_sto_t *st, dk3_fct_eval_ul_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to a float.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_f(dk3_sto_t *st, dk3_fct_eval_f_t *f, int cr);

/**	Set evaluation function.
	@param	st	Storage.
	@param	f	Function evaluating a pointer to a double.
	@param	cr	Evaluation criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_eval_d(dk3_sto_t *st, dk3_fct_eval_d_t *f, int cr);

/**	Set comparison function.
	@param	st	Storage.
	@param	f	Function comparing two object pointers.
	@param	cr	Comparison criteria.
	@return	1 on success, 0 on error.
*/
int
dk3sto_set_comp(dk3_sto_t *st, dk3_fct_comp_t *f, int cr);

/**	Allow use of tree structures.
	This function must be called before adding any data.
	@param	st	Storage.
	@param	ok	Flag: Trees may be used.
	@return	1 on success, 0 on error.
*/
int
dk3sto_use_trees(dk3_sto_t *st,int ok);

/**	Find object pointer at the trees root.
	@param	s	Storage.
*/
void *
dk3sto_find_root(dk3_sto_t *s);

/**	Find object pointer for the parent node
	of the last found object.
	@param	i	Iterator.
	@return	Object pointer on success, NULL on error.
*/
void *
dk3sto_it_find_parent(dk3_sto_it_t *i);

/**	Find object pointer for node on left child of the last found object.
	@param	i	Iterator.
	@return	Object pointer on success, NULL on error.
*/
void *
dk3sto_it_find_left(dk3_sto_it_t *i);

/**	Find object pointer for node on right child of the last found object.
	@param	i	Iterator.
	@return	Object pointer on success, NULL on error.
*/
void *
dk3sto_it_find_right(dk3_sto_it_t *i);

/**	Find object pointer at the trees root.
	@param	i	Iterator.
*/
void *
dk3sto_it_find_root(dk3_sto_it_t *i);



#ifdef __cplusplus
}
#endif




#endif
