/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3srch.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3srch.c The dk3srch module.
*/


#line 61 "dk3srch.ctr"

#include "dk3all.h"






#line 67 "dk3srch.ctr"



/**	One result node.
*/
typedef struct _dk3_search_node_t_ {
  unsigned long	n;	/**< Node number. */
  dkChar const	*fn;	/**< File name. */
} dk3_search_node_t;



/**	Compare two line nodes.
	@param	l	Left node.
	@param	r	Right node.
	@param	cr	Comparison criteria.
	@return	Comparison result.
*/
static
int
node_compare(void const *l, void const *r, int cr)
{
  int back = 0;
  dk3_search_node_t const	*pl;	/* Left node. */
  dk3_search_node_t const	*pr;	/* Right node. */
  if(l) {
    if(r) {
      pl = (dk3_search_node_t const *)l;
      pr = (dk3_search_node_t const *)r;
      if(pl->n > pr->n) { back = 1; }
      else { if(pl->n < pr->n) { back = -1; } }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  if(cr) { back = 0 - back; }
  return back;
}



/**	Delete one node, release memory.
	@param	n	Node to delete.
*/
static
void
dk3search_node_delete(dk3_search_node_t *n)
{
  if(n) {
    dk3_release(n->fn);
    n->n = 0UL;
    dk3_delete(n);
  }
}



/**	Create new node, allocate memory.
	@param	n	Node number.
	@param	fn	File name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to new node on success, NULL on error.
*/
static
dk3_search_node_t *
dk3search_node_new_app(unsigned long n, dkChar const *fn, dk3_app_t *app)
{
  dk3_search_node_t *back = NULL;
  

#line 136 "dk3srch.ctr"
  back = dk3_new_app(dk3_search_node_t,1,app);
  if(back) {
    back->n = n;
    back->fn = dk3str_dup_app(fn, app);
    if(!(back->fn)) {	

#line 141 "dk3srch.ctr"
      dk3search_node_delete(back); back = NULL;
    }
  } 

#line 144 "dk3srch.ctr"
  return back;
}



void
dk3search_close(dk3_search_t *sp)
{
  dk3_search_node_t *n = NULL;
  if(sp) {
    if(sp->s_fn) {
      if(sp->i_fn) {
        dk3sto_it_reset(sp->i_fn);
	while((n = (dk3_search_node_t *)dk3sto_it_next(sp->i_fn)) != NULL) {
	  dk3search_node_delete(n);
	}
        dk3sto_it_close(sp->i_fn);
      }
      dk3sto_close(sp->s_fn);
    } sp->s_fn = NULL; sp->i_fn = NULL;
    sp->app = NULL;
    dk3_delete(sp);
  }
}



dk3_search_t *
dk3search_open_app(int i, dk3_app_t *app)
{
  dk3_search_t *back = NULL;
  back = dk3_new_app(dk3_search_t,1,app);
  if(back) {
    back->s_fn = NULL; back->i_fn = NULL; back->inverted = (i ? 1 : 0);
    back->nf = 0UL; back->app = app;
    back->s_fn = dk3sto_open_app(app);
    if(back->s_fn) {
      back->i_fn = dk3sto_it_open(back->s_fn);
      dk3sto_set_comp(back->s_fn, node_compare, 0);
    }
    if(!((back->s_fn) && (back->i_fn))) {
      dk3search_close(back); back = NULL;
    }
  }
  return back;
}



int
dk3search_add(dk3_search_t *sp, dkChar const *fn)
{
  int back = 0;
  dk3_search_node_t *n = NULL;	/* New node. */
  

#line 199 "dk3srch.ctr"
  if((sp) && (fn)) {
    n = dk3search_node_new_app(sp->nf, fn, sp->app);
    if(n) {
      if(dk3sto_add(sp->s_fn, n)) {
        back = 1;
	sp->nf += 1UL;
      } else {
        dk3search_node_delete(n);
      }
    }
  } 

#line 210 "dk3srch.ctr"
  return back;
}



void
dk3search_reset(dk3_search_t *sp)
{
  if(sp) {
    dk3sto_it_reset(sp->i_fn);
  }
}



dkChar const *
dk3search_next(dk3_search_t *sp)
{
  dkChar const *back = NULL;
  dk3_search_node_t	*node = NULL;	/* Next node. */
  if(sp) {
    node = (dk3_search_node_t *)dk3sto_it_next(sp->i_fn);
    if(node) {
      back = node->fn;
    }
  } 

#line 236 "dk3srch.ctr"
  return back;
}



/* vim: set ai sw=2 : */

