/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3sock4.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3sock4.c The dk3sock4 module.
*/


#line 9 "dk3sock4.ctr"


#include "dk3all.h"
#include "dk3sock.h"





#line 17 "dk3sock4.ctr"


#if DK3_ON_WINDOWS





#line 24 "dk3sock4.ctr"


#line 25 "dk3sock4.ctr"


#line 26 "dk3sock4.ctr"


#line 27 "dk3sock4.ctr"


#line 28 "dk3sock4.ctr"


#line 29 "dk3sock4.ctr"


#line 30 "dk3sock4.ctr"


#line 31 "dk3sock4.ctr"


#line 32 "dk3sock4.ctr"





#line 36 "dk3sock4.ctr"


#line 37 "dk3sock4.ctr"


#line 38 "dk3sock4.ctr"


#line 39 "dk3sock4.ctr"


#line 40 "dk3sock4.ctr"


#line 41 "dk3sock4.ctr"


#line 42 "dk3sock4.ctr"


#line 43 "dk3sock4.ctr"


#line 44 "dk3sock4.ctr"


#line 45 "dk3sock4.ctr"


#line 46 "dk3sock4.ctr"


#line 47 "dk3sock4.ctr"


#line 48 "dk3sock4.ctr"


#line 49 "dk3sock4.ctr"


#line 50 "dk3sock4.ctr"


#line 51 "dk3sock4.ctr"


#line 52 "dk3sock4.ctr"


#line 53 "dk3sock4.ctr"


#line 54 "dk3sock4.ctr"


#line 55 "dk3sock4.ctr"


#line 56 "dk3sock4.ctr"


#line 57 "dk3sock4.ctr"


#line 58 "dk3sock4.ctr"


#line 59 "dk3sock4.ctr"


#line 60 "dk3sock4.ctr"


#line 61 "dk3sock4.ctr"


#line 62 "dk3sock4.ctr"


#line 63 "dk3sock4.ctr"



void
dk3socket_set_delete(dk3_socket_set_t *ps)
{
  if(ps) {
    dk3_release(ps->pData);
    ps->szMax = 0; ps->szUsed = 0;
    dk3_delete(ps);
  }
}



void
dk3socket_set_close(dk3_socket_set_t *ps, int *ec, dk3_app_t *app)
{
  dk3_socket_t		*ptr;	/* Current socket to close. */
  size_t		 i;	/* Index of current socket to close. */
  if(ps) {
    if((ps->pData) && (ps->szUsed)) {
      ptr = ps->pData;
      for(i = 0; i < ps->szUsed; i++) {
        if(INVALID_SOCKET != (*ptr)) {
	  dk3socket_close(*ptr, ec, app);
	  *ptr = INVALID_SOCKET;
	}
        ptr++;
      }
    }
    dk3socket_set_delete(ps);
  }
}



dk3_socket_set_t *
dk3socket_set_new(
  size_t		 sz,
  int			*ec,
  dk3_app_t		*app
)
{
  dk3_socket_t		*ptr;		/* Current socket to initialize. */
  dk3_socket_set_t	*back = NULL;
  size_t		 i;		/* Index of socket to initialize. */
  if(sz) {
    back = dk3_new_app(dk3_socket_set_t,1,app);
    if(back) {
      back->pData = NULL;
      back->szMax = 0;
      back->szUsed = 0;
      back->pData = dk3_new_app(dk3_socket_t,sz,app);
      if(back->pData) {
        ptr = back->pData;
	for(i = 0; i < sz; i++) { *(ptr++) = INVALID_SOCKET; }
	back->szMax = sz;
      } else {
        dk3_delete(back);
	back = NULL;
      }
    }
  }
  return back;
}



int
dk3socket_check(dk3_socket_t so)
{
  int back = 0;
  if(INVALID_SOCKET != so) {
    back = 1;
  }
  return back;
}



/**	Function names, used for error reporting on non-Windows systems.
*/
static dkChar const * const dk3socket_function_names[] = {
/* 0 */
dkT("socket: "),

/* 1 */
dkT("bind: "),

/* 2 */
dkT("connect: "),

/* 3 */
dkT("listen: "),

/* 4 */
dkT("accept: "),

/* 5 */
dkT("send/sendto:"),

/* 6 */
dkT("recv/recvfrom: "),

/* 7 */
dkT("select: "),

/* 8 */
dkT("close: "),

/* 9 */
dkT("inet_pton: "),

/* 10 */
dkT("getaddrinfo: "),

/* 11 */
dkT("shutdown: "),

/* 12 */
dkT("setsockopt: "),

/* 13 */
dkT(""),

/* 14 */
dkT("fcntl: "),

/* 15 */
dkT(":"),

/* 16 */
dkT("%lu"),

/* 17 */
dkT("."),

/* 18 */
dkT("%x"),

/* 19 */
dkT("%u@"),

NULL


#line 229 "dk3sock4.ctr"
};



void
dk3socket_error_socket(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_SYSTEM; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 279); }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 240 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 244 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEAFNOSUPPORT: {	

#line 248 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAEINPROGRESS: {	

#line 252 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEMFILE: {		

#line 256 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 277); }
    } break;
    case WSAENOBUFS: {		

#line 260 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAEPROTONOSUPPORT: {	

#line 264 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_PROTOCOL_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 278); }
    } break;
    case WSAEPROTOTYPE: {	

#line 268 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ILLEGAL_PROTOCOL_FAMILY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAESOCKTNOSUPPORT: {	

#line 272 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 323); }
    } break;
  }
}



void
dk3socket_error_bind(int *ec, dk3_app_t *app, int err, dkChar const *lat)
{
  if(ec) { *ec = DK3_ERROR_BIND_FAILED; }
  if(app) { dk3app_log_i3(app, DK3_LL_ERROR, 302, 303, lat); }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 287 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 291 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEACCES: {		

#line 295 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 324); }
    } break;
    case WSAEADDRINUSE: {	

#line 299 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 293); }
    } break;
    case WSAEADDRNOTAVAIL: {	

#line 303 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 325); }
    } break;
    case WSAEFAULT: {		

#line 307 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINPROGRESS: {	

#line 310 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINVAL: {		

#line 314 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_BOUND; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 304);}
    } break;
    case WSAENOBUFS: {		

#line 318 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTSOCK: {		

#line 322 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



void
dk3socket_error_connect(int *ec, dk3_app_t *app, int err, dkChar const *str)
{
  if(ec) { *ec = DK3_ERROR_SYSTEM; }
  if(app) {
    if(str) {
      dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, str);
    } else {
      dk3app_log_i1(app, DK3_LL_ERROR, 282);
    }
  }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 342 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 346 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEADDRINUSE: {	

#line 350 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 293); }
    } break;
    case WSAEINTR: {		

#line 354 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 358 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEALREADY: {		

#line 362 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 295); }
    } break;
    case WSAEADDRNOTAVAIL: {	

#line 366 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 325); }
    } break;
    case WSAEAFNOSUPPORT: {	

#line 370 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAECONNREFUSED: {	

#line 374 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_REFUSED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 296); }
    } break;
    case WSAEFAULT: {		

#line 378 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINVAL: {		

#line 381 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEISCONN: {		

#line 384 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 297); }
    } break;
    case WSAENETUNREACH: {	

#line 388 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 298); }
    } break;
    case WSAEHOSTUNREACH: {	

#line 392 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_HOST_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 326); }
    } break;
    case WSAENOBUFS: {		

#line 396 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTSOCK: {		

#line 400 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAETIMEDOUT: {	

#line 403 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
    } break;
    case WSAEWOULDBLOCK: {	

#line 407 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEACCES: {		

#line 410 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 324); }
    } break;
  }
}



void
dk3socket_error_listen(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_LISTEN_FAILED; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 283); }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 425 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 429 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEADDRINUSE: {	

#line 433 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 293); }
    } break;
    case WSAEINPROGRESS: {	

#line 437 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINVAL: {		

#line 441 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEISCONN: {		

#line 444 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 297); }
    } break;
    case WSAEMFILE: {		

#line 448 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 277); }
    } break;
    case WSAENOBUFS: {		

#line 452 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTSOCK: {		

#line 456 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEOPNOTSUPP: {	

#line 459 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



void
dk3socket_error_accept(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_ACCEPT_FAILED; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 317); }
    switch(err) {
      case WSANOTINITIALISED: {	

#line 473 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
      } break;
      case WSAECONNRESET: {	

#line 477 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
      } break;
      case WSAEFAULT: {		

#line 481 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEINTR: {		

#line 484 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
      } break;
      case WSAEINVAL: {		

#line 488 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEINPROGRESS: {	

#line 491 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
      } break;
      case WSAEMFILE: {		

#line 495 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 277); }
      } break;
      case WSAENETDOWN: {	

#line 499 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
      } break;
      case WSAENOBUFS: {	

#line 503 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_MEMORY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
      } break;
      case WSAENOTSOCK: {	

#line 507 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEOPNOTSUPP: {	

#line 510 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEWOULDBLOCK: {	

#line 513 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
    }
}



void
dk3socket_error_send(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_DURING_WRITE; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
  switch(err) {
    case WSANOTINITIALISED: {	

#line 527 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 531 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEACCES: {		

#line 535 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 324); }
    } break;
    case WSAEINTR: {		

#line 539 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 543 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEFAULT: {		

#line 547 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENETRESET: {	

#line 550 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAENOBUFS: {		

#line 554 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTCONN: {		

#line 558 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAENOTSOCK: {		

#line 562 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEOPNOTSUPP: {	

#line 565 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAESHUTDOWN: {	

#line 568 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEWOULDBLOCK: {	

#line 571 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEMSGSIZE: {		

#line 574 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_LARGE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 245); }
    } break;
    case WSAEHOSTUNREACH: {	

#line 578 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_HOST_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 326); }
    } break;
    case WSAEINVAL: {		

#line 582 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAECONNABORTED: {	

#line 585 "dk3sock4.ctr"
        if(ec) { *ec = DK3_ERROR_CONNECTION_ABORTED; }
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 318); }
    } break;
    case WSAECONNRESET: {	

#line 589 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAETIMEDOUT: {	

#line 593 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
    } break;
    case WSAEADDRNOTAVAIL: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 325); }
    } break;
    case WSAEAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAEDESTADDRREQ: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_REQUIRED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 308); }
    } break;
    case WSAENETUNREACH: {
      if(ec) { *ec = DK3_ERROR_NETWORK_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 298); }
    } break;
  }
}



void
dk3socket_error_recv(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_DURING_READ; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 314); }
  switch(err) {
    case WSANOTINITIALISED: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEFAULT: {		

#line 632 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENOTCONN: {		

#line 635 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAEINTR: {		

#line 639 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 643 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAENETRESET: {	

#line 647 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAENOTSOCK: {		

#line 651 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEOPNOTSUPP: {	

#line 654 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAESHUTDOWN: {	

#line 657 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEWOULDBLOCK: {	

#line 660 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEMSGSIZE: {		

#line 663 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_LARGE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 245); }
    } break;
    case WSAEINVAL: {		

#line 667 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEISCONN: {		

#line 670 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 297); }
    } break;
    case WSAECONNABORTED: {	

#line 674 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_ABORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 318); }
    } break;
    case WSAETIMEDOUT: {	

#line 678 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
    } break;
    case WSAECONNRESET: {	

#line 682 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
  }
}



void
dk3socket_error_select(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 336); }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 697 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAEFAULT: {		

#line 701 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 294); }
    } break;
    case WSAENETDOWN: {		

#line 705 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINVAL: {		

#line 709 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINTR: {		

#line 712 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 716 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAENOTSOCK: {		

#line 720 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



void
dk3socket_error_close(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 280); }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 734 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 738 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAENOTSOCK: {		

#line 742 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINPROGRESS: {	

#line 745 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINTR: {		

#line 749 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEWOULDBLOCK: {	

#line 753 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
  }
}



void
dk3socket_error_inet_pton(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 337); }
  switch(err) {
    case WSAEAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAEFAULT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



void
dk3socket_error_gethostbyname(int *ec, dk3_app_t *app, int err, char const *hn)
{
  if(app) {
    if(hn) {
#if DK3_CHAR_SIZE == 1
      dk3app_log_i3(app, DK3_LL_ERROR, 284, 285, hn);
#else
      dk3app_log_i1(app, DK3_LL_ERROR, 286);
#endif
    } else {
      dk3app_log_i1(app, DK3_LL_ERROR, 286);
    }
  }
  if(ec) { *ec = DK3_ERROR_HOST_NOT_FOUND; }
  switch(err) {
    case WSANOTINITIALISED: {	

#line 795 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 799 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAHOST_NOT_FOUND: {	

#line 803 "dk3sock4.ctr"
    } break;
    case WSATRY_AGAIN: {	

#line 805 "dk3sock4.ctr"
    } break;
    case WSANO_RECOVERY: {	

#line 807 "dk3sock4.ctr"
    } break;
    case WSANO_DATA: {		

#line 809 "dk3sock4.ctr"
    } break;
    case WSAEINPROGRESS: {	

#line 811 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEFAULT: {		

#line 815 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINTR: {		

#line 818 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
  }
}



/**	Report error from bringing WinSock up (Windows only).
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	err	Error code from WSAStartUp.
*/
static
void
dk3socket_error_up(int *ec, dk3_app_t *app, int err)
{
  /* ERROR: Failed to bring Windows sockets up. */
  switch(err) {
    case WSASYSNOTREADY: {	

#line 838 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAVERNOTSUPPORTED: {	

#line 842 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_PROTOCOL_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 327); }
    } break;
    case WSAEINPROGRESS: {	

#line 846 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEPROCLIM: {		

#line 850 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 328); }
    } break;
    case WSAEFAULT: {		

#line 854 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



/**	Report error from bringing WinSock down (Windows only).
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	err	Error code from WSAStartUp.
*/
static
void
dk3socket_error_down(int *ec, dk3_app_t *app, int err)
{
  /* ERROR: Failed to bring Winsock subsystem down! */
  switch(err) {
    case WSANOTINITIALISED: {	

#line 873 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 877 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINPROGRESS: {	

#line 881 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
  }
}



void
dk3socket_error_shutdown(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 315); }
  switch(err) {
    case WSANOTINITIALISED: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINPROGRESS: {
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAENOTCONN: {
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



void
dk3socket_error_setsockopt(int *ec, dk3_app_t *app, int err)
{
  

#line 926 "dk3sock4.ctr"
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 339); }
  switch(err) {
    case WSANOTINITIALISED: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINPROGRESS: {
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENETRESET: {
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAENOPROTOOPT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENOTCONN: {
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
  

#line 960 "dk3sock4.ctr"
}



void
dk3socket_ip4addr_set_localhost(struct sockaddr_in *sp)
{
  if(sp) {
    dk3mem_res((void *)sp, sizeof(struct sockaddr_in));
    sp->sin_family = AF_INET;
    (sp->sin_addr).s_addr = htonl(0x7F000001UL);
  }
}



int
dk3socket_ip4addr_to_text(dkChar *dp, size_t szdp, IN_ADDR *ia4)
{
#if VERSION_BEFORE_20140716
  dkChar		bu[32];
  unsigned long		ul;
  int			back = 0;
  if((dp) && (szdp >= 16) && (ia4)) {
    ul = ntohl(ia4->s_addr);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul >> 24) & 0x000000FFUL));
    dk3str_cpy_not_overlapped(dp, bu);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul >> 16) & 0x000000FFUL));
    dk3str_cat(dp, dk3socket_function_names[17]);
    dk3str_cat(dp, bu);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul >>  8) & 0x000000FFUL));
    dk3str_cat(dp, dk3socket_function_names[17]);
    dk3str_cat(dp, bu);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul      ) & 0x000000FFUL));
    dk3str_cat(dp, dk3socket_function_names[17]);
    dk3str_cat(dp, bu);
    back = 1;
  }
  return back;
#else
  dkChar		 bu1[32];
  dkChar		 bu2[32];
  dkChar		 bu3[32];
  dkChar		 bu4[32];
  size_t		 sz;
  unsigned long		 ul;
  int			 back = 0;
  if ((NULL != dp) && (16 <= szdp) && (ia4)) {
    ul = ntohl(ia4->s_addr);
    back = dk3ma_um_to_string(
      bu1, DK3_SIZEOF(bu1,dkChar), (dk3_um_t)((ul >> 24) & 0x000000FFUL)
    );
    if (0 != back) {
      back = dk3ma_um_to_string(
        bu2, DK3_SIZEOF(bu2,dkChar), (dk3_um_t)((ul >> 16) & 0x000000FFUL)
      );
      if (0 != back) {
        back = dk3ma_um_to_string(
	  bu3, DK3_SIZEOF(bu3,dkChar), (dk3_um_t)((ul >> 8) & 0x000000FFUL)
	);
	if (0 != back) {
	  back = dk3ma_um_to_string(
	    bu4, DK3_SIZEOF(bu4,dkChar), (dk3_um_t)(ul & 0x000000FFUL)
	  );
	  if (0 != back) {
	    back = 0;
	    sz = dk3str_len(bu1) + dk3str_len(bu2) + dk3str_len(bu3)
	         + dk3str_len(bu4) + 4;
	    if (sz < szdp) {
	      back = 1;
	      dk3str_cpy_not_overlapped(dp, bu1);
	      dk3str_cat(dp, dk3socket_function_names[17]);
	      dk3str_cat(dp, bu2);
	      dk3str_cat(dp, dk3socket_function_names[17]);
	      dk3str_cat(dp, bu3);
	      dk3str_cat(dp, dk3socket_function_names[17]);
	      dk3str_cat(dp, bu4);
	    }
	  }
	}
      }
    }
  }
  return back;
#endif
}


int
dk3socket_ipaddr_to_text(dkChar *dp, size_t szdp, void *ia, size_t sz)
{
  dkChar		 mybu[64];
  struct sockaddr	*soa;
  struct sockaddr_in	*so4;
  dkChar		*ptr;
  size_t		 sl;
  unsigned		 u;
  int			 back = 0;
  

#line 1059 "dk3sock4.ctr"
  if((dp) && (szdp) && (ia) && (sz)) {		

#line 1060 "dk3sock4.ctr"
    soa = (struct sockaddr *)ia;
    if((AF_INET == soa->sa_family) && (sz == sizeof(struct sockaddr_in))) {
      so4 = (struct sockaddr_in *)ia;		

#line 1063 "dk3sock4.ctr"
      u = (unsigned)(ntohs(so4->sin_port));
#if VERSION_BEFORE_20140716
      dk3sf_sprintf3(mybu, dk3socket_function_names[19], u);
      if((1 + dk3str_len(mybu)) < szdp) {
        dk3str_cpy_not_overlapped(dp, mybu);
        ptr = dp; while(*ptr) { ptr++; }
        sl = dk3str_len(dp);
        back = dk3socket_ip4addr_to_text(ptr, (szdp - sl), &(so4->sin_addr));
      }
#else
      if (0 != dk3ma_um_to_string(mybu, DK3_SIZEOF(mybu,dkChar), (dk3_um_t)u)) {
        if ((2 + dk3str_len(mybu)) < szdp) {
	  dk3str_cpy_not_overlapped(dp, mybu);
	  ptr = dp; while(*ptr) { ptr++; }
	  *(ptr++) = dkT('@');
	  *ptr = dkT('\0');
	  sl = dk3str_len(dp);
	  back = dk3socket_ip4addr_to_text(ptr, (szdp - sl), &(so4->sin_addr));
	}
      }
#endif
    } else {
    }
  } 

#line 1087 "dk3sock4.ctr"
  return back;
}



/**	Report success from listen().
	@param	app	Application structure for diagnostics.
	@param	so	Socket.
	@param	addr	Local address we are listening on.
	@param	szaddr	Address size.
*/
static
void
dk3socket_report_listen_success(
  dk3_app_t	*app,
  dk3_socket_t	 so,
  void		*addr,
  size_t	 szaddr
)
{
  dkChar	 bu[128];
  dkChar	 sb[128];
  int		 convres;	/* Address conversion result. */
  if(app) {
    if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
      convres = dk3socket_ipaddr_to_text(
        bu, DK3_SIZEOF(bu,dkChar), addr, szaddr
      );
      if(convres) {
#if VERSION_BEFORE_20140716
        dk3sf_sprintf3(sb,dkT("%d"),((int)so));
	dk3app_log_i5(app, DK3_LL_PROGRESS, 372, 373, 374, sb, bu);
#else
	convres = dk3ma_im_to_string(
	  sb, DK3_SIZEOF(sb,dkChar), (dk3_im_t)so
	);
	if (0 != convres) {
	  dk3app_log_i5(app, DK3_LL_PROGRESS, 372, 373, 374, sb, bu);
	}
#endif
      }
    }
  }
}



/**	Report success from connect().
	@param	app	Application structure for diagnostics.
	@param	so	Socket.
	@param	addr	Local address we are listening on.
	@param	szaddr	Address size.
*/
static
void
dk3socket_report_connect_success(
  dk3_app_t	*app,
  dk3_socket_t	 so,
  void		*addr,
  size_t	 szaddr
)
{
  dkChar	 bu[128];
  dkChar	 sb[128];
  int		 convres;	/* Address conversion result. */
  if(app) {
    if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
      convres = dk3socket_ipaddr_to_text(
        bu, DK3_SIZEOF(bu,dkChar), addr, szaddr
      );
      if(convres) {
#if VERSION_BEFORE_20140716
        dk3sf_sprintf3(sb,dkT("%d"),((int)so));
	dk3app_log_i5(app, DK3_LL_PROGRESS, 375, 376, 377, sb, bu);
#else
	convres = dk3ma_im_to_string(
	  sb, DK3_SIZEOF(sb,dkChar), (dk3_im_t)so
	);
	if (0 != convres) {
	  dk3app_log_i5(app, DK3_LL_PROGRESS, 375, 376, 377, sb, bu);
	}
#endif
      }
    }
  }
}



dk3_socket_t
dk3socket_open(
  int		 af,
  int		 tp,
  int		 pr,
  int		*ec,
  dk3_app_t	*app
)
{
  dk3_socket_t		 back;
  int			 err;	/* Error code. */
  

#line 1188 "dk3sock4.ctr"
  back = socket(af, tp, pr);
  if(INVALID_SOCKET == back) {
    err = dk3socket_error(errno);
    dk3socket_error_socket(ec, app, err);
  } 

#line 1193 "dk3sock4.ctr"
  return back;
}



int
dk3socket_bind(
  dk3_socket_t		 sock,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  int			*ec,
  dk3_app_t		*app
)
{
  dkChar		 bu[64];	/* Port number buffer. */
  dkChar		*ptr;
  dkChar		*lat;	/* Local address text. */
  int			 res;	/* Result from bind(). */
  int			 err;	/* Error code. */
  int			 back = 0;
  int			 conr = 0;
  

#line 1215 "dk3sock4.ctr"
  if((INVALID_SOCKET != sock) && (pAddr) && (szAddr)) {
    res = bind(sock, pAddr, (int)szAddr);
    if(0 == res) {
      back = 1;
    } else {
      err = dk3socket_error(errno);
      lat = NULL;
      switch(pAddr->sa_family) {
	case AF_INET: {
	  struct sockaddr_in	*soin;
	  unsigned u;
	  soin = (struct sockaddr_in *)pAddr;
	  u = (unsigned)(ntohs(soin->sin_port));
#if VERSION_BEFORE_20140716
	  dk3sf_sprintf3(bu,dk3socket_function_names[19], u);
#else
	  dk3ma_um_to_string(bu, DK3_SIZEOF(bu,dkChar), (dk3_um_t)u);
#endif
	  ptr = bu;
	  while(*ptr) { ptr++; }
	  *(ptr++) = dkT('@');
	  *ptr = dkT('\0');
	  dk3socket_ip4addr_to_text(
	    ptr,
	    (DK3_SIZEOF(bu,dkChar) - dk3str_len(bu)),
	    &(soin->sin_addr)
	  );
	  lat = bu;
	} break;
      }
      dk3socket_error_bind(ec, app, err, lat);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1250 "dk3sock4.ctr"
  return back;
}



static
void
dk3socket_error_ioctlsocket_fionbio(
  int		*ec,
  dk3_app_t	*app,
  int		 err
)
{
    if(ec) { *ec = DK3_ERROR_SYSTEM; }
    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 339); }
    switch(err) {
      case WSANOTINITIALISED: {
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
      } break;
      case WSAENETDOWN: {
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
      } break;
      case WSAEINPROGRESS: {
        if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
      } break;
      case WSAENOTSOCK: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEFAULT: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
    }
}



/**	Connect with timeout on Windows system.
	@param	so	Socket to connect.
	@param	pAddr	Pointer to address.
	@param	szaddr	Address size.
	@param	secs	Seconds for timeout.
	@param	usecs	Microseconds for timeout.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
static
int
dk3socket_connect_windows_timeout(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  int			 szaddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str
)
{
  fd_set	 	 wfds;			/* File descriptor set. */
  struct timeval	 to;			/* Timeout. */
  int			 res;			/* Operation result. */
  int			 err;			/* Error code. */
  int			 back = 0;
  res = connect(so, pAddr, szaddr);
  if(0 == res) {
    back = 1;
  } else {
    err = dk3socket_error(errno);
    switch(err) {
      /*	##### CHECK WHETHER ERROR CODE IS CORRECT!
      */
      case WSAEINPROGRESS: {
        /*	Still connecting, use select to wait.
	*/
	FD_ZERO(&wfds);
	FD_SET(so, &wfds);
	to.tv_sec = secs;
	to.tv_usec = usecs;
	res = select(((int)so + 1), NULL, &wfds, NULL, &to);
	if(SOCKET_ERROR != res) {
	  if(FD_ISSET(so, &wfds)) {
	    back = 1;
	  } else {
	    /* Timeout. */
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(res == 0) {
	    /*	Timeout.  */
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  } else {
	    /* Error in select. */
	    if(ec) { *ec = DK3_ERROR_SYSTEM; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	}
      } break;
      default: {
        /*	failed to connect.
	*/
	dk3socket_error_connect(ec, app, err, str);
      } break;
    }
  }
  return back;
}



int
dk3socket_connect_spnb(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str,
  int			 spnb,
  int			 nb
)
{
  int		 	res;			/* Operation result. */
  int		 	err;			/* Error code. */
  int		 	back = 0;
  

#line 1386 "dk3sock4.ctr"
  if((INVALID_SOCKET != so) && (pAddr) && (szAddr)) {
    if((secs) || (usecs)) {		

#line 1388 "dk3sock4.ctr"
      if(spnb) {			

#line 1389 "dk3sock4.ctr"
        if(nb) {				

#line 1390 "dk3sock4.ctr"
          /* Now attempt to connect */
	  back = dk3socket_connect_windows_timeout(
	    so, pAddr, (int)szaddr, secs, usecs, ec, app, str
	  );
        } else {
          unsigned long		xv;	

#line 1396 "dk3sock4.ctr"
	  xv = 0x01010101UL;
	  if(0 == ioctlsocket(so, FIONBIO, &xv)) {
	    /* Now attempt to connect */
	    back = dk3socket_connect_windows_timeout(
	      so, pAddr, (int)szaddr, secs, usecs, ec, app, str
	    );
	    xv = 0UL;
	    if(0 != ioctlsocket(so, FIONBIO, &xv)) {	

#line 1404 "dk3sock4.ctr"
	      err = WSAGetLastError();
	      dk3socket_error_ioctlsocket_fionbio(ec, app, err);
	      back = 0;
	    }
	  } else {			

#line 1409 "dk3sock4.ctr"
	    err = WSAGetLastError();
	    dk3socket_error_ioctlsocket_fionbio(ec, app, err);
	  }
        }
      } else {				

#line 1414 "dk3sock4.ctr"
        res = connect(so, pAddr, (int)szAddr);
        if(0 == res) {
          back = 1;
        } else {
          err = dk3socket_error(errno);
	  dk3socket_error_connect(ec, app, err, str);
        }
      }
    } else {					

#line 1423 "dk3sock4.ctr"
      res = connect(so, pAddr, (int)szAddr);
      if(0 == res) {
        back = 1;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_connect(ec, app, err, str);
      }
    }
    if(back) {
      dk3socket_report_connect_success(app, so, (void *)pAddr, szAddr);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1437 "dk3sock4.ctr"
  return back;
}



int
dk3socket_connect_nb(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str,
  int			 nb
)
{
  int back;
  back = dk3socket_connect_spnb(
    so, pAddr, szAddr, secs, usecs, ec, app, str, 1, nb
  );
  return back;
}



int
dk3socket_connect(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str
)
{
  int		back;
  back = dk3socket_connect_spnb(
    so, pAddr, szAddr, secs, usecs, ec, app, str, 0, 0
  );
  return back;
}



int
dk3socket_listen(
  dk3_socket_t	 so,
  int		 bl,
  int		*ec,
  dk3_app_t	*app
)
{
  int back = 0;
  int res;		/* Operation result. */
  int err;		/* Error code. */
  

#line 1497 "dk3sock4.ctr"
  if(INVALID_SOCKET != so) {
    res = listen(so, bl);
    if(0 == res) {
      back = 1;
    } else {
      err = dk3socket_error(errno);
      dk3socket_error_listen(ec, app, err);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1508 "dk3sock4.ctr"
  return back;
}



dk3_socket_t
dk3socket_accept(
  dk3_socket_t		 ls,
  struct sockaddr	*pAddr,
  size_t		*pSzAddr,
  int			*ec,
  dk3_app_t		*app
)
{
  int			addrsize = 0;
  dk3_socket_t		back = INVALID_SOCKET;
  int			err;
  if((pAddr) && (pSzAddr)) {
    if(pSzAddr) { addrsize = (int)(*pSzAddr); }
  }
  if(INVALID_SOCKET != ls) {
    back = accept(ls, pAddr, ((pAddr) ? &addrsize : NULL));
    if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)addrsize; }
    if(INVALID_SOCKET == back) {
      err = dk3socket_error(errno);
      dk3socket_error_accept(ec, app, err);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



/**	Send data. This is a wrapper around the send() function from the
	BSD sockets API.
	@param	so	Socket.
	@param	bu	Buffer pointer.
	@param	sz	Buffer size in bytes.
	@param	secs	Timeout seconds.
	@param	usecs	Timeout microseconds.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Number of bytes sent.
*/
static
int
dk3socket_send_attempt(
  dk3_socket_t	 so,
  void const	*bu,
  size_t	 sz,
  long		 secs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
  int		 back = -1;
  int		 err;				/* Error code. */
  int		 res;				/* Operation result. */
  fd_set	 wfds;				/* File descriptor set. */
  struct timeval to;				/* Timeout. */
  int		 selres;			/* Result from select(). */
  

#line 1573 "dk3sock4.ctr"
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
      FD_ZERO(&wfds);
      FD_SET(so, &wfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), NULL, &wfds, NULL, &to);
      if(selres != SOCKET_ERROR)
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&wfds)) {
            res = send(so, bu, (int)sz, 0);
            if(res >= 0) {
	      back = res;
	      if((size_t)res < sz) {
                if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	        if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	      }
            } else {
	      err = dk3socket_error(errno);
              dk3socket_error_send(ec, app, err);
            }
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
    } else {
      res = send(so, bu, (int)sz, 0);
      if(res >= 0) {
        back = res;
	if((size_t)res < sz) {
          if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	  if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	}
      } else {
        err = dk3socket_error(errno);
        dk3socket_error_send(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1625 "dk3sock4.ctr"
  return back;
}



int
dk3socket_send(
  dk3_socket_t	 so,
  void const	*bu,
  size_t	 sz,
  long		 secs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
  char const	*ptr;
  int		 back = 0;
  int		 res;
  

#line 1645 "dk3sock4.ctr"
  ptr = (char const *)bu;
  do {
    res = dk3socket_send_attempt(so,(void const *)ptr,sz,secs,usecs,ec,app);
    if(-1 < res) {
      back += res;
      ptr = &(ptr[res]);
    }
  } while((back < (int)sz) && (-1 < res));
  

#line 1654 "dk3sock4.ctr"
  return back;
}



int
dk3socket_recv(
  dk3_socket_t	 so,
  void		*bu,
  size_t	 sz,
  long		 secs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
  fd_set		rfds;			/* File descriptor set. */
  struct timeval	to;			/* Timeout. */
  int			selres;			/* Result from select(). */
  int			res;			/* Operation result. */
  int			err;			/* Error code. */
  int			back = -1;
  

#line 1677 "dk3sock4.ctr"
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
      FD_ZERO(&rfds);
      FD_SET(so,&rfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), &rfds, NULL, NULL, &to);
      if(selres != SOCKET_ERROR)
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&rfds)) {
            res = recv(so, bu, (int)sz, 0);
            if(res >= 0) {
              back = res;
            } else {
              err = dk3socket_error(errno);
	      dk3socket_error_recv(ec, app, err);
            }
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      }
      else
      {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
    } else {
      res = recv(so, bu, (int)sz, 0);
      if(res >= 0) {
        back = res;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_recv(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1723 "dk3sock4.ctr"
  return back;
}



int
dk3socket_sendto(
  dk3_socket_t		 so,
  void			*bu,
  size_t		 sz,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  int		 back = -1;
  int		 err;				/* Error code. */
  int		 res;				/* Operation result. */
  fd_set	 wfds;				/* File descriptor set. */
  struct timeval to;				/* Timeout. */
  int		 selres;			/* Result from select(). */
  int		 myszaddr;
  

#line 1749 "dk3sock4.ctr"
  myszaddr = (int)szAddr;
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
      FD_ZERO(&wfds);
      FD_SET(so, &wfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), NULL, &wfds, NULL, &to);
      if(selres != SOCKET_ERROR)
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&wfds)) {
            res = sendto(so, bu, (int)sz, 0, pAddr, myszaddr);
            if(res >= 0) {
	      back = res;
	      if((size_t)res < sz) {
                if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	        if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	      }
            } else {
	      err = dk3socket_error(errno);
              dk3socket_error_send(ec, app, err);
            }
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
    } else {
      res = sendto(so, bu, (int)sz, 0, pAddr, myszaddr);
      if(res >= 0) {
        back = res;
	if((size_t)res < sz) {
          if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	  if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	}
      } else {
        err = dk3socket_error(errno);
        dk3socket_error_send(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1802 "dk3sock4.ctr"
  return back;
}



int
dk3socket_recvfrom(
  dk3_socket_t		 so,
  void			*bu,
  size_t		 sz,
  struct sockaddr	*pAddr,
  size_t		*pSzAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  fd_set		rfds;			/* File descriptor set. */
  struct timeval	to;			/* Timeout. */
  int			selres;			/* Result from select(). */
  int			res;			/* Operation result. */
  int			err;			/* Error code. */
  int			back = -1;
  int			myszaddr = 0;
  

#line 1828 "dk3sock4.ctr"
  if((pAddr) && (pSzAddr)) { myszaddr = (int)(*pSzAddr); }
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
      FD_ZERO(&rfds);
      FD_SET(so,&rfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), &rfds, NULL, NULL, &to);
      if(selres != SOCKET_ERROR)
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&rfds)) {
            res = recvfrom(so,bu,(int)sz,0,pAddr,((pAddr) ? &myszaddr : NULL));
	    if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)myszaddr; }
            if(res >= 0) {
              back = res;
            } else {
              err = dk3socket_error(errno);
	      dk3socket_error_recv(ec, app, err);
            }
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      }
      else
      {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
    } else {
      res = recvfrom(so, bu, (int)sz, 0, pAddr, ((pAddr) ? &myszaddr : NULL));
      if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)myszaddr; }
      if(res >= 0) {
        back = res;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_recv(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1877 "dk3sock4.ctr"
  return back;
}



int
dk3socket_close(
  dk3_socket_t	 so,
  int		*ec,
  dk3_app_t	*app
)
{
  int	res;		/* Operation result. */
  int	err;		/* Error code. */
  int	back = 0;
  

#line 1893 "dk3sock4.ctr"
  if(INVALID_SOCKET != so) {
    res = closesocket(so);
    if(0 == res) {
      back = 1;
    } else {
      /* ERROR: Failed to close socket! */
      err = dk3socket_error(errno);
      dk3socket_error_close(ec, app, err);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1905 "dk3sock4.ctr"
  return back;
}



dk3_socket_t
dk3socket_invalid(void)
{
  return INVALID_SOCKET;
}



int
dk3socket_up(int *ec, dk3_app_t *app)
{
  int		back = 0;
  int		err;			/* Error code. */
  WORD		wVersionRequested;	/* Requested Winsock version. */
  WSADATA	wsaData;		/* Result data. */
  

#line 1926 "dk3sock4.ctr"
  wVersionRequested = MAKEWORD(2,0);
  err = WSAStartup(wVersionRequested, &wsaData);
  if(0 == err) {
    back = 1;
  } else {
    dk3socket_error_up(ec, app, err);
  } 

#line 1933 "dk3sock4.ctr"
  return back;
}



int
dk3socket_down(int *ec, dk3_app_t *app)
{
  int		back	= 0;
  

#line 1943 "dk3sock4.ctr"
  if(0 == WSACleanup()) {
    back = 1;
  } else {
    dk3socket_error_down(ec, app, WSAGetLastError());
  } 

#line 1948 "dk3sock4.ctr"
  return back;
}



int
dk3socket_inet_pton(int af, char const *hn, void *addr, int *ec, dk3_app_t *app)
{
  int		back = 0;
  int		res;		/* Result from inet_pton(). */
  

#line 1959 "dk3sock4.ctr"
#if DK3_ON_WINDOWS
  

#line 1961 "dk3sock4.ctr"
  res = InetPtonA(af, hn, addr);
  switch(res) {
    case 1: {
      back = 1;
    } break;
    case 0: {
      /* ERROR: Not an IP address! */
    } break;
    case -1: {
      dk3socket_error_inet_pton(ec, app, WSAGetLastError());
    } break;
  }
#else
  

#line 1975 "dk3sock4.ctr"
#if DK3_HAVE_INET_PTON
  

#line 1977 "dk3sock4.ctr"
  res = inet_pton(af, hn, addr);
  switch(res) {
    case 1: {			

#line 1980 "dk3sock4.ctr"
      back = 1;
    } break;
    case 0: {			

#line 1983 "dk3sock4.ctr"
      /* ERROR: Not an IP address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) {
#if DK3_CHAR_SIZE == 1
        dk3app_log_i3(app, DK3_LL_ERROR, 348, 349, hn);
#else
        dk3app_log_i1(app, DK3_LL_ERROR, 350);
#endif
      }
    } break;
    case -1: {			

#line 1994 "dk3sock4.ctr"
      dk3socket_error_inet_pton(ec, app, errno);
    } break;
  }
#else
  

#line 1999 "dk3sock4.ctr"
#if DK3_HAVE_INET_ATON
  

#line 2001 "dk3sock4.ctr"
  if(AF_INET == af) {		

#line 2002 "dk3sock4.ctr"
    res = inet_aton(hn, (IN_ADDR *)addr);
    if(res) {			

#line 2004 "dk3sock4.ctr"
      back = 1;
    } else {			

#line 2006 "dk3sock4.ctr"
      /* ERROR: Not an IPv4 address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) {
#if DK3_CHAR_SIZE == 1
        dk3app_log_i3(app, DK3_LL_ERROR, 348, 349, hn);
#else
        dk3app_log_i1(app, DK3_LL_ERROR, 350);
#endif
      }
    }
  } else {
#ifdef EAFNOSUPPORT
    dk3socket_error_inet_pton(ec, app, EAFNOSUPPORT);
#endif
  }
#else
  

#line 2023 "dk3sock4.ctr"
  if(AF_INET == af) {
    if(dk3enc_c8_ipaddr_to_ul_app(hn, (unsigned long *)addr, app))
    {				

#line 2026 "dk3sock4.ctr"
      back = 1;
    } else {			

#line 2028 "dk3sock4.ctr"
      /* ERROR: Not an IPv4 address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    }
  } else {
#ifdef EAFNOSUPPORT
    dk3socket_error_inet_pton(ec, app, EAFNOSUPPORT);
#endif
  }
#endif
#endif
#endif
  

#line 2040 "dk3sock4.ctr"
  return back;
}



int
dk3socket_set_reuse(dk3_socket_t so, int v, int *ec, dk3_app_t *app)
{
  int			 back = 0;
  int			 err;
  

#line 2051 "dk3sock4.ctr"
  if(INVALID_SOCKET != so) {
#if DK3_HAVE_SETSOCKOPT && defined(SO_REUSEADDR)
    int		opt;
#if DK3_SIZEOF_INT > 2
#if DK3_SIZEOF_INT > 4
    opt = ((v) ? 0x0101010101010101 : 0);
#else
    opt = ((v) ? 0x01010101 : 0);
#endif
#else
    opt = ((v) ? 0x0101 : 0);
#endif
    if(0 == setsockopt(so,SOL_SOCKET,SO_REUSEADDR,(void *)(&opt),sizeof(opt)))
    { 

#line 2065 "dk3sock4.ctr"
#ifdef SO_REUSEPORT
      if(0 == setsockopt(so,SOL_SOCKET,SO_REUSEPORT,(void *)(&opt),sizeof(opt)))
      { 

#line 2068 "dk3sock4.ctr"
        back = 1;	

#line 2069 "dk3sock4.ctr"
      }
      else
      { 

#line 2072 "dk3sock4.ctr"
        /* ERROR: setsockopt failed! */
	err = dk3socket_error(errno);
	dk3socket_error_setsockopt(ec, app, err);
      }
#else
      back = 1;		

#line 2078 "dk3sock4.ctr"
#endif
    }
    else
    { 

#line 2082 "dk3sock4.ctr"
      /* ERROR: setsockopt failed! */
      err = dk3socket_error(errno);
      dk3socket_error_setsockopt(ec, app, err);
    }
#else
    /* ERROR: SO_REUSEADDR NOT DEFINED */
    

#line 2089 "dk3sock4.ctr"
#endif
  } else {				

#line 2091 "dk3sock4.ctr"
    /* ERROR: Not a valid socket! */
  } 

#line 2093 "dk3sock4.ctr"
  return back;
}



int
dk3socket_shutdown(dk3_socket_t so, int sv, int *ec, dk3_app_t *app)
{
  int			 back = 0;
  int			 err = 0;	/* Error code. */
  if(INVALID_SOCKET != so) {
    switch(sv) {
      case DK3_TCPIP_SHUTDOWN_READ: {
	if(0 == shutdown(so, SD_RECEIVE)) {
	  back = 1;
	} else {
	  err = WSAGetLastError();
	  dk3socket_error_shutdown(ec, app, err);
	}
      } break;
      case DK3_TCPIP_SHUTDOWN_WRITE: {
	if(0 == shutdown(so, SD_SEND)) {
	  back = 1;
	} else {
	  err = WSAGetLastError();
	  dk3socket_error_shutdown(ec, app, err);
	}
      } break;
      case DK3_TCPIP_SHUTDOWN_RW: {
	if(0 == shutdown(so, SD_BOTH)) {
	  back = 1;
	} else {
	  err = WSAGetLastError();
	  dk3socket_error_shutdown(ec, app, err);
	}
      } break;
      default: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3socket_set_non_block(dk3_socket_t so, int v, int *ec, dk3_app_t *app)
{
  int back = 0;
  int err;
  if(INVALID_SOCKET != so) {
  unsigned long xv;
  if(v) { xv = 0x01010101UL; } else { xv = 0UL; };
  if(0 == ioctlsocket(so, FIONBIO, &xv)) {
    back = 1;
  } else {
    err = WSAGetLastError();
    dk3socket_error_ioctlsocket_fionbio(ec, app, err);
  }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3socket_get_non_block(dk3_socket_t so, int *ec, dk3_app_t *app)
{
  int back = -1;
  if(INVALID_SOCKET != so) {
  /* ERROR: No function implemented! */
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 353); }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



/*
	Section start: gethostbyname().
*/

dk3_socket_t
dk3socket_open_net_stream_client(
  char const		*sh,
  unsigned short	 sp,
  unsigned short	 lp,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  struct sockaddr_in	 sl4;		/* Local IPv4 address. */
  struct sockaddr_in	 sr4;		/* Remote IPv4 address. */
  IN_ADDR		 in4;		/* IPv4 address. */
  struct hostent	*he;		/* Result from gethostbyname(). */
  char		       **addrptr;	/* Address pointer. */
  dk3_socket_t		 back = INVALID_SOCKET;
  int			 resgai;	/* Result from getaddrinfo(). */
  int			 connres;	/* Result from bind()/connect(). */
  int			 err;		/* Error code from gethostbyname(). */
  

#line 2203 "dk3sock4.ctr"
  if(sp) {
    if(sh) {					

#line 2205 "dk3sock4.ctr"
      /*
      	Attempt IPv4 address.
      */
      resgai = dk3socket_inet_pton(AF_INET, sh, &in4, NULL, NULL);
      if(1 == resgai) {
        back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
	if(INVALID_SOCKET != back) {
	  if(lp) {
	    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
            dk3mem_res((void *)(&sl4), sizeof(struct sockaddr_in));
	    sl4.sin_family = AF_INET;
	    sl4.sin_port = htons(lp);
	    sl4.sin_addr.s_addr = INADDR_ANY;
	    connres = dk3socket_bind(
	      back,
	      (struct sockaddr *)(&sl4), sizeof(sl4),
	      NULL, NULL
	    );
	    if(!(connres)) {
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	    }
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3mem_res((void *)(&sr4), sizeof(sr4));
	  sr4.sin_family = AF_INET;
	  sr4.sin_port = htons(sp);
	  dk3mem_cpy(
	    (void *)(&(sr4.sin_addr)),
	    (void *)(&in4),
	    sizeof(IN_ADDR)
	  );
	  connres = dk3socket_connect_nb(
	    back,
	    (struct sockaddr *)(&sr4), sizeof(sr4),
	    secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	    sh,
#else
	    NULL,
#endif
	    0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      /*
      	Host name resolution.
      */
      if(INVALID_SOCKET == back) {
        he = gethostbyname(sh);
	if(he) {				

#line 2261 "dk3sock4.ctr"
	  if(AF_INET == he->h_addrtype) {
	    if(4 == he->h_length) {
	      if(he->h_addr_list) {
	        addrptr = he->h_addr_list;
		while((INVALID_SOCKET == back) && (*addrptr)) {
		  back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
		  if(INVALID_SOCKET != back) {
		    if(lp) {
		      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
		      dk3mem_res((void *)(&sl4), sizeof(struct sockaddr_in));
		      sl4.sin_family = AF_INET;
		      sl4.sin_port = htons(lp);
		      sl4.sin_addr.s_addr = INADDR_ANY;
		      connres = dk3socket_bind(
		        back,
			(struct sockaddr *)(&sl4), sizeof(struct sockaddr_in),
			NULL, NULL
		      );
		      if(!(connres)) {
		        dk3socket_close(back, NULL, NULL);
			back = INVALID_SOCKET;
		      }
		    }
		  }
		  if(INVALID_SOCKET != back) {
		    dk3mem_res((void *)(&sr4), sizeof(struct sockaddr_in));
		    sr4.sin_family = AF_INET;
		    sr4.sin_port = htons(sp);
		    dk3mem_cpy(
		      (void *)(&(sr4.sin_addr)),
		      (void *)(*addrptr),
		      sizeof(IN_ADDR)
		    );
		    connres = dk3socket_connect_nb(
		      back,
		      (struct sockaddr *)(&sr4), sizeof(struct sockaddr_in),
		      secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
		      sh,
#else
		      NULL,
#endif
		      0
		    );
		    if(!(connres)) {
		      dk3socket_close(back, NULL, NULL);
		      back = INVALID_SOCKET;
		    }
		  }
		  addrptr++;
		}
	      } else {
	        /* ERROR: No address list! */
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
	      }
	    } else {
	      /* ERROR: Wrong address length */
	      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
	    }
	  } else {
	  }
	} else {
	  /* ERROR: Host not found! */
	  err = dk3socket_error(h_errno);
	  dk3socket_error_gethostbyname(ec, app, err, sh);
	}
      }
    } else {					

#line 2329 "dk3sock4.ctr"
      /*
      	Test IPv4 localhost
      */
      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
      if(INVALID_SOCKET != back) {
        if(lp) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip4addr_set_localhost(&sl4);
	  sl4.sin_port = htons(lp);
	  connres = dk3socket_bind(
	    back, (struct sockaddr *)(&sl4), sizeof(struct sockaddr_in),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      if(INVALID_SOCKET != back) {
        dk3socket_ip4addr_set_localhost(&sr4);
	sr4.sin_port = htons(sp);
	connres = dk3socket_connect_nb(
	  back, (struct sockaddr *)(&sr4), sizeof(sr4),
	  secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	  sh,
#else
	  NULL,
#endif
	  0
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
    }
    if(INVALID_SOCKET == back) {
      if(sh) {
        if(app) {
#if DK3_CHAR_SIZE == 1
	  dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, sh);
#else
	  dk3app_log_i1(app, DK3_LL_ERROR, 282);
#endif
	}
      } else {
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 2383 "dk3sock4.ctr"
  return back;
}



dk3_socket_set_t *
dk3socket_listeners(
  unsigned short	 portno,
  int			 backlog,
  int			 fLocalOnly,
  int			*ec,
  dk3_app_t		*app
)
{
  struct sockaddr_in	 ip4;		/* Local IPv4 address. */
  dk3_socket_t		*sp;		/* Pointer to current socket to init. */
  dk3_socket_set_t	*back = NULL;
  size_t		 szmax;		/* Number of sockets in set. */
  size_t		 na;		/* Number of used sockets in set. */
  dk3_socket_t		 so;		/* Socket to create. */
  

#line 2404 "dk3sock4.ctr"
  if((portno) && (portno > 0)) {
    szmax = 1;
    back = dk3socket_set_new(szmax, ec, app);
    if(back) {
      sp = back->pData;
      na = 0;
      /*
      	Attempt to bind IPv4 address.
      */
      dk3mem_res((void *)(&ip4), sizeof(struct sockaddr_in));
      if(fLocalOnly) {
        dk3socket_ip4addr_set_localhost(&ip4);
      } else {
        ip4.sin_family = AF_INET;
	ip4.sin_addr.s_addr = INADDR_ANY;
      }
      ip4.sin_port = htons(portno);
      so = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
      if(INVALID_SOCKET != so) {
        if(dk3socket_bind(
	     so, (struct sockaddr *)(&ip4), sizeof(struct sockaddr_in), ec, app
	   )
	)
	{
	  if(dk3socket_listen(so, backlog, ec, app)) {
	    *(sp++) = so;
	    na++;
	    dk3socket_report_listen_success(
	      app, so, &ip4, sizeof(struct sockaddr_in)
	    );
	  } else {
	    dk3socket_close(so, ec, app);
	  }
	}
	else
	{
	  dk3socket_close(so, ec, app);
	}
      }
      /*
      	If no address was bound, close the set.
      */
      if(na) {
        back->szUsed  = na;
      } else {
        dk3socket_set_close(back, ec, app);
	back = NULL;
      } 

#line 2452 "dk3sock4.ctr"
    }
  } 

#line 2454 "dk3sock4.ctr"
  return back;
}



dk3_socket_set_t *
dk3socket_datagram_sockets(
  unsigned short	 portno,
  int			 fLocalOnly,
  int			*ec,
  dk3_app_t		*app
)
{
  struct sockaddr_in	 ip4;		/* Local IPv4 address. */
  dk3_socket_t		*sp;		/* Pointer to current socket to init. */
  dk3_socket_set_t	*back = NULL;
  size_t		 szmax;		/* Number of sockets in set. */
  size_t		 na;		/* Number of used sockets in set. */
  dk3_socket_t		 so;		/* Socket to create. */
  if(portno) {
    szmax = 1;
    back = dk3socket_set_new(szmax, ec, app);
    if(back) {
      sp = back->pData;
      na = 0;
      /*
      	Attempt to bind IPv4 address.
      */
      dk3mem_res((void *)(&ip4), sizeof(struct sockaddr_in));
      if(fLocalOnly) {
        dk3socket_ip4addr_set_localhost(&ip4);
      } else {
        ip4.sin_family = AF_INET;
	ip4.sin_addr.s_addr = INADDR_ANY;
      }
      ip4.sin_port = htons(portno);
      so = dk3socket_open(AF_INET, SOCK_DGRAM, 0, ec, app);
      if(INVALID_SOCKET != so) {
        if(dk3socket_bind(
	     so, (struct sockaddr *)(&ip4), sizeof(struct sockaddr_in), ec, app
	   )
	)
	{
	  *(sp++) = so;
	  na++;
	}
	else
	{
	  dk3socket_close(so, ec, app);
	}
      }
      /*
      	If no address was bound, close the set.
      */
      if(na) {
        back->szUsed  = na;
      } else {
        dk3socket_set_close(back, ec, app);
	back = NULL;
      } 

#line 2514 "dk3sock4.ctr"
    }
  }
  return back;
}



/**	Fill address bits in an IPv4 address beginning from
	MSB. This function is used to build a netmask.
	@param	ap	Address structure to modify.
	@param	bitno	Number of bits to set.
*/
void
dk3socket_ip4_fill_bits(IN_ADDR *ap, unsigned bitno)
{
  

#line 2530 "dk3sock4.ctr"
  if(ap) {
    unsigned long	bits;
    unsigned long	back;
    unsigned		b;
    back = 0UL;
    bits = 0x80000000UL;
    b = bitno;
    if(b > 32) b = 32;
    while(b--) {
      back |= bits;
      bits = (bits >> 1);
    }
    ap->s_addr = htonl(back); 

#line 2543 "dk3sock4.ctr"
  } 

#line 2544 "dk3sock4.ctr"
}



/**	Set netmask part of allowed peer.
	@param	dp	Destination pointer (allowed peer).
	@param	src	Source text containing the network mask.
	@param	app	Application structure for diagnostics.
	@param	is6	Flag: We are searching for IPv6 address.
	@return	1 on success, 0 on error.
*/
static
int
dknet_allowed_mask(dk3_peer_allowed_t *dp, char *src, dk3_app_t *app, int is6)
{
  IN_ADDR	 ip4mask;		/* IPv4 net mask. */
  unsigned	 u;			/* Number of bits to set. */
  int		 res;			/* Operation result. */
  int		 back = 0;
    if(src) {
      if(dk3str_c8_chr(src, '.')) {
        res = dk3socket_inet_pton(AF_INET, src, (void *)(&ip4mask), NULL, NULL);
        if(res) {
          back = 1;
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 354); }
        }
      } else {
        if(sscanf(src, "%u", &u) == 1) {
          back = 1;
	  dk3socket_ip4_fill_bits(&ip4mask, u);
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 355); }
        }
      }
    } else {
      back = 1;
      ip4mask.s_addr = 0xFFFFFFFFUL;
    }
    if(back) {
      dk3mem_cpy(
        (void *)(&((dp->d).ip4.ma)), (void *)(&ip4mask), sizeof(IN_ADDR)
      );
    }
  return back;
}



int
dk3socket_set_peer(
  dk3_peer_allowed_t	*dp,
  char const		*sr,
  int			*ec,
  dk3_app_t		*app
)
{
  char		 	 bu[DK3_MAX_PATH];	/* Private copy of hostname. */
  struct hostent	*heptr;		/* Result from gethostbyname(). */
  IN_ADDR		 ip4addr;	/* IPv4 address. */
  unsigned long		*ulptr;		/* Pointer to address. */
  char		       **addrptr;	/* Address pointer. */
  struct sockaddr_in	*soin;		/* Socket address. */
  char			*maptr;		/* Pointer to beginning of mask. */
  int			 back = 0;
  int			 res;		/* Result from inet_ntop(). */
  int			 found;		/* Flag: Host found. */
  int			 err;		/* Error code from gethostbyname() .*/
  

#line 2613 "dk3sock4.ctr"
  if((dp) && (sr)) {				

#line 2614 "dk3sock4.ctr"
    found = 0;
    if(dk3str_c8_len(sr) < sizeof(bu)) {	

#line 2616 "dk3sock4.ctr"
      dk3str_c8_cpy_not_overlapped(bu, sr);
      maptr = dk3str_c8_chr(bu, '/');
      if(maptr) {				

#line 2619 "dk3sock4.ctr"
        *(maptr++) = '\0';
	maptr = dk3str_c8_start(maptr, NULL);
      }
      res = dk3socket_inet_pton(AF_INET, bu, (void *)(&ip4addr), NULL, NULL);
      if(res) {					

#line 2624 "dk3sock4.ctr"
        found = 1;
        /* HAVE IPv4 address */
	dp->wh = 0;
	dk3mem_cpy(
	  (void *)(&((dp->d).ip4.ad)), (void *)(&ip4addr), sizeof(IN_ADDR)
	);
	back = dknet_allowed_mask(dp, maptr, app, 0);
      } else {					

#line 2632 "dk3sock4.ctr"
      }
      if(!(found)) {				

#line 2634 "dk3sock4.ctr"
	

#line 2635 "dk3sock4.ctr"
	heptr = gethostbyname(bu);
	if(heptr) {
	  if(AF_INET == heptr->h_addrtype) {		

#line 2638 "dk3sock4.ctr"
	    if(4 == heptr->h_length) {			

#line 2639 "dk3sock4.ctr"
	      if(heptr->h_addr_list) {			

#line 2640 "dk3sock4.ctr"
	        addrptr = heptr->h_addr_list;
		ulptr = (unsigned long *)(*addrptr);
		if(ulptr) {
		  dp->wh = 0;
		  dk3mem_cpy(
		    (void *)(&((dp->d).ip4.ad)),
		    (void *)(ulptr),
		    sizeof(IN_ADDR)
		  );
		  back = dknet_allowed_mask(dp, maptr, app, 0);
		}
	      } else {					

#line 2652 "dk3sock4.ctr"
	      }
	    } else {					

#line 2654 "dk3sock4.ctr"
	    }
	  } else {					

#line 2656 "dk3sock4.ctr"
	  }
	} else {					

#line 2658 "dk3sock4.ctr"
	  err = dk3socket_error(h_errno);
	  dk3socket_error_gethostbyname(ec, app, err, bu);
	}
      }
    } else {					

#line 2663 "dk3sock4.ctr"
      /* ERROR: Source text too long! */
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 108); }
    }
  } else {					

#line 2667 "dk3sock4.ctr"
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 2669 "dk3sock4.ctr"
  return back;
}



int
dk3socket_compare_peer(void *l, void *r, int cr)
{
  char			 adbl[16];
  char			 adbr[16];
  dk3_peer_allowed_t	*pl;
  dk3_peer_allowed_t	*pr;
  struct sockaddr	*so;
  struct sockaddr_in	*soin;
  unsigned long		 ull;
  unsigned long		 ulr;
  size_t		 i;
  int			 back = 0;
  if(l) {
    if(r) {
      pl = (dk3_peer_allowed_t *)l;
      switch(cr) {
        case 1: {
	  /*	Compare address families.
	  */
	  so = (struct sockaddr *)r;
	  switch(so->sa_family) {
	    case AF_INET: {
	      if(pl->wh) {
	        back = 1;
	      }
	    } break;
	    default: {
	      back = -1;
	    } break;
	  }
	  /*	For matching address families compare addresses.
	  */
	  if(0 == back) {
	    if(pl->wh) {
	      /* Compare IPv6.
	      */
	    } else {
	      /* Compare IPv4.
	      */
	      soin = (struct sockaddr_in *)r;
	      ull = ((pl->d).ip4.ad.s_addr) & ((pl->d).ip4.ma.s_addr);
	      ulr = ((soin->sin_addr).s_addr) & ((pl->d).ip4.ma.s_addr);
	      if(ull < ulr) {
	        back = -1;
	      } else {
	        if(ull > ulr) {
		  back = 1;
		}
	      }
	    }
	  }
	} break;
	default: {
	  pr = (dk3_peer_allowed_t *)r;
	  if(pl->wh > pr->wh) {
	    back = 1;
	  } else {
	    if(pl->wh < pr->wh) {
	      back = -1;
	    }
	  }
	  if(0 == back) {
	    switch(pl->wh) {
	      case 1: {
	        /* Compare IPv6 addresses.
		*/
	      } break;
	      default: {
	        /* Compare IPv4 addresses.
		*/
	        if((pl->d).ip4.ad.s_addr > (pr->d).ip4.ad.s_addr) {
		  back = 1;
		} else {
		  if((pl->d).ip4.ad.s_addr < (pr->d).ip4.ad.s_addr) {
		    back = -1;
		  }
		}
	      } break;
	    }
	  }
	} break;
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}


#if (DK3_CHAR_SIZE == 2)

static
dk3_socket_t
dk3socket_dkchar_attempt_open_net_stream_for_local_address(
  int			 af,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  ADDRINFOW const	*resl,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*hn
)
{
  dk3_socket_t		 back = INVALID_SOCKET;
  ADDRINFOW const	*resc;		/* Current address. */
  struct sockaddr	*soa;		/* Socket address. */
  int			 found;		/* Flag: Matching address found. */
  int			 connres;	/* Result from bind() and connect(). */
  found = 0;
  resc = resl;
  while((resc) && (INVALID_SOCKET == back)) {
    soa = resc->ai_addr;
    if(soa) {
      if(soa->sa_family == af) {
        switch(af) {
	  case AF_INET:
	  case AF_INET6: {
	    switch(soa->sa_family) {
	      case AF_INET6: {
	        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
	      } break;
	      default: {
	        back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
	      } break;
	    }
	    if(INVALID_SOCKET != back) {
	      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	      connres = dk3socket_bind(
	        back, soa, resc->ai_addrlen, ec, app
	      );
	      if(connres) {
	        connres = dk3socket_connect_nb(
		  back, pAddr, szAddr, secs, usecs, ec, app, hn, 0
		);
		if(!(connres)) {			

#line 2813 "dk3sock4.ctr"
		  dk3socket_close(back, NULL, NULL);
		  back = INVALID_SOCKET;
		}
	      } else {					

#line 2817 "dk3sock4.ctr"
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    } else {					

#line 2821 "dk3sock4.ctr"
	    }
	  } break;
	  default: {					

#line 2824 "dk3sock4.ctr"
	  } break;
	}
      } else {						

#line 2827 "dk3sock4.ctr"
      }
    } else {						

#line 2829 "dk3sock4.ctr"
    }
    resc = resc->ai_next;
  }
  return back;
}


/**	Attempt to open a client socket.
	@param	hai	Server host address information.
	@param	lai	Client (local) host address information, may be NULL.
	@param	secs	Timeout seconds.
	@param	usecs	Timeout microseconds.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	sh	Server host name.
	@return	Valid socket on success, INVALID_SOCKET on error.
*/
static
dk3_socket_t
dk3socket_dkchar_attempt_open_net_stream_client(
  ADDRINFOW	const	*hai,
  ADDRINFOW	const *lai,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*sh
)
{
  ADDRINFOW	const	*resc;
  ADDRINFOW	const	*resl;
  struct sockaddr	*soa;
  struct sockaddr	*sol;
  dk3_socket_t		 back = INVALID_SOCKET;
  int			 found;
  int			 connres;
  

#line 2866 "dk3sock4.ctr"
  found = 0;
  resc = hai;
  while((resc) && (INVALID_SOCKET == back)) {	

#line 2869 "dk3sock4.ctr"
    soa = resc->ai_addr;
    if(soa) {					

#line 2871 "dk3sock4.ctr"
      if(lai) {
        resl = lai;
	while((resl) && (INVALID_SOCKET == back)) {
	  sol = resl->ai_addr;
	  if(sol) {
	    if(soa->sa_family == sol->sa_family) {
	      switch(soa->sa_family) {
	        case AF_INET: case AF_INET6: {
		  found = 1;
		  switch(soa->sa_family) {
		    case AF_INET6: {
		      back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
		    } break;
		    default: {
		      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
		    } break;
		  }
		  if(INVALID_SOCKET != back) {
		    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
		    connres = dk3socket_bind(
		      back, sol, resl->ai_addrlen, ec, app
		    );
		    if(connres) {
		      connres = dk3socket_connect_nb(
		        back, soa, resc->ai_addrlen, secs, usecs, ec, app, sh, 0
		      );
		      if(!(connres)) {			

#line 2898 "dk3sock4.ctr"
		        dk3socket_close(back, NULL, NULL);
			back = INVALID_SOCKET;
		      }
		    } else {				

#line 2902 "dk3sock4.ctr"
		      dk3socket_close(back, NULL, NULL);
		      back = INVALID_SOCKET;
		    }
		  } else {				

#line 2906 "dk3sock4.ctr"
		  }
		} break;
		default: {				

#line 2909 "dk3sock4.ctr"
		} break;
	      }
	    } else {					

#line 2912 "dk3sock4.ctr"
	    }
	  } else {					

#line 2914 "dk3sock4.ctr"
	  }
	  resl = resl->ai_next;
	}
      } else {						

#line 2918 "dk3sock4.ctr"
        switch(soa->sa_family) {
          case AF_INET: {
	    found = 1;
	    back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back, soa, resc->ai_addrlen, secs, usecs, ec, app, sh, 0
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
	        back = INVALID_SOCKET;
	      }
	    }
	  } break;
	  case AF_INET6: {
	    found = 1;
	    back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back, soa, resc->ai_addrlen, secs, usecs, ec, app, sh, 0
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
	        back = INVALID_SOCKET;
	      }
	    }
	  } break;
	  default: {
	  } break;
        }
      }
    } else {					

#line 2950 "dk3sock4.ctr"
    }
    resc = resc->ai_next;
  }
  

#line 2954 "dk3sock4.ctr"
  return back;
}



/**	Set netmask part of allowed peer.
	@param	dp	Destination pointer (allowed peer).
	@param	src	Source text containing the network mask.
	@param	app	Application structure for diagnostics.
	@param	is6	Flag: We are searching for IPv6 address.
	@return	1 on success, 0 on error.
*/
static
int
dknet_dkchar_allowed_mask(
  dk3_peer_allowed_t *dp, dkChar *src, dk3_app_t *app, int is6
)
{
  IN_ADDR	 ip4mask;		/* IPv4 net mask. */
  unsigned	 u;			/* Number of bits to set. */
  int		 res;			/* Operation result. */
  int		 back = 0;
    if(src) {
      if(dk3str_chr(src, dkT('.'))) {
        res = dk3socket_dkchar_inet_pton(
	  AF_INET, src, (void *)(&ip4mask), NULL, NULL
	);
        if(res) {
          back = 1;
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 354); }
        }
      } else {
#if VERSION_BEFORE_20140716
        if(dk3sf_sscanf3(src, dkT("%u"), &u) == 1)
#else
	if(0 != dk3ma_u_from_string(&u, src, NULL))
#endif
	{
          back = 1;
	  dk3socket_ip4_fill_bits(&ip4mask, u);
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 355); }
        }
      }
    } else {
      back = 1;
      ip4mask.s_addr = 0xFFFFFFFFUL;
    }
    if(back) {
      dk3mem_cpy(
        (void *)(&((dp->d).ip4.ma)), (void *)(&ip4mask), sizeof(IN_ADDR)
      );
    }
  return back;
}

#endif

dk3_socket_t
dk3socket_dkchar_open_net_stream_client(
  dkChar const		*sh,
  unsigned short	 sp,
  unsigned short	 lp,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No support for wide char socket functions!"
#else
  /* ##### Complete rewrite, do not use getaddrinfo(). */
  dkChar		 lbuf[64];			/* Server port text. */
  dkChar		 pbuf[64];			/* Local port text. */
  IN_ADDR		 in4;				/* IPv4 address. */
  dk3_socket_t		 back	=	INVALID_SOCKET;
  ADDRINFOW		 hs;
  ADDRINFOW		 hl;
  ADDRINFOW		*ress	=	NULL;
  ADDRINFOW		*resl	=	NULL;
  struct sockaddr_in	 soin4;
  int			 resgai;
  int			 connres;
  

#line 3041 "dk3sock4.ctr"
  if(sp) {
    if(sh) {						

#line 3043 "dk3sock4.ctr"
      ress = NULL;
      resl = NULL;
      resgai = 0;
      if(lp) {						

#line 3047 "dk3sock4.ctr"
#if VERSION_BEFORE_20140716
        dk3sf_sprintf3(lbuf, dkT("%u"), (unsigned)lp);
	dk3mem_res((void *)(&hl), sizeof(ADDRINFOW));
	hl.ai_flags = AI_NUMERICSERV | AI_PASSIVE;
	hl.ai_family = AF_UNSPEC;
	hl.ai_socktype = SOCK_STREAM;
	hl.ai_protocol = 0;
	resgai = GetAddrInfoW(NULL, lbuf, &hl, &resl);
#else
	if (0 != dk3ma_um_to_string(lbuf,DK3_SIZEOF(lbuf,dkChar),(dk3_um_t)lp))
	{
	  dk3mem_res((void *)(&hl), sizeof(ADDRINFOW));
	  hl.ai_flags = AI_NUMERICSERV | AI_PASSIVE;
	  hl.ai_family = AF_UNSPEC;
	  hl.ai_socktype = SOCK_STREAM;
	  hl.ai_protocol = 0;
	  resgai = GetAddrInfoW(NULL, lbuf, &hl, &resl);
	}
#endif
      }
      if(((0 == resgai) && (resl)) || (0 == lp)) {
        resgai = dk3socket_dkchar_inet_pton(
	  AF_INET, sh, (void *)(&in4), NULL, NULL
	);
	if(1 == resgai) {
	  dk3mem_res((void *)(&soin4), sizeof(struct sockaddr_in));
	  soin4.sin_family = AF_INET;
	  soin4.sin_port = htons(sp);
	  dk3mem_cpy(
	    (void *)(&(soin4.sin_addr)),
	    (void *)(&(in4)),
	    sizeof(IN_ADDR)
	  );
	  if(lp) {
	    back = dk3socket_dkchar_attempt_open_net_stream_for_local_address(
	      AF_INET, (struct sockaddr *)(&soin4), sizeof(soin4),
	      resl, secs, usecs, NULL, NULL, sh
	    );
	  } else {
	    back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back,
		(struct sockaddr *)(&soin4), sizeof(struct sockaddr_in),
		secs, usecs, NULL, NULL, sh, 0
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    } else {					

#line 3098 "dk3sock4.ctr"
	    }
	  }
	} else {					

#line 3101 "dk3sock4.ctr"
	}
	if(INVALID_SOCKET == back) {			

#line 3103 "dk3sock4.ctr"
	  resgai = dk3socket_dkchar_inet_pton(
	    AF_INET6, sh, (void *)(&in6), NULL, NULL
	  );
	  if(1 == resgai) {
	    dk3mem_res((void *)(&soin6), sizeof(struct sockaddr_in6));
	    soin6.sin6_family = AF_INET6;
	    soin6.sin6_port = htons(sp);
	    dk3mem_cpy(
	      (void *)(&(soin6.sin6_addr)),
	      (void *)(&in6),
	      sizeof(IN6_ADDR)
	    );
	    if(lp) {
	      back = dk3socket_dkchar_attempt_open_net_stream_for_local_address(
	        AF_INET6, (struct sockaddr *)(&soin6), sizeof(soin6),
		resl, secs, usecs, NULL, NULL, sh
	      );
	    } else {
	      back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	      if(INVALID_SOCKET != back) {
	        connres = dk3socket_connect_nb(
		  back,
		  (struct sockaddr *)(&soin6), sizeof(struct sockaddr_in6),
		  secs, usecs, NULL, NULL, sh,0 
		);
		if(!(connres)) {
		  dk3socket_close(back, NULL, NULL);
		  back = INVALID_SOCKET;
		}
	      }
	    }
	  }
	}
	if(INVALID_SOCKET == back) {			

#line 3137 "dk3sock4.ctr"
#if VERSION_BEFORE_20140716
	  dk3sf_sprintf3(pbuf, dkT("%u"), (unsigned)sp);
	  dk3mem_res((void *)(&hs), sizeof(struct addrinfo));
	  hs.ai_flags = AI_NUMERICSERV;
	  hs.ai_family = AF_UNSPEC;
	  hs.ai_socktype = SOCK_STREAM;
	  hs.ai_protocol = 0;
	  resgai = GetAddrInfoW(sh, pbuf, &hs, &ress);
	  if((0 == resgai) && (ress)) {			

#line 3146 "dk3sock4.ctr"
	    back = dk3socket_dkchar_attempt_open_net_stream_client(
	      ress, ((lp) ? (resl) : NULL), secs, usecs, NULL, NULL, sh
	    );
	  } else {					

#line 3150 "dk3sock4.ctr"
	    dk3socket_error_getaddrinfo(ec, app, resgai);
	  }
	  if(ress) {
	    FreeAddrInfoW(ress); ress = NULL;
	  }
#else
	  if (dk3ma_um_to_string(pbuf, DK3_SIZEOF(pbuf,dkChar), (dk3_um_t)sp)) {
	    dk3sf_sprintf3(pbuf, dkT("%u"), (unsigned)sp);
	    dk3mem_res((void *)(&hs), sizeof(struct addrinfo));
	    hs.ai_flags = AI_NUMERICSERV;
	    hs.ai_family = AF_UNSPEC;
	    hs.ai_socktype = SOCK_STREAM;
	    hs.ai_protocol = 0;
	    resgai = GetAddrInfoW(sh, pbuf, &hs, &ress);
	    if((0 == resgai) && (ress)) {		

#line 3165 "dk3sock4.ctr"
	      back = dk3socket_dkchar_attempt_open_net_stream_client(
	        ress, ((lp) ? (resl) : NULL), secs, usecs, NULL, NULL, sh
	      );
	    } else {					

#line 3169 "dk3sock4.ctr"
	      dk3socket_error_getaddrinfo(ec, app, resgai);
	    }
	    if(ress) {
	      FreeAddrInfoW(ress); ress = NULL;
	    }
	  }
#endif
	}
      } else {
        /* ERROR: No local addresses found */
      }
      if(resl) {
        FreeAddrInfoW(resl); resl = NULL;
      }
    } else {						

#line 3184 "dk3sock4.ctr"
      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
      if(INVALID_SOCKET != back) {
        if(lp) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip4addr_set_localhost(&soin4);
	  soin4.sin_port = htons(lp);
	  connres = dk3socket_bind(
	    back, (struct sockaddr *)(&soin4), sizeof(soin4),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      if(INVALID_SOCKET != back) {
        dk3socket_ip4addr_set_localhost(&soin4);
	soin4.sin_port = htons(sp);
	connres = dk3socket_connect_nb(
	  back,
	  (struct sockaddr *)(&soin4), sizeof(soin4),
	  secs, usecs, NULL, NULL, sh, 0
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
      if(INVALID_SOCKET == back) {
        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
        if(INVALID_SOCKET != back) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip6addr_set_localhost(&soin6);
	  soin6.sin6_port = htons(lp);
	  connres = dk3socket_bind(
	    back,
	    (struct sockaddr *)(&soin6), sizeof(soin6),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3socket_ip6addr_set_localhost(&soin6);
	  soin6.sin6_port = htons(sp);
	  connres = dk3socket_connect_nb(
	    back,
	    (struct sockaddr *)(&soin6), sizeof(soin6),
	    secs, usecs, NULL, NULL, sh, 0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
    }
    if(INVALID_SOCKET == back) {
      if(sh) {
        if(app) { dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, sh); }
      } else {
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
      }
    }
  } else {						

#line 3252 "dk3sock4.ctr"
    /* ERROR: No server port specified! */
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 3255 "dk3sock4.ctr"
  return back;
#endif
#else
  dk3_socket_t	back;
  back = dk3socket_open_net_stream_client(sh, sp, lp, secs, usecs, ec, app);
  return back;
#endif
}



int
dk3socket_dkchar_inet_pton(
  int		 af,
  dkChar const	*hn,
  void		*addr,
  int		*ec,
  dk3_app_t	*app
)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No support for wide char socket functions!"
#else
  int		 back = 0;
  int		 res;
  res = InetPtonW(af, hn, addr);
  switch(res) {
    case 1: {
      back = 1;
    } break;
    case 0: {
      /* ERROR: Not an IP address! */
    } break;
    case -1: {
      dk3socket_error_inet_pton(ec, app, WSAGetLastError());
    } break;
  }
  return back;
#endif
#else
  int back;
  back = dk3socket_inet_pton(af, hn, addr, ec, app);
  return back;
#endif
}



int
dk3socket_dkchar_set_peer(
  dk3_peer_allowed_t	*dp,
  dkChar const		*sr,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No support for wide char socket functions!"
#else
  /* ##### Complete rewrite, do not use getaddrinfo() */
  dkChar		 bu[DK3_MAX_PATH];
  ADDRINFOW		 hints;
  ADDRINFOW		*rgai;
  ADDRINFOW		*pai;
  IN6_ADDR		 ip6addr;
  struct sockaddr_in6	*soin6;
  IN_ADDR		 ip4addr;
  struct sockaddr_in	*soin;
  dkChar		*maptr;
  int			 res;
  int			 found;
  int			 back = 0;
  

#line 3330 "dk3sock4.ctr"
  if((dp) && (sr)) {
    found = 0;
    if(dk3str_len(sr) < DK3_SIZEOF(bu,dkChar)) {
      dk3str_cpy_not_overlapped(bu, sr);
      maptr = dk3str_chr(bu, dkT('/'));
      if(maptr) {
        *(maptr++) = dkT('\0');
	maptr = dk3str_start(maptr, NULL);
      }
      res = dk3socket_dkchar_inet_pton(
        AF_INET, bu, (void *)(&ip4addr), NULL, NULL
      );
      if(res) {
        found = 1;
	dp->wh = 0;
	dk3mem_cpy(
	  (void *)(&((dp->d).ip4.ad)), (void *)(&ip4addr), sizeof(IN_ADDR)
	);
	back = dknet_dkchar_allowed_mask(dp, maptr, app, 0);
      } else {
      }
      if(!(found)) {
        rgai = NULL;
	dk3mem_res((void *)(&hints), sizeof(ADDRINFOW));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = 0;
	hints.ai_protocol = 0;
	hints.ai_addrlen = 0;
	hints.ai_canonname = NULL;
	hints.ai_addr = NULL;
	hints.ai_next = NULL;
	res = GetAddrInfoW(bu, NULL, &hints, &rgai);
	if(0 == res) {
	  if(rgai) {
	    pai = rgai;
	    while((0 == back) && (pai)) {
	      switch(pai->ai_family) {
	        case AF_INET: {
		  if(sizeof(struct sockaddr_in) == pai->ai_addrlen) {
		    if(pai->ai_addr) {
		      found = 1;
		      dp->wh = 0;
		      soin = (struct sockaddr_in *)(pai->ai_addr);
		      dk3mem_cpy(
		        (void *)(&((dp->d).ip4.ad)),
			(void *)(&(soin->sin_addr)),
			sizeof(IN_ADDR)
		      );
		      back = dknet_dkchar_allowed_mask(dp, maptr, app, 0);
		    }
		  }
		} break;
	      }
	      pai = pai->ai_next;
	    }
	  } else {
	  }
	} else {
	  dk3socket_error_getaddrinfo(ec, app, res);
	}
	if(rgai) {
	  FreeAddrInfoW(rgai);
	}
      }
    } else {
      /* ERROR: Host name too long! */
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 108); }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 3402 "dk3sock4.ctr"
  return back;
#endif
#else
  int back;
  back = dk3socket_set_peer(dp, sr, ec, app);
  return back;
#endif
}



dk3_socket_t
dk3socket_set_accept(
  dk3_socket_set_t	*ss,
  struct sockaddr	*pAddr,
  size_t		*pSzAddr,
  dk3_sto_it_t		*iAllowed,
  int			 skipDenied,
  long			 nsecs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  dkChar		 adbu[128];		/* Address text buffer. */
  dkChar		 sobu[128];		/* Socket number buffer. */
  dk3_sockaddr_storage_t sasto;			/* Peer address. */
  struct timeval	 to;
  fd_set		 rfds;
  void			*pp;			/* Peer pointer. */
  size_t		 i;			/* Listener index. */
  dk3_socket_t		 lisock	= INVALID_SOCKET; /* Listener socket. */
  dk3_socket_t		 max	= 0;		/* Maximum socket number. */
  dk3_socket_t		 back	= INVALID_SOCKET;
  int			 addrsize = 0;
  int			 mustSelect = 0;	/* Flag: Must select(). */
  int			 haveAny = 0;		/* Flag: Have any listener. */
  int			 ccloop = 0;		/* Flag: Can continue loop. */
  int			 adbures;		/* Conversion result. */
  

#line 3442 "dk3sock4.ctr"
  dk3mem_res((void *)(&sasto), sizeof(sasto));
  if(ss) {						

#line 3444 "dk3sock4.ctr"
    if((ss->pData) && (ss->szUsed)) {			

#line 3445 "dk3sock4.ctr"
      if(ss->szUsed > 1) { mustSelect = 1; }
      if((nsecs) || (usecs)) { mustSelect = 1; }
      do {
        ccloop = 0;
	to.tv_sec = nsecs;
	to.tv_usec = usecs;
	lisock = INVALID_SOCKET;
	addrsize = (int)sizeof(sasto);
	to.tv_sec = nsecs;
	to.tv_usec = usecs;
        if(mustSelect) {			

#line 3456 "dk3sock4.ctr"
	  FD_ZERO(&rfds);
	  for(i = 0; i < ss->szUsed; i++) {
	    if(INVALID_SOCKET != (ss->pData)[i]) {
	      FD_SET((ss->pData)[i],&rfds);
	      haveAny = 1;		

#line 3461 "dk3sock4.ctr"
	      if((ss->pData)[i] > max) {
	        max = (ss->pData)[i];
	      }
	    }
	  }
	  if(haveAny) {			

#line 3467 "dk3sock4.ctr"
	    haveAny = select(
	      ((int)max + 1), &rfds, NULL, NULL, (((nsecs) || (usecs)) ? &to : NULL)
	    );				

#line 3470 "dk3sock4.ctr"
	    if(SOCKET_ERROR != haveAny)
	    {				

#line 3472 "dk3sock4.ctr"
	      for(i = 0; (i < ss->szUsed) && (INVALID_SOCKET == lisock); i++) {
	        if(INVALID_SOCKET != (ss->pData)[i]) {
	          if(FD_ISSET((ss->pData)[i],&rfds)) {
		    FD_CLR((ss->pData)[i],&rfds);
		    lisock = (ss->pData)[i];	

#line 3477 "dk3sock4.ctr"
		  }
	        }
	      }
	    } else {			

#line 3481 "dk3sock4.ctr"
	      if(0 == haveAny) {		/* Timeout */	

#line 3482 "dk3sock4.ctr"
	        if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 317); }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	      } else {			/* Failure */	

#line 3486 "dk3sock4.ctr"
	        if(ec) { *ec = DK3_ERROR_SYSTEM; }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 317); }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	      }
	    }
	  } else {			

#line 3492 "dk3sock4.ctr"
	    /* ERROR: No valid socket in set! */
	    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 359); }
	  }
        } else {				

#line 3497 "dk3sock4.ctr"
          lisock = *(ss->pData); 

#line 3498 "dk3sock4.ctr"
        }
        if(INVALID_SOCKET != lisock) {	

#line 3500 "dk3sock4.ctr"
          back = accept(lisock, (struct sockaddr *)(&sasto), &addrsize); 

#line 3501 "dk3sock4.ctr"
	  if(INVALID_SOCKET == back) {	

#line 3502 "dk3sock4.ctr"
	    dk3socket_error_accept(ec, app, dk3socket_error(errno));
	  }
        }
        if(INVALID_SOCKET != back) {		

#line 3506 "dk3sock4.ctr"
          if(iAllowed) {
	    pp = dk3sto_it_find_like(iAllowed, (void *)(&sasto), 1);
	    if(!(pp)) {			

#line 3509 "dk3sock4.ctr"
	      /* Not allowed to connect! */
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	      if(skipDenied) { ccloop = 1; }
	      if(app) {
	        if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
	          adbures = dk3socket_ipaddr_to_text(
	            adbu, DK3_SIZEOF(adbu,dkChar), (void *)(&sasto), addrsize
	          );
	          if(adbures) {
		    dk3app_log_i3(app, DK3_LL_PROGRESS, 362, 363, adbu); 
	          }
	        }
	      }
	    }
	  }
        }
        if(INVALID_SOCKET != back) {
          if((pAddr) && (pSzAddr)) {
	    if(*pSzAddr >= (size_t)addrsize) {
	      dk3mem_cpy((void *)pAddr, (void *)(&sasto), (size_t)addrsize);
	      *pSzAddr = (size_t)addrsize;
	    } else {			

#line 3532 "dk3sock4.ctr"
	      /* Failed to save address! */
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	      /* Failed to save address size, buffer too small! */
	      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 38); }
	    }
	  }
        }
	if(INVALID_SOCKET != back) {
	  if(app) {
	    if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
	      adbures = dk3socket_ipaddr_to_text(
	        adbu, DK3_SIZEOF(adbu,dkChar), (void *)(&sasto), addrsize
	      );
	      if(adbures) {
#if VERSION_BEFORE_20140716
	        dk3sf_sprintf3(sobu,dkT("%d"),((int)back));
	        dk3app_log_i5(app, DK3_LL_PROGRESS, 360, 361, 371, sobu, adbu);
#else
		if(
		dk3ma_im_to_string(sobu,DK3_SIZEOF(sobu,dkChar),(dk3_im_t)back)
		)
		{
		  dk3app_log_i5(app,DK3_LL_PROGRESS,360,361,371,sobu,adbu);
		}
#endif
	      }
	    }
	  }
	}
      } while((ccloop) && (INVALID_SOCKET == back));
    } else {				

#line 3565 "dk3sock4.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) {
        /* ERROR: No usable socket in set! */
	if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 359); }
      }
    }
  } else {				

#line 3573 "dk3sock4.ctr"
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  

#line 3576 "dk3sock4.ctr"
  return back;
}



void
dk3socket_eat_input(dk3_socket_t so, dk3_app_t *app)
{
  char		bu[4096];
  int		szrd;
  do {
    szrd = dk3socket_recv(so, bu, sizeof(bu), 0L, 0L, NULL, app);
  } while(szrd > 0);
}


#else
#error	"This module is for legacy Windows versions only!"
#endif

