/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3sock.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3sock.c The dk3sock module.
*/


#line 952 "dk3sock.ctr"


#include "dk3all.h"
#include "dk3sock.h"





#line 960 "dk3sock.ctr"



#if DK3_HAVE_STRUCT_SOCKADDR_IN6
/**	Value to initialize any address.
*/
static const IN6_ADDR dk3socket_ia6_addr_any = IN6ADDR_ANY_INIT;
#endif





#line 972 "dk3sock.ctr"


#line 973 "dk3sock.ctr"


#line 974 "dk3sock.ctr"


#line 975 "dk3sock.ctr"


#line 976 "dk3sock.ctr"


#line 977 "dk3sock.ctr"


#line 978 "dk3sock.ctr"


#line 979 "dk3sock.ctr"


#line 980 "dk3sock.ctr"





#line 984 "dk3sock.ctr"


#line 985 "dk3sock.ctr"


#line 986 "dk3sock.ctr"


#line 987 "dk3sock.ctr"


#line 988 "dk3sock.ctr"


#line 989 "dk3sock.ctr"


#line 990 "dk3sock.ctr"


#line 991 "dk3sock.ctr"


#line 992 "dk3sock.ctr"


#line 993 "dk3sock.ctr"


#line 994 "dk3sock.ctr"


#line 995 "dk3sock.ctr"


#line 996 "dk3sock.ctr"


#line 997 "dk3sock.ctr"


#line 998 "dk3sock.ctr"


#line 999 "dk3sock.ctr"


#line 1000 "dk3sock.ctr"


#line 1001 "dk3sock.ctr"


#line 1002 "dk3sock.ctr"


#line 1003 "dk3sock.ctr"


#line 1004 "dk3sock.ctr"


#line 1005 "dk3sock.ctr"


#line 1006 "dk3sock.ctr"


#line 1007 "dk3sock.ctr"


#line 1008 "dk3sock.ctr"


#line 1009 "dk3sock.ctr"


#line 1010 "dk3sock.ctr"


#line 1011 "dk3sock.ctr"


#line 1012 "dk3sock.ctr"


#line 1013 "dk3sock.ctr"


#line 1014 "dk3sock.ctr"


#line 1015 "dk3sock.ctr"


#line 1016 "dk3sock.ctr"


#line 1017 "dk3sock.ctr"


#line 1018 "dk3sock.ctr"


#line 1019 "dk3sock.ctr"


#line 1020 "dk3sock.ctr"


#line 1021 "dk3sock.ctr"


#line 1022 "dk3sock.ctr"


#line 1023 "dk3sock.ctr"


#line 1024 "dk3sock.ctr"


#line 1025 "dk3sock.ctr"


#line 1026 "dk3sock.ctr"


#line 1027 "dk3sock.ctr"


#line 1028 "dk3sock.ctr"


#line 1029 "dk3sock.ctr"


#line 1030 "dk3sock.ctr"


#line 1031 "dk3sock.ctr"


#line 1032 "dk3sock.ctr"


#line 1033 "dk3sock.ctr"


#line 1034 "dk3sock.ctr"


#line 1035 "dk3sock.ctr"


#line 1036 "dk3sock.ctr"


#line 1037 "dk3sock.ctr"


#line 1038 "dk3sock.ctr"


#line 1039 "dk3sock.ctr"


#line 1040 "dk3sock.ctr"


#line 1041 "dk3sock.ctr"


#line 1042 "dk3sock.ctr"


#line 1043 "dk3sock.ctr"


#line 1044 "dk3sock.ctr"


#line 1045 "dk3sock.ctr"


#line 1046 "dk3sock.ctr"


#line 1047 "dk3sock.ctr"


#line 1048 "dk3sock.ctr"


#line 1049 "dk3sock.ctr"


#line 1050 "dk3sock.ctr"


#line 1051 "dk3sock.ctr"


#line 1052 "dk3sock.ctr"


#line 1053 "dk3sock.ctr"


#line 1054 "dk3sock.ctr"


#line 1055 "dk3sock.ctr"


#line 1056 "dk3sock.ctr"


#line 1057 "dk3sock.ctr"


#line 1058 "dk3sock.ctr"


#line 1059 "dk3sock.ctr"


#line 1060 "dk3sock.ctr"



void
dk3socket_set_delete(dk3_socket_set_t *ps)
{
  if(ps) {
    dk3_release(ps->pData);
    ps->szMax = 0; ps->szUsed = 0;
    dk3_delete(ps);
  }
}



void
dk3socket_set_close(dk3_socket_set_t *ps, int *ec, dk3_app_t *app)
{
  dk3_socket_t		*ptr;	/* Current socket to close. */
  size_t		 i;	/* Index of current socket to close. */
  if(ps) {
    if((ps->pData) && (ps->szUsed)) {
      ptr = ps->pData;
      for(i = 0; i < ps->szUsed; i++) {
        if(INVALID_SOCKET != (*ptr)) {
	  dk3socket_close(*ptr, ec, app);
	  *ptr = INVALID_SOCKET;
	}
        ptr++;
      }
    }
    dk3socket_set_delete(ps);
  }
}



dk3_socket_set_t *
dk3socket_set_new(
  size_t		 sz,
  int			*ec,
  dk3_app_t		*app
)
{
  dk3_socket_t		*ptr;		/* Current socket to initialize. */
  dk3_socket_set_t	*back = NULL;
  size_t		 i;		/* Index of socket to initialize. */
  if(sz) {
    back = dk3_new_app(dk3_socket_set_t,1,app);
    if(back) {
      back->pData = NULL;
      back->szMax = 0;
      back->szUsed = 0;
      back->pData = dk3_new_app(dk3_socket_t,sz,app);
      if(back->pData) {
        ptr = back->pData;
	for(i = 0; i < sz; i++) { *(ptr++) = INVALID_SOCKET; }
	back->szMax = sz;
      } else {
        dk3_delete(back);
	back = NULL;
      }
    }
  }
  return back;
}



int
dk3socket_check(dk3_socket_t so)
{
  int back = 0;
  if(INVALID_SOCKET != so) {
    back = 1;
  }
  return back;
}



/**	Function names, used for error reporting on non-Windows systems.
*/
static dkChar const * const dk3socket_function_names[] = {
/* 0 */
dkT("socket: "),

/* 1 */
dkT("bind: "),

/* 2 */
dkT("connect: "),

/* 3 */
dkT("listen: "),

/* 4 */
dkT("accept: "),

/* 5 */
dkT("send/sendto:"),

/* 6 */
dkT("recv/recvfrom: "),

/* 7 */
dkT("select: "),

/* 8 */
dkT("close: "),

/* 9 */
dkT("inet_pton: "),

/* 10 */
dkT("getaddrinfo: "),

/* 11 */
dkT("shutdown: "),

/* 12 */
dkT("setsockopt: "),

/* 13 */
dkT(""),

/* 14 */
dkT("fcntl: "),

/* 15 */
dkT(":"),

/* 16 */
dkT("%lu"),

/* 17 */
dkT("."),

/* 18 */
dkT("%x"),

/* 19 */
dkT("%u@"),

NULL


#line 1226 "dk3sock.ctr"
};



void
dk3socket_error_socket(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_SYSTEM; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 279); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 1238 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 1242 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEAFNOSUPPORT: {	

#line 1246 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAEINPROGRESS: {	

#line 1250 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEMFILE: {		

#line 1254 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 277); }
    } break;
    case WSAENOBUFS: {		

#line 1258 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAEPROTONOSUPPORT: {	

#line 1262 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_PROTOCOL_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 278); }
    } break;
    case WSAEPROTOTYPE: {	

#line 1266 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ILLEGAL_PROTOCOL_FAMILY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAESOCKTNOSUPPORT: {	

#line 1270 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 323); }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[0]);
  switch(err) {
#ifdef EACCES
    case EACCES: {		

#line 1279 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#endif
#ifdef EAFNOSUPPORT
    case EAFNOSUPPORT: {	

#line 1284 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {		

#line 1289 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ILLEGAL_PROTOCOL_FAMILY; }
    } break;
#endif
#ifdef EMFILE
    case EMFILE: {		

#line 1294 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_PROCESS_TABLE_OVERFLOW; }
    } break;
#endif
#ifdef ENFILE
    case ENFILE: {		

#line 1299 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
    } break;
#endif
#ifdef EPROTONOSUPPORT
    case EPROTONOSUPPORT: {	

#line 1304 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_PROTOCOL_NOT_SUPPORTED; }
    } break;
#endif
#ifdef EPROTOTYPE
    case EPROTOTYPE: {		

#line 1309 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ILLEGAL_PROTOCOL_FAMILY; }
    } break;
#endif
#ifdef ENOSR
    case ENOSR: {
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#if defined(ENOBUFS) && defined(ENOMEM)
#if ENOBUFS == ENOMEM
    case ENOBUFS: {		

#line 1320 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#else
    case ENOBUFS: {		

#line 1324 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
    case ENOMEM: {		

#line 1327 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#else
#if defined(ENOBUFS)
    case ENOBUFS: {		

#line 1333 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#else
#if defined(ENOMEM)
    case ENOMEM: {		

#line 1338 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#endif
#endif
  }
#endif
}



void
dk3socket_error_bind(int *ec, dk3_app_t *app, int err, dkChar const *lat)
{
  if(ec) { *ec = DK3_ERROR_BIND_FAILED; }
  if(app) { dk3app_log_i3(app, DK3_LL_ERROR, 302, 303, lat); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 1357 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 1361 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEACCES: {		

#line 1365 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 324); }
    } break;
    case WSAEADDRINUSE: {	

#line 1369 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 293); }
    } break;
    case WSAEADDRNOTAVAIL: {	

#line 1373 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 325); }
    } break;
    case WSAEFAULT: {		

#line 1377 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINPROGRESS: {	

#line 1380 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINVAL: {		

#line 1384 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_BOUND; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 304);}
    } break;
    case WSAENOBUFS: {		

#line 1388 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTSOCK: {		

#line 1392 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[1]);
  switch(err) {
#ifdef EACCES
    case EACCES: {
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#endif
#ifdef EADDRINUSE
    case EADDRINUSE: {			

#line 1405 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
    } break;
#endif
#ifdef EADDRNOTAVAIL
    case EADDRNOTAVAIL: {		

#line 1410 "dk3sock.ctr"
      /* ERROR: Address not available on local machine */
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
    } break;
#endif
#ifdef ENOSR
    case ENOSR: {			

#line 1416 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {
      if(ec) { *ec = DK3_ERROR_ALREADY_BOUND; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EIO
    case EIO: {			

#line 1436 "dk3sock.ctr"
      /* ERROR: I/O error while creating directory entry or inode */
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
#ifdef EISDIR
    case EISDIR: {		

#line 1442 "dk3sock.ctr"
      /* ERROR: NULL pathname */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EDESTADDRREQ
#if EDESTADDRREQ != EISDIR
    case EDESTADDRREQ: {	

#line 1449 "dk3sock.ctr"
      /* ERROR: NULL pointer */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#endif
#ifdef ELOOP
    case ELOOP: {		

#line 1456 "dk3sock.ctr"
      /* ERROR: Too many symlinks in path */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOENT
    case ENOENT: {		

#line 1462 "dk3sock.ctr"
      /* ERROR: Directory does not exist */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOTDIR
    case ENOTDIR: {		

#line 1468 "dk3sock.ctr"
      /* ERROR: One of the path components is not a directory */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EROFS
    case EROFS: {		

#line 1474 "dk3sock.ctr"
      /* ERROR: Filesystem is read-only */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EFAULT
    case EFAULT: {		

#line 1480 "dk3sock.ctr"
      /* ERROR: Address argument can not be accessed */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EOPNOTSUPP
    case EOPNOTSUPP: {		

#line 1486 "dk3sock.ctr"
      /* ERROR: Socket type does not support binding an address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENAMETOOLONG
    case ENAMETOOLONG: {	

#line 1492 "dk3sock.ctr"
      /* ERROR: Path name too long! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#if defined(ENOBUFS) && defined(ENOMEM)
#if ENOBUFS == ENOMEM
    case ENOBUFS: {		

#line 1499 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#else
    case ENOBUFS: {		

#line 1503 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
    case ENOMEM: {		

#line 1506 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#else
#if defined(ENOBUFS)
    case ENOBUFS: {		

#line 1512 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#else
#if defined(ENOMEM)
    case ENOMEM: {		

#line 1517 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#endif
#endif
#ifdef EISCONN
    case EISCONN: {		

#line 1524 "dk3sock.ctr"
      /* ERROR: Socket already connected! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_connect(int *ec, dk3_app_t *app, int err, dkChar const *str)
{
  if(ec) { *ec = DK3_ERROR_SYSTEM; }
  if(app) {
    if(str) {
      dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, str);
    } else {
      dk3app_log_i1(app, DK3_LL_ERROR, 282);
    }
  }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 1548 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 1552 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEADDRINUSE: {	

#line 1556 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 293); }
    } break;
    case WSAEINTR: {		

#line 1560 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 1564 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEALREADY: {		

#line 1568 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 295); }
    } break;
    case WSAEADDRNOTAVAIL: {	

#line 1572 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 325); }
    } break;
    case WSAEAFNOSUPPORT: {	

#line 1576 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAECONNREFUSED: {	

#line 1580 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_REFUSED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 296); }
    } break;
    case WSAEFAULT: {		

#line 1584 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINVAL: {		

#line 1587 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEISCONN: {		

#line 1590 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 297); }
    } break;
    case WSAENETUNREACH: {	

#line 1594 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 298); }
    } break;
    case WSAEHOSTUNREACH: {	

#line 1598 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_HOST_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 326); }
    } break;
    case WSAENOBUFS: {		

#line 1602 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTSOCK: {		

#line 1606 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAETIMEDOUT: {	

#line 1609 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
    } break;
    case WSAEWOULDBLOCK: {	

#line 1613 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEACCES: {		

#line 1616 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 324); }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[2]);
  switch(err) {
#if defined(EACCES) && defined(EPERM)
#if EACCES == EPERM
    case EACCES: {
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break ;
#else
    case EACCES:
    case EPERM: {
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#endif
#else
#ifdef EACCES
    case EACCES: {
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#else
#ifdef EPERM
    case EPERM: {
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#endif
#endif
#endif
#ifdef EADDRINUSE
    case EADDRINUSE: {
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
    } break;
#endif
#ifdef EADDRNOTAVAIL
    case EADDRNOTAVAIL: {
      /* ERROR: Address not available on remote machine. */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EAFNOSUPPORT
    case EAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
    } break;
#endif

#if defined(EAGAIN) && defined(EWOULDBLOCK)
#if EAGAIN == EWOULDBLOCK
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#else
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
    case EWOULDBLOCK: {
      /* ERROR: Operation would block! */
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#else
#ifdef EAGAIN
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef EWOULDBLOCK
    case EWOULDBLOCK: {
      /* ERROR: Operation would block! */
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#endif

#ifdef EALREADY
    case EALREADY: {
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
    } break;
#endif
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ECONNREFUSED
    case ECONNREFUSED: {
      if(ec) { *ec = DK3_ERROR_CONNECTION_REFUSED; }
    } break;
#endif
#ifdef EFAULT
    case EFAULT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINPROGRESS
    case EINPROGRESS: {
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
    } break;
#endif
#ifdef EINTR
    case EINTR: {
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
    } break;
#endif
#ifdef EISCONN
    case EISCONN: {
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
    } break;
#endif
#ifdef ENETUNREACH
    case ENETUNREACH: {
      if(ec) { *ec = DK3_ERROR_NETWORK_UNREACHABLE; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ETIMEDOUT 
    case ETIMEDOUT: {
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {
      /* ERROR: Address name length wrong */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EIO
    case EIO: {
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
#ifdef ELOOP
    case ELOOP: {
      /* ERROR: Too many symbolic links while translating path! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EHOSTUNREACH
    case EHOSTUNREACH: {			

#line 1761 "dk3sock.ctr"
      /* ERROR: Remote host not available from this host! */
      if(ec) { *ec = DK3_ERROR_HOST_UNREACHABLE; }
    } break;
#endif
#ifdef ENOENT
    case ENOENT: {				

#line 1767 "dk3sock.ctr"
      /* ERROR: Component in path name does not exist! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOSR
    case ENOSR: {				

#line 1773 "dk3sock.ctr"
      /* ERROR: Resources! */
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef ENXIO
    case ENXIO: {				

#line 1779 "dk3sock.ctr"
      /* ERROR: Server exited before completing connection! */
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
    } break;
#endif
#ifdef ENOTDIR
    case ENOTDIR: {				

#line 1785 "dk3sock.ctr"
      /* Component of path prefix is not a directory! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EPROTOTYPE
    case EPROTOTYPE: {				

#line 1791 "dk3sock.ctr"
      /* ERROR: Can not connect to datagram socket! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENAMETOOLONG
    case ENAMETOOLONG: {	

#line 1797 "dk3sock.ctr"
      /* ERROR: Path name too long! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ECONNRESET
    case ECONNRESET: {		

#line 1803 "dk3sock.ctr"
      /* ERROR: Remote host reset connection request! */
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
    } break;
#endif
#ifdef ENETDOWN
    case ENETDOWN: {		

#line 1809 "dk3sock.ctr"
      /* ERROR: Local network interface is down! */
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
    } break;
#endif
#ifdef ENOBUFS
    case ENOBUFS: {		

#line 1815 "dk3sock.ctr"
      /* ERROR: No buffer space available */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef EOPNOTSUPP
    case EOPNOTSUPP: {		

#line 1821 "dk3sock.ctr"
      /* ERROR: Socket is listening, cannot be connected! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_listen(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_LISTEN_FAILED; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 283); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 1839 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 1843 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEADDRINUSE: {	

#line 1847 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 293); }
    } break;
    case WSAEINPROGRESS: {	

#line 1851 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINVAL: {		

#line 1855 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEISCONN: {		

#line 1858 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 297); }
    } break;
    case WSAEMFILE: {		

#line 1862 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 277); }
    } break;
    case WSAENOBUFS: {		

#line 1866 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTSOCK: {		

#line 1870 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEOPNOTSUPP: {	

#line 1873 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[3]);
  switch(err) {
#ifdef EADDRINUSE
    case EADDRINUSE: {
      if(ec) { *ec = DK3_ERROR_ADDR_IN_USE; }
    } break;
#endif
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EOPNOTSUPP
    case EOPNOTSUPP: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EDESTADDRREQ
    case EDESTADDRREQ: {	

#line 1901 "dk3sock.ctr"
      /* ERROR: Socket must be bound before listening! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {		

#line 1907 "dk3sock.ctr"
      /* ERROR: Socket already connected or shut down! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EACCES
    case EACCES: {		

#line 1913 "dk3sock.ctr"
      /* ERROR: Insufficient privileges */
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#endif
#ifdef ENOBUFS
    case ENOBUFS: {		

#line 1919 "dk3sock.ctr"
      /* ERROR: Insufficient resources! */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_accept(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_ACCEPT_FAILED; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 317); }
#if DK3_ON_WINDOWS
    switch(err) {
      case WSANOTINITIALISED: {	

#line 1937 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
      } break;
      case WSAECONNRESET: {	

#line 1941 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
      } break;
      case WSAEFAULT: {		

#line 1945 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEINTR: {		

#line 1948 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
      } break;
      case WSAEINVAL: {		

#line 1952 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEINPROGRESS: {	

#line 1955 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
      } break;
      case WSAEMFILE: {		

#line 1959 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 277); }
      } break;
      case WSAENETDOWN: {	

#line 1963 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
      } break;
      case WSAENOBUFS: {	

#line 1967 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_MEMORY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
      } break;
      case WSAENOTSOCK: {	

#line 1971 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEOPNOTSUPP: {	

#line 1974 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEWOULDBLOCK: {	

#line 1977 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
    }
#else
    dk3sf_report_errno(app, err, dk3socket_function_names[4]);
    switch(err) {
#if defined(EAGAIN) && defined(EWOULDBLOCK)
#if EAGAIN == EWOULDBLOCK
      case EAGAIN: {
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
#else
      case EAGAIN: {
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
      case EWOULDBLOCK: {
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
#endif
#else
#ifdef EAGAIN
      case EAGAIN: {
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
#endif
#ifdef EWOULDBLOCK
      case EWOULDBLOCK: {
        if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      } break;
#endif
#endif
#ifdef EBADF
      case EBADF: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
#endif
#ifdef ECONNABORTED
      case ECONNABORTED: {
        if(ec) { *ec = DK3_ERROR_CONNECTION_ABORTED; }
      } break;
#endif
#ifdef EFAULT
      case EFAULT: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
#endif
#ifdef EINTR
      case EINTR: {
        if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      } break;
#endif
#ifdef EINVAL
      case EINVAL: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
#endif
#ifdef EMFILE
      case EMFILE: {
        if(ec) { *ec = DK3_ERROR_PROCESS_TABLE_OVERFLOW; }
      } break;
#endif
#ifdef ENFILE
      case ENFILE: {
        if(ec) { *ec = DK3_ERROR_TOO_MANY_OPEN_FILES; }
      } break;
#endif
#if defined(ENOBUFS) && defined(ENOMEM)
#if ENOBUFS == ENOMEM
      case ENOBUFS: {
        if(ec) { *ec = DK3_ERROR_MEMORY; }
      } break;
#else
      case ENOBUFS: {
        if(ec) { *ec = DK3_ERROR_MEMORY; }
      } break;
      case ENOMEM: {
        if(ec) { *ec = DK3_ERROR_MEMORY; }
      } break;
#endif
#else
#ifdef ENOBUFS
      case ENOBUFS: {
        if(ec) { *ec = DK3_ERROR_MEMORY; }
      } break;
#endif
#ifdef ENOMEM
      case ENOMEM: {
        if(ec) { *ec = DK3_ERROR_MEMORY; }
      } break;
#endif
#endif
#ifdef ENOTSOCK
      case ENOTSOCK: {
	if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
#endif
#ifdef EOPNOTSUPP
      case EOPNOTSUPP: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
#endif
#ifdef EPROTO
      case EPROTO: {
        if(ec) { *ec = DK3_ERROR_NETWORK_PROTOCOL; }
      } break;
#endif
#ifdef EPERM
      case EPERM: {
        if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      } break;
#endif
#ifdef ENODEV
      case ENODEV: {	

#line 2090 "dk3sock.ctr"
        /* ERROR: Configuration files do not contain family and type */
	if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
#endif
#ifdef ENOSR
      case ENOSR: {	

#line 2096 "dk3sock.ctr"
        /* ERROR: Insufficient streams resources */
        if(ec) { *ec = DK3_ERROR_RESOURCES; }
      } break;
#endif
    }
#endif
}



void
dk3socket_error_send(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_DURING_WRITE; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 2114 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 2118 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEACCES: {		

#line 2122 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 324); }
    } break;
    case WSAEINTR: {		

#line 2126 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 2130 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEFAULT: {		

#line 2134 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENETRESET: {	

#line 2137 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAENOBUFS: {		

#line 2141 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAENOTCONN: {		

#line 2145 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAENOTSOCK: {		

#line 2149 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEOPNOTSUPP: {	

#line 2152 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAESHUTDOWN: {	

#line 2155 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEWOULDBLOCK: {	

#line 2158 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEMSGSIZE: {		

#line 2161 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_LARGE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 245); }
    } break;
    case WSAEHOSTUNREACH: {	

#line 2165 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_HOST_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 326); }
    } break;
    case WSAEINVAL: {		

#line 2169 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAECONNABORTED: {	

#line 2172 "dk3sock.ctr"
        if(ec) { *ec = DK3_ERROR_CONNECTION_ABORTED; }
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 318); }
    } break;
    case WSAECONNRESET: {	

#line 2176 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAETIMEDOUT: {	

#line 2180 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
    } break;
    case WSAEADDRNOTAVAIL: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_NOT_AVAILABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 325); }
    } break;
    case WSAEAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAEDESTADDRREQ: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_REQUIRED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 308); }
    } break;
    case WSAENETUNREACH: {
      if(ec) { *ec = DK3_ERROR_NETWORK_UNREACHABLE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 298); }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[5]);
  switch(err) {
#ifdef EACCES
    case EACCES: {
      if(ec) { *ec = DK3_ERROR_INSUFFICIENT_PERMISSIONS; }
    } break;
#endif
#if defined(EAGAIN) && defined(EWOULDBLOCK)
#if EAGAIN == EWOULDBLOCK
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#else
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case EWOULDBLOCK: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#else
#ifdef EAGAIN
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#ifdef EWOULDBLOCK
    case EWOULDBLOCK: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#endif
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ECONNRESET
    case ECONNRESET: {
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
    } break;
#endif
#ifdef EDESTADDRREQ
    case EDESTADDRREQ: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_REQUIRED; }
    } break;
#endif
#ifdef EFAULT
    case EFAULT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINTR
    case EINTR: {
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EISCONN
    case EISCONN: {
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
    } break;
#endif
#ifdef EISCON
    case EISCON: {	

#line 2270 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
    } break;
#endif
#ifdef EMSGSIZE
    case EMSGSIZE: {
      if(ec) { *ec = DK3_ERROR_TOO_LARGE; }
    } break;
#endif
#ifdef ENOBUFS
    case ENOBUFS: {
      if(ec) { *ec = DK3_ERROR_TOO_LARGE; }
    } break;
#endif
#ifdef ENOMEM
    case ENOMEM: {
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef ENOTCONN
    case ENOTCONN: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_REQUIRED; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EOPNOTSUPP
    case EOPNOTSUPP: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EPIPE
    case EPIPE: {
      if(ec) { *ec = DK3_ERROR_PIPE; }
    } break;
#endif
#ifdef ENOSR
    case ENOSR: {	

#line 2310 "dk3sock.ctr"
      /* ERROR: Insufficient streams resources! */
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef ECONNREFUSED
    case ECONNREFUSED: {	

#line 2316 "dk3sock.ctr"
      /* ERROR: Connection refused by peer */
      if(ec) { *ec = DK3_ERROR_CONNECTION_REFUSED; }
    } break;
#endif
#ifdef EIO
    case EIO: {			

#line 2322 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
#ifdef ENETDOWN
    case ENETDOWN: {		

#line 2327 "dk3sock.ctr"
      /* ERROR: Local network interface is down! */
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
    } break;
#endif
#ifdef ENETUNREACH
    case ENETUNREACH: {		

#line 2333 "dk3sock.ctr"
      /* ERROR: No route to network is present! */
      if(ec) { *ec = DK3_ERROR_NETWORK_UNREACHABLE; }
    } break;
#endif
#ifdef EAFNOSUPPORT
    case EAFNOSUPPORT: {	

#line 2339 "dk3sock.ctr"
      /* ERROR: Address can not be used with this socket! */
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
    } break;
#endif
#ifdef ELOOP
    case ELOOP: {		

#line 2345 "dk3sock.ctr"
      /* ERROR: Too many symbolic links in path name! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENAMETOOLONG
    case ENAMETOOLONG: {	

#line 2351 "dk3sock.ctr"
      /* ERROR: Path name too long! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOENT
    case ENOENT: {		

#line 2357 "dk3sock.ctr"
      /* COmponent in path name names nonexisting file or directory! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOTDIR
    case ENOTDIR: {		

#line 2363 "dk3sock.ctr"
      /* ERROR: Component in path name is not a directory! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EHOSTUNREACH
    case EHOSTUNREACH: {	

#line 2369 "dk3sock.ctr"
      /* ERROR: Host unreachable! */
      if(ec) { *ec = DK3_ERROR_HOST_UNREACHABLE; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_recv(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_DURING_READ; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 314); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEFAULT: {		

#line 2395 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENOTCONN: {		

#line 2398 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAEINTR: {		

#line 2402 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 2406 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAENETRESET: {	

#line 2410 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAENOTSOCK: {		

#line 2414 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEOPNOTSUPP: {	

#line 2417 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAESHUTDOWN: {	

#line 2420 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEWOULDBLOCK: {	

#line 2423 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEMSGSIZE: {		

#line 2426 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TOO_LARGE; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 245); }
    } break;
    case WSAEINVAL: {		

#line 2430 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
    case WSAEISCONN: {		

#line 2433 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_ALREADY_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 297); }
    } break;
    case WSAECONNABORTED: {	

#line 2437 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_ABORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 318); }
    } break;
    case WSAETIMEDOUT: {	

#line 2441 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
    } break;
    case WSAECONNRESET: {	

#line 2445 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[6]);
  switch(err) {
#if defined(EAGAIN) && defined(EWOULDBLOCK)
#if EAGAIN == EWOULDBLOCK
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#else
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 306); }
    } break;
    case EWOULDBLOCK: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#else
#ifdef EAGAIN
    case EAGAIN: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#ifdef EWOULDBLOCK
    case EWOULDBLOCK: {
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
#endif
#endif
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ECONNREFUSED
    case ECONNREFUSED: {
      if(ec) { *ec = DK3_ERROR_CONNECTION_REFUSED; }
    } break;
#endif
#ifdef EFAULT
    case EFAULT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINTR
    case EINTR: {
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOMEM
    case ENOMEM: {
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef ENOTCONN
    case ENOTCONN: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_REQUIRED; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EIO
    case EIO: {		

#line 2520 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
#ifdef ENOSR
    case ENOSR: {	

#line 2525 "dk3sock.ctr"
      /* ERROR: Insufficient streams resources! */
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef ESTALE
    case ESTALE: {	

#line 2531 "dk3sock.ctr"
      /* ERROR: Stale NFS file handle! */
      if(ec) { *ec = DK3_ERROR_STALE_NFS_FILE_HANDLE; }
    } break;
#endif
#ifdef ECONNRESET
    case ECONNRESET: {	

#line 2537 "dk3sock.ctr"
      /* ERROR: Connection forcibly closed by peer! */
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
    } break;
#endif
#ifdef EOPNOTSUPP
    case EOPNOTSUPP: {	

#line 2543 "dk3sock.ctr"
      /* ERROR: Specified flags are not supported! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOBUFS
    case ENOBUFS: {	

#line 2549 "dk3sock.ctr"
      /* ERROR: Insufficient resources! */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef ETIMEDOUT
    case ETIMEDOUT: {	

#line 2555 "dk3sock.ctr"
      /* ERROR: Connection timed out! */
      if(ec) { *ec = DK3_ERROR_TIMEOUT; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_select(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 336); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 2573 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAEFAULT: {		

#line 2577 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 294); }
    } break;
    case WSAENETDOWN: {		

#line 2581 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINVAL: {		

#line 2585 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINTR: {		

#line 2588 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEINPROGRESS: {	

#line 2592 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAENOTSOCK: {		

#line 2596 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[7]);
  switch(err) {
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINTR
    case EINTR: {
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOMEM
    case ENOMEM: {
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_close(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 280); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 2636 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 2640 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAENOTSOCK: {		

#line 2644 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINPROGRESS: {	

#line 2647 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINTR: {		

#line 2651 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
    case WSAEWOULDBLOCK: {	

#line 2655 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_WOULD_BLOCK; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[8]);
  switch(err) {
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINTR
    case EINTR: {
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
    } break;
#endif
#ifdef EIO
    case EIO: {
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
#ifdef ENOLINK
    case ENOLINK: {	

#line 2678 "dk3sock.ctr"
      /* ERROR: Remote file descriptr, server not available! */
      if(ec) { *ec = DK3_ERROR_STALE_NFS_FILE_HANDLE; }
    } break;
#endif
#ifdef ENOSPC
    case ENOSPC: {	

#line 2684 "dk3sock.ctr"
      /* ERROR: No free space left on device! */
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
    default: {
      if(ec) { *ec = DK3_ERROR_SYSTEM; }
    } break;
  }
#endif
}



void
dk3socket_error_inet_pton(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 337); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSAEAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 275); }
    } break;
    case WSAEFAULT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[9]);
  switch(err) {
#ifdef EAFNOSUPPORT
    case EAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_ADDRESS_FAMILY_NOT_SUPPORTED; }
    } break;
#endif
#ifdef ENOSPC
    case ENOSPC: {	

#line 2722 "dk3sock.ctr"
      /* ERROR: Inadequate result buffer size! */
      if(ec) { *ec = DK3_ERROR_IO; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_getaddrinfo(int *ec, dk3_app_t *app, int err)
{
#if (DK3_CHAR_SIZE == 1) && DK3_HAVE_STRERROR && (!DK3_ON_WINDOWS)
  dkChar const	*msgarray[2];
#if DK3_HAVE_GETENV && DK3_HAVE_SETLOCALE
  char const	*oldlocale = NULL;
  char const	*langptr = NULL;
#endif
#endif
  

#line 2743 "dk3sock.ctr"
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 338); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSATRY_AGAIN: {
      if(ec) { *ec = DK3_ERROR_HOST_NOT_FOUND; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 289);}
    } break;
    case WSAEINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSANO_RECOVERY: {
      if(ec) { *ec = DK3_ERROR_HOST_NOT_FOUND; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 288);}
    } break;
    case WSAEAFNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSA_NOT_ENOUGH_MEMORY: {
      if(ec) { *ec = DK3_ERROR_MEMORY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 9); }
    } break;
    case WSAHOST_NOT_FOUND: {
      if(ec) { *ec = DK3_ERROR_HOST_NOT_FOUND; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286);}
    } break;
    case WSATYPE_NOT_FOUND: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAESOCKTNOSUPPORT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  /* dk3sf_report_errno(app, err, dk3socket_function_names[10]); */
#if (DK3_CHAR_SIZE == 1) && DK3_HAVE_STRERROR && (!DK3_ON_WINDOWS)
#if DK3_HAVE_GETENV && DK3_HAVE_SETLOCALE
  langptr = getenv("LANG");
  if(langptr) {
    oldlocale = setlocale(LC_MESSAGES, langptr);
  }
#endif
  msgarray[0] = dk3socket_function_names[10];
  errno = 0;
  msgarray[1] = gai_strerror(err);
  if(msgarray[1]) {
    if(0 == errno) {
      if(app) {
        dk3app_log_3(
          app, DK3_LL_ERROR, msgarray, 0, 1, dk3socket_function_names[13]
        );
      }
    }
  }
#if DK3_HAVE_GETENV && DK3_HAVE_SETLOCALE
  if(langptr) {
    if(oldlocale) { setlocale(LC_MESSAGES, oldlocale); }
  }
#endif
#endif
  switch(err) {
#ifdef EAI_ADDRFAMILY
    case EAI_ADDRFAMILY: {
      if(ec) { *ec =DK3_ERROR_HOST_NOT_FOUND; }
    } break;
#endif
#ifdef EAI_AGAIN
    case EAI_AGAIN: {
      if(ec) { *ec =DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef EAI_BADFLAGS
    case EAI_BADFLAGS: {
      if(ec) { *ec =DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EAI_FAIL
    case EAI_FAIL: {
      if(ec) { *ec =DK3_ERROR_HOST_NOT_FOUND; }
    } break;
#endif
#ifdef EAI_FAMILY
    case EAI_FAMILY: {
      if(ec) { *ec =DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EAI_MEMORY
    case EAI_MEMORY: {
      if(ec) { *ec =DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef EAI_NODATA
    case EAI_NODATA: {
      if(ec) { *ec =DK3_ERROR_HOST_NOT_FOUND; }
    } break;
#endif
#ifdef EAI_NONAME
    case EAI_NONAME: {
      if(ec) { *ec =DK3_ERROR_HOST_NOT_FOUND; }
    } break;
#endif
#ifdef EAI_SERVICE
    case EAI_SERVICE: {
      if(ec) { *ec =DK3_ERROR_HOST_NOT_FOUND; }
    } break;
#endif
#ifdef EAI_SOCKTYPE
    case EAI_SOCKTYPE: {
      if(ec) { *ec =DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EAI_OVERFLOW
    case EAI_OVERFLOW: {
      if(ec) { *ec =DK3_ERROR_TOO_LARGE; }
    } break;
#endif
#ifdef EAI_SYSTEM
    case EAI_SYSTEM: {
      if(ec) { *ec =DK3_ERROR_SYSTEM; }
    } break;
#endif
  }
#endif
  

#line 2867 "dk3sock.ctr"
}



void
dk3socket_error_gethostbyname(int *ec, dk3_app_t *app, int err, char const *hn)
{
  if(app) {
    if(hn) {
#if DK3_CHAR_SIZE == 1
      dk3app_log_i3(app, DK3_LL_ERROR, 284, 285, hn);
#else
      dk3app_log_i1(app, DK3_LL_ERROR, 286);
#endif
    } else {
      dk3app_log_i1(app, DK3_LL_ERROR, 286);
    }
  }
  if(ec) { *ec = DK3_ERROR_HOST_NOT_FOUND; }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {	

#line 2889 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 2893 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAHOST_NOT_FOUND: {	

#line 2897 "dk3sock.ctr"
    } break;
    case WSATRY_AGAIN: {	

#line 2899 "dk3sock.ctr"
    } break;
    case WSANO_RECOVERY: {	

#line 2901 "dk3sock.ctr"
    } break;
    case WSANO_DATA: {		

#line 2903 "dk3sock.ctr"
    } break;
    case WSAEINPROGRESS: {	

#line 2905 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEFAULT: {		

#line 2909 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINTR: {		

#line 2912 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INTERRUPTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 281); }
    } break;
  }
#else
  switch(err) {
#ifdef HOST_NOT_FOUND
    case HOST_NOT_FOUND: {	

#line 2920 "dk3sock.ctr"
    } break;
#endif
#ifdef TRY_AGAIN
    case TRY_AGAIN: {		

#line 2924 "dk3sock.ctr"
    } break;
#endif
#ifdef NO_RECOVERY
    case NO_RECOVERY: {		

#line 2928 "dk3sock.ctr"
    } break;
#endif
#if defined(NO_DATA) && defined(NO_ADDRESS)
#if NO_DATA == NO_ADDRESS
    case NO_DATA: {		

#line 2933 "dk3sock.ctr"
    } break;
#else
    case NO_DATA: {		

#line 2936 "dk3sock.ctr"
    } break;
    case NO_ADDRESS: {		

#line 2938 "dk3sock.ctr"
    } break;
#endif
#else
#ifdef NO_DATA
    case NO_DATA: {		

#line 2943 "dk3sock.ctr"
    } break;
#endif
#ifdef NO_ADDRESS
    case NO_ADDRESS: {		

#line 2947 "dk3sock.ctr"
    } break;
#endif
#endif
  }
#endif
}



#if DK3_ON_WINDOWS

/**	Report error from bringing WinSock up (Windows only).
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	err	Error code from WSAStartUp.
*/
static
void
dk3socket_error_up(int *ec, dk3_app_t *app, int err)
{
  /* ERROR: Failed to bring Windows sockets up. */
  switch(err) {
    case WSASYSNOTREADY: {	

#line 2970 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAVERNOTSUPPORTED: {	

#line 2974 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_PROTOCOL_NOT_SUPPORTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 327); }
    } break;
    case WSAEINPROGRESS: {	

#line 2978 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEPROCLIM: {		

#line 2982 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 328); }
    } break;
    case WSAEFAULT: {		

#line 2986 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
}



/**	Report error from bringing WinSock down (Windows only).
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	err	Error code from WSAStartUp.
*/
static
void
dk3socket_error_down(int *ec, dk3_app_t *app, int err)
{
  /* ERROR: Failed to bring Winsock subsystem down! */
  switch(err) {
    case WSANOTINITIALISED: {	

#line 3005 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {		

#line 3009 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINPROGRESS: {	

#line 3013 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
  }
}



#endif



void
dk3socket_error_shutdown(int *ec, dk3_app_t *app, int err)
{
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 315); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAEINPROGRESS: {
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAENOTCONN: {
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[11]);
  switch(err) {
#ifdef EBADF
    case EBADF: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOMEM
    case ENOMEM: {
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef ENOSR
    case ENOSR: {
      if(ec) { *ec = DK3_ERROR_RESOURCES; }
    } break;
#endif
#ifdef ENOTCONN
    case ENOTCONN: {
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {	

#line 3085 "dk3sock.ctr"
      /* ERROR: how argument is invalid! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOBUFS
    case ENOBUFS: {	

#line 3091 "dk3sock.ctr"
      /* ERROR: Insufficient resources! */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
  }
#endif
}



void
dk3socket_error_setsockopt(int *ec, dk3_app_t *app, int err)
{
  

#line 3105 "dk3sock.ctr"
  if(ec) { *ec = DK3_ERROR_IO; }
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 339); }
#if DK3_ON_WINDOWS
  switch(err) {
    case WSANOTINITIALISED: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
    } break;
    case WSAENETDOWN: {
      if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
    } break;
    case WSAEINPROGRESS: {
      if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
    } break;
    case WSAEINVAL: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENETRESET: {
      if(ec) { *ec = DK3_ERROR_CONNECTION_RESET; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 307); }
    } break;
    case WSAENOPROTOOPT: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
    case WSAENOTCONN: {
      if(ec) { *ec = DK3_ERROR_SOCKET_NOT_CONNECTED; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 316); }
    } break;
    case WSAENOTSOCK: {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
  }
#else
  dk3sf_report_errno(app, err, dk3socket_function_names[12]);
  switch(err) {
#if defined(ENOMEM) && defined(ENOBUFS)
#if ENOMEM == ENOBUFS
    case ENOMEM: {	

#line 3145 "dk3sock.ctr"
      /* ERROR: Insufficient memory */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#else
    case ENOMEM: {	

#line 3150 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
    case ENOBUFS: {	

#line 3153 "dk3sock.ctr"
      /* ERROR: Insufficient buffer resources. */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#else
#ifdef ENOMEM
    case ENOMEM: {	

#line 3160 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#ifdef ENOBUFS
    case ENOBUFS: {	

#line 3165 "dk3sock.ctr"
      /* */
      if(ec) { *ec = DK3_ERROR_MEMORY; }
    } break;
#endif
#endif
#ifdef EBADF
    case EBADF: {		

#line 3172 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EFAULT
    case EFAULT: {		

#line 3177 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EINVAL
    case EINVAL: {		

#line 3182 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOPROTOOPT
    case ENOPROTOOPT: {		

#line 3187 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef ENOTSOCK
    case ENOTSOCK: {		

#line 3192 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EDOM
    case EDOM: {		

#line 3197 "dk3sock.ctr"
      /* ERROR: Timeout values too big! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
#ifdef EISCONN
    case EISCONN: {		

#line 3203 "dk3sock.ctr"
      /* ERROR: Socket already connected, too late to set option! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    } break;
#endif
  }
#endif
  

#line 3210 "dk3sock.ctr"
}



void
dk3socket_ip4addr_set_localhost(struct sockaddr_in *sp)
{
  if(sp) {
    dk3mem_res((void *)sp, sizeof(struct sockaddr_in));
    sp->sin_family = AF_INET;
    (sp->sin_addr).s_addr = htonl(0x7F000001UL);
  }
}



#if DK3_HAVE_STRUCT_SOCKADDR_IN6
void
dk3socket_ip6addr_set_localhost(struct sockaddr_in6 *sp)
{
  if(sp) {
    dk3mem_res((void *)sp, sizeof(struct sockaddr_in6));
    sp->sin6_family = AF_INET6;
    sp->sin6_addr.s6_addr[15] = 0x01;
  }
}

int
dk3socket_ip6addr_to_text(dkChar *dp, size_t szdp, IN6_ADDR const *ia6)
{
  dkChar		bu[32];
  size_t		i;
  size_t		szx;
  int			back = 0;
  unsigned char		uc1;
  unsigned char		uc2;
  unsigned short	us;

  if((dp) && (szdp >= 40) && (ia6)) {
    back = 1;
    for(i = 0; i < 8; i++) {
      uc1 = ia6->s6_addr[2 * i];
      uc2 = ia6->s6_addr[2 * i + 1];
      us = (((unsigned short)uc1) << 8) & 0xFF00U;
      us |= (((unsigned short)uc2) & 0x00FFU);
#if VERSION_BEFORE_20140716
      dk3sf_sprintf3(bu,dk3socket_function_names[18],((int)us & 0xFFFF));
      if(i) {
        dk3str_cat(dp, dk3socket_function_names[15]);
        dk3str_cat(dp, bu);
      } else {
        dk3str_cpy_not_overlapped(dp, bu);
      }
#else
      if (dk3ma_um_to_hex_string(bu, DK3_SIZEOF(bu,dkChar), (dk3_um_t)us, 0)) {
        if(i) {
	  szx = dk3str_len(dp) + dk3str_len(dk3socket_function_names[15])
	      + dk3str_len(bu);
	  if (szx < szdp) {
            dk3str_cat(dp, dk3socket_function_names[15]);
            dk3str_cat(dp, bu);
	  } else {
	    back = 0;
	  }
        } else {
	  szx = dk3str_len(dp) + dk3str_len(bu);
	  if (szx < szdp) {
            dk3str_cpy_not_overlapped(dp, bu);
	  } else {
	    back = 0;
	  }
        }
      }
#endif
    }
  }
  return back;
}
#endif



int
dk3socket_ip4addr_to_text(dkChar *dp, size_t szdp, IN_ADDR const *ia4)
{
#if VERSION_BEFORE_20140716
  dkChar		bu[32];
  unsigned long		ul;
  int			back = 0;
  if((dp) && (szdp >= 16) && (ia4)) {
    ul = ntohl(ia4->s_addr);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul >> 24) & 0x000000FFUL));
    dk3str_cpy_not_overlapped(dp, bu);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul >> 16) & 0x000000FFUL));
    dk3str_cat(dp, dk3socket_function_names[17]);
    dk3str_cat(dp, bu);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul >>  8) & 0x000000FFUL));
    dk3str_cat(dp, dk3socket_function_names[17]);
    dk3str_cat(dp, bu);
    dk3sf_sprintf3(bu,dk3socket_function_names[16],((ul      ) & 0x000000FFUL));
    dk3str_cat(dp, dk3socket_function_names[17]);
    dk3str_cat(dp, bu);
    back = 1;
  }
  return back;
#else
  dkChar		 bu1[32];
  dkChar		 bu2[32];
  dkChar		 bu3[32];
  dkChar		 bu4[32];
  size_t		 sz;
  unsigned long		 ul;
  int			 back = 0;
  if ((NULL != dp) && (16 <= szdp) && (ia4)) {
    ul = ntohl(ia4->s_addr);
    back = dk3ma_um_to_string(
      bu1, DK3_SIZEOF(bu1,dkChar), (dk3_um_t)((ul >> 24) & 0x000000FFUL)
    );
    if (0 != back) {
      back = dk3ma_um_to_string(
        bu2, DK3_SIZEOF(bu2,dkChar), (dk3_um_t)((ul >> 16) & 0x000000FFUL)
      );
      if (0 != back) {
        back = dk3ma_um_to_string(
	  bu3, DK3_SIZEOF(bu3,dkChar), (dk3_um_t)((ul >> 8) & 0x000000FFUL)
	);
	if (0 != back) {
	  back = dk3ma_um_to_string(
	    bu4, DK3_SIZEOF(bu4,dkChar), (dk3_um_t)(ul & 0x000000FFUL)
	  );
	  if (0 != back) {
	    back = 0;
	    sz = dk3str_len(bu1) + dk3str_len(bu2) + dk3str_len(bu3)
	         + dk3str_len(bu4) + 4;
	    if (sz < szdp) {
	      back = 1;
	      dk3str_cpy_not_overlapped(dp, bu1);
	      dk3str_cat(dp, dk3socket_function_names[17]);
	      dk3str_cat(dp, bu2);
	      dk3str_cat(dp, dk3socket_function_names[17]);
	      dk3str_cat(dp, bu3);
	      dk3str_cat(dp, dk3socket_function_names[17]);
	      dk3str_cat(dp, bu4);
	    }
	  }
	}
      }
    }
  }
  return back;
#endif
}



int
dk3socket_ipaddr_to_text(dkChar *dp, size_t szdp, void const *ia, size_t sz)
{
  dkChar			 mybu[64];
  struct sockaddr const		*soa;
  struct sockaddr_in const	*so4;
#ifdef AF_INET6
  struct sockaddr_in6 const	*so6;
#endif
  dkChar			*ptr;
  size_t			 sl;
  unsigned			 u;
  int				 back = 0;
  

#line 3379 "dk3sock.ctr"
  if((dp) && (szdp) && (ia) && (sz)) {		

#line 3380 "dk3sock.ctr"
    soa = (struct sockaddr const *)ia;
    if((AF_INET == soa->sa_family) && (sz == sizeof(struct sockaddr_in))) {
      so4 = (struct sockaddr_in const *)ia;		

#line 3383 "dk3sock.ctr"
      u = (unsigned)(ntohs(so4->sin_port));
#if VERSION_BEFORE_20140716
      dk3sf_sprintf3(mybu, dk3socket_function_names[19], u);
      if((1 + dk3str_len(mybu)) < szdp) {
        dk3str_cpy_not_overlapped(dp, mybu);
        ptr = dp; while(*ptr) { ptr++; }
        sl = dk3str_len(dp);
        back = dk3socket_ip4addr_to_text(ptr, (szdp - sl), &(so4->sin_addr));
      }
#else
      if (dk3ma_um_to_string(mybu, DK3_SIZEOF(mybu,dkChar), (dk3_um_t)u)) {
        if((2 + dk3str_len(mybu)) < szdp) {
          dk3str_cpy_not_overlapped(dp, mybu);
          ptr = dp; while(*ptr) { ptr++; }
	  *(ptr++) = dkT('@');
	  *ptr = dkT('\0');
          sl = dk3str_len(dp);
          back = dk3socket_ip4addr_to_text(ptr, (szdp - sl), &(so4->sin_addr));
        }
      }
#endif
    } else {
#ifdef AF_INET6
      if((AF_INET6 == soa->sa_family) && (sz == sizeof(struct sockaddr_in6))) {
        so6 = (struct sockaddr_in6 const *)ia;	

#line 3408 "dk3sock.ctr"
	u = (unsigned)(ntohs(so6->sin6_port));
#if VERSION_BEFORE_20140716
	dk3sf_sprintf3(mybu, dk3socket_function_names[19], u);
	if((1 + dk3str_len(mybu)) < szdp) {
	  dk3str_cpy_not_overlapped(dp, mybu);
	  ptr = dp; while(*ptr) { ptr++; }
	  sl = dk3str_len(dp);
	  back = dk3socket_ip6addr_to_text(ptr, (szdp - sl), &(so6->sin6_addr));
	}
#else
	if (dk3ma_um_to_string(mybu, DK3_SIZEOF(mybu,dkChar), (dk3_um_t)u)) {
	  if((2 + dk3str_len(mybu)) < szdp) {
	    dk3str_cpy_not_overlapped(dp, mybu);
	    ptr = dp; while(*ptr) { ptr++; }
	    *(ptr++) = dkT('@');
	    *ptr = dkT('\0');
	    sl = dk3str_len(dp);
	    back = dk3socket_ip6addr_to_text(ptr,(szdp - sl),&(so6->sin6_addr));
	  }
	}
#endif
      } else {
#endif

#ifdef AF_INET6
      }
#endif
    }
  } 

#line 3437 "dk3sock.ctr"
  return back;
}



/**	Report success from listen().
	@param	app	Application structure for diagnostics.
	@param	so	Socket.
	@param	addr	Local address we are listening on.
	@param	szaddr	Address size.
*/
static
void
dk3socket_report_listen_success(
  dk3_app_t	*app,
  dk3_socket_t	 so,
  void		*addr,
  size_t	 szaddr
)
{
  dkChar	 bu[128];
  dkChar	 sb[128];
  int		 convres;	/* Address conversion result. */
  if(app) {
    if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
      convres = dk3socket_ipaddr_to_text(
        bu, DK3_SIZEOF(bu,dkChar), addr, szaddr
      );
      if(convres) {
#if VERSION_BEFORE_20140716
        dk3sf_sprintf3(sb,dkT("%d"),((int)so));
	dk3app_log_i5(app, DK3_LL_PROGRESS, 372, 373, 374, sb, bu);
#else
	convres = dk3ma_im_to_string(sb, DK3_SIZEOF(sb,dkChar), (dk3_im_t)so);
	if (0 != convres) {
	  dk3app_log_i5(app, DK3_LL_PROGRESS, 372, 373, 374, sb, bu);
	}
#endif
      }
    }
  }
}



/**	Report success from connect().
	@param	app	Application structure for diagnostics.
	@param	so	Socket.
	@param	addr	Local address we are listening on.
	@param	szaddr	Address size.
*/
static
void
dk3socket_report_connect_success(
  dk3_app_t	*app,
  dk3_socket_t	 so,
  void		*addr,
  size_t	 szaddr
)
{
  dkChar	 bu[128];
  dkChar	 sb[128];
  int		 convres;	/* Address conversion result. */
  if(app) {
    if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
      convres = dk3socket_ipaddr_to_text(
        bu, DK3_SIZEOF(bu,dkChar), addr, szaddr
      );
      if(convres) {
#if VERSION_BEFORE_20140716
        dk3sf_sprintf3(sb,dkT("%d"),((int)so));
	dk3app_log_i5(app, DK3_LL_PROGRESS, 375, 376, 377, sb, bu);
#else
	convres = dk3ma_im_to_string(sb, DK3_SIZEOF(sb,dkChar), (dk3_im_t)so);
	if (0 != convres) {
	  dk3app_log_i5(app, DK3_LL_PROGRESS, 375, 376, 377, sb, bu);
	}
#endif
      }
    }
  }
}



/**	Obtain last error code for sockets.
	@param	ec	Error code from errno.
	@return	Result from WSAGetLastError() on Windows, ec on all other
	systems.
*/
static
int
dk3socket_error(int ec)
{
#if DK3_ON_WINDOWS
  int back;
  back = WSAGetLastError();
  return back;
#else
  return ec;
#endif
}



dk3_socket_t
dk3socket_open(
  int		 af,
  int		 tp,
  int		 pr,
  int		*ec,
  dk3_app_t	*app
)
{
  dk3_socket_t		 back;
  int			 err;	/* Error code. */
  

#line 3554 "dk3sock.ctr"
  back = socket(af, tp, pr);
  if(INVALID_SOCKET == back) {
    err = dk3socket_error(errno);
    dk3socket_error_socket(ec, app, err);
  } 

#line 3559 "dk3sock.ctr"
  return back;
}



int
dk3socket_bind(
  dk3_socket_t		 sock,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  int			*ec,
  dk3_app_t		*app
)
{
  dkChar		 bu[64];	/* Port number buffer. */
#if VERSION_BEFORE_20140716
  dkChar		*ptr;
#endif
  dkChar		*lat;	/* Local address text. */
  int			 res;	/* Result from bind(). */
  int			 err;	/* Error code. */
  int			 conr;	/* Address conversion result. */
  int			 back = 0;
  

#line 3583 "dk3sock.ctr"
  if((INVALID_SOCKET != sock) && (pAddr) && (szAddr)) {
    res = bind(sock, pAddr, (int)szAddr);
    if(0 == res) {
      back = 1;
    } else {
      err = dk3socket_error(errno);
      lat = NULL;
      switch(pAddr->sa_family) {
#ifdef AF_UNIX
        case AF_UNIX: {
#if DK3_CHAR_SIZE == 1
	  struct sockaddr_un	*soun;
	  soun = (struct sockaddr_un *)pAddr;
	  lat = soun->sun_path;
#endif
	} break;
#endif
	case AF_INET: {
#if VERSION_BEFORE_20140716
	  struct sockaddr_in	*soin;
	  unsigned u;
	  soin = (struct sockaddr_in *)pAddr;
	  u = (unsigned)(ntohs(soin->sin_port));
	  dk3sf_sprintf3(bu,dk3socket_function_names[19], u);
	  ptr = bu;
	  while(*ptr) { ptr++; }
	  *(ptr++) = dkT('@');
	  *ptr = dkT('\0');
	  dk3socket_ip4addr_to_text(
	    ptr,
	    (DK3_SIZEOF(bu,dkChar) - dk3str_len(bu)),
	    &(soin->sin_addr)
	  );
	  lat = bu;
#else
	  conr = dk3socket_ipaddr_to_text(
	    bu, DK3_SIZEOF(bu,dkChar),
	    (void const *)pAddr, sizeof(struct sockaddr_in)
	  );
	  if (0 != conr) {
	    lat = bu;
	  }
#endif
	} break;
#if defined(AF_INET6) && DK3_HAVE_STRUCT_SOCKADDR_IN6
	case AF_INET6: {
#if VERSION_BEFORE_20140716
	  struct sockaddr_in6	*soin6;
	  unsigned u;
	  soin6 = (struct sockaddr_in6 *)pAddr;
	  u = (unsigned)(ntohs(soin6->sin6_port));
	  dk3sf_sprintf3(bu,dk3socket_function_names[19], u);
	  ptr = bu;
	  while(*ptr) { ptr++; }
	  *(ptr++) = dkT('@');
	  *ptr = dkT('\0');
	  dk3socket_ip6addr_to_text(
	    ptr,
	    (DK3_SIZEOF(bu,dkChar) - dk3str_len(bu)),
	    &(soin6->sin6_addr)
	  );
	  lat = bu;
#else
	  conr = dk3socket_ipaddr_to_text(
	    bu, DK3_SIZEOF(bu,dkChar),
	    (void const *)pAddr, sizeof(struct sockaddr_in6)
	  );
	  if (0 != conr) {
	    lat = bu;
	  }
#endif
	} break;
#endif
      }
      if (NULL != lat) {
        dk3socket_error_bind(ec, app, err, lat);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 3664 "dk3sock.ctr"
  return back;
}



#if DK3_ON_WINDOWS


static
void
dk3socket_error_ioctlsocket_fionbio(
  int		*ec,
  dk3_app_t	*app,
  int		 err
)
{
    if(ec) { *ec = DK3_ERROR_SYSTEM; }
    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 339); }
    switch(err) {
      case WSANOTINITIALISED: {
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 321); }
      } break;
      case WSAENETDOWN: {
        if(ec) { *ec = DK3_ERROR_NETWORK_SUBSYSTEM_NOT_READY; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 320); }
      } break;
      case WSAEINPROGRESS: {
        if(ec) { *ec = DK3_ERROR_IN_PROGRESS; }
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 322); }
      } break;
      case WSAENOTSOCK: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
      case WSAEFAULT: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
    }
}



/**	Connect with timeout on Windows system.
	@param	so	Socket to connect.
	@param	pAddr	Pointer to address.
	@param	szaddr	Address size.
	@param	secs	Seconds for timeout.
	@param	usecs	Microseconds for timeout.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
static
int
dk3socket_connect_windows_timeout(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  int			 szaddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str
)
{
  fd_set	 	 wfds;			/* File descriptor set. */
  struct timeval	 to;			/* Timeout. */
  int			 res;			/* Operation result. */
  int			 err;			/* Error code. */
  int			 back = 0;
  res = connect(so, pAddr, szaddr);
  if(0 == res) {
    back = 1;
  } else {
    err = dk3socket_error(errno);
    switch(err) {
      /*	##### CHECK WHETHER ERROR CODE IS CORRECT!
      */
      case WSAEINPROGRESS: {
        /*	Still connecting, use select to wait.
	*/
	FD_ZERO(&wfds);
	FD_SET(so, &wfds);
	to.tv_sec = secs;
	to.tv_usec = usecs;
	res = select(((int)so + 1), NULL, &wfds, NULL, &to);
	if(SOCKET_ERROR != res) {
	  if(FD_ISSET(so, &wfds)) {
	    back = 1;
	  } else {
	    /* Timeout. */
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(res == 0) {
	    /*	Timeout.  */
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  } else {
	    /* Error in select. */
	    if(ec) { *ec = DK3_ERROR_SYSTEM; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	}
      } break;
      default: {
        /*	failed to connect.
	*/
	dk3socket_error_connect(ec, app, err, str);
      } break;
    }
  }
  return back;
}

#endif



int
dk3socket_connect_spnb(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str,
  int			 spnb,
  int			 nb
)
{
#if DK3_HAVE_SELECT && (!(DK3_ON_WINDOWS))
  fd_set	 	wfds;			/* File descriptor set. */
  struct timeval	to;			/* Timeout. */
  int			oldmode;		/* File mode before. */
  int			mustrestore = 0;	/* Flag: Resotre old mode. */
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  int			slo = 0;		/* Size of option. */
#else
  socklen_t		slo = 0;		/* Size of option. */
#endif
#endif
  int		 	res;			/* Operation result. */
  int		 	err;			/* Error code. */
  int		 	back = 0;
  

#line 3816 "dk3sock.ctr"
  if((INVALID_SOCKET != so) && (pAddr) && (szAddr)) {
    if((secs) || (usecs)) {		

#line 3818 "dk3sock.ctr"
#if DK3_HAVE_SELECT
#if DK3_ON_WINDOWS
      if(spnb) {			

#line 3821 "dk3sock.ctr"
        if(nb) {				

#line 3822 "dk3sock.ctr"
          /* Now attempt to connect */
	  back = dk3socket_connect_windows_timeout(
	    so, pAddr, (int)szAddr, secs, usecs, ec, app, str
	  );
        } else {
          unsigned long		xv;	

#line 3828 "dk3sock.ctr"
	  xv = 0x01010101UL;
	  if(0 == ioctlsocket(so, FIONBIO, &xv)) {
	    /* Now attempt to connect */
	    back = dk3socket_connect_windows_timeout(
	      so, pAddr, (int)szAddr, secs, usecs, ec, app, str
	    );
	    xv = 0UL;
	    if(0 != ioctlsocket(so, FIONBIO, &xv)) {	

#line 3836 "dk3sock.ctr"
	      err = WSAGetLastError();
	      dk3socket_error_ioctlsocket_fionbio(ec, app, err);
	      back = 0;
	    }
	  } else {			

#line 3841 "dk3sock.ctr"
	    err = WSAGetLastError();
	    dk3socket_error_ioctlsocket_fionbio(ec, app, err);
	  }
        }
      } else {				

#line 3846 "dk3sock.ctr"
        res = connect(so, pAddr, (int)szAddr);
        if(0 == res) {
          back = 1;
        } else {
          err = dk3socket_error(errno);
	  dk3socket_error_connect(ec, app, err, str);
        }
      }
#else
      mustrestore = 0;			

#line 3856 "dk3sock.ctr"
      oldmode = fcntl(so, F_GETFL);
      if(!(oldmode & O_NONBLOCK)) {
        fcntl(so, F_SETFL, (oldmode | O_NONBLOCK));
	mustrestore = 1;
      }
      res = connect(so, pAddr, (int)szAddr);
      if(0 == res) {			

#line 3863 "dk3sock.ctr"
        back = 1;
      } else {
        err = errno;
        switch(err) {
	  case EINPROGRESS: {		

#line 3868 "dk3sock.ctr"
	    FD_ZERO(&wfds);
	    FD_SET(so, &wfds);
	    to.tv_sec = secs;
	    to.tv_usec = usecs;
	    res = select(((int)so + 1), NULL, &wfds, NULL, &to);
#if DK3_ON_WINDOWS
	    if(SOCKET_ERROR != res)
#else
	    if(res > 0)
#endif
	    {				

#line 3879 "dk3sock.ctr"
	      if(FD_ISSET(so, &wfds)) {	

#line 3880 "dk3sock.ctr"
	        if(FD_ISSET(so, &wfds)) {	

#line 3881 "dk3sock.ctr"
		  err = 0;
		  slo = sizeof(int);
		  res = getsockopt(
		    so,
		    SOL_SOCKET,
		    SO_ERROR,
		    (void *)(&err),
		    &slo
		  );
		  if(0 == res) {		

#line 3891 "dk3sock.ctr"
		    if(slo == sizeof(int)) {	

#line 3892 "dk3sock.ctr"
		      if(0 == err) {		

#line 3893 "dk3sock.ctr"
			back = 1;
		      } else {			

#line 3895 "dk3sock.ctr"
			dk3socket_error_connect(ec, app, err, str);
			mustrestore = 0;
		      }
		    } else {			

#line 3899 "dk3sock.ctr"
		      /* ERROR: Not an int value from getsockopt */
		      if(ec) { *ec = DK3_ERROR_SOCKET_OPTIONS; }
		      if(app) { dk3app_log_i1(app,DK3_LL_ERROR,282); }
		      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 301); }
		      mustrestore = 0;
		    }
		  } else {			

#line 3906 "dk3sock.ctr"
		    /* ERROR while reading socket option */
		    if(ec) { *ec = DK3_ERROR_SOCKET_OPTIONS; }
		    if(app) { dk3app_log_i1(app,DK3_LL_ERROR,282); }
		    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 301); }
		    mustrestore = 0;
		  }
	        } else {			

#line 3913 "dk3sock.ctr"
	          /* TIMEOUT */
	          if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
	          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
		  mustrestore = 0;
	        }
	      } else {				

#line 3920 "dk3sock.ctr"
	        if(ec) { *ec = DK3_ERROR_TIMEOUT; }
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
		mustrestore = 0;
	      }
	    } else {				

#line 3926 "dk3sock.ctr"
	      if(res == 0) {
	        if(ec) { *ec = DK3_ERROR_TIMEOUT; }
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	      } else {
	        if(ec) { *ec = DK3_ERROR_SYSTEM; }
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	      }
	      mustrestore = 0;
	    }
	  } break;
	  default: {				

#line 3939 "dk3sock.ctr"
	    dk3socket_error_connect(ec, app, err, str);
	    mustrestore = 0;
	  } break;
	}
      }
      if(mustrestore) {
        fcntl(so, F_SETFL, oldmode);
      }
#endif
#else
      res = connect(so, pAddr, (int)szAddr);
      if(0 == res) {
        back = 1;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_connect(ec, app, err, str);
      }
#endif
    } else {					

#line 3958 "dk3sock.ctr"
      res = connect(so, pAddr, (int)szAddr);
      if(0 == res) {
        back = 1;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_connect(ec, app, err, str);
      }
    }
    if(back) {
      dk3socket_report_connect_success(app, so, (void *)pAddr, szAddr);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 3972 "dk3sock.ctr"
  return back;
}



int
dk3socket_connect_nb(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str,
  int			 nb
)
{
  int back;
  back = dk3socket_connect_spnb(
    so, pAddr, szAddr, secs, usecs, ec, app, str, 1, nb
  );
  return back;
}



int
dk3socket_connect(
  dk3_socket_t		 so,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*str
)
{
  int		back;
  back = dk3socket_connect_spnb(
    so, pAddr, szAddr, secs, usecs, ec, app, str, 0, 0
  );
  return back;
}



int
dk3socket_listen(
  dk3_socket_t	 so,
  int		 bl,
  int		*ec,
  dk3_app_t	*app
)
{
  int back = 0;
  int res;		/* Operation result. */
  int err;		/* Error code. */
  

#line 4032 "dk3sock.ctr"
  if(INVALID_SOCKET != so) {
    res = listen(so, bl);
    if(0 == res) {
      back = 1;
    } else {
      err = dk3socket_error(errno);
      dk3socket_error_listen(ec, app, err);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 4043 "dk3sock.ctr"
  return back;
}



dk3_socket_t
dk3socket_accept(
  dk3_socket_t		 ls,
  struct sockaddr	*pAddr,
  size_t		*pSzAddr,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  int			addrsize = 0;
#else
  socklen_t		addrsize = 0;
#endif
  dk3_socket_t		back = INVALID_SOCKET;
  int			err;
  if((pAddr) && (pSzAddr)) {
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
    if(pSzAddr) { addrsize = (int)(*pSzAddr); }
#else
    if(pSzAddr) { addrsize = (socklen_t)(*pSzAddr); }
#endif
  }
  if(INVALID_SOCKET != ls) {
    back = accept(ls, pAddr, ((pAddr) ? &addrsize : NULL));
    if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)addrsize; }
    if(INVALID_SOCKET == back) {
      err = dk3socket_error(errno);
      dk3socket_error_accept(ec, app, err);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



/**	Send data. This is a wrapper around the send() function from the
	BSD sockets API.
	@param	so	Socket.
	@param	bu	Buffer pointer.
	@param	sz	Buffer size in bytes.
	@param	secs	Timeout seconds.
	@param	usecs	Timeout microseconds.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Number of bytes sent.
*/
static
int
dk3socket_send_attempt(
  dk3_socket_t	 so,
  void const	*bu,
  size_t	 sz,
  long		 secs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
  int		 back = -1;
  int		 err;				/* Error code. */
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SSIZE_T))
  int		 res;				/* Operation result. */
#else
  ssize_t	 res;				/* Operation result. */
#endif
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
  fd_set	 wfds;				/* File descriptor set. */
  struct timeval to;				/* Timeout. */
  int		 selres;			/* Result from select(). */
#endif
  

#line 4122 "dk3sock.ctr"
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
      FD_ZERO(&wfds);
      FD_SET(so, &wfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), NULL, &wfds, NULL, &to);
#if DK3_ON_WINDOWS
      if(selres != SOCKET_ERROR)
#else
      if(selres > -1)
#endif
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&wfds)) {
#if DK3_ON_WINDOWS
            res = send(so, bu, (int)sz, 0);
#else
            res = send(so, bu, sz, 0);
#endif
            if(res >= 0) {
	      back = res;
	      if((size_t)res < sz) {
                if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	        if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	      }
            } else {
	      err = dk3socket_error(errno);
              dk3socket_error_send(ec, app, err);
            }
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
#else
#if DK3_ON_WINDOWS
      res = send(so, bu, (int)sz, 0);
#else
      res = send(so, bu, sz, 0);
#endif
      if(res >= 0) {
        back = res;
	if((size_t)res < sz) {
          if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	  if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	}
      } else {
        err = dk3socket_error(errno);
        dk3socket_error_send(ec, app, err);
      }
#endif
    } else {
#if DK3_ON_WINDOWS
      res = send(so, bu, (int)sz, 0);
#else
      res = send(so, bu, sz, 0);
#endif
      if(res >= 0) {
        back = res;
	if((size_t)res < sz) {
          if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	  if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	}
      } else {
        err = dk3socket_error(errno);
        dk3socket_error_send(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 4204 "dk3sock.ctr"
  return back;
}



int
dk3socket_send(
  dk3_socket_t	 so,
  void const	*bu,
  size_t	 sz,
  long		 secs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
  char const	*ptr;
  int		 back = 0;
  int		 res;
  

#line 4224 "dk3sock.ctr"
  ptr = (char const *)bu;
  do {
    res = dk3socket_send_attempt(so,(void const *)ptr,sz,secs,usecs,ec,app);
    if(-1 < res) {
      back += res;
      ptr = &(ptr[res]);
    }
  } while((back < (int)sz) && (-1 < res));
  

#line 4233 "dk3sock.ctr"
  return back;
}



int
dk3socket_recv(
  dk3_socket_t	 so,
  void		*bu,
  size_t	 sz,
  long		 secs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
  fd_set		rfds;			/* File descriptor set. */
  struct timeval	to;			/* Timeout. */
  int			selres;			/* Result from select(). */
#if !DK3_ON_WINDOWS
  int			oldmode;		/* Block/nonblock mode. */
  int			mustrestore = 0;	/* Must restore old mode. */
#endif
#endif
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SSIZE_T))
  int			res;			/* Operation result. */
#else
  ssize_t		res;			/* Operation result. */
#endif
  int			err;			/* Error code. */
  int			back = -1;
  

#line 4266 "dk3sock.ctr"
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
      FD_ZERO(&rfds);
      FD_SET(so,&rfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), &rfds, NULL, NULL, &to);
#if DK3_ON_WINDOWS
      if(selres != SOCKET_ERROR)
#else
      if(selres >= 0)
#endif
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&rfds)) {
#if DK3_ON_WINDOWS
            res = recv(so, bu, (int)sz, 0);
#else
	    mustrestore = 0;
	    oldmode = fcntl(so, F_GETFL);
	    if(!(oldmode & O_NONBLOCK)) {
	      fcntl(so, F_SETFL, (oldmode | O_NONBLOCK));
	      mustrestore = 1;
	    }
            res = recv(so, bu, sz, 0);
#endif
            if(res >= 0) {
              back = res;
            } else {
              err = dk3socket_error(errno);
	      dk3socket_error_recv(ec, app, err);
            }
#if !DK3_ON_WINDOWS
	    if(mustrestore) {
	      fcntl(so, F_SETFL, oldmode);
	    }
#endif
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      }
      else
      {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
#else
#if DK3_ON_WINDOWS
      res = recv(so, bu, (int)sz, 0);
#else
      res = recv(so, bu, sz, 0);
#endif
      if(res >= 0) {
        back = res;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_recv(ec, app, err);
      }
#endif
    } else {
#if DK3_ON_WINDOWS
      res = recv(so, bu, (int)sz, 0);
#else
      res = recv(so, bu, sz, 0);
#endif
      if(res >= 0) {
        back = res;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_recv(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 4349 "dk3sock.ctr"
  return back;
}



int
dk3socket_sendto(
  dk3_socket_t		 so,
  void const		*bu,
  size_t		 sz,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  int		 back = -1;
  int		 err;				/* Error code. */
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SSIZE_T))
  int		 res;				/* Operation result. */
#else
  ssize_t	 res;				/* Operation result. */
#endif
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
  fd_set	 wfds;				/* File descriptor set. */
  struct timeval to;				/* Timeout. */
  int		 selres;			/* Result from select(). */
#endif
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  int		 myszaddr;
#else
  socklen_t	 myszaddr;
#endif
  

#line 4385 "dk3sock.ctr"
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  myszaddr = (int)szAddr;
#else
  myszaddr = (socklen_t)szAddr;
#endif
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
      FD_ZERO(&wfds);
      FD_SET(so, &wfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), NULL, &wfds, NULL, &to);
#if DK3_ON_WINDOWS
      if(selres != SOCKET_ERROR)
#else
      if(selres > -1)
#endif
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&wfds)) {
#if DK3_ON_WINDOWS
            res = sendto(so, bu, (int)sz, 0, pAddr, myszaddr);
#else
            res = sendto(so, bu, sz, 0, pAddr, myszaddr);
#endif
            if(res >= 0) {
	      back = res;
	      if((size_t)res < sz) {
                if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	        if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	      }
            } else {
	      err = dk3socket_error(errno);
              dk3socket_error_send(ec, app, err);
            }
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
#else
#if DK3_ON_WINDOWS
      res = sendto(so, bu, (int)sz, 0, pAddr, myszaddr);
#else
      res = sendto(so, bu, sz, 0, pAddr, myszaddr);
#endif
      if(res >= 0) {
        back = res;
	if((size_t)res < sz) {
          if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	  if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	}
      } else {
        err = dk3socket_error(errno);
        dk3socket_error_send(ec, app, err);
      }
#endif
    } else {
#if DK3_ON_WINDOWS
      res = sendto(so, bu, (int)sz, 0, pAddr, myszaddr);
#else
      res = sendto(so, bu, sz, 0, pAddr, myszaddr);
#endif
      if(res >= 0) {
        back = res;
	if((size_t)res < sz) {
          if(ec) { *ec = DK3_ERROR_MESSAGE_NOT_SENT_COMPLETELY; }
	  if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 313); }
	}
      } else {
        err = dk3socket_error(errno);
        dk3socket_error_send(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 4472 "dk3sock.ctr"
  return back;
}



int
dk3socket_recvfrom(
  dk3_socket_t		 so,
  void			*bu,
  size_t		 sz,
  struct sockaddr	*pAddr,
  size_t		*pSzAddr,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
  fd_set		rfds;			/* File descriptor set. */
  struct timeval	to;			/* Timeout. */
  int			selres;			/* Result from select(). */
#if !DK3_ON_WINDOWS
  int			oldmode;		/* Block/nonblock mode. */
  int			mustrestore;		/* Flag: Restore old mode. */
#endif
#endif
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SSIZE_T))
  int			res;			/* Operation result. */
#else
  ssize_t		res;			/* Operation result. */
#endif
  int			err;			/* Error code. */
  int			back = -1;
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  int			myszaddr = 0;
#else
  socklen_t		myszaddr = 0;
#endif
  

#line 4512 "dk3sock.ctr"
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  if((pAddr) && (pSzAddr)) { myszaddr = (int)(*pSzAddr); }
#else
  if((pAddr) && (pSzAddr)) { myszaddr = (socklen_t)(*pSzAddr); }
#endif
  if((INVALID_SOCKET != so) && (bu) && (sz)) {
    if((secs) || (usecs)) {
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
      FD_ZERO(&rfds);
      FD_SET(so,&rfds);
      to.tv_sec = secs;
      to.tv_usec = usecs;
      selres = select(((int)so + 1), &rfds, NULL, NULL, &to);
#if DK3_ON_WINDOWS
      if(selres != SOCKET_ERROR)
#else
      if(selres >= 0)
#endif
      {
        if(selres > 0) {
	  if(FD_ISSET(so,&rfds)) {
#if DK3_ON_WINDOWS
            res = recvfrom(so,bu,(int)sz,0,pAddr,((pAddr) ? &myszaddr : NULL));
#else
	    mustrestore = 0;
	    oldmode = fcntl(so, F_GETFL);
	    if(!(oldmode & O_NONBLOCK)) {
	      fcntl(so, F_SETFL, (oldmode | O_NONBLOCK));
	      mustrestore = 1;
	    }
            res = recvfrom(so, bu, sz, 0, pAddr, ((pAddr) ? &myszaddr : NULL));
#endif
	    if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)myszaddr; }
            if(res >= 0) {
              back = res;
            } else {
              err = dk3socket_error(errno);
	      dk3socket_error_recv(ec, app, err);
            }
#if !DK3_ON_WINDOWS
	    if(mustrestore) {
	      fcntl(so, F_SETFL, oldmode);
	    }
#endif
	  } else {
	    if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	  }
	} else {
	  if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 305); } 
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	}
      }
      else
      {
        err = dk3socket_error(errno);
	dk3socket_error_select(ec, app, err);
      }
#else
#if DK3_ON_WINDOWS
      res = recvfrom(so, bu, (int)sz, 0, pAddr, ((pAddr) ? &myszaddr : NULL));
#else
      res = recvfrom(so, bu, sz, 0, pAddr, ((pAddr) ? &myszaddr : NULL));
#endif
      if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)myszaddr; }
      if(res >= 0) {
        back = res;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_recv(ec, app, err);
      }
#endif
    } else {
#if DK3_ON_WINDOWS
      res = recvfrom(so, bu, (int)sz, 0, pAddr, ((pAddr) ? &myszaddr : NULL));
#else
      res = recvfrom(so, bu, sz, 0, pAddr, ((pAddr) ? &myszaddr : NULL));
#endif
      if((pAddr) && (pSzAddr)) { *pSzAddr = (size_t)myszaddr; }
      if(res >= 0) {
        back = res;
      } else {
        err = dk3socket_error(errno);
	dk3socket_error_recv(ec, app, err);
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 4603 "dk3sock.ctr"
  return back;
}



int
dk3socket_close(
  dk3_socket_t	 so,
  int		*ec,
  dk3_app_t	*app
)
{
  int	res;		/* Operation result. */
  int	err;		/* Error code. */
  int	back = 0;
  

#line 4619 "dk3sock.ctr"
  if(INVALID_SOCKET != so) {
#if DK3_ON_WINDOWS
    res = closesocket(so);
#else
    res = close(so);
#endif
    if(0 == res) {
      back = 1;
    } else {
      /* ERROR: Failed to close socket! */
      err = dk3socket_error(errno);
      dk3socket_error_close(ec, app, err);
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 4635 "dk3sock.ctr"
  return back;
}



dk3_socket_t
dk3socket_invalid(void)
{
  return INVALID_SOCKET;
}



int
dk3socket_up(int *ec, dk3_app_t *app)
{
#if DK3_ON_WINDOWS
  int		back = 0;
  int		err;			/* Error code. */
  WORD		wVersionRequested;	/* Requested Winsock version. */
  WSADATA	wsaData;		/* Result data. */
  

#line 4657 "dk3sock.ctr"
  wVersionRequested = MAKEWORD(2,0);
  err = WSAStartup(wVersionRequested, &wsaData);
  if(0 == err) {
    back = 1;
  } else {
    dk3socket_error_up(ec, app, err);
  } 

#line 4664 "dk3sock.ctr"
  return back;
#else
  return 1;
#endif
}



int
dk3socket_down(int *ec, dk3_app_t *app)
{
#if DK3_ON_WINDOWS
  int		back	= 0;
  

#line 4678 "dk3sock.ctr"
  if(0 == WSACleanup()) {
    back = 1;
  } else {
    dk3socket_error_down(ec, app, WSAGetLastError());
  } 

#line 4683 "dk3sock.ctr"
  return back;
#else
  return 1;
#endif
}



int
dk3socket_inet_pton(int af, char const *hn, void *addr, int *ec, dk3_app_t *app)
{
  int		back = 0;
  int		res;		/* Result from inet_pton(). */
  

#line 4697 "dk3sock.ctr"
#if DK3_ON_WINDOWS
#if (!defined(NTDDI_VERSION)) || (NTDDI_VERSION >= NTDDI_VISTA)
  

#line 4700 "dk3sock.ctr"
  res = InetPtonA(af, hn, addr);
  switch(res) {
    case 1: {
      back = 1;
    } break;
    case 0: {
      /* ERROR: Not an IP address! */
    } break;
    case -1: {
      dk3socket_error_inet_pton(ec, app, WSAGetLastError());
    } break;
  }
#else
  if(AF_INET == af) {
    IN_ADDR	*ia;
    unsigned long ul;
    ul = 0UL;
    if(dk3enc_c8_ipaddr_to_ul_app(hn, &ul, app)) {
      ia = (IN_ADDR *)addr;
      ia->s_addr = htonl(ul);
      back = 1;
    } else {
      /* ERROR: Not an IPv4 address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    }
  }
#endif
#else
  

#line 4729 "dk3sock.ctr"
#if DK3_HAVE_INET_PTON
  

#line 4731 "dk3sock.ctr"
  res = inet_pton(af, hn, addr);
  switch(res) {
    case 1: {			

#line 4734 "dk3sock.ctr"
      back = 1;
    } break;
    case 0: {			

#line 4737 "dk3sock.ctr"
      /* ERROR: Not an IP address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) {
#if DK3_CHAR_SIZE == 1
        dk3app_log_i3(app, DK3_LL_ERROR, 348, 349, hn);
#else
        dk3app_log_i1(app, DK3_LL_ERROR, 350);
#endif
      }
    } break;
    case -1: {			

#line 4748 "dk3sock.ctr"
      dk3socket_error_inet_pton(ec, app, errno);
    } break;
  }
#else
  

#line 4753 "dk3sock.ctr"
#if DK3_HAVE_INET_ATON
  

#line 4755 "dk3sock.ctr"
  if(AF_INET == af) {		

#line 4756 "dk3sock.ctr"
    res = inet_aton(hn, (IN_ADDR *)addr);
    if(res) {			

#line 4758 "dk3sock.ctr"
      back = 1;
    } else {			

#line 4760 "dk3sock.ctr"
      /* ERROR: Not an IPv4 address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) {
#if DK3_CHAR_SIZE == 1
        dk3app_log_i3(app, DK3_LL_ERROR, 348, 349, hn);
#else
        dk3app_log_i1(app, DK3_LL_ERROR, 350);
#endif
      }
    }
  } else {
#ifdef EAFNOSUPPORT
    dk3socket_error_inet_pton(ec, app, EAFNOSUPPORT);
#endif
  }
#else
  

#line 4777 "dk3sock.ctr"
  if(AF_INET == af) {
    IN_ADDR		*ia;
    unsigned long	 ul;
    ul = 0UL;
    if(dk3enc_c8_ipaddr_to_ul_app(hn, &ul, app))
    {				

#line 4783 "dk3sock.ctr"
      ia = (IN_ADDR *)addr;
      ia->s_addr = htonl(ul);
      back = 1;
    } else {			

#line 4787 "dk3sock.ctr"
      /* ERROR: Not an IPv4 address! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    }
  } else {
#ifdef EAFNOSUPPORT
    dk3socket_error_inet_pton(ec, app, EAFNOSUPPORT);
#endif
  }
#endif
#endif
#endif
  

#line 4799 "dk3sock.ctr"
  return back;
}



int
dk3socket_set_reuse(dk3_socket_t so, int v, int *ec, dk3_app_t *app)
{
  int			 back = 0;
  int			 err;
  

#line 4810 "dk3sock.ctr"
  if(INVALID_SOCKET != so) {
#if DK3_HAVE_SETSOCKOPT && defined(SO_REUSEADDR)
    int		opt;
#if DK3_SIZEOF_INT > 2
#if DK3_SIZEOF_INT > 4
    opt = ((v) ? 0x0101010101010101 : 0);
#else
    opt = ((v) ? 0x01010101 : 0);
#endif
#else
    opt = ((v) ? 0x0101 : 0);
#endif
    if(0 == setsockopt(so,SOL_SOCKET,SO_REUSEADDR,(void *)(&opt),sizeof(opt)))
    { 

#line 4824 "dk3sock.ctr"
#ifdef SO_REUSEPORT
      if(0 == setsockopt(so,SOL_SOCKET,SO_REUSEPORT,(void *)(&opt),sizeof(opt)))
      { 

#line 4827 "dk3sock.ctr"
        back = 1;	

#line 4828 "dk3sock.ctr"
      }
      else
      { 

#line 4831 "dk3sock.ctr"
        /* ERROR: setsockopt failed! */
	err = dk3socket_error(errno);
	dk3socket_error_setsockopt(ec, app, err);
      }
#else
      back = 1;		

#line 4837 "dk3sock.ctr"
#endif
    }
    else
    { 

#line 4841 "dk3sock.ctr"
      /* ERROR: setsockopt failed! */
      err = dk3socket_error(errno);
      dk3socket_error_setsockopt(ec, app, err);
    }
#else
    /* ERROR: SO_REUSEADDR NOT DEFINED */
    

#line 4848 "dk3sock.ctr"
#endif
  } else {				

#line 4850 "dk3sock.ctr"
    /* ERROR: Not a valid socket! */
  } 

#line 4852 "dk3sock.ctr"
  return back;
}



int
dk3socket_shutdown(dk3_socket_t so, int sv, int *ec, dk3_app_t *app)
{
  int			 back = 0;
  int			 err = 0;	/* Error code. */
  if(INVALID_SOCKET != so) {
    switch(sv) {
      case DK3_TCPIP_SHUTDOWN_READ: {
#if DK3_ON_WINDOWS
	if(0 == shutdown(so, SD_RECEIVE)) {
	  back = 1;
	} else {
	  err = WSAGetLastError();
	  dk3socket_error_shutdown(ec, app, err);
	}
#else
#ifdef SHUT_RD
	if(0 == shutdown(so, SHUT_RD)) {
	  back = 1;
	} else {
	  err = dk3socket_error(errno);
	  dk3socket_error_shutdown(ec, app, err);
	}
#else
	if(0 == shutdown(so, 0)) {
	  back = 1;
	} else {
	  err = dk3socket_error(errno);
	  dk3socket_error_shutdown(ec, app, err);
	}
#endif
#endif
      } break;
      case DK3_TCPIP_SHUTDOWN_WRITE: {
#if DK3_ON_WINDOWS
	if(0 == shutdown(so, SD_SEND)) {
	  back = 1;
	} else {
	  err = WSAGetLastError();
	  dk3socket_error_shutdown(ec, app, err);
	}
#else
#ifdef SHUT_WR
	if(0 == shutdown(so, SHUT_WR)) {
	  back = 1;
	} else {
	  err = dk3socket_error(errno);
	  dk3socket_error_shutdown(ec, app, err);
	}
#else
	if(0 == shutdown(so, 1)) {
	  back = 1;
	} else {
	  err = dk3socket_error(errno);
	  dk3socket_error_shutdown(ec, app, err);
	}
#endif
#endif
      } break;
      case DK3_TCPIP_SHUTDOWN_RW: {
#if DK3_ON_WINDOWS
	if(0 == shutdown(so, SD_BOTH)) {
	  back = 1;
	} else {
	  err = WSAGetLastError();
	  dk3socket_error_shutdown(ec, app, err);
	}
#else
#ifdef SHUT_RDWR
	if(0 == shutdown(so, SHUT_RDWR)) {
	  back = 1;
	} else {
	  err = dk3socket_error(errno);
	  dk3socket_error_shutdown(ec, app, err);
	}
#else
	if(0 == shutdown(so, 2)) {
	  back = 1;
	} else {
	  err = dk3socket_error(errno);
	  dk3socket_error_shutdown(ec, app, err);
	}
#endif
#endif
      } break;
      default: {
        if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      } break;
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3socket_set_non_block(dk3_socket_t so, int v, int *ec, dk3_app_t *app)
{
  int back = 0;
  int err;
  if(INVALID_SOCKET != so) {
#if DK3_ON_WINDOWS
  unsigned long xv;
  if(v) { xv = 0x01010101UL; } else { xv = 0UL; };
  if(0 == ioctlsocket(so, FIONBIO, &xv)) {
    back = 1;
  } else {
    err = WSAGetLastError();
    dk3socket_error_ioctlsocket_fionbio(ec, app, err);
  }
#else
  int oldmode;
  oldmode = fcntl(so, F_GETFL);
  if(oldmode & O_NONBLOCK) {
    back = 1;
  } else {
    oldmode |= O_NONBLOCK;
    if(-1 != fcntl(so, F_SETFL, oldmode)) {
      back = 1;
    } else {
      err = dk3socket_error(errno);
      if(ec) { *ec = DK3_ERROR_SYSTEM; }
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 339); }
      dk3sf_report_errno(app, err, dk3socket_function_names[14]);
    }
  }
#endif
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3socket_get_non_block(dk3_socket_t so, int *ec, dk3_app_t *app)
{
  int back = -1;
  if(INVALID_SOCKET != so) {
#if DK3_ON_WINDOWS
  /* ERROR: No function implemented! */
  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 353); }
#else
  int oldmode;
  oldmode = fcntl(so, F_GETFL);
  if(oldmode & O_NONBLOCK) {
    back = 1;
  } else {
    back = 0;
  }
#endif
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



#if DK3_HAVE_STRUCT_SOCKADDR_UN

size_t
dk3socket_un_length(struct sockaddr_un const *p)
{
  size_t	back = 0;
  if(p) {
#ifdef SUN_LEN
    back = SUN_LEN(p) ;
#else
    back = sizeof(struct sockaddr_un)
           - sizeof(p->sun_path)
	   + strlen(p->sun_path);
#endif
  }
  return back;
}

dk3_socket_t
dk3socket_un_listener(char const *fn, int backlog, int *ec, dk3_app_t *app)
{
  dk3_socket_t		 back = INVALID_SOCKET;
  struct sockaddr_un	 soun;
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  int			 szs;
#else
  socklen_t		 szs;
#endif
  

#line 5048 "dk3sock.ctr"
  if(fn) {
    if(strlen(fn) < 108) {
      back = dk3socket_open(AF_UNIX, SOCK_STREAM, 0, ec, app);
      if(INVALID_SOCKET != back) {
        (void)dk3socket_set_reuse(back, 1, ec, app);
	soun.sun_family = AF_UNIX;
	strcpy(soun.sun_path, fn);
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
	szs = (int)dk3socket_un_length(&soun);
#else
	szs = (socklen_t)dk3socket_un_length(&soun);
#endif
	if(dk3socket_bind(back, (struct sockaddr *)(&soun), szs, ec, app)) {
	  if(!dk3socket_listen(back, backlog, ec, app)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	} else {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
    } else {
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 5076 "dk3sock.ctr"
  return back;
}

dk3_socket_set_t *
dk3socket_un_listeners(char const *fn, int backlog, int *ec, dk3_app_t *app)
{
  dk3_socket_set_t	*back = NULL;
  dk3_socket_t		 fd;

  fd = dk3socket_un_listener(fn, backlog, ec, app);
  if(INVALID_SOCKET != fd) {
    back = dk3socket_set_new(1, ec, app);
    if(back) {
      *(back->pData) = fd;
    } else {
      dk3socket_close(fd, ec, app);
    }
  }
  return back;
}

dk3_socket_t
dk3socket_un_stream_client(
  char const	*fn,
  long		 nsecs,
  long		 usecs,
  int		*ec,
  dk3_app_t	*app
)
{
  dk3_socket_t		back	= INVALID_SOCKET;
  struct sockaddr_un	soun;
  size_t		szs;
  int			res;

  if(fn) {
    if(strlen(fn) < 108) {
      back = dk3socket_open(AF_UNIX, SOCK_STREAM, 0, ec, app);
      if(INVALID_SOCKET != back) {
        soun.sun_family = AF_UNIX;
	strcpy(soun.sun_path, fn);
        szs = dk3socket_un_length(&soun);
        res = dk3socket_connect(
	  back, (struct sockaddr *)(&soun), szs, nsecs, usecs, ec, app,
#if DK3_CHAR_SIZE == 1
	    fn
#else
	    NULL
#endif
	);
	if(!(res)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
    } else {
      /* ERROR: Socket name too long! */
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
#if DK3_CHAR_SIZE < 2
      if(app) { dk3app_log_i3(app, DK3_LL_ERROR, 65, 66, fn); }
#endif
    }
  } else {
    /* ERROR: Invalid arguments, missing file name! */
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}


#endif



#if DK3_HAVE_GETADDRINFO || DK3_ON_WINDOWS

/*
	Section start: getaddrinfo().
*/

/**	Attempt to open a client socket.
	@param	hai	Server host address information.
	@param	lai	Client (local) host address information, may be NULL.
	@param	secs	Timeout seconds.
	@param	usecs	Timeout microseconds.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Valid socket on success, INVALID_SOCKET on error.
*/
static
dk3_socket_t
dk3socket_attempt_open_net_stream_client(
  struct addrinfo const	*hai,
  struct addrinfo const *lai,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  struct addrinfo const	*resc;		/* Results for remote addresses. */
  struct addrinfo const	*resl;		/* Results for local adddresses. */
  struct sockaddr	*soa;		/* Remote socket address. */
  struct sockaddr	*sol;		/* Local socket address. */
  dk3_socket_t		 back = INVALID_SOCKET;
  int			 found;		/* Flag: Address found. */
  int			 connres;	/* Result from bind()/connect(). */
  

#line 5184 "dk3sock.ctr"
  found = 0;
  resc = hai;
  while((resc) && (INVALID_SOCKET == back)) {		

#line 5187 "dk3sock.ctr"
    soa = resc->ai_addr;
    if(soa) {						

#line 5189 "dk3sock.ctr"
      if(lai) {						

#line 5190 "dk3sock.ctr"
        resl = lai;		

#line 5191 "dk3sock.ctr"
        while((resl) && (INVALID_SOCKET == back)) {	

#line 5192 "dk3sock.ctr"
	  sol = resl->ai_addr;	

#line 5193 "dk3sock.ctr"
	  if(sol) {					

#line 5194 "dk3sock.ctr"
	    if(soa->sa_family == sol->sa_family) {	

#line 5195 "dk3sock.ctr"
	      switch(soa->sa_family) {
	        case AF_INET:
		case AF_INET6: {			

#line 5198 "dk3sock.ctr"
		  found = 1;
		  switch(soa->sa_family) {
		    case AF_INET6: {			

#line 5201 "dk3sock.ctr"
		      back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
		    } break;
		    default: {				

#line 5204 "dk3sock.ctr"
		      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
		    } break;
		  }
		  if(INVALID_SOCKET != back) {		

#line 5208 "dk3sock.ctr"
		    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
		    connres = dk3socket_bind(
		      back, sol, resl->ai_addrlen, ec, app
		    );
		    if(connres) {			

#line 5213 "dk3sock.ctr"
	              connres = dk3socket_connect_nb(
	                back, soa, resc->ai_addrlen, secs, usecs, ec, app,
			NULL, 0
	              );
		      if(!(connres)) {			

#line 5218 "dk3sock.ctr"
		        dk3socket_close(back, NULL, NULL);
			back = INVALID_SOCKET;
		      }
		    } else {				

#line 5222 "dk3sock.ctr"
		      dk3socket_close(back, NULL, NULL);
		      back = INVALID_SOCKET;
		    }
		  } else {				

#line 5226 "dk3sock.ctr"
		  }
		} break;
		default: {				

#line 5229 "dk3sock.ctr"
		} break;
	      }
	    } else {					

#line 5232 "dk3sock.ctr"
	      /* Families do not match. */
	    }
	  } else {					

#line 5235 "dk3sock.ctr"
	  }
          resl = resl->ai_next;
        }
      } else {					

#line 5239 "dk3sock.ctr"
        switch(soa->sa_family) {
	  case AF_INET: {			

#line 5241 "dk3sock.ctr"
	    found = 1;
	    back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != back) {	

#line 5244 "dk3sock.ctr"
	      connres = dk3socket_connect_nb(
	        back, soa, resc->ai_addrlen, secs, usecs, ec, app, NULL, 0
	      );
	      if(!(connres)) {			

#line 5248 "dk3sock.ctr"
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    }
	  } break;
	  case AF_INET6: {			

#line 5254 "dk3sock.ctr"
	    back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != back) {	

#line 5256 "dk3sock.ctr"
	      connres = dk3socket_connect_nb(
	        back, soa, resc->ai_addrlen, secs, usecs, ec, app, NULL, 0
	      );
	      if(!(connres)) {			

#line 5260 "dk3sock.ctr"
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    }
	    found = 1;
	  } break;
	}
      }
    } else {					

#line 5269 "dk3sock.ctr"
    }
    resc = resc->ai_next;			

#line 5271 "dk3sock.ctr"
  }
  

#line 5273 "dk3sock.ctr"
  return back;
}



/**	Connect to a remote address using one from a set of local addresses.
	@param	af	Address family for remote address.
	@param	pAddr	Remote address.
	@param	szAddr	Remote address length.
	@param	resl	Set of local addresses.
	@param	secs	Seconds for timeout.
	@param	usecs	Microseconds for timeout.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Valid socket on success, INVALID_SOCKET on error.
*/
static
dk3_socket_t
dk3socket_attempt_open_net_stream_for_local_address(
  int			 af,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  struct addrinfo const	*resl,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  dk3_socket_t		 back = INVALID_SOCKET;
  struct addrinfo const	*resc;		/* Current address info struct. */
  struct sockaddr	*soa;		/* Socket address. */
  int			 found;		/* Flag: Matching address found. */
  int			 connres;	/* Result from bind() and connect(). */
  

#line 5308 "dk3sock.ctr"
  found = 0;
  resc = resl;
  while((resc) && (INVALID_SOCKET == back)) {		

#line 5311 "dk3sock.ctr"
    soa = resc->ai_addr;
    if(soa) {						

#line 5313 "dk3sock.ctr"
      if(soa->sa_family == af) {			

#line 5314 "dk3sock.ctr"
        switch(af) {
	  case AF_INET: 
	  case AF_INET6: {				

#line 5317 "dk3sock.ctr"
	    switch(soa->sa_family) {
	      case AF_INET6: {				

#line 5319 "dk3sock.ctr"
	        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
	      } break;
	      default: {				

#line 5322 "dk3sock.ctr"
	        back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
	      } break;
	    }
	    if(INVALID_SOCKET != back) {		

#line 5326 "dk3sock.ctr"
	      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	      connres = dk3socket_bind(
	        back, soa, resc->ai_addrlen, ec, app
	      );
	      if(connres) {				

#line 5331 "dk3sock.ctr"
	        connres = dk3socket_connect_nb(
		  back, pAddr, szAddr, secs, usecs, ec, app, NULL, 0
		);
		if(!(connres)) {			

#line 5335 "dk3sock.ctr"
		  dk3socket_close(back, NULL, NULL);
		  back = INVALID_SOCKET;
		}
	      } else {					

#line 5339 "dk3sock.ctr"
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    } else {					

#line 5343 "dk3sock.ctr"
	    }
	  } break;
	  default: {					

#line 5346 "dk3sock.ctr"
	  } break;
	}
      } else {						

#line 5349 "dk3sock.ctr"
      }
    } else {						

#line 5351 "dk3sock.ctr"
    }
    resc = resc->ai_next;
  }
  

#line 5355 "dk3sock.ctr"
  return back;
}



dk3_socket_t
dk3socket_open_net_stream_client(
  char const		*sh,
  unsigned short	 sp,
  unsigned short	 lp,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  char			pbuf[64];	/* Server port number as text. */
  char			lbuf[64];	/* Local port number as text. */
  IN_ADDR		in4;		/* IPv4 address. */
  IN6_ADDR		in6;		/* IPv6 address. */
  struct addrinfo	hs;		/* Remote hints. */
  struct addrinfo	hl;		/* Local hints. */
  struct addrinfo	*ress;		/* Server addresses. */
  struct addrinfo	*resl;		/* Local addresses. */
  struct sockaddr_in	soin4;		/* IPv4 socket address. */
  struct sockaddr_in6	soin6;		/* IPv6 socket address. */
  int			resgai = 0;	/* Result from getaddrinfo(). */
  int			connres;	/* Result from connect(). */
  dk3_socket_t		back = INVALID_SOCKET;
  

#line 5385 "dk3sock.ctr"
  if(sp) {						

#line 5386 "dk3sock.ctr"
    if(sh) {					

#line 5387 "dk3sock.ctr"
      ress = NULL;
      resl = NULL;
      /*
      	Find local addresses.
      */
      if(lp) {
        sprintf(lbuf, "%u", (unsigned)lp);
	dk3mem_res((void *)(&hl), sizeof(struct addrinfo));
	hl.ai_flags = AI_NUMERICSERV | AI_PASSIVE;
	hl.ai_family = AF_UNSPEC;
	hl.ai_socktype = SOCK_STREAM;
	hl.ai_protocol = 0;
	resgai = getaddrinfo(NULL, lbuf, &hl, &resl); 

#line 5400 "dk3sock.ctr"
      }
      /*
      	Continue only if local addresses are found or not needed.
      */	
      if(((resgai == 0) && (resl)) || (0 == lp)) {	

#line 5405 "dk3sock.ctr"
        /*
      	  Test IPv4 address.
        */
	resgai = dk3socket_inet_pton(AF_INET,sh,(void *)(&in4),NULL,NULL);
	if(1 == resgai) {		

#line 5410 "dk3sock.ctr"
	  dk3mem_res((void *)(&soin4), sizeof(struct sockaddr_in));
	  soin4.sin_family = AF_INET;
	  soin4.sin_port = htons(sp);
	  dk3mem_cpy(
	    (void *)(&(soin4.sin_addr)),
	    (void *)(&(in4)),
	    sizeof(IN_ADDR)
	  );
	  if(lp) {			

#line 5419 "dk3sock.ctr"
	    back = dk3socket_attempt_open_net_stream_for_local_address(
	      AF_INET, (struct sockaddr *)(&soin4), sizeof(soin4),
	      resl, secs, usecs, NULL, NULL
	    );
	  } else {			

#line 5424 "dk3sock.ctr"
	    back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back,
		(struct sockaddr *)(&soin4), sizeof(struct sockaddr_in),
		secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
		sh,
#else
		NULL,
#endif
		0
	      );
	      if(!(connres)) {		

#line 5438 "dk3sock.ctr"
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    }
	  }
	} else {			

#line 5444 "dk3sock.ctr"
	}
        /*
      	  Test IPv6 address.
        */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
        if(INVALID_SOCKET == back) {
	  resgai = dk3socket_inet_pton(AF_INET6,sh,(void *)(&in6),NULL,NULL);
	  if(1 == resgai) {
	    dk3mem_res((void *)(&soin6), sizeof(struct sockaddr_in6));
	    soin6.sin6_family = AF_INET6;
	    soin6.sin6_port = htons(sp);
	    dk3mem_cpy(
	      (void *)(&(soin6.sin6_addr)),
	      (void *)(&in6),
	      sizeof(IN6_ADDR)
	    );
	    if(lp) {
	      back = dk3socket_attempt_open_net_stream_for_local_address(
	        AF_INET6, (struct sockaddr *)(&soin6), sizeof(soin6),
		resl, secs, usecs, NULL, NULL
	      );
	    } else {
	      back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	      if(INVALID_SOCKET != back) {
	        connres = dk3socket_connect_nb(
		  back,
		  (struct sockaddr *)(&soin6), sizeof(struct sockaddr_in6),
		  secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
		  sh,
#else
		  NULL,
#endif
		  0
		);
		if(!(connres)) {
		  dk3socket_close(back, NULL, NULL);
		  back = INVALID_SOCKET;
		}
	      }
	    }
	  }
        }
#endif
        /*
      	  Resolve host name.
        */
        if(INVALID_SOCKET == back) {	

#line 5492 "dk3sock.ctr"
	  sprintf(pbuf, "%u", (unsigned)sp);
	  dk3mem_res((void *)(&hs), sizeof(struct addrinfo));
	  hs.ai_flags = AI_NUMERICSERV;
	  hs.ai_family = AF_UNSPEC;   /* Solaris man says: PF_UNSPEC */
	  hs.ai_socktype = SOCK_STREAM;
	  hs.ai_protocol = 0;
	  resgai = getaddrinfo(sh, pbuf, &hs, &ress);
	  if((0 == resgai) && (ress)) {	

#line 5500 "dk3sock.ctr"
	    back = dk3socket_attempt_open_net_stream_client(
	      ress, ((lp) ? resl : NULL), secs, usecs, NULL, NULL
	    );
	  } else {			

#line 5504 "dk3sock.ctr"
	    dk3socket_error_getaddrinfo(ec, app, resgai);
	  }
	  if(ress) {
	    freeaddrinfo(ress); ress = NULL;
	  }
        }
      } else {				

#line 5511 "dk3sock.ctr"
      }
      /*
      	Release resources.
      */
      if(resl) {
        freeaddrinfo(resl); resl = NULL;
      }
    } else {	

#line 5519 "dk3sock.ctr"
      /*
      	Test IPv4 localhost
      */
      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
      if(INVALID_SOCKET != back) {
        if(lp) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip4addr_set_localhost(&soin4);
	  soin4.sin_port = htons(lp);
	  connres = dk3socket_bind(
	    back, (struct sockaddr *)(&soin4), sizeof(soin4),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      if(INVALID_SOCKET != back) {
        dk3socket_ip4addr_set_localhost(&soin4);
	soin4.sin_port = htons(sp);
	connres = dk3socket_connect_nb(
	  back, (struct sockaddr *)(&soin4), sizeof(soin4),
	  secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	  sh,
#else
	  NULL,
#endif
	  0
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
      /*
      	Test IPv6 localhost
      */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
      if(INVALID_SOCKET == back) {
        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	if(INVALID_SOCKET != back) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip6addr_set_localhost(&soin6);
	  soin6.sin6_port = htons(lp);
	  connres = dk3socket_bind(
	    back, (struct sockaddr *)(&soin6), sizeof(soin6),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3socket_ip6addr_set_localhost(&soin6);
	  soin6.sin6_port = htons(sp);
	  connres = dk3socket_connect_nb(
	    back, (struct sockaddr *)(&soin6), sizeof(soin6),
	    secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	    sh,
#else
	    NULL,
#endif
	    0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
#endif
    } 
    if(INVALID_SOCKET == back) {
      if(sh) {
        if(app) {
#if DK3_CHAR_SIZE == 1
	  dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, sh);
#else
	  dk3app_log_i1(app, DK3_LL_ERROR, 282);
#endif
	}
      } else {
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
      }
    }
  } else {							

#line 5610 "dk3sock.ctr"
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  

#line 5613 "dk3sock.ctr"
  return back;
}



dk3_socket_set_t *
dk3socket_listeners(
  unsigned short	 portno,
  int			 backlog,
  int			 fLocalOnly,
  int			*ec,
  dk3_app_t		*app
)
{
  char			 pnb[32];	/* Port number buffer. */
  struct addrinfo	 hi;		/* Hints. */
  struct addrinfo	*ai;		/* Result from getaddrinfo(). */
  struct addrinfo	*ap;		/* Pointer to traverse ai. */
  struct sockaddr	*sa;		/* Socket address in ap. */
  dk3_socket_set_t	*back = NULL;
  dk3_socket_t		*sp;		/* Pointer to current socket to init. */
  size_t		 na;		/* Number of addresses. */
  dk3_socket_t		 so;		/* Current socket to create. */
  int			 res;		/* Result from getaddrinfo(). */
  if((portno) && (backlog > 0)) {
    dk3mem_res((void *)(&hi), sizeof(struct addrinfo));
    sprintf(pnb, "%u", (unsigned)portno);
    hi.ai_family = AF_UNSPEC;
    hi.ai_socktype = SOCK_STREAM;
    hi.ai_flags = 0;
    hi.ai_protocol = 0;
    hi.ai_addrlen = 0;
    hi.ai_canonname = NULL;
    hi.ai_addr = NULL;
    hi.ai_next = NULL;
    if(!(fLocalOnly)) { hi.ai_flags = AI_PASSIVE; }
    hi.ai_flags |= AI_NUMERICSERV;
    ai = NULL;
    res = getaddrinfo(NULL, pnb, &hi, &ai);
    if(0 == res) {
      if(ai) {
        /*
		Find number of addresses.
	*/
        na = 0; ap = ai;
	while(ap) { na++; ap = ap->ai_next; }
	/*
		Allocate socket set.
	*/
	if(na > 0) { back = dk3socket_set_new(na, ec, app); }
	/*
		Create the listener sockets.
	*/
	if(back) {
	  ap = ai;
	  na = 0;
	  sp = back->pData;
	  while(ap) {		

#line 5671 "dk3sock.ctr"
	    sa = ap->ai_addr; 

#line 5672 "dk3sock.ctr"
	    so = dk3socket_open(sa->sa_family, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != so) {
	      (void)dk3socket_set_reuse(so, 1, ec, app);
	      if(dk3socket_bind(so, sa, ap->ai_addrlen, NULL, NULL)) {
	        if(dk3socket_listen(so, backlog, ec, app)) {
		  *(sp++) = so;
		  na++;
		  dk3socket_report_listen_success(app, so, sa, ap->ai_addrlen);
		  

#line 5681 "dk3sock.ctr"
		} else {
		  dk3socket_close(so, ec, app);
		}
	      } else {
	        dk3socket_close(so, ec, app);
	      }
	    }
	    ap = ap->ai_next;
	  }
	  back->szUsed = na;
	}
	/*
		If no listener initialized, close socket set
	*/
	if(back) {
	  if(!(na)) {
	    dk3socket_set_close(back, ec, app);
	    back = NULL;
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 364); }
	  }
	}
      } else {
        /* ERROR: No addresses returned */
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
      }
    } else {
      dk3socket_error_getaddrinfo(ec, app, res);
    }
    if(ai) {
      freeaddrinfo(ai);
    }
  }
  return back;
}



dk3_socket_set_t *
dk3socket_datagram_sockets(
  unsigned short	 portno,
  int			 fLocalOnly,
  int			*ec,
  dk3_app_t		*app
)
{
  char			 pnb[32];	/* Port number buffer. */
  struct addrinfo	 hi;		/* Hints. */
  struct addrinfo	*ai;		/* Result from getaddrinfo(). */
  struct addrinfo	*ap;		/* Pointer to traverse ai. */
  struct sockaddr	*sa;		/* Socket address in ap. */
  dk3_socket_set_t	*back = NULL;
  dk3_socket_t		*sp;		/* Pointer to current socket to init. */
  size_t		 na;		/* Number of addresses. */
  dk3_socket_t		 so;		/* Current socket to create. */
  int			 res;		/* Result from getaddrinfo(). */
  if(portno) {
    dk3mem_res((void *)(&hi), sizeof(struct addrinfo));
    sprintf(pnb, "%u", (unsigned)portno);
    hi.ai_family = AF_UNSPEC;
    hi.ai_socktype = SOCK_STREAM;
    hi.ai_flags = 0;
    hi.ai_protocol = 0;
    hi.ai_addrlen = 0;
    hi.ai_canonname = NULL;
    hi.ai_addr = NULL;
    hi.ai_next = NULL;
    if(!(fLocalOnly)) { hi.ai_flags = AI_PASSIVE; }
    hi.ai_flags |= AI_NUMERICSERV;
    ai = NULL;
    res = getaddrinfo(NULL, pnb, &hi, &ai);
    if(0 == res) {
      if(ai) {
        /*
      	  Find number of addresses.
        */
        na = 0; ap = ai;
        while(ap) { na++; ap = ap->ai_next; }
        /*
      	  Allocate socket set;
        */
        if(na > 0) { back = dk3socket_set_new(na, ec, app); }
        /*
      	  Create the UDP sockets.
        */
        if(back) {
          ap = ai;
	  na = 0;
	  sp = back->pData;
	  while(ap) {
	    sa = ap->ai_addr;
	    so = dk3socket_open(sa->sa_family, SOCK_DGRAM, 0, ec, app);
	    if(INVALID_SOCKET != so) {
	      (void)dk3socket_set_reuse(so, 1, ec, app);
	      if(dk3socket_bind(so, sa, ap->ai_addrlen, ec, app)) {
	        *(sp++) = so;
	        na++;
	      } else {
	        dk3socket_close(so, ec, app);
	      }
	    }
	    ap = ap->ai_next;
	  }
        }
        /*
      	  Close socket set if no socket created.
        */
        if(back) {
          if(!(na)) {
	    dk3socket_set_close(back, ec, app);
	    back = NULL;
	  }
        }
      }
    } else {
      dk3socket_error_getaddrinfo(ec, app, res);
    }
    if(ai) {
      freeaddrinfo(ai);
    }
  }
  return back;
}



/*
	Section end: getaddrinfo().
*/

#else
/* if DK3_HAVE_GETADDRINFO */

#if DK3_HAVE_GETHOSTBYNAME

/*
	Section start: gethostbyname().
*/



dk3_socket_t
dk3socket_open_net_stream_client(
  char const		*sh,
  unsigned short	 sp,
  unsigned short	 lp,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  struct sockaddr_in6	 sl6;		/* Local IPv6 address. */
  struct sockaddr_in6	 sr6;		/* Remote IPv6 address. */
  IN6_ADDR		 in6;		/* IPv6 address. */
#endif
  struct sockaddr_in	 sl4;		/* Local IPv4 address. */
  struct sockaddr_in	 sr4;		/* Remote IPv4 address. */
  IN_ADDR		 in4;		/* IPv4 address. */
  struct hostent	*he;		/* Result from gethostbyname(). */
  char		       **addrptr;	/* Address pointer. */
  dk3_socket_t		 back = INVALID_SOCKET;
  int			 resgai;	/* Result from getaddrinfo(). */
  int			 connres;	/* Result from bind()/connect(). */
  int			 err;		/* Error code from gethostbyname(). */
  

#line 5847 "dk3sock.ctr"
  if(sp) {
    if(sh) {					

#line 5849 "dk3sock.ctr"
      /*
      	Attempt IPv4 address.
      */
      resgai = dk3socket_inet_pton(AF_INET, sh, &in4, NULL, NULL);
      if(1 == resgai) {
        back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
	if(INVALID_SOCKET != back) {
	  if(lp) {
	    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
            dk3mem_res((void *)(&sl4), sizeof(struct sockaddr_in));
	    sl4.sin_family = AF_INET;
	    sl4.sin_port = htons(lp);
	    sl4.sin_addr.s_addr = INADDR_ANY;
	    connres = dk3socket_bind(
	      back,
	      (struct sockaddr *)(&sl4), sizeof(sl4),
	      NULL, NULL
	    );
	    if(!(connres)) {
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	    }
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3mem_res((void *)(&sr4), sizeof(sr4));
	  sr4.sin_family = AF_INET;
	  sr4.sin_port = htons(sp);
	  dk3mem_cpy(
	    (void *)(&(sr4.sin_addr)),
	    (void *)(&in4),
	    sizeof(IN_ADDR)
	  );
	  connres = dk3socket_connect_nb(
	    back,
	    (struct sockaddr *)(&sr4), sizeof(sr4),
	    secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	    sh,
#else
	    NULL,
#endif
	    0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      /*
      	Attempt IPv6 address.
      */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
      if(INVALID_SOCKET == back) {
        resgai = dk3socket_inet_pton(AF_INET6, sh, &in6, NULL, NULL);
	if(1 == resgai) {
	  back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	  if(INVALID_SOCKET != back) {
	    if(lp) {
	      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	      dk3mem_res((void *)(&sl6), sizeof(struct sockaddr_in6));
	      sl6.sin6_family = AF_INET6;
	      sl6.sin6_port = htons(lp);
	      dk3mem_cpy(
	        (void *)(&(sl6.sin6_addr)),
		(void *)(&dk3socket_ia6_addr_any),
		sizeof(IN6_ADDR)
	      );
	      connres = dk3socket_bind(
	        back,
		(struct sockaddr *)(&sl6), sizeof(struct sockaddr_in6),
		NULL, NULL
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    }
	  }
	  if(INVALID_SOCKET != back) {
	    dk3mem_res((void *)(&sr6), sizeof(struct sockaddr_in6));
	    sr6.sin6_family = AF_INET6;
	    sr6.sin6_port = htons(sp);
	    dk3mem_cpy(
	      (void *)(&(sr6.sin6_addr)),
	      (void *)(&in6),
	      sizeof(IN6_ADDR)
	    );
	    connres = dk3socket_connect_nb(
	      back,
	      (struct sockaddr *)(&sr6), sizeof(struct sockaddr_in6),
	      secs, usecs, NULL, NULL
#if DK3_CHAR_SIZE == 1
	      sh,
#else
	      NULL,
#endif
	      0
	    );
	    if(!(connres)) {
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	    }
	  }
	}
      }
#endif
      /*
      	Host name resolution.
      */
      if(INVALID_SOCKET == back) {
        he = gethostbyname(sh);
	if(he) {				

#line 5963 "dk3sock.ctr"
	  if(AF_INET == he->h_addrtype) {
	    if(4 == he->h_length) {
	      if(he->h_addr_list) {
	        addrptr = he->h_addr_list;
		while((INVALID_SOCKET == back) && (*addrptr)) {
		  back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
		  if(INVALID_SOCKET != back) {
		    if(lp) {
		      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
		      dk3mem_res((void *)(&sl4), sizeof(struct sockaddr_in));
		      sl4.sin_family = AF_INET;
		      sl4.sin_port = htons(lp);
		      sl4.sin_addr.s_addr = INADDR_ANY;
		      connres = dk3socket_bind(
		        back,
			(struct sockaddr *)(&sl4), sizeof(struct sockaddr_in),
			NULL, NULL
		      );
		      if(!(connres)) {
		        dk3socket_close(back, NULL, NULL);
			back = INVALID_SOCKET;
		      }
		    }
		  }
		  if(INVALID_SOCKET != back) {
		    dk3mem_res((void *)(&sr4), sizeof(struct sockaddr_in));
		    sr4.sin_family = AF_INET;
		    sr4.sin_port = htons(sp);
		    dk3mem_cpy(
		      (void *)(&(sr4.sin_addr)),
		      (void *)(*addrptr),
		      sizeof(IN_ADDR)
		    );
		    connres = dk3socket_connect_nb(
		      back,
		      (struct sockaddr *)(&sr4), sizeof(struct sockaddr_in),
		      secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
		      sh,
#else
		      NULL,
#endif
		      0
		    );
		    if(!(connres)) {
		      dk3socket_close(back, NULL, NULL);
		      back = INVALID_SOCKET;
		    }
		  }
		  addrptr++;
		}
	      } else {
	        /* ERROR: No address list! */
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
	      }
	    } else {
	      /* ERROR: Wrong address length */
	      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
	    }
	  } else {
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
	    if(AF_INET6 == he->h_addrtype) {
	      if(16 == he->h_length) {
	        if(he->h_addr_list) {
		  addrptr = he->h_addr_list;
		  while((INVALID_SOCKET == back) && (*addrptr)) {
		    back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
		    if(INVALID_SOCKET != back) {
		      if(lp) {
		        (void)dk3socket_set_reuse(back, 1, NULL, NULL);
		        dk3mem_res((void *)(&sl6), sizeof(struct sockaddr_in6));
			sl6.sin6_family = AF_INET6;
			sl6.sin6_port = htons(lp);
			dk3mem_cpy(
			  (void *)(&(sl6.sin6_addr)),
			  (void *)(&dk3socket_ia6_addr_any),
			  sizeof(IN6_ADDR)
			);
			connres = dk3socket_bind(
			  back,
			  (struct sockaddr *)(&sl6),
			  sizeof(struct sockaddr_in6),
			  NULL, NULL
			);
			if(!(connres)) {
			  dk3socket_close(back, NULL, NULL);
			  back = INVALID_SOCKET;
			}
		      }
		    }
		    if(INVALID_SOCKET != back) {
		      dk3mem_res((void *)(&sr6), sizeof(struct sockaddr_in6));
		      sr6.sin6_family = AF_INET6;
		      sr6.sin6_port = htons(sp);
		      dk3mem_cpy(
		        (void *)(&(sr6.sin6_addr)),
			(void *)(*addrptr),
			sizeof(IN6_ADDR)
		      );
		      connres = dk3socket_connect_nb(
		        back,
			(struct sockaddr *)(&sr6), sizeof(struct sockaddr_in6),
			secs, usecs, NULL, NULL
#if DK3_CHAR_SIZE == 1
			sh,
#else
			NULL,
#endif
			0
		      );
		      if(!(connres)) {
		        dk3socket_close(back, NULL, NULL);
			back = INVALID_SOCKET;
		      }
		    }
		    addrptr++;
		  }
		} else {
		  /* ERROR: No address list! */
		  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
		}
	      } else {
	        /* ERROR: Illegal length! */
		if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
	      }
	    } else {
	    }
#endif
	  }
	} else {
	  /* ERROR: Host not found! */
	  err = dk3socket_error(h_errno);
	  dk3socket_error_gethostbyname(ec, app, err, sh);
	}
      }
    } else {					

#line 6099 "dk3sock.ctr"
      /*
      	Test IPv4 localhost
      */
      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
      if(INVALID_SOCKET != back) {
        if(lp) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip4addr_set_localhost(&sl4);
	  sl4.sin_port = htons(lp);
	  connres = dk3socket_bind(
	    back, (struct sockaddr *)(&sl4), sizeof(struct sockaddr_in),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      if(INVALID_SOCKET != back) {
        dk3socket_ip4addr_set_localhost(&sr4);
	sr4.sin_port = htons(sp);
	connres = dk3socket_connect_nb(
	  back, (struct sockaddr *)(&sr4), sizeof(sr4),
	  secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	  sh,
#else
	  NULL,
#endif
	  0
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
      /*
      	Test IPv6 localhost
      */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
      if(INVALID_SOCKET == back) {
        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	if(INVALID_SOCKET != back) {
	  if(lp) {
	    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	    dk3socket_ip6addr_set_localhost(&sl6);
	    sl6.sin6_port = htons(lp);
	    connres = dk3socket_bind(
	      back, (struct sockaddr *)(&sl6), sizeof(struct sockaddr_in6),
	      NULL, NULL
	    );
	    if(!(connres)) {
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	    }
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3socket_ip6addr_set_localhost(&sr6);
	  sr6.sin6_port = htons(sp);
	  connres = dk3socket_connect_nb(
	    back, (struct sockaddr *)(&sr6), sizeof(struct sockaddr_in6),
	    secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	    sh,
#else
	    NULL,
#endif
	    0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
#endif
    }
    if(INVALID_SOCKET == back) {
      if(sh) {
        if(app) {
#if DK3_CHAR_SIZE == 1
	  dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, sh);
#else
	  dk3app_log_i1(app, DK3_LL_ERROR, 282);
#endif
	}
      } else {
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
      }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 6194 "dk3sock.ctr"
  return back;
}



/*
	Section end: gethostbyname().
*/

#else
/* if DK3_HAVE_GETHOSTBYNAME */

/*
	Section start: No getaddrinfo(), no gethostbyname().
*/

dk3_socket_t
dk3socket_open_net_stream_client(
  char const		*sh,
  unsigned short	 sp,
  unsigned short	 lp,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  struct sockaddr_in6	 sr6;		/* Remote IPv6 address. */
  struct sockaddr_in6	 sl6;		/* Local IPv6 address. */
  IN6_ADDR		 in6;		/* IPv6 address. */
#endif
  struct sockaddr_in	 srem;		/* Remote IPv4 address. */
  struct sockaddr_in	 sloc;		/* Local IPv4 address. */
  IN_ADDR		 in4;		/* IPv4 address. */
  dk3_socket_t		 back = INVALID_SOCKET;
  int			 connres;	/* Result from bind()/connect(). */
  

#line 6232 "dk3sock.ctr"
  if(sp) {
    if(sh) {		

#line 6234 "dk3sock.ctr"
      dk3mem_res((void *)(&srem), sizeof(struct sockaddr_in));
      dk3mem_res((void *)(&in4), sizeof(IN_ADDR));
      if(dk3socket_inet_pton(AF_INET, sh, (void *)(&in4), NULL, NULL)) {
        back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
	if(INVALID_SOCKET != back) {
	  if(lp) {
	    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	    dk3mem_res((void *)(&sloc), sizeof(struct sockaddr_in));
	    sloc.sin_addr.s_addr = INADDR_ANY;
	    sloc.sin_family = AF_INET;
	    sloc.sin_port = htons(lp);
	    connres = dk3socket_bind(
	      back,
	      (struct sockaddr const *)(&sloc), sizeof(struct sockaddr_in),
	      NULL, NULL
	    );
	    if(!(connres)) {
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	    }
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3mem_res((void *)(&srem), sizeof(struct sockaddr_in));
	  dk3mem_cpy((void *)(&(srem.sin_addr)), (void *)(&in4), sizeof(IN_ADDR));
	  srem.sin_family = AF_INET;
	  srem.sin_port = htons(sp);
	  connres = dk3socket_connect_nb(
	    back,
	    (struct sockaddr *)(&srem), sizeof(struct sockaddr_in),
	    secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	    sh,
#else
	    NULL,
#endif
	    0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      } else {
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
	dk3mem_res((void *)(&sr6), sizeof(struct sockaddr_in6));
	dk3mem_res((void *)(&in6), sizeof(IN6_ADDR));
	if(dk3socket_inet_pton(AF_INET6, sh, (void *)(&in6), NULL, NULL)) {
	   back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	   if(INVALID_SOCKET != back) {
	     if(lp) {
	      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	       dk3mem_res((void *)(&sl6), sizeof(struct sockaddr_in6));
	       dk3mem_cpy(
	         (void *)(&(sl6.sin6_addr)),
		 (void *)(&dk3socket_ia6_addr_any),
		 sizeof(IN6_ADDR)
	       );
	       sl6.sin6_family = AF_INET6;
	       sl6.sin6_port = htons(lp);
	       connres = dk3socket_bind(
	         back,
		 (struct sockaddr *)(&sl6), sizeof(struct sockaddr_in6),
		 NULL, NULL
	       );
	       if(!(connres)) {
	         dk3socket_close(back, NULL, NULL);
		 back = INVALID_SOCKET;
	       }
	     }
	   }
	   if(INVALID_SOCKET != back) {
	     dk3mem_cpy(
	       (void *)(&(sr6.sin6_addr)),
	       (void *)(&in6),
	       sizeof(IN6_ADDR)
	     );
	     sr6.sin6_family = AF_INET6;
	     sr6.sin6_port = htons(sp);
	     connres = dk3socket_connect_nb(
	       back,
	       (struct sockaddr *)(&sr6), sizeof(struct sockaddr_in6),
	       secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	       sh,
#else
	       NULL,
#endif
	       0
	     );
	     if(!(connres)) {
	       dk3socket_close(back, NULL, NULL);
	       back = INVALID_SOCKET;
	     }
	   }
	} else {
	  /* ERROR: No an IPv6 address! */
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
	}
#else
        /* ERROR: Not an IPv4 address! */
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 286); }
#endif
      }
    } else {		

#line 6339 "dk3sock.ctr"
      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
      if((lp) && (INVALID_SOCKET != back)) {
	(void)dk3socket_set_reuse(back, 1, NULL, NULL);
        dk3socket_ip4addr_set_localhost(&srem);
	srem.sin_port = htons(lp);
	connres = dk3socket_bind(
	  back,
	  (struct sockaddr const *)(&srem), sizeof(struct sockaddr_in),
	  NULL, NULL
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
      if(INVALID_SOCKET != back) {
	dk3socket_ip4addr_set_localhost(&srem);
	srem.sin_port = htons(sp);
	connres = dk3socket_connect_nb(
	  back,
	  (struct sockaddr *)(&srem), sizeof(struct sockaddr_in),
	  secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	  sh,
#else
	  NULL,
#endif
	  0
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
      if(INVALID_SOCKET == back) {
	back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	if((lp) && (INVALID_SOCKET != back)) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip6addr_set_localhost(&sr6);
	  sr6.sin6_port = htons(lp);
	  connres = dk3socket_bind(
	    back,
	    (struct sockaddr const *)(&sr6), sizeof(struct sockaddr_in6),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3socket_ip6addr_set_localhost(&sr6);
	  sr6.sin6_port = htons(sp);
	  connres = dk3socket_connect_nb(
	    back,
	    (struct sockaddr *)(&sr6), sizeof(struct sockaddr_in6),
	    secs, usecs, NULL, NULL,
#if DK3_CHAR_SIZE == 1
	    sh,
#else
	    NULL,
#endif
	    0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
#endif
    }
    if(INVALID_SOCKET == back) {
      if(sh) {
        if(app) {
#if DK3_CHAR_SIZE == 1
	  dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, sh);
#else
	  dk3app_log_i1(app, DK3_LL_ERROR, 282);
#endif
	}
      } else {
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
      }
    }
  } else {
    /* ERROR: No remote port! */
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  

#line 6430 "dk3sock.ctr"
  return back;
}


/*
	Section end: No getaddrinfo(), no gethostbyname().
*/

#endif
/* if DK3_HAVE_GETHOSTBYNAME */



dk3_socket_set_t *
dk3socket_listeners(
  unsigned short	 portno,
  int			 backlog,
  int			 fLocalOnly,
  int			*ec,
  dk3_app_t		*app
)
{
  struct sockaddr_in	 ip4;		/* Local IPv4 address. */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  struct sockaddr_in6	 ip6;		/* Local IPv6 address. */
#endif
  dk3_socket_t		*sp;		/* Pointer to current socket to init. */
  dk3_socket_set_t	*back = NULL;
  size_t		 szmax;		/* Number of sockets in set. */
  size_t		 na;		/* Number of used sockets in set. */
  dk3_socket_t		 so;		/* Socket to create. */
  

#line 6462 "dk3sock.ctr"
  if((portno) && (portno > 0)) {
    szmax = 1;
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
    szmax = 2;
#endif
    back = dk3socket_set_new(szmax, ec, app);
    if(back) {
      sp = back->pData;
      na = 0;
      /*
      	Attempt to bind IPv4 address.
      */
      dk3mem_res((void *)(&ip4), sizeof(struct sockaddr_in));
      if(fLocalOnly) {
        dk3socket_ip4addr_set_localhost(&ip4);
      } else {
        ip4.sin_family = AF_INET;
	ip4.sin_addr.s_addr = INADDR_ANY;
      }
      ip4.sin_port = htons(portno);
      so = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
      if(INVALID_SOCKET != so) {
        if(dk3socket_bind(
	     so, (struct sockaddr *)(&ip4), sizeof(struct sockaddr_in), ec, app
	   )
	)
	{
	  if(dk3socket_listen(so, backlog, ec, app)) {
	    *(sp++) = so;
	    na++;
	    dk3socket_report_listen_success(
	      app, so, &ip4, sizeof(struct sockaddr_in)
	    );
	  } else {
	    dk3socket_close(so, ec, app);
	  }
	}
	else
	{
	  dk3socket_close(so, ec, app);
	}
      }
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
      /*
      	Attempt bo bind IPv6 address.
      */
      dk3mem_res((void *)(&ip6), sizeof(struct sockaddr_in6));
      if(fLocalOnly) {
        dk3socket_ip6addr_set_localhost(&ip6);
      } else {
        ip6.sin6_family = AF_INET6;
	dk3mem_cpy(
	  (void *)(&(ip6.sin6_addr)),
	  (void *)(&dk3socket_ia6_addr_any),
	  sizeof(IN6_ADDR)
	);
      }
      ip6.sin6_port = htons(portno);
      so = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
      if(INVALID_SOCKET != so) {
        if(dk3socket_bind(
	     so, (struct sockaddr *)(&ip6), sizeof(struct sockaddr_in6), ec, app
	   )
	)
	{
	  if(dk3socket_listen(so, backlog, ec, app)) {
	    *(sp++) = so;
	    na++;
	    dk3socket_report_listen_success(
	      app, so, &ip6, sizeof(struct sockaddr_in6)
	    );
	  } else {
	    dk3socket_close(so, ec, app);
	  }
	} else {
	  dk3socket_close(so, ec, app);
	}
      }
#endif
      /*
      	If no address was bound, close the set.
      */
      if(na) {
        back->szUsed  = na;
      } else {
        dk3socket_set_close(back, ec, app);
	back = NULL;
      } 

#line 6550 "dk3sock.ctr"
    }
  } 

#line 6552 "dk3sock.ctr"
  return back;
}



dk3_socket_set_t *
dk3socket_datagram_sockets(
  unsigned short	 portno,
  int			 fLocalOnly,
  int			*ec,
  dk3_app_t		*app
)
{
  struct sockaddr_in	 ip4;		/* Local IPv4 address. */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  struct sockaddr_in6	 ip6;		/* Local IPv6 address. */
#endif
  dk3_socket_t		*sp;		/* Pointer to current socket to init. */
  dk3_socket_set_t	*back = NULL;
  size_t		 szmax;		/* Number of sockets in set. */
  size_t		 na;		/* Number of used sockets in set. */
  dk3_socket_t		 so;		/* Socket to create. */
  if(portno) {
    szmax = 1;
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
    szmax = 2;
#endif
    back = dk3socket_set_new(szmax, ec, app);
    if(back) {
      sp = back->pData;
      na = 0;
      /*
      	Attempt to bind IPv4 address.
      */
      dk3mem_res((void *)(&ip4), sizeof(struct sockaddr_in));
      if(fLocalOnly) {
        dk3socket_ip4addr_set_localhost(&ip4);
      } else {
        ip4.sin_family = AF_INET;
	ip4.sin_addr.s_addr = INADDR_ANY;
      }
      ip4.sin_port = htons(portno);
      so = dk3socket_open(AF_INET, SOCK_DGRAM, 0, ec, app);
      if(INVALID_SOCKET != so) {
        if(dk3socket_bind(
	     so, (struct sockaddr *)(&ip4), sizeof(struct sockaddr_in), ec, app
	   )
	)
	{
	  *(sp++) = so;
	  na++;
	}
	else
	{
	  dk3socket_close(so, ec, app);
	}
      }
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
      /*
      	Attempt bo bind IPv6 address.
      */
      dk3mem_res((void *)(&ip6), sizeof(struct sockaddr_in6));
      if(fLocalOnly) {
        dk3socket_ip6addr_set_localhost(&ip6);
      } else {
        ip6.sin6_family = AF_INET6;
	dk3mem_cpy(
	  (void *)(&(ip6.sin6_addr)),
	  (void *)(&dk3socket_ia6_addr_any),
	  sizeof(IN6_ADDR)
	);
      }
      ip6.sin6_port = htons(portno);
      so = dk3socket_open(AF_INET6, SOCK_DGRAM, 0, ec, app);
      if(INVALID_SOCKET != so) {
        if(dk3socket_bind(
	     so, (struct sockaddr *)(&ip6), sizeof(struct sockaddr_in6), ec, app
	   )
	)
	{
	  *(sp++) = so;
	  na++;
	} else {
	  dk3socket_close(so, ec, app);
	}
      }
#endif
      /*
      	If no address was bound, close the set.
      */
      if(na) {
        back->szUsed  = na;
      } else {
        dk3socket_set_close(back, ec, app);
	back = NULL;
      } 

#line 6648 "dk3sock.ctr"
    }
  }
  return back;
}



#endif
/* if DK3_HAVE_GETADDRINFO */



#if DK3_HAVE_STRUCT_SOCKADDR_IN6

/**	Bit patterns for use in dk3socket_ip6_fill_bits.
*/
static unsigned char const dk3socket_bits_in_byte[] = {
0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01
};

/**	Fill address bits in an IPv6 address beginning from
	MSB. This function is used to build a netmask.
	@param	ap	Address structure to modify.
	@param	bits	Number of bits to set.
*/
void
dk3socket_ip6_fill_bits(IN6_ADDR *ap, unsigned bits)
{
  int		i;	/* Current byte to process. */
  int		j;	/* Current bit index. */
  unsigned	b;	/* Number of bits still to process. */
  

#line 6680 "dk3sock.ctr"
  if(ap) {
    for(i = 0; i < 16; i++) {
      ap->s6_addr[i] = 0x00;
    }
    b = bits;
    if(b > 128) b = 128;
    i = 0; j = 0;
    while(b--) {
      ap->s6_addr[i] |= dk3socket_bits_in_byte[j];
      j++;
      if(8 <= j) { j = 0; i++; }
    }
  } 

#line 6693 "dk3sock.ctr"
}
#endif

/**	Fill address bits in an IPv4 address beginning from
	MSB. This function is used to build a netmask.
	@param	ap	Address structure to modify.
	@param	bitno	Number of bits to set.
*/
void
dk3socket_ip4_fill_bits(IN_ADDR *ap, unsigned bitno)
{
  

#line 6705 "dk3sock.ctr"
  if(ap) {
    unsigned long	bits;
    unsigned long	back;
    unsigned		b;
    back = 0UL;
    bits = 0x80000000UL;
    b = bitno;
    if(b > 32) b = 32;
    while(b--) {
      back |= bits;
      bits = (bits >> 1);
    }
    ap->s_addr = htonl(back); 

#line 6718 "dk3sock.ctr"
  } 

#line 6719 "dk3sock.ctr"
}



/**	Set netmask part of allowed peer.
	@param	dp	Destination pointer (allowed peer).
	@param	src	Source text containing the network mask.
	@param	app	Application structure for diagnostics.
	@param	is6	Flag: We are searching for IPv6 address.
	@return	1 on success, 0 on error.
*/
static
int
dknet_allowed_mask(dk3_peer_allowed_t *dp, char *src, dk3_app_t *app, int is6)
{
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  IN6_ADDR	 ip6mask;		/* IPv6 net mask. */
#endif
  IN_ADDR	 ip4mask;		/* IPv4 net mask. */
  unsigned	 u;			/* Number of bits to set. */
  int		 res;			/* Operation result. */
  int		 back = 0;

#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  if(is6) {
    if(src) {
      if(dk3str_c8_chr(src, ':')) {
        res = dk3socket_inet_pton(AF_INET6,src,(void *)(&ip6mask),NULL,NULL);
	if(res) {
	  back = 1;
	} else {
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 356); }
	}
      } else {
        if(sscanf(src, "%u", &u) == 1) {
	  back = 1;
	  dk3socket_ip6_fill_bits(&ip6mask, u);
	} else {
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 355); }
	}
      }
    } else {
      back = 1;
      dk3socket_ip6_fill_bits(&((dp->d).ip6.ma), 128);
    }
    if(back) {
      dk3mem_cpy(
        (void *)(&((dp->d).ip6.ma)), (void *)(&ip6mask), sizeof(IN6_ADDR)
      );
    }
  } else {
#endif
    if(src) {
      if(dk3str_c8_chr(src, '.')) {
        res = dk3socket_inet_pton(AF_INET, src, (void *)(&ip4mask), NULL, NULL);
        if(res) {
          back = 1;
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 354); }
        }
      } else {
        if(sscanf(src, "%u", &u) == 1) {
          back = 1;
	  dk3socket_ip4_fill_bits(&ip4mask, u);
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 355); }
        }
      }
    } else {
      back = 1;
      ip4mask.s_addr = 0xFFFFFFFFUL;
    }
    if(back) {
      dk3mem_cpy(
        (void *)(&((dp->d).ip4.ma)), (void *)(&ip4mask), sizeof(IN_ADDR)
      );
    }
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  }
#endif
  return back;
}



int
dk3socket_set_peer(
  dk3_peer_allowed_t	*dp,
  char const		*sr,
  int			*ec,
  dk3_app_t		*app
)
{
  char		 	 bu[DK3_MAX_PATH];	/* Private copy of hostname. */
#if DK3_HAVE_GETADDRINFO
  struct addrinfo	 hints;		/* Hints set. */
  struct addrinfo	*rgai;		/* Result from getaddrinfo(). */
  struct addrinfo	*pai;		/* Current address to check. */
#else
#if DK3_HAVE_GETHOSTBYNAME
  struct hostent	*heptr;		/* Result from gethostbyname(). */
#endif
#endif
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  IN6_ADDR		 ip6addr;	/* IPv6 address. */
  struct sockaddr_in6	*soin6;		/* Socket address. */
#endif
  IN_ADDR		 ip4addr;	/* IPv4 address. */
#if !(DK3_ON_WINDOWS || DK3_HAVE_GETADDRINFO)
#if DK3_HAVE_GETHOSTBYNAME && DK3_HAVE_STRUCT_SOCKADDR_IN6
  unsigned long		*ulptr;		/* Pointer to address. */
  char		       **addrptr;	/* Address pointer. */
#endif
#endif
  struct sockaddr_in	*soin;		/* Socket address. */
  char			*maptr;		/* Pointer to beginning of mask. */
#if 0
  unsigned		 u;		/* Number of bits in netmask. */
#endif
  int			 back = 0;
  int			 res;		/* Result from inet_ntop(). */
  int			 found;		/* Flag: Host found. */
#if !(DK3_ON_WINDOWS || DK3_HAVE_GETADDRINFO)
#if DK3_HAVE_GETHOSTBYNAME
  int			 err;		/* Error code from gethostbyname() .*/
#endif
#endif
  

#line 6847 "dk3sock.ctr"
  if((dp) && (sr)) {				

#line 6848 "dk3sock.ctr"
    found = 0;
    if(dk3str_c8_len(sr) < sizeof(bu)) {	

#line 6850 "dk3sock.ctr"
      dk3str_c8_cpy_not_overlapped(bu, sr);
      maptr = dk3str_c8_chr(bu, '/');
      if(maptr) {				

#line 6853 "dk3sock.ctr"
        *(maptr++) = '\0';
	maptr = dk3str_c8_start(maptr, NULL);
      }
      res = dk3socket_inet_pton(AF_INET, bu, (void *)(&ip4addr), NULL, NULL);
      if(res) {					

#line 6858 "dk3sock.ctr"
        found = 1;
        /* HAVE IPv4 address */
	dp->wh = 0;
	dk3mem_cpy(
	  (void *)(&((dp->d).ip4.ad)), (void *)(&ip4addr), sizeof(IN_ADDR)
	);
	back = dknet_allowed_mask(dp, maptr, app, 0);
      } else {					

#line 6866 "dk3sock.ctr"
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
        res = dk3socket_inet_pton(AF_INET6, bu, (void *)(&ip6addr), NULL, NULL);
	if(res) {				

#line 6869 "dk3sock.ctr"
	  found = 1;
	  dp->wh = 1;
	  dk3mem_cpy(
	    (void *)(&((dp->d).ip6.ad)),
	    (void *)(&ip6addr), sizeof(IN6_ADDR)
	  );
	  back = dknet_allowed_mask(dp, maptr, app, 1);
	} else {				

#line 6877 "dk3sock.ctr"
	}
#endif
      }
      if(!(found)) {				

#line 6881 "dk3sock.ctr"
#if DK3_ON_WINDOWS || DK3_HAVE_GETADDRINFO
	

#line 6883 "dk3sock.ctr"
	rgai = NULL;
	dk3mem_res((void *)(&hints), sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = 0;
	hints.ai_protocol = 0;
	hints.ai_addrlen = 0;
	hints.ai_canonname = NULL;
	hints.ai_addr = NULL;
	hints.ai_next = NULL;
	res = getaddrinfo(bu, NULL, &hints, &rgai);
	if(0 == res) {				

#line 6895 "dk3sock.ctr"
	  if(rgai) {
	    pai = rgai;
	    while((0 == back) && (pai)) {	

#line 6898 "dk3sock.ctr"
	      if(AF_INET == pai->ai_family) {
	        if(sizeof(struct sockaddr_in) == pai->ai_addrlen) {
		  if(pai->ai_addr) {
		    found = 1;
		    dp->wh = 0;
		    soin = (struct sockaddr_in *)(pai->ai_addr);
		    dk3mem_cpy(
		      (void *)(&((dp->d).ip4.ad)),
		      (void *)(&(soin->sin_addr)),
		      sizeof(IN_ADDR)
		    );
		    back = dknet_allowed_mask(dp, maptr, app, 0);
		  }
		}
	      } else {			

#line 6913 "dk3sock.ctr"
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
		if(AF_INET6 == pai->ai_family) {	

#line 6915 "dk3sock.ctr"
		  if(sizeof(struct sockaddr_in6) == pai->ai_addrlen) {
		    

#line 6917 "dk3sock.ctr"
		    if(pai->ai_addr) {	

#line 6918 "dk3sock.ctr"
		      found = 1;
		      dp->wh = 1;
		      soin6 = (struct sockaddr_in6 *)(pai->ai_addr);
		      dk3mem_cpy(
		        (void *)(&((dp->d).ip6.ad)),
			(void *)(&(soin6->sin6_addr)),
			sizeof(IN6_ADDR)
		      );
		      back = dknet_allowed_mask(dp, maptr, app, 1);
		    } else {		

#line 6928 "dk3sock.ctr"
		    }
		  } else {		

#line 6930 "dk3sock.ctr"
		  }
		} else {		

#line 6932 "dk3sock.ctr"
		}
#endif
	      }
	      pai = pai->ai_next;
	    }
	  }
	} else {			

#line 6939 "dk3sock.ctr"
	  dk3socket_error_getaddrinfo(ec, app, res);
	}
	if(rgai) {
	  freeaddrinfo(rgai);
	}
#else
#if DK3_HAVE_GETHOSTBYNAME
	

#line 6947 "dk3sock.ctr"
	heptr = gethostbyname(bu);
	if(heptr) {
	  if(AF_INET == heptr->h_addrtype) {		

#line 6950 "dk3sock.ctr"
	    if(4 == heptr->h_length) {			

#line 6951 "dk3sock.ctr"
	      if(heptr->h_addr_list) {			

#line 6952 "dk3sock.ctr"
	        addrptr = heptr->h_addr_list;
		ulptr = (unsigned long *)(*addrptr);
		if(ulptr) {
		  dp->wh = 0;
		  dk3mem_cpy(
		    (void *)(&((dp->d).ip4.ad)),
		    (void *)(ulptr),
		    sizeof(IN_ADDR)
		  );
		  back = dknet_allowed_mask(dp, maptr, app, 0);
		}
	      } else {					

#line 6964 "dk3sock.ctr"
	      }
	    } else {					

#line 6966 "dk3sock.ctr"
	    }
	  } else {					

#line 6968 "dk3sock.ctr"
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
	    if(AF_INET6 == heptr->h_addrtype) {
	      if(16 == heptr->h_length) {		

#line 6971 "dk3sock.ctr"
	        if(heptr->h_addr_list) {		

#line 6972 "dk3sock.ctr"
		  addrptr = heptr->h_addr_list;
		  ulptr = (unsigned long *)(*addrptr);
		  if(ulptr) {				

#line 6975 "dk3sock.ctr"
		    dp->wh = 0;
		    dk3mem_cpy(
		      (void *)(&((dp->d).ip6.ad)),
		      (void *)(ulptr),
		      sizeof(IN6_ADDR)
		    );
		    back = dknet_allowed_mask(dp, maptr, app, 1);
		  } else {				

#line 6983 "dk3sock.ctr"
		  }
		} else {				

#line 6985 "dk3sock.ctr"
		}
	      } else {					

#line 6987 "dk3sock.ctr"
	      }
	    }
#endif
	  }
	} else {					

#line 6992 "dk3sock.ctr"
	  err = dk3socket_error(h_errno);
	  dk3socket_error_gethostbyname(ec, app, err, bu);
	}
#else
	

#line 6997 "dk3sock.ctr"
        /* ERROR: Host not an IP address, no address resolution */
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 357); }
#endif
#endif
      }
    } else {					

#line 7003 "dk3sock.ctr"
      /* ERROR: Source text too long! */
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 108); }
    }
  } else {					

#line 7007 "dk3sock.ctr"
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 7009 "dk3sock.ctr"
  return back;
}



int
dk3socket_compare_peer(void const *l, void const *r, int cr)
{
  char			 adbl[16];
  char			 adbr[16];
  dk3_peer_allowed_t const	*pl;
  dk3_peer_allowed_t const	*pr;
  struct sockaddr const		*so;
  struct sockaddr_in const	*soin;
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
  struct sockaddr_in6 const	*soin6;
#endif
  unsigned long		 ull;
  unsigned long		 ulr;
  size_t		 i;
  int			 back = 0;
  if(l) {
    if(r) {
      pl = (dk3_peer_allowed_t const *)l;
      switch(cr) {
        case 1: {
	  /*	Compare address families.
	  */
	  so = (struct sockaddr const *)r;
	  switch(so->sa_family) {
	    case AF_INET: {
	      if(pl->wh) {
	        back = 1;
	      }
	    } break;
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
	    case AF_INET6: {
	      if(!(pl->wh)) {
	        back = -1;
	      }
	    } break;
#endif
	    default: {
	      back = -1;
	    } break;
	  }
	  /*	For matching address families compare addresses.
	  */
	  if(0 == back) {
	    if(pl->wh) {
	      /* Compare IPv6.
	      */
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
	      soin6 = (struct sockaddr_in6 const *)r;
	      for(i = 0; i < 16; i++) {
	        adbl[i] =
		((pl->d).ip6.ad.s6_addr[i]) & ((pl->d).ip6.ma.s6_addr[i]);
		adbr[i] =
		((soin6->sin6_addr).s6_addr[i]) & ((pl->d).ip6.ma.s6_addr[i]);
	      }
	      back = dk3mem_cmp((void *)adbl, (void *)adbr, 16);
	      if(back < -1) back = -1;
	      if(back >  1) back =  1;
#endif
	    } else {
	      /* Compare IPv4.
	      */
	      soin = (struct sockaddr_in const *)r;
	      ull = ((pl->d).ip4.ad.s_addr) & ((pl->d).ip4.ma.s_addr);
	      ulr = ((soin->sin_addr).s_addr) & ((pl->d).ip4.ma.s_addr);
	      if(ull < ulr) {
	        back = -1;
	      } else {
	        if(ull > ulr) {
		  back = 1;
		}
	      }
	    }
	  }
	} break;
	default: {
	  pr = (dk3_peer_allowed_t const *)r;
	  if(pl->wh > pr->wh) {
	    back = 1;
	  } else {
	    if(pl->wh < pr->wh) {
	      back = -1;
	    }
	  }
	  if(0 == back) {
	    switch(pl->wh) {
	      case 1: {
	        /* Compare IPv6 addresses.
		*/
#if DK3_HAVE_STRUCT_SOCKADDR_IN6
		back = dk3mem_cmp(
		  (void *)(&((pl->d).ip6.ad)),
		  (void *)(&((pr->d).ip6.ad)),
		  sizeof(IN6_ADDR)
		);
		if(back < -1) back = -1;
		if(back >  1) back =  1;
#endif
	      } break;
	      default: {
	        /* Compare IPv4 addresses.
		*/
	        if((pl->d).ip4.ad.s_addr > (pr->d).ip4.ad.s_addr) {
		  back = 1;
		} else {
		  if((pl->d).ip4.ad.s_addr < (pr->d).ip4.ad.s_addr) {
		    back = -1;
		  }
		}
	      } break;
	    }
	  }
	} break;
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}


#if (DK3_CHAR_SIZE == 2) && DK3_ON_WINDOWS

static
dk3_socket_t
dk3socket_dkchar_attempt_open_net_stream_for_local_address(
  int			 af,
  struct sockaddr const	*pAddr,
  size_t		 szAddr,
  ADDRINFOW const	*resl,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*hn
)
{
  dk3_socket_t		 back = INVALID_SOCKET;
  ADDRINFOW const	*resc;		/* Current address. */
  struct sockaddr	*soa;		/* Socket address. */
  int			 found;		/* Flag: Matching address found. */
  int			 connres;	/* Result from bind() and connect(). */
  found = 0;
  resc = resl;
  while((resc) && (INVALID_SOCKET == back)) {
    soa = resc->ai_addr;
    if(soa) {
      if(soa->sa_family == af) {
        switch(af) {
	  case AF_INET:
	  case AF_INET6: {
	    switch(soa->sa_family) {
	      case AF_INET6: {
	        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
	      } break;
	      default: {
	        back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
	      } break;
	    }
	    if(INVALID_SOCKET != back) {
	      (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	      connres = dk3socket_bind(
	        back, soa, resc->ai_addrlen, ec, app
	      );
	      if(connres) {
	        connres = dk3socket_connect_nb(
		  back, pAddr, szAddr, secs, usecs, ec, app, hn, 0
		);
		if(!(connres)) {			

#line 7184 "dk3sock.ctr"
		  dk3socket_close(back, NULL, NULL);
		  back = INVALID_SOCKET;
		}
	      } else {					

#line 7188 "dk3sock.ctr"
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    } else {					

#line 7192 "dk3sock.ctr"
	    }
	  } break;
	  default: {					

#line 7195 "dk3sock.ctr"
	  } break;
	}
      } else {						

#line 7198 "dk3sock.ctr"
      }
    } else {						

#line 7200 "dk3sock.ctr"
    }
    resc = resc->ai_next;
  }
  return back;
}


/**	Attempt to open a client socket.
	@param	hai	Server host address information.
	@param	lai	Client (local) host address information, may be NULL.
	@param	secs	Timeout seconds.
	@param	usecs	Timeout microseconds.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@param	sh	Server host name.
	@return	Valid socket on success, INVALID_SOCKET on error.
*/
static
dk3_socket_t
dk3socket_dkchar_attempt_open_net_stream_client(
  ADDRINFOW	const	*hai,
  ADDRINFOW	const *lai,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app,
  dkChar const		*sh
)
{
  ADDRINFOW	const	*resc;
  ADDRINFOW	const	*resl;
  struct sockaddr	*soa;
  struct sockaddr	*sol;
  dk3_socket_t		 back = INVALID_SOCKET;
  int			 found;
  int			 connres;
  

#line 7237 "dk3sock.ctr"
  found = 0;
  resc = hai;
  while((resc) && (INVALID_SOCKET == back)) {	

#line 7240 "dk3sock.ctr"
    soa = resc->ai_addr;
    if(soa) {					

#line 7242 "dk3sock.ctr"
      if(lai) {
        resl = lai;
	while((resl) && (INVALID_SOCKET == back)) {
	  sol = resl->ai_addr;
	  if(sol) {
	    if(soa->sa_family == sol->sa_family) {
	      switch(soa->sa_family) {
	        case AF_INET: case AF_INET6: {
		  found = 1;
		  switch(soa->sa_family) {
		    case AF_INET6: {
		      back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
		    } break;
		    default: {
		      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
		    } break;
		  }
		  if(INVALID_SOCKET != back) {
		    (void)dk3socket_set_reuse(back, 1, NULL, NULL);
		    connres = dk3socket_bind(
		      back, sol, resl->ai_addrlen, ec, app
		    );
		    if(connres) {
		      connres = dk3socket_connect_nb(
		        back, soa, resc->ai_addrlen, secs, usecs, ec, app, sh, 0
		      );
		      if(!(connres)) {			

#line 7269 "dk3sock.ctr"
		        dk3socket_close(back, NULL, NULL);
			back = INVALID_SOCKET;
		      }
		    } else {				

#line 7273 "dk3sock.ctr"
		      dk3socket_close(back, NULL, NULL);
		      back = INVALID_SOCKET;
		    }
		  } else {				

#line 7277 "dk3sock.ctr"
		  }
		} break;
		default: {				

#line 7280 "dk3sock.ctr"
		} break;
	      }
	    } else {					

#line 7283 "dk3sock.ctr"
	    }
	  } else {					

#line 7285 "dk3sock.ctr"
	  }
	  resl = resl->ai_next;
	}
      } else {						

#line 7289 "dk3sock.ctr"
        switch(soa->sa_family) {
          case AF_INET: {
	    found = 1;
	    back = dk3socket_open(AF_INET, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back, soa, resc->ai_addrlen, secs, usecs, ec, app, sh, 0
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
	        back = INVALID_SOCKET;
	      }
	    }
	  } break;
	  case AF_INET6: {
	    found = 1;
	    back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, ec, app);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back, soa, resc->ai_addrlen, secs, usecs, ec, app, sh, 0
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
	        back = INVALID_SOCKET;
	      }
	    }
	  } break;
	  default: {
	  } break;
        }
      }
    } else {					

#line 7321 "dk3sock.ctr"
    }
    resc = resc->ai_next;
  }
  

#line 7325 "dk3sock.ctr"
  return back;
}



/**	Set netmask part of allowed peer.
	@param	dp	Destination pointer (allowed peer).
	@param	src	Source text containing the network mask.
	@param	app	Application structure for diagnostics.
	@param	is6	Flag: We are searching for IPv6 address.
	@return	1 on success, 0 on error.
*/
static
int
dknet_dkchar_allowed_mask(
  dk3_peer_allowed_t *dp, dkChar *src, dk3_app_t *app, int is6
)
{
  IN6_ADDR	 ip6mask;		/* IPv6 net mask. */
  IN_ADDR	 ip4mask;		/* IPv4 net mask. */
  unsigned	 u;			/* Number of bits to set. */
  int		 res;			/* Operation result. */
  int		 back = 0;

  if(is6) {
    if(src) {
      if(dk3str_chr(src, dkT(':'))) {
        res = dk3socket_dkchar_inet_pton(
	  AF_INET6, src, (void *)(&ip6mask), NULL, NULL
	);
	if(res) {
	  back = 1;
	} else {
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 356); }
	}
      } else {
#if VERSION_BEFORE_20140716
        if(dk3sf_sscanf3(src, dkT("%u"), &u) == 1)
#else
	if(dk3ma_ui_from_string(&u, src, NULL))
#endif
	{
	  back = 1;
	  dk3socket_ip6_fill_bits(&ip6mask, u);
	} else {
	  if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 355); }
	}
      }
    } else {
      back = 1;
      dk3socket_ip6_fill_bits(&((dp->d).ip6.ma), 128);
    }
    if(back) {
      dk3mem_cpy(
        (void *)(&((dp->d).ip6.ma)), (void *)(&ip6mask), sizeof(IN6_ADDR)
      );
    }
  } else {
    if(src) {
      if(dk3str_chr(src, dkT('.'))) {
        res = dk3socket_dkchar_inet_pton(
	  AF_INET, src, (void *)(&ip4mask), NULL, NULL
	);
        if(res) {
          back = 1;
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 354); }
        }
      } else {
#if VERSION_BEFORE_20140716
        if(dk3sf_sscanf3(src, dkT("%u"), &u) == 1)
#else
	if(dk3ma_ui_from_string(&u, src, NULL))
#endif
	{
          back = 1;
	  dk3socket_ip4_fill_bits(&ip4mask, u);
        } else {
          if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 355); }
        }
      }
    } else {
      back = 1;
      ip4mask.s_addr = 0xFFFFFFFFUL;
    }
    if(back) {
      dk3mem_cpy(
        (void *)(&((dp->d).ip4.ma)), (void *)(&ip4mask), sizeof(IN_ADDR)
      );
    }
  }
  return back;
}

#endif

dk3_socket_t
dk3socket_dkchar_open_net_stream_client(
  dkChar const		*sh,
  unsigned short	 sp,
  unsigned short	 lp,
  long			 secs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No support for wide char socket functions!"
#else
#if DK3_ON_WINDOWS
  dkChar		 lbuf[64];			/* Server port text. */
  dkChar		 pbuf[64];			/* Local port text. */
  IN6_ADDR		 in6;				/* IPv6 address. */
  IN_ADDR		 in4;				/* IPv4 address. */
  dk3_socket_t		 back	=	INVALID_SOCKET;
  ADDRINFOW		 hs;
  ADDRINFOW		 hl;
  ADDRINFOW		*ress	=	NULL;
  ADDRINFOW		*resl	=	NULL;
  struct sockaddr_in	 soin4;
  struct sockaddr_in6	 soin6;
  int			 resgai;
  int			 connres;
  

#line 7451 "dk3sock.ctr"
  if(sp) {
    if(sh) {						

#line 7453 "dk3sock.ctr"
      ress = NULL;
      resl = NULL;
      resgai = 0;
      if(lp) {						

#line 7457 "dk3sock.ctr"
#if VERSION_BEFORE_20140716
        dk3sf_sprintf3(lbuf, dkT("%u"), (unsigned)lp);
	dk3mem_res((void *)(&hl), sizeof(ADDRINFOW));
	hl.ai_flags = AI_NUMERICSERV | AI_PASSIVE;
	hl.ai_family = AF_UNSPEC;
	hl.ai_socktype = SOCK_STREAM;
	hl.ai_protocol = 0;
	resgai = GetAddrInfoW(NULL, lbuf, &hl, &resl);
#else
	if (dk3ma_um_to_string(lbuf, DK3_SIZEOF(lbuf,dkChar), (dk3_um_t)lp)) {
	  dk3mem_res((void *)(&hl), sizeof(ADDRINFOW));
	  hl.ai_flags = AI_NUMERICSERV | AI_PASSIVE;
	  hl.ai_family = AF_UNSPEC;
	  hl.ai_socktype = SOCK_STREAM;
	  hl.ai_protocol = 0;
	  resgai = GetAddrInfoW(NULL, lbuf, &hl, &resl);
	}
#endif
      }
      if(((0 == resgai) && (resl)) || (0 == lp)) {
        resgai = dk3socket_dkchar_inet_pton(
	  AF_INET, sh, (void *)(&in4), NULL, NULL
	);
	if(1 == resgai) {
	  dk3mem_res((void *)(&soin4), sizeof(struct sockaddr_in));
	  soin4.sin_family = AF_INET;
	  soin4.sin_port = htons(sp);
	  dk3mem_cpy(
	    (void *)(&(soin4.sin_addr)),
	    (void *)(&(in4)),
	    sizeof(IN_ADDR)
	  );
	  if(lp) {
	    back = dk3socket_dkchar_attempt_open_net_stream_for_local_address(
	      AF_INET, (struct sockaddr *)(&soin4), sizeof(soin4),
	      resl, secs, usecs, NULL, NULL, sh
	    );
	  } else {
	    back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
	    if(INVALID_SOCKET != back) {
	      connres = dk3socket_connect_nb(
	        back,
		(struct sockaddr *)(&soin4), sizeof(struct sockaddr_in),
		secs, usecs, NULL, NULL, sh, 0
	      );
	      if(!(connres)) {
	        dk3socket_close(back, NULL, NULL);
		back = INVALID_SOCKET;
	      }
	    } else {					

#line 7507 "dk3sock.ctr"
	    }
	  }
	} else {					

#line 7510 "dk3sock.ctr"
	}
	if(INVALID_SOCKET == back) {			

#line 7512 "dk3sock.ctr"
	  resgai = dk3socket_dkchar_inet_pton(
	    AF_INET6, sh, (void *)(&in6), NULL, NULL
	  );
	  if(1 == resgai) {
	    dk3mem_res((void *)(&soin6), sizeof(struct sockaddr_in6));
	    soin6.sin6_family = AF_INET6;
	    soin6.sin6_port = htons(sp);
	    dk3mem_cpy(
	      (void *)(&(soin6.sin6_addr)),
	      (void *)(&in6),
	      sizeof(IN6_ADDR)
	    );
	    if(lp) {
	      back = dk3socket_dkchar_attempt_open_net_stream_for_local_address(
	        AF_INET6, (struct sockaddr *)(&soin6), sizeof(soin6),
		resl, secs, usecs, NULL, NULL, sh
	      );
	    } else {
	      back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
	      if(INVALID_SOCKET != back) {
	        connres = dk3socket_connect_nb(
		  back,
		  (struct sockaddr *)(&soin6), sizeof(struct sockaddr_in6),
		  secs, usecs, NULL, NULL, sh,0 
		);
		if(!(connres)) {
		  dk3socket_close(back, NULL, NULL);
		  back = INVALID_SOCKET;
		}
	      }
	    }
	  }
	}
	if(INVALID_SOCKET == back) {			

#line 7546 "dk3sock.ctr"
#if VERSION_BEFORE_20140716
	  dk3sf_sprintf3(pbuf, dkT("%u"), (unsigned)sp);
	  dk3mem_res((void *)(&hs), sizeof(struct addrinfo));
	  hs.ai_flags = AI_NUMERICSERV;
	  hs.ai_family = AF_UNSPEC;
	  hs.ai_socktype = SOCK_STREAM;
	  hs.ai_protocol = 0;
	  resgai = GetAddrInfoW(sh, pbuf, &hs, &ress);
	  if((0 == resgai) && (ress)) {			

#line 7555 "dk3sock.ctr"
	    back = dk3socket_dkchar_attempt_open_net_stream_client(
	      ress, ((lp) ? (resl) : NULL), secs, usecs, NULL, NULL, sh
	    );
	  } else {					

#line 7559 "dk3sock.ctr"
	    dk3socket_error_getaddrinfo(ec, app, resgai);
	  }
	  if(ress) {
	    FreeAddrInfoW(ress); ress = NULL;
	  }
#else
	  if (dk3ma_um_to_string(pbuf, DK3_SIZEOF(pbuf,dkChar), (dk3_um_t)sp)) {
	    dk3sf_sprintf3(pbuf, dkT("%u"), (unsigned)sp);
	    dk3mem_res((void *)(&hs), sizeof(struct addrinfo));
	    hs.ai_flags = AI_NUMERICSERV;
	    hs.ai_family = AF_UNSPEC;
	    hs.ai_socktype = SOCK_STREAM;
	    hs.ai_protocol = 0;
	    resgai = GetAddrInfoW(sh, pbuf, &hs, &ress);
	    if((0 == resgai) && (ress)) {		

#line 7574 "dk3sock.ctr"
	      back = dk3socket_dkchar_attempt_open_net_stream_client(
	        ress, ((lp) ? (resl) : NULL), secs, usecs, NULL, NULL, sh
	      );
	    } else {					

#line 7578 "dk3sock.ctr"
	      dk3socket_error_getaddrinfo(ec, app, resgai);
	    }
	    if(ress) {
	      FreeAddrInfoW(ress); ress = NULL;
	    }
	  }
#endif
	}
      } else {
        /* ERROR: No local addresses found */
      }
      if(resl) {
        FreeAddrInfoW(resl); resl = NULL;
      }
    } else {						

#line 7593 "dk3sock.ctr"
      back = dk3socket_open(AF_INET, SOCK_STREAM, 0, NULL, NULL);
      if(INVALID_SOCKET != back) {
        if(lp) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip4addr_set_localhost(&soin4);
	  soin4.sin_port = htons(lp);
	  connres = dk3socket_bind(
	    back, (struct sockaddr *)(&soin4), sizeof(soin4),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
      if(INVALID_SOCKET != back) {
        dk3socket_ip4addr_set_localhost(&soin4);
	soin4.sin_port = htons(sp);
	connres = dk3socket_connect_nb(
	  back,
	  (struct sockaddr *)(&soin4), sizeof(soin4),
	  secs, usecs, NULL, NULL, sh, 0
	);
	if(!(connres)) {
	  dk3socket_close(back, NULL, NULL);
	  back = INVALID_SOCKET;
	}
      }
      if(INVALID_SOCKET == back) {
        back = dk3socket_open(AF_INET6, SOCK_STREAM, 0, NULL, NULL);
        if(INVALID_SOCKET != back) {
	  (void)dk3socket_set_reuse(back, 1, NULL, NULL);
	  dk3socket_ip6addr_set_localhost(&soin6);
	  soin6.sin6_port = htons(lp);
	  connres = dk3socket_bind(
	    back,
	    (struct sockaddr *)(&soin6), sizeof(soin6),
	    NULL, NULL
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
	if(INVALID_SOCKET != back) {
	  dk3socket_ip6addr_set_localhost(&soin6);
	  soin6.sin6_port = htons(sp);
	  connres = dk3socket_connect_nb(
	    back,
	    (struct sockaddr *)(&soin6), sizeof(soin6),
	    secs, usecs, NULL, NULL, sh, 0
	  );
	  if(!(connres)) {
	    dk3socket_close(back, NULL, NULL);
	    back = INVALID_SOCKET;
	  }
	}
      }
    }
    if(INVALID_SOCKET == back) {
      if(sh) {
        if(app) { dk3app_log_i3(app, DK3_LL_ERROR, 351, 352, sh); }
      } else {
        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 282); }
      }
    }
  } else {						

#line 7661 "dk3sock.ctr"
    /* ERROR: No server port specified! */
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 7664 "dk3sock.ctr"
  return back;
#else
#error "No support for wide char socket functions!"
#endif
#endif
#else
  dk3_socket_t	back;
  back = dk3socket_open_net_stream_client(sh, sp, lp, secs, usecs, ec, app);
  return back;
#endif
}



int
dk3socket_dkchar_inet_pton(
  int		 af,
  dkChar const	*hn,
  void		*addr,
  int		*ec,
  dk3_app_t	*app
)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No support for wide char socket functions!"
#else
#if DK3_ON_WINDOWS
#if (!defined(NTDDI_VERSION)) || (NTDDI_VERSION >= NTDDI_VISTA)
  int		 back = 0;
  int		 res;
  res = InetPtonW(af, hn, addr);
  switch(res) {
    case 1: {
      back = 1;
    } break;
    case 0: {
      /* ERROR: Not an IP address! */
    } break;
    case -1: {
      dk3socket_error_inet_pton(ec, app, WSAGetLastError());
    } break;
  }
  return back;
#else
  char		 bu[128];
  int		 back = 0;
  if(dk3str_c16_to_c8_simple_app(bu, sizeof(bu), hn, app)) {
    back = dk3socket_inet_pton(af, bu, addr, ec, app);
  }
  return  back;
#endif
#else
#error "No support for wide char socket functions!"
#endif
#endif
#else
  int back;
  back = dk3socket_inet_pton(af, hn, addr, ec, app);
  return back;
#endif
}



int
dk3socket_dkchar_set_peer(
  dk3_peer_allowed_t	*dp,
  dkChar const		*sr,
  int			*ec,
  dk3_app_t		*app
)
{
#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No support for wide char socket functions!"
#else
#if DK3_ON_WINDOWS
  dkChar		 bu[DK3_MAX_PATH];
  ADDRINFOW		 hints;
  ADDRINFOW		*rgai;
  ADDRINFOW		*pai;
  IN6_ADDR		 ip6addr;
  struct sockaddr_in6	*soin6;
  IN_ADDR		 ip4addr;
  struct sockaddr_in	*soin;
  dkChar		*maptr;
  int			 res;
  int			 found;
  int			 back = 0;
  

#line 7755 "dk3sock.ctr"
  if((dp) && (sr)) {
    found = 0;
    if(dk3str_len(sr) < DK3_SIZEOF(bu,dkChar)) {
      dk3str_cpy_not_overlapped(bu, sr);
      maptr = dk3str_chr(bu, dkT('/'));
      if(maptr) {
        *(maptr++) = dkT('\0');
	maptr = dk3str_start(maptr, NULL);
      }
      res = dk3socket_dkchar_inet_pton(
        AF_INET, bu, (void *)(&ip4addr), NULL, NULL
      );
      if(res) {
        found = 1;
	dp->wh = 0;
	dk3mem_cpy(
	  (void *)(&((dp->d).ip4.ad)), (void *)(&ip4addr), sizeof(IN_ADDR)
	);
	back = dknet_dkchar_allowed_mask(dp, maptr, app, 0);
      } else {
        res = dk3socket_dkchar_inet_pton(
	  AF_INET6, bu, (void *)(&ip6addr), NULL, NULL
	);
	if(res) {
	  found = 1;
	  dp->wh = 1;
	  dk3mem_cpy(
	    (void *)(&((dp->d).ip6.ad)),
	    (void *)(&ip6addr),
	    sizeof(IN6_ADDR)
	  );
	  back = dknet_dkchar_allowed_mask(dp, maptr, app, 1);
	} else {				

#line 7788 "dk3sock.ctr"
	}
      }
      if(!(found)) {
        rgai = NULL;
	dk3mem_res((void *)(&hints), sizeof(ADDRINFOW));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = 0;
	hints.ai_protocol = 0;
	hints.ai_addrlen = 0;
	hints.ai_canonname = NULL;
	hints.ai_addr = NULL;
	hints.ai_next = NULL;
	res = GetAddrInfoW(bu, NULL, &hints, &rgai);
	if(0 == res) {
	  if(rgai) {
	    pai = rgai;
	    while((0 == back) && (pai)) {
	      switch(pai->ai_family) {
	        case AF_INET: {
		  if(sizeof(struct sockaddr_in) == pai->ai_addrlen) {
		    if(pai->ai_addr) {
		      found = 1;
		      dp->wh = 0;
		      soin = (struct sockaddr_in *)(pai->ai_addr);
		      dk3mem_cpy(
		        (void *)(&((dp->d).ip4.ad)),
			(void *)(&(soin->sin_addr)),
			sizeof(IN_ADDR)
		      );
		      back = dknet_dkchar_allowed_mask(dp, maptr, app, 0);
		    }
		  }
		} break;
		case AF_INET6: {
		  if(sizeof(struct sockaddr_in6) == pai->ai_addrlen) {
		    if(pai->ai_addr) {
		      found = 1;
		      dp->wh = 1;
		      soin6 = (struct sockaddr_in6 *)(pai->ai_addr);
		      dk3mem_cpy(
		        (void *)(&((dp->d).ip6.ad)),
			(void *)(&(soin6->sin6_addr)),
			sizeof(IN6_ADDR)
		      );
		      back = dknet_dkchar_allowed_mask(dp, maptr, app, 1);
		    }
		  }
		} break;
	      }
	      pai = pai->ai_next;
	    }
	  } else {
	  }
	} else {
	  dk3socket_error_getaddrinfo(ec, app, res);
	}
	if(rgai) {
	  FreeAddrInfoW(rgai);
	}
      }
    } else {
      /* ERROR: Host name too long! */
      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 108); }
    }
  } else {
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 7856 "dk3sock.ctr"
  return back;
#else
#error "No support for wide char socket functions!"
#endif
#endif
#else
  int back;
  back = dk3socket_set_peer(dp, sr, ec, app);
  return back;
#endif
}



dk3_socket_t
dk3socket_set_accept(
  dk3_socket_set_t	*ss,
  struct sockaddr	*pAddr,
  size_t		*pSzAddr,
  dk3_sto_it_t		*iAllowed,
  int			 skipDenied,
  long			 nsecs,
  long			 usecs,
  int			*ec,
  dk3_app_t		*app
)
{
  dkChar		 adbu[128];		/* Address text buffer. */
  dkChar		 sobu[128];		/* Socket number buffer. */
  dk3_sockaddr_storage_t sasto;			/* Peer address. */
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
  struct timeval	 to;
  fd_set		 rfds;
#endif
  void			*pp;			/* Peer pointer. */
  size_t		 i;			/* Listener index. */
  dk3_socket_t		 lisock	= INVALID_SOCKET; /* Listener socket. */
  dk3_socket_t		 max	= 0;		/* Maximum socket number. */
  dk3_socket_t		 back	= INVALID_SOCKET;
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
  int			 addrsize = 0;
#else
  socklen_t		 addrsize = 0;
#endif
  int			 mustSelect = 0;	/* Flag: Must select(). */
  int			 haveAny = 0;		/* Flag: Have any listener. */
  int			 ccloop = 0;		/* Flag: Can continue loop. */
  int			 adbures;		/* Conversion result. */
  

#line 7905 "dk3sock.ctr"
  dk3mem_res((void *)(&sasto), sizeof(sasto));
  if(ss) {						

#line 7907 "dk3sock.ctr"
    if((ss->pData) && (ss->szUsed)) {			

#line 7908 "dk3sock.ctr"
      if(ss->szUsed > 1) { mustSelect = 1; }
      if((nsecs) || (usecs)) { mustSelect = 1; }
      do {
        ccloop = 0;
	to.tv_sec = nsecs;
	to.tv_usec = usecs;
	lisock = INVALID_SOCKET;
#if DK3_ON_WINDOWS || (!(DK3_HAVE_SOCKLEN_T))
	addrsize = (int)sizeof(sasto);
#else
	addrsize = (socklen_t)sizeof(sasto);
#endif
	to.tv_sec = nsecs;
	to.tv_usec = usecs;
        if(mustSelect) {			

#line 7923 "dk3sock.ctr"
#if DK3_HAVE_SELECT || DK3_ON_WINDOWS
	  FD_ZERO(&rfds);
	  for(i = 0; i < ss->szUsed; i++) {
	    if(INVALID_SOCKET != (ss->pData)[i]) {
	      FD_SET((ss->pData)[i],&rfds);
	      haveAny = 1;		

#line 7929 "dk3sock.ctr"
	      if((ss->pData)[i] > max) {
	        max = (ss->pData)[i];
	      }
	    }
	  }
	  if(haveAny) {			

#line 7935 "dk3sock.ctr"
	    haveAny = select(
	      ((int)max + 1), &rfds, NULL, NULL, (((nsecs) || (usecs)) ? &to : NULL)
	    );				

#line 7938 "dk3sock.ctr"
#if DK3_ON_WINDOWS
	    if(SOCKET_ERROR != haveAny)
#else
	    if(haveAny > 0)
#endif
	    {				

#line 7944 "dk3sock.ctr"
	      for(i = 0; (i < ss->szUsed) && (INVALID_SOCKET == lisock); i++) {
	        if(INVALID_SOCKET != (ss->pData)[i]) {
	          if(FD_ISSET((ss->pData)[i],&rfds)) {
		    FD_CLR((ss->pData)[i],&rfds);
		    lisock = (ss->pData)[i];	

#line 7949 "dk3sock.ctr"
		  }
	        }
	      }
	    } else {			

#line 7953 "dk3sock.ctr"
	      if(0 == haveAny) {		/* Timeout */	

#line 7954 "dk3sock.ctr"
	        if(ec) { *ec = DK3_ERROR_TIMEOUT; }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 317); }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	      } else {			/* Failure */	

#line 7958 "dk3sock.ctr"
	        if(ec) { *ec = DK3_ERROR_SYSTEM; }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 317); }
	        if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 299); }
	      }
	    }
	  } else {			

#line 7964 "dk3sock.ctr"
	    /* ERROR: No valid socket in set! */
	    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 359); }
	  }
#else
	  

#line 7970 "dk3sock.ctr"
	  if(1 == ss->szUsed) {		

#line 7971 "dk3sock.ctr"
	    lisock = *(ss->pData);
	    /* Warning: Ignoring timeout! */
	    if(app) { dk3app_log_i1(app, DK3_LL_WARNING, 300); }
	  } else {			

#line 7975 "dk3sock.ctr"
	    /* ERROR: No select function! */
	    if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 358); }
	    if(ec) { *ec = DK3_ERROR_NO_SELECT; }
	  }
#endif
        } else {				

#line 7981 "dk3sock.ctr"
          lisock = *(ss->pData); 

#line 7982 "dk3sock.ctr"
        }
        if(INVALID_SOCKET != lisock) {	

#line 7984 "dk3sock.ctr"
          back = accept(lisock, (struct sockaddr *)(&sasto), &addrsize); 

#line 7985 "dk3sock.ctr"
	  if(INVALID_SOCKET == back) {	

#line 7986 "dk3sock.ctr"
	    dk3socket_error_accept(ec, app, dk3socket_error(errno));
	  }
        }
        if(INVALID_SOCKET != back) {		

#line 7990 "dk3sock.ctr"
          if(iAllowed) {
	    pp = dk3sto_it_find_like(iAllowed, (void *)(&sasto), 1);
	    if(!(pp)) {			

#line 7993 "dk3sock.ctr"
	      /* Not allowed to connect! */
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	      if(skipDenied) { ccloop = 1; }
	      if(app) {
	        if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
	          adbures = dk3socket_ipaddr_to_text(
	            adbu, DK3_SIZEOF(adbu,dkChar), (void *)(&sasto), addrsize
	          );
	          if(adbures) {
		    dk3app_log_i3(app, DK3_LL_PROGRESS, 362, 363, adbu); 
	          }
	        }
	      }
	    }
	  }
        }
        if(INVALID_SOCKET != back) {
          if((pAddr) && (pSzAddr)) {
	    if(*pSzAddr >= (size_t)addrsize) {
	      dk3mem_cpy((void *)pAddr, (void *)(&sasto), (size_t)addrsize);
	      *pSzAddr = (size_t)addrsize;
	    } else {			

#line 8016 "dk3sock.ctr"
	      /* Failed to save address! */
	      dk3socket_close(back, NULL, NULL);
	      back = INVALID_SOCKET;
	      /* Failed to save address size, buffer too small! */
	      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	      if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 38); }
	    }
	  }
        }
	if(INVALID_SOCKET != back) {
	  if(app) {
	    if(dk3app_max_log_level(app) >= DK3_LL_PROGRESS) {
	      adbures = dk3socket_ipaddr_to_text(
	        adbu, DK3_SIZEOF(adbu,dkChar), (void *)(&sasto), addrsize
	      );
	      if(adbures) {
#if VERSION_BEFORE_20140716
	        dk3sf_sprintf3(sobu,dkT("%d"),((int)back));
	        dk3app_log_i5(app, DK3_LL_PROGRESS, 360, 361, 371, sobu, adbu);
#else
		if (
		dk3ma_im_to_string(sobu,DK3_SIZEOF(sobu,dkChar),(dk3_im_t)back)
		)
		{
		  dk3app_log_i5(app,DK3_LL_PROGRESS,360,361,371,sobu,adbu);
		}
#endif
	      }
	    }
	  }
	}
      } while((ccloop) && (INVALID_SOCKET == back));
    } else {				

#line 8049 "dk3sock.ctr"
      if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      if(app) {
        /* ERROR: No usable socket in set! */
	if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	if(app) { dk3app_log_i1(app, DK3_LL_ERROR, 359); }
      }
    }
  } else {				

#line 8057 "dk3sock.ctr"
    if(ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  

#line 8060 "dk3sock.ctr"
  return back;
}



void
dk3socket_eat_input(dk3_socket_t so, dk3_app_t *app)
{
  char		bu[4096];
  int		szrd;
  do {
    szrd = dk3socket_recv(so, bu, sizeof(bu), 0L, 0L, NULL, app);
  } while(szrd > 0);
}



