/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3signl.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3signl.c The dk3signl module.
*/


#line 47 "dk3signl.ctr"

#include "dk3all.h"





#line 53 "dk3signl.ctr"



#if DK3_HAVE_SIGACTION
/**	Set new signal disposition.
	@param	signo	Signal number of signal to modify.
	@param	fct	New signal disposition.
	@return	Previous signal disposition.
*/
static
dk3_signal_disp_t
dk3signal_sigaction(int signo, dk3_signal_disp_t fct)
{
  dk3_signal_disp_t	back = (dk3_signal_disp_t)SIG_ERR;
  struct sigaction	act, oact;

  act.sa_handler = fct;
  sigemptyset(&act.sa_mask);
  if(signo == SIGALRM) {
#ifdef SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT;
#else
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;
#endif
#endif
  }
  if(sigaction(signo, &act, &oact) < 0) {
    back = (dk3_signal_disp_t)SIG_ERR;
  } else {
    back = (dk3_signal_disp_t)oact.sa_handler;
  }
  return back;
}
#endif


dk3_signal_disp_t
dk3signal_set(int signo, dk3_signal_disp_t fct)
{
  dk3_signal_disp_t	back = NULL;
#if DK3_HAVE_SIGACTION
/* + sigaction */
  back = dk3signal_sigaction(signo, fct);
/* - sigaction */
#else
#if DK3_HAVE_SIGSET
/* + sigset */
  back = (dk3_signal_disp_t)sigset(signo,fct);
/* - sigset */
#else
#if DK3_HAVE_SIGNAL
/* + signal */
  back = (dk3_signal_disp_t)signal(signo,fct);
/* - signal */
#else
#error	"No signal handling functions available"
#endif
#endif
#endif
  return back;
}



void
dk3signal_refresh(int signo, dk3_signal_disp_t fct)
{
#if DK3_HAVE_SIGACTION
#else
#if DK3_HAVE_SIGSET
#else
#if DK3_HAVE_SIGNAL
  (void)signal(signo, fct);
#else
#endif
#endif
#endif
}


int
dk3signal_available(void)
{
  int back = DK3_SIGNAL_HANDLING_TYPE_NONE;
#if DK3_HAVE_SIGACTION
  back = DK3_SIGNAL_HANDLING_TYPE_SIGACTION;
#else
#if DK3_HAVE_SIGSET
  back = DK3_SIGNAL_HANDLING_TYPE_SIGSET;
#else
#if DK3_HAVE_SIGNAL
  back = DK3_SIGNAL_HANDLING_TYPE_SIGNAL;
#endif
#endif
#endif
  return back;
}



/* vim: set ai sw=2 : */

