/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3sf.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3SF_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3SF_H_INCLUDED 1


#line 10 "dk3sf.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

#if DK3_ON_WINDOWS

/**	Retrieve information about a file.
	@param	st	File information buffer.
	@param	fn	File name.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_stat_app(dk3_stat_t *st, dk3_c16_t const *fn, dk3_app_t *app);

/**	Open a file.
	@param	fn	File name.
	@param	mo	Mode.
	@param	app	Application structure, used for diagnostics.
	@return	FILE pointer on success, NULL on error.
*/
FILE *
dk3sf_c16_fopen_app(dk3_c16_t const *fn, dk3_c16_t const *mo, dk3_app_t *app);

/**	Convert timestamp to text.
	@param	dest	Destination buffer.
	@param	sz	Size of \a dest (number of characters).
	@param	timer	Timestamp to convert.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_time_convert_app(
  dk3_c16_t *dest, size_t sz, dk3_time_t const *timer, dk3_app_t *app
);

/**	Get current working directory.
	@param	dest	Destination buffer.
	@param	sz	Size of \a dest.
	The size must not exceed INT_MAX/2.
	Practically this is not a limitation
	as the useful buffer size is DK3_MAX_PATH elements.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_getcwd_app(dk3_c16_t *dest, size_t sz, dk3_app_t *app);

/**	Find executable file.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	The size must not exceed 2^31-1. Practically this is not a
	limitation as the useful buffer size is DK3_MAX_PATH elements.
	@param	w	Current working directory.
	@param	c	Command as typed in the command line.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_find_exec_app(
  dk3_c16_t *d, size_t s, dk3_c16_t const *w, dk3_c16_t const *c, dk3_app_t *app
);

/**	Find users home directory.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_get_home_app(dk3_c16_t *d, size_t s, dk3_app_t *app);


/**	Remove (unlink) path.
 	@param	n	Path name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_remove_file_app(dk3_c16_t const *n, dk3_app_t *app);


/**	Remove directory.
	@param	n	Directory name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_remove_dir_app(dk3_c16_t const *n, dk3_app_t *app);

/**	Retrieve host name (short name, without DNS domain).
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of characters).
	The size must not exceed INT_MAX. Practically this is not a
	limitation as I have never seen host names longer than 80 characters.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_get_hostname_app(dk3_c16_t *db, size_t sz, dk3_app_t *app);

/**	Get login name.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_get_logname_app(dk3_c16_t *d, size_t s, dk3_app_t *app);


/**	Create directory if it does not yet exist.
	@param	p	Path name.
	@param	mo	Creation mode.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c16_mkdir_app(dk3_c16_t const *p, int mo, dk3_app_t *app);;

/**	Get environment variable.
	@param	name	Environment variable name.
	@return	Value on success, NULL on error.
*/
dk3_c16_t *
dk3sf_c16_getenv(dk3_c16_t const *name);

#else


#endif

/**	Retrieve information about a file.
	@param	st	File information buffer.
	@param	fn	File name.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_stat_app(dk3_stat_t *st, char const *fn, dk3_app_t *app);

/**	Open a file.
	@param	fn	File name.
	@param	mo	Mode.
	@param	app	Application structure, used for diagnostics.
	@return	FILE pointer on success, NULL on error.
*/
FILE *
dk3sf_c8_fopen_app(char const *fn, char const *mo, dk3_app_t *app);

/**	Convert timestamp to text.
	@param	dest	Destination buffer.
	@param	sz	Size of \a dest (number of characters).
	@param	timer	Timestamp to convert.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_time_convert_app(
  char *dest, size_t sz, dk3_time_t const *timer, dk3_app_t *app
);

/**	Get current working directory.
	@param	dest	Destination buffer.
	@param	sz	Size of \a dest.
	On some platforms the size is converted to int, so it
	should not exceed 32767. Practically this is not a limitation
	as the userful buffer size is DK3_MAX_PATH.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_getcwd_app(char *dest, size_t sz, dk3_app_t *app);

/**	Read input line.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of characters).
	@param	fi	Input file.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fgets(dkChar *db, size_t sz, FILE *fi);

/**	Read input line.
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of characters).
	The size must not exceed 32767 as it is converted to int on some
	systems.
	@param	fi	Input file.
	@param	fn	Input file name, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fgets_fn_app(
  dkChar *db, size_t sz, FILE *fi, dkChar const *fn, dk3_app_t *app
);

/**	Write string to file.
	@param	st	String to write.
	@param	fi	File to write to.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fputs(dkChar const *st, FILE *fi);

/**	Write string to file, report errors if any.
	@param	st	String to write.
	@param	fi	Output file to write to.
	@param	fn	File name for error messages, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fputs_fn_app(dkChar const *st,FILE *fi,dkChar const *fn,dk3_app_t *app);

/**	Write array of line strings to file.
	@param	txt	Pointer to array of lines.
	@param	fi	Output file to write to.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fputt(dkChar const * const *txt, FILE *fi);

/**	Write one character to file.
	@param	ch	Character to write.
	@param	fi	File to write to.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fputc(dkChar ch, FILE *fi);

/**	Write one character to file.
	@param	ch	Character to write.
	@param	fi	File to write to.
	@param	fn	File name of output file.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fputc_fn_app(dkChar ch, FILE *fi, dkChar const *fn, dk3_app_t *app);

/**	Write byte order marker 0xFEFF to standard output.
*/
void
dk3sf_initialize_stdout(void);

/**	Only set stdout mode, do not write byte order marker
	0xFEFF to standard output.
*/
void
dk3sf_initialize_stdout_no_bom(void);

/**	Write byte order marker 0xFEFF to standard error output.
*/
void
dk3sf_initialize_stderr(void);

/**	Write byte order marker 0xFEFF to file.
	@param	fipo	File to set up.
*/
void
dk3sf_initialize_file(FILE *fipo);

/**	Prepare standard output and standard error output for multibyte
	characters (write byte order marker 0xFEFF).
*/
void
dk3sf_initialize_output(void);

/**	Get current timestamp.
	@param	timer	Pointer to result variable.
	@return	1 on success, 0 on error.
*/
int
dk3sf_time(dk3_time_t *timer);

/**	Find executable file.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	The size should not exceed 2^32-1 as it is converted to
	a DWORD. Practically this is not a restriction as DK3_MAX_PATH
	is the useful buffer size.
	@param	w	Current working directory.
	@param	c	Command as typed in the command line.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_find_exec_app(
  char *d, size_t s, char const *w, char const *c, dk3_app_t *app
);

/**	Find users home directory.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_get_home_app(char *d, size_t s, dk3_app_t *app);

/**	Get current users login name.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of characters).
	@param	app	Application structure for diagnostics, may be NULL.
*/
int
dk3sf_c8_get_logname_app(char *d, size_t s, dk3_app_t *app);

/**	Create directory if it does not yet exist.
	@param	p	Path name.
	@param	mo	Creation mode.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_mkdir_app(char const *p, int mo, dk3_app_t *app);

/**	Remove (unlink) path.
 	@param	n	Path name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_remove_file_app(char const *n, dk3_app_t *app);

/**	Remove directory.
	@param	n	Directory name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_remove_dir_app(char const *n, dk3_app_t *app);

/**	Get current process ID.
	@return	Process ID.
*/
dk3_um_t
dk3sf_getpid(void);

/**	Check whether we must expand a file name.
	@param	fn	File name to check.
	@return	1 for "must expand", 0 for "no need to expand".
*/
int
dk3sf_must_expand(dkChar const *fn);

/**	Retrieve host name (short name).
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of characters).
	The size must not exceed 2^32-1. Practically this is not a
	limitation as the useful buffer size for host name is below 256.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_get_hostname_app(char *db, size_t sz, dk3_app_t *app);

/**	Print 8-bit character to file, convert to 16 bit if necessary.
	@param	c	Character to print.
	@param	f	File to write to.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_fputc(char c, FILE *f);

/**	Print 8-bit character string to file, convert to 16 bit if necessary.
	@param	s	String to print.
	@param	f	File to write to.
	@return	1 on success, 0 on error.
*/
int
dk3sf_c8_fputs(char const *s, FILE *f);

/**	Read bytes from file descriptor into buffer.
	@param	fd	File descriptor.
	@param	buf	Buffer.
	@param	s	Size of \a buf.
	The size must not exceed 65535 as it is converted to unsigned int
	on some systems.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Number of bytes read.
*/
size_t
dk3sf_read_app(int fd, void *buf, size_t s, dk3_app_t *app);

/**	Write bytes to file descriptor.
	@param	fd	File descriptor.
	@param	buf	Buffer to write.
	@param	s	Size of \a buf in bytes.
	The size must not exceed 65535 as it is converted to unsigned int
	on some systems.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 for success (all bytes written), 0 on error.
*/
int
dk3sf_write_app(int fd, char const *buf, size_t s, dk3_app_t *app);

/**	Read from file.
	@param	db	Destination buffer.
	@param	sz	Size of one element.
	@param	ne	Number of elements.
	@param	fi	File to read from.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Number of elements read.
*/
size_t
dk3sf_fread_app(void *db, size_t sz, size_t ne, FILE *fi, dk3_app_t *app);

/**	Write to file.
	@param	sb	Source buffer.
	@param	sz	Size of one element.
	@param	ne	Number of elements.
	@param	fi	File to write to.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success (all elements written), 0 on error.
*/
int
dk3sf_fwrite_app(void const *sb,size_t sz,size_t ne,FILE *fi,dk3_app_t *app);

/**	Inspect file, search for byte order marker.
	The function inspects the first 4 bytes from file and attempts
	to find the file encoding (DK3_FILE_ENCODING_xxx).
	If there is no BOM at the beginning of the file the default
	value \a dv is returned. A value for \a dv can be obtained
	from dk3app_get_output_encoding() or by inspecting the DK3_CHAR_SIZE
	value and the language setting (ending on "UTF-8" or "utf8"?).
	@param	fn	File name.
	@param	dv	Default value for file encoding.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	File encoding if BOM found, default value \a dv otherwise.
*/
int
dk3sf_inspect_bom_app(dkChar const *fn, int dv, dk3_app_t *app);

/**	Inspect file, search for byte order marker. If byte order marker
	is found save number of bytes to skip at beginning of file
	to variable.
	The function inspects the first 4 bytes from file and attempts
	to find the file encoding (DK3_FILE_ENCODING_xxx).
	If there is no BOM at the beginning of the file the default
	value \a dv is returned. A value for \a dv can be obtained
	from dk3app_get_output_encoding() or by inspecting the DK3_CHAR_SIZE
	value and the language setting (ending on "UTF-8" or "utf8"?).
	@param	fn	File name.
	@param	dv	Default value for file encoding.
	@param	skb	Pointer to size_t variable for number of bytes
			to skip at the beginning of the file.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	File encoding if BOM found, default value \a dv otherwise.
*/
int
dk3sf_inspect_bom_skip_app(
  dkChar const	*fn,
  int		 dv,
  size_t	*skb,
  dk3_app_t	*app
);

/**	Attempt to apply an encoding found from BOM to an input FILE.
	This function has an effect on Windows systems only.
	For \a enc we can handle DK3_FILE_ENCODING_ASCII (mapped to
	_O_TEXT), DK3_FILE_ENCODING_UTF8 (mapped to _O_U8TEXT) and
	DK3_FILE_ENCODING_UTF16_LSB (mapped to _O_U16TEXT).
	@param	fipo	File pointer.
	@param	enc	Encoding found from dk3sf_inspect_bom_app().
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_apply_bom_to_file_app(FILE *fipo, int enc, dk3_app_t *app);

/**	Get environment variable.
	@param	name	Environment variable name.
	@return	Value on success, NULL on error.
*/
char *
dk3sf_c8_getenv(char const *name);

/**	Check whether or not the given file name is a directory.
	@param	n	File name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success (is directory), 0 on error.
*/
int
dk3sf_is_dir_app(dkChar const *n, dk3_app_t *app);

/**	Change into directory.
 * 	@param	dn	Directory name.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	1 on success, 0 on error.
 */
int
dk3sf_chdir_app(dkChar const *dn, dk3_app_t *app);

/**	Check whether we need to re-build a destination file from a source.
 * 	@param	dn	Destination file name.
 * 	@param	sn	Source file name.
 * 	@return	1 for rebuild necessary, 0 for not necessary.
 */
int
dk3sf_must_rebuild(dkChar const *dn, dkChar const *sn);

/**	Create 8-bit file name from dkChar file name.
	@param	fnb	File name buffer for result.
	@param	szfnb	Size of @a fnb (number of bytes).
	@param	src	Source file name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_filename_to_c8(
  char *fnb, size_t szfnb, dkChar const *src, dk3_app_t *app
);

/**	Retrieve a double value in POSIX notation from a string.
	The sscanf() function depends on the current locale setting.
	This function retrieves and saves the current locale setting,
	establishes C locale temporarily for the the sscanf() call and
	restores the original setting before exiting.
	@param	txt	Text to inspect.
	@param	v	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_scan_double_app(dkChar const *txt, double *v, dk3_app_t *app);

/**	Convert timestamp to human readable date and time.
	@param	dest	Destination structure.
	@param	timer	Source timestamp.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_localtime_app(dk3_tm_t *dest, dk3_time_t *timer, dk3_app_t *app);

/**	Retrieve maximum number of open files.
	@return	Maximum number of open files.
*/
int
dk3sf_get_max_files(void);

/**	Report error detailes.
	@param	app	Application structure for diagnostics.
	@param	err	Error code from errno.
	@param	fctn	Function name.
*/
void
dk3sf_report_errno(dk3_app_t *app, int err, dkChar const *fctn);

/**	Close a file.
	@param	fipo	FILE to close.
	@param	fn	File name, may be NULL.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fclose_fn_app(FILE *fipo, dkChar const *fn, dk3_app_t *app);

/**	Close a file.
	@param	fipo	FILE to close.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_fclose_app(FILE *fipo, dk3_app_t *app);

/**	Retrieve information about a file.
	@param	st	File information buffer.
	@param	fn	File name.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_stat_app(dk3_stat_t *st, dkChar const *fn, dk3_app_t *app);

/**	Open a file.
	@param	fn	File name.
	@param	mo	Mode.
	@param	app	Application structure, used for diagnostics.
	@return	FILE pointer on success, NULL on error.
*/
FILE *
dk3sf_fopen_app(dkChar const *fn, dkChar const *mo, dk3_app_t *app);

/**	Convert timestamp to text.
	@param	dest	Destination buffer.
	@param	sz	Size of \a dest (number of dkChar).
	@param	timer	Timestamp to convert.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_time_convert_app(
  dkChar		*dest,
  size_t		 sz,
  dk3_time_t const	*timer,
  dk3_app_t		*app
);

/**	Get current working directory.
	@param	dest	Destination buffer.
	@param	sz	Size of \a dest (number of dkChar).
	The size must not exceed INT_MAX/2. Practically this is not a
	limitation as the useful buffer size is DK3_MAX_PATH elements.
	@param	app	Application structure, used for diagnostics.
	@return	1 on success, 0 on error.
*/
int
dk3sf_getcwd_app(dkChar *dest, size_t sz, dk3_app_t *app);

/**	Find executable file.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of dkChar).
	The size must not exceed 2^31-1. Practically this is not a
	limitation as the useful buffer size is DK3_MAX_PATH elements.
	@param	w	Current working directory.
	@param	c	Command as typed in the command line.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_find_exec_app(
  dkChar	*d,
  size_t	 s,
  dkChar const	*w,
  dkChar const	*c,
  dk3_app_t	*app
);

/**	Get login name.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of dkChar).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_get_logname_app(dkChar *d, size_t s, dk3_app_t *app);

/**	Find users home directory.
	@param	d	Destination buffer.
	@param	s	Size of \a d (number of dkChar).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_get_home_app(dkChar *d, size_t s, dk3_app_t *app);

/**	Create directory if it does not yet exist.
	@param	p	Path name.
	@param	mo	Creation mode.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_mkdir_app(dkChar const *p, int mo, dk3_app_t *app);

/**	Remove (unlink) path.
 	@param	n	Path name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_remove_file_app(dkChar const *n, dk3_app_t *app);

/**	Remove directory.
	@param	n	Directory name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_remove_dir_app(dkChar const *n, dk3_app_t *app);

/**	Retrieve host name (short name, without DNS domain).
	@param	db	Destination buffer.
	@param	sz	Size of \a db (number of dkChar).
	The size must not exceed 2^31-1. Practically this is not a
	limitation as I have never seen host names longer than 80 characters.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3sf_get_hostname_app(dkChar *db, size_t sz, dk3_app_t *app);

/**	Get environment variable.
	@param	name	Environment variable name.
	@return	Value on success, NULL on error.
*/
dkChar *
dk3sf_getenv(dkChar const *name);

#ifdef __cplusplus
}
#endif



#if DK3_CHAR_SIZE > 1
#if DK3_CHAR_SIZE > 2
#error	"No functions to support large characters!"
#else
#if DK3_ON_WINDOWS

/**	Macro to choose correct character size for sscanf()/swscanf().
*/
#define	dk3sf_sscanf3(s,f,d)		swscanf(s,f,d)

/**	Macro to choose correct character size for sprintf()/swprintf().
	NOTE: The first argument must be a *buffer*, *not* a pointer.
*/
#define	dk3sf_sprintf3(s,f,d)		swprintf(s,(sizeof(s)/sizeof(wchar_t)),f,d)
#else
#error	"16 bit characters are supported on Windows platforms only!"
#endif
#endif
#else


/**	Macro to choose correct character size for sscanf().
*/
#define	dk3sf_sscanf3(s,f,d)		sscanf(s,f,d)

/**	Macro to choose correct character size for sprintf().
	NOTE: The first argument *must* be a buffer, *not* a pointer.
*/
#define	dk3sf_sprintf3(s,f,d)		sprintf(s,f,d)

#endif




#endif
