/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3se.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3se.h Header file for the dk3se module.
*/

#ifndef DK3SE_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3SE_H_INCLUDED 1


#line 9 "dk3se.ctr"

#include <dk3conf.h>
#include <dk3types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**	Write ANSI character or check ANSI compatibility.
	@param	c32	Character to write or check.
	@param	fipo	File to write to (NULL for check).
	@return	1 on success, 0 on error (No representation for this
	character in ANSI encoding).
*/
int
dk3se_ansi_fputc(dk3_c32_t c32, FILE *fipo);

/**	Write URL character or check URL compatibility.
	@param	c32	Character to write or check.
	@param	fipo	File to write to (NULL for check).
	@return	1 on success, 0 on error.
*/
int
dk3se_url_fputc(dk3_c32_t c32, FILE *fipo);

/**	Convert to ANSI and write URL character or check URL compatibility.
	@param	c32	Character to write or check.
	@param	fipo	File to write to (NULL for check).
	@return	1 on success, 0 on error.
*/
int
dk3se_ansi_url_fputc(dk3_c32_t c32, FILE *fipo);

/**	Write ANSI string or check ANSI compatibility.
	@param	str	String to write.
	@param	enc	String encoding.
	@param	fipo	File to write to (NULL for compatibility check).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3se_ansi_fputs(dkChar const *str, int enc, FILE *fipo, dk3_app_t *app);

/**	Write URL string or check URL compatibility.
	@param	str	String to write.
	@param	enc	String encoding.
	@param	fipo	File to write to (NULL for compatibility check).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3se_url_fputs(dkChar const *str, int enc, FILE *fipo, dk3_app_t *app);

/**	Convert to ANSI and write URL string or check URL compatibility.
	@param	str	String to write.
	@param	enc	String encoding.
	@param	fipo	File to write to (NULL for compatibility check).
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3se_ansi_url_fputs(dkChar const *str, int enc, FILE *fipo, dk3_app_t *app);

/**	Check whether a string can be converted to ANSI or URL.
	@param	str	String to test.
	@param	enc	String encoding.
	@param	se	Output encoding (DK3SE_ANSI and/or DK3SE_URL).
	@param	ev	Pointer to encoding violation variable.
	@param	we	Pointer to write error variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3se_check(dkChar const *str,int enc,int se,int *ev,int *we,dk3_app_t *app);

#ifdef __cplusplus
}
#endif

/**	ANSI encoding.
*/
#define	DK3SE_ANSI	1

/**	URL encoding.
*/
#define	DK3SE_URL	2


#endif
