/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3prreq.ctr
*/

/**	@file dk3prreq.c The dk3prreq module.
*/


#line 20 "dk3prreq.ctr"


#include "dk3all.h"
#include "dk3print.h"
#include "dk3prcfg.h"
#include "dk3prreq.h"



/**	Report printer details found.
	@param	pc	Print configuration.
	@param	det	Details for current printer.
	@param	pr	Current printer to process.
	@param	tp	Current printer type.
	@param	isprim	Flag: Reporting primary details.
*/
static
void
dk3prreq_details_report(
  dk3_print_conf_t	*pc, 
  dk3_printer_details_t	*det,
  dk3_printer_t		*pr,
  int			 tp,
  int			 isprim
)
{
  dkChar		 buf[16];	/* Buffer for numeric values. */
  int			 isdefault = 0;	/* Flag: This is the default printer. */
  int			 res;		/* Result from conv to string. */

  /* Type */
  dk3sf_fputs((pc->msg)[3], stdout);
  switch(tp) {
    case DK3_PRINTER_TYPE_WINDOWS: {
      dk3sf_fputs((pc->msg)[17], stdout);
    } break;
    case DK3_PRINTER_TYPE_SOCKET: {
      dk3sf_fputs((pc->msg)[18], stdout);
    } break;
    case DK3_PRINTER_TYPE_LPD: {
      dk3sf_fputs((pc->msg)[19], stdout);
    } break;
    case DK3_PRINTER_TYPE_LPRNG: {
      dk3sf_fputs((pc->msg)[20], stdout);
    } break;
    default: {
      dk3sf_fputs((pc->msg)[16], stdout);
    } break;
  }
  dk3sf_fputc(dkT('\n'), stdout);
  /* Default */
  if(isprim) {
    if(pc->defPrinter) {
      if(dk3str_cmp((pc->defPrinter)->name, pr->name) == 0) {
        isdefault = 1;
	dk3sf_fputs((pc->msg)[11], stdout);
	dk3sf_fputs((pc->msg)[21], stdout);
	dk3sf_fputc(dkT('\n'), stdout);
      }
    }
  }
  /* PS level */
  if(isprim) {
    if(pr->ps) {
#if VERSION_BEFORE_20140716
      if(dk3sf_sprintf3(buf,dkT("%d"),pr->ps))
#else
      if(0 != dk3ma_im_to_string(buf,DK3_SIZEOF(buf,dkChar),(dk3_im_t)(pr->ps)))
#endif
      {
        dk3sf_fputs((pc->msg)[10], stdout);
	dk3sf_fputs(buf, stdout);
	dk3sf_fputc(dkT('\n'), stdout);
      }
    }
  }
  /* Specific details */
  switch(tp) {
    case DK3_PRINTER_TYPE_WINDOWS: {
    } break;
    case DK3_PRINTER_TYPE_SOCKET: {
      /* Host name */
      dk3sf_fputs((pc->msg)[4], stdout);
      if((det->sock).hostname) {
        dk3sf_fputs((det->sock).hostname, stdout);
      } else {
        dk3sf_fputs((pc->msg)[16], stdout);
      }
      dk3sf_fputc(dkT('\n'), stdout);
      /* Port number */
#if VERSION_BEFORE_20140716
      if(dk3sf_sprintf3(buf,dkT("%u"),(unsigned)((det->sock).portno)))
#else
      res = dk3ma_um_to_string(
        buf, DK3_SIZEOF(buf,dkChar), (dk3_um_t)((det->sock).portno)
      );
      if (0 != res)
#endif
      {
        dk3sf_fputs((pc->msg)[7], stdout);
	dk3sf_fputs(buf, stdout);
	dk3sf_fputc(dkT('\n'), stdout);
      }
      /* Orderly release */
      dk3sf_fputs((pc->msg)[15], stdout);
      dk3sf_fputs((pc->msg)[((det->sock).ordrel) ? 21 : 22], stdout);
      dk3sf_fputc(dkT('\n'), stdout);
      /* Connect timeout */
      if((det->sock).to_c > 0.0) {
#if VERSION_BEFORE_20140716
        if(dk3sf_sprintf3(buf,dkT("%lg"), (det->sock).to_c))
#else
	if (0 != dk3ma_d_to_string(buf,DK3_SIZEOF(buf,dkChar),(det->sock).to_c))
#endif
	{
	  dk3sf_fputs((pc->msg)[7], stdout);
	  dk3sf_fputs(buf, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
      /* Send timeout */
      if((det->sock).to_s > 0.0) {
#if VERSION_BEFORE_20140716
        if(dk3sf_sprintf3(buf,dkT("%lg"), (det->sock).to_s))
#else
	if (0 != dk3ma_d_to_string(buf,DK3_SIZEOF(buf,dkChar),(det->sock).to_s))
#endif
	{
	  dk3sf_fputs((pc->msg)[8], stdout);
	  dk3sf_fputs(buf, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
      /* Receive timeout */
      if((det->sock).to_r > 0.0) {
#if VERSION_BEFORE_20140716
        if(dk3sf_sprintf3(buf,dkT("%lg"), (det->sock).to_r))
#else
	if (0 != dk3ma_d_to_string(buf,DK3_SIZEOF(buf,dkChar),(det->sock).to_r))
#endif
	{
	  dk3sf_fputs((pc->msg)[9], stdout);
	  dk3sf_fputs(buf, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
    } break;
    case DK3_PRINTER_TYPE_LPD: case DK3_PRINTER_TYPE_LPRNG: {
      /* Host name */
      dk3sf_fputs((pc->msg)[4], stdout);
      if((det->lprng).hostname) {
        dk3sf_fputs((det->lprng).hostname, stdout);
      } else {
        dk3sf_fputs((pc->msg)[16], stdout);
      }
      dk3sf_fputc(dkT('\n'), stdout);
      /* Queue name */
      dk3sf_fputs((pc->msg)[5], stdout);
      if((det->lprng).queuename) {
        dk3sf_fputs((det->lprng).queuename, stdout);
      } else {
        dk3sf_fputs((pc->msg)[16], stdout);
      }
      dk3sf_fputc(dkT('\n'), stdout);
      /* Connect timeout */
      if((det->lprng).to_c > 0.0) {
#if VERSION_BEFORE_20140716
        if(dk3sf_sprintf3(buf,dkT("%lg"), (det->lprng).to_c))
#else
	if(0 != dk3ma_d_to_string(buf,DK3_SIZEOF(buf,dkChar),(det->lprng).to_c))
#endif
	{
	  dk3sf_fputs((pc->msg)[7], stdout);
	  dk3sf_fputs(buf, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
      /* Send timeout */
      if((det->lprng).to_s > 0.0) {
#if VERSION_BEFORE_20140716
        if(dk3sf_sprintf3(buf,dkT("%lg"), (det->lprng).to_s))
#else
	if(0 != dk3ma_d_to_string(buf,DK3_SIZEOF(buf,dkChar),(det->lprng).to_s))
#endif
	{
	  dk3sf_fputs((pc->msg)[8], stdout);
	  dk3sf_fputs(buf, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
      /* Receive timeout */
      if((det->lprng).to_r > 0.0) {
#if VERSION_BEFORE_20140716
        if(dk3sf_sprintf3(buf,dkT("%lg"), (det->lprng).to_r))
#else
	if(0 != dk3ma_d_to_string(buf,DK3_SIZEOF(buf,dkChar),(det->lprng).to_r))
#endif
	{
	  dk3sf_fputs((pc->msg)[9], stdout);
	  dk3sf_fputs(buf, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
    } break;
  }
  if(isprim) {
    if((pr->h_snmp) || (pr->c_snmp) || (DK3_SNMP_VERSION_UNKNOWN != pr->v_snmp))
    {
      /* SNMP host */
      dk3sf_fputs((pc->msg)[12], stdout);
      if(pr->h_snmp) {
        dk3sf_fputs(pr->h_snmp, stdout);
      } else {
        dk3sf_fputs((pc->msg)[16], stdout);
      }
      dk3sf_fputc(dkT('\n'), stdout);
      /* SNMP version */
      dk3sf_fputs((pc->msg)[14], stdout);
      switch(pr->v_snmp) {
        case DK3_SNMP_VERSION_1: {
	  dk3sf_fputs((pc->msg)[23], stdout);
	} break;
	case DK3_SNMP_VERSION_2C: {
	  dk3sf_fputs((pc->msg)[24], stdout);
	} break;
	case DK3_SNMP_VERSION_2P: {
	  dk3sf_fputs((pc->msg)[25], stdout);
	} break;
	case DK3_SNMP_VERSION_3: {
	  dk3sf_fputs((pc->msg)[26], stdout);
	} break;
	default: {
	  dk3sf_fputs((pc->msg)[16], stdout);
	} break;
      }
      dk3sf_fputc(dkT('\n'), stdout);
      /* SNMP community */
      dk3sf_fputs((pc->msg)[13], stdout);
      if(pr->c_snmp) {
        dk3sf_fputs(pr->c_snmp, stdout);
      } else {
        dk3sf_fputs((pc->msg)[16], stdout);
      }
      dk3sf_fputc(dkT('\n'), stdout);
    }
  }
}



void
dk3prreq_report(dk3_print_conf_t *pc)
{
  void			*vptr;		/* Current printer from iterator. */
  dk3_printer_t		*pr;		/* Current printer. */
  int			 isfirst = 1;	/* Flag: Current is first to show. */

  dk3sf_initialize_stdout();
  dk3sto_it_reset(pc->iPrinters);
  while(NULL != (vptr = dk3sto_it_next(pc->iPrinters))) {
    pr = (dk3_printer_t *)vptr;
    if(isfirst) {
      isfirst = 0;
    } else {
      dk3sf_fputc(dkT('\n'), stdout);
    }
    /* Printer name */
    dk3sf_fputs((pc->msg)[0], stdout);
    dk3sf_fputc(dkT(' '), stdout);
    dk3sf_fputs(pr->name, stdout);
    dk3sf_fputc(dkT('\n'), stdout);
    /* Primary data */
    dk3sf_fputs((pc->msg)[1], stdout);
    dk3sf_fputc(dkT('\n'), stdout);
    dk3prreq_details_report(pc, &(pr->det_p), pr, pr->t_p, 1);
    if(DK3_PRINTER_TYPE_WINDOWS == pr->t_p) {
      if(DK3_PRINTER_TYPE_NONE != pr->t_s) {
        dk3sf_fputs((pc->msg)[2], stdout);
	dk3sf_fputc(dkT('\n'), stdout);
        dk3prreq_details_report(pc, &(pr->det_s), pr, pr->t_s, 0);
      }
    }
  }
}


