/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3print.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3print.h Header file for the dk3print module.
*/

#ifndef DK3PRINT_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3PRINT_H_INCLUDED 1


#line 9 "dk3print.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Clean up details for Windows printer.
	@param	ptr	Details to clean up.
*/
void
dk3print_win_det_cleanup(dk3_printer_windows_details_t *ptr);

/**	Clean up details for LPRng/LPD printer.
	@param	ptr	Details to clean up.
*/
void
dk3print_lprng_det_cleanup(dk3_printer_lprng_details_t *ptr);

/**	Clean up details for socket printer.
	@param	ptr	Details to clean up.
*/
void
dk3print_socket_det_cleanup(dk3_printer_socket_t *ptr);

/**	Clean up type-specific details for a printer.
	@param	tp	Printer type.
	@param	ptr	Pointer to details data.
*/
void
dk3print_det_cleanup(int tp, dk3_printer_details_t *ptr);

/**	Create new printer entry if necessary.
	@param	pc	Print configuration to set up.
	@param	name	Printer name.
	@return	Pointer to new or existing printer entry on success,
	NULL on error.
*/
dk3_printer_t *
dk3print_printer_new(dk3_print_conf_t *pc, dkChar const *name);

/**	Destroy printer entry in print configuration, release memory.
	@param	ptr	Printer entry to destroy.
*/
void
dk3print_printer_delete(dk3_printer_t *ptr);

/**	Destroy printer alias entry in print configuration, release memory.
	@param	ptr	Alias to destroy.
*/
void
dk3print_alias_delete(dk3_printer_alias_t *ptr);

/**	Create new print host entry if necessary.
	@param	pc	Print configuration to set up.
	@param	name	Print host name.
	@return	Pointer to new or existing printer entry on success,
	NULL on error.
*/
dk3_print_host_t *
dk3print_host_new(dk3_print_conf_t *pc, dkChar const *name);

/**	Destroy print host entry in print configuration, release memory.
	@param	ptr	Print host entry to destroy.
*/
void
dk3print_host_delete(dk3_print_host_t *ptr);

/**	Destroy print host alias entry in print configuration, release memory.
	@param	ptr	Alias to destroy.
*/
void
dk3print_host_alias_delete(dk3_print_host_alias_t *ptr);

/**	Destroy print configuration, release resources.
	@param	pc	Print configuration to destroy.
*/
void
dk3print_conf_delete(dk3_print_conf_t *pc);

/**	Create new print configuration, allocate resources for storages.
	@param	app	Application structur, must not be NULL.
	@return	Pointer to new configuration on success, NULL on error.
*/
dk3_print_conf_t *
dk3print_config_new(dk3_app_t *app);

/**	Create new print configuration, initialize it from configuration files.
	@param	app		Application structure, must not be NULL.
	@param	useConfigFiles	Flag: Use dk3print configuration files.
	@return	Pointer to new configuration on success, NULL on error.
*/
dk3_print_conf_t *
dk3print_conf_open(dk3_app_t *app, int useConfigFiles);

/**	Close print configuration.
	@param	pc	Print configuration to close.
*/
void
dk3print_conf_close(dk3_print_conf_t *pc);

/**	Initialize details based on print queue type.
	@param	det	Details to initialize.
	@param	tp	Print queue type.
*/
void
dk3print_set_det(dk3_printer_details_t *det, int tp);

/**	Find named printer (either directly or via alias).
	@param	pc	Print configuration.
	@param	pn	Printer name.
	@return	Pointer to printer on success, NULL on error (not found).
*/
dk3_printer_t *
dk3print_get_printer(dk3_print_conf_t *pc, dkChar const *pn);

/**	Find named print host (either directly or via alias).
	@param	pc	Print configuration.
	@param	hn	Host name.
	@return	Pointer to print host on success, NULL on error (not found).
*/
dk3_print_host_t *
dk3print_get_host(dk3_print_conf_t *pc, dkChar const *hn);

#ifdef __cplusplus
}
#endif


#endif
