/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3print.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3print.c The dk3print module.
*/


#line 136 "dk3print.ctr"



#include "dk3all.h"
#include "dk3print.h"
#include "dk3prcfg.h"
#include "dk3prreq.h"





#line 147 "dk3print.ctr"



/**	Keywords used by the module, not localized.
*/
static dkChar const * const dk3print_nl[] = {
/* 0 */
dkT("dk3print.conf"),

/* 1 */
dkT("dk3print.str"),

/* 2 */
dkT("PS"),

/* 3 */
dkT("PostScript"),

/* 4 */
dkT("Ghostscript PDF"),

/* 5 */
dkT("/print/ps/level"),

/* 6 */
dkT("%d"),

NULL


#line 183 "dk3print.ctr"
};



/**	Texts used by the module, normaly replaced by localized texts.
*/
static dkChar const * const dk3print_msg[] = {
/* 0 */
dkT("PRINTER:"),

/* 1 */
dkT("PRIMARY CONFIGURATION:"),

/* 2 */
dkT("SECONDARY CONFIGURATION:"),

/* 3 */
dkT("Printer type:    "),

/* 4 */
dkT("Host:            "),

/* 5 */
dkT("Queue:           "),

/* 6 */
dkT("Port:            "),

/* 7 */
dkT("Connect timeout: "),

/* 8 */
dkT("Send timeout:    "),

/* 9 */
dkT("Receive timeout: "),

/* 10 */
dkT("PS level:        "),

/* 11 */
dkT("Default:         "),

/* 12 */
dkT("SNMP host:       "),

/* 13 */
dkT("SNMP community:  "),

/* 14 */
dkT("SNMP version:    "),

/* 15 */
dkT("Orderly release: "),

/* 16 */
dkT("unknown"),

/* 17 */
dkT("Windows"),

/* 18 */
dkT("Socket"),

/* 19 */
dkT("LPD"),

/* 20 */
dkT("LPRng"),

/* 21 */
dkT("yes"),

/* 22 */
dkT("no"),

/* 23 */
dkT("1"),

/* 24 */
dkT("2c"),

/* 25 */
dkT("2p"),

/* 26 */
dkT("3"),

/* 27 */
dkT("Missing closing bracket ']'!"),

/* 28 */
dkT("Keyword \""),

/* 29 */
dkT("\" not allowed here, must be \"host\" or \"printer\"!"),

/* 30 */
dkT("Missing name for printer or host!"),

/* 31 */
dkT("Printer \""),

/* 32 */
dkT("\" already exists!"),

/* 33 */
dkT("Printer alias \""),

/* 34 */
dkT("\" already exists!"),

/* 35 */
dkT("Option \""),

/* 36 */
dkT("\" requires an argument!"),

/* 37 */
dkT("Queue type is already set!"),

/* 38 */
dkT("Unknown print queue type \""),

/* 39 */
dkT("\"!"),

/* 40 */
dkT("Overwriting host name \""),

/* 41 */
dkT("\"!"),

/* 42 */
dkT("Option \""),

/* 43 */
dkT("\" invalid for printer type!"),

/* 44 */
dkT("Overwriting queue name \""),

/* 45 */
dkT("\"!"),

/* 46 */
dkT("Overwriting port number "),

/* 47 */
dkT("!"),

/* 48 */
dkT("Numeric overflow!"),

/* 49 */
dkT("Illegal PS level \""),

/* 50 */
dkT("\", must be 2 or 3!"),

/* 51 */
dkT("Overwriting SNMP host \""),

/* 52 */
dkT("\"!"),

/* 53 */
dkT("Overwriting SNMP community \""),

/* 54 */
dkT("\"!"),

/* 55 */
dkT("Overwriting SNMP version!"),

/* 56 */
dkT("Unknown SNMP version \""),

/* 57 */
dkT("\"!"),

/* 58 */
dkT("Overwriting receive timeout \""),

/* 59 */
dkT("\"!"),

/* 60 */
dkT("Overwriting send timeout \""),

/* 61 */
dkT("\"!"),

/* 62 */
dkT("Overwriting connect timeout \""),

/* 63 */
dkT("\"!"),

/* 64 */
dkT("Unknown configuration option \""),

/* 65 */
dkT("\"!"),

/* 66 */
dkT("Print host \""),

/* 67 */
dkT("\" already exists!"),

/* 68 */
dkT("Print host alias \""),

/* 69 */
dkT("\" already exists!"),

/* 70 */
dkT("Illegal encoding \""),

/* 71 */
dkT("\" for LPD protocol!"),

/* 72 */
dkT("Line outside scope, not belonging to printer or host!"),

NULL


#line 415 "dk3print.ctr"
};



void
dk3print_win_det_cleanup(dk3_printer_windows_details_t *ptr)
{
  

#line 423 "dk3print.ctr"
  if(ptr) {
  }
  

#line 426 "dk3print.ctr"
}



void
dk3print_lprng_det_cleanup(dk3_printer_lprng_details_t *ptr)
{
  

#line 434 "dk3print.ctr"
  if(ptr) {
    dk3_release(ptr->hostname);
    dk3_release(ptr->queuename);
  }
  

#line 439 "dk3print.ctr"
}



void
dk3print_socket_det_cleanup(dk3_printer_socket_t *ptr)
{
  

#line 447 "dk3print.ctr"
  if(ptr) {
    dk3_release(ptr->hostname);
    ptr->portno = 0;
    ptr->ordrel = 0x00;
  }
  

#line 453 "dk3print.ctr"
}



void
dk3print_det_cleanup(int tp, dk3_printer_details_t *ptr)
{
  

#line 461 "dk3print.ctr"
  if(ptr) {
    switch(tp) {
      case DK3_PRINTER_TYPE_WINDOWS: {
        dk3print_win_det_cleanup(&(ptr->win));
      } break;
      case DK3_PRINTER_TYPE_SOCKET: {
        dk3print_socket_det_cleanup(&(ptr->sock));
      } break;
      case DK3_PRINTER_TYPE_LPD: {
        dk3print_lprng_det_cleanup(&(ptr->lprng));
      } break;
      case DK3_PRINTER_TYPE_LPRNG: {
        dk3print_lprng_det_cleanup(&(ptr->lprng));
      } break;
    }
  }
  

#line 478 "dk3print.ctr"
}



void
dk3print_printer_delete(dk3_printer_t *ptr)
{
  

#line 486 "dk3print.ctr"
  if(ptr) {
    dk3print_det_cleanup(ptr->t_p, &(ptr->det_p));
    dk3print_det_cleanup(ptr->t_s, &(ptr->det_s));
    dk3_release(ptr->name);
    dk3_release(ptr->h_snmp);
    dk3_release(ptr->c_snmp);
    dk3_delete(ptr);
  } 

#line 494 "dk3print.ctr"
}



dk3_printer_t *
dk3print_printer_new(dk3_print_conf_t *pc, dkChar const *name)
{
  dk3_printer_t		*back = NULL;
  if((pc) && (name)) {
    back =
    (dk3_printer_t *)dk3sto_it_find_like(pc->iPrinters, (void *)name, 1);
    if(!(back)) {
      back = dk3_new_app(dk3_printer_t,1,pc->app);
      if(back) {
        back->name = NULL;
	back->h_snmp = NULL;
	back->c_snmp = 0;
	back->t_p = DK3_PRINTER_TYPE_NONE;
	back->t_s = DK3_PRINTER_TYPE_NONE;
	back->v_snmp = DK3_SNMP_VERSION_UNKNOWN;
	back->ps = 0;
	back->name = dk3str_dup_app(name, pc->app);
	if(back->name) {
	  if(!dk3sto_add(pc->sPrinters, back)) {
	    dk3print_printer_delete(back);
	    back = NULL;
	  }
	} else {
	  dk3print_printer_delete(back);
	  back = NULL;
	}
      }
    }
    if(back) {
      if(!(pc->defPrinter)) {
        pc->defPrinter = back;
      }
    }
  }
  return back;
}



void
dk3print_alias_delete(dk3_printer_alias_t *ptr)
{
  

#line 542 "dk3print.ctr"
  if(ptr) {
    dk3_release(ptr->name);
    ptr->printer = NULL;
    dk3_delete(ptr);
  }
  

#line 548 "dk3print.ctr"
}



void
dk3print_host_delete(dk3_print_host_t *ptr)
{
  

#line 556 "dk3print.ctr"
  if(ptr) {
    dk3_release(ptr->name);
    dk3_delete(ptr);
  }
  

#line 561 "dk3print.ctr"
}



dk3_print_host_t *
dk3print_host_new(dk3_print_conf_t *pc, dkChar const *name)
{
  dk3_print_host_t	*back = NULL;
  if((pc) && (name)) {
    back =
    (dk3_print_host_t *)dk3sto_it_find_like(pc->iPrintHosts, (void *)name, 1);
    if(!(back)) {
      back = dk3_new_app(dk3_print_host_t,1,pc->app);
      if(back) {
        back->name = NULL;
	/* Further initialization. */
	back->to_c = -1.0;
	back->to_r = -1.0;
	back->to_s = -1.0;
	back->enc  = DK3_ENCODING_UTF8;
	/* Save name. */
	back->name = dk3str_dup_app(name, pc->app);
	if(back->name) {
	  /* Add to configuration. */
	  if(!dk3sto_add(pc->sPrintHosts, back)) {
	    dk3print_host_delete(back);
	    back = NULL;
	  }
	} else {
	  dk3print_host_delete(back);
	  back = NULL;
	}
      }
    }
    if(back) {
      if(!(pc->defHost)) {
        pc->defHost = back;
      }
    }
  }
  return back;
}



void
dk3print_host_alias_delete(dk3_print_host_alias_t *ptr)
{
  

#line 610 "dk3print.ctr"
  if(ptr) {
    dk3_release(ptr->name);
    ptr->host = NULL;
    dk3_delete(ptr);
  }
  

#line 616 "dk3print.ctr"
}



void
dk3print_conf_delete(dk3_print_conf_t *pc)
{
  void		*vptr;	/* Current element to delete. */

  

#line 626 "dk3print.ctr"
  if(pc) {
    pc->defPrinter = NULL;
    pc->defHost = NULL;
    if(pc->sHostAliases) {
      if(pc->iHostAliases) {
        dk3sto_it_reset(pc->iHostAliases);
	while(NULL != (vptr = dk3sto_it_next(pc->iHostAliases))) {
	  dk3print_host_alias_delete((dk3_print_host_alias_t *)vptr);
	}
	dk3sto_it_close(pc->iHostAliases);
      }
      dk3sto_close(pc->sHostAliases);
    } pc->sHostAliases = NULL; pc->iHostAliases = NULL;
    if(pc->sPrintHosts) {
      if(pc->iPrintHosts) {
        dk3sto_it_reset(pc->iPrintHosts);
	while(NULL != (vptr = dk3sto_it_next(pc->iPrintHosts))) {
	  dk3print_host_delete((dk3_print_host_t *)vptr);
	}
	dk3sto_it_close(pc->iPrintHosts);
      }
      dk3sto_close(pc->sPrintHosts);
    } pc->sPrintHosts = NULL; pc->iPrintHosts = NULL;
    if(pc->sPrintAliases) {
      if(pc->iPrintAliases) {
        dk3sto_it_reset(pc->iPrintAliases);
	while(NULL != (vptr = dk3sto_it_next(pc->iPrintAliases))) {
	  dk3print_alias_delete((dk3_printer_alias_t *)vptr);
	}
	dk3sto_it_close(pc->iPrintAliases);
      }
      dk3sto_close(pc->sPrintAliases);
    } pc->sPrintAliases = NULL; pc->iPrintAliases = NULL;
    if(pc->sPrinters) {
      if(pc->iPrinters) {
        dk3sto_it_reset(pc->iPrinters);
	while(NULL != (vptr = dk3sto_it_next(pc->iPrinters))) {
	  dk3print_printer_delete((dk3_printer_t *)vptr);
	}
	dk3sto_it_close(pc->iPrinters);
      }
      dk3sto_close(pc->sPrinters);
    } pc->sPrinters = NULL; pc->iPrinters = NULL;
    pc->app = NULL;
    pc->msg = NULL;
    dk3_delete(pc);
  } 

#line 673 "dk3print.ctr"
}



/**	Compare two printers by name.
	@param	l	Left object.
	@param	r	Right object or name.
	@param	cr	Comparison criteria (0=printer/printer, 1=printer/name).
	@return	Comparison result.
*/
static
int
dk3print_compare_printer(void const *l, void const *r, int cr)
{
  int		 back = 0;
  dk3_printer_t const	*pl;		/* Pointer to left printer. */
  dk3_printer_t const	*pr;		/* Pointer to right printer. */
  dkChar const		*n;		/* Pointer to right name. */
  if(l) {
    if(r) {
      pl = (dk3_printer_t const *)l;
      switch(cr) {
        case 1: {
	  n  = (dkChar const *)r;
	  if(pl->name) {
	    back = dk3str_cmp(pl->name, n);
	    if(back < 0) back = -1;
	    if(back > 0) back =  1;
	  } else {
	    back = -1;
	  }
	} break;
	default: {
	  pr = (dk3_printer_t const *)r;
	  if(pl->name) {
	    if(pr->name) {
	      back = dk3str_cmp(pl->name, pr->name);
	      if(back < 0) back = -1;
	      if(back > 0) back =  1;
	    } else {
	      back = 1;
	    }
	  } else {
	    if(pr->name) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  return back;
}



/**	Compare two printer aliases by name.
	@param	l	Left object.
	@param	r	Right object or name.
	@param	cr	Comparison criteria (0=alias/alias, 1=alias/name).
	@return	Comparison result.
*/
static
int
dk3print_compare_print_alias(void const *l, void const *r, int cr)
{
  int				 back = 0;
  dk3_printer_alias_t const	*pl;		/* Left printer alias. */
  dk3_printer_alias_t const	*pr;		/* Right printer alias. */
  dkChar const			*n;		/* Right alias name. */
  if(l) {
    if(r) {
      pl = (dk3_printer_alias_t const *)l;
      switch(cr) {
        case 1: {
	  n = (dkChar const *)r;
	  if(pl->name) {
	    back = dk3str_cmp(pl->name, n);
	    if(back < 0) back = -1;
	    if(back > 0) back =  1;
	  } else {
	    back = -1;
	  }
	} break;
	default: {
	  pr = (dk3_printer_alias_t const *)r;
	  if(pl->name) {
	    if(pr->name) {
	      back = dk3str_cmp(pl->name, pr->name);
	      if(back < 0) back = -1;
	      if(back > 0) back =  1;
	    } else {
	      back = 1;
	    }
	  } else {
	    if(pr->name) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  return back;
}



/**	Compare two print hosts by name.
	@param	l	Left object.
	@param	r	Right object or name.
	@param	cr	Comparison criteria (0=host/host, 1=host/name).
	@return	Comparison result.
*/
static
int
dk3print_compare_host(void const *l, void const *r, int cr)
{
  int		 back = 0;
  dk3_print_host_t const	*pl;	/* Left print host. */
  dk3_print_host_t const	*pr;	/* Right print host. */
  dkChar const			*n;	/* Right print host name. */
  if(l) {
    if(r) {
      pl = (dk3_print_host_t const *)l;
      switch(cr) {
        case 1: {
	  n = (dkChar const *)r;
	  if(pl->name) {
	    back = dk3str_cmp(pl->name, n);
	    if(back < 0) back = -1;
	    if(back > 0) back =  1;
	  } else {
	    back = -1;
	  }
	} break;
	default: {
	  pr = (dk3_print_host_t const *)r;
	  if(pl->name) {
	    if(pr->name) {
	      back = dk3str_cmp(pl->name, pr->name);
	      if(back < 0) back = -1;
	      if(back > 0) back =  1;
	    } else {
	      back = 1;
	    }
	  } else {
	    if(pr->name) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  return back;
}



/**	Compare two print host aliases by name.
	@param	l	Left object.
	@param	r	Right object or name.
	@param	cr	Comparison criteria (0=alias/alias, 1=alias/name).
	@return	Comparison result.
*/
static
int
dk3print_compare_host_alias(void const *l, void const *r, int cr)
{
  int		 		 back = 0;
  dk3_print_host_alias_t const	*pl;		/* Left host alias. */
  dk3_print_host_alias_t const	*pr;		/* Right host alias. */
  dkChar const			*n;		/* Right alias name. */
  if(l) {
    if(r) {
      pl = (dk3_print_host_alias_t const *)l;
      switch(cr) {
        case 1: {
	  n = (dkChar const *)r;
	  if(pl->name) {
	    back = dk3str_cmp(pl->name, n);
	    if(back < 0) back = -1;
	    if(back > 0) back =  1;
	  } else {
	    back = -1;
	  }
	} break;
	default: {
	  pr = (dk3_print_host_alias_t const *)r;
	  if(pl->name) {
	    if(pr->name) {
	      back = dk3str_cmp(pl->name, pr->name);
	      if(back < 0) back = -1;
	      if(back > 0) back =  1;
	    } else {
	      back = 1;
	    }
	  } else {
	    if(pr->name) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  return back;
}



dk3_print_conf_t *
dk3print_config_new(dk3_app_t *app)
{
  dk3_print_conf_t	*back	= NULL;
  int			 ok	= 0;	/* Flag: Success. */
  

#line 915 "dk3print.ctr"
  if(app) {
    back = dk3_new_app(dk3_print_conf_t,1,app);
    if(back) {
      /* Initialize members. */
      back->sPrinters = NULL; back->iPrinters = NULL;
      back->sPrintAliases = NULL; back->iPrintAliases = NULL;
      back->sPrintHosts = NULL; back->iPrintHosts = NULL;
      back->defPrinter = NULL;
      back->defHost = NULL;
      back->defPsl = 3;
      back->app = app;
      back->msg = dk3app_messages(app, dk3print_nl[1], dk3print_msg);
      if(!(back->msg)) { back->msg = dk3print_msg; }
      /* Allocate resources for storages. */
      back->sPrinters = dk3sto_open_app(app);
      if(back->sPrinters) {
        dk3sto_set_comp(back->sPrinters, dk3print_compare_printer, 0);
        back->iPrinters = dk3sto_it_open(back->sPrinters);
        if(back->iPrinters) {
          back->sPrintAliases = dk3sto_open_app(app);
	  if(back->sPrintAliases) {
	    dk3sto_set_comp(back->sPrintAliases,dk3print_compare_print_alias,0);
	    back->iPrintAliases = dk3sto_it_open(back->sPrintAliases);
	    if(back->iPrintAliases) {
	      back->sPrintHosts = dk3sto_open_app(app);
	      if(back->sPrintHosts) {
	        dk3sto_set_comp(back->sPrintHosts, dk3print_compare_host, 0);
	        back->iPrintHosts = dk3sto_it_open(back->sPrintHosts);
	        if(back->iPrintHosts) {
	          back->sHostAliases = dk3sto_open_app(app);
		  if(back->sHostAliases) {
		    dk3sto_set_comp(
		      back->sHostAliases, dk3print_compare_host_alias, 0
		    );
		    back->iHostAliases = dk3sto_it_open(back->sHostAliases);
		    if(back->iHostAliases) {
		      ok = 1;
		    }
		  }
	        }
	      }
	    }
	  }
        }
      }
      /* Destroy configuration if allocations failed. */
      if(!(ok)) {
        dk3print_conf_delete(back);
        back = NULL;
      }
    }
  } 

#line 967 "dk3print.ctr"
  return back;
}


#if DK3_ON_WINDOWS

/**	Check whether a printer name contains the words
	"PostScript" or "PS".
	@param	pc	Print configuration to set up.
	@param	pr	Printer structure to modify.
	@param	str	Printer string to check.
*/
static
void
dk3print_check_postscript(
  dk3_print_conf_t	*pc,
  dk3_printer_t		*pr,
  dkChar const		*str
)
{
  dkChar		 buf[DK3_MAX_PATH];	/* Private copy. */
  dkChar		*c;			/* Current string. */
  dkChar		*n;			/* Next string. */

  if(!(pr->ps)) {
    if(dk3str_len(str) < DK3_SIZEOF(buf,dkChar)) {
      dk3str_cpy_not_overlapped(buf, str);
      c = dk3str_start(buf, NULL);
      while(c) {
        n = dk3str_next(c, NULL);
	if(dk3str_cmp(c, dk3print_nl[2]) == 0) {
	  pr->ps = pc->defPsl;
	} else {
	  if(dk3str_casecmp(c, dk3print_nl[3]) == 0) {
	    pr->ps = pc->defPsl;
	  }
	}
	c = n;
      }
    }
    if(!(pr->ps)) {
      if(dk3str_casecmp(str, dk3print_nl[4]) == 0) {
        pr->ps = pc->defPsl;
      }
    }
  }
}

#endif



#if DK3_ON_WINDOWS
/* + Windows */

/**	Read printer information from system.
	@param	pc	Print configuration to set up.
	@return	1 on success, 0 on error.
*/
static
int
dk3print_read_system(dk3_print_conf_t *pc)
{
  dkChar		 buf[1024];	/* Default printer name. */
  char			*peb;		/* Result buffer. */
#if DK3_CHAR_SIZE > 1
  PRINTER_INFO_2W	*pi2;		/* Printer information. */
#else
  PRINTER_INFO_2A	*pi2;		/* Printer information. */
#endif
  dk3_printer_t		*printer;	/* New printer to create. */
  DWORD			 cbNeeded;	/* Bytes needed. */
  DWORD			 cbReturned;	/* Bytes returned. */
  DWORD			 szPeb;		/* Size of peb. */
  DWORD			 i;		/* Index of current information. */
  DWORD			 dwSz;		/* Buffer size. */
  BOOL			 res;		/* Operation result. */
  int			 back = 1;
  

#line 1046 "dk3print.ctr"
  cbNeeded = cbReturned = szPeb = (DWORD)0UL;
#if DK3_CHAR_SIZE > 1
  EnumPrintersW(PRINTER_ENUM_LOCAL,NULL,2,NULL,szPeb,&cbNeeded,&cbReturned);
#else
  EnumPrintersA(PRINTER_ENUM_LOCAL,NULL,2,NULL,szPeb,&cbNeeded,&cbReturned);
#endif
  if(cbNeeded > 0) {
    szPeb = cbNeeded;
    peb = dk3_new_app(char,(size_t)cbNeeded,pc->app);
    if(peb) {
      cbNeeded = cbReturned = (DWORD)0UL;
#if DK3_CHAR_SIZE > 1
      res = EnumPrintersW(
        PRINTER_ENUM_LOCAL,NULL,2,(LPBYTE)peb,szPeb,&cbNeeded,&cbReturned
      );
#else
      res = EnumPrintersA(
        PRINTER_ENUM_LOCAL,NULL,2,(LPBYTE)peb,szpeb,&cbNeeded,&cbReturned
      );
#endif
      if(res) {
        if((DWORD)0UL < cbReturned) {
	  pi2 = (PRINTER_INFO_2 *)peb;
	  for(i = (DWORD)0UL; i < cbReturned; i++) {
	    printer = dk3print_printer_new(pc, pi2->pPrinterName);
	    if(printer) {
	      printer->t_p = DK3_PRINTER_TYPE_WINDOWS;
	      if(pi2->pDriverName) {
	        dk3print_check_postscript(pc, printer, pi2->pDriverName);
	      }
	      if(pi2->pComment) {
	        dk3print_check_postscript(pc, printer, pi2->pComment);
	      }
	    } else {
	      back = 0;
	    }
	    pi2++;
	  }
	} else {			

#line 1085 "dk3print.ctr"
	}
      } else {			

#line 1087 "dk3print.ctr"
        back = 0;
      }
      dk3_delete(peb);
    } else {			

#line 1091 "dk3print.ctr"
      back = 0;
    }
    if(back) {
      dwSz = (DWORD)DK3_SIZEOF(buf,dkChar) ;
#if DK3_CHAR_SIZE > 1
      res = GetDefaultPrinterW(buf, &dwSz);
#else
      res = GetDefaultPrinterA(buf, &dwSz);
#endif
      if(res) {
        if(dwSz > (DWORD)0UL) {
	  if(dwSz < DK3_SIZEOF(buf,dkChar)) {
	    buf[dwSz - 1] = dkT('\0');
	    printer =
	    (dk3_printer_t *)dk3sto_it_find_like(pc->iPrinters, (void *)buf, 1);
	    if(printer) {
	      pc->defPrinter = printer;
	    }
	  }
	}
      }
    }
  } else {			

#line 1114 "dk3print.ctr"
  }
  

#line 1116 "dk3print.ctr"
  return back;
}

/* - Windows */

#else
/* + non-Windows */

/**	Read printer information from system.
	@param	pc	Print configuration to set up.
	@return	1 on success, 0 on error.
*/
static
int
dk3print_read_system(dk3_print_conf_t *pc)
{
  int		 back = 1;
  

#line 1134 "dk3print.ctr"
  /* ##### Read /etc/printcap */
  

#line 1136 "dk3print.ctr"
  return back;
}

/* - non-Windows */
#endif


/**	Read print configuration data from system and/or configuration files.
	@param	pc		Print configuration to set up.
	@param	useConfigFiles	Flag: Use dk3print conf files.
	@return	1 on success, 0 on error.
*/
static
int
dk3print_read_configuration(dk3_print_conf_t *pc, int useConfigFiles)
{
  dkChar	 buf[512];	/* Buffer used for values in diagnostics. */
  int		 i;		/* Temporary conversion result (PS level). */
  int		 back = 0;

  

#line 1157 "dk3print.ctr"
  /* Find default PS level from preferences */
  if(pc->app) {
    if(dk3app_get_pref(pc->app, dk3print_nl[5], buf, DK3_SIZEOF(buf,dkChar))) {
#if VERSION_BEFORE_20140716
      if(dk3sf_sscanf3(buf, dk3print_nl[6], &i) == 1)
#else
      if (0 != dk3ma_i_from_string(&i, buf, NULL))
#endif
      {
        if((2 <= i) && (3 >= i)) {
	  pc->defPsl = i;
	} else {
	  /* ERROR: PS level out of range! */
	  dk3app_log_3(pc->app, DK3_LL_ERROR, pc->msg, 49, 50, buf);
	}
      } else {
        /* ERROR: PS level not numeric! */
	dk3app_log_3(pc->app, DK3_LL_ERROR, pc->msg, 49, 50, buf);
      }
    }
  }
  /* Read system printers and configuration files. */
  if(dk3print_read_system(pc)) {
    if(useConfigFiles) {
      if(dk3print_read_config_files(pc)) {
        back = 1;
      }
    } else {
      back = 1;
    }
  } 

#line 1188 "dk3print.ctr"
  return back;
}



dk3_print_conf_t *
dk3print_conf_open(dk3_app_t *app, int useConfigFiles)
{
  dk3_print_conf_t	*back = NULL;
  

#line 1198 "dk3print.ctr"
  if(app) {
    back = dk3print_config_new(app);
    if(back) {
      if(!dk3print_read_configuration(back, useConfigFiles)) {
        dk3print_conf_delete(back);
        back = NULL;
      }
    }
  } 

#line 1207 "dk3print.ctr"
  return back;
}



void
dk3print_conf_close(dk3_print_conf_t *pc)
{
  

#line 1216 "dk3print.ctr"
  if(pc) {
    dk3print_conf_delete(pc);
  } 

#line 1219 "dk3print.ctr"
}



void
dk3print_set_det(dk3_printer_details_t *det, int tp)
{
  

#line 1227 "dk3print.ctr"
  if(det) {
    switch(tp) {
      case DK3_PRINTER_TYPE_WINDOWS: {
        (det->win).dummy = 0;
      } break;
      case DK3_PRINTER_TYPE_SOCKET: {
        (det->sock).hostname = NULL;
	(det->sock).portno = 0;
	(det->sock).ordrel = 0x00;
	(det->sock).to_c = -1.0;
	(det->sock).to_r = -1.0;
	(det->sock).to_s = -1.0;
      } break;
      case DK3_PRINTER_TYPE_LPD: case DK3_PRINTER_TYPE_LPRNG: {
        (det->lprng).hostname = NULL;
	(det->lprng).queuename = NULL;
	(det->lprng).to_c = -1.0;
	(det->lprng).to_r = -1.0;
	(det->lprng).to_s = -1.0;
      } break;
      default: {
      } break;
    }
  } 

#line 1251 "dk3print.ctr"
}



dk3_printer_t *
dk3print_get_printer(dk3_print_conf_t *pc, dkChar const *pn)
{
  dk3_printer_t		*back = NULL;
  dk3_printer_alias_t	*al = NULL;	/* Alias for printer. */

  if((pc) && (pn)) {
    back = (dk3_printer_t *)dk3sto_it_find_like(pc->iPrinters, (void *)pn, 1);
    if(!(back)) {
      al = (dk3_printer_alias_t *)dk3sto_it_find_like(
        pc->iPrintAliases, (void *)pn, 1
      );
      if(al) {
        back = al->printer;
      }
    }
  }
  return back;
}


dk3_print_host_t *
dk3print_get_host(dk3_print_conf_t *pc, dkChar const *hn)
{
  dk3_print_host_t		*back = NULL;
  dk3_print_host_alias_t	*al = NULL;	/* Alias for host. */

  if((pc) && (hn)) {
    back = (dk3_print_host_t *)dk3sto_it_find_like(
      pc->iPrintHosts, (void *)hn, 1
    );
    if(!(back)) {
      al = (dk3_print_host_alias_t *)dk3sto_it_find_like(
        pc->iHostAliases, (void *)hn, 1
      );
      if(al) {
        back = al->host;
      }
    }
  }
  return back;
}

