/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3pixre.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3PIXRE_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3PIXRE_H_INCLUDED 1


#line 10 "dk3pixre.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Set up resampling structure.
	This function must be called before you start
	any conversion using dk3pixre_convert().
	@param	pp	Resampling structure.
	@param	inw	Input number of bits per component.
	@param	outw	Output number of bits per component.
	@return	1 on success, 0 on error.
*/
int
dk3pixre_set(dk3_pixel_resample_t *pp, size_t inw, size_t outw);

/**	Check whether a pixel value can be converted without quality loss.
	@param	pp	Pixel resampling structure.
	@param	inval	Value to convert.
	@return	1 on success, 0 on error.
*/
int
dk3pixre_can_convert(dk3_pixel_resample_t const *pp, dk3_bif_pixel_t inval);

/**	Resample pixel. The dk3_pixel_resample_t structure must
	already be set up using dk3pixre_set().
	@param	pp	Resampling structure.
	@param	inval	Value to resample.
	@return	Pixel component resampled.
*/
dk3_bif_pixel_t
dk3pixre_convert(dk3_pixel_resample_t const *pp, dk3_bif_pixel_t inval);

/**	Get mask for maximum output value.
	@param	pp	Resampling structure.
	@return	Maximum value for given number of output bits.
*/
dk3_bif_pixel_t
dk3pixre_get_max_value(dk3_pixel_resample_t const *pp);

/**	Get one pixel component value from packed bytes.
	@param	row	Pixel data.
	@param	vi	Value index.
	@param	bpc	Number of bits per component.
	@return	Pixel component value.
*/
dk3_bif_pixel_t
dk3pixre_get_value_from_packed_bytes(
  unsigned char const	*row,
  dk3_bif_coord_t	 vi,
  size_t		 bpc
);

/**	Get maximum pixel value for a given bit width.
	@param	w	Bit width.
	@return	Maximum value on success, 0 on error.
*/
dk3_bif_pixel_t
dk3pixre_maximum_for_width(size_t w);

#ifdef __cplusplus
}
#endif


#endif
