/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3pdf.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3PDF_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3PDF_H_INCLUDED 1


#line 10 "dk3pdf.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Create PDF writer structure.
	@param	app	Application structure, required here.
	@return	Pointer to new structure on success, NULL on error.
*/
dk3_pdf_t *
dk3pdf_open_app(dk3_app_t *app);

/**	Write PDF to output file.
	@param	pdf	PDF writer structure.
	@param	ofile	Output file.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_write_file(dk3_pdf_t *pdf, FILE *ofile);

/**	Write PDF to output file.
	@param	pdf	PDF writer structure.
	@param	ofile	Output file.
	@param	pcomm	Communicator object.
	@param	minpb	Minimum progress bar value.
	@param	maxpb	Maximum progress bar value.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_write_file_progress(
  dk3_pdf_t	*pdf,
  FILE		*ofile,
  void		*pcomm,
  int		 minpb,
  int		 maxpb
);

/**	Destroy PDF writer structure, release memory.
	@param	pdf	Structure to destroy.
*/
void
dk3pdf_close(dk3_pdf_t *pdf);

/**	Prepare media box for next page to open.
	@param	pdf	PDF writer structure.
	@param	x0	Left x.
	@param	x1	Right x.
	@param	y0	Bottom y.
	@param	y1	Top y.
*/
void
dk3pdf_set_next_mediabox(
  dk3_pdf_t	*pdf,
  long		 x0,
  long		 x1,
  long		 y0,
  long		 y1
);

/**	Open a new page.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_open_page(dk3_pdf_t *pdf);

/**	Open a new page, set clip path to media box.
	@param	pdf	PDF writer structure.
	@param	wc	Flag: With clip path setting.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_open_page_with_clip(dk3_pdf_t *pdf, int wc);

/**	Close the current page.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_close_page(dk3_pdf_t *pdf);

/**	Write save graphics state instruction to current page.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_gsave(dk3_pdf_t *pdf);

/**	Write restore graphics state instruction to current page.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_grestore(dk3_pdf_t *pdf);

/**	Translate coordinates, use long values.
	@param	pdf	PDF writer structure.
	@param	x	X translation.
	@param	y	Y translation.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_translate_long(dk3_pdf_t *pdf, long x, long y);

/**	Translate coordinates, use double values.
	@param	pdf	PDF writer structure.
	@param	x	X translation.
	@param	y	Y translation.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_translate_double(dk3_pdf_t *pdf, double x, double y);

/**	Rotate coordinates, use integer value.
	@param	pdf	PDF writer structure.
	@param	angle	Rotation angle in degree.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_rotate_int(dk3_pdf_t *pdf, int angle);

/**	Rotate coordinates, use double value.
	@param	pdf	PDF writer structure.
	@param	angle	Rotation angle in degree.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_rotate_double(dk3_pdf_t *pdf, double angle);

/**	Scale coordinates, use long values.
	@param	pdf	PDF writer structure.
	@param	x	X scale factor.
	@param	y	Y scale factor.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_scale_long(dk3_pdf_t *pdf, long x, long y);

/**	Scale coordinates, use double values.
	@param	pdf	PDF writer structure.
	@param	x	X scale factor.
	@param	y	Y scale factor.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_scale_double(dk3_pdf_t *pdf, double x, double y);

/**	Add XObject to current page.
	@param	pdf	PDF writer structure.
	@param	xo	XObject to add.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_add_xobject_to_page(dk3_pdf_t *pdf, dk3_pdf_xobject_t *xo);

/**	Add image.
	@param	pdf		PDF writer structure.
	@param	bif		Image, the current frame will be added.
	@param	opt		Conversion options.
	@param	pc		Communicator object.
	@param	min		Minimum progress bar value (0-1000).
	@param	max		Maximum progress bar value (0-1000).
	@return	Pointer to object on success, NULL on error.
*/
dk3_pdf_xobject_t *
dk3pdf_add_image_progress(
  dk3_pdf_t		*pdf,
  dk3_bif_t		*bif,
  dk3_bm_eps_options_t	*opt,
  void			*pc,
  int			 min,
  int			 max
);

/**	Add image.
	@param	pdf		PDF writer structure.
	@param	bif		Image, the current frame will be added.
	@param	opt		Conversion options.
	@return	Pointer to object on success, NULL on error.
*/
dk3_pdf_xobject_t *
dk3pdf_add_image(
  dk3_pdf_t		*pdf,
  dk3_bif_t		*bif,
  dk3_bm_eps_options_t	*opt
);

/**	PDF newpath and lineto. Start new path and move to specified position.
	@param	pdf	PDF writer structure.
	@param	x	New x position.
	@param	y	New y position.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_newpath_moveto(dk3_pdf_t *pdf, double x, double y);

/**	PDF lineto.
	@param	pdf	PDF writer structure.
	@param	x	New x
	@param	y	New y.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_lineto(dk3_pdf_t *pdf, double x, double y);

/**	PDF curveto.
	@param	pdf	PDF writer structure.
	@param	xcs	Control point X near start.
	@param	ycs	Control point Y near start.
	@param	xce	Control point X near end.
	@param	yce	Control point Y near end.
	@param	xe	End point X.
	@param	ye	End point Y.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_curveto(
  dk3_pdf_t *pdf,
  double xcs, double ycs,
  double xce, double yce,
  double xe,  double ye
);

/**	Set nonstroking gray.
	@param	pdf	PDF writer structure.
	@param	g	New gray value.
	@return 1 on success, 0 on error.
*/
int
dk3pdf_set_nonstroking_gray(dk3_pdf_t *pdf, double g);

/**	Set stroking gray.
	@param	pdf	PDF writer structure.
	@param	g	New gray value.
	@return 1 on success, 0 on error.
*/
int
dk3pdf_set_stroking_gray(dk3_pdf_t *pdf, double g);

/**	Close path, fill (non-zero winding rule), and stroke path.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_closepath_fill_stroke_nz(dk3_pdf_t *pdf);

/**	Close path, fill (even/odd rule), and stroke path.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_closepath_fill_stroke_eo(dk3_pdf_t *pdf);

/**	Close path.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_closepath(dk3_pdf_t *pdf);

/**	Fill current path (non-zero winding rule).
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_fill_nz(dk3_pdf_t *pdf);

/**	Fill current path (even/odd rule).
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_fill_eo(dk3_pdf_t *pdf);

/**	Clip to current path (even/odd rule).
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_clip_eo(dk3_pdf_t *pdf);

/**	Clip to current path (non-zero rule).
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_clip_nz(dk3_pdf_t *pdf);

/**	Set RGB color for nonstroking operations.
	@param	pdf	PDF writer structure.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_nonstroking_rgb(dk3_pdf_t *pdf, double r, double g, double b);

/**	Set RGB color for stroking operations.
	@param	pdf	PDF writer structure.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_stroking_rgb(dk3_pdf_t *pdf, double r, double g, double b);

/**	Set line cap mode.
	@param	pdf	PDF writer structure.
	@param	lc	Line cap DK3_LINECAP_xxx, see @ref linecap.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_set_linecap(dk3_pdf_t *pdf, int lc);

/**	Set line join mode.
	@param	pdf	PDF writer structure.
	@param	lj	Line cap DK3_LINECAP_xxx, see @ref linecap.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_set_linejoin(dk3_pdf_t *pdf, int lj);

/**	Set line dash pattern.
	@param	pdf	PDF writer structure.
	@param	sv	Style values array.
	@param	nsv	Number of elements in sv.
	@param	ph	Phase (initial shift).
	@return	1 on success, 0 on error.
*/
int
dk3pdf_set_line_dash(dk3_pdf_t *pdf, double *sv, size_t nsv, double ph);

/**	Stroke current path.
	@param	pdf	PDF writer structure.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_stroke(dk3_pdf_t *pdf);

/**	Set line width for stroke operations.
	@param	pdf	PDF writer structure.
	@param	lw	New line width.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_set_linewidth(dk3_pdf_t *pdf, double lw);

/**	Create image XObject.
	@param	pdf	PDF writer structure.
	@param	bif	Image, the current frame will be added.
	@param	opt	Conversion options.
	@param	pc	Communication object.
	@param	min	Minimum progress bar value (0-1000).
	@param	max	Maximum progress bar value (0-1000).
	@return	Pointer to new object on success, NULL on error.
*/
dk3_pdf_xobject_t *
dk3pdf_create_ixobject_progress(
  dk3_pdf_t		*pdf,
  dk3_bif_t		*bif,
  dk3_bm_eps_options_t	*opt,
  void			*pc,
  int			 min,
  int			 max
);

/**	Write debug line to graphics contents stream.
	@param	pdf	PDF output structure.
	@param	txt	Text to write.
	@return	1 on success, 0 on error.
*/
int
dk3pdf_write_debug_line(dk3_pdf_t *pdf, char const *txt);

#ifdef __cplusplus
}
#endif




#endif
