/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3opt.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3OPT_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3OPT_H_INCLUDED 1


#line 10 "dk3opt.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Create new options set.
	@param	options		Array of option descriptions.
	@param	szoptions	Number of entries in options.
	@param	foc		Character introducing a further option.
	@param	focl		String introducing a further option.
	@param	argc		Number of command line arguments to process.
	@param	argv		Command line arguments array pointer.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to option set on success, NULL on error.
*/
dk3_option_set_t *
dk3opt_open_app(
  dk3_option_t const	*options,
  size_t		 szoptions,
  dkChar		 foc,
  dkChar const		*focl,
  int			 argc,
  dkChar const * const	*argv,
  dk3_app_t		*app
);

/**	Create new options set.
	@param	options		Array of option descriptions.
	@param	szoptions	Number of entries in options.
	@param	foc		Character to indicate a further option.
	@param	focl		Long option for further options.
	@param	app	Application structure.
	@return	Pointer to option set on success, NULL on error.
*/
dk3_option_set_t *
dk3opt_open_from_app(
  dk3_option_t const	*options,
  size_t		 szoptions,
  dkChar		 foc,
  dkChar const		*focl,
  dk3_app_t		*app
);

/**	Check whether or not an option is set.
	@param	optset		Options set.
	@param	shortopt	Option character.
	@return	1 for option was set, 0 for option was not set.
*/
int
dk3opt_is_set(
  dk3_option_set_t const	*optset,
  dkChar			 shortopt
);

/**	Check whether or not a long option is set.
	@param	optset		Options set.
	@param	longopt		Long option name string.
	@return 1 for option was set, 0 for option was not set.
*/
int
dk3opt_is_set_long(
  dk3_option_set_t const	*optset,
  dkChar const			*longopt
);

/**	Get option argument.
	@param	optset		Options set.
	@param	shortopt	Option character.
	@return	Option argument (if any) or NULL.
*/
dkChar const *
dk3opt_get_short_arg(
  dk3_option_set_t const	*optset,
  dkChar			 shortopt
);

/**	Get long option argument.
	@param	optset		Options set.
	@param	longopt		Option name.
	@return	Option argument (if any) or NULL.
*/
dkChar const *
dk3opt_get_long_arg(
  dk3_option_set_t const	*optset,
  dkChar const			*longopt
);

/**	Get number of command line arguments without options.
	@param	optset		Options set.
	@return	Number of command line arguments.
*/
int
dk3opt_get_num_args(
  dk3_option_set_t const	*optset
);

/**	Get one command line argument.
	@param	optset		Options set.
	@param	num		Index of argument.
	@return	The argument on success, NULL on error.
*/
dkChar const *
dk3opt_get_arg(
  dk3_option_set_t const	*optset,
  int				 num
);

/**	Get number of further options.
	@param	os		Options set.
	@return	Number of further options.
*/
int
dk3opt_get_num_fo(
  dk3_option_set_t const	*os
);

/**	Get one further option.
	@param	os		Options set.
	@param	num		Index of option.
	@return	The further option on success, NULL on error.
*/
dkChar const *
dk3opt_get_fo(
  dk3_option_set_t const	*os,
  int			 num
);

/**	Destroy option set.
	@param	os	Option set to destroy.
*/
void
dk3opt_close(
  dk3_option_set_t *os
);

/**	Get error code.
	@param	os	Option set to check for errors.
	@return	Error code value.
*/
int
dk3opt_get_error_code(dk3_option_set_t const *os);

/**	Reset error code.
	@param	os	Option set to clean up.
*/
void
dk3opt_reset_error_code(dk3_option_set_t *os);

#ifdef __cplusplus
}
#endif




#endif
