/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3opt.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3opt.c The dk3opt module.
*/


#line 168 "dk3opt.ctr"

#include "dk3all.h"





#line 174 "dk3opt.ctr"



/**	Find index of character in options set.
	@param	os	Options set.
	@param	c	Character to search for.
	@param	pind	Pointer to destination variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3opt_find_index_short(
  dk3_option_set_t const	*os,
  dkChar			 c,
  size_t			*pind
)
{
  int		back = 0;
  size_t	i;
  

#line 194 "dk3opt.ctr"
  if((os) && (pind)) {
    if((os->options) && (os->szoptions)) {
      for(i = 0; ((i < os->szoptions) && (back == 0)); i++) {
        if(((os->options)[i]).so == c) {
	  *pind = i; back = 1;	

#line 199 "dk3opt.ctr"
	}
      }
    }
  } 

#line 203 "dk3opt.ctr"
  return back;
}



/**	Find index of long option in options set.
	@param	os	Options set.
	@param	t	Long option name to search for.
	@param	pind	Pointer to destination variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3opt_find_index_long(
  dk3_option_set_t const	*os,
  dkChar const			*t,
  size_t			*pind
)
{
  int		back = 0;
  size_t	i;
  

#line 225 "dk3opt.ctr"
  if((os) && (t) && (pind)) {
    if((os->options) && (os->szoptions)) {
      for(i = 0; ((i < os->szoptions) && (back == 0)); i++) {
        if(((os->options)[i]).lo) {
	  if(dk3str_cmp(((os->options)[i]).lo, t) == 0) {
	    *pind = i; back = 1;	

#line 231 "dk3opt.ctr"
	  }
	}
      }
    }
  } 

#line 236 "dk3opt.ctr"
  return back;
}



/**	Apply the command line options to the options set.
	@param	os	Options set.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
*/
static
void
dk3opt_apply_options(
  dk3_option_set_t	*os,
  int			 argc,
  dkChar const * const	*argv
)
{
  dkChar const * const	*lfdptr;
  dkChar const		*ptr;
  dkChar const		*optr;
  dkChar const		*cptr;
  int			 i;
  size_t		 j;
  int			 done;
  dkChar		 bu[2 * DK3_MAX_PATH];
  dkChar		*p1;
  

#line 264 "dk3opt.ctr"
  lfdptr = argv; i = 0;
  while(i < argc) {
    optr = ptr = *lfdptr;
    if(*ptr == dkT('-')) {		

#line 268 "dk3opt.ctr"
      ptr++;
      if(*ptr == dkT('-')) {		

#line 270 "dk3opt.ctr"
        ptr++;
	if(dk3str_len(ptr) < DK3_SIZEOF(bu,dkChar)) {
	  dk3str_cpy_not_overlapped(bu, ptr);
	  p1 = dk3str_chr(bu, dkT('='));
	  if(p1) {
	    *p1 = dkT('\0');
	  }
	  done = 0;
	  if(os->focl) {
	    if(dk3str_cmp(os->focl, bu) == 0) {
	      done = 1;
	      cptr = dk3str_chr(ptr, dkT('='));
	      if(cptr) {
	        cptr++;
		if(!(*cptr)) {
		  cptr = NULL;
		}
	      }
	      if(!(cptr)) {
	        lfdptr++; i++; if(i < argc) { cptr = *lfdptr; }
	      }
	      if(cptr) {
	        (os->fo)[os->fou] = cptr;
		os->fou += 1;
	      } else {
	        /* ERROR: Option needs argument! */
		os->ec = 1;
		if(os->app) {
		  dk3app_log_i3(os->app, DK3_LL_ERROR, 133, 134, optr);
		}
	      }
	    }
	  }
	  if(!done) {
	    if(dk3opt_find_index_long(os, bu, &j)) {
	      (os->found)[j] += 1;
	      if((os->found)[j] == 0) { /* Overflow */
	        (os->found)[j] = 0x7FFF;
	      }
	      if(((os->options)[j]).na) {
	        cptr = dk3str_chr(ptr, dkT('='));
		if(cptr) { cptr++; if(!(*cptr)) { cptr = NULL; } }
		if(!(cptr)) {
		  lfdptr++; i++; if(i < argc) { cptr = *lfdptr; }
		}
		if(cptr) {
		  if((os->optargs)[j]) {
		    /* Warning: Redefinition */
		    /* os->ec = 1; */
		    if(os->app) {
		      dk3app_log_i5(
		        os->app, DK3_LL_WARNING, 206, 207, 208,
			(os->optargs)[j], cptr
		      );
		    }
		  }
		  (os->optargs)[j] = cptr;
		} else {
		  /* ERROR: Option needs argument! */
		  os->ec = 1;
		  if(os->app) {
		    dk3app_log_i3(os->app, DK3_LL_ERROR, 133, 134, optr);
		  }
		}
	      }
	    } else {
	      /* ERROR: Illegal option! */
	      os->ec = 1;
	      if(os->app) {
	        dk3app_log_i3(os->app, DK3_LL_ERROR, 139, 140, optr);
	      }
	    }
	  }
	} else {
	  /* ERROR: Option too long! */
	  os->ec = 1;
	  if(os->app) {
	    dk3app_log_i3(os->app, DK3_LL_ERROR, 135, 136, optr);
	  }
	}
      } else {				

#line 351 "dk3opt.ctr"
	if(*ptr == os->foc) {		

#line 352 "dk3opt.ctr"
	  ptr++;
	  if(!(*ptr)) {
	    ptr = NULL;
	    lfdptr++; i++;
	    if(i < argc) { ptr = *lfdptr; }
	  }
	  if(ptr) {
	    (os->fo)[os->fou] = ptr;
	    os->fou += 1;
	  } else {
	    /* ERROR: Option needs an argument! */
	    os->ec = 1;
	    if(os->app) {
	      dk3app_log_i3(os->app, DK3_LL_ERROR, 133, 134, optr);
	    }
	  }
	} else {			

#line 369 "dk3opt.ctr"
	  if(dk3opt_find_index_short(os, *ptr, &j)) {
	    (os->found)[j] += 1;
	    if((os->found)[j] == 0) { /* Overflow */
	      (os->found)[j] = 0x7FFF;
	    }
	    if(((os->options)[j]).na) {
	      ptr++;
	      if(!(*ptr)) {
	        ptr = NULL;
		lfdptr++; i++;
		if(i < argc) { ptr = *lfdptr; }
	      }
	      if(ptr) {
	        if((os->optargs)[j]) {
		  /* Warning: Redefinition of option. */
		  /* os->ec = 1; */
		  if(os->app) {
		    dk3app_log_i5(
		      os->app, DK3_LL_WARNING, 206, 207, 208,
		      (os->optargs)[j], ptr
		    );
		  }
		}
	        (os->optargs)[j] = ptr;
	      } else {
	        /* ERROR: Option needs an argument! */
		os->ec = 1;
		if(os->app) {
		  dk3app_log_i3(os->app, DK3_LL_ERROR, 133, 134, optr);
		}
	      }
	    } else {
	      ptr++;
	      if(*ptr) {
	        if((os->optargs)[j]) {
		  if(os->app) {
		    dk3app_log_i5(
		      os->app, DK3_LL_WARNING, 206, 207, 208,
		      (os->optargs)[j], ptr
		    );
		  }
		}
		(os->optargs)[j] = ptr;
	      }
	    }
	  } else {
	    /* ERROR: Illegal option! */
	    os->ec = 1;
	    if(os->app) {
	      dk3app_log_i3(os->app, DK3_LL_ERROR, 139, 140, optr);
	    }
	  }
	}
      }
    } else {				

#line 424 "dk3opt.ctr"
      (os->args)[os->argsused] = ptr;
      os->argsused += 1;
    }
    lfdptr++; i++;
  } 

#line 429 "dk3opt.ctr"
}



dk3_option_set_t *
dk3opt_open_app(
  dk3_option_t const	*options,
  size_t		 szoptions,
  dkChar		 foc,
  dkChar const		*focl,
  int			 argc,
  dkChar const * const	*argv,
  dk3_app_t		*app
)
{
  dk3_option_set_t	*back = NULL;
  int			 ok   = 0;
  int			 i    = 0;
  size_t		 j    = 0;
  

#line 449 "dk3opt.ctr"
  if((options) && (szoptions)) {		

#line 450 "dk3opt.ctr"
    back = dk3_new_app(dk3_option_set_t,1,app);
    if(back) {					

#line 452 "dk3opt.ctr"
      back->app = app;
      back->options = options;
      back->szoptions = szoptions;
      back->found = NULL;
      back->optargs = NULL;
      back->args = NULL;
      back->fo = NULL;
      back->foc = foc;
      back->focl = focl;
      back->argsav = 0;
      back->argsused = 0;
      back->foav = 0;
      back->fou = 0;
      back->ec = 0;
      back->found = dk3_new_app(int,szoptions,app);
      if(back->found) {	

#line 468 "dk3opt.ctr"
        for(j = 0; j < szoptions; j++) {
	  (back->found)[j] = 0;
	} 

#line 471 "dk3opt.ctr"
	back->optargs = dk3_new_app(DK3_PCDKCHAR,szoptions,app);
	if(back->optargs) {	

#line 473 "dk3opt.ctr"
	  for(j = 0; j < szoptions; j++) {
	    (back->optargs)[j] = NULL;
	  }
	  if(argc) {
	    back->args = dk3_new_app(DK3_PCDKCHAR,argc,app);
	    if(back->args) {
	      back->argsav = argc;
	      for(i = 0; i < argc; i++) { (back->args)[i] = NULL; }
	      back->fo = dk3_new_app(DK3_PCDKCHAR,argc,app);
	      if(back->fo) {
	        back->foav = argc;
	        for(i = 0; i < argc; i++) { (back->fo)[i] = NULL; }
	        ok = 1;				

#line 486 "dk3opt.ctr"
	        dk3opt_apply_options(back, argc, argv);
	      }
	    }
	  } else {
	    ok = 1;
	  }
	} else {		

#line 493 "dk3opt.ctr"
	}
      } else {			

#line 495 "dk3opt.ctr"
      }
      if(!ok) {
        dk3opt_close(back); back = NULL;
      }
      if(back) {
        if(back->ec) {
          if(app) {
	    dk3app_log_i1(app, DK3_LL_ERROR, 252);
	  }
	}
      }
    }
  } 

#line 508 "dk3opt.ctr"
  return back;
}



dk3_option_set_t *
dk3opt_open_from_app(
  dk3_option_t const	*options,
  size_t		 szoptions,
  dkChar		 foc,
  dkChar const		*focl,
  dk3_app_t		*app
)
{
  dk3_option_set_t	*back = NULL;
  dkChar const * const	*argv;
  int			 argc;
  

#line 526 "dk3opt.ctr"
  if((options) && (szoptions) && (app)) {
    argc = dk3app_get_argc(app);
    argv = dk3app_get_argv(app);
    argv++; argc--;
    back = dk3opt_open_app(options, szoptions, foc, focl, argc, argv, app);
  } 

#line 532 "dk3opt.ctr"
  return back;
}



int
dk3opt_is_set(
  dk3_option_set_t const	*optset,
  dkChar			 shortopt
)
{
  int		back = 0;
  size_t	i;
  

#line 546 "dk3opt.ctr"
  if(optset) {
    if(dk3opt_find_index_short(optset, shortopt, &i)) {
      if(optset->found) {
        back = (optset->found)[i];
      }
    }
  } 

#line 553 "dk3opt.ctr"
  return back;
}



int
dk3opt_is_set_long(
  dk3_option_set_t const	*optset,
  dkChar const			*longopt
)
{
  int		back = 0;
  size_t	i;
  

#line 567 "dk3opt.ctr"
  if((optset) && (longopt)) {
    if(dk3opt_find_index_long(optset, longopt, &i)) {
      if(optset->found) {
        back = (optset->found)[i]; 

#line 571 "dk3opt.ctr"
      }
    }
  } 

#line 574 "dk3opt.ctr"
  return back;
}



dkChar const *
dk3opt_get_short_arg(
  dk3_option_set_t const	*optset,
  dkChar			 shortopt
)
{
  dkChar const	*back = NULL;
  size_t	 i;
  

#line 588 "dk3opt.ctr"
  if(optset) {
    if(dk3opt_find_index_short(optset, shortopt, &i)) {
      if(optset->options) {
        if(((optset->options)[i]).na) {
	  if(optset->optargs) {
	    back = (optset->optargs)[i];
	  }
	}
      }
    }
  } 

#line 599 "dk3opt.ctr"
  return back;
}



dkChar const *
dk3opt_get_long_arg(
  dk3_option_set_t const	*optset,
  dkChar const			*longopt
)
{
  dkChar const	*back = NULL;
  size_t	 i;
  

#line 613 "dk3opt.ctr"
  if((optset) && (longopt)) {
    if(dk3opt_find_index_long(optset, longopt, &i)) {
      if(optset->options) {
        if(((optset->options)[i]).na) {
	  if(optset->optargs) {
	    back = (optset->optargs)[i];
	  }
	}
      }
    }
  } 

#line 624 "dk3opt.ctr"
  return back;
}



int
dk3opt_get_num_args(
  dk3_option_set_t const	*optset
)
{
  int back = 0;
  

#line 636 "dk3opt.ctr"
  if(optset) {
    back = optset->argsused;
  } 

#line 639 "dk3opt.ctr"
  return back;
}



dkChar const *
dk3opt_get_arg(
  dk3_option_set_t const	*optset,
  int				 num
)
{
  dkChar const *back	= NULL;
  

#line 652 "dk3opt.ctr"
  if((optset) && (num >= 0)) {
    if(num < optset->argsused) {
      if(optset->args) {
        back = (optset->args)[num];
      }
    }
  } 

#line 659 "dk3opt.ctr"
  return back;
}



int
dk3opt_get_num_fo(
  dk3_option_set_t const	*os
)
{
  int back = 0;
  

#line 671 "dk3opt.ctr"
  if(os) {
    back = os->fou;
  } 

#line 674 "dk3opt.ctr"
  return  back;
}



dkChar const *
dk3opt_get_fo(
  dk3_option_set_t const *os,
  int			  num
)
{
  dkChar const *back = NULL;
  

#line 687 "dk3opt.ctr"
  if((os) && (num >= 0)) {
    if(num < os->fou) {
      if(os->fo) {
        back = (os->fo)[num];
      }
    }
  } 

#line 694 "dk3opt.ctr"
  return back;
}



void
dk3opt_close(
  dk3_option_set_t *os
)
{
  int		i;
  size_t	j;
  

#line 707 "dk3opt.ctr"
  if(os) {
    if(os->optargs) {
      for(j = 0; j < os->szoptions; j++) { (os->optargs)[j] = NULL; }
      

#line 711 "dk3opt.ctr"
      dk3_delete(os->optargs);
      

#line 713 "dk3opt.ctr"
    } os->optargs = NULL;
    if(os->found) {
      for(j = 0; j < os->szoptions; j++) { (os->found)[j] = 0;}
      

#line 717 "dk3opt.ctr"
      dk3_delete(os->found);
      

#line 719 "dk3opt.ctr"
    } os->found = NULL;
    if(os->args) {
      for(i = 0; i < os->argsav; i++) { (os->args)[i] = NULL; }
      

#line 723 "dk3opt.ctr"
      dk3_delete(os->args);
      

#line 725 "dk3opt.ctr"
    } os->args = NULL;
    if(os->fo) {
      for(i = 0; i < os->foav; i++) { (os->fo)[i] = NULL; }
      

#line 729 "dk3opt.ctr"
      dk3_delete(os->fo);
      

#line 731 "dk3opt.ctr"
    } os->fo = NULL;
    os->options = NULL;
    os->szoptions = 0;
    os->argsav = os->argsused = 0;
    os->foav = os->fou = 0;
    os->ec = 0;
    os->focl = NULL;
    os->foc = dkT('\0');
    

#line 740 "dk3opt.ctr"
    dk3_delete(os);
    

#line 742 "dk3opt.ctr"
  } 

#line 743 "dk3opt.ctr"
}



int
dk3opt_get_error_code(dk3_option_set_t const *os)
{
  int back = 0;
  if(os) {
    back = os->ec;
  }
  return back;
}


void
dk3opt_reset_error_code(dk3_option_set_t *os)
{
  if(os) {
    os->ec = 0;
  }
}



/* vim: set ai sw=2 : */

