/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3of.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3of.h Header file for the dk3of module.
*/

#ifndef DK3OF_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3OF_H_INCLUDED 1


#line 10 "dk3of.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Create output filter for a stream.
	@param	os	Output stream.
	@param	app	Application structure for diagnostics.
	@return	Pointer to new filter on success, NULL on error.
*/
dk3_of_t *
dk3of_open_app(dk3_stream_t *os, dk3_app_t *app);

/**	Create output filter for a stream.
	@param	os	Output stream.
	@return	Pointer to new filter on success, NULL on error.
*/
dk3_of_t *
dk3of_open(dk3_stream_t *os);

/**	Close output filter, release memory.
	@param	of	Filter to delete.
*/
void
dk3of_close(dk3_of_t *of);

/**	Add filter cell.
	@param	of	Output filter.
	@param	ct	Cell type (DK3_OF_CELL_TYPE_xxx).
	@return	1 on success, 0 on error.
*/
int
dk3of_add_cell(dk3_of_t *of, int ct);

/**	Start data chunk.
	@param	of	Output filter.
	@return	1 on success, 0 on error.
*/
int
dk3of_start_chunk(dk3_of_t *of);

/**	End data chunk, flush buffers.
	@param	of	Output filter.
	@return	1 on success, 0 on error.
*/
int
dk3of_end_chunk(dk3_of_t *of);

/**	Write bytes to filter cell.
	@param	cp	Filter cell.
	@param	bu	Buffer containing the bytes.
	@param	sz	Number of bytes.
	@return	1 on success, 0 on error.
*/
int
dk3of_bytes_to_cell(dk3_of_cell_t *cp, unsigned char const *bu, size_t sz);

/**	Write bytes from filter cell, either to the next filter cell
	downwards or to the destination stream.
	@param	cp	Filter cell.
	@param	bu	Buffer containing the bytes.
	@param	sz	Number of bytes.
	@return	1 on success, 0 on error.
*/
int
dk3of_bytes_from_cell(dk3_of_cell_t *cp, unsigned char const *bu, size_t sz);

/**	Write bytes to output filter.
	@param	of	Output filter.
	@param	bu	Buffer containing the bytes.
	@param	sz	Number of bytes.
	@return	1 on success, 0 on error.
*/
int
dk3of_write_bytes(dk3_of_t *of, unsigned char const *bu, size_t sz);

/**	Write string to output filter.
	@param	of	Output filter.
	@param	st	String to write.
	@return	1 on success, 0 on error.
*/
int
dk3of_write_c8_string(dk3_of_t *of, char const *st);

/**	Write bits to output filter.
	@param	of	Output filter.
	@param	bv	Bit values.
	@param	sz	Number of bits.
	@return	1 on success, 0 on error.
*/
int
dk3of_write_bits(dk3_of_t *of, unsigned short bv, size_t sz);

/**	Flush bit buffer.
	@param	of	Output filter.
	@return	1 on success, 0 on error.
*/
int
dk3of_flush_bits(dk3_of_t *of);

/**	Configure use of cr/nl sequences.
	@param	of	Output filter.
	@param	fl	0 for disable, any other value to enable.
*/
void
dk3of_set_crnl(dk3_of_t *of, int fl);

/**	Configure use of finalizers.
	@param	of	Output filter.
	@param	fl	0 for disable, any other value to enable.
*/
void
dk3of_set_finalize(dk3_of_t *of, int fl);

/**	Write double number to output, avoid exponential notation.
	@param	of	Output filter.
	@param	x	Value to write.
	@return	1 on success, 0 on error.
*/
int
dk3of_double_to_c8_no_sci(dk3_of_t *of, double x);

/**	Write double number to output.
	@param	of	Output filter to write to.
	@param	buffer	String buffer containing number as string.
	@return	1 on success, 0 on error.
*/
int
dk3of_double_str_no_sci(dk3_of_t *of, char *buffer);

#ifdef __cplusplus
}
#endif




#endif
