
#ifndef DK3NUMCO_H_INCLUDED
#define	DK3NUMCO_H_INCLUDED	1

/**	@file	dk3numco.h	Numeric constants.
Use system-defined mininum and maximum values if available.
Define own contants using two s complement if no system definitions available.
*/

#include <dk3conf.h>
#include <dk3types.h>

#if DK3_HAVE_STDINT_H
#include <stdint.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif



#if (!(DK3_HAVE_TWOS_COMPLEMENT))

/*	The definitions in this header file are only valid if the
	twos complement representation is used for negative integer
	values.
	If the compiler aborts compilation showing the error below,
	the configure script failed to verify the use of twos complement
	for signed integers.
	There are two possible reasons:
	1. Your C compiler and the libraries use another integer
	   representation. So you can not use this header file or
	   the dk3maxxx modules.
	2. Failure in the verification process. If you are sure your
	   compiler and libraries use twos complement, set
	     #define DK3_HAVE_TWOS_COMPLEMENT 1
	   in dk3conf.h and run
	     make clean
	   before attempting to build.
*/
#error	"Module only available if twos complement is used for signed integers!"

#endif



/*	short
	-----
*/

#if defined(SHRT_MIN) && defined(SHRT_MAX)

/**	Maximum short value.
*/
#define	DK3_S_MAX	(SHRT_MAX)

/**	Minimum short value.
*/
#define	DK3_S_MIN	(SHRT_MIN)

#else

#if DK3_SIZEOF_SHORT	> 2
#if DK3_SIZEOF_SHORT	> 4
#if DK3_SIZEOF_SHORT	> 8
#error	"No definitions for shorts larger than 8 bytes yet!"
#else
/**	Maximum short value.
*/
#define	DK3_S_MAX	(9223372036854775807)
/**	Minimum short value.
*/
#define	DK3_S_MIN	(-DK3_S_MAX - 1)
#endif
#else
/**	Maximum short value.
*/
#define	DK3_S_MAX	(2147483647)
/**	Minimum short value.
*/
#define	DK3_S_MIN	(-DK3_S_MAX - 1)
#endif
#else
/**	Maximum short value.
*/
#define	DK3_S_MAX	(32767)
/**	Minimum short value.
*/
#define	DK3_S_MIN	(-DK3_S_MAX - 1)
#endif
#endif

/*	unsigned short
	--------------
*/
#if defined(USHRT_MAX)

/**	Maximum unsigned short value.
*/
#define	DK3_US_MAX	(USHRT_MAX)

#else
#if DK3_SIZEOF_SHORT > 2
#if DK3_SIZEOF_SHORT > 4
#if DK3_SIZEOF_SHORT > 8
#error	"No definition for short values larger than 8 bytes yet!"
#else
/**	Maximum unsigned short value.
*/
#define	DK3_US_MAX	(18446744073709551615U)
#endif
#else
/**	Maximum unsigned short value.
*/
#define	DK3_US_MAX	(4294967295U)
#endif
#else
/**	Maximum unsigned short value.
*/
#define	DK3_US_MAX	(65535U)
#endif
#endif

/*	int
	---
*/
#if defined(INT_MIN) && defined(INT_MAX)

/**	Maximum integer.
*/
#define	DK3_I_MAX	(INT_MAX)

/**	Minimum integer.
*/
#define	DK3_I_MIN	(INT_MIN)

#else

#if DK3_SIZEOF_INT > 2
#if DK3_SIZEOF_INT > 4
#if DK3_SIZEOF_INT > 8
#error	"No definition for int larger than 8 bytes yet!"
#else
/**	Maximum integer.
*/
#define	DK3_I_MAX	(9223372036854775807)
/**	Minimum integer.
*/
#define	DK3_I_MIN	(-DK3_I_MAX - 1)
#endif
#else
/**	Maximum integer.
*/
#define	DK3_I_MAX	(2147483647)
/**	Minimum integer.
*/
#define	DK3_I_MIN	(-DK3_I_MAX - 1)
#endif
#else
/**	Maximum integer.
*/
#define	DK3_I_MAX	(32767)
/**	Minimum integer.
*/
#define	DK3_I_MIN	(-DK3_I_MAX - 1)
#endif
#endif



/*	unsigned int
	------------
*/
#if defined UINT_MAX

/**	Maximum unsigned integer.
*/
#define	DK3_U_MAX	(UINT_MAX)

#else

#if DK3_SIZEOF_INT	> 2
#if DK3_SIZEOF_INT	> 4
#if DK3_SIZEOF_INT	> 8
#error "No definitions for unsigned int larger than 8 bytes yet!"
#else
/**	Maximum unsigned integer.
*/
#define	DK3_U_MAX	(18446744073709551615)
#endif
#else
/**	Maximum unsigned integer.
*/
#define	DK3_U_MAX	(4294967295)
#endif
#else
/**	Maximum unsigned integer.
*/
#define	DK3_U_MAX	(65535)
#endif

#endif




/*	long
	----
*/
#if defined(LONG_MIN) && defined(LONG_MAX)

/**	Maximum long integer.
*/
#define	DK3_L_MAX	(LONG_MAX)

/**	Minimum long integer.
*/
#define	DK3_L_MIN	(LONG_MIN)

#else

#if DK3_SIZEOF_LONG	> 2
#if DK3_SIZEOF_LONG	> 4
#if DK3_SIZEOF_LONG	> 8
#error	"No definitions for long larger than 8 bytes yet!"
#else
/**	Maximum long integer.
*/
#define	DK3_L_MAX	(9223372036854775807)

/**	Minimum long integer.
*/
#define	DK3_L_MIN	(-DK3_L_MAX - 1L)
#endif
#else
/**	Maximum long integer.
*/
#define	DK3_L_MAX	(2147483647)

/**	Minimum long integer.
*/
#define	DK3_L_MIN	(-DK3_L_MAX - 1L)
#endif
#else
/**	Maximum long integer.
*/
#define	DK3_L_MAX	(32767)
/**	Minimum long integer.
*/
#define	DK3_L_MIN	(-DK3_L_MAX - 1L)
#endif
#endif



/*	unsigned long
	-------------
*/
#if defined(ULONG_MAX)

/**	Maximum unsigned long.
*/
#define	DK3_UL_MAX	(ULONG_MAX)

#else
#if DK3_SIZEOF_LONG	> 2
#if DK3_SIZEOF_LONG	> 4
#if DK3_SIZEOF_LONG	> 8
#error	"No definitions for unsigned long larger than 8 bytes yet!"
#else
/**	Maximum unsigned long.
*/
#define	DK3_UL_MAX	(18446744073709551615UL)
#endif
#else
/**	Maximum unsigned long.
*/
#define	DK3_UL_MAX	(4294967295UL)
#endif
#else
/**	Maximum unsigned long.
*/
#define	DK3_UL_MAX	(65535UL)
#endif
#endif

#if DK3_HAVE_LONG_LONG
/*	long long
	---------
*/
#if defined(LLONG_MAX) && defined(LLONG_MIN)

/**	Maximum long long.
*/
#define	DK3_LL_MAX	(LLONG_MAX)

/**	Minimum long long.
*/
#define	DK3_LL_MIN	(LLONG_MIN)

#else
#if DK3_SIZEOF_LONG_LONG	> 2
#if DK3_SIZEOF_LONG_LONG	> 4
#if DK3_SIZEOF_LONG_LONG	> 8
#error	"No definitions for long long larger than 8 bytes yet!"
#else
/**	Maximum long long.
*/
#define	DK3_LL_MAX	(9223372036854775807LL)
/**	Minimum long long.
*/
#define	DK3_LL_MIN	(-DK3_LL_MAX - 1LL)
#endif
#else
/**	Maximum long long.
*/
#define	DK3_LL_MAX	(2147483647LL)
/**	Minimum long long.
*/
#define	DK3_LL_MIN	(-DK3_LL_MAX - 1LL)
#endif
#else
/**	Maximum long long.
*/
#define	DK3_LL_MAX	(32767LL)
/**	Minimum long long.
*/
#define	DK3_LL_MIN	(-DK3_LL_MAX - 1LL)
#endif
#endif

/*	unsigned long long
	------------------
*/
#if defined(ULLONG_MAX)

/**	Maximum unsigned long long.
*/
#define	DK3_ULL_MAX	(ULLONG_MAX)

#else
#if DK3_SIZEOF_LONG_LONG	> 2
#if DK3_SIZEOF_LONG_LONG	> 4
#if DK3_SIZEOF_LONG_LONG	> 8
#error	"No definitions for unsigned long long larger than 8 bytes yet!"
#else
/**	Maximum unsigned long long.
*/
#define	DK3_ULL_MAX	(18446744073709551615ULL)
#endif
#else
/**	Maximum unsigned long long.
*/
#define	DK3_ULL_MAX	(4294967295ULL)
#endif
#else
/**	Maximum unsigned long long.
*/
#define	DK3_ULL_MAX	(65535ULL)
#endif
#endif

#endif
/* if DK3_HAVE_LONG_LONG */



#if DK3_HAVE_INTMAX_T
/*	intmax_t
	--------
*/
#if defined(INTMAX_MIN) && defined(INTMAX_MAX)

/**	Maximum intmax_t value.
*/
#define	DK3_INTMAX_T_MAX	(INTMAX_MAX)

/**	Minimum intmax_t value.
*/
#define	DK3_INTMAX_T_MIN	(INTMAX_MIN)

#else
#if DK3_SIZEOF_INTMAX_T	> 2
#if DK3_SIZEOF_INTMAX_T	> 4
#if DK3_SIZEOF_INTMAX_T	> 8
#error	"No definitions for intmax_t larger than 8 bytes yet!"
#else
#if DK3_SIZEOF_INTMAX_T == DK3_SIZEOF_LONG
/**	Maximum intmax_t value.
*/
#define	DK3_INTMAX_T_MAX	(9223372036854775807L)
/**	Minimum intmax_t value.
*/
#define	DK3_INTMAX_T_MIN	(-DK3_INTMAX_T_MAX - 1L)
#else
/**	Maximum intmax_t value.
*/
#define	DK3_INTMAX_T_MAX	(9223372036854775807LL)
/**	Minimum intmax_t value.
*/
#define	DK3_INTMAX_T_MIN	(-DK3_INTMAX_T_MAX - 1LL)
#endif
#endif
#else
/**	Maximum intmax_t value.
*/
#define	DK3_INTMAX_T_MAX	(2147483647L)
/**	Minimum intmax_t value.
*/
#define	DK3_INTMAX_T_MIN	(-DK3_INTMAX_T_MAX - 1L)
#endif
#else
/**	Maximum intmax_t value.
*/
#define	DK3_INTMAX_T_MAX	(32767L)
/**	Minimum intmax_t value.
*/
#define	DK3_INTMAX_T_MIN	(-DK3_INTMAX_T_MAX - 1)
#endif
#endif


/*	uintmax_t
	---------
*/
#if defined(UINTMAX_MAX)

/**	Maximum uintmax_t value.
*/
#define	DK3_UINTMAX_T_MAX	(UINTMAX_MAX)

#else
#if DK3_SIZEOF_INTMAX_T	> 2
#if DK3_SIZEOF_INTMAX_T	> 4
#if DK3_SIZEOF_INTMAX_T	> 8
#error	"No definitions for uintmax_t larger than 8 bytes yet!"
#else
#if DK3_SIZEOF_INTMAX_T == DK3_SIZEOF_LONG
/**	Maximum uintmax_t value.
*/
#define	DK3_UINTMAX_T_MAX	(18446744073709551615UL)
#else
/**	Maximum uintmax_t value.
*/
#define	DK3_UINTMAX_T_MAX	(18446744073709551615ULL)
#endif
#endif
#else
/**	Maximum uintmax_t value.
*/
#define	DK3_UINTMAX_T_MAX	(4294967295UL)
#endif
#else
/**	Maximum uintmax_t value.
*/
#define	DK3_UINTMAX_T_MAX	(65535U)
#endif
#endif

#if DK3_HAVE_LONG_LONG
/**	intmax_t 0.
*/
#define	DK3_INTMAX_T_0		((intmax_t)0LL)
/**	intmax_t 1.
*/
#define	DK3_INTMAX_T_1		((intmax_t)1LL)
#else
/**	intmax_t 0.
*/
#define	DK3_INTMAX_T_0		((intmax_t)0L)
/**	intmax_t 1.
*/
#define	DK3_INTMAX_T_1		((intmax_t)1L)
#endif

#if DK3_HAVE_LONG_LONG
/**	uintmax_t 0.
*/
#define	DK3_UINTMAX_T_0		((uintmax_t)0ULL)
/**	uintmax_t 1.
*/
#define	DK3_UINTMAX_T_1		((uintmax_t)1ULL)
#else
/**	uintmax_t 0.
*/
#define	DK3_UINTMAX_T_0		((uintmax_t)0UL)
/**	uintmax_t 1.
*/
#define	DK3_UINTMAX_T_1		((uintmax_t)1UL)
#endif

#endif
/* if DK3_HAVE_INTMAX_T */


/*	dk3_im_t
	--------
*/
#if DK3_HAVE_INTMAX_T
/**	Minimum dk3_im_t value.
*/
#define	DK3_IM_MIN	(DK3_INTMAX_T_MIN)

/**	Maximum dk3_im_t value.
*/
#define	DK3_IM_MAX	(DK3_INTMAX_T_MAX)

#else
#if DK3_HAVE_LONG_LONG
/**	Minimum dk3_im_t value.
*/
#define	DK3_IM_MIN	(DK3_LL_MIN)

/**	Maximum dk3_im_t value.
*/
#define	DK3_IM_MAX	(DK3_LL_MAX)
#else
/**	Minimum dk3_im_t value.
*/
#define	DK3_IM_MIN	(DK3_L_MIN)

/**	Maximum dk3_im_t value.
*/
#define	DK3_IM_MAX	(DK3_L_MAX)
#endif
#endif


#if DK3_HAVE_LONG_LONG
/**	0 in dk3_im_t.
*/
#define	DK3_IM_0	((dk3_im_t)0LL)
/**	0 in dk3_um_t.
*/
#define	DK3_UM_0	((dk3_um_t)0ULL)
/**	1 in dk3_um_t.
*/
#define	DK3_UM_1	((dk3_um_t)1ULL)
#else
/**	0 in dk3_im_t.
*/
#define	DK3_IM_0	((dk3_im_t)0L)
/**	0 in dk3_um_t.
*/
#define	DK3_UM_0	((dk3_um_t)0UL)
/**	1 in dk3_um_t.
*/
#define	DK3_UM_1	((dk3_um_t)1UL)
#endif

/*	dk3_um_t
	--------
*/
#if DK3_HAVE_INTMAX_T
/**	Maximum dk3_um_t value.
*/
#define	DK3_UM_MAX	(DK3_UINTMAX_T_MAX)
#else
#if DK3_HAVE_LONG_LONG
/**	Maximum dk3_um_t value.
*/
#define	DK3_UM_MAX	(DK3_ULL_MAX)
#else
/**	Maximum dk3_um_t value.
*/
#define	DK3_UM_MAX	(DK3_UL_MAX)
#endif
#endif



#if defined(SIZE_MAX)
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(SIZE_MAX)
#else
#if DK3_SIZEOF_SIZE_T == DK3_SIZEOF_INT
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(DK3_U_MAX)
#else
#if DK3_SIZEOF_SIZE_T == DK3_SIZEOF_LONG
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(DK3_UL_MAX)
#else
#if (DK3_HAVE_LONG_LONG) && (DK3_SIZEOF_SIZE_T == DK3_SIZEOF_LONG_LONG)
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(DK3_ULL_MAX)
#else
#if (DK3_HAVE_INTMAX_T) && (DK3_SIZE OF_SIZE_T == DK3_SIZEOF_INTMAX_T) && (defined(UINT_MAX))
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(DK3_UM_MAX)
#else
#if DK3_SIZEOF_SIZE_T	> 2
#if DK3_SIZEOF_SIZE_T	> 4
#if DK3_SIZEOF_SIZE_T	> 8
#error	"No definitions for size_t larger than 8 bytes yet!"
#else
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(18446744073709551615ULL)
#endif
#else
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(4294967295UL)
#endif
#else
/**	Maximum size_t value.
*/
#define	DK3_SIZE_T_MAX	(65535U)
#endif
#endif
#endif
#endif
#endif
#endif

#if DK3_HAVE_INTMAX_T
/**	Size of the dk3_um_t type.
*/
#define	DK3_SIZEOF_UM	DK3_SIZEOF_INTMAX_T
#else
#if DK3_HAVE_LONG_LONG
/**	Size of the dk3_um_t type.
*/
#define	DK3_SIZEOF_UM	DK3_SIZEOF_LONG_LONG
#else
/**	Size of the dk3_um_t type.
*/
#define	DK3_SIZEOF_UM	DK3_SIZEOF_LONG
#endif
#endif

#endif
/* ifndef DK3NUMCO_H_INCLUDED */

