
#ifndef	DK3NETTP_H_INCLUDED
#define	DK3NETTP_H_INCLUDED 1


#include <dk3all.h>



#if DK3_ON_WINDOWS || DK3_HAVE_SOCKET



/**	IPv4 address.
*/
typedef struct {

  /**	IP address in net representation.
  */
  struct sockaddr_in	soin;

  /**	Minimum port number to use for local ip address.
  */
  unsigned short	portmin;

  /**	Maximum port number. When binding a local address we can specify
  	a port range portno-portmax.
  */
  unsigned short	portmax;

} dk3_ip_addr_t;




/**	Socket address.
*/
typedef struct sockaddr		DK3_SOA;

/**	Internet socket address.
*/
typedef struct sockaddr_in	DK3_SOAIN;

/**	Size of internet socket address.
*/
#define	DK3_SZ_SOAIN		sizeof(DK3_SOAIN)



/**	Network socket.
*/
typedef struct {

  /**	Local IP address.
  */
  dk3_ip_addr_t		 local;

  /**	Remote IP address wished.
	This address is used when sending UDP packets.
  */
  dk3_ip_addr_t		 remote_wished;

  /**	Remote IP address found.
	When receiving UDP packets, the sender address is stored here.
  */
  dk3_ip_addr_t		 remote_found;

  /**	Application structure for diagnostics and preferences.
  */
  dk3_app_t		*app;

#if DK3_ON_WINDOWS
  /**	File descriptor, the real socket.
  */
  SOCKET		fd;
#else
  /**	File descriptor, the real socket.
  */
  int			fd;
#endif

  /**	Socket state, DK3_SOCKET_STATE_xxx.
  */
  int			st;

  /**	Flag: End of input data found (0 bytes read).
  */
  int			eod_found;

  /**	Flag: Write shutdown was sent to peer during close operation.
  */
  int			shutdown_done;

} dk3_socket_t;


#endif
/* if DK3_ON_WINDOWS || DK3_HAVE_SOCKET */


#endif
/* if DK3NETTP_H_INCLUDED */

