/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mem.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3MEM_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MEM_H_INCLUDED 1


#line 10 "dk3mem.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif


/**	Reset memory range.
 * 	@param	mp	Memory pointer.
 * 	@param	sz	Size of memory range in bytes.
 */
void
dk3mem_res(void	*mp, size_t sz) ;

/**	Copy memory range. The buffers must not overlap!
 * 	@param	dp	Destination buffer pointer.
 * 	@param	sp	Source pointer.
 * 	@param	sz	Number of bytes to copy.
 */
void
dk3mem_cpy(void	*dp, void const	*sp, size_t sz);

/**	Compare two memory ranges byte by byte.
 * 	@param	s1	Left pointer.
 * 	@param	s2	Right pointer.
 * 	@param	sz	Maximum number of bytes to use in comparison.
 * 	@return	1 for s1>s2, 0 for s1==s2, -1 for s1<s2.
 */
int
dk3mem_cmp(void const *s1, void const *s2, size_t sz);

/**	Allocate memory dynamically.
 * 	@param	sz	Number of bytes to allocate.
 * 	@return	Pointer to new memory on success, NULL on error.
 */
void *
dk3mem_malloc(size_t sz);

/**	Allocate memory dynamically.
 * 	@param	sz	Number of bytes to allocate.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new memory on success, NULL on error.
 */
void *
dk3mem_malloc_app(size_t sz, dk3_app_t *app);

/**	Allocate memory dynamically.
 * 	@param	sz	Element size.
 * 	@param	ne	Number of elements.
 * 	@return	Pointer to new memory on success, NULL on error.
 */
void *
dk3mem_alloc(size_t sz, size_t ne);

/**	Allocate memory dynamically.
 * 	@param	sz	Element size.
 * 	@param	ne	Number of elements.
 * 	@param	app	Application structure for diagnostics, may be NULL.
 * 	@return	Pointer to new memory on success, NULL on error.
 */
void *
dk3mem_alloc_app(size_t	sz, size_t ne, dk3_app_t *app);

/**	Release dynamically allocated memory.
 * 	@param	po	Pointer to memory.
 */
void
dk3mem_free(void *po);

/**	Calculate number of bytes (product element size, number of elements).
	@param	sz	Element size.
	@param	ne	Number of elements.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OUT_OF_RANGE if the element size sz is 0,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	Product on success, 0 on error (mathematical overflow,
	one of the sizes 0).
*/
size_t
dk3mem_mul_size_t(size_t sz, size_t ne, int *ec);

/**	Summary of two sizes.
	@param	a	One size.
	@param	b	Other size.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OVERFLOW if a numeric overflow occurs.
	@return	Positive number on success, 0 on error (mathematical overflow).
*/
size_t
dk3mem_add_size_t(size_t a, size_t b, int *ec);

#ifdef __cplusplus
}
#endif

/**	Get number of elements in an array.
 * 	@param	v	Variable.
 * 	@param	t	Type.
 * 	@return	Number of elememnts of type \a t in \a v.
 */
#define DK3_SIZEOF(v,t)	(sizeof(v)/sizeof(t))

/**	Calculate byte alignment for a given size, round upwards if necessary.
	@param	a	Original size.
	@param	b	Alignment size.
	@return	a, corrected upwards if necessary.
*/
#define	DK3_MEM_ALIGN(a,b) \
((0 == b) ? (a) : ((0 == (a) % (b)) ? (a) : ((b) * (((a) / (b)) + 1))))

/**	Allocate memory dynamically.
 * 	@param	t	Type.
 * 	@param	s	Number of elements.
 * 	@return	Type-casted pointer to new memory or NULL.
 */
#define dk3_new(t,s) ((t *)dk3mem_alloc_app(sizeof(t),(size_t)(s),NULL))

/**	Allocate memory dynamically.
 * 	@param	t	Type.
 * 	@param	s	Number of elements.
 * 	@param	a	Application structure for diagnostics, may be NULL.
 * 	@return	Type-casted pointer to new memory or NULL.
 */
#define	dk3_new_app(t,s,a) ((t *)dk3mem_alloc_app(sizeof(t),(size_t)(s),(a)))

/**	Release memory.
 * 	@param	po	Pointer to memory to release.
 */
#define dk3_delete(po) \
do { if(po) { dk3mem_free((void *)(po)); } } while(0)

/**	Release memory.
 * 	@param	po	Pointer to memory to release.
 */
#define	dk3_release(po) \
do { if(po) { dk3mem_free((void *)(po)); } po = NULL; } while(0)

/**	Release C++ object.
 *	@param	po	Object pointer.
 */
#define	dk3_cpp_release(po) \
do { if(po) { delete(po); } po = NULL; } while(0)




#endif
