/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mem.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mem.c The dk3mem module.
*/


#line 158 "dk3mem.ctr"

#include "dk3all.h"






#line 164 "dk3mem.ctr"



void
dk3mem_res(void *mp, size_t sz)
/* {{{ */
{
  if((NULL != mp) && (0 != sz)) {
#if DK3_HAVE_MEMSET
    memset(mp, (int)'\0', sz);
#else
#if DK3_HAVE_BZERO
    bzero(mp, sz);
#else
    register char *ptr;
    register size_t i;
    ptr = (char *)mp; i = sz;
    while(i--) { *(ptr++) = '\0'; }
#endif
#endif
  }
}
/* }}} */



void
dk3mem_cpy(void *dp, void const *sp, size_t sz)
/* {{{ */
{
  if((NULL != dp) && (NULL != sp) && (0 != sz)) {
#if DK3_HAVE_MEMCPY
    memcpy(dp, sp, sz);
#else
#if DK3_HAVE_BCOPY
    bcopy(sp, dp, sz);
#else
    register char *mydp;
    register char const *mysp;
    register size_t i;
    mydp = (char *)dp;
    mysp = (char const *)sp;
    i = sz;
    while(i--) { *(mydp++) = *(mysp++); }
#endif
#endif
  }
}
/* }}} */



int
dk3mem_cmp(void const *s1, void const *s2, size_t sz)
/* {{{ */
{
  int back = 0;
  if(NULL != s1) {
    if(NULL != s2) {
#if DK3_HAVE_MEMCMP
        back = memcmp(s1, s2, sz);
#else
#if DK3_HAVE_BCMP
        back = bcmp(s1, s2, sz);
#else
        register unsigned char const *mys1;
        register unsigned char const *mys2;
	register size_t i;
	register int myback = 0;
        mys1 = (unsigned char const *)s1;
	mys2 = (unsigned char const *)s2;
        for(i = 0; ((i < sz) && (0 == myback)); i++) {
          if(*mys1 > *mys2) {
            myback = 1;
          } else {
            if(*mys1 < *mys2) {
              myback = -1;
            } else {
              mys1++; mys2++;
            }
          }
        }
	back = myback;
#endif
#endif
    } else { back = 1; }
  } else {
    if(s2) { back = -1; }
  }
  return back;
}
/* }}} */



void *
dk3mem_malloc_app(size_t sz, dk3_app_t *app)
/* {{{ */
{
  void		*back = NULL;
  char		c8buffer[64];	/* Buffer to show number of bytes. */
  dkChar	dkbuffer[64];	/* Buffer to show number of bytes. */
  

#line 267 "dk3mem.ctr"
  if(0 != sz) {
#if DK3_ON_WINDOWS && (_MSC_VER > 1100)
    

#line 270 "dk3mem.ctr"
    back = (void *)LocalAlloc((LMEM_FIXED | LMEM_ZEROINIT), sz);
#else
#if DK3_HAVE_MALLOC && DK3_HAVE_FREE
    

#line 274 "dk3mem.ctr"
    back = malloc(sz);
    

#line 276 "dk3mem.ctr"
#else
#error "The malloc and free functions are not available here!"
#endif
#endif
    if(NULL != back) {	

#line 281 "dk3mem.ctr"
      dk3mem_res(back, sz);
    } else {	

#line 283 "dk3mem.ctr"
      if(NULL != app) {	

#line 284 "dk3mem.ctr"
        /* ERROR: Failed to allocate n bytes! */
	if(0 != dk3ma_um_to_c8_string(c8buffer,sizeof(c8buffer),(dk3_um_t)sz)) {
	  (void)dk3str_cnv_c8_to_str_app(
	    dkbuffer, DK3_SIZEOF(dkbuffer,dkChar), c8buffer, NULL
	  );
	  dk3app_log_i3(app, DK3_LL_ERROR, 12, 13, dkbuffer);
	} else {
	  dk3app_log_i1(app, DK3_LL_ERROR, 14);
	}
      }
    }
  } 

#line 296 "dk3mem.ctr"
  return back;
}
/* }}} */


void *
dk3mem_malloc(size_t sz)
/* {{{ */
{
  void *back;
  back = dk3mem_malloc_app(sz, NULL);
  return back;
}
/* }}} */



size_t
dk3mem_mul_size_t(size_t sz, size_t ne, int *ec)
/* {{{ */
{
  size_t back = 0;
  if (0 < sz) {
    if ((DK3_SIZE_T_MAX / sz) < ne) {
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    } else {
      back = (sz * ne);
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  }
  return back;
}
/* }}} */



size_t
dk3mem_add_size_t(size_t a, size_t b, int *ec)
{
  size_t back = 0;
  if((DK3_SIZE_T_MAX - a) >= b) { back = a + b; }
  else { if(NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; } }
  return back;
}


void *
dk3mem_alloc_app(size_t sz, size_t ne, dk3_app_t *app)
/* {{{ */
{
  void			*back = NULL;
  size_t		as = 0;		/* Allocation size. */
  char			c8b1[64];	/* Buffer for element size. */
  char			c8b2[64];	/* Buffer for number of elements. */
  dkChar		dkb1[64];	/* Buffer for element size. */
  dkChar		dkb2[64];	/* Buffer for number of elements. */
  int			ok = 0;		/* Flag: Success. */
  

#line 355 "dk3mem.ctr"
  if((0 != sz) && (0 != ne)) {	
    as = dk3mem_mul_size_t(sz, ne, NULL);
    if(0 != as) {
      back = dk3mem_malloc_app(as, app);
    } else {
      if(NULL != app) {
        /* ERROR: Numeric overflow! */
	ok = 0;
	dkb1[0] = dkb2[0] = dkT('\0');
	if(0 != dk3ma_um_to_c8_string(c8b1, sizeof(c8b1),(dk3_um_t)sz)) {
	  if(0 != dk3ma_um_to_c8_string(c8b2, sizeof(c8b2),(dk3_um_t)ne)) {
	    (void)dk3str_cnv_c8_to_str_app(
	      dkb1, DK3_SIZEOF(dkb1,dkChar), c8b1, NULL
	    );
	    (void)dk3str_cnv_c8_to_str_app(
	      dkb2, DK3_SIZEOF(dkb2,dkChar), c8b2, NULL
	    );
	    ok = 1;
	  }
	}
	if(0 != ok) {
	  dk3app_log_i5(app, DK3_LL_ERROR, 16, 17, 18, dkb1, dkb2);
	} else {
	  dk3app_log_i1(app, DK3_LL_ERROR, 15);
	}
      }
    }
  } 

#line 383 "dk3mem.ctr"
  return back;
}
/* }}} */



void *
dk3mem_alloc(size_t sz, size_t ne)
/* {{{ */
{
  void *back;
  back = dk3mem_alloc_app(sz, ne, NULL);
  return back;
}
/* }}} */



void
dk3mem_free (void *po)
/* {{{ */
{
  if(NULL != po) {
#if DK3_ON_WINDOWS && (_MSC_VER > 1100)
    LocalFree((HLOCAL)po);
#else
#if DK3_HAVE_MALLOC && DK3_HAVE_FREE
    free(po);
#endif
#endif
  }
}
/* }}} */


/* vim: set ai sw=2 filetype=c foldmethod=marker foldopen=all : */

