/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3md.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3MD_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MD_H_INCLUDED 1


#line 9 "dk3md.ctr"

#include <dk3conf.h>
#include <dk3types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**	Addition of double or long double.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable.
	@return	Operation result.
*/
dk3_double_t
dk3md_add_ok(dk3_double_t a, dk3_double_t b, int *ec);

/**	Substraction of double or long double.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable.
	@return	Operation result.
*/
dk3_double_t
dk3md_sub_ok(dk3_double_t a, dk3_double_t b, int *ec);

/**	Multiplication of double or long double.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable.
	@return	Operation result.
*/
dk3_double_t
dk3md_mul_ok(dk3_double_t a, dk3_double_t b, int *ec);

/**	Division of double or long double.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable.
	@return	Operation result.
*/
dk3_double_t
dk3md_div_ok(dk3_double_t a, dk3_double_t b, int *ec);

/**	Obtain format string for conversions.
	@param	c	Key character 'e', 'f', or 'g'.
	@return	Conversion format string.
*/
dkChar const *
dk3md_format(char c);

/**	Obtain format string for conversions.
	@param	c	Key character 'e', 'f', or 'g'.
	@return	Conversion format string.
*/
char const *
dk3md_c8_format(char c);

/**	Check availability of long double.
	@return	1 for long double available, 0 for fallback to double.
*/
int
dk3md_have_long_double(void);

/**	Sinus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_sin(dk3_double_t x);

/**	Cosinus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_cos(dk3_double_t x);

/**	Tangens.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_tan(dk3_double_t x);

/**	Arcus sinus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_asin(dk3_double_t x);

/**	Arcus cosinus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_acos(dk3_double_t x);

/**	Arcus tangens.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_atan(dk3_double_t x);

/**	Arcus tangens for two arguments.
	@param	y	Y position.
	@param	x	X position.
	@return	Result.
*/
dk3_double_t
dk3md_atan2(dk3_double_t y, dk3_double_t x);

/**	Absolute value.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_fabs(dk3_double_t x);

/**	Round downwards.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_floor(dk3_double_t x);

/**	Round upwards.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_ceil(dk3_double_t x);

/**	Round to next integer.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_rint(dk3_double_t x);

/**	Exponential function.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_exp(dk3_double_t x);

/**	Logarithm.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_log(dk3_double_t x);

/**	Square root.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_sqrt(dk3_double_t x);

/**	Sinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_sinh(dk3_double_t x);

/**	Cosinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_cosh(dk3_double_t x);

/**	Tangens hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_tanh(dk3_double_t x);

#if DK3_HAVE_LONG_DOUBLE && (DK3_SIZEOF_LONG_DOUBLE > DK3_SIZEOF_DOUBLE)
#if (DK3_HAVE_ASINHL) && (DK3_HAVE_ACOSHL) && (DK3_HAVE_ATANHL)

/**	Arcus sinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_asinh(dk3_double_t x);

/**	Arcus cosinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_acosh(dk3_double_t x);

/**	Arcus tangens hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_atanh(dk3_double_t x);

#else
#if (DK3_HAVE_ASINH) && (DK3_HAVE_ACOSH) && (DK3_HAVE_ATANH)

/**	Arcus sinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_asinh(dk3_double_t x);

/**	Arcus cosinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_acosh(dk3_double_t x);

/**	Arcus tangens hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_atanh(dk3_double_t x);

#else
#if (DK3_NEED_ASINH) || (DK3_NEED_ACOSH) || (DK3_NEED_ATANH)
#error	"No asinh/acosh/atanh function in math library!"
#endif
#endif
#endif
#else
#if (DK3_HAVE_ASINH) && (DK3_HAVE_ACOSH) && (DK3_HAVE_ATANH)

/**	Arcus sinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_asinh(dk3_double_t x);

/**	Arcus cosinus hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_acosh(dk3_double_t x);

/**	Arcus tangens hyperbolicus.
	@param	x	Argument.
	@return	Result.
*/
dk3_double_t
dk3md_atanh(dk3_double_t x);
#else

#if (DK3_NEED_ASINH) || (DK3_NEED_ACOSH) || (DK3_NEED_ATANH)
#error	"No asinh/acosh/atanh function in math library!"
#endif
#endif
#endif

#ifdef __cplusplus
}
#endif


#endif
