/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3maul.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3maul.h Header file for the dk3maul module.
*/

#ifndef DK3MAUL_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MAUL_H_INCLUDED 1


#line 10 "dk3maul.ctr"

/**	@file	dk3maul.h	Mathematical operations on
	unsigned long, unsigned long long, uintmax_t and dk3_um_t.
*/

#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
unsigned long
dk3ma_ul_add_ok(unsigned long a, unsigned long b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
unsigned long
dk3ma_ul_sub_ok(unsigned long a, unsigned long b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
unsigned long
dk3ma_ul_mul_ok(unsigned long a, unsigned long b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
unsigned long
dk3ma_ul_div_ok(unsigned long a, unsigned long b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b.
*/
unsigned long
dk3ma_ul_gcd(unsigned long a, unsigned long b);


#if DK3_HAVE_LONG_LONG

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
unsigned long long
dk3ma_ull_add_ok(unsigned long long a, unsigned long long b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
unsigned long long
dk3ma_ull_sub_ok(unsigned long long a, unsigned long long b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
unsigned long long
dk3ma_ull_mul_ok(unsigned long long a, unsigned long long b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
unsigned long long
dk3ma_ull_div_ok(unsigned long long a, unsigned long long b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b.
*/
unsigned long long
dk3ma_ull_gcd(unsigned long long a, unsigned long long b);

#endif



#if DK3_HAVE_INTMAX_T

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
uintmax_t
dk3ma_uintmax_t_add_ok(uintmax_t a, uintmax_t b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
uintmax_t
dk3ma_uintmax_t_sub_ok(uintmax_t a, uintmax_t b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
uintmax_t
dk3ma_uintmax_t_mul_ok(uintmax_t a, uintmax_t b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
uintmax_t
dk3ma_uintmax_t_div_ok(uintmax_t a, uintmax_t b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b.
*/
uintmax_t
dk3ma_uintmax_t_gcd(uintmax_t a, uintmax_t b);

#endif


/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
dk3_um_t
dk3ma_um_add_ok(dk3_um_t a, dk3_um_t b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
dk3_um_t
dk3ma_um_sub_ok(dk3_um_t a, dk3_um_t b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
dk3_um_t
dk3ma_um_mul_ok(dk3_um_t a, dk3_um_t b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
dk3_um_t
dk3ma_um_div_ok(dk3_um_t a, dk3_um_t b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b.
*/
dk3_um_t
dk3ma_um_gcd(dk3_um_t a, dk3_um_t b);

/**	Convert dk3_um_t to size_t.
	@param	um	Positive dk3_um_t value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OVERFLOW on conversion errors.
	@return	Positive number on success, 0 on error
	(significant bits lost in conversion).
*/
size_t
dk3ma_um_to_sz(dk3_um_t um, int *ec);

#ifdef __cplusplus
}
#endif




#endif
