/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3maul.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3maul.c The dk3maul module.
*/


#line 271 "dk3maul.ctr"



#include "dk3ma.h"





#line 279 "dk3maul.ctr"



unsigned long
dk3ma_ul_add_ok(unsigned long a, unsigned long b, int *ec)
{
  

#line 286 "dk3maul.ctr"
  if (NULL != ec) {		

#line 287 "dk3maul.ctr"
    if ((DK3_UL_MAX - a) < b) { *ec = DK3_ERROR_MATH_OVERFLOW; }
  } 

#line 289 "dk3maul.ctr"
  return (a + b);
}



unsigned long
dk3ma_ul_sub_ok(unsigned long a, unsigned long b, int *ec)
{
  

#line 298 "dk3maul.ctr"
  if (NULL != ec) {
    if (b > a) {		

#line 300 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_OVERFLOW;
    }
  }
  return (a - b);
}



unsigned long
dk3ma_ul_mul_ok(unsigned long a, unsigned long b, int *ec)
{
  

#line 312 "dk3maul.ctr"
  if (NULL != ec) {
    if (0UL != a) {
      if ((DK3_UL_MAX / a) < b) {	

#line 315 "dk3maul.ctr"
        *ec = DK3_ERROR_MATH_OVERFLOW;
      }
    }
  } 

#line 319 "dk3maul.ctr"
  return (a * b);
}


 
unsigned long
dk3ma_ul_div_ok(unsigned long a, unsigned long b, int *ec)
{
  unsigned long	back	=	(unsigned long)0;
  

#line 329 "dk3maul.ctr"
  if (0UL != b) {
    back = a / b;
  } else {
    if (NULL != ec) {		

#line 333 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_DIVZERO;
    }
    back = DK3_UL_MAX;
  } 

#line 337 "dk3maul.ctr"
  return back;
}



unsigned long
dk3ma_ul_gcd(unsigned long a, unsigned long b)
{
  unsigned long	h;
  

#line 347 "dk3maul.ctr"
  while (0UL < b) {
    h = a % b;
    a = b;
    b = h;
  }
  if (0UL == a) { a = 1UL; } 

#line 353 "dk3maul.ctr"
  return a;
}



#if DK3_HAVE_LONG_LONG

unsigned long long
dk3ma_ull_add_ok(unsigned long long a, unsigned long long b, int *ec)
{
#if DK3_ON_WINDOWS
  

#line 365 "dk3maul.ctr"
#else
  

#line 367 "dk3maul.ctr"
#endif
  if (NULL != ec) {
    if ((DK3_ULL_MAX - a) < b) {	

#line 370 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_OVERFLOW;
    }
  }
#if DK3_ON_WINDOWS
  

#line 375 "dk3maul.ctr"
#else
  

#line 377 "dk3maul.ctr"
#endif
  return (a + b);
}



unsigned long long
dk3ma_ull_sub_ok(unsigned long long a, unsigned long long b, int *ec)
{
#if DK3_ON_WINDOWS
  

#line 388 "dk3maul.ctr"
#else
  

#line 390 "dk3maul.ctr"
#endif
  if (NULL != ec) {
    if (b > a) {			

#line 393 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_OVERFLOW;
    }
  }
#if DK3_ON_WINDOWS
  

#line 398 "dk3maul.ctr"
#else
  

#line 400 "dk3maul.ctr"
#endif
  return (a - b);
}



unsigned long long
dk3ma_ull_mul_ok(unsigned long long a, unsigned long long b, int *ec)
{
#if DK3_ON_WINDOWS
  

#line 411 "dk3maul.ctr"
#else
  

#line 413 "dk3maul.ctr"
#endif
  if (NULL != ec) {
    if (0ULL != a) {			

#line 416 "dk3maul.ctr"
      if ((DK3_ULL_MAX / a) < b) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  }
#if DK3_ON_WINDOWS
  

#line 421 "dk3maul.ctr"
#else
  

#line 423 "dk3maul.ctr"
#endif
  return (a * b);
}



unsigned long long
dk3ma_ull_div_ok(unsigned long long a, unsigned long long b, int *ec)
{
  unsigned long long	back	=	(unsigned long long)0;
#if DK3_ON_WINDOWS
  

#line 435 "dk3maul.ctr"
#else
  

#line 437 "dk3maul.ctr"
#endif
  if (0ULL != b) {
    back = a / b;
  } else {
    if (NULL != ec) {			

#line 442 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_DIVZERO;
    }
    back = DK3_ULL_MAX;
  }
#if DK3_ON_WINDOWS
  

#line 448 "dk3maul.ctr"
#else
  

#line 450 "dk3maul.ctr"
#endif
  return back;
}



unsigned long long
dk3ma_ull_gcd(unsigned long long a, unsigned long long b)
{
  unsigned long long	h;
#if DK3_ON_WINDOWS
  

#line 462 "dk3maul.ctr"
#else
  

#line 464 "dk3maul.ctr"
#endif
  while (0ULL < b) {
    h = a % b;
    a = b;
    b = h;
  }
  if (0ULL == a) { a = 1ULL; }
#if DK3_ON_WINDOWS
  

#line 473 "dk3maul.ctr"
#else
  

#line 475 "dk3maul.ctr"
#endif
  return a;
}


#endif



#if DK3_HAVE_INTMAX_T

uintmax_t
dk3ma_uintmax_t_add_ok(uintmax_t a, uintmax_t b, int *ec)
{
#if DK3_ON_WINDOWS
  

#line 491 "dk3maul.ctr"
#else
  

#line 493 "dk3maul.ctr"
#endif
  if (NULL != ec) {
    if ((DK3_UINTMAX_T_MAX - a) < b) {	

#line 496 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_OVERFLOW;
    }
  }
#if DK3_ON_WINDOWS
  

#line 501 "dk3maul.ctr"
#else
  

#line 503 "dk3maul.ctr"
#endif
  return (a + b);
}



uintmax_t
dk3ma_uintmax_t_sub_ok(uintmax_t a, uintmax_t b, int *ec)
{
#if DK3_ON_WINDOWS
  

#line 514 "dk3maul.ctr"
#else
  

#line 516 "dk3maul.ctr"
#endif
  if (NULL != ec) {
    if (b > a) {			

#line 519 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_OVERFLOW;
    }
  }
#if DK3_ON_WINDOWS
  

#line 524 "dk3maul.ctr"
#else
  

#line 526 "dk3maul.ctr"
#endif
  return (a - b);
}



uintmax_t
dk3ma_uintmax_t_mul_ok(uintmax_t a, uintmax_t b, int *ec)
{
#if DK3_ON_WINDOWS
  

#line 537 "dk3maul.ctr"
#else
  

#line 539 "dk3maul.ctr"
#endif
  if (NULL != ec) {
    if (DK3_UINTMAX_T_0 != a) {
      if ((DK3_UINTMAX_T_MAX / a) < b) {	

#line 543 "dk3maul.ctr"
        *ec = DK3_ERROR_MATH_OVERFLOW;
      }
    }
  }
#if DK3_ON_WINDOWS
  

#line 549 "dk3maul.ctr"
#else
  

#line 551 "dk3maul.ctr"
#endif
  return (a * b);
}



uintmax_t
dk3ma_uintmax_t_div_ok(uintmax_t a, uintmax_t b, int *ec)
{
  uintmax_t	back	=	(uintmax_t)0;
#if DK3_ON_WINDOWS
  

#line 563 "dk3maul.ctr"
#else
  

#line 565 "dk3maul.ctr"
#endif
  if (DK3_UINTMAX_T_0 != b) {
    back = a / b;
  } else {
    if (NULL != ec) {			

#line 570 "dk3maul.ctr"
      *ec = DK3_ERROR_MATH_DIVZERO;
    }
    back = DK3_UINTMAX_T_MAX;
  }
#if DK3_ON_WINDOWS
  

#line 576 "dk3maul.ctr"
#else
  

#line 578 "dk3maul.ctr"
#endif
  return back;
}



uintmax_t
dk3ma_uintmax_t_gcd(uintmax_t a, uintmax_t b)
{
  uintmax_t	h;
#if DK3_ON_WINDOWS
  

#line 590 "dk3maul.ctr"
#else
  

#line 592 "dk3maul.ctr"
#endif
  while (DK3_UINTMAX_T_0 < b) {
    h = a % b;
    a = b;
    b = h;
  }
  if (DK3_UINTMAX_T_0 == a) { a = DK3_UINTMAX_T_1; }
#if DK3_ON_WINDOWS
  

#line 601 "dk3maul.ctr"
#else
  

#line 603 "dk3maul.ctr"
#endif
  return a;
}


#endif



dk3_um_t
dk3ma_um_add_ok(dk3_um_t a, dk3_um_t b, int *ec)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_uintmax_t_add_ok(a, b, ec));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_ull_add_ok(a, b, ec));
#else
  return (dk3ma_ul_add_ok(a, b, ec));
#endif
#endif
}



dk3_um_t
dk3ma_um_sub_ok(dk3_um_t a, dk3_um_t b, int *ec)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_uintmax_t_sub_ok(a, b, ec));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_ull_sub_ok(a, b, ec));
#else
  return (dk3ma_ul_sub_ok(a, b, ec));
#endif
#endif
}



dk3_um_t
dk3ma_um_mul_ok(dk3_um_t a, dk3_um_t b, int *ec)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_uintmax_t_mul_ok(a, b, ec));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_ull_mul_ok(a, b, ec));
#else
  return (dk3ma_ul_mul_ok(a, b, ec));
#endif
#endif
}



dk3_um_t
dk3ma_um_div_ok(dk3_um_t a, dk3_um_t b, int *ec)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_uintmax_t_div_ok(a, b, ec));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_ull_div_ok(a, b, ec));
#else
  return (dk3ma_ul_div_ok(a, b, ec));
#endif
#endif
}



dk3_um_t
dk3ma_um_gcd(dk3_um_t a, dk3_um_t b)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_uintmax_t_gcd(a, b));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_ull_gcd(a, b));
#else
  return (dk3ma_ul_gcd(a, b));
#endif
#endif
}



size_t
dk3ma_um_to_sz(dk3_um_t um, int *ec)
{
  size_t	back = 0;
#if DK3_SIZEOF_SIZE_T >= DK3_SIZEOF_UM
  back = (size_t)um;
#else
  if ((dk3_um_t)DK3_SIZE_T_MAX >= um) {
    back = (size_t)um;
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
  }
#endif
  return back;
}

