/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mastr.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mastr.h Header file for the dk3mastr module.
*/

#ifndef DK3MASTR_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MASTR_H_INCLUDED 1


#line 10 "dk3mastr.ctr"

/**	@file	dk3mastr.h	Conversion from numbers to strings.
*/

#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

/**	Convert largest size integer to string.
	@param	rb	Result buffer.
	@param	sz	Result buffer size (number of bytes).
	@param	va	Value to convert.
	@return	1 on success, 0 on error.
*/
int
dk3ma_im_to_c8_string(char *rb, size_t sz, dk3_im_t va);

/**	Convert largest size unsigned integer to string.
	@param	rb	Result buffer.
	@param	sz	Result buffer size (number of bytes).
	@param	va	Value to convert.
	@return	1 on success, 0 on error.
*/
int
dk3ma_um_to_c8_string(char *rb, size_t sz, dk3_um_t va);

/**	Convert largest size unsigned integer to hexadecimal string.
	@param	rb	Result buffer.
	@param	sz	Result buffer size (number of bytes).
	@param	va	Value to convert.
	@return	1 on success, 0 on error.
*/
int
dk3ma_um_to_c8_hex_string(char *rb, size_t sz, dk3_um_t va);

/**	Convert largest size integer to string.
	@param	rb	Result buffer.
	@param	sz	Result buffer size (number of bytes).
	@param	va	Value to convert.
	@return	1 on success, 0 on error.
*/
int
dk3ma_im_to_string(dkChar *rb, size_t sz, dk3_im_t va);

/**	Convert largest size unsigned integer to string.
	@param	rb	Result buffer.
	@param	sz	Result buffer size (number of bytes).
	@param	va	Value to convert.
	@return	1 on success, 0 on error.
*/
int
dk3ma_um_to_string(dkChar *rb, size_t sz, dk3_um_t va);

/**	Convert largest size unsigned integer to hexadecimal string.
	@param	rb	Result buffer.
	@param	sz	Result buffer size (number of bytes).
	@param	va	Value to convert.
	@param	leftpad	Flag: 0-padding on the left.
	@return	1 on success, 0 on error.
*/
int
dk3ma_um_to_hex_string(dkChar *rb, size_t sz, dk3_um_t va, int leftpad);

/**	Convert string to dk3_um_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_um_from_c8_string(dk3_um_t *rp, char const *src, int *ec);

/**	Convert string to dk3_im_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_im_from_c8_string(dk3_im_t *rp, char const *src, int *ec);

/**	Convert string to dk3_um_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_um_from_string(dk3_um_t *rp, dkChar const *src, int *ec);

/**	Convert string to dk3_im_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_im_from_string(dk3_im_t *rp, dkChar const *src, int *ec);

/**	Convert string to short.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_s_from_string(short *rp, dkChar const *src, int *ec);

/**	Convert string to short.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_s_from_c8_string(short *rp, char const *src, int *ec);

/**	Convert string to unsigned short.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_us_from_string(unsigned short *rp, dkChar const *src, int *ec);

/**	Convert string to unsigned short.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_us_from_c8_string(unsigned short *rp, char const *src, int *ec);

/**	Convert string to int.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_i_from_string(int *rp, dkChar const *src, int *ec);

/**	Convert string to int.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_i_from_c8_string(int *rp, char const *src, int *ec);

/**	Convert string to unsigned.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ui_from_string(unsigned *rp, dkChar const *src, int *ec);

/**	Convert string to unsigned.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ui_from_c8_string(unsigned *rp, char const *src, int *ec);

/**	Convert string to long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_l_from_string(long *rp, dkChar const *src, int *ec);

/**	Convert string to long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_l_from_c8_string(long *rp, char const *src, int *ec);

/**	Convert string to unsigned long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ul_from_string(unsigned long *rp, dkChar const *src, int *ec);

/**	Convert string to unsigned long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ul_from_c8_string(unsigned long *rp, char const *src, int *ec);

#if DK3_HAVE_LONG_LONG

/**	Convert string to long long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ll_from_string(long long *rp, dkChar const *src, int *ec);

/**	Convert string to long long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ll_from_c8_string(long long *rp, char const *src, int *ec);

/**	Convert string to unsigned long long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ull_from_string(unsigned long long *rp, dkChar const *src, int *ec);

/**	Convert string to unsigned long long.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_ull_from_c8_string(unsigned long long *rp, char const *src, int *ec);

#endif

#if DK3_HAVE_INTMAX_T

/**	Convert string to intmax_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_intmax_t_from_string(intmax_t *rp, dkChar const *src, int *ec);

/**	Convert string to intmax_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_intmax_t_from_c8_string(intmax_t *rp, char const *src, int *ec);

/**	Convert string to uintmax_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_uintmax_t_from_string(uintmax_t *rp, dkChar const *src, int *ec);

/**	Convert string to uintmax_t.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
	If trailing garbage is found after the number, the function
	returns 1 and sets the error code variable to DK3_ERROR_SYNTAX.
*/
int
dk3ma_uintmax_t_from_c8_string(uintmax_t *rp, char const *src, int *ec);

#endif

/**	Convert string to size_t. The string can optionally contain an
	``k'', ``K'', ``m'', ``M'', ``g'', or ``G'' suffix.
	@param	rp	Pointer to result variable.
	@param	src	Source text to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_INVALID_ARGS if rp and/or src is NULL or
	the string is too long for the internal buffer,
	DK3_ERROR_SYNTAX if unacceptable characters found,
	DK3_ERROR_MATH_OVERFLOW on numeric overflow.
	@return	1 on success, 0 on error (see ec).
*/
int
dk3ma_sz_from_string(size_t *rp, dkChar const *src, int *ec);

#ifdef __cplusplus
}
#endif




#endif
