/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mastr.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mastr.c The dk3mastr module.
*/


#line 461 "dk3mastr.ctr"


#include "dk3ma.h"
#include <stdio.h>
#include "dk3mem.h"
#include "dk3str.h"




#line 470 "dk3mastr.ctr"



/**	Size correction for alignment.
*/
#define	DK3MASTR_ALIGN(sz,al) \
((0 == (sz % al)) ? (sz) : (((sz / al) + 1) * al))



#ifndef DK3MASTR_HEX_PADDED_LEFT
/**	When converting to hexadecimal notation, use padding.
*/
#define	DK3MASTR_HEX_PADDED_LEFT	1
#endif



int
dk3ma_um_to_c8_string(char *rb, size_t sz, dk3_um_t va)
{
  char		 buf[DK3MASTR_ALIGN((8*DK3_SIZEOF_UM),16)];
  char		*ptr;
  dk3_um_t	 x;
  size_t	 szmax	=	sizeof(buf);
  size_t	 szused	=	0;
  size_t	 i;
  int		 back	=	1;
  char		 c;

  if ((NULL != rb) && (0 < sz)) {
    rb[0] = '\0';
    ptr = buf;
    if (2 <= szmax) {
      do {
        x = va % 10;
        va = va / 10;
        c = '\0';
        switch((int)x) {
          case 0: { c = '0'; } break;
          case 1: { c = '1'; } break;
          case 2: { c = '2'; } break;
          case 3: { c = '3'; } break;
          case 4: { c = '4'; } break;
          case 5: { c = '5'; } break;
          case 6: { c = '6'; } break;
          case 7: { c = '7'; } break;
          case 8: { c = '8'; } break;
          case 9: { c = '9'; } break;
        }
        if (szused < szmax) {
          *(ptr++) = c;
	  szused++;
        } else {
          back = 0;
        }
      } while((DK3_UM_0 != va) && (szused < szmax) && (1 == back));
      if (szused < szmax) {
        buf[szused] = '\0';
      } else {
        back = 0;
        buf[szmax - 1] = '\0';
      }
      if (1 == back) {
        if (szused < sz) {
          for (i = 0; i < szused; i++) {
	    rb[i] = buf[szused - i - 1];
	  }
	  rb[szused] = '\0';
        } else {
          back = 0;
        }
      }
    }
  }
  return back;
}



int
dk3ma_im_to_c8_string(char *rb, size_t sz, dk3_im_t va)
{
  dk3_um_t	 umva;
  int		 back	=	0;
  if ((NULL != rb) && (0 < sz)) {
    rb[0] = '\0';
    if (2 < sz) {
      if (DK3_IM_0 > va) {
        *(rb++) = '-';
	sz--;
	if (DK3_IM_MIN == va) {
	  umva = (dk3_um_t)DK3_IM_MAX;
	  umva++;
	} else {
	  umva = (dk3_um_t)(DK3_IM_0 - va);
	}
      } else {
        umva = (dk3_um_t)va;
      }
      back = dk3ma_um_to_c8_string(rb, sz, umva);
    }
  }
  return back;
}



int
dk3ma_um_to_c8_hex_string(char *rb, size_t sz, dk3_um_t va)
{
  char		 buf[DK3MASTR_ALIGN((8*DK3_SIZEOF_UM),16)];
  char		*ptr;
  dk3_um_t	 x;
  size_t	 szmax	=	sizeof(buf);
  size_t	 szused	=	0;
  size_t	 i;
  int		 back	=	1;
  char		 c;

  if ((NULL != rb) && (0 < sz)) {
    rb[0] = '\0';
    ptr = buf;
    if (2 <= szmax) {
      do {
        x = va % 16;
	va = va / 16;
	c = '\0';
	switch((int)x) {
          case  0: { c = '0'; } break;
          case  1: { c = '1'; } break;
          case  2: { c = '2'; } break;
          case  3: { c = '3'; } break;
          case  4: { c = '4'; } break;
          case  5: { c = '5'; } break;
          case  6: { c = '6'; } break;
          case  7: { c = '7'; } break;
          case  8: { c = '8'; } break;
          case  9: { c = '9'; } break;
          case 10: { c = 'A'; } break;
          case 11: { c = 'B'; } break;
          case 12: { c = 'C'; } break;
          case 13: { c = 'D'; } break;
          case 14: { c = 'E'; } break;
          case 15: { c = 'F'; } break;
	}
	if (szused < szmax) {
	  *(ptr++) = c;
	  szused++;
	} else {
	  back = 0;
	}
      } while((DK3_UM_0 != va) && (szused < szmax) && (1 == back));
      if (szused < szmax) {
        buf[szused] = '\0';
      } else {
        back = 0;
	buf[szmax - 1] = '\0';
      }
      if (1 == back) {
        if (szused < sz) {
/*
*/
#if DK3MASTR_HEX_PADDED_LEFT
	  if ((2 * DK3_SIZEOF_UM) < sz) {
	    for (i = 0; i < (2 * DK3_SIZEOF_UM); i++) {
	      rb[i] = '0';
	    }
	    rb[2 * DK3_SIZEOF_UM] = '\0';
	    for (i = 0; i < szused; i++) {
	      rb[(2 * DK3_SIZEOF_UM) - 1 - i] = buf[i];
	    }
	  } else {
#endif
	    for (i = 0; i < szused; i++) {
	      rb[i] = buf[szused - i - 1];
	    }
	    rb[szused] = '\0';
#if DK3MASTR_HEX_PADDED_LEFT
	  }
#endif
	} else {
	  back = 0;
	}
      }
    }
  }
  return back;
}



int
dk3ma_im_to_string(dkChar *rb, size_t sz, dk3_im_t va)
{
  dk3_um_t	 umva;
  int		 back	=	0;
  if ((NULL != rb) && (0 < sz)) {
    rb[0] = dkT('\0');
    if (2 < sz) {
      if (DK3_IM_0 > va) {
        *(rb++) = dkT('-');
	sz--;
	if (DK3_IM_MIN == va) {
	  umva = (dk3_um_t)DK3_IM_MAX;
	  umva++;
	} else {
	  umva = (dk3_um_t)(DK3_IM_0 - va);
	}
      } else {
        umva = (dk3_um_t)va;
      }
      back = dk3ma_um_to_string(rb, sz, umva);
    }
  }
  return back;
}



int
dk3ma_um_to_string(dkChar *rb, size_t sz, dk3_um_t va)
{
  char		 buf[DK3MASTR_ALIGN((8*DK3_SIZEOF_UM),16)];
  char		*ptr;
  dk3_um_t	 x;
  size_t	 szmax	=	sizeof(buf);
  size_t	 szused	=	0;
  size_t	 i;
  int		 back	=	1;
  char		 c;

  if ((NULL != rb) && (0 < sz)) {
    rb[0] = dkT('\0');
    ptr = buf;
    if (2 <= szmax) {
      do {
        x = va % 10;
        va = va / 10;
        c = '\0';
        switch((int)x) {
          case 0: { c = '0'; } break;
          case 1: { c = '1'; } break;
          case 2: { c = '2'; } break;
          case 3: { c = '3'; } break;
          case 4: { c = '4'; } break;
          case 5: { c = '5'; } break;
          case 6: { c = '6'; } break;
          case 7: { c = '7'; } break;
          case 8: { c = '8'; } break;
          case 9: { c = '9'; } break;
        }
        if (szused < szmax) {
          *(ptr++) = c;
	  szused++;
        } else {
          back = 0;
        }
      } while((DK3_UM_0 != va) && (szused < szmax) && (1 == back));
      if (szused < szmax) {
        buf[szused] = '\0';
      } else {
        back = 0;
        buf[szmax - 1] = '\0';
      }
      if (1 == back) {
        if (szused < sz) {
          for (i = 0; i < szused; i++) {
	    rb[i] = (dkChar)(buf[szused - i - 1]);
	  }
	  rb[szused] = dkT('\0');
        } else {
          back = 0;
        }
      }
    }
  }
  return back;
}



int
dk3ma_um_to_hex_string(dkChar *rb, size_t sz, dk3_um_t va, int leftpad)
{
  char		 buf[DK3MASTR_ALIGN((8*DK3_SIZEOF_UM),16)];
  char		*ptr;
  dk3_um_t	 x;
  size_t	 szmax	=	sizeof(buf);
  size_t	 szused	=	0;
  size_t	 i;
  int		 back	=	1;
  char		 c;

  if ((NULL != rb) && (0 < sz)) {
    rb[0] = dkT('\0');
    ptr = buf;
    if (2 <= szmax) {
      do {
        x = va % 16;
	va = va / 16;
	c = '\0';
	switch((int)x) {
          case  0: { c = '0'; } break;
          case  1: { c = '1'; } break;
          case  2: { c = '2'; } break;
          case  3: { c = '3'; } break;
          case  4: { c = '4'; } break;
          case  5: { c = '5'; } break;
          case  6: { c = '6'; } break;
          case  7: { c = '7'; } break;
          case  8: { c = '8'; } break;
          case  9: { c = '9'; } break;
          case 10: { c = 'A'; } break;
          case 11: { c = 'B'; } break;
          case 12: { c = 'C'; } break;
          case 13: { c = 'D'; } break;
          case 14: { c = 'E'; } break;
          case 15: { c = 'F'; } break;
	}
	if (szused < szmax) {
	  *(ptr++) = c;
	  szused++;
	} else {
	  back = 0;
	}
      } while((DK3_UM_0 != va) && (szused < szmax) && (1 == back));
      if (szused < szmax) {
        buf[szused] = '\0';
      } else {
        back = 0;
	buf[szmax - 1] = '\0';
      }
      if (1 == back) {
        if (szused < sz) {
	  if ((0 != leftpad) && ((2 * DK3_SIZEOF_UM) < sz)) {
	    for (i = 0; i < (2 * DK3_SIZEOF_UM); i++) {
	      rb[i] = dkT('0');
	    }
	    rb[2 * DK3_SIZEOF_UM] = dkT('\0');
	    for (i = 0; i < szused; i++) {
	      rb[(2 * DK3_SIZEOF_UM) - 1 - i] = (dkChar)(buf[i]);
	    }
	  } else {
	    for (i = 0; i < szused; i++) {
	      rb[i] = (dkChar)(buf[szused - i - 1]);
	    }
	    rb[szused] = dkT('\0');
	  }
	} else {
	  back = 0;
	}
      }
    }
  }
  return back;
}



/**	Constant numeric values.
*/
static dk3_um_t const dk3ma_um_c8_array[] = {
#if DK3_HAVE_LONG_LONG
  /*  0 */	(dk3_um_t)10ULL,
  /*  1 */	(dk3_um_t)1ULL,
  /*  2 */	(dk3_um_t)2ULL,
  /*  3 */	(dk3_um_t)3ULL,
  /*  4 */	(dk3_um_t)4ULL,
  /*  5 */	(dk3_um_t)5ULL,
  /*  6 */	(dk3_um_t)6ULL,
  /*  7 */	(dk3_um_t)7ULL,
  /*  8 */	(dk3_um_t)8ULL,
  /*  9 */	(dk3_um_t)9ULL
#else
  /*  0 */	(dk3_um_t)10UL,
  /*  1 */	(dk3_um_t)1UL,
  /*  2 */	(dk3_um_t)2UL,
  /*  3 */	(dk3_um_t)3UL,
  /*  4 */	(dk3_um_t)4UL,
  /*  5 */	(dk3_um_t)5UL,
  /*  6 */	(dk3_um_t)6UL,
  /*  7 */	(dk3_um_t)7UL,
  /*  8 */	(dk3_um_t)8UL,
  /*  9 */	(dk3_um_t)9UL
#endif
};



int
dk3ma_um_from_c8_string(dk3_um_t *rp, char const *src, int *ec)
{
  char const	*ptr	=	NULL;		/* Current char to process */
  dk3_um_t	 val	=	DK3_UM_0;	/* Value found */
  dk3_um_t	 op	=	DK3_UM_0;	/* Operand to add */
  int		 mec	=	0;		/* Math error code */
  int		 back	=	0;		/* Function result */
  int		 found	=	0;		/* Flag: Digits found */
  int		 cc	=	1;		/* Flag: Can continue */
  int		 action	=	0;		/* Action to take */
  

#line 872 "dk3mastr.ctr"
  if ((NULL != rp) && (NULL != src)) {
    ptr = src;
    while((' ' == *ptr) || ('\t' == *ptr)) { ptr++; }
    if ('\0' != *ptr) {
      while (0 != cc) {
        action = 0;
        switch(*(ptr++)) {
	  case '\0': {		/* End of string */
	    cc = 0;
	    if (0 != found) {
	      back = 1;
	    } else {
	      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
	    }
	  } break;
	  case '0': {
	    found = 1; action = 1; op = DK3_UM_0;
	  } break;
	  case '1': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[1];
	  } break;
	  case '2': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[2];
	  } break;
	  case '3': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[3];
	  } break;
	  case '4': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[4];
	  } break;
	  case '5': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[5];
	  } break;
	  case '6': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[6];
	  } break;
	  case '7': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[7];
	  } break;
	  case '8': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[8];
	  } break;
	  case '9': {
	    found = 1; action = 1; op = dk3ma_um_c8_array[9];
	  } break;
	  default: {		/* Non-digit */
	    cc = 0;
	    if (0 != found) {
	      back = 1;
	    }
	    if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
	  } break;
	}
	if (0 != cc) {
	  switch(action) {
	    case 1: {
	      val = dk3ma_um_add_ok(
	        dk3ma_um_mul_ok(val, dk3ma_um_c8_array[0], &mec), op, &mec
	      );			

#line 931 "dk3mastr.ctr"
	      if (0 != mec) {		

#line 932 "dk3mastr.ctr"
	        cc = 0;
	        val = DK3_UM_MAX;
	        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	      }
	    } break;
	  }
	}				

#line 939 "dk3mastr.ctr"
      }
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
    }
    *rp = val;
#if DK3_ON_WINDOWS
    

#line 946 "dk3mastr.ctr"
#else
#if DK3_HAVE_INTMAX_T
    

#line 949 "dk3mastr.ctr"
#else
#if DK3_HAVE_LONG_LONG
    

#line 952 "dk3mastr.ctr"
#else
    

#line 954 "dk3mastr.ctr"
#endif
#endif
#endif
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 960 "dk3mastr.ctr"
  return back;
}



int
dk3ma_im_from_c8_string(dk3_im_t *rp, char const *src, int *ec)
{
  char const	*ptr	=	NULL;		/* Start of text */
  dk3_um_t	 umv	=	DK3_UM_0;	/* Temporary value */
  dk3_im_t	 val	=	DK3_IM_0;	/* Conversion result */
  int		 back	=	0;		/* Function result */
  if ((NULL != rp) && (NULL != src)) {
    ptr = src;
    while((' ' == *ptr) || ('\t' == *ptr)) { ptr++; }
    if ('\0' != *ptr) {
      if ('-' == *ptr) {
        ptr++;
	if (dk3ma_um_from_c8_string(&umv, ptr, ec)) {
	  if ((dk3_um_t)DK3_IM_MAX >= umv) {
	    val = (dk3_im_t)umv;
	    val = DK3_IM_0 - val;
	    back = 1;
	  } else {
#if 0
	    if ((dk3_um_t)(DK3_IM_MAX + (dk3_im_t)1L) == umv)
#else
	    if (((dk3_um_t)DK3_IM_MAX + (dk3_um_t)1UL) == umv)
#endif
	    {
	      val = DK3_IM_MIN;
	      back = 1;
	    } else {
	      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	    }
	  }
	}
      } else {
        if (dk3ma_um_from_c8_string(&umv, ptr, ec)) {
	  if ((dk3_um_t)DK3_IM_MAX >= umv) {
	    val = (dk3_im_t)umv;
	    back = 1;
	  } else {
	    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	  }
	}
      }
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
    }
    *rp = val;
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}


int
dk3ma_um_from_string(dk3_um_t *rp, dkChar const *src, int *ec)
{
#if DK3_CHAR_SIZE > 1
  dkChar const	*ptr	=	NULL;		/* Current char to process */
  dk3_um_t	 val	=	DK3_UM_0;	/* Value found */
  dk3_um_t	 op	=	DK3_UM_0;	/* Operand to add */
  int		 mec	=	0;		/* Math error code */
  int		 back	=	0;		/* Function result */
  int		 found	=	0;		/* Flag: Digits found */
  int		 cc	=	1;		/* Flag: Can continue */
  int		 action	=	0;		/* Action to take */
  

#line 1031 "dk3mastr.ctr"
  if ((NULL != rp) && (NULL != src)) {
    ptr = src;
    while((dkT(' ') == *ptr) || (dkT('\t') == *ptr)) { ptr++; }
    if (dkT('\0') != *ptr) {
      while (0 != cc) {
        action = 0;
        switch(*(ptr++)) {
	  case dkT('\0'): {		/* End of string */
	    cc = 0;
	    if (0 != found) {
	      back = 1;
	    } else {
	      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
	    }
	  } break;
	  case dkT('0'): {
	    found = 1; action = 1; op = DK3_UM_0;
	  } break;
	  case dkT('1'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[1];
	  } break;
	  case dkT('2'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[2];
	  } break;
	  case dkT('3'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[3];
	  } break;
	  case dkT('4'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[4];
	  } break;
	  case dkT('5'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[5];
	  } break;
	  case dkT('6'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[6];
	  } break;
	  case dkT('7'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[7];
	  } break;
	  case dkT('8'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[8];
	  } break;
	  case dkT('9'): {
	    found = 1; action = 1; op = dk3ma_um_c8_array[9];
	  } break;
	  default: {		/* Non-digit */
	    cc = 0;
	    if (0 != found) {
	      back = 1;
	    }
	    if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
	  } break;
	}
	if (0 != cc) {
	  switch(action) {
	    case 1: {
	      val = dk3ma_um_add_ok(
	        dk3ma_um_mul_ok(val, dk3ma_um_c8_array[0], &mec), op, &mec
	      );			

#line 1090 "dk3mastr.ctr"
	      if (0 != mec) {		

#line 1091 "dk3mastr.ctr"
	        cc = 0;
	        val = DK3_UM_MAX;
	        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	      }
	    } break;
	  }
	}				

#line 1098 "dk3mastr.ctr"
      }
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
    }
    *rp = val;
#if DK3_ON_WINDOWS
    

#line 1105 "dk3mastr.ctr"
#else
#if DK3_HAVE_INTMAX_T
    

#line 1108 "dk3mastr.ctr"
#else
#if DK3_HAVE_LONG_LONG
    

#line 1111 "dk3mastr.ctr"
#else
    

#line 1113 "dk3mastr.ctr"
#endif
#endif
#endif
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1119 "dk3mastr.ctr"
  return back;
#else
  return (dk3ma_um_from_c8_string(rp, src, ec));
#endif
}



int
dk3ma_im_from_string(dk3_im_t *rp, dkChar const *src, int *ec)
{
#if DK3_CHAR_SIZE > 1
  dkChar const	*ptr	=	NULL;		/* Start of text */
  dk3_um_t	 umv	=	DK3_UM_0;	/* Temporary value */
  dk3_im_t	 val	=	DK3_IM_0;	/* Conversion result */
  int		 back	=	0;		/* Function result */
  if ((NULL != rp) && (NULL != src)) {
    ptr = src;
    while((dkT(' ') == *ptr) || (dkT('\t') == *ptr)) { ptr++; }
    if (dkT('\0') != *ptr) {
      if (dkT('-') == *ptr) {
        ptr++;
	if (dk3ma_um_from_string(&umv, ptr, ec)) {
	  if ((dk3_um_t)DK3_IM_MAX >= umv) {
	    val = (dk3_im_t)umv;
	    val = DK3_IM_0 - val;
	    back = 1;
	  } else {
	    if ((dk3_um_t)(DK3_IM_MAX + (dk3_im_t)1L) == umv) {
	      val = DK3_IM_MIN;
	      back = 1;
	    } else {
	      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	    }
	  }
	}
      } else {
        if (dk3ma_um_from_string(&umv, ptr, ec)) {
	  if ((dk3_um_t)DK3_IM_MAX >= umv) {
	    val = (dk3_im_t)umv;
	    back = 1;
	  } else {
	    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	  }
	}
      }
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
    }
    *rp = val;
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
#else
  return (dk3ma_im_from_c8_string(rp, src, ec));
#endif
}



int
dk3ma_s_from_string(short *rp, dkChar const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_S_MIN <= val) && ((dk3_im_t)DK3_S_MAX >= val)) {
        *rp = (short)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_us_from_string(unsigned short *rp, dkChar const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_US_MAX >= val) {
        *rp = (unsigned short)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_i_from_string(int *rp, dkChar const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_I_MIN <= val) && ((dk3_im_t)DK3_I_MAX >= val)) {
        *rp = (int)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_ui_from_string(unsigned *rp, dkChar const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_U_MAX >= val) {
        *rp = (unsigned)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_l_from_string(long *rp, dkChar const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_L_MIN <= val) && ((dk3_im_t)DK3_L_MAX >= val)) {
        *rp = (long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_ul_from_string(unsigned long *rp, dkChar const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_UL_MAX >= val) {
        *rp = (unsigned long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



#if DK3_HAVE_LONG_LONG

int
dk3ma_ll_from_string(long long *rp, dkChar const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_LL_MIN <= val) && ((dk3_im_t)DK3_LL_MAX >= val)) {
        *rp = (long long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_ull_from_string(unsigned long long *rp, dkChar const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_ULL_MAX >= val) {
        *rp = (unsigned long long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}

#endif



#if DK3_HAVE_INTMAX_T

int
dk3ma_intmax_t_from_string(intmax_t *rp, dkChar const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_string(&val, src, ec)) {
      *rp = (intmax_t)val;
      back = 1;
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_uintmax_t_from_string(uintmax_t *rp, dkChar const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_string(&val, src, ec)) {
      *rp = (uintmax_t)val;
      back = 1;
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



#endif



int
dk3ma_s_from_c8_string(short *rp, char const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_c8_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_S_MIN <= val) && ((dk3_im_t)DK3_S_MAX >= val)) {
	*rp = (short)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_us_from_c8_string(unsigned short *rp, char const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_c8_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_US_MAX >= val) {
        *rp = (unsigned short)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_i_from_c8_string(int *rp, char const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_c8_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_I_MIN <= val) && ((dk3_im_t)DK3_I_MAX >= val)) {
        *rp = (int)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_ui_from_c8_string(unsigned *rp, char const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_c8_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_U_MAX >= val) {
        *rp = (unsigned) val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_l_from_c8_string(long *rp, char const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_c8_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_L_MIN <= val) && ((dk3_im_t)DK3_L_MAX >= val)) {
        *rp = (long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_ul_from_c8_string(unsigned long *rp, char const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_c8_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_UL_MAX >= val) {
        *rp = (unsigned long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



#if DK3_HAVE_LONG_LONG

int
dk3ma_ll_from_c8_string(long long *rp, char const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_c8_string(&val, src, ec)) {
      if (((dk3_im_t)DK3_LL_MIN <= val) && ((dk3_im_t)DK3_LL_MAX >= val)) {
        *rp = (long long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_ull_from_c8_string(unsigned long long *rp, char const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_c8_string(&val, src, ec)) {
      if ((dk3_um_t)DK3_ULL_MAX >= val) {
        *rp = (unsigned long long)val;
	back = 1;
      } else {
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}

#endif



#if DK3_HAVE_INTMAX_T

int
dk3ma_intmax_t_from_c8_string(intmax_t *rp, char const *src, int *ec)
{
  dk3_im_t	val	=	DK3_IM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_im_from_c8_string(&val, src, ec)) {
      *rp = (intmax_t)val;
      back = 1;
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}



int
dk3ma_uintmax_t_from_c8_string(uintmax_t *rp, char const *src, int *ec)
{
  dk3_um_t	val	=	DK3_UM_0;
  int		back	=	0;
  if ((NULL != rp) && (NULL != src)) {
    if (dk3ma_um_from_c8_string(&val, src, ec)) {
      *rp = (uintmax_t)val;
      back = 1;
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  }
  return back;
}

#endif



int
dk3ma_sz_from_string(size_t *rp, dkChar const *src, int *ec)
{
  /* Private copy of string, can be modified. */
  dkChar	 buffer[DK3_MEM_ALIGN((8*sizeof(dk3_um_t)+1),16)];
  dkChar const	*ptr;			/* Start of original text */
  size_t	 lgt;			/* Length of text in buffer */
  dk3_um_t	 convres = (dk3_um_t)1;	/* Conversion result */
  dk3_um_t	 factor	=  (dk3_um_t)1;	/* Constant factor */
  int		 myec	=	0;	/* Private error code */
  int		 back	=	0;	/* Function result */
  int		 done	=	0;	/* Flag: No conversion necessary */
  

#line 1635 "dk3mastr.ctr"
  if ((NULL != rp) && (NULL != src)) {
    ptr = dk3str_start(src, NULL);
    if (NULL != ptr) {
      if (dk3str_len(ptr) < DK3_SIZEOF(buffer,dkChar)) {
        dk3str_cpy(buffer, ptr);
	dk3str_chomp(buffer, NULL);
	lgt = dk3str_len(buffer);
	if (0 < lgt) {
	  switch(buffer[lgt-1]) {
	    case dkT('k'): case dkT('K'): {
	      factor = (dk3_um_t)1024;
	      buffer[lgt-1] = dkT('\0');
	      if (1 == lgt) { done = 1; }
	    } break;
	    case dkT('m'): case dkT('M'): {
	      factor = dk3ma_um_mul_ok((dk3_um_t)1024, (dk3_um_t)1024, &myec);
	      buffer[lgt-1] = dkT('\0');
	      if (1 == lgt) { done = 1; }
	    } break;
	    case dkT('g'): case dkT('G'): {
	      factor = dk3ma_um_mul_ok(
	        dk3ma_um_mul_ok((dk3_um_t)1024, (dk3_um_t)1024, &myec),
		(dk3_um_t)1024, &myec
	      );
	      buffer[lgt-1] = dkT('\0');
	      if (1 == lgt) { done = 1; }
	    } break;
	  }
	  if (0 == myec) {
	    if (0 == done) {		

#line 1665 "dk3mastr.ctr"
	      if (0 != dk3ma_um_from_string(&convres, buffer, ec)) {
	        

#line 1667 "dk3mastr.ctr"
	        convres = dk3ma_um_mul_ok(convres, factor, &myec);
		if ((dk3_um_t)DK3_SIZE_T_MAX >= convres) {
		  *rp = (size_t)convres;
		  back = 1;
#if DK3_ON_WINDOWS
		  

#line 1673 "dk3mastr.ctr"
#else
		  

#line 1675 "dk3mastr.ctr"
#endif
		} else {		

#line 1677 "dk3mastr.ctr"
		  if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
		}
	      } else {			

#line 1680 "dk3mastr.ctr"
	      }
	    } else {			

#line 1682 "dk3mastr.ctr"
	      convres = dk3ma_um_mul_ok(convres, factor, &myec);
	      if ((dk3_um_t)DK3_SIZE_T_MAX >= convres) {
	        *rp = (size_t)convres;
	        back = 1;		

#line 1686 "dk3mastr.ctr"
#if DK3_ON_WINDOWS
		

#line 1688 "dk3mastr.ctr"
#else
		

#line 1690 "dk3mastr.ctr"
#endif
	      } else {			

#line 1692 "dk3mastr.ctr"
	        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	      }
	    }
	    if (1 == back) {
	      if (0 != myec) {		

#line 1697 "dk3mastr.ctr"
	        back = 0;
		if (NULL != ec) { *ec = myec; }
	      }
	    }
	  } else {			

#line 1702 "dk3mastr.ctr"
	    if (NULL != ec) { *ec = myec; }
	  }
	} else {			

#line 1705 "dk3mastr.ctr"
	  if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
	}
      } else {				

#line 1708 "dk3mastr.ctr"
        if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
      }
    } else {				

#line 1711 "dk3mastr.ctr"
      if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
    }
  } else {				

#line 1714 "dk3mastr.ctr"
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 1716 "dk3mastr.ctr"
  return back;
}


