/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mal.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mal.h Header file for the dk3mal module.
*/

#ifndef DK3MAL_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MAL_H_INCLUDED 1


#line 10 "dk3mal.ctr"

/**	@file	dk3mal.h	Mathematical operations on long, long long,
	intmax_t and dk3_im_t.
*/

#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

/**	Absolute value.
	@param	a	Original value.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Non-negative value on success,
	DK3_L_MAX and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
long
dk3ma_l_abs_ok(long a, int *ec);

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
long
dk3ma_l_add_ok(long a, long b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
long
dk3ma_l_sub_ok(long a, long b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
long
dk3ma_l_mul_ok(long a, long b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
long
dk3ma_l_div_ok(long a, long b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b on success,
	0L and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
long
dk3ma_l_gcd_ok(long a, long b, int *ec);



#if DK3_HAVE_LONG_LONG

/**	Absolute value.
	@param	a	Original value.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Non-negative value on success,
	DK3_L_MAX and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
long long
dk3ma_ll_abs_ok(long long a, int *ec);

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
long long
dk3ma_ll_add_ok(long long a, long long b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
long long
dk3ma_ll_sub_ok(long long a, long long b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
long long
dk3ma_ll_mul_ok(long long a, long long b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
long long
dk3ma_ll_div_ok(long long a, long long b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b on success,
	0L and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
long long
dk3ma_ll_gcd_ok(long long a, long long b, int *ec);

#endif
/* if DK3_HAVE_LONG_LONG */



#if DK3_HAVE_INTMAX_T

/**	Absolute value.
	@param	a	Original value.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Non-negative value on success,
	DK3_L_MAX and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
intmax_t
dk3ma_intmax_t_abs_ok(intmax_t a, int *ec);

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
intmax_t
dk3ma_intmax_t_add_ok(intmax_t a, intmax_t b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
intmax_t
dk3ma_intmax_t_sub_ok(intmax_t a, intmax_t b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
intmax_t
dk3ma_intmax_t_mul_ok(intmax_t a, intmax_t b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
intmax_t
dk3ma_intmax_t_div_ok(intmax_t a, intmax_t b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b on success,
	0L and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
intmax_t
dk3ma_intmax_t_gcd_ok(intmax_t a, intmax_t b, int *ec);

#endif

/**	Absolute value.
	@param	a	Original value.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Non-negative value on success,
	DK3_L_MAX and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
dk3_im_t
dk3ma_im_abs_ok(dk3_im_t a, int *ec);

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
dk3_im_t
dk3ma_im_add_ok(dk3_im_t a, dk3_im_t b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
dk3_im_t
dk3ma_im_sub_ok(dk3_im_t a, dk3_im_t b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
dk3_im_t
dk3ma_im_mul_ok(dk3_im_t a, dk3_im_t b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
dk3_im_t
dk3ma_im_div_ok(dk3_im_t a, dk3_im_t b, int *ec);

/**	Greatest common divisor.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Greatest common divisor of a and b on success,
	0L and ec = DK3_ERROR_MATH_OVERFLOW on error.
*/
dk3_im_t
dk3ma_im_gcd_ok(dk3_im_t a, dk3_im_t b, int *ec);

#ifdef __cplusplus
}
#endif




#endif
