/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mai.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mai.c The dk3mai module.
*/


#line 108 "dk3mai.ctr"



#include "dk3ma.h"





#line 116 "dk3mai.ctr"



int
dk3ma_i_abs_ok(int a, int *ec)
{
  if (NULL != ec) { if (DK3_I_MIN == a) { *ec = DK3_ERROR_MATH_OVERFLOW; } }
  return ((0 <= a) ? a : (0 - a));
}



int
dk3ma_i_add_ok(int a, int b, int *ec)
{
  if (NULL != ec) {
    if ((0 < a) && (0 < b)) {
      if((DK3_I_MAX - a) < b) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    } else {
      if ((0 > a) && (0 > b)) {
        if (DK3_I_MIN == a) {
	  *ec = DK3_ERROR_MATH_OVERFLOW;
	} else {
	  if ((DK3_I_MIN - a) > b) {
	    *ec = DK3_ERROR_MATH_OVERFLOW;
	  }
	}
      }
    }
  }
  return (a + b);
}



int
dk3ma_i_sub_ok(int a, int b, int *ec)
{
  if (NULL != ec) {
    if ((0 < a) && (0 > b)) {
      if((DK3_I_MAX + b) < a) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    } else {
      if ((0 > a) && (0 < b)) {
        if((DK3_I_MIN + b) > a) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    }
  }
  return (a - b);
}




int
dk3ma_i_mul_ok(int a, int b, int *ec)
{
  if (NULL != ec) {
    if ((0 != a) && (0 != b)) {
      if ((DK3_I_MIN == a) && (1 != b)) {
        *ec = DK3_ERROR_MATH_OVERFLOW;
	goto checksfinished;
      }
      if ((DK3_I_MIN == b) && (1 != a)) {
        *ec = DK3_ERROR_MATH_OVERFLOW;
	goto checksfinished;
      }
      if ((DK3_I_MAX / dk3ma_i_abs_ok(a, ec)) < dk3ma_i_abs_ok(b, ec)) {
        *ec = DK3_ERROR_MATH_OVERFLOW;
	/* goto checksfinished; -- when adding further tests -- */
      }
    }
  }
  checksfinished:
  return (a * b);
}



int
dk3ma_i_div_ok(int a, int b, int *ec)
{
  int		back	= 0;
  if (0 != b) {
    if ((DK3_I_MIN == a) && (-1 == b)) {
      back = DK3_I_MAX;
      *ec = DK3_ERROR_MATH_OVERFLOW;
    } else {
      back = a / b;
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_DIVZERO; }
    if (0 <= a) { back = DK3_I_MAX; }
    else        { back = DK3_I_MIN; }
  }
  return back;
}



int
dk3ma_i_gcd_ok(int a, int b, int *ec)
{
  int	h;
  if (0 > a) {
    if (DK3_I_MIN == a) {
      a = 0;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      goto finished;
    } else {
      a = 0 - a;
    }
  }
  if (0 > b) {
    if (DK3_I_MIN == b) {
      a = 0;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      goto finished;
    } else {
      b = 0 - b;
    }
  }
  while (0 < b) {
    h = a % b;
    a = b;
    b = h;
  }
  if (0 == a) { a = 1; }
  finished:
  return a;
}

