/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mafpe.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mafpe.c The dk3mafpe module.
*/


#line 260 "dk3mafpe.ctr"

#include "dk3mafpe.h"





#line 266 "dk3mafpe.ctr"



#if TRACE_DEBUG

static
void
dk3mafpe_debug(dk3_ma_fpe_t fpes)
{
  

#line 276 "dk3mafpe.ctr"
  if (NULL != dktrace_file()) {
    if (0 != (fpes & DK3MAFPE_DIVBYZERO)) {
      fputs("DIVBYZERO\n", dktrace_file());
    }
    if (0 != (fpes & DK3MAFPE_INEXACT)) {
      fputs("INEXACT\n", dktrace_file());
    }
    if (0 != (fpes & DK3MAFPE_OVERFLOW)) {
      fputs("OVERFLOW\n", dktrace_file());
    }
    if (0 != (fpes & DK3MAFPE_UNDERFLOW)) {
      fputs("UNDERFLOW\n", dktrace_file());
    }
    if (0 != (fpes & DK3MAFPE_INVALID)) {
      fputs("INVALID\n", dktrace_file());
    }
  }
  

#line 294 "dk3mafpe.ctr"
}

#endif

dk3_ma_fpe_t
dk3mafpe_get(void)
{
#if DK3_ON_WINDOWS
#if DK3_HAVE__CLEARFP
#if TRACE_DEBUG
  dk3_ma_fpe_t	back;
  back = _statusfp();
  dk3mafpe_debug(back);
  return back;
#else
  return (_statusfp());
#endif
#else
  return 0;
#endif
#else
#if DK3_HAVE_FETESTEXCEPT
#if TRACE_DEBUG
  dk3_ma_fpe_t	back;
  back = fetestexcept(FE_ALL_EXCEPT);
  dk3mafpe_debug(back);
  return back;
#else
  return (fetestexcept(FE_ALL_EXCEPT));
#endif
#else
  return 0;
#endif
#endif
}



void
dk3mafpe_clear(void)
{
#if DK3_ON_WINDOWS
#if DK3_HAVE__CLEARFP
  (void)_clearfp();
#else

#endif
#else
#if DK3_HAVE_FETESTEXCEPT
  feclearexcept(FE_ALL_EXCEPT);
#else

#endif
#endif
}



dk3_ma_fpe_t
dk3mafpe_get_and_clear(void)
{
#if DK3_ON_WINDOWS
#if DK3_HAVE__CLEARFP
#if TRACE_DEBUG
  dk3_ma_fpe_t	back;
  back = _clearfp();
  dk3mafpe_debug(back);
  return back;
#else
  return (_clearfp());
#endif
#else
  return 0;
#endif
#else
#if DK3_HAVE_FETESTEXCEPT
  dk3_ma_fpe_t	back;
  back = fetestexcept(FE_ALL_EXCEPT);
  feclearexcept(FE_ALL_EXCEPT);
#if TRACE_DEBUG
  dk3mafpe_debug(back);
#endif
  return back;
#else
  return 0;
#endif
#endif
}



int
dk3mafpe_get_handling_type(void)
{
#if DK3_ON_WINDOWS
#if DK3_HAVE__CLEARFP
  return DK3_MA_FPE_HANDLING_CLEARFP;
#else
  return DK3_MA_FPE_HANDLING_NONE;
#endif
#else
#if DK3_HAVE_FETESTEXCEPT
  return DK3_MA_FPE_HANDLING_FETESTEXCEPT;
#else
  return DK3_MA_FPE_HANDLING_NONE;
#endif
#endif
}



int
dk3mafpe_isfinite(double x)
{
#if DK3_ON_WINDOWS
  int back = 0;
  if (_finite(x)) {
    back = 1;
  }
  return back;
#else
#if DK3_HAVE_ISFINITE
  int back = 0;
  if (isfinite(x)) {
    back = 1;
  }
  return back;
#else
#error "No function or macro isfinite(x) available!"
  return 1;
#endif
#endif
}




int
dk3mafpe_isnormal(double x)
{
#if DK3_ON_WINDOWS
  int	back	=	0;
  if (_finite(x)) {
    back = 1;
    switch (_fpclass(x)) {
      case _FPCLASS_ND: case _FPCLASS_PD: {
        back = 0;
      } break;
    }
  }
  return back;
#else
#if DK3_HAVE_ISNORMAL
  int	back = 0;
  if (isnormal(x)) {
    back = 1;
  }
  return back;
#else
#error "No function or macro isnormal(x) available!"
  return 1;
#endif
#endif
}

