/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madso.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madso.c The dk3madso module.
*/


#line 65 "dk3madso.ctr"



#include "dk3ma.h"
#if DK3_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK3_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK3_HAVE_STRING_H
#include <string.h>
#endif
#if DK3_HAVE_ERRNO_H
#include <errno.h>
#endif



#line 83 "dk3madso.ctr"



int
dk3ma_d_to_c8_string(char *rb, size_t sz, double va)
{
  int		back	= 0;
#if DK3_HAVE_SNPRINTF || DK3_HAVE__SNPRINTF || DK3_ON_WINDOWS
  int		res;
  if ((NULL != rb) && (0 < sz)) {
#if DK3_HAVE_SNPRINTF
    res = snprintf(rb, sz, "%lg", va);
#else
    res = _snprintf(rb, sz, "%lg", va);
#endif
    if (0 < res) {			/* Anything written? */
      if ((size_t)res < sz) {		/* Buffer large enough? */
        rb[res] = '\0';
	rb[sz - 1] = '\0';
	back = 1;
      } else {				/* Buffer too small! */
        rb[sz - 1] = '\0';
      }
    } else {				/* Nothing written! */
      rb[0] = '\0';
    }
  }
#else
  char		buf[128];
  if ((NULL != rb) && (0 < sz)) {
    sprintf(buf, "%lg", va);
    if (dk3str_c8_len(buf) < sz) {
      dk3str_c8_cpy(rb, buf);
      back = 1;
    } else {
      rb[0] = '\0';
    }
  }
#endif
  return back;
}



int
dk3ma_d_to_string(dkChar *rb, size_t sz, double va)
{
#if DK3_CHAR_SIZE > 1
  char		 buf[128];
  char		*cptr;
  dkChar	*dptr;
  int 		 back	= 0;
  if ((NULL != rb) && (0 < sz)) {
    if (dk3ma_d_to_c8_string(buf, sizeof(buf), va)) {
      if (dk3str_c8_len(buf) < sz) {
        back = 1;
	dptr = rb; cptr = buf;
	while(*cptr) { *(dptr++) = (dkChar)(*(cptr++)); }
	*dptr = dkT('\0');
      } else {
        rb[0] = dkT('\0');
      }
    } else {
      rb[0] = dkT('\0');
    }
  }
  return back;
#else
  return (dk3ma_d_to_c8_string(rb, sz, va));
#endif
}


