/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madsi.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madsi.c The dk3madsi module.
*/


#line 71 "dk3madsi.ctr"



#include "dk3ma.h"
#if DK3_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK3_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK3_HAVE_STRING_H
#include <string.h>
#endif
#if DK3_HAVE_ERRNO_H
#include <errno.h>
#endif



#line 89 "dk3madsi.ctr"



int
dk3ma_d_from_c8_string(double *rp, char const *src, int *ec)
{
#if DK3_HAVE_STRTOD
  char		*endptr = NULL;
  double	 val;
  int		 back	= 0;
  

#line 100 "dk3madsi.ctr"
  if ((NULL != rp) && (NULL != src)) {
    errno = 0;
    val = strtod(src, &endptr);
    if (endptr) {
      if ('\0' == *endptr) {
        back = 1;
      } else {
        if (endptr != src) {
	  back = 1;
	}
	if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
      }
    } else {
      back = 1;
    }
    if (0 != back) {
      if (ERANGE == errno) {
        if ((HUGE_VAL == val) || (-HUGE_VAL == val) || (0.0 == val)) {
	  back = 0;
	  if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	}
      }
    }
    *rp = val;
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 127 "dk3madsi.ctr"
  return back;
#else
  double	val;
  int		back	=	0;
  

#line 132 "dk3madsi.ctr"
  if ((NULL != rp) && (NULL != src)) {
    if (1 == sscanf(src, "%lf", &val)) {
      *rp = val;
      back = 1;
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 142 "dk3madsi.ctr"
  return back;
#endif
}



int
dk3ma_d_from_string(double *rp, dkChar const *src, int *ec)
{
#if DK3_CHAR_SIZE > 1
#if DK3_HAVE_WCSTOD
  dkChar	*endptr = NULL;
  double	 val;
  int		 back = 0;
  

#line 157 "dk3madsi.ctr"
  if ((NULL != rp) && (NULL != src)) {
    errno = 0;
    val = strtod(src, &endptr);
    if (endptr) {
      if ('\0' == *endptr) {
        back = 1;
      } else {
        if (endptr != src) {
	  back = 1;
	}
	if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
      }
    } else {
      back = 1;
    }
    if (0 != back) {
      if (ERANGE == errno) {
        if ((HUGE_VAL == val) || (-HUGE_VAL == val) || (0.0 == val)) {
	  back = 0;
	  if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	}
      }
    }
    *rp = val;
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 184 "dk3madsi.ctr"
  return back;
#else
  double	val = 0.0;
  int		back	=	0;
  

#line 189 "dk3madsi.ctr"
  if ((NULL != rp) && (NULL != src)) {
    if (1 == swscanf(src, dkT("%lf"), &val)) {
      *rp = val;
      back = 1;
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_SYNTAX; }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_INVALID_ARGS; }
  } 

#line 199 "dk3madsi.ctr"
  return back;
#endif
#else
  return (dk3ma_d_from_c8_string(rp, src, ec));
#endif
}


