/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madlc.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madlc.h Header file for the dk3madlc module.
*/

#ifndef DK3MADLC_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MADLC_H_INCLUDED 1


#line 10 "dk3madlc.ctr"

/**	@file	dk3madlc.h	Conversion from double to long,
	unsigned long, long long, unsigned long long, intmax_t, uintmax_t,
	dk3_im_t and dk3_um_t.
*/

#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**	Convert double number to size.
	@param	v	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OUT_OF_RANGE for negative v values,
	DK3_ERROR_MATH_OVERFLOW for values too large.
	@return	Conversion result.
*/
size_t
dk3ma_d_to_sz_ok(double v, int *ec);

/**	Convert double value to long.
	@param	x	Double value.
	@param	ec	Pointer to error code variable.
	Set to DK3_ERROR_MATH_OVERFLOW if the absolute value is too large.
	@return	Conversion result.
*/
long
dk3ma_d_to_l_ok(double x, int *ec);

/**	Convert double value to unsigned long.
	@param	x	Double value.
	@param	ec	Pointer to error code variable.
	Set to DK3_ERROR_MATH_OUT_OF_RANGE for negative v values,
	DK3_ERROR_MATH_OVERFLOW for values too large.
	@return	Conversion result.
*/
unsigned long
dk3ma_d_to_ul_ok(double x, int *ec);

#if DK3_HAVE_LONG_LONG

/**	Convert double to long long.
	@param	x	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OVERFLOW if the absolute value is too large.
	@return	Conversion result.
*/
long long
dk3ma_d_to_ll_ok(double x, int *ec);

/**	Convert double to unsigned long long.
	@param	x	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OUT_OF_RANGE for negative v values,
	DK3_ERROR_MATH_OVERFLOW for values too large.
	@return	Conversion result.
*/
unsigned long long
dk3ma_d_to_ull_ok(double x, int *ec);

#endif


#if DK3_HAVE_INTMAX_T

/**	Convert double to intmax_t.
	@param	x	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OVERFLOW if the absolute value is too large.
	@return	Conversion result.
*/
intmax_t
dk3ma_d_to_intmax_t_ok(double x, int *ec);

/**	Convert double to uintmax_t.
	@param	x	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OUT_OF_RANGE for negative v values,
	DK3_ERROR_MATH_OVERFLOW for values too large.
	@return	Conversion result.
*/
uintmax_t
dk3ma_d_to_uintmax_t_ok(double x, int *ec);

#endif

/**	Convert double precision floating point number to dk3_im_t.
	@param	x	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OVERFLOW if the absolute value is too large.
	@return	Conversion result.
*/
dk3_im_t
dk3ma_d_to_im_ok(double x, int *ec);

/**	Convert double precision floating point number to dk3_um_t.
	@param	x	Value to convert.
	@param	ec	Pointer to error code variable, may be NULL.
	Set to DK3_ERROR_MATH_OUT_OF_RANGE for negative v values,
	DK3_ERROR_MATH_OVERFLOW for values too large.
	@return	Conversion result.
*/
dk3_um_t
dk3ma_d_to_um_ok(double x, int *ec);

#ifdef __cplusplus
}
#endif


#endif
