/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madlc.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madlc.c The dk3madlc module.
*/


#line 142 "dk3madlc.ctr"



#include "dk3ma.h"





#line 150 "dk3madlc.ctr"



/* formerly DK3_HAVE_COMPILER_CONVERSIONS */
#if 1



size_t
dk3ma_d_to_sz_ok(double v, int *ec)
{
  size_t	back	= 0;
  

#line 163 "dk3madlc.ctr"
  if (0.0 <= v) {
    if ((double)DK3_SIZE_T_MAX >= v) {	

#line 165 "dk3madlc.ctr"
      back = (size_t)v;
    } else {
      if (NULL != ec) {			

#line 168 "dk3madlc.ctr"
        *ec = DK3_ERROR_MATH_OVERFLOW;
      }
    }
  } else {
    if (NULL != ec) {			

#line 173 "dk3madlc.ctr"
      *ec = DK3_ERROR_MATH_OUT_OF_RANGE;
    }
  } 

#line 176 "dk3madlc.ctr"
  return back;
}


 
long
dk3ma_d_to_l_ok(double x, int *ec)
{
  long		back	= 0L;
  

#line 186 "dk3madlc.ctr"
  if ((double)DK3_L_MIN <= x) {
    if ((double)DK3_L_MAX >= x) {
      back = (long)x;
    } else {
      back = DK3_L_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  } else {
    back = DK3_L_MIN;
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
  } 

#line 197 "dk3madlc.ctr"
  return back;
}



unsigned long
dk3ma_d_to_ul_ok(double x, int *ec)
{
  unsigned long	back	= 0UL;
  

#line 207 "dk3madlc.ctr"
  if (0.0 <= x) {
    if ((double)DK3_UL_MAX >= x) {
      back = (unsigned long)x;
    } else {
      back = DK3_UL_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
    }
  } else {
    back = 0UL;
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  } 

#line 218 "dk3madlc.ctr"
  return back;
}



#if DK3_HAVE_LONG_LONG

long long
dk3ma_d_to_ll_ok(double x, int *ec)
{
  long long	back	= 0LL;
  

#line 230 "dk3madlc.ctr"
  if ((double)DK3_LL_MIN <= x) {
    if ((double)DK3_LL_MAX >= x) {
      back = (long long)x;
    } else {
      back = DK3_LL_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  } else {
    back = DK3_LL_MIN;
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
  } 

#line 241 "dk3madlc.ctr"
  return back;
}



unsigned long long
dk3ma_d_to_ull_ok(double x, int *ec)
{
  unsigned long long	back	= 0ULL;
  

#line 251 "dk3madlc.ctr"
  if (0.0 <= x) {
    if ((double)DK3_ULL_MAX >= x) {
      back = (unsigned long long)x;
    } else {
      back = DK3_ULL_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  } 

#line 261 "dk3madlc.ctr"
  return back;
}

#endif


#if DK3_HAVE_INTMAX_T

intmax_t
dk3ma_d_to_intmax_t_ok(double x, int *ec)
{
  intmax_t	back	= DK3_INTMAX_T_0;
  

#line 274 "dk3madlc.ctr"
  if ((double)DK3_INTMAX_T_MIN <= x) {
    if ((double)DK3_INTMAX_T_MAX >= x) {
      back = (intmax_t)x;
    } else {
      back = DK3_INTMAX_T_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  } else {
    back = DK3_INTMAX_T_MIN;
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
  } 

#line 285 "dk3madlc.ctr"
  return back;
}



uintmax_t
dk3ma_d_to_uintmax_t_ok(double x, int *ec)
{
  uintmax_t	back	=	DK3_UINTMAX_T_0;
  

#line 295 "dk3madlc.ctr"
  if (0.0 <= x) {
    if ((double)DK3_UINTMAX_T_MAX >= x) {
      back = (uintmax_t)x;
    } else {
      back = DK3_UINTMAX_T_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  } 

#line 305 "dk3madlc.ctr"
  return back;
}

#endif



dk3_im_t
dk3ma_d_to_im_ok(double x, int *ec)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_d_to_intmax_t_ok(x, ec));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_d_to_ll_ok(x, ec));
#else
  return (dk3ma_d_to_l_ok(x, ec));
#endif
#endif
}



dk3_um_t
dk3ma_d_to_um_ok(double x, int *ec)
{
#if DK3_HAVE_INTMAX_T
  return (dk3ma_d_to_uintmax_t_ok(x, ec));
#else
#if DK3_HAVE_LONG_LONG
  return (dk3ma_d_to_ull_ok(x, ec));
#else
  return (dk3ma_d_to_ul_ok(x, ec));
#endif
#endif
}



#else
/* if 1, formerly if DK3_HAVE_COMPILER_CONVERSIONS */


/*	If you see the error message below during build process, you have
	disabled compiler conversions when running the configure script.
	During the last 10 year I did not see any compiler doing
	type casts from double to integers wrong, so the default is to
	enable compiler conversions.
	If you are really sure your compiler is doing type casts from
	double to integer types wrong, remove the error compiler directive
	below.
	Note: The code for manual conversion from double to integers
	is not well-tested as on all my systems the compilers type casts
	do fine. Make sure you know what you are doing.
*/
#error	"Compiler conversions turned off! See comment section above!"



#if DK3_HAVE_INTMAX_T
/* + uintmax_t */
#if DK3_SIZEOF_INTMAX_T > 2
#if DK3_SIZEOF_INTMAX_T > 4
#if DK3_SIZEOF_INTMAX_T > 8
#error "Can not handle such a large uintmax_t!"
#else
/*  8 */
#if DK3_HAVE_LONG_LONG
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(9223372036854775808ULL)
#else
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(9223372036854775808UL)
#endif
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(9223372036854775808.0)
#endif
#else
/*  4 */
#if DK3_HAVE_LONG_LONG
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(2147483648ULL)
#else
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(2147483648UL)
#endif
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(2147483648.0)
#endif
#else
/*  2 */
#if DK3_HAVE_LONG_LONG
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(32768ULL)
#else
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(32768UL)
#endif
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(32768.0)
#endif
/* - uintmax_t */
#else
#if DK3_HAVE_LONG_LONG
/* + unsigned long long */
#if DK3_SIZEOF_LONG_LONG > 2
#if DK3_SIZEOF_LONG_LONG > 4
#if DK3_SIZEOF_LONG_LONG > 8
#error "Can not handle such a large unsigned long long!"
#else
/*  8 */
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(9223372036854775808ULL)
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(9223372036854775808.0)
#endif
#else
/*  4 */
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(2147483648ULL)
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(2147483648.0)
#endif
#else
/*  2*/
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(32768ULL)
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(32768.0)
#endif
/* - unsigned long long */
#else
/* + unsigned long */
#if DK3_SIZEOF_LONG > 2
#if DK3_SIZEOF_LONG > 4
#if DK3_SIZEOF_LONG > 8
#error "Can not handle such a large unsigned long!"
#else
/*  8 */
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(9223372036854775808UL)
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(9223372036854775808.0)
#endif
#else
/*  4 */
#define	DK3_UM_FIRST_BIT	(2147483648UL)
#define	DK3_UM_FIRST_DOUBLE	(2147483648.0)
#endif
#else
/*  2 */
/**	First bit of a dk3_um_t.
*/
#define	DK3_UM_FIRST_BIT	(32768UL)
/**	First bit of a dk3_um_t written as double.
*/
#define	DK3_UM_FIRST_DOUBLE	(32768.0)
#endif
/* - unsigned long */
#endif
#endif



/**	Constant value 2 as dk3_um_t.
*/
static dk3_um_t const dk3ma_um2 =
#if DK3_HAVE_LONG_LONG
  (dk3_um_t)2ULL
#else
  (dk3_um_t)2UL
#endif
;


dk3_um_t
dk3ma_d_to_um_ok(double x, int *ec)
{
  dk3_um_t		back	=	DK3_UM_0;
  dk3_um_t		testu;
  double		testd;
  

#line 504 "dk3madlc.ctr"
  if (0.0 <= x) {
#if DK3_HAVE_LONG_DOUBLE
    if ((long double)DK3_UM_MAX >= (long double)x)
#else
    if ((double)DK3_UM_MAX >= x)
#endif
    {
      testd = DK3_UM_FIRST_DOUBLE;
      testu = DK3_UM_FIRST_BIT;
      for (i = 0; i < (8 * DK3_SIZEOF_UM); i++) {
        if (x >= testd) {
	  x = x - testd;
	  back = back + testu;
	}
        testd = testd / 2.0;
	testu = testu / dk3ma_um2;
      }
    }
    else
    {
      back = DK3_UM_MAX
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  }
  

#line 531 "dk3madlc.ctr"
  return back;
}



dk3_im_t
dk3ma_d_to_im_ok(double x, int *ec)
{
  dk3_im_t	back	= DK3_IM_0;
  dk3_um_t	tmp;
  int		mec	= 0;

  if (x >= 0.0) {
    tmp = dk3ma_d_to_um_ok(x, &mec);
    if (0 == mec) {
      if ((dk3_um_t)DK3_IM_MAX >= tmp) {
        back = (dk3_im_t)tmp;
      } else {
        back = DK3_IM_MAX;
        if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    } else {
      if (NULL != ec) { *ec = mec; }
    }
  } else {
    if ((double)DK3_IM_MIN > x) {
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      back = DK3_IM_MIN;
    } else {
      if ((double)(-DK3_IM_MAX) > x) {
        back = DK3_IM_MIN;
      } else {
        tmp = dk3ma_d_to_um_ok((0.0 - x), &mec);
	if (0 == mec) {
	  if ((dk3_um_t)DK3_IM_MAX >= tmp) {
	    back = DK3_IM_0 - (dk3_im_t)tmp;
	  } else {
	    back = DK3_IM_MIN;
	    if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
	  }
	} else {
	  if (NULL != ec) { *ec = mec; }
	}
      }
    }
  }
}



#if DK3_HAVE_INTMAX_T

uintmax_t
dk3ma_d_to_uintmax_t_ok(double x, int *ec)
{
  return (dk3ma_d_to_um_ok(x, ec));
}

intmax_t
dk3ma_d_to_intmax_t_ok(double x, int *ec)
{
  return (dk3ma_d_to_im_ok(x, ec));
}

#endif



#if DK3_HAVE_LONG_LONG

unsigned long long
dk3ma_d_to_ull_ok(double x, int *ec)
{
#if (!(DK3_HAVE_INTMAX_T))
  return (dk3ma_d_to_um_ok(x, ec));
#else
  dk3_um_t		tmp;
  unsigned long long	back	=	0ULL;
  int			mec	=	0;
  if (0.0 <= x) {
    tmp = dk3ma_d_to_um_ok(x, &mec);
    if (0 == mec) {
#if DK3_SIZEOF_LONG_LONG >= DK3_SIZEOF_UM
      back = (unsigned long long)tmp;
#else
      if ((dk3_um_t)DK3_ULL_MAX >= tmp) {
        back = (unsigned long long)tmp;
      } else {
        back = DK3_ULL_MAX;
	if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
#endif
    } else {
      if (NULL != ec) { *ec = mec; }
    }
  } else {
    if (NULL != ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  }
  return back;
#endif
}



long long
dk3ma_d_to_ll_ok(double x, int *ec)
{
#if (!(DK3_HAVE_INTMAX_T))
  return (dk3ma_d_to_im_ok(x, ec));
#else
  dk3_im_t	tmp;
  long long	back	=	0LL;
  int		mec	=	0;

  tmp = dk3ma_d_to_im_ok(x, &mec);
  if (0 == mec) {
#if DK3_SIZEOF_LONG_LONG >= DK3_SIZEOF_UM
    back = (long long)tmp;
#else
    if ((dk3_im_t)DK3_LL_MIN <= tmp) {
      if ((dk3_im_t)DK3_LL_MAX >= tmp) {
        back = (long long)tmp;
      } else {
        back = DK3_LL_MAX;
	if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    } else {
      back = DK3_LL_MIN;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
#endif
  } else {
    if (NULL != ec) { *ec = mec; }
  }
#endif
}

#endif



unsigned long
dk3ma_d_to_ul_ok(double x, int *ec)
{
#if (!((DK3_HAVE_INTMAX_T) || (DK3_HAVE_LONG_LONG)))
  return (dk3ma_d_to_um_ok(x, ec));
#else
  dk3_um_t		tmp;
  unsigned long		back	=	0UL;
  int			mec	=	0;

  tmp = dk3ma_d_to_um_ok(x, &mec);
  if (0 == mec) {
#if DK3_SIZEOF_LONG >= DK3_SIZEOF_UM
    back = (unsigned long)tmp;
#else
    if ((dk3_um_t)DK3_UL_MAX >= tmp) {
      back = (unsigned long)tmp;
    } else {
      back = DK3_UL_MAX;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
#endif
  } else {
    if (NULL != ec) { *ec = mec; }
  }
  return back;
#endif
}



long
dk3ma_d_to_l_ok(double x, int *ec)
{
#if (!((DK3_HAVE_INTMAX_T) || (DK3_HAVE_LONG_LONG)))
  return (dk3ma_d_to_im_ok(x, ec));
#else
  dk3_im_t	tmp;
  long		back	=	0L;
  int		mec	=	0;
  tmp = dk3ma_d_to_im_ok(x, &mec);
  if (0 == mec) {
#if DK3_SIZEOF_LONG >= DK3_SIZEOF_UM
    back = (long)tmp;
#else
    if ((dk3_im_t)DK3_L_MIN <= tmp) {
      if ((dk3_im_t)DK3_L_MAX >= tmp) {
        back = (dk3_im_t)tmp;
      } else {
        back = DK3_L_MAX;
	if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
      }
    } else {
      back = DK3_L_MIN;
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
#endif
  } else {
    if (NULL != ec) { *ec = mec; }
  }
  return back;
#endif
}



size_t
dk3ma_d_to_sz_ok(double v, int *ec)
{
  dk3_um_t	tmp;
  size_t	back	=	0;
  int		mec	=	0;
  
  tmp = dk3ma_d_to_um_ok(v, &mec);
  if (0 == mec) {
#if DK3_SIZEOF_SIZE_T >= DK3_SIZEOF_UM
    back = (size_t)tmp;
#else
    if ((dk3_um_t)DK3_SIZE_T_MAX >= tmp) {
      back = (size_t)tmp;
    } else {
      if (NULL != ec) { *ec = DK3_ERROR_MATH_OVERFLOW; }
    }
#endif
  } else {
    if (NULL != ec) { *ec = mec; }
  }
  return back;
}



#endif
/* if 1, formerly if DK3_HAVE_COMPILER_CONVERSIONS */


