/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madic.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madic.h Header file for the dk3madic module.
*/

#ifndef DK3MADIC_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MADIC_H_INCLUDED 1


#line 10 "dk3madic.ctr"

/**	@file	dk3madic.h	Conversion from double to int/unsigned.
*/

#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**	Convert double value to int.
	@param	x	Double value to convert.
	@param	ec	Pointer to error code variable.
	Set to DK3_ERROR_MATH_OVERFLOW if the absolute value of x is too large.
	@return	Conversion result.
*/
int
dk3ma_d_to_i_ok(double x, int *ec);

/**	Convert double value to unsigned.
	@param	x	Double value to convert.
	@param	ec	Pointer to error code variable.
	Set to DK3_ERROR_MATH_OVERFLOW if the absolute value of x is too large,
	DK3_ERROR_MATH_OUT_OF_RANGE for negative x.
	@return	Conversion result.
*/
unsigned
dk3ma_d_to_u_ok(double x, int *ec);

#ifdef __cplusplus
}
#endif


#endif
