/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madfo.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madfo.h Header file for the dk3madfo module.
*/

#ifndef DK3MADFO_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MADFO_H_INCLUDED 1


#line 9 "dk3madfo.ctr"

/**	@file	dk3madfo.h	Output functions for double values.
*/


#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**	Print floating point value specified as string to
	output file, avoid exponential notation.
	@param	of	Output file.
	@param	buffer	Buffer containing string representation of
	value, probably in scientific notatation. The buffer content
	is modified by this function.
	The string represenation should be built using
	sprintf(buffer, "%lg", value).
*/
void
dk3ma_print_double_c8_str_no_sci(FILE *of, char *buffer);

/**	Print floating point value to output file,
	avoid exponential notation.
	@param	of	Output file.
	@param	x	Value to print.
*/
void
dk3ma_print_double_c8_no_sci(FILE *of, double x);

#ifdef __cplusplus
}
#endif




#endif
