/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3madfo.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3madfo.c The dk3madfo module.
*/


#line 67 "dk3madfo.ctr"



#include "dk3ma.h"
#if DK3_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK3_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK3_HAVE_STRING_H
#include <string.h>
#endif
#if DK3_HAVE_ERRNO_H
#include <errno.h>
#endif



#line 85 "dk3madfo.ctr"



void
dk3ma_print_double_c8_str_no_sci(FILE *of, char *buffer)
{
  char		*start;		/* Start of string. */
  char		*eptr;		/* Start of exponent substring. */
  char		*ptr;		/* Traverse string. */
  size_t	 lgt;		/* String length. */
  int		 dp;		/* Decimal dot position. */
  int		 exponent;	/* Exponent. */
  int		 i;		/* Traverse the string. */
  

#line 99 "dk3madfo.ctr"
  if((of) && (buffer)) {
    eptr = NULL;
    start = buffer;
    /*
    	Print sign.
    */
    switch(*start) {
      case '-': {
        fputc('-', of);
	start++;
      } break;
      case '+': {
        start++;
      } break;
    }
    /*
    	Find exponent substring and exponent.
    */
    eptr = NULL;
    ptr = start;
    while(*ptr) {
      switch(*ptr) {
        case 'e': case 'E': {
	  eptr = ptr;
	} break;
      }
      ptr++;
    }
    if(eptr) {
      *(eptr++) = '\0';
#if VERSION_BEFORE_20140716
      if(sscanf(eptr, "%d", &exponent) != 1)
#else
      if (0 == dk3ma_i_from_c8_string(&exponent, eptr, NULL))
#endif
      {
        exponent = 0;
      }
    } else {
      exponent = 0;
    }
    /*
            Find decimal dot.
    */
    eptr = strchr(start, '.');
    if(eptr) {
      /*
              Keep dot position in dp, squeeze string.
      */
      *eptr = '\0';
      dp = (int)strlen(start);
      *eptr = '.';
      while(*eptr) {
        eptr[0] = eptr[1];
        eptr++;
      }
    } else {
      /*
              Dot position is after the string.
      */
      dp = (int)strlen(start);
    }
    /*
            Correct dot position.
    */
    dp = dp + exponent;
    /*
            Remove leading zeroes (if any).
    */
    while('0' == *start) {
      start++; dp--;
    }
    /*
            Remove trailing zeroes (if any).
    */
    eptr = NULL;
    ptr = start;
    while(*ptr) {
      if('0' == *ptr) {
        if(!(eptr)) { eptr = ptr; }
      } else {
        eptr = NULL;
      }
      ptr++;
    }
    if(eptr) { *eptr = '\0'; }
    lgt = strlen(start);
    if(0 < lgt) {
      if(dp >= (int)lgt) {
        /*
                Decimal dot is at end or after string.
        */
        fputs(start, of);
        /*
                Decimal dot is after the string.
        */
        for(i = 0; i < (dp - (int)lgt); i++) {
          fputc('0', of);
        }
      } else {
        if(dp <= 0) {
          /*
                  Decimal dot is before the string.
          */
          fputc('0', of);
          fputc('.', of);
          while(dp++ < 0) {
            fputc('0', of);
          }
          fputs(start, of);
        } else {
          /*
                  Decimal dot is in the string.
          */
          for(i = 0; i < (int)lgt; i++) {
            if(dp == i) {
              fputc('.', of);
            }
            fputc(start[i], of);
          }
        }
      }
    } else {
      /*
              No non-zero digits in string.
      */
      fputc('0', of);
    }
  } 

#line 228 "dk3madfo.ctr"
}



void
dk3ma_print_double_c8_no_sci(FILE *of, double x)
{
  char		 buffer[64];
  

#line 237 "dk3madfo.ctr"
  if(of) {
    sprintf(buffer, "%lg", x);
    dk3ma_print_double_c8_str_no_sci(of, buffer);
  } 

#line 241 "dk3madfo.ctr"
}


