/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3mad.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3mad.h Header file for the dk3mad module.
*/

#ifndef DK3MAD_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3MAD_H_INCLUDED 1


#line 10 "dk3mad.ctr"

/**	@file	dk3mad.h	Mathematical operations on double numbers.

Note: You should not use dk3ma_d_add_ok(), dk3ma_d_sub_ok(),
dk3ma_d_mul_ok(), dk3ma_d_div_ok() and dk3ma_d_div_ok()
for new programs.
Perform the calculations traditionally and use the
functions from the dk3mafpe module to check for floating point exceptions.

*/

#include <dk3conf.h>

#include <stdio.h>
#if DK3_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK3_HAVE_STDINT
#include <stdint.h>
#endif
#if DK3_HAVE_INTTYPES_H
#include <inttypes.h>
#endif
#if DK3_HAVE_LIMITS_H
#include <limits.h>
#endif
#if DK3_HAVE_MATH_H
#include <math.h>
#endif
#if DK3_HAVE_FLOAT_H
#include <float.h>
#endif


#ifdef __cplusplus
extern "C" {
#endif

/**	Absolute value.
	@param	x	Original value.
	@return	Absolute value of x.
*/
double
dk3ma_d_abs(double x);

/**	Rounding to next integer.
	@param	x	Double value.
	@return	Value rounded to nearest integer.
*/
double
dk3ma_d_rint(double x);

/**	Addition.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Summary of a and b.
*/
double
dk3ma_d_add_ok(double a, double b, int *ec);

/**	Substraction.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Difference of a and b.
*/
double
dk3ma_d_sub_ok(double a, double b, int *ec);

/**	Multiplication.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW when returning.
	@return	Product of a and b.
*/
double
dk3ma_d_mul_ok(double a, double b, int *ec);

/**	Division.
	@param	a	Left operand (nominator).
	@param	b	Right operand (denominator).
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OVERFLOW or
	DK3_ERROR_MATH_DIVZERO when returning.
	@return	Fraction of a and b.
*/
double
dk3ma_d_div_ok(double a, double b, int *ec);

/**	Square root.
	@param	x	Original value.
	@param	ec	Pointer to error code variable, may be NULL.
	The variable may be set to DK3_ERROR_MATH_OUT_OF_RANGE
	if the input is negative.
	@return	Square root of x.
*/
double
dk3ma_d_square_ok(double x, int *ec);

/**	Equality check.
	@param	a	Left operand.
	@param	b	Right operand.
	@param	epsilon	Maximum allowed difference between a and b.
	@return	1 for equal values, 0 for unequal values.
*/
int
dk3ma_d_equal(double a, double b, double epsilon);

/**	Arcus tangens for two lengths.
	@param	y	Y length (height).
	@param	x	X length (width).
	@return	Angle alpha for y/x = tan(alpha).
*/
double
dk3ma_d_atan2(double y, double x);

/**	Restrict number of digits following the decimal dot.
	@param	x	Original value.
	@param	n	Number of digits after decimal dot.
	@return	Rounded result.
*/
double
dk3ma_d_restrict_digits(double x, size_t n);

/**	Restrict number of digits following the decimal dot,
	round downwards.
	@param	x	Original value.
	@param	n	Number of digits after decimal dot.
	@return	Rounded result.
*/
double
dk3ma_d_restrict_digits_floor(double x, size_t n);

/**	Restrict number of digits following the decimal dot,
	round upwards.
	@param	x	Original value.
	@param	n	Number of digits after decimal dot.
	@return	Rounded result.
*/
double
dk3ma_d_restrict_digits_ceil(double x, size_t n);

#ifdef __cplusplus
}
#endif


#endif
