/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3kv.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3kv.c The dk3kv module.
*/


#line 43 "dk3kv.ctr"


#include "dk3all.h"



int
dk3kv_compare(void const *l, void const *r, int cr)
{
  int			 back	= 0;
  dk3_key_value_t const	*pl;
  dk3_key_value_t const	*pr;
  if(l) {
    if(r) {
      pl = (dk3_key_value_t const *)l;
      switch(cr) {
        case 1: {
	  back = dk3str_cmp(pl->key, (dkChar const *)r);
	} break;
	default: {
	  pr = (dk3_key_value_t const *)r;
	  back = dk3str_cmp(pl->key, pr->key);
	} break;
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}



void
dk3kv_delete(dk3_key_value_t *p)
{
  if(p) {
    dk3_release(p->key);
    dk3_release(p->val);
    dk3_delete(p);
  }
}



dk3_key_value_t *
dk3kv_new_app(dkChar const *k, dkChar const *v, dk3_app_t *app)
{
  dk3_key_value_t	*back	= NULL;
  if(k) {
    back = dk3_new_app(dk3_key_value_t,1,app);
    if(back) {
      back->key = NULL;
      back->val = NULL;
      back->key = dk3str_dup_app(k, app);
      if(back->key) {
        if(v) {
	  back->val = dk3str_dup_app(v, app);
	  if(!(back->val)) {
	    dk3kv_delete(back);
	    back = NULL;
	  }
	}
      } else {
        dk3kv_delete(back);
	back = NULL;
      }
    }
  }
  return back;
}



