/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3info.ctr
*/

/**	@file dk3info.c The dk3info module.
*/


#line 5 "dk3info.ctr"

#include "dk3all.h"
#include "dk3sf.h"
#include "dk3info1.c"


/**	Option names for configure.
*/
static dkChar const *option_names[] = {
/* 0 */
dkT("--prefix="),

/* 1 */
dkT("--sysconfdir="),

/* 2 */
dkT("--datarootdir="),

/* 3 */
dkT("--localstatedir="),

/* 4 */
dkT("--bindir="),

/* 5 */
dkT("--sbindir="),

/* 6 */
dkT("--libdir="),

/* 7 */
dkT("--includedir="),

/* 8 */
dkT("--mandir="),

/* 9 */
dkT("--execprefix="),

/* 10 */
dkT("--libexecdir="),

NULL


#line 27 "dk3info.ctr"
};



/**	Options order.
*/
static size_t option_order[] = {
  0, 1, 3, 2, 4, 5, 6, 7, 8, 10
};



/**	Number of options.
*/
static size_t num_options = (sizeof(option_order))/sizeof(size_t);



/**	Application group name.
*/
static dkChar const dk3info_group_name[] = { dkT("dkt-3") };



/**	Print the information.
	@param	app		Application structure.
	@param	longvers	Flag: Print long version.
*/
static
void
run_with_app(dk3_app_t *app, int longvers)
{
  dkChar const	*val;		/* Directory value (compiled). */
  dkChar const	*xval;		/* Directory value (actually used). */
  size_t	 maxlgt = 0;	/* Maximum option name length. */
  size_t	 lgt;		/* Current option name length. */
  size_t	 i;		/* Traverse all options. */
  size_t	 k;		/* Print space. */
  size_t	 di;		/* Directory index. */
  int		 mp;		/* Flag: Must print actual data. */

  /*	Find maximum length of option names.
  */
  for(i = 0; i < num_options; i++) {
    di = option_order[i];
    /* ##### Count number of screen positions! */
    lgt = dk3str_len(option_names[di]);
    if(lgt > maxlgt) { maxlgt = lgt; }
  }
  /*	Now print the information.
  */
  dk3sf_initialize_stdout();
  for(i = 0; i < num_options; i++) {
    di = option_order[i];
    lgt = dk3str_len(option_names[di]);
    if(lgt < maxlgt) {
      lgt = maxlgt - lgt;
      while(lgt--) {
        dk3sf_fputc(dkT(' '), stdout);
      }
    }
    dk3sf_fputs(option_names[di], stdout);
    val = dk3inst_get_directory(di);
    if(val) {
      dk3sf_fputs(val, stdout);
    }
    dk3sf_fputc(dkT('\n'), stdout);
    if(app) {
      xval = NULL;
      mp = 1;
      switch(di) {
        case DK3_INST_SYSCONF: xval = dk3app_get_etcdir(app); break;
	case DK3_INST_DATAROOT: xval = dk3app_get_sharedir(app); break;
	case DK3_INST_BIN: xval = dk3app_get_bindir(app); break;
	case DK3_INST_LOCALSTATE: xval = dk3app_get_vardir(app); break;
      }
      if(xval) {
        if(val) {
	  if(0 == dk3str_fncmp(val, xval)) {
	    mp = 0;
	  }
	}
        if(mp) {
	  for(k = 0; k < maxlgt; k++) dk3sf_fputc(dkT(' '), stdout);
	  dk3sf_fputs(xval, stdout);
	  dk3sf_fputc(dkT('\n'), stdout);
	}
      }
    }
  }
  if(longvers) {
    show_defines();
  }
}



/**	The main function.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, all other values indicate errors.
*/
DK3_MAIN
{
  dk3_app_t		*app = NULL;
  dkChar const * const	*xargv;
  int			 longvers = 0;
  int			 xargc;
  app = dk3app_open_command(
    argc, (dkChar const * const *)argv, dk3info_group_name
  );
  if(app) {
    xargc = dk3app_get_argc(app);
    xargv = dk3app_get_argv(app);
    if(1 < xargc) {
      if(dk3str_cmp(xargv[1], dkT("-l")) == 0) {
        longvers = 1;
      }
    }
    run_with_app(app, longvers);
    dk3app_close(app);
  } else {
    if(1 < argc) {
      if(dk3str_cmp(argv[1], dkT("-l")) == 0) {
        longvers = 1;
      }
    }
    run_with_app(NULL, longvers);
  }
  fflush(stdout);
  exit(0); return 0;
}



