/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3font.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3font.h Header file for the dk3font module.
*/

#ifndef DK3FONT_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3FONT_H_INCLUDED 1


#line 10 "dk3font.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Retrieve PS font name for font without leading slash.
	@param	fontno	Font number.
	@return	Pointer to name on success, NULL on error.
*/
char const *
dk3font_get_ps_font_name(int fontno);

/**	Retrieve GS font name for font.
	@param	fontno	Font number.
	@return	Pointer to name on success, NULL on error.
*/
char const *
dk3font_get_gs_font_name(int fontno);

/**	Retrieve TeX/LaTeX font name.
	@param	fontno	Font number.
	@return	Pointer to name on success, NULL on error.
*/
char const *
dk3font_get_tex_font_name(int fontno);

/**	Get TeX/LaTeX font family name.
	@param	fontno	Font number.
	@return	Pointer to family name on success, NULL on error.
*/
char const *
dk3font_get_tex_family_name(int fontno);

/**	Get old GS font file name without leading path and without suffix.
	Typically you need to append ".pfb".
	@param	fontno	Font number.
	@return	Pointer to name on success, NULL on error.
*/
char const *
dk3font_get_gs_old_file(int fontno);

/**	Get new GS font file name without leading path and without suffix.
	@param	fontno	Font number.
	@return	Pointer to name on success, NULL on error.
*/
char const *
dk3font_get_gs_new_file(int fontno);

/**	Retrieve font feature set.
	@param	fontno	Font number.
	@return	Font feature set.
*/
int
dk3font_get_features(int fontno);

/**	Retrieve SVG font feature set.
	@param	fontno	Font number.
	@return	Font feature set.
*/
int
dk3font_get_svg_features(int fontno);

/**	Retrieve PS font family name.
	@param	fontno	Font number.
	@return	Family name on success, NULL on error.
*/
char const *
dk3font_get_ps_family(int fontno);

/**	Retrieve list of replacement family names.
	@param	fontno	Font number.
	@return	NULL-terminated array of names.
*/
char const * const *
dk3font_get_replacement_families(int fontno);

/**	Retrieve SVG font family name.
	@param	fontno	Font number.
	@return	Family name on success, NULL on error.
*/
char const *
dk3font_get_svg_family(int fontno);

/**	Retrieve SVG font ID.
	@param	fontno	Font number.
	@return	Font ID on success, NULL on error.
*/
char const *
dk3font_get_svg_fontid(int fontno);

/**	Retrieve SVG font weight.
	@param	fontno	Font number.
	@return	The weight as numeric value.
*/
int
dk3font_get_svg_font_weight(int fontno);

/**	Find font base URI.
	@param	app	Application structure.
	@param	buf	Destination buffer.
	@param	bs	Size of @arg buf (number of dkChar).
	@return	1 on success, 0 on error.
*/
int
dk3font_gs_base_web(dk3_app_t *app, dkChar *buf, size_t bs);

/**	Find local font base directory.
	@param	app	Application structure.
	@param	buf	Destination buffer.
	@param	bs	Size of @arg buf (number of dkChar).
	@return	1 on success, 0 on error.
*/
int
dk3font_gs_base_local(dk3_app_t *app, dkChar *buf, size_t bs);

#ifdef __cplusplus
}
#endif




#endif
