/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3font.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3font.c The dk3font module.
*/


#line 132 "dk3font.ctr"

#include "dk3all.h"
#include "dk3font.h"





#line 139 "dk3font.ctr"



/*
	PLACES TO SEARCH FOR PFB FILES:
	===============================

	Linux
	-----
	/usr/share/ghostscript/_version_/Resource/Font/_newname_
	/usr/share/fonts/default/Type1/_oldname_.pfb

	Windows
	-------
	_windowsdirectory_/Fonts
	Ghostscript font directories
*/



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_times_family_names[] = {
/* 0 */
"Times New Roman",

/* 1 */
"Bodoni MT",

NULL


#line 166 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_avantgarde_family_names[] = {
/* 0 */
"Trebuchet MS",

/* 1 */
"Verdana",

NULL


#line 177 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_bookman_light_family_names[] = {
/* 0 */
"Bookman Old Style",

/* 1 */
"Times New Roman",

NULL


#line 188 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_courier_family_names[] = {
/* 0 */
"Courier New",

NULL


#line 198 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_helvetica_family_names[] = {
/* 0 */
"Arial",

/* 1 */
"Gill Sans MT",

/* 2 */
"Lucida Sans",

/* 3 */
"Tahoma",

NULL


#line 211 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_helvetica_narrow_family_names[] = {
/* 0 */
"Arial Narrow",

/* 1 */
"Arial",

NULL


#line 222 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_ncschoolbook_family_names[] = {
/* 0 */
"Century Schoolbook",

/* 1 */
"Times New Roman",

NULL


#line 233 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_palatino_family_names[] = {
/* 0 */
"Palatino Linotype",

/* 1 */
"Times New Roman",

NULL


#line 244 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_symbol_family_names[] = {
/* 0 */
"Symbol",

NULL


#line 254 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_zapfchancery_family_names[] = {
/* 0 */
"Edwardian Script ITC",

/* 1 */
"Blackadder ITC",

NULL


#line 265 "dk3font.ctr"
};



/**	Additional system font families usable as replacements.
*/
static char const * const	dk3font_zapfdingbats_family_names[] = {
/* 0 */
"WingDings",

NULL


#line 275 "dk3font.ctr"
};



/**	Font information.
*/
static dk3_font_t const dk3font_data[] = {
  { /*  0 */
    "Times-Roman",
    "ptmr",
    "ptm",
    "NimbusRomNo9L-Regu",
    "n021003l",
    "NimbusRomNo9L-Regu",
    "Times",
    "Nimbus Roman No9 L",
    "NimbusRomanNo9L-Regu",
    dk3font_times_family_names,
    DK3_FONT_ROMAN,
    DK3_FONT_ROMAN,
    400
  },
  { /*  1 */
    "Times-Italic",
    "ptmri",
    "ptm",
    "NimbusRomNo9L-ReguItal",
    "n021023l",
    "NimbusRomNo9L-ReguItal",
    "Times",
    "Nimbus Roman No9 L",
    "NimbusRomNo9L-ReguItal",
    dk3font_times_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    400
  },
  { /*  2 */
    "Times-Bold",
    "ptmb",
    "ptm",
    "NimbusRomNo9L-Medi",
    "n021004l",
    "NimbusRomNo9L-Medi",
    "Times",
    "Nimbus Roman No9 L",
    "NimbusRomNo9L-Medi",
    dk3font_times_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_BOLD),
    DK3_FONT_ROMAN,
    500
  },
  { /*  3 */
    "Times-BoldItalic",
    "ptmbi",
    "ptm",
    "NimbusRomNo9L-MediItal",
    "n021024l",
    "NimbusRomNo9L-MediItal",
    "Times",
    "Nimbus Roman No9 L",
    "NimbusRomNo9L-MediItal",
    dk3font_times_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC | DK3_FONT_BOLD),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    500
  },
  { /*  4 */
    "AvantGarde-Book",
    "pagk",
    "pag",
    "URWGothicL-Book",
    "a010013l",
    "URWGothicL-Book",
    "AvantGarde",
    "URW Gothic L",
    "URWGothicL-Book",
    dk3font_avantgarde_family_names,
    DK3_FONT_SANS_SERIF,
    DK3_FONT_SANS_SERIF,
    400
  },
  { /*  5 */
    "AvantGarde-BookOblique",
    "pagko",
    "pag",
    "URWGothicL-BookObli",
    "a010033l",
    "URWGothicL-BookObli",
    "AvantGarde",
    "URW Gothic L",
    "URWGothicL-BookObli",
    dk3font_avantgarde_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_ITALIC),
    (DK3_FONT_SANS_SERIF | DK3_FONT_OBLIQUE),
    400
  },
  { /*  6 */
    "AvantGarde-Demi",
    "pagd",
    "pag",
    "URWGothicL-Demi",
    "a010015l",
    "URWGothicL-Demi",
    "AvantGarde",
    "URW Gothic L",
    "URWGothicL-Demi",
    dk3font_avantgarde_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_BOLD),
    DK3_FONT_SANS_SERIF,
    600
  },
  { /*  7 */
    "AvantGarde-DemiOblique",
    "pagdo",
    "pag",
    "URWGothicL-DemiObli",
    "a010035l",
    "URWGothicL-DemiObli",
    "AvantGarde",
    "URW Gothic L",
    "URWGothicL-DemiObli",
    dk3font_avantgarde_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_ITALIC | DK3_FONT_BOLD),
    (DK3_FONT_SANS_SERIF | DK3_FONT_OBLIQUE),
    600
  },
  { /*  8 */
    "Bookman-Light",
    "pbkl",
    "pbk",
    "URWBookmanL-Ligh",
    "b018012l",
    "URWBookmanL-Ligh",
    "Bookman",
    "URW Bookman L",
    "URWBookmanL-Ligh",
    dk3font_bookman_light_family_names,
    DK3_FONT_ROMAN,
    DK3_FONT_ROMAN,
    400
  },
  { /*  9 */
    "Bookman-LightItalic",
    "pbkli",
    "pbk",
    "URWBookmanL-LighItal",
    "b018032l",
    "URWBookmanL-LighItal",
    "Bookman",
    "URW Bookman L",
    "URWBookmanL-LighItal",
    dk3font_bookman_light_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    400
  },
  { /* 10 */
    "Bookman-Demi",
    "pbkd",
    "pbk",
    "URWBookmanL-DemiBold",	/* 2.2.22: URWBookmanL-Demi */
    "b018015l",
    "URWBookmanL-DemiBold",
    "Bookman",
    "URW Bookman L",
    "URWBookmanL-DemiBold",
    dk3font_bookman_light_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_BOLD),
    DK3_FONT_ROMAN,
    600
  },
  { /* 11 */
    "Bookman-DemiItalic",
    "pbkdi",
    "pbk",
    "URWBookmanL-DemiBoldItal",	/* 2.2.22: URWBookmanL-DemiItal */
    "b018035l",
    "URWBookmanL-DemiBoldItal",
    "Bookman",
    "URW Bookman L",
    "URWBookmanL-DemiBoldItal",
    dk3font_bookman_light_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC | DK3_FONT_BOLD),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    600
  },
  { /* 12 */
    "Courier",
    "pcrr",
    "pcr",
    "NimbusMonL-Regu",
    "n022003l",
    "NimbusMonL-Regu",
    "Courier",
    "Nimbus Mono L",
    "NimbusMonL-Regu",
    dk3font_courier_family_names,
    DK3_FONT_TYPEWRITER,
    DK3_FONT_TYPEWRITER,
    400
  },
  { /* 13 */
    "Courier-Oblique",
    "pcrro",
    "pcr",
    "NimbusMonL-ReguObli",
    "n022023l",
    "NimbusMonL-ReguObli",
    "Courier",
    "Nimbus Mono L",
    "NimbusMonL-ReguObli",
    dk3font_courier_family_names,
    (DK3_FONT_TYPEWRITER | DK3_FONT_ITALIC),
    (DK3_FONT_TYPEWRITER | DK3_FONT_OBLIQUE),
    400
  },
  { /* 14 */
    "Courier-Bold",
    "pcrb",
    "pcr",
    "NimbusMonL-Bold",
    "n022004l",
    "NimbusMonL-Bold",
    "Courier",
    "Nimbus Mono L",
    "NimbusMonL-Bold",
    dk3font_courier_family_names,
    (DK3_FONT_TYPEWRITER | DK3_FONT_BOLD),
    DK3_FONT_TYPEWRITER,
    700
  },
  { /* 15 */
    "Courier-BoldOblique",
    "pcrbo",
    "pcr",
    "NimbusMonL-BoldObli",
    "n022024l",
    "NimbusMonL-BoldObli",
    "Courier",
    "Nimbus Mono L",
    "NimbusMonL-BoldObli",
    dk3font_courier_family_names,
    (DK3_FONT_TYPEWRITER | DK3_FONT_ITALIC | DK3_FONT_BOLD),
    (DK3_FONT_TYPEWRITER | DK3_FONT_OBLIQUE),
    700
  },
  { /* 16 */
    "Helvetica",
    "phvr",
    "phv",
    "NimbusSanL-Regu",
    "n019003l",
    "NimbusSanL-Regu",
    "Helvetica",
    "Nimbus Sans L",
    "NimbusSansL-Regu",
    dk3font_helvetica_family_names,
    DK3_FONT_SANS_SERIF,
    DK3_FONT_SANS_SERIF,
    400
  },
  { /* 17 */
    "Helvetica-Oblique",
    "phvro",
    "phv",
    "NimbusSanL-ReguItal",
    "n019023l",
    "NimbusSanL-ReguItal",
    "Helvetica",
    "Nimbus Sans L",
    "NimbusSanL-ReguItal",
    dk3font_helvetica_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_OBLIQUE),
    (DK3_FONT_SANS_SERIF | DK3_FONT_ITALIC),
    400
  },
  { /* 18 */
    "Helvetica-Bold",
    "phvb",
    "phv",
    "NimbusSanL-Bold",
    "n019004l",
    "NimbusSanL-Bold",
    "Helvetica",
    "Nimbus Sans L",
    "NimbusSanL-Bold",
    dk3font_helvetica_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_BOLD),
    DK3_FONT_SANS_SERIF,
    700
  },
  { /* 19 */
    "Helvetica-BoldOblique",
    "phvbo",
    "phv",
    "NimbusSanL-BoldItal",
    "n019024l",
    "NimbusSanL-BoldItal",
    "Helvetica",
    "Nimbus Sans L",
    "NimbusSanL-BoldItal",
    dk3font_helvetica_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_OBLIQUE | DK3_FONT_BOLD),
    (DK3_FONT_SANS_SERIF | DK3_FONT_ITALIC),
    700
  },
  { /* 20 */
    "Helvetica-Narrow",
    "phvrrn",
    "phv",
    "NimbusSanL-ReguCond",
    "n019043l",
    "NimbusSanL-ReguCond",
    "Helvetica Narrow",
    "Nimbus Sans L",
    "NimbusSanL-ReguCond",
    dk3font_helvetica_narrow_family_names,
    DK3_FONT_SANS_SERIF,
    DK3_FONT_SANS_SERIF,
    400
  },
  { /* 21 */
    "Helvetica-Narrow-Oblique",
    "phvron",
    "phv",
    "NimbusSanL-ReguCondItal",
    "n019063l",
    "NimbusSanL-ReguCondItal",
    "Helvetica Narrow",
    "Nimbus Sans L",
    "NimbusSanL-ReguCondItal",
    dk3font_helvetica_narrow_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_OBLIQUE),
    (DK3_FONT_SANS_SERIF | DK3_FONT_ITALIC),
    400
  },
  { /* 22 */
    "Helvetica-Narrow-Bold",
    "phvbrn",
    "phv",
    "NimbusSanL-BoldCond",
    "n019044l",
    "NimbusSanL-BoldCond",
    "Helvetica Narrow",
    "Nimbus Sans L",
    "NimbusSanL-BoldCond",
    dk3font_helvetica_narrow_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_BOLD),
    DK3_FONT_SANS_SERIF,
    700
  },
  { /* 23 */
    "Helvetica-Narrow-BoldOblique",
    "phvbon",
    "phv",
    "NimbusSanL-BoldCondItal",
    "n019064l",
    "NimbusSanL-BoldCondItal",
    "Helvetica Narrow",
    "Nimbus Sans L",
    "NimbusSanL-BoldCondItal",
    dk3font_helvetica_narrow_family_names,
    (DK3_FONT_SANS_SERIF | DK3_FONT_OBLIQUE | DK3_FONT_BOLD),
    (DK3_FONT_SANS_SERIF | DK3_FONT_ITALIC),
    700
  },
  { /* 24 */
    "NewCenturySchlbk-Roman",
    "pncr",
    "pnc",
    "CenturySchL-Roma",
    "c059013l",
    "CenturySchL-Roma",
    "New Century Schoolbook",
    "Century Schoolbook L",
    "CenturySchL-Roma",
    dk3font_ncschoolbook_family_names,
    DK3_FONT_ROMAN,
    DK3_FONT_ROMAN,
    400
  },
  { /* 25 */
    "NewCenturySchlbk-Italic",
    "pncri",
    "pnc",
    "CenturySchL-RomaItal",
    "c059033l",
    "CenturySchL-Ital",
    "New Century Schoolbook",
    "Century Schoolbook L",
    "CenturySchL-Ital",
    dk3font_ncschoolbook_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    400
  },
  { /* 26 */
    "NewCenturySchlbk-Bold",
    "pncb",
    "pnc",
    "CenturySchL-Bold",
    "c059016l",
    "CenturySchL-Bold",
    "New Century Schoolbook",
    "Century Schoolbook L",
    "CenturySchL-Bold",
    dk3font_ncschoolbook_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_BOLD),
    DK3_FONT_ROMAN,
    700
  },
  { /* 27 */
    "NewCenturySchlbk-BoldItalic",
    "pncbi",
    "pnc",
    "CenturySchL-BoldItal",
    "c059036l",
    "CenturySchL-BoldItal",
    "New Century Schoolbook",
    "Century Schoolbook L",
    "CenturySchL-BoldItal",
    dk3font_ncschoolbook_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC | DK3_FONT_BOLD),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    700
  },
  { /* 28 */
    "Palatino-Roman",
    "pplr",
    "ppl",
    "URWPalladioL-Roma",
    "p052003l",
    "URWPalladioL-Roma",
    "Palatino",
    "URW Palladio L",
    "URWPalladioL-Roma",
    dk3font_palatino_family_names,
    DK3_FONT_ROMAN,
    DK3_FONT_ROMAN,
    400
  },
  { /* 29 */
    "Palatino-Italic",
    "pplri",
    "ppl",
    "URWPalladioL-Ital",
    "p052023l",
    "URWPalladioL-Ital",
    "Palatino",
    "URW Palladio L",
    "URWPalladioL-Ital",
    dk3font_palatino_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    400
  },
  { /* 30 */
    "Palatino-Bold",
    "pplb",
    "ppl",
    "URWPalladioL-Bold",
    "p052004l",
    "URWPalladioL-Bold",
    "Palatino",
    "URW Palladio L",
    "URWPalladioL-Bold",
    dk3font_palatino_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_BOLD),
    DK3_FONT_ROMAN,
    700
  },
  { /* 31 */
    "Palatino-BoldItalic",
    "pplbi",
    "ppl",
    "URWPalladioL-BoldItal",
    "p052024l",
    "URWPalladioL-BoldItal",
    "Palatino",
    "URW Palladio L",
    "URWPalladioL-BoldItal",
    dk3font_palatino_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC | DK3_FONT_BOLD),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    700
  },
  { /* 32 */
    "Symbol",
    "psyr",
    "psy",
    "StandardSymL",
    "s050000l",
    "StandardSymL",
    "Symbol",
    "Standard Symbols L",
    "StandardSymL",
    dk3font_symbol_family_names,
    0,
    0,
    400
  },
  { /* 33 */
    "ZapfChancery-MediumItalic",
    "pzcmi",
    "pzc",
    "URWChanceryL-MediItal",
    "z003034l",
    "URWChanceryL-MediItal",
    "Zapf Chancery",
    "URW Chancery L",
    "URWChanceryL-MediItal",
    dk3font_zapfchancery_family_names,
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    (DK3_FONT_ROMAN | DK3_FONT_ITALIC),
    500
  },
  { /* 34 */
    "ZapfDingbats",
    "pzdr",
    "pzd",
    "Dingbats",
    "d050000l",
    "Dingbats",
    "DingBats",
    "Dingbats",
    "Dingbats",
    dk3font_zapfdingbats_family_names,
    0,
    0,
    400
  }
};



/**	Preference names to search for GhostScript font files.
*/
static dkChar const * const	dk3font_base_pref_names[] = {
dkT("/fonts/ghostscript/web"),
dkT("/fonts/ghostscript/local"),
NULL
};



char const *
dk3font_get_ps_font_name(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].psFontName;
  }
  return back;
}



char const *
dk3font_get_gs_font_name(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].gsFontName;
  }
  return back;
}



char const *
dk3font_get_tex_font_name(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].texFontName;
  }
  return back;
}



char const *
dk3font_get_tex_family_name(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].texFamilyName;
  }
  return back;
}



char const *
dk3font_get_gs_old_file(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].gsFileOld;
  }
  return back;
}



char const *
dk3font_get_gs_new_file(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].gsFileNew;
  }
  return back;
}



int
dk3font_get_features(int fontno)
{
  int			 back = 0;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].features;
  }
  return back;
}


int
dk3font_get_svg_features(int fontno)
{
  int			 back = 0;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].svgFeatures;
  }
  return back;
}



char const *
dk3font_get_ps_family(int fontno)
{
  char const		*back = NULL;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].psFamilyName;
  }
  return back;
}



char const *
dk3font_get_svg_family(int fontno)
{
  char const		*back = NULL;
  

#line 933 "dk3font.ctr"
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].svgFamilyName;
  } 

#line 936 "dk3font.ctr"
  return back;
}



char const *
dk3font_get_svg_fontid(int fontno)
{
  char const		*back = NULL;
  

#line 946 "dk3font.ctr"
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].svgFontId;
  } 

#line 949 "dk3font.ctr"
  return back;
}



int
dk3font_get_svg_font_weight(int fontno)
{
  int		back = 0;
  if((fontno >= 0) && (fontno < 35)) {
    back = dk3font_data[fontno].svgFontWeight;
  }
  return back;
}



int
dk3font_gs_base_web(dk3_app_t *app, dkChar *buf, size_t bs)
{
  int back;
  back = dk3app_get_dir_from_pref(app, dk3font_base_pref_names[0], buf, bs, 0);
  return back;
}



int
dk3font_gs_base_local(dk3_app_t *app, dkChar *buf, size_t bs)
{
  int back;
  back = dk3app_get_dir_from_pref(app, dk3font_base_pref_names[1], buf, bs, 1);
  return back;
}



char const * const *
dk3font_get_replacement_families(int fontno)
{
  char const * const	*back = NULL;
  if((0 <= fontno) && (fontno < 35)) {
    back = dk3font_data[fontno].replacements;
  }
  return back;
}


