/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figto.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figto.h Header file for the dk3figto module.
*/

#ifndef DK3FIGTO_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3FIGTO_H_INCLUDED 1


#line 10 "dk3figto.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Check whether or not an object is a background rectangle.
	A background rectangle is not drawn to output, it is only
	used to calculate the bounding box of the drawing.
	@param	obj	Object to check.
	@param	objno	Object number in storage.
	@return	1 for background rectangle, 0 for normal object.
*/
int
dk3fig_tool_is_bgrect(dk3_fig_obj_t const *obj, unsigned long objno);

/**	Find line width for object.
	@param	drw	Drawing to which the object belongs.
	@param	obj	Object to find line width for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Positive line width in Fig units on success, 0.0 on error.
*/
double
dk3fig_tool_get_lw(
  dk3_fig_drawing_t const	*drw,
  dk3_fig_obj_t	const		*obj,
  int				*ec
);

/**	Get object line width in bp.
	@param	drw	Drawing to which the object belongs.
	@param	obj	Object to find line width for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Positive line width in Fig units on success, 0.0 on error.
*/
double
dk3fig_tool_get_lw_in_bp(
  dk3_fig_drawing_t const	*drw,
  dk3_fig_obj_t const		*obj,
  int				*ec
);

/**	Calculate kappa value for arc.
	To approximate arcs using Bezier spline segments we calculate
	the control points as xcs = xstart + kappa * x'(0) and
	xce = xend - kappa * x'(1). Using a kappa depending on the
	angle alpha results in a better approximation than using the
	fixed constant 1/3.
	@param	alpha	Arc angle.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Non-negative value on success, -1.0 on error.
*/
double
dk3fig_tool_arc_kappa(double alpha, int *ec);

/**	Find number of Bezier segments per X-spline segment.
	@param	drw	Drawing.
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@return	Number of Bezier segments per X-spline segment.
*/
size_t
dk3fig_tool_xssbs(dk3_fig_drawing_t *drw, int primobj);

/**	Calculate distance between two points.
	@param	p1	Point 1.
	@param	p2	Point 2.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Distance value.
*/
double
dk3fig_tool_point_distance(
  dk3_fig_poly_point_t const	*p1,
  dk3_fig_poly_point_t const	*p2,
  int				*ec
);

/**	Move polyline points to the left to skip first segment.
	@param	dst	Destination pointer (address of element 0).
	@param	src	Source pointer (address of element 1).
	@param	np	Number of elements to shift.
*/
void
dk3fig_tool_poly_point_move_left(
  dk3_fig_poly_point_t		*dst,
  dk3_fig_poly_point_t		*src,
  size_t			 np
);

/**	Shorten a line segment.
	@param	endpoint	Endpoint of the polyline.
	@param	innerpoint	Inner point of the polyline.
	@param	distance	Distance to cut.
	@param	ec		Pointer to error code variable, may be NULL.
	@return	1 on success, 0 on error (point distance too short).
*/
int
dk3fig_tool_cut_segment(
  dk3_fig_poly_point_t		*endpoint,
  dk3_fig_poly_point_t const	*innerpoint,
  double			 distance,
  int				*ec
);

/**	Find operations necessary to draw an object.
	@param	drw	Drawing.
	@param	obj	Object.
	@return	Drawing operations combination, see @ref dk3figoperations.
*/
int
dk3fig_tool_get_operation(dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj);

/**	Find RGB color (double values).
	@param	rgb	Color structure to set up.
	@param	drw	Drawing to find color for.
	@param	colno	Color number.
	@param	fs	Fill style.
*/
void
dk3fig_tool_find_color(
  dk3_rgb_color_t	*rgb,
  dk3_fig_drawing_t	*drw,
  int			 colno,
  int			 fs
);

/**	Find RGB color (int values).
	@param	dst	Color structure to set up.
	@param	drw	Drawing to find color for.
	@param	colno	Color number.
	@param	fs	Fill style.
*/
void
dk3fig_tool_find_int_color(
  dk3_fig_color_t	*dst,
  dk3_fig_drawing_t	*drw,
  int			 colno,
  int			 fs
);

/**	Rotate a point.
	@param	point	Point to rotate.
	@param	angle	Rotation angle in radians.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
dk3fig_tool_rotate_point(
  dk3_fig_poly_point_t	*point,
  double		 angle,
  int			*ec
);

/**	Rotate a spline point.
	@param	point	Point to rotate.
	@param	angle	Rotation angle in radians.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
dk3fig_tool_rotate_spoint(
  dk3_fig_spline_point_t	*point,
  double			 angle,
  int				*ec
);

/**	Shift a point.
	@param	point	Point to shift.
	@param	x	X shift.
	@param	y	Y shift.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
dk3fig_tool_shift_point(
  dk3_fig_poly_point_t	*point,
  double		 x,
  double		 y,
  int			*ec
);

/**	Shift a spline point.
	@param	point	Point to shift.
	@param	x	X shift.
	@param	y	Y shift.
	@param	ec	Pointer to error code variable, may be NULL.
*/
void
dk3fig_tool_shift_spoint(
  dk3_fig_spline_point_t	*point,
  double			 x,
  double			 y,
  int				*ec
);

/**	Compare two font structures.
	Comparison by font number first, font size later.
	@param	l	Left font structure.
	@param	r	Right font structure.
	@param	cr	Comparison criteria, ignored.
	@return	Comparison result.
*/
int
dk3fig_tool_font_compare(void const *l, void const *r, int cr);

/**	Find PS font number for text object.
	@param	obj	Text object.
	@return	Non-negative font number on success
	(PS font suitable for this text object),
	-1 on error (not a text object or hidden or special text).
*/
int
dk3fig_tool_ps_font_number(dk3_fig_obj_t *obj);

/**	Check whether a new color must be set.
	@param	hc1	Flag: Old color configured.
	@param	r1	Old red.
	@param	g1	Old green.
	@param	b1	Old blue.
	@param	r2	New red.
	@param	g2	New green.
	@param	b2	New blue.
	@return	1 if the color must be set, 0 otherwise.
*/
int
dk3fig_tool_must_set_color(
  int		hc1,
  double	r1,
  double	g1,
  double	b1,
  double	r2,
  double	g2,
  double	b2
);

/**	Check whether we must set up a new font.
	@param	hfn	Flag: Have old font number and size.
	@param	ofn	Old font number.
	@param	ofs	Old font size.
	@param	nfn	New font number.
	@param	nfs	New font size.
	@return	1 if we must install the new font, 0 otherwise.
*/
int
dk3fig_tool_must_set_font(
  int		hfn,
  int		ofn,
  double	ofs,
  int		nfn,
  double	nfs
);

/**	Obtain short output file name as 8-bit character string.
	The result of this function is used as argument to an
	includegraphics LaTeX instruction.
	@param	fullName	Full name of output file.
	@param	app		Application structure.
	@return	Pointer to 8-bit character string on success, NULL on error.
*/
char const *
dk3fig_tool_short_output_file_name(
  dkChar const		*fullName,
  dk3_app_t		*app
);

/**	Compare two text handling entries.
	@param	l	Left pointer.
	@param	r	Right pointer.
	@param	cr	Comparison criteria.
	@return	Comparison result.
*/
int
dk3fig_tool_text_handling_compare(void const *l, void const *r, int cr);

#ifdef __cplusplus
}
#endif


#endif
