/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figto.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figto.c The dk3figto module.
*/


#line 284 "dk3figto.ctr"


#include "dk3all.h"
#include "dk3fig.h"
#include "dk3figto.h"
#include "fig2lat.h"





#line 294 "dk3figto.ctr"



/**	Color palette for colors 0...31 as calculated from the floating point
	numbers.
*/
static dk3_fig_color_t	dk3fig_tool_low_rgb[] = {
  /*  0: black */        {  0,   0,   0,   0 },
  /*  1: blue */         {  1,   0,   0, 255 },
  /*  2: green */        {  2,   0, 255,   0 },
  /*  3: cyan */         {  3,   0, 255, 255 },
  /*  4: red */          {  4, 255,   0,   0 },
  /*  5: magenta */      {  5, 255,   0, 255 },
  /*  6: yellow */       {  6, 255, 255,   0 },
  /*  7: white */        {  7, 255, 255, 255 },
  /*  8: dark blue */    {  8,   0,   0, 143 },
  /*  9: blue */         {  9,   0,   0, 176 },
  /* 10: blue */         { 10,   0,   0, 209 },
  /* 11: blue */         { 11, 135, 207, 255 },
  /* 12: dark green */   { 12,   0, 143,   0 },
  /* 13: green */        { 13,   0, 176,   0 },
  /* 14: green */        { 14,   0, 209,   0 },
  /* 15: dark cyan */    { 15,   0, 143, 143 },
  /* 16: cyan */         { 16,   0, 176, 176 },
  /* 17: cyan */         { 17,   0, 209, 209 },
  /* 18: dark red */     { 18, 143,   0,   0 },
  /* 19: red */          { 19, 176,   0,   0 },
  /* 20: red */          { 20, 209,   0,   0 },
  /* 21: dark magenta */ { 21, 143,   0, 143 },
  /* 22: magenta */      { 22, 176,   0, 176 },
  /* 23: magenta */      { 23, 209,   0, 209 },
  /* 24: dark brown */   { 24, 127,  48,   0 },
  /* 25: brown */        { 25, 160,  63,   0 },
  /* 26: brown */        { 26, 191,  97,   0 },
  /* 27: dark pink */    { 27, 255, 127, 127 },
  /* 28: pink */         { 28, 255, 160, 160 },
  /* 29: pink */         { 29, 255, 191, 191 },
  /* 30: pink */         { 30, 255, 224, 224 },
  /* 31: gold */         { 31, 255, 214,   0 }
};



int
dk3fig_tool_is_bgrect(dk3_fig_obj_t const *obj, unsigned long objno)
{
  int 		 back = 0;
  if(obj) {
    if(0UL == objno) {
      if(DK3_FIG_OBJ_POLYLINE == obj->ot) {
        if(2 == obj->st) {
          if(999 == obj->la) {
	    if(0 == obj->lw) {
	      if(-1 == obj->fi) {
	        if((-1 == obj->pc) || (7 == obj->pc)) {
	          back = 1;
	        }
	      }
	    }
	  }
        }
      }
    }
  }
  return back;
}



double
dk3fig_tool_get_lw(
  dk3_fig_drawing_t const	*drw,
  dk3_fig_obj_t const		*obj,
  int				*ec
)
{
  int			 mec = 0;	/* Mathematical error code. */
#if VERSION_BEFORE_20140330
  double		 lw;		/* Line width. */
#endif
  double		 back = 0.0;
  

#line 376 "dk3figto.ctr"
#if VERSION_BEFORE_20140330
  if((drw) && (obj)) {
    lw = (double)(obj->lw); 

#line 379 "dk3figto.ctr"
    back = dk3ma_d_mul_ok(lw, drw->res, &mec) / 80.0;	

#line 380 "dk3figto.ctr"
    if(drw->lighten) { back = back / 2.0; }		

#line 381 "dk3figto.ctr"
    if(mec) {
      back = 0.0;
      if(ec) { *ec = mec; }
    }
  }
#else
  if ((drw) && (obj)) {
    /* back = obj->lw * drw->lwbp * drw->res / 72 */
    back = dk3ma_d_mul_ok(
      dk3ma_d_mul_ok(obj->lw, drw->lwbp, &mec),
      drw->res,
      &mec
    ) / 72.0;
    if (mec) {
      back = 0.0;
      if (ec) { *ec = mec; }
    }
  }
#endif
  

#line 401 "dk3figto.ctr"
  return back;
}



double
dk3fig_tool_get_lw_in_bp(
  dk3_fig_drawing_t const	*drw,
  dk3_fig_obj_t const		*obj,
  int				*ec
)
{
  double		 back	= 0.0;
  int			 mec	= 0;
  if ((drw) && (obj)) {
    back = dk3ma_d_mul_ok(obj->lw, drw->lwbp, &mec);
    if (mec) {
      back = 0.0;
      if (ec) { *ec = mec; }
    }
  }
  return back;
}


double
dk3fig_tool_arc_kappa(double alpha, int *ec)
{
  double	 back;
  double	 emcosa;	/* 1 - cos(alpha). */
  int		 mec = 0;	/* Mathematical error code. */
  

#line 433 "dk3figto.ctr"
  emcosa = 1.0 - cos(alpha);
  back = dk3ma_d_div_ok(
    ((2.0 * sqrt(8.0 * emcosa)) - (4.0 * sin(alpha))),
    dk3ma_d_mul_ok(alpha, (3.0 * emcosa), &mec),
    &mec
  );
  if(mec) {
    back = -1.0;
    if(ec) { *ec = mec; }
  } 

#line 443 "dk3figto.ctr"
  return back;
}



size_t
dk3fig_tool_xssbs(dk3_fig_drawing_t *drw, int primobj)
{
  size_t	 back = 8;
  

#line 453 "dk3figto.ctr"
  if(drw)		{ back = drw->xssbs; }
  if(!(primobj))	{ back = back / 2; }
  if(back < 2)		{ back = 2; }
  

#line 457 "dk3figto.ctr"
  return back;
}



double
dk3fig_tool_point_distance(
  dk3_fig_poly_point_t	const	*p1,
  dk3_fig_poly_point_t	const	*p2,
  int				*ec
)
{
  double	 back = 0.0;
  

#line 471 "dk3figto.ctr"
  if((p1) && (p2)) {
    back = sqrt(
      dk3ma_d_add_ok(
        dk3ma_d_square_ok(
          dk3ma_d_sub_ok(p2->x, p1->x, ec),
	  ec
        ),
        dk3ma_d_square_ok(
          dk3ma_d_sub_ok(p2->y, p1->y, ec),
	  ec
        ),
        ec
      )
    );
  } 

#line 486 "dk3figto.ctr"
  return back;
}



void
dk3fig_tool_poly_point_move_left(
  dk3_fig_poly_point_t		*dst,
  dk3_fig_poly_point_t		*src,
  size_t			 np
)
{
  dk3_fig_poly_point_t		*dptr;	/* Destination buffer pointer. */
  dk3_fig_poly_point_t		*sptr;	/* Source buffer pointer. */
  size_t			 i;	/* Index to traverse all elements. */
  

#line 502 "dk3figto.ctr"
  if((dst) && (src) && (np)) {
    dptr = dst; sptr = src; i = np;
    while(i--) { *(dptr++) = *(sptr++); }
  } 

#line 506 "dk3figto.ctr"
}



int
dk3fig_tool_cut_segment(
  dk3_fig_poly_point_t		*endpoint,
  dk3_fig_poly_point_t const	*innerpoint,
  double			 distance,
  int				*ec
)
{
  double	 delta;		/* Segment length. */
  double	 q;		/* Cut factor. */
  double	 newx;		/* New x of end point. */
  double	 newy;		/* New y of end point. */
  int		 back = 0;
  int		 mec = 0;	/* Mathematical error code. */
  

#line 525 "dk3figto.ctr"
  if((endpoint) && (innerpoint)) {		

#line 526 "dk3figto.ctr"
    

#line 527 "dk3figto.ctr"
    if(0.0 < distance) {			

#line 528 "dk3figto.ctr"
      delta = sqrt(
        dk3ma_d_add_ok(
	  dk3ma_d_square_ok(
	    dk3ma_d_sub_ok(innerpoint->x, endpoint->x, &mec),
	    &mec
	  ),
	  dk3ma_d_square_ok(
	    dk3ma_d_sub_ok(innerpoint->y, endpoint->y, &mec),
	    &mec
	  ),
	  &mec
	)
      );	

#line 541 "dk3figto.ctr"
      if(delta > distance) {			

#line 542 "dk3figto.ctr"
        q = dk3ma_d_div_ok(distance, delta, &mec);	

#line 543 "dk3figto.ctr"
	newx = dk3ma_d_add_ok(
	  endpoint->x,
	  dk3ma_d_mul_ok(
	    q,
	    dk3ma_d_sub_ok(innerpoint->x, endpoint->x, &mec),
	    &mec
	  ),
	  &mec
	);
	newy = dk3ma_d_add_ok(
	  endpoint->y,
	  dk3ma_d_mul_ok(
	    q,
	    dk3ma_d_sub_ok(innerpoint->y, endpoint->y, &mec),
	    &mec
	  ),
	  &mec
	);
	if(0 == mec) {		

#line 562 "dk3figto.ctr"
	  endpoint->x = newx; endpoint->y = newy;
	  back = 1;
	}
      } else {				

#line 566 "dk3figto.ctr"
      }
    } else {				

#line 568 "dk3figto.ctr"
    }
  } else {				

#line 570 "dk3figto.ctr"
  }
  if(mec) { if(ec) { *ec = mec; } } 

#line 572 "dk3figto.ctr"
  return back;
}



int
dk3fig_tool_get_operation(dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj)
{
  int		 back = 0;
  

#line 582 "dk3figto.ctr"
  if((drw) && (obj)) {
    if(0 < obj->lw) {
      if(obj->pc != drw->transcol) {
        back |= DK3_FIG_OP_STROKE;
      }
    }
    if(obj->cl) {
      if(-1 != obj->fi) {
        if(obj->fc != drw->transcol) {
          back |= DK3_FIG_OP_FILL;
        }
        if(40 < obj->fi) {
          if(63 > obj->fi) {
	    back |= DK3_FIG_OP_PATTERN;
	  }
        }
      }
    }
  } 

#line 601 "dk3figto.ctr"
  return back;
}



/**	Mix a color component against black or white.
	@param	x	Color component to mix.
	@param	y	Black (0) or white (1).
	@param	alpha	Ratio of x in 1/20.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Mix result.
*/
static
double
dk3fig_tool_color_alpha(double x, double y, double alpha, int *ec)
{
  double	 back;
  

#line 619 "dk3figto.ctr"
  back = dk3ma_d_add_ok(
    dk3ma_d_mul_ok(x, alpha, ec),
    dk3ma_d_mul_ok(y, dk3ma_d_sub_ok(20.0, alpha, ec), ec),
    ec
  ) / 20.0; 

#line 624 "dk3figto.ctr"
  return  back;
}



/**	Modify color depending on the fill style.
	@param	rgb	Destination and source pointer.
	@param	endval	Value to mix against.
	@param	twe	Coeffiecient for rgb, 1/20.
*/
static
void
dk3fig_tool_mix_color(
  dk3_rgb_color_t	*rgb,
  double		 endval,
  int			 twe
)
{
  dk3_rgb_color_t	myrgb;	/* Intermediate result buffer. */
  double		alpha;	/* Factor for mixing. */
  int			ec = 0;	/* Mathematical error code. */
  

#line 646 "dk3figto.ctr"
  myrgb.r = rgb->r;
  myrgb.g = rgb->g;
  myrgb.b = rgb->b;
  alpha = (double)twe;
  myrgb.r = dk3fig_tool_color_alpha(rgb->r, endval, alpha, &ec);
  myrgb.g = dk3fig_tool_color_alpha(rgb->g, endval, alpha, &ec);
  myrgb.b = dk3fig_tool_color_alpha(rgb->b, endval, alpha, &ec);
  if(0 == ec) {
    rgb->r = myrgb.r; rgb->g = myrgb.g; rgb->b = myrgb.b;
  } 

#line 656 "dk3figto.ctr"
}



/**	Mix one color value against another value.
	@param	cv	Primary color.
	@param	ov	Other color (background color) to mix against.
	@param	twe	Weight of cv, multiples of 1/20.
	@return	Color mixing result.
*/
static
int
dk3fig_tool_mix_one_int_color(int cv, int ov, int twe)
{
  int			 back;
  back = ((twe * cv) + ((20 - twe) * ov)) / 20;
  return back;
}



/**	Mix color against background color value (white or black).
	@param	col	Color to mix, input and output.
	@param	val	Value to mix against (background color 0=black, 255=white).
	@param	twe	Weight of input color, multiples of 1/20.
*/
static
void
dk3fig_tool_mix_int_color(
  dk3_fig_color_t		*col,
  int				 val,
  int				 twe
)
{
  col->r = dk3fig_tool_mix_one_int_color(col->r, val, twe);
  col->g = dk3fig_tool_mix_one_int_color(col->g, val, twe);
  col->b = dk3fig_tool_mix_one_int_color(col->b, val, twe);
}



void
dk3fig_tool_find_color(
  dk3_rgb_color_t	*rgb,
  dk3_fig_drawing_t	*drw,
  int			 colno,
  int			 fs
)
{
  dk3_fig_color_t	*pfc;		/* Pointer to already defined color. */
  int			 mycolno;	/* Color number. */
  

#line 708 "dk3figto.ctr"
  mycolno = 0;
  if(rgb) {
    rgb->r = rgb->g = rgb->b = 0.0;
    if(drw) {						

#line 712 "dk3figto.ctr"
      if(drw->scol) {					

#line 713 "dk3figto.ctr"
        if(drw->icol) {					

#line 714 "dk3figto.ctr"
	  if((0 <= colno) && (colno <= 31)) {		

#line 715 "dk3figto.ctr"
	    pfc = &(dk3fig_tool_low_rgb[colno]);
	  } else {					

#line 717 "dk3figto.ctr"
	    pfc = (dk3_fig_color_t *)dk3sto_it_find_like(
	      drw->icol, (void *)(&colno), 1
	    );
	  }
	  if(pfc) {
	    rgb->r = (double)(pfc->r) / 255.0;
	    rgb->g = (double)(pfc->g) / 255.0;
	    rgb->b = (double)(pfc->b) / 255.0;
	    mycolno = colno;
	  } else {			

#line 727 "dk3figto.ctr"
	    if(-1 != colno) {
	      /* ERROR: Color not found, using black as default! */
	      dk3app_log_1(drw->app, DK3_LL_WARNING, drw->msg, 7);
	    }
	  }
	} else {					

#line 733 "dk3figto.ctr"
	}
      } else {						

#line 735 "dk3figto.ctr"
      }
    } else {						

#line 737 "dk3figto.ctr"
    }
    if(-1 < fs) {
      if(20 > fs) {		

#line 740 "dk3figto.ctr"
        switch(mycolno) {
          case 0: {
	    dk3fig_tool_mix_color(rgb, 1.0, fs);
	  } break;
	  case 7: {
	    dk3fig_tool_mix_color(rgb, 0.0, fs);
	  } break;
	  default: {
	    dk3fig_tool_mix_color(rgb, 0.0, fs);
	  } break;
        }
      } else {
        if(41 > fs) {
          if(20 < fs) {		

#line 754 "dk3figto.ctr"
	    switch(mycolno) {
	      case 0: {
	      } break;
	      case 7: {
	      } break;
	      default: {
	        dk3fig_tool_mix_color(rgb, 1.0, (40 - fs));
	      } break;
	    }
	  }
        }
      }
    }
    if(drw->codi) {
      rgb->r = dk3ma_d_restrict_digits(rgb->r, drw->codi);
      rgb->g = dk3ma_d_restrict_digits(rgb->g, drw->codi);
      rgb->b = dk3ma_d_restrict_digits(rgb->b, drw->codi);
    }
  } 

#line 773 "dk3figto.ctr"
}



void
dk3fig_tool_find_int_color(
  dk3_fig_color_t	*dst,
  dk3_fig_drawing_t	*drw,
  int			 colno,
  int			 fs
)
{
  dk3_fig_color_t	*pfc = NULL;
  int			 mycolno;

  mycolno = 0;
  if(dst) {
    dst->r = dst->g = dst->b = 0;
    if(drw) {
      if((0 <= colno) && (colno <= 31)) {
        pfc = &(dk3fig_tool_low_rgb[colno]);
      } else {
        if(drw->scol) {
	  if(drw->icol) {
	    pfc = (dk3_fig_color_t *)dk3sto_it_find_like(
	      drw->icol, (void *)(&colno), 1
	    );
	  }
	}
      }
      if(pfc) {
        mycolno = colno;
        dst->r = pfc->r; dst->g = pfc->g; dst->b = pfc->b;
      } else {
        if(-1 != colno) {
	  /* ERROR: Color not found, using black as default! */
	  dk3app_log_1(drw->app, DK3_LL_WARNING, drw->msg, 7);
	}
      }
    }
    if(-1 < fs) {
      if(20 > fs) {			

#line 815 "dk3figto.ctr"
        switch(mycolno) {
	  case 0: {
	    dk3fig_tool_mix_int_color(dst, 255, fs);
	  } break;
	  case 7: {
	    dk3fig_tool_mix_int_color(dst, 0, fs);
	  } break;
	  default: {
	    dk3fig_tool_mix_int_color(dst, 0, fs);
	  } break;
	}
      } else {
        if((20 < fs) && (41 > fs)) {	

#line 828 "dk3figto.ctr"
	  switch(mycolno) {
	    case 0: {
	    } break;
	    case 7: {
	    } break;
	    default: {
	      dk3fig_tool_mix_int_color(dst, 255, (40 - fs));
	    } break;
	  }
	}
      }
    }
  }
}



void
dk3fig_tool_rotate_point(
  dk3_fig_poly_point_t	*point,
  double			 angle,
  int				*ec
)
{
  double	r;		/* Radius from origin to point. */
  double	alpha;		/* angle of point. */

  if(point) {
    r = sqrt(
      dk3ma_d_add_ok(
        dk3ma_d_square_ok(point->x, ec),
        dk3ma_d_square_ok(point->y, ec),
        ec
      )
    );
    alpha = dk3ma_d_atan2(point->y, point->x);
    alpha = dk3ma_d_add_ok(alpha, angle, ec);
    point->x = r * cos(alpha);
    point->y = r * sin(alpha);
  }
}



void
dk3fig_tool_rotate_spoint(
  dk3_fig_spline_point_t	*point,
  double			 angle,
  int				*ec
)
{
  double	r;		/* Radius origin to point. */
  double	alpha;		/* Angle of point. */

  if(point) {
    r = sqrt(
      dk3ma_d_add_ok(
        dk3ma_d_square_ok(point->x, ec),
        dk3ma_d_square_ok(point->y, ec),
        ec
      )
    );
    alpha = dk3ma_d_atan2(point->y, point->x);
    alpha = dk3ma_d_add_ok(alpha, angle, ec);
    point->x = r * cos(alpha);
    point->y = r * sin(alpha);
  }
}


void
dk3fig_tool_shift_point(
  dk3_fig_poly_point_t	*point,
  double		 x,
  double		 y,
  int			*ec
)
{
  if(point) {
    point->x = dk3ma_d_add_ok(point->x, x, ec);
    point->y = dk3ma_d_add_ok(point->y, y, ec);
  }
}



void
dk3fig_tool_shift_spoint(
  dk3_fig_spline_point_t	*point,
  double			 x,
  double			 y,
  int				*ec
)
{
  if(point) {
    point->x = dk3ma_d_add_ok(point->x, x, ec);
    point->y = dk3ma_d_add_ok(point->y, y, ec);
  }
}



int
dk3fig_tool_font_compare(void const *l, void const *r, int cr)
{
  int		 	 back = 0;
  dk3_fig_font_t const	*pl;		/* Left pointer. */
  dk3_fig_font_t const	*pr;		/* Right pointer. */
  if(l) {
    if(r) {
    } else {
      pl = (dk3_fig_font_t const *)l;
      pr = (dk3_fig_font_t const *)r;
      if(pl->psfont > pr->psfont) {
        back = 1;
      } else {
        if(pl->psfont < pr->psfont) {
	  back = -1;
	} else {
          if(pl->fontno > pr->fontno) {
            back = 1;
          } else {
            if(pl->fontno < pr->fontno) {
	      back = -1;
	    } else {
	      if(pl->fontsz > (pr->fontsz + 1.0e-6)) {
	        back = 1;
	      } else {
	        if(pl->fontsz < (pr->fontsz - 1.0e-6)) {
	          back = -1;
	        }
	      }
	    }
          }
	}
      }
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  }
  return back;
}



int
dk3fig_tool_ps_font_number(dk3_fig_obj_t *obj)
{
  int		 back = -1;
  int		 ff;		/* Font flags. */

  if(obj) {
    if(DK3_FIG_OBJ_TEXT == obj->ot) {
      ff = (obj->dt).txt.ff;
      if(!(ff & DK3_FIG_FONT_FLAG_HIDDEN)) {
        if(!(ff & DK3_FIG_FONT_FLAG_SPECIAL)) {
          if(ff & DK3_FIG_FONT_FLAG_PS) {
            back = (obj->dt).txt.fo;
	  } else {
	    switch((obj->dt).txt.fo) {
	      case DK3_FIG_FONT_LATEX_BOLD: { back = 2; } break;
	      case DK3_FIG_FONT_LATEX_ITALIC: { back = 1; } break;
	      case DK3_FIG_FONT_LATEX_SANS_SERIF: { back = 16; } break;
	      case DK3_FIG_FONT_LATEX_TYPEWRITER: { back = 12; } break;
	      default: { back = 0; } break;
	    }
	  }
        }
      }
    }
  }
  return back;
}



int
dk3fig_tool_must_set_color(
  int		hc1,
  double	r1,
  double	g1,
  double	b1,
  double	r2,
  double	g2,
  double	b2
)
{
  int		 back = 1;
  int		 ec = 0;	/* Mathematical error code. */

  if(hc1) {
    if(1.0e-6 > fabs(dk3ma_d_sub_ok(r1, r2, &ec))) {
      if(1.0e-6 > fabs(dk3ma_d_sub_ok(g1, g2, &ec))) {
        if(1.0e-6 > fabs(dk3ma_d_sub_ok(b1, b2, &ec))) {
	  if(0 == ec) {
	    back = 0;
	  }
	}
      }
    }
  }
  return back;
}



int
dk3fig_tool_must_set_font(
  int		hfn,
  int		ofn,
  double	ofs,
  int		nfn,
  double	nfs
)
{
  int		 back = 1;
  int		 ec = 0;	/* Mathematical error code. */

  if(hfn) {
    if(ofn == nfn) {
      if(1.0e-6 > fabs(dk3ma_d_sub_ok(ofs, nfs, &ec))) {
        if(0 == ec) {
	  back = 0;
	}
      }
    }
  }
  return back;
}



/**	Compare two text handling structures.
	@param	l	Left text handling structure.
	@param	r	Right text handling structure.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
int
dk3fig_tool_text_handling_compare(void const *l, void const *r, int cr)
{
  f2l_text_handling_t const	*pl;		/* Left pointer. */
  f2l_text_handling_t const	*pr;		/* Right pointer. */
  int				 back = 0;

  if(l) {
    if(r) {
      pl = (f2l_text_handling_t const *)l;
      pr = (f2l_text_handling_t const *)r;
      if(pl->psFontNo > pr->psFontNo) {
        back = 1;
      } else {
        if(pl->psFontNo < pr->psFontNo) {
	  back = -1;
	}
      }
      if(0 == back) {
        if(pl->fontSize > (pr->fontSize + 1.0e-6)) {
	  back = 1;
	} else {
	  if(pr->fontSize > (pl->fontSize + 1.0e-6)) {
	    back = -1;
	  }
	}
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



char const *
dk3fig_tool_short_output_file_name(
  dkChar const		*fullName,
  dk3_app_t		*app
)
{
  char			 buf[DK3_MAX_PATH];	/* Conversion buffer. */
  dkChar const		*snptr;			/* Start of old short name. */
  dkChar const		*ptr;			/* Traverse fullName. */
  char const		*back	= NULL;
  int			 res = 0;		/* Operation result. */
  

#line 1117 "dk3figto.ctr"
  if(fullName) {
    snptr = NULL; ptr = fullName;
    while(*ptr) {
      if((*ptr == dkT('/')) || (*ptr == dkT('\\'))) {
        snptr = ptr;
      }
      ptr++;
    }
    if(snptr) {
      snptr++;
    } else {
      snptr = fullName;
    }
    if(snptr) {
      switch(dk3app_get_encoding(app)) {
	case DK3_ENCODING_UTF8: {
	  res = dk3str_to_c8u_app(
	    buf, sizeof(buf), snptr, dk3app_get_encoding(app), app
	  );
	} break;
	default: {
	  res = dk3str_to_c8p_app(
	    buf, sizeof(buf), snptr, dk3app_get_encoding(app), app
	  );
	} break;
      }
      if(res) {
        back = dk3str_c8_dup_app(buf, app);
      }
    }
  } 

#line 1148 "dk3figto.ctr"
  return back;
}

