/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figrd.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figrd.c The dk3figrd module.
*/


#line 45 "dk3figrd.ctr"

#include "dk3all.h"
#include "dk3fig.h"
#include "dk3figrd.h"
#include "fig2lat.h"





#line 54 "dk3figrd.ctr"



/**	Keywords used by the module, not localized.
*/
static dkChar const * const	dk3figrd_kw[] = {
/* 0 */
dkT("r"),

NULL


#line 66 "dk3figrd.ctr"
};


/**	Keywords used by the module.
*/
static char const * const	dk3figrd_c8_kw[] = {
/* 0 */
"C",

/* 1 */
"Created",

/* 2 */
"by",

/* 3 */
"WinFIG",

NULL


#line 84 "dk3figrd.ctr"
};


/**	File type tag at start of file.
*/
static char const dk3figrd_file_start_tag[] = { "#FIG 3.2" };



/**	Error reporting function.
	@param	drw	Drawing structure.
	@param	res	Operation result (1=success, 0=error).
	@param	ec	Error code (1=syntax, 2=memory, 3=redefinition).
*/
static
void
dk3figrd_report_error_code(dk3_fig_drawing_t *drw, int res, int ec)
{
  if(!(res)) {
    switch(ec) {
      case 1: {
        /* ERROR: Syntax */
        dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
      } break;
      case 2: {
        /* ERROR: Memory */
	dk3app_log_i1(drw->app, DK3_LL_ERROR, 9);
      } break;
      case 3: {
        /* ERROR: Color redefinition */
        dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 2);
      } break;
    }
  }
}



/**	Expect file identifier.
	@param	drw	Drawing to modify.
	@param	lp	Text line to process.
	@return	1 on success (identifier found or comment line).
*/
static
int
dk3figrd_expect_start(dk3_fig_drawing_t *drw, char *lp)
{
  int		 back = 0;
  

#line 133 "dk3figrd.ctr"
  if('#' == *lp) {
    back = 1;
    if(7 < dk3str_c8_len(lp)) {
      if(0 == dk3str_c8_ncmp(lp, dk3figrd_file_start_tag, 8)) {
        drw->state = DK3_FIG_RD_STATE_EXPECT_ORIENTATION;
      } else {					

#line 139 "dk3figrd.ctr"
      }
    } else {					

#line 141 "dk3figrd.ctr"
    }
  } else {					

#line 143 "dk3figrd.ctr"
  }
  if(!(back)) {
    dk3fig_set_ec(drw, DK3_ERROR_SYNTAX);
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
  } 

#line 148 "dk3figrd.ctr"
  return back;
}



/**	Retrieve transparent color number.
	@param	drw	Drawing to modify.
	@param	lp	Text line to process.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_expect_transparent(dk3_fig_drawing_t *drw, char *lp)
{
  int		 back = 0;
  int		 i;
  if(1 == sscanf(lp, "%d", &i)) {
    back = 1;
    drw->state = DK3_FIG_RD_STATE_EXPECT_RESOLUTION;
    drw->transcol = i;		

#line 168 "dk3figrd.ctr"
  } else {
    dk3fig_set_ec(drw, DK3_ERROR_SYNTAX);
    /* ERROR: Not a number! */
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
  }
  return back;
}



/**	Retrieve resolution.
	@param	drw	Drawing to modify.
	@param	lp	Text line to process.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_expect_resolution(dk3_fig_drawing_t *drw, char *lp)
{
  long		 lres;
  int		 back = 0;
  if(1 == sscanf(lp, "%ld", &lres)) {
    if(0L < lres) {
      drw->lres = lres;
#if VERSION_BEFORE_20140716
      drw->res = dk3ma_l_to_d(lres);
#else
      drw->res = (double)lres;
#endif
      back = 1;
      drw->state = DK3_FIG_RD_STATE_READY;
    }
  }
  if(!(back)) { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); }
  dk3figrd_report_error_code(drw, back, 1);
  return back;
}



/**	Get a hexadecimal digit.
	@param	c	Character to process.
	@param	x	Pointer to result variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_hex_digit(char c, int *x)
{
  int		 back = 0;
  switch(c) {
    case '0': { *x =  0; back = 1; } break;
    case '1': { *x =  1; back = 1; } break;
    case '2': { *x =  2; back = 1; } break;
    case '3': { *x =  3; back = 1; } break;
    case '4': { *x =  4; back = 1; } break;
    case '5': { *x =  5; back = 1; } break;
    case '6': { *x =  6; back = 1; } break;
    case '7': { *x =  7; back = 1; } break;
    case '8': { *x =  8; back = 1; } break;
    case '9': { *x =  9; back = 1; } break;
    case 'a': { *x = 10; back = 1; } break;
    case 'A': { *x = 10; back = 1; } break;
    case 'b': { *x = 11; back = 1; } break;
    case 'B': { *x = 11; back = 1; } break;
    case 'c': { *x = 12; back = 1; } break;
    case 'C': { *x = 12; back = 1; } break;
    case 'd': { *x = 13; back = 1; } break;
    case 'D': { *x = 13; back = 1; } break;
    case 'e': { *x = 14; back = 1; } break;
    case 'E': { *x = 14; back = 1; } break;
    case 'f': { *x = 15; back = 1; } break;
    case 'F': { *x = 15; back = 1; } break;
  }
  return back;
}



/**	Read color object.
	@param	drw	Drawing to modify.
	@param	args	Arguments in color line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_color_object(dk3_fig_drawing_t *drw, char *args)
{
  dk3_fig_color_t	 col;	/* Temporary buffer. */
  dk3_fig_color_t	*pcol;	/* Object found in storage. */
  char			*pn;	/* Next word to process. */
  int			 x;	/* Temporary variable. */
  int			 back = 0;
  int			 ec = 1;	/* 1=syntax, 2=memory, 3=redef  */
  

#line 263 "dk3figrd.ctr"
  if(args) {
    pn = dk3str_c8_next(args, NULL);
    if(pn) {
      if(1 == sscanf(args, "%d", &(col.i))) {
        if(31 < col.i) {
	  if('#' == *(pn++)) {
	    col.r = col.g = col.b = x = 0;
	    if(dk3figrd_hex_digit(*(pn++), &x)) {
	      col.r = x;
	      if(dk3figrd_hex_digit(*(pn++), &x)) {
	        col.r = 16 * col.r + x;
		if(dk3figrd_hex_digit(*(pn++), &x)) {
		  col.g = x;
		  if(dk3figrd_hex_digit(*(pn++), &x)) {
		    col.g = 16 * col.g + x;
		    if(dk3figrd_hex_digit(*(pn++), &x)) {
		      col.b = x;
		      if(dk3figrd_hex_digit(*(pn++), &x)) {
		        col.b = 16 * col.b + x;
			if(dk3sto_it_find_like(drw->icol, (void *)(&col), 0)) {
			  ec = 3;
			} else {
			  pcol = dk3_new_app(dk3_fig_color_t,1,drw->app);
			  if(pcol) {
			    /*	2013-01-15: Copy color data to new buffer!
			    */
			    dk3mem_cpy(
			      (void *)pcol, (void *)(&col),
			      sizeof(dk3_fig_color_t)
			    );
			    if(dk3sto_add(drw->scol, (void *)pcol)) {
			      back = 1;
			    } else {
			      dk3_delete(pcol);
			      ec = 2;
			    }
			  } else {
			    ec = 2;
			  }
			}
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
    }
  }
  if(!(back)) {
    switch(ec) {
      case 1: case 3: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 322 "dk3figrd.ctr"
  return back;
}



/**	Complete arc.
	@param	drw	Drawing to modify.
	@param	tobj	Object to complete.
	@param	args	Object arguments in start line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_arc_complete(dk3_fig_drawing_t *drw, dk3_fig_obj_t *tobj, char *args)
{
  dk3_fig_obj_t		*pobj;		/* New object. */
  char			*pc;		/* Current text word to process. */
  char			*pn;		/* Next text word to process. */
  int			 i;		/* Index of current text word. */
  int			 af = 0;	/* Flag: Arrowhead forward. */
  int			 ab = 0;	/* Flag: Arrowhead backward. */
  int			 ec = 1;	/* Error code. */
  int			 back = 1;
  

#line 346 "dk3figrd.ctr"
  pc = args;
  for(i = 0; ((back) && (pc) && (i < 12)); i++) {
    pn = dk3str_c8_next(pc, NULL);
    switch(i) {
      case 0: {	/* int  cap style */
        if(1 != sscanf(pc, "%d", &(tobj->cs))) {	

#line 352 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 1: {	/* int  direction 0=clockwise, ignored */
      } break;
      case 2: {	/* int  arrow forward */
        if(1 != sscanf(pc, "%d", &af)) {		

#line 359 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 3: {	/* int  arrow backward */
        if(1 != sscanf(pc, "%d", &ab)) {	

#line 364 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 4: { /* double  cx */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.xc))) {	

#line 369 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 5: { /* double  cy */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.yc))) {	

#line 374 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 6: { /* double  x1 */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.x1))) {	

#line 379 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 7: { /* double  y1 */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.y1))) {	

#line 384 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 8: { /* double  x2 */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.x2))) {	

#line 389 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 9: { /* double  y2 */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.y2))) {	

#line 394 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 10: { /* double x3 */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.x3))) {	

#line 399 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 11: { /* double y3 */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).arc.y3))) {	

#line 404 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
    }
    if(!(pc)) {
      if(i < 11) {					

#line 410 "dk3figrd.ctr"
        back = 0;
      }
    }
    pc = pn;
  }
  if(back) {						

#line 416 "dk3figrd.ctr"
    pobj = dk3fig_obj_new(
      drw->lineno, tobj->la, tobj->ot, tobj->st, tobj->lw, tobj->pc, tobj->fc,
      tobj->fi, tobj->cs, tobj->js, tobj->ls, tobj->sv, af, ab,
      0, NULL, drw->app
    );
    if(pobj) {
      

#line 423 "dk3figrd.ctr"
      

#line 424 "dk3figrd.ctr"
      if(dk3sto_add(drw->sobj, (void *)pobj)) {
        dk3mem_cpy(
	  (void *)(&((pobj->dt).arc)),
	  (void *)(&((tobj->dt).arc)),
	  sizeof(dk3_fig_det_arc_t)
	);
        if(pobj->ab) {
	  drw->state = DK3_FIG_RD_STATE_ARC_ARROW_BACKWARD;
	}
	if(pobj->af) {
	  drw->state = DK3_FIG_RD_STATE_ARC_ARROW_FORWARD;
	}
	drw->cobj = pobj;
      } else {
        back = 0; ec = 2;				

#line 439 "dk3figrd.ctr"
	dk3fig_obj_delete(pobj);
      }
    } else {
      back = 0; ec = 2;					

#line 443 "dk3figrd.ctr"
    }
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 453 "dk3figrd.ctr"
  return back;
}



/**	Complete ellipse.
	@param	drw	Drawing to modify.
	@param	tobj	Object to complete.
	@param	args	Object arguments in start line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_ellipse_complete(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *tobj, char *args
)
{
  dk3_fig_obj_t		*pobj;		/* New object. */
  char			*pc;		/* Current text word to process. */
  char			*pn;		/* Next text to process. */
  int			 i;		/* Index of current text word. */
  int			 ec = 1;	/* Error code. */
  int			 back = 1;
  

#line 477 "dk3figrd.ctr"
  pc = args;
  for(i = 0; ((back) && (pc) && (i < 10)); i++) {
    pn = dk3str_c8_next(pc, NULL);
    switch(i) {
      case 0: {		/* direction, ignored */
      } break;
      case 1: {		/* angle */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).ell.an))) {	

#line 485 "dk3figrd.ctr"
	  back = 0;
	} 

#line 487 "dk3figrd.ctr"
      } break;
      case 2: {		/* cx */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).ell.cx))) {	

#line 490 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 3: {		/* cy */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).ell.cy))) {	

#line 495 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 4: {		/* rx */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).ell.rx))) {	

#line 500 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 5: {		/* ry */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).ell.ry))) {	

#line 505 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 6: {		/* start x */
      } break;
      case 7: {		/* start y */
      } break;
      case 8: {		/* end x */
      } break;
      case 9: {		/* end y */
      } break;
    }
    pc = pn;
    if(!(pc)) {
      if(i < 9) {					

#line 520 "dk3figrd.ctr"
        back = 0;
      }
    }
  }
  if(back) {
    pobj = dk3fig_obj_new(
      drw->lineno, tobj->la, tobj->ot, tobj->st, tobj->lw, tobj->pc, tobj->fc,
      tobj->fi, tobj->cs, tobj->js, tobj->ls, tobj->sv, 0, 0,
      0, NULL, drw->app
    );
    if(pobj) {
      if(dk3sto_add(drw->sobj, (void *)pobj)) {
	dk3mem_cpy(
	  (void *)(&((pobj->dt).ell)),
	  (void *)(&((tobj->dt).ell)),
	  sizeof(dk3_fig_det_ell_t)
	);
      } else {
        back = 0; ec = 2;
	dk3fig_obj_delete(pobj);
      }
    } else {
      back = 0; ec = 2;
    }
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 553 "dk3figrd.ctr"
  return back;
}



/**	Complete polyline.
	@param	drw	Drawing to modify.
	@param	tobj	Object to complete.
	@param	args	Object arguments in start line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_polyline_complete(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *tobj, char *args
)
{
  dk3_fig_obj_t		*pobj;		/* New object. */
  char 			*pc;		/* Current text word to process. */
  char			*pn;		/* Next text to process. */
#if VERSION_BEFORE_20140809
  unsigned		 u;		/* Number of points. */
#endif
  int			 i;		/* Index of current text word. */
  int			 af = 0;	/* Flag: Arrowhead forward. */
  int			 ab = 0;	/* Flag: Arrowhead backward. */
  int			 ec = 1;	/* Error code. */
  int			 back = 1;
  

#line 582 "dk3figrd.ctr"
  pc = args;
  for(i = 0; ((back) && (pc) && (i < 6)); i++) {
    pn = dk3str_c8_next(pc, NULL);
    switch(i) {
      case 0: {		/* js, join style */
        if(1 != sscanf(pc, "%d", &(tobj->js))) {	

#line 588 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 1: {		/* cs, cap style */
        if(1 != sscanf(pc, "%d", &(tobj->cs))) {	

#line 593 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 2: {		/* radius */
        if(1 != sscanf(pc, "%lg", &((tobj->dt).pol.ra))) {	

#line 598 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 3: {		/* af, array forward */
        if(1 != sscanf(pc, "%d", &af)) {		

#line 603 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 4: {		/* ab, array backward */
        if(1 != sscanf(pc, "%d", &ab)) {		

#line 608 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 5:  {	/* Number of points */
#if VERSION_BEFORE_20140809
        if(1 == sscanf(pc, "%u", &u)) {
	  (tobj->dt).pol.np = (size_t)u;
	  if(u != (unsigned)((tobj->dt).pol.np)) {	

#line 616 "dk3figrd.ctr"
	    back = 0;
	  }
	} else {					

#line 619 "dk3figrd.ctr"
	  back = 0;
	}
#else
	dk3_um_t	um	= DK3_UM_0;
	int		mec	= 0;
	if (dk3ma_um_from_c8_string(&um, pc, NULL)) {
	  (tobj->dt).pol.np = dk3ma_um_to_sz(um, &mec);
	  if (0 != mec) {			/* Overflow */
	    back = 0;
	  }
	} else {				/* Not a number */
	  back = 0;
	}
#endif
      } break;
    }
    pc = pn;
    if(!(pc)) {
      if(i < 5) {				

#line 638 "dk3figrd.ctr"
        back = 0;
      }
    }
  }
  if(back) {
    pobj = dk3fig_obj_new(
      drw->lineno, tobj->la, tobj->ot, tobj->st, tobj->lw, tobj->pc, tobj->fc,
      tobj->fi, tobj->cs, tobj->js, tobj->ls, tobj->sv, af, ab,
      (tobj->dt).pol.np, NULL, drw->app
    );
    if(pobj) {
      (pobj->dt).pol.ra = (tobj->dt).pol.ra;
      

#line 651 "dk3figrd.ctr"
      

#line 652 "dk3figrd.ctr"
      if(dk3sto_add(drw->sobj, (void *)pobj)) {
        drw->cobj = pobj;
	drw->cind = 0;
	drw->cxy = 0;
	drw->state = DK3_FIG_RD_STATE_PL_POINTS;
	if(5 == pobj->st) {
	  drw->state = DK3_FIG_RD_STATE_PL_IMAGE;
	}
	if(pobj->ab) {
	  drw->state = DK3_FIG_RD_STATE_PL_ARROW_BACKWARD;
	}
	if(pobj->af) {
	  drw->state = DK3_FIG_RD_STATE_PL_ARROW_FORWARD;
	}
      } else {
        back = 0; ec = 2;			

#line 668 "dk3figrd.ctr"
	dk3fig_obj_delete(pobj);
      }
    } else {
      back = 0; ec = 2;				

#line 672 "dk3figrd.ctr"
    }
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 682 "dk3figrd.ctr"
  return back;
}



/**	Complete spline.
	@param	drw	Drawing to modify.
	@param	tobj	Object to complete.
	@param	args	Object arguments in start line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_spline_complete(dk3_fig_drawing_t *drw,dk3_fig_obj_t *tobj,char *args)
{
  dk3_fig_obj_t		*pobj;		/* New object. */
  char			*pc;		/* Current text word to process. */
  char			*pn;		/* Next text to process. */
#if VERSION_BEFORE_20140809
  unsigned		 u;		/* Number of points. */
#endif
  int			 i;		/* Index of current text word. */
  int			 af = 0;	/* Flag: Arrowhead forward. */
  int			 ab = 0;	/* Flag: Arrowhead backward. */
  int			 ec = 1;	/* Error code. */
  int			 back = 1;
  

#line 709 "dk3figrd.ctr"
  pc = args;
  for(i = 0; ((back) && (pc) && (i < 4)); i++) {
    pn = dk3str_c8_next(pc, NULL);
    switch(i) {
      case 0: {		/* cs, cap style */
	if(1 != sscanf(pc, "%d", &(tobj->cs))) {	

#line 715 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 1: {		/* af, arrowhead forward */
        if(1 != sscanf(pc, "%d", &af)) {		

#line 720 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 2: {		/* ab, arrowhead backward */
        if(1 != sscanf(pc, "%d", &ab)) {		

#line 725 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 3: {		/* np, number of points */
#if VERSION_BEFORE_20140809
        if(1 == sscanf(pc, "%u", &u)) {
	  (tobj->dt).pol.np = (size_t)u;
	  if(u != (unsigned)((tobj->dt).pol.np)) {	

#line 733 "dk3figrd.ctr"
	    back = 0;
	  }
	} else {
	  back = 0;
	}
#else
	dk3_um_t	um	= DK3_UM_0;
	int		mec	= 0;
	if (dk3ma_um_from_c8_string(&um, pc, NULL)) {
	  (tobj->dt).pol.np = dk3ma_um_to_sz(um, &mec);
	  if (0 != mec) {			/* Range overflow */
	    back = 0;
	  }
	} else {				/* Not a number */
	  back = 0;
	}
#endif
      } break;
    }
    pc = pn;
    if(!(pc)) {
      if(i < 3) {
        back = 0;
      }
    }
  }
  if(back) {
    pobj = dk3fig_obj_new(
      drw->lineno, tobj->la, tobj->ot, tobj->st, tobj->lw, tobj->pc, tobj->fc,
      tobj->fi, tobj->cs, 0, tobj->ls, tobj->sv, af, ab,
      (tobj->dt).pol.np, NULL, drw->app
    );
    if(pobj) {
      

#line 767 "dk3figrd.ctr"
      

#line 768 "dk3figrd.ctr"
      if(dk3sto_add(drw->sobj, (void *)pobj)) {
        drw->cobj = pobj;
	drw->cind = 0;
	drw->cxy = 0;
	drw->state = DK3_FIG_RD_STATE_SP_POINTS;
	if(pobj->ab) {
	  drw->state = DK3_FIG_RD_STATE_SP_ARROW_BACKWARD;
	}
	if(pobj->af) {
	  drw->state = DK3_FIG_RD_STATE_SP_ARROW_FORWARD;
	}
      } else {					

#line 780 "dk3figrd.ctr"
        back = 0; ec = 2;
	dk3fig_obj_delete(pobj);
      }
    } else {					

#line 784 "dk3figrd.ctr"
      back = 0; ec = 2;
    }
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 795 "dk3figrd.ctr"
  return back;
}



/**	Read graphics element.
	@param	drw	Drawing to modify.
	@param	ot	Object type.
	@param	args	Object arguments in start line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_path_object(dk3_fig_drawing_t *drw, int ot, char *args)
{
  dk3_fig_obj_t		 tobj;	/* Buffer object. */
  char			*pc;	/* Current text word to process. */
  char			*pn;	/* Next text to process. */
  int			 i;	/* Index of current text word. */
  int			 back = 0;
  

#line 816 "dk3figrd.ctr"
  if(args) {
    dk3fig_obj_init(&tobj);
    tobj.ot = ot;
    back = 1;
    pc = args;
    for(i = 0; ((back) && (pc) && (i < 9)); i++) {
      pn = dk3str_c8_next(pc, NULL);
      switch(i) {
        case 0: {	/* st: sub type */
	  if(1 != sscanf(pc, "%d", &(tobj.st))) {	

#line 826 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw, DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
            dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }		

#line 831 "dk3figrd.ctr"
	} break;
	case 1: {	/* ls: line style: int */
	  if(1 != sscanf(pc, "%d", &(tobj.ls))) {	

#line 834 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw, DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
	case 2: {	/* lw: line thickness: int */
	  if(1 != sscanf(pc, "%d", &(tobj.lw))) {	

#line 842 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw, DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
	case 3: {	/* pc: pen color: int */
	  if(1 != sscanf(pc, "%d", &(tobj.pc))) {	

#line 850 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
	case 4: {	/* fc: fill color: int */
	  if(1 != sscanf(pc, "%d", &(tobj.fc))) {	

#line 858 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
	case 5: {	/* la: depth: int */
	  if(1 != sscanf(pc, "%d", &(tobj.la))) {	

#line 866 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
	case 6: {	/* pen style: int, unused */
	} break;
	case 7: {	/* fi: area fill: int */
	  if(1 != sscanf(pc, "%d", &(tobj.fi))) {	

#line 876 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
	case 8: {	/* sv: style value: double */
	  if(1 != sscanf(pc, "%lg", &(tobj.sv))) {	

#line 884 "dk3figrd.ctr"
	    back = 0;
	    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	    /* ERROR: Syntax */
	    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
	  }
	} break;
      }
      pc = pn;
      if(!(pc)) {					

#line 893 "dk3figrd.ctr"
        back = 0;
	dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	/* ERROR: Syntax */
	dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
      }
    }
    if((back) && (pc)) {
      

#line 901 "dk3figrd.ctr"
      switch(ot) {
        case DK3_FIG_OBJ_ARC: {
	  back = dk3figrd_arc_complete(drw, &tobj, pc);
	} break;
	case DK3_FIG_OBJ_ELLIPSE: {
	  back = dk3figrd_ellipse_complete(drw, &tobj, pc);
	} break;
	case DK3_FIG_OBJ_POLYLINE: {
	  back = dk3figrd_polyline_complete(drw, &tobj, pc);
	} break;
	case DK3_FIG_OBJ_SPLINE: {
	  back = dk3figrd_spline_complete(drw, &tobj, pc);
	} break;
      }
    } else {
      /* ERROR: Syntax */
      dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
      dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
    }
  } else {
    /* ERROR: Missing arguments! */
    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
  } 

#line 925 "dk3figrd.ctr"
  return back;
}



/**	Copy string from right to left while resolving escape sequences.
	Destination and source source address point to the same buffer
	but src must point somewhere right from dst.
	@param	dst	Destination pointer.
	@param	src	Source pointer.
*/
static
void
dk3figrd_string_copy_to_left(char *dst, char *src)
{
  char *pd;	/* Current destination pointer. */
  char *ps;	/* Current source pointer. */
  pd = dst; ps = src;
  while(*ps) { *(pd++) = *(ps++); }
  *pd = '\0';
}



/**	Squeeze Fig string (resolve octal codes and backslash escapes).
	@param	str	String to modify.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_squeeze_string(char *str)
{
  char		*ptr;		/* Current character to process. */
  int		 i1 = 0;	/* First octal value. */
  int		 i2 = 0;	/* Second octal value. */
  int		 i3 = 0;	/* Third octal value. */
  int		 back = 1;
  

#line 963 "dk3figrd.ctr"
  ptr = str;
  while((back) && (*ptr)) {			

#line 965 "dk3figrd.ctr"
    if('\\' == *ptr) {				

#line 966 "dk3figrd.ctr"
      if((ptr[1] >= '0') && (ptr[1] <= '3')) {
        if((ptr[2] >= '0') && (ptr[2] <= '7')) {
	  if((ptr[3] >= '0') && (ptr[3] <= '7')) {	

#line 969 "dk3figrd.ctr"
	    i1 = i2 = i3 = 0;
	    (void)dk3figrd_hex_digit(ptr[1], &i1);	

#line 971 "dk3figrd.ctr"
	    (void)dk3figrd_hex_digit(ptr[2], &i2);	

#line 972 "dk3figrd.ctr"
	    (void)dk3figrd_hex_digit(ptr[3], &i3);	

#line 973 "dk3figrd.ctr"
	    

#line 974 "dk3figrd.ctr"
	    *ptr = (char)(64 * i1 + 8 * i2 + i3);
	    dk3figrd_string_copy_to_left(&(ptr[1]), &(ptr[4]));
	    if(0x01 == *ptr) {
	      *ptr = '\0';
	    } else {
	      ptr++;
	    }
	  } else {				

#line 982 "dk3figrd.ctr"
	    back = 0;
	  }
        } else {
	  back = 0;				

#line 986 "dk3figrd.ctr"
	}
      } else {
        switch(ptr[1]) {
	  case '\0': {
	    *ptr = '\0';
	  } break;
	  case 'r': {
	    *ptr = '\r';
	    dk3figrd_string_copy_to_left(&(ptr[1]), &(ptr[2]));
	    ptr++;
	  } break;
	  case 'n': {
	    *ptr = '\n';
	    dk3figrd_string_copy_to_left(&(ptr[1]), &(ptr[2]));
	    ptr++;
	  } break;
	  case 'a': {
	    *ptr = '\a';
	    dk3figrd_string_copy_to_left(&(ptr[1]), &(ptr[2]));
	    ptr++;
	  } break;
	  default: {
	    dk3figrd_string_copy_to_left(ptr, &(ptr[1]));
	    ptr++;
	  } break;
	}
      }
    } else {					

#line 1014 "dk3figrd.ctr"
      ptr++;
    }
  }
  if(!(back)) {
  } 

#line 1019 "dk3figrd.ctr"
  return back;
}



/**	Read text element.
	@param	drw	Drawing to modify.
	@param	args	Object arguments in start line.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_text_object(dk3_fig_drawing_t *drw, char *args)
{
  dk3_fig_obj_t		 tobj;		/* Buffer object. */
  dk3_fig_obj_t		*pobj = NULL;	/* New object. */
  char			*pc;		/* Current text word to process. */
  char			*pn;		/* Next text to process. */
  int			 back = 0;
  int			 ec = 1;	/* 1=syntax, 2=memory */
  int			 i;		/* Index of current text word. */
  

#line 1041 "dk3figrd.ctr"
  if(args) {
    dk3fig_obj_init(&tobj);
    tobj.ot = DK3_FIG_OBJ_TEXT;
    back = 1;
    pc = args; pn = NULL;
    for(i = 0; ((back) && (pc) && (i < 12)); i++) {
      pn = dk3str_c8_next(pc, NULL);
      switch(i) {
        case 0: {	/* sub type */
	  if(1 != sscanf(pc, "%d", &(tobj.st))) {	

#line 1051 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 1: {	/* color */
	  if(1 != sscanf(pc, "%d", &(tobj.pc))) {	

#line 1056 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 2: {	/* depth (layer) */
	  if(1 != sscanf(pc, "%d", &(tobj.la))) {	

#line 1061 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 3: {	/* pen style, unused */
	} break;
	case 4: {	/* font */
	  if(1 != sscanf(pc, "%d", &(tobj.dt.txt.fo))) {	

#line 1068 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 5: {	/* font size */
	  if(1 == sscanf(pc, "%lg", &(tobj.dt.txt.fs))) {	

#line 1073 "dk3figrd.ctr"
	    if(tobj.dt.txt.fs < 0.0) {				

#line 1074 "dk3figrd.ctr"
	      back = 0;
	    }
	  } else {						

#line 1077 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 6: {	/* angle */
	  if(1 != sscanf(pc, "%lg", &(tobj.dt.txt.an))) {	

#line 1082 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 7: {	/* font flags */
	  if(1 != sscanf(pc, "%d", &(tobj.dt.txt.ff))) {	

#line 1087 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 8: {	/* height */
	} break;
	case 9: {	/* length */
	} break;
	case 10: {	/* x */
	  if(1 != sscanf(pc, "%lg", &(tobj.dt.txt.x))) {	

#line 1096 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
	case 11: {	/* y */
	  if(1 != sscanf(pc, "%lg", &(tobj.dt.txt.y))) {	

#line 1101 "dk3figrd.ctr"
	    back = 0;
	  }
	} break;
      }
      pc = pn;
      if(!(pc)) {						

#line 1107 "dk3figrd.ctr"
        back = 0;
      }
    }
    if((pc) && (back)) {
      if(dk3figrd_squeeze_string(pc)) {
        pobj = dk3fig_obj_new(
	  drw->lineno, tobj.la, tobj.ot, tobj.st, 0, tobj.pc,
	  0, 0, 0, 0, 0, 0.0, 0, 0, 0, pc, drw->app
	);
	if(pobj) {
	  if(dk3sto_add(drw->sobj, (void *)pobj)) {
	    (pobj->dt).txt.x  = tobj.dt.txt.x;
	    (pobj->dt).txt.y  = tobj.dt.txt.y;
	    (pobj->dt).txt.an = tobj.dt.txt.an;
	    (pobj->dt).txt.fs = tobj.dt.txt.fs;
	    (pobj->dt).txt.he = tobj.dt.txt.he;
	    (pobj->dt).txt.wi = tobj.dt.txt.wi;
	    (pobj->dt).txt.fo = tobj.dt.txt.fo;
	    (pobj->dt).txt.ff = tobj.dt.txt.ff;
	  } else {
	    back = 0; ec = 2;					

#line 1128 "dk3figrd.ctr"
	    dk3fig_obj_delete(pobj);
	  }
	} else {
	  back = 0; ec = 2;					

#line 1132 "dk3figrd.ctr"
	}
      } else {
        dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
        back = 0;			

#line 1136 "dk3figrd.ctr"
      }
    }
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 1147 "dk3figrd.ctr"
  return back;
}




/**	Read start line of an object.
	@param	drw	Drawing to modify.
	@param	lp	Text line to process.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_start_object(dk3_fig_drawing_t *drw, char *lp)
{
  char		*pn;		/* Pointer to text after object type. */
  int		 ot = 0;	/* Object type. */
  int		 back = 0;
  

#line 1166 "dk3figrd.ctr"
  pn = dk3str_c8_next(lp, NULL);
  if(1 == sscanf(lp, "%d", &ot)) {
    switch(ot) {
      case DK3_FIG_OBJ_COLOR: {
        back = dk3figrd_color_object(drw, pn);
      } break;
      case DK3_FIG_OBJ_ARC:
      case DK3_FIG_OBJ_ELLIPSE:
      case DK3_FIG_OBJ_POLYLINE:
      case DK3_FIG_OBJ_SPLINE:
      {
        back = dk3figrd_path_object(drw, ot, pn);
      } break;
      case DK3_FIG_OBJ_TEXT: {
        back = dk3figrd_text_object(drw, pn);
      } break;
      case DK3_FIG_OBJ_COMPOUND: {
        back = 1;
      } break;
      case DK3_FIG_OBJ_ENDCOMPOUND: {
        back = 1;
      } break;
    }
  } else {
    /* Syntax error, no numeric object type! */
    dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 1);
  }
  

#line 1195 "dk3figrd.ctr"
  return back;
}



/**	Read arrowhead line.
	@param	drw	Drawing.
	@param	obj	Current object.
	@param	ah	Arrowhead structure to fill.
	@param	lp	Text containing arrowhead information.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_arrowhead(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  char			*lp
)
{
  char		*pc;	/* Current text word to process. */
  char		*pn;	/* Next text to process. */
  int		 i;	/* Index of current text word. */
  int		 back = 1;
  

#line 1221 "dk3figrd.ctr"
  pc = dk3str_c8_start(lp, NULL);
  for(i = 0; ((back) && (pc) && (i < 5)); i++) {
    pn = dk3str_c8_next(pc, NULL);
    switch(i) {
      case 0: {		/* arrow type */
	if(1 != sscanf(pc, "%d", &(ah->as))) {		

#line 1227 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 1: {		/* arrow style */
        if(1 != sscanf(pc, "%d", &(ah->af))) {		

#line 1232 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 2: {		/* thickness (ignored, linewidth used) */
      } break;
      case 3: {		/* width */
        if(1 != sscanf(pc, "%lg", &(ah->wi))) {		

#line 1239 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
      case 4: {		/* height */
        if(1 != sscanf(pc, "%lg", &(ah->he))) {		

#line 1244 "dk3figrd.ctr"
	  back = 0;
	}
      } break;
    }
    pc = pn;
    if(!(pc)) {
      if(i < 4) {				

#line 1251 "dk3figrd.ctr"
        back = 0;
      }
    }
  } 

#line 1255 "dk3figrd.ctr"
  return back;
}



/**	Attach arrowhead information to arc.
	@param	drw	Drawing to modify.
	@param	lp	Text line containing arrowhead information.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_arc_arrow(dk3_fig_drawing_t *drw, char *lp)
{
  int	 ec = 1;	/* Error code. */
  int	 ostate;	/* Old object reader state. */
  int	 back = 0;
  

#line 1273 "dk3figrd.ctr"
  ostate = drw->state;
  if(drw->cobj) {
    switch(ostate) {
      case DK3_FIG_RD_STATE_ARC_ARROW_BACKWARD: {
        if((drw->cobj)->ab) {
	  back = dk3figrd_arrowhead(drw, drw->cobj, (drw->cobj)->ab, lp);
	} else {				

#line 1280 "dk3figrd.ctr"
	}
      } break;
      default: {
        if((drw->cobj)->af) {
	  back = dk3figrd_arrowhead(drw, drw->cobj, (drw->cobj)->af, lp);
	} else {				

#line 1286 "dk3figrd.ctr"
	}
      } break;
    }
    drw->state = DK3_FIG_RD_STATE_READY;
    switch(ostate) {
      case DK3_FIG_RD_STATE_ARC_ARROW_FORWARD: {
        if((drw->cobj)->ab) {
	  drw->state = DK3_FIG_RD_STATE_ARC_ARROW_BACKWARD;
	}
      } break;
    }
  } else {					

#line 1298 "dk3figrd.ctr"
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);	

#line 1306 "dk3figrd.ctr"
  return back;
}



/**	Attach arrowhead information to polyline.
	@param	drw	Drawing to modify.
	@param	lp	Text line containing arrowhead information.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_polyline_arrow(dk3_fig_drawing_t *drw, char *lp)
{
  int	 ostate;	/* Old object reader state. */
  int	 ec = 1;	/* Error code. */
  int	 back = 0;
  

#line 1324 "dk3figrd.ctr"
  ostate = drw->state;
  if(drw->cobj) {
    switch(ostate) {
      case DK3_FIG_RD_STATE_PL_ARROW_BACKWARD: {
        if((drw->cobj)->ab) {
	  back = dk3figrd_arrowhead(drw, drw->cobj, (drw->cobj)->ab, lp);
	} else {				

#line 1331 "dk3figrd.ctr"
	}
      } break;
      default: {
        if((drw->cobj)->af) {
	  back = dk3figrd_arrowhead(drw, drw->cobj, (drw->cobj)->af, lp);
	} else {				

#line 1337 "dk3figrd.ctr"
	}
      } break;
    }
    drw->state = DK3_FIG_RD_STATE_PL_POINTS;
    if(5 == (drw->cobj)->st) {
      drw->state = DK3_FIG_RD_STATE_PL_IMAGE;
    }
    switch(ostate) {
      case DK3_FIG_RD_STATE_PL_ARROW_FORWARD: {
        if((drw->cobj)->ab) {
	  drw->state = DK3_FIG_RD_STATE_PL_ARROW_BACKWARD;
	}
      } break;
    }
  } else {					

#line 1352 "dk3figrd.ctr"
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 1361 "dk3figrd.ctr"
  return back;
}



/**	Attach arrowhead information to spline.
	@param	drw	Drawing to modify.
	@param	lp	Text line containing arrowhead information.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_spline_arrow(dk3_fig_drawing_t *drw, char *lp)
{
  int	 ostate;	/* Old object reader state. */
  int	 ec = 1;	/* Error code. */
  int	 back = 0;
  

#line 1379 "dk3figrd.ctr"
  ostate = drw->state;
  if(drw->cobj) {
    switch(ostate) {
      case DK3_FIG_RD_STATE_SP_ARROW_BACKWARD: {
        if((drw->cobj)->ab) {
	  back = dk3figrd_arrowhead(drw, drw->cobj, (drw->cobj)->ab, lp);
	} else {				

#line 1386 "dk3figrd.ctr"
	}
      } break;
      default: {
        if((drw->cobj)->af) {
	  back = dk3figrd_arrowhead(drw, drw->cobj, (drw->cobj)->af, lp);
	} else {				

#line 1392 "dk3figrd.ctr"
	}
      } break;
    }
    drw->state = DK3_FIG_RD_STATE_SP_POINTS;
    switch(ostate) {
      case DK3_FIG_RD_STATE_SP_ARROW_FORWARD: {
        if((drw->cobj)->ab) {
	  drw->state = DK3_FIG_RD_STATE_SP_ARROW_BACKWARD;
	}
      } break;
    }
  } else {					

#line 1404 "dk3figrd.ctr"
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 1413 "dk3figrd.ctr"
  return back;
}



/**	Read image line for a polyline object.
	@param	drw	Drawing to modify.
	@param	lp	Text line containing image information.
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_polyline_image(dk3_fig_drawing_t *drw, char *lp)
{
  char	*p1;		/* Text for flipped-flag. */
  char	*p2;		/* File name. */
  int	 i;		/* Flag: Flipped. */
  int	 ec = 1;	/* Error code. */
  int	 back = 0;
  

#line 1433 "dk3figrd.ctr"
  if(drw->cobj) {
    p1 = dk3str_c8_start(lp, NULL);
    if(p1) {
      p2 = dk3str_c8_next(p1, NULL);
      if(p2) {
        if(1 == sscanf(p1, "%d", &i)) {
	  ((drw->cobj)->dt).pol.flf = ((i) ? 1 : 0);
	  if(!(((drw->cobj)->dt).pol.fn)) {
	    ((drw->cobj)->dt).pol.fn = dk3str_c8_dup_app(p2, drw->app);
	    if(((drw->cobj)->dt).pol.fn) {
	      back = 1;
	      drw->state = DK3_FIG_RD_STATE_PL_POINTS;
	    } else {
	      ec = 2;
	    }
	  }
        }
      }
    } 
  } else {						

#line 1453 "dk3figrd.ctr"
  }
  if(!(back)) {
    switch(ec) {
      case 1: { dk3fig_set_ec(drw, DK3_ERROR_SYNTAX); } break;
      case 2: { dk3fig_set_ec(drw, DK3_ERROR_MEMORY); } break;
    }
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 1462 "dk3figrd.ctr"
  return back;
}



/**	Read point data or control data.
	@param	drw
	@param	lp
	@return	1 on success, 0 on error.
*/
static
int
dk3figrd_point_data(dk3_fig_drawing_t *drw, char *lp)
{
  dk3_fig_poly_point_t		*pp = NULL;	/* Point to read. */
  dk3_fig_spline_point_t	*sp = NULL;	/* Point to read. */
  char				*pc;		/* Current text word. */
  char				*pn;		/* Next text. */
  double			 d;		/* Result sscanf(). */
  int				 cc = 1;	/* Flag: Can continue. */
  int				 ec = 1;	/* Error code. */
  int				 back = 1;
  

#line 1485 "dk3figrd.ctr"
  if(drw->cobj) {
    switch((drw->cobj)->ot) {
      case DK3_FIG_OBJ_POLYLINE: {
        pp = ((drw->cobj)->dt).pol.po;
	if(!(pp)) { back = 0; dk3fig_set_ec(drw, DK3_ERROR_DATA_DAMAGED); }
      } break;
      case DK3_FIG_OBJ_SPLINE: {
        sp = ((drw->cobj)->dt).spl.po;
	if(!(sp)) { back = 0; dk3fig_set_ec(drw, DK3_ERROR_DATA_DAMAGED); }
      } break;
      default: {
        back = 0; dk3fig_set_ec(drw, DK3_ERROR_DATA_DAMAGED); 

#line 1497 "dk3figrd.ctr"
	} break;
    }
    if(back) {
      pc = dk3str_c8_start(lp, NULL);
      while((cc) && (back) && (pc)) {
        pn = dk3str_c8_next(pc, NULL);		

#line 1503 "dk3figrd.ctr"
	if(1 == sscanf(pc, "%lg", &d)) {
	  switch((drw->cobj)->ot) {
	    case DK3_FIG_OBJ_POLYLINE: {
	      if(drw->cind < ((drw->cobj)->dt).pol.np) {
	        if(drw->cxy) {	

#line 1508 "dk3figrd.ctr"
		  pp[drw->cind].y = d;
		  drw->cxy = 0;
		  drw->cind += 1;
		} else {	

#line 1512 "dk3figrd.ctr"
		  pp[drw->cind].x = d;
		  drw->cxy = 1;
		}
	      }
	      if(drw->cind >= ((drw->cobj)->dt).pol.np) {
	        drw->state = DK3_FIG_RD_STATE_READY;
		cc = 0;
	      }
	    } break;
	    case DK3_FIG_OBJ_SPLINE: {
	      if(DK3_FIG_RD_STATE_SP_CONTROL == drw->state) {
	        if(drw->cind < ((drw->cobj)->dt).spl.np) {
		  sp[drw->cind].s = d; 

#line 1525 "dk3figrd.ctr"
		  drw->cind += 1;
		}
		if(drw->cind >= ((drw->cobj)->dt).spl.np) {
		  drw->state = DK3_FIG_RD_STATE_READY;
		  cc = 0;
		}
	      } else {
	        if(drw->cind < ((drw->cobj)->dt).spl.np) {
		  if(drw->cxy) { 

#line 1534 "dk3figrd.ctr"
		    sp[drw->cind].y = d;
		    drw->cxy = 0;
		    drw->cind += 1;
		  } else {	 

#line 1538 "dk3figrd.ctr"
		    sp[drw->cind].x = d;
		    drw->cxy = 1;
		  }
		}
		if(drw->cind >= ((drw->cobj)->dt).spl.np) {
		  drw->state = DK3_FIG_RD_STATE_SP_CONTROL;
		  drw->cind = 0;
		  drw->cxy = 0;	 

#line 1546 "dk3figrd.ctr"
		}
	      }
	    } break;
	  }
	} else {
	  cc = 0;
	  dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
	}
        pc = pn;
      }
    }
  } else {					

#line 1558 "dk3figrd.ctr"
  }
  dk3figrd_report_error_code(drw, back, ec);
  

#line 1561 "dk3figrd.ctr"
  return back;
}



/**	Process comment line.
	@param	drw	Drawing to modify.
	@param	lp	Text line to process.
*/
static
void
dk3figrd_process_comment(dk3_fig_drawing_t *drw, char *lp)
{
  char		*cp[16];
  char		*lp1;
  size_t	 ncp;
  

#line 1578 "dk3figrd.ctr"
  switch(drw->state) {
    case DK3_FIG_RD_STATE_EXPECT_ORIENTATION: {
      if(DK3_FIG_SRCTYPE_UNKNOWN == drw->srctype) {
        lp1 = lp; lp1++;
        lp1 = dk3str_c8_start(lp1, NULL);
        if(lp1) {
          ncp = dk3str_c8_explode(cp, 15, lp1, NULL);
	  if(ncp >= 3) {
	    if(dk3str_c8_casecmp(cp[0], dk3figrd_c8_kw[1]) == 0) {
	      if(dk3str_c8_casecmp(cp[1], dk3figrd_c8_kw[2]) == 0) {
	        if(dk3str_c8_casecmp(cp[2], dk3figrd_c8_kw[3]) == 0) {
	          drw->srctype = DK3_FIG_SRCTYPE_WINFIG;	

#line 1590 "dk3figrd.ctr"
	        }
	      }
	    }
	  }
        }
      }
    } break;
  } 

#line 1598 "dk3figrd.ctr"
}



/**	Apply one input line to drawing, LC_NUMERIC is set correctly.
	@param	drw	Drawing to modify.
	@param	lp	Text to process.
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_read_my_apply_line(dk3_fig_drawing_t *drw, char *lp)
{
  char			*p1;		/* Start of line. */
  int			 back = 0;
  

#line 1614 "dk3figrd.ctr"
  if((drw) && (lp)) {
    drw->lineno += 1UL;
    if(drw->app) { dk3app_set_source_line(drw->app, drw->lineno); }
    p1 = dk3str_c8_start(lp, NULL);
    if(p1) {
      dk3str_c8_delnl(p1);
      if(DK3_FIG_RD_STATE_START == drw->state) {
        back = dk3figrd_expect_start(drw, p1);
      } else {
        if('#' != *p1) {
	  switch(drw->state) {
	    case DK3_FIG_RD_STATE_EXPECT_ORIENTATION: {
	      back = 1; drw->state = DK3_FIG_RD_STATE_EXPECT_JUSTIFICATION;
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_JUSTIFICATION: {
	      back = 1; drw->state = DK3_FIG_RD_STATE_EXPECT_UNITS;
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_UNITS: {
	      back = 1; drw->state = DK3_FIG_RD_STATE_EXPECT_PAPERSIZE;
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_PAPERSIZE: {
	      back = 1; drw->state = DK3_FIG_RD_STATE_EXPECT_MAGNIFICATION;
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_MAGNIFICATION: {
	      back = 1; drw->state = DK3_FIG_RD_STATE_EXPECT_MULTIPAGE;
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_MULTIPAGE: {
	      back = 1; drw->state = DK3_FIG_RD_STATE_EXPECT_TRANSPARENT;
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_TRANSPARENT: {
	      back = dk3figrd_expect_transparent(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_EXPECT_RESOLUTION: {
	      back = dk3figrd_expect_resolution(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_READY: {
	      back = dk3figrd_start_object(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_ARC_ARROW_FORWARD: {
	      back = dk3figrd_arc_arrow(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_ARC_ARROW_BACKWARD: {
	      back = dk3figrd_arc_arrow(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_PL_ARROW_FORWARD: {
	      back = dk3figrd_polyline_arrow(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_PL_ARROW_BACKWARD: {
	      back = dk3figrd_polyline_arrow(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_PL_IMAGE: {
	      back = dk3figrd_polyline_image(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_PL_POINTS: {
	      back = dk3figrd_point_data(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_SP_ARROW_FORWARD: {
	      back = dk3figrd_spline_arrow(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_SP_ARROW_BACKWARD: {
	      back = dk3figrd_spline_arrow(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_SP_POINTS: {
	      back = dk3figrd_point_data(drw, p1);
	    } break;
	    case DK3_FIG_RD_STATE_SP_CONTROL: {
	      back = dk3figrd_point_data(drw, p1);
	    } break;
	  }
	} else {
	  back = 1;					

#line 1685 "dk3figrd.ctr"
	  dk3figrd_process_comment(drw, p1);
	}
      }
    } else {
      back = 1;						

#line 1690 "dk3figrd.ctr"
    }
    if(!(back)) {
      drw->state = DK3_FIG_RD_STATE_ERROR;
    }
    if(DK3_FIG_RD_STATE_ERROR == drw->state) {
      /* ERROR: Error while reading input file! */
      dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 6);
    }
    if(DK3_FIG_RD_STATE_READY == drw->state) {
      drw->cobj = NULL;
      drw->cind = 0;
      drw->cxy = 0;
    }
  } else {						

#line 1704 "dk3figrd.ctr"
  } 

#line 1705 "dk3figrd.ctr"
  return back;
}



int
dk3fig_read_apply_line(dk3_fig_drawing_t *drw, char *lp)
{
  int back;
#if DK3_HAVE_SETLOCALE && defined(LC_NUMERIC) && DK3_HAVE_LOCALE_H
  char	*oldlocale;
#endif
#if DK3_HAVE_SETLOCALE && defined(LC_NUMERIC) && DK3_HAVE_LOCALE_H
  

#line 1719 "dk3figrd.ctr"
  oldlocale = setlocale(LC_NUMERIC, "C");
#endif
  back = dk3fig_read_my_apply_line(drw, lp);
#if DK3_HAVE_SETLOCALE && defined(LC_NUMERIC) && DK3_HAVE_LOCALE_H
  if(oldlocale) {	

#line 1724 "dk3figrd.ctr"
    setlocale(LC_NUMERIC, oldlocale);
  }
#endif
  return back;
}



int
dk3fig_read_file(dk3_fig_drawing_t *drw, FILE *fipo)
{
  char	 il[DK3_FIG_LINE_SIZE];	/* Input line buffer. */
#if DK3_HAVE_SETLOCALE && defined(LC_NUMERIC) && DK3_HAVE_LOCALE_H
  char	*oldlocale;
#endif
  int	 	 cc;			/* Flag: Can continue. */
  int		 back = 0;
  

#line 1742 "dk3figrd.ctr"
  if((drw) && (fipo)) {
#if DK3_HAVE_SETLOCALE && defined(LC_NUMERIC) && DK3_HAVE_LOCALE_H
    

#line 1745 "dk3figrd.ctr"
    oldlocale = setlocale(LC_NUMERIC, "C");
#endif
    back = 1;
    cc = 1;
    while((back) && (cc)) {
      if(fgets(il, sizeof(il), fipo)) {
        if(!dk3fig_read_my_apply_line(drw, il)) {	

#line 1752 "dk3figrd.ctr"
	  back = 0;
	}
      } else {					

#line 1755 "dk3figrd.ctr"
        cc = 0;
      }
    }
#if DK3_HAVE_SETLOCALE && defined(LC_NUMERIC) && DK3_HAVE_LOCALE_H
    if(oldlocale) {	

#line 1760 "dk3figrd.ctr"
      setlocale(LC_NUMERIC, oldlocale);
    }
#endif
  } else {					

#line 1764 "dk3figrd.ctr"
  } 

#line 1765 "dk3figrd.ctr"
  return back;
}



int
dk3fig_read_file_name(dk3_fig_drawing_t *drw, dkChar const *fn)
{
  dkChar const	*oldsrcname = NULL;	/* Saved source file name. */
  FILE		*fipo;			/* Input file. */
  unsigned long	 oldsrcline = 0UL;	/* Saved source line number. */
  int		 back = 0;
  

#line 1778 "dk3figrd.ctr"
  if((drw) && (fn)) {
    if(drw->app) {
      oldsrcname = dk3app_get_source_file(drw->app);
      oldsrcline = dk3app_get_source_line(drw->app);
      dk3app_set_source_file(drw->app, fn);
      dk3app_set_source_line(drw->app, 0UL);
    }
    fipo = dk3sf_fopen_app(fn, dk3figrd_kw[0], drw->app);
    if(fipo) {
      back = dk3fig_read_file(drw, fipo);
      fclose(fipo);
    } else {						

#line 1790 "dk3figrd.ctr"
      dk3fig_set_ec(drw,  DK3_ERROR_SYSTEM);
    }
    if(drw->app) {
      dk3app_set_source_file(drw->app, oldsrcname);
      dk3app_set_source_line(drw->app, oldsrcline);
    }
  } else {						

#line 1797 "dk3figrd.ctr"
    if(drw) { dk3fig_set_ec(drw, DK3_ERROR_INVALID_ARGS); }
  } 

#line 1799 "dk3figrd.ctr"
  return back;
}



