/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figpr.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figpr.c The dk3figpr module.
*/


#line 48 "dk3figpr.ctr"

#include "dk3all.h"
#include "dk3fig.h"
#include "dk3figto.h"
#include "dk3figpr.h"
#include "dk3figbb.h"
#include "dk3figah.h"
#include "fig2lat.h"



#line 58 "dk3figpr.ctr"



/**	If the first object is a background rectangle check
	whether it was created by jFig or XFig.
	@param	drw	Drawing.
	@param	obj	Object to check.
	@param	objno	Object number.
*/
static
void
dk3fig_prepare_check_bgrect(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 objno
)
{
  

#line 76 "dk3figpr.ctr"
  if(dk3fig_tool_is_bgrect(obj, objno)) {
    if(DK3_FIG_SRCTYPE_UNKNOWN == drw->srctype) {
      switch(obj->pc) {
        case 7: {		

#line 80 "dk3figpr.ctr"
	  drw->srctype = DK3_FIG_SRCTYPE_JFIG;
	} break;
	default: {		

#line 83 "dk3figpr.ctr"
	  drw->srctype = DK3_FIG_SRCTYPE_XFIG;
	} break;
      }
    }
  } 

#line 88 "dk3figpr.ctr"
}



#if TRACE_DEBUG
/**	Calculate distance of 2 points, used to verify the correct
	radius calculation for args.
	@param	x1	Point 1 x.
	@param	x2	Point 2 x.
	@param	y1	Point 1 y.
	@param	y2	Point 2 y.
	@return	Distance between points.
*/
static
double
dk3fig_prepare_point_distance(
  double x1, double x2, double y1, double y2
)
{
  double back;
  back = sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
  return back;
}
#endif



/**	Initialize arc object (calculate center and radius).
	@param	drw	Drawing.
	@param	obj	Object.
	@param	objno	Object number (0 for first object).
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_initialize_arc(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj, unsigned long objno, int primobj
)
{
  dk3_fig_poly_point_t	*points;
  dk3_fig_det_arc_t	*arc;
  double		 tm;	/* The t parameter of the M point. */
  double		 n;	/* Denominator in tm calculation. */
  double		 xa;
  double		 ya;
  double		 xc;
  double		 yc;
  double		 r;
  double		 eps = DK3_FIG_EPSILON;
  int			 back = 1;
  int			 ec = 0;
  int			 divec = 0;
  

#line 142 "dk3figpr.ctr"
  arc = &((obj->dt).arc);
  n = dk3ma_d_sub_ok(
    dk3ma_d_mul_ok(
      dk3ma_d_sub_ok(arc->y2, arc->y1, &ec),
      dk3ma_d_sub_ok(arc->x2, arc->x3, &ec),
      &ec
    ),
    dk3ma_d_mul_ok(
      dk3ma_d_sub_ok(arc->y3, arc->y2, &ec),
      dk3ma_d_sub_ok(arc->x1, arc->x2, &ec),
      &ec
    ),
    &ec
  );
  tm = 0.5 * dk3ma_d_div_ok(
    dk3ma_d_sub_ok(
      dk3ma_d_mul_ok(
        dk3ma_d_sub_ok(arc->x2, arc->x3, &ec),
	dk3ma_d_sub_ok(arc->x3, arc->x1, &ec),
	&ec
      ),
      dk3ma_d_mul_ok(
        dk3ma_d_sub_ok(arc->y3, arc->y2, &ec),
	dk3ma_d_sub_ok(arc->y3, arc->y1, &ec),
	&ec
      ),
      &ec
    ),
    n,
    &divec
  );
  if(0 == divec) {
    arc->xc = dk3ma_d_add_ok(
      (0.5 * dk3ma_d_add_ok(arc->x1, arc->x2, &ec)),
      dk3ma_d_mul_ok(
        tm,
        dk3ma_d_sub_ok(arc->y2, arc->y1, &ec),
        &ec
      ),
      &ec
    );
    arc->yc = dk3ma_d_add_ok(
      (0.5 * dk3ma_d_add_ok(arc->y1, arc->y2, &ec)),
      dk3ma_d_mul_ok(
        tm,
        dk3ma_d_sub_ok(arc->x1, arc->x2, &ec),
        &ec
      ),
      &ec
    );
    arc->ra = sqrt(
      dk3ma_d_add_ok(
        dk3ma_d_mul_ok(
          dk3ma_d_sub_ok(arc->xc, arc->x1, &ec),
	  dk3ma_d_sub_ok(arc->xc, arc->x1, &ec),
	  &ec
        ),
        dk3ma_d_mul_ok(
          dk3ma_d_sub_ok(arc->yc, arc->y1, &ec),
	  dk3ma_d_sub_ok(arc->yc, arc->y1, &ec),
	  &ec
        ),
        &ec
      )
    );
    arc->as = dk3ma_d_atan2(
      dk3ma_d_sub_ok(arc->y1, arc->yc, &ec),
      dk3ma_d_sub_ok(arc->x1, arc->xc, &ec)
    );
    arc->ae = dk3ma_d_atan2(
      dk3ma_d_sub_ok(arc->y3, arc->yc, &ec),
      dk3ma_d_sub_ok(arc->x3, arc->xc, &ec)
    );
    if(n >= 0.0) {
      arc->di = 0x01;
      while(arc->ae < arc->as) {
        arc->ae = arc->ae + (2.0 * M_PI);
      }
    } else {
      arc->di = 0x00;
      while(arc->as < arc->ae) {
        arc->as = arc->as + (2.0 * M_PI);
      }
    }
    

#line 227 "dk3figpr.ctr"
    

#line 228 "dk3figpr.ctr"
    

#line 229 "dk3figpr.ctr"
    

#line 230 "dk3figpr.ctr"
    

#line 231 "dk3figpr.ctr"
    

#line 232 "dk3figpr.ctr"
    

#line 233 "dk3figpr.ctr"
    

#line 234 "dk3figpr.ctr"
    

#line 235 "dk3figpr.ctr"
    

#line 236 "dk3figpr.ctr"
    

#line 237 "dk3figpr.ctr"
  } else {
    /* line */
    back = 0;
    xa = arc->x1;
    ya = arc->y1;
    xc = arc->x3;
    yc = arc->y3;
    if(dk3ma_d_equal(xa, xc, eps) && dk3ma_d_equal(ya, yc, eps)) {
      r = 0.5 * dk3fig_tool_get_lw(drw, obj, &ec);
      switch(obj->cs) {
        case DK3_FIG_LC_ROUND: {
	  back = 1;
	  dk3mem_res(
	    (void *)(&((obj->dt))),
	    sizeof(dk3_fig_obj_det_t)
	  );
	  obj->ot = DK3_FIG_OBJ_ELLIPSE;
	  obj->st = 3;	/* Circle defined by radius */
	  obj->lw = 0;
	  obj->fc = obj->pc;
	  obj->fi = 20;	/* Full saturation of color. */
	  obj->cs = DK3_FIG_LC_BUTT;
	  obj->js = DK3_FIG_LJ_MITER;
	  obj->ls = DK3_FIG_LS_SOLID;
	  obj->cl = 1;
	  (obj->dt).ell.an = 0.0;
	  (obj->dt).ell.cx = xa;
	  (obj->dt).ell.cy = ya;
	  (obj->dt).ell.rx = (obj->dt).ell.ry = r;
	} break;
	default: {
	  points = dk3_new_app(dk3_fig_poly_point_t,4,drw->app);
	  if(points) {
	    back = 1;
	    points[0].x = points[3].x = dk3ma_d_sub_ok(xa, r, &ec);
	    points[1].x = points[2].x = dk3ma_d_add_ok(xa, r, &ec);
	    points[0].y = points[1].y = dk3ma_d_sub_ok(ya, r, &ec);
	    points[2].y = points[3].y = dk3ma_d_add_ok(ya, r, &ec);
	    dk3mem_res(
	      (void *)(&((obj->dt))),
	      sizeof(dk3_fig_obj_det_t)
	    );
	    obj->ot = DK3_FIG_OBJ_POLYLINE;
	    obj->st = 3;	/* Polygon */
	    obj->lw = 0;
	    obj->fc = obj->pc;
	    obj->fi = 20;	/* Full saturation of color. */
	    obj->cs = DK3_FIG_LC_BUTT;
	    obj->js = DK3_FIG_LJ_MITER;
	    obj->ls = DK3_FIG_LS_SOLID;
	    obj->cl = 1;
	    (obj->dt).pol.fn = NULL;
	    (obj->dt).pol.po = points;
	    (obj->dt).pol.ra = 0.0;
	    (obj->dt).pol.xs = 0.0;
	    (obj->dt).pol.ys = 0.0;
	    (obj->dt).pol.xe = 0.0;
	    (obj->dt).pol.ye = 0.0;
	    (obj->dt).pol.np = 4;
	    (obj->dt).pol.flf = 0;
	  } else {
	    back = 0;
	    dk3fig_set_ec(drw,  DK3_ERROR_MEMORY);
	  }
	} break;
      }
    } else {
      points = dk3_new_app(dk3_fig_poly_point_t,2,drw->app);
      if(points) {
        back = 1;
        points[0].x = xa;
        points[0].y = ya;
        points[1].x = xc;
        points[1].y = yc;
        (obj->dt).pol.fn = NULL;
        (obj->dt).pol.po = points;
        (obj->dt).pol.ra = 0.0;
        (obj->dt).pol.xs = xa;
        (obj->dt).pol.ys = ya;
        (obj->dt).pol.xe = xc;
        (obj->dt).pol.ye = yc;
        (obj->dt).pol.np = 2;
        (obj->dt).pol.flf = 0;
        obj->ot = DK3_FIG_OBJ_POLYLINE;
        obj->st = 1;
      } else {
        dk3fig_set_ec(drw,  DK3_ERROR_MEMORY);
        /* memory allocation failed, reported by back == 0. */
      }
    }
  }
  if(ec) {		

#line 329 "dk3figpr.ctr"
    back = 0;
    /* ERROR: Mathematical problem with arc! */
    dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 3);
  }
  

#line 335 "dk3figpr.ctr"
  return back;
}



/**	Convert polyline to circle or squara if necessary.
	@param	drw	Drawing.
	@param	obj	Object.
	@param	objno	Object number (0 for first object).
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_initialize_polyline(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj, unsigned long objno, int primobj
)
{
  dk3_fig_poly_point_t	*newpoints;
  double	 	 cx;
  double	 	 cy;
  double	 	 r;
  double	 	 x1;
  double	 	 x2;
  double	 	 y1;
  double	 	 y2;
  double		 eps = DK3_FIG_EPSILON;
  int		 	 back = 1;
  int		 	 mc = 0;
  int		 	 ec = 0;
  

#line 366 "dk3figpr.ctr"
  if(1 == (obj->dt).pol.np) {
    mc = 1;
  } else {
    if(2 == (obj->dt).pol.np) {
      if(dk3ma_d_equal(((obj->dt).pol.po)[0].x, ((obj->dt).pol.po)[1].x, eps)) {
      if(dk3ma_d_equal(((obj->dt).pol.po)[0].y, ((obj->dt).pol.po)[1].y, eps)) {
        mc = 1;
      }
      }
    }
  }
  if(mc) {
    switch(obj->cs) {
      case DK3_FIG_LC_ROUND: {		

#line 380 "dk3figpr.ctr"
        cx = ((obj->dt).pol.po)[0].x;
	cy = ((obj->dt).pol.po)[0].y;
	r  = 0.5 * dk3fig_tool_get_lw(drw, obj, &ec);
	dk3_release((obj->dt).pol.fn);
	dk3_release((obj->dt).pol.po);
	dk3mem_res(
	  (void *)(&((obj->dt))),
	  sizeof(dk3_fig_obj_det_t)
	);
	obj->ot = DK3_FIG_OBJ_ELLIPSE;
	obj->st = 3;	/* Circle defined by radius */
	obj->lw = 0;
	obj->fc = obj->pc;
	obj->fi = 20;	/* Full saturation of color. */
	obj->cs = DK3_FIG_LC_BUTT;
	obj->js = DK3_FIG_LJ_MITER;
	obj->ls = DK3_FIG_LS_SOLID;
	obj->cl = 1;
	(obj->dt).ell.an = 0.0;
	(obj->dt).ell.cx = cx;
	(obj->dt).ell.cy = cy;
	(obj->dt).ell.rx = (obj->dt).ell.ry = r;
      } break;
      default: {			

#line 404 "dk3figpr.ctr"
        cx = ((obj->dt).pol.po)[0].x;
	cy = ((obj->dt).pol.po)[0].y;
	r  = 0.5 * dk3fig_tool_get_lw(drw, obj, &ec);
	x1 = dk3ma_d_sub_ok(cx, r, &ec);
	x2 = dk3ma_d_add_ok(cx, r, &ec);
	y1 = dk3ma_d_sub_ok(cy, r, &ec);
	y2 = dk3ma_d_add_ok(cy, r, &ec);
	newpoints = dk3_new_app(dk3_fig_poly_point_t,4,drw->app);
	if(newpoints) {
	  newpoints[0].x = x1; newpoints[0].y = y1;
	  newpoints[1].x = x2; newpoints[1].y = y1;
	  newpoints[2].x = x2; newpoints[2].y = y2;
	  newpoints[3].x = x1; newpoints[3].y = y2;
	  dk3_release((obj->dt).pol.fn);
	  dk3_release((obj->dt).pol.po);
	  dk3mem_res(
	    (void *)(&((obj->dt))),
	    sizeof(dk3_fig_obj_det_t)
	  );
	  obj->ot = DK3_FIG_OBJ_POLYLINE;
	  obj->st = 3;	/* Polygon */
	  obj->lw = 0;
	  obj->fc = obj->pc;
	  obj->fi = 20;	/* Full saturation of color. */
	  obj->cs = DK3_FIG_LC_BUTT;
	  obj->js = DK3_FIG_LJ_MITER;
	  obj->ls = DK3_FIG_LS_SOLID;
	  obj->cl = 1;
	  (obj->dt).pol.fn = NULL;
	  (obj->dt).pol.po = newpoints;
	  (obj->dt).pol.ra = 0.0;
	  (obj->dt).pol.xs = 0.0;
	  (obj->dt).pol.ys = 0.0;
	  (obj->dt).pol.xe = 0.0;
	  (obj->dt).pol.ye = 0.0;
	  (obj->dt).pol.np = 4;
	  (obj->dt).pol.flf = 0;
	} else {
	  back = 0;
	  dk3fig_set_ec(drw,  DK3_ERROR_MEMORY);
	}
      } break;
    }
  }
  if(ec) {			

#line 449 "dk3figpr.ctr"
    /* ERROR: Math */
    dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
    back = 0;
    dk3app_log_i1(drw->app, DK3_LL_ERROR, 260);
  } 

#line 454 "dk3figpr.ctr"
  return back;
}



#if 0
/*
    	Only polylines are allowed to have one point, not splines.
*/
/**	Convert spline to circle or squara if necessary.
	@param	drw	Drawing.
	@param	obj	Object.
	@param	objno	Object number (0 for first object).
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_initialize_spline(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj, unsigned long objno, int primobj
)
{
  dk3_fig_poly_point_t	*newpoints;
  double	 	 cx;
  double	 	 cy;
  double	 	 r;
  double	 	 x1;
  double	 	 x2;
  double	 	 y1;
  double	 	 y2;
  double		 eps = DK3_FIG_EPSILON;
  int		 	 back = 1;
  int		 	 mc = 0;
  int		 	 ec = 0;
  

#line 489 "dk3figpr.ctr"
  if(1 == (obj->dt).spl.np) {
    mc = 1;
  } else {
    if(2 == (obj->dt).spl.np) {
      if(dk3ma_d_equal(((obj->dt).spl.po)[0].x, ((obj->dt).spl.po)[1].x, eps)) {
      if(dk3ma_d_equal(((obj->dt).spl.po)[0].y, ((obj->dt).spl.po)[1].y, eps)) {
        mc = 1;
      }
      }
    }
  }
  if(mc) {
    switch(obj->cs) {
      case DK3_FIG_LC_ROUND: {	

#line 503 "dk3figpr.ctr"
        cx = ((obj->dt).spl.po)[0].x;
	cy = ((obj->dt).spl.po)[0].y;
	r  = 0.5 * dk3fig_tool_get_lw(drw, obj, &ec);
	dk3_release((obj->dt).spl.po);
	dk3mem_res(
	  (void *)(&((obj->dt))),
	  sizeof(dk3_fig_obj_det_t)
	);
	obj->ot = DK3_FIG_OBJ_ELLIPSE;
	obj->st = 3;	/* Circle defined by radius */
	obj->lw = 0;
	obj->fc = obj->pc;
	obj->fi = 20;	/* Full saturation of color. */
	obj->cs = DK3_FIG_LC_BUTT;
	obj->js = DK3_FIG_LJ_MITER;
	obj->ls = DK3_FIG_LS_SOLID;
	obj->cl = 1;
	(obj->dt).ell.an = 0.0;
	(obj->dt).ell.cx = cx;
	(obj->dt).ell.cy = cy;
	(obj->dt).ell.rx = (obj->dt).ell.ry = r;
      } break;
      default: {		

#line 526 "dk3figpr.ctr"
        cx = ((obj->dt).spl.po)[0].x;
	cy = ((obj->dt).spl.po)[0].y;
	r  = 0.5 * dk3fig_tool_get_lw(drw, obj, &ec);
	x1 = dk3ma_d_sub_ok(cx, r, &ec);
	x2 = dk3ma_d_add_ok(cx, r, &ec);
	y1 = dk3ma_d_sub_ok(cy, r, &ec);
	y2 = dk3ma_d_add_ok(cy, r, &ec);
	newpoints = dk3_new_app(dk3_fig_poly_point_t,4,drw->app);
	if(newpoints) {
	  newpoints[0].x = x1; newpoints[0].y = y1;
	  newpoints[1].x = x2; newpoints[1].y = y1;
	  newpoints[2].x = x2; newpoints[2].y = y2;
	  newpoints[3].x = x1; newpoints[3].y = y2;
	  dk3_release((obj->dt).spl.po);
	  dk3mem_res(
	    (void *)(&((obj->dt))),
	    sizeof(dk3_fig_obj_det_t)
	  );
	  obj->ot = DK3_FIG_OBJ_POLYLINE;
	  obj->st = 3;	/* Polygon */
	  obj->lw = 0;
	  obj->fc = obj->pc;
	  obj->fi = 20;	/* Full saturation of color. */
	  obj->cs = DK3_FIG_LC_BUTT;
	  obj->js = DK3_FIG_LJ_MITER;
	  obj->ls = DK3_FIG_LS_SOLID;
	  obj->cl = 1;
	  (obj->dt).pol.fn = NULL;
	  (obj->dt).pol.po = newpoints;
	  (obj->dt).pol.ra = 0.0;
	  (obj->dt).pol.xs = 0.0;
	  (obj->dt).pol.ys = 0.0;
	  (obj->dt).pol.xe = 0.0;
	  (obj->dt).pol.ye = 0.0;
	  (obj->dt).pol.np = 4;
	  (obj->dt).pol.flf = 0;
	} else {
	  back = 0;
	}
      } break;
    }
  }
  if(ec) {		

#line 569 "dk3figpr.ctr"
    dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
    /* ERROR: Math */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 38);
  } 

#line 573 "dk3figpr.ctr"
  return back;
}
#endif




/**	Object type specific initialization.
	@param	drw	Drawing.
	@param	obj	Object.
	@param	objno	Object number (0 for first object).
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_initialize_object(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj, unsigned long objno, int primobj
)
{
  int		 back = 1;
  

#line 595 "dk3figpr.ctr"
  switch(obj->ot) {
    case DK3_FIG_OBJ_POLYLINE: {
      back = dk3fig_prepare_initialize_polyline(drw, obj, objno, primobj);
    } break;
#if 0
    /*
    	Only polylines are allowed to have one point, not splines.
    */
    case DK3_FIG_OBJ_SPLINE: {
      back = dk3fig_prepare_initialize_spline(drw, obj, objno, primobj);
    } break;
#endif
    case DK3_FIG_OBJ_ARC: {
      back = dk3fig_prepare_initialize_arc(drw, obj, objno, primobj);
    } break;
  } 

#line 611 "dk3figpr.ctr"
  return back;
}



/**	Add object to drawing bounding box.
	@param	drw	Drawing to calculate the bounding box for.
	@param	obj	Object to add to bounding box.
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_add_to_bb(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t const	*obj,
  int			 primobj
);



/**	Add objects for one arrowhead to bounding box.
	@param	drw
	@param	obj
	@param	ah
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_arrowhead_object(
  dk3_fig_drawing_t		*drw,
  dk3_fig_obj_t const		*obj,
  dk3_fig_ah_t const		*ah
)
{
  int		 back = 1;
  

#line 648 "dk3figpr.ctr"
  if(ah) {
    if(ah->o1) {
      if(!dk3fig_prepare_add_to_bb(drw, (dk3_fig_obj_t *)(ah->o1), 0)) {
        back = 0;
      }
    }
    if(ah->o2) {
      if(!dk3fig_prepare_add_to_bb(drw, (dk3_fig_obj_t *)(ah->o2), 0)) {
        back = 0;
      }
    }
    if(!(back)) {
      dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
      /* ERROR: Math overflow */
    }
  } 

#line 664 "dk3figpr.ctr"
  return back;
}



int
dk3fig_prepare_obj_bb(
  dk3_bb_t		*dbb,
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t const	*obj,
  int			 primobj
)
{
  int			back = 0;
  int			notfound = 0;
  switch(obj->ot) {
    case DK3_FIG_OBJ_ELLIPSE: {	 

#line 681 "dk3figpr.ctr"
      back = dk3fig_bb_add_ellipse(
        dbb, &((obj->dt).ell), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_POLYLINE: { 

#line 686 "dk3figpr.ctr"
      back = dk3fig_bb_add_polyline(
        dbb, &((obj->dt).pol), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_SPLINE: {		

#line 691 "dk3figpr.ctr"
      back = dk3fig_bb_add_spline(
        drw,
        dbb, &((obj->dt).spl),
	(0.5 * dk3fig_tool_get_lw(drw, obj, NULL)), primobj,
	((obj->cl) ? 1 : 0)
      );
    } break;
    case DK3_FIG_OBJ_TEXT: {		

#line 699 "dk3figpr.ctr"
      back = dk3fig_bb_add_text(
        dbb, &((obj->dt).txt), drw->res, drw->bbts
      );
    } break;
    case DK3_FIG_OBJ_ARC: {		

#line 704 "dk3figpr.ctr"
      back = dk3fig_bb_add_arc(
        dbb, &((obj->dt).arc),
	((1 != obj->st) ? 1 : 0),
	(0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    default: {				

#line 711 "dk3figpr.ctr"
      dk3fig_set_ec(drw,  DK3_ERROR_SYNTAX);
      /* ERROR: Unknown object type! */
      dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 8);
      notfound = 1;
    } break;
  }
  if(!(back)) {
    if(!(notfound)) {
      dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
      /* ERROR: Math overflow */
    }
  }
  return back;
}



static
int
dk3fig_prepare_add_to_bb(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t const	*obj,
  int			 primobj
)
{
#if TEST_SHOW_EACH_BB
  int		 back = 0;
  dk3_bb_t	 mybb;
  

#line 740 "dk3figpr.ctr"
  dk3bb_reset(&mybb);
  switch(obj->ot) {
    case DK3_FIG_OBJ_ELLIPSE: {		

#line 743 "dk3figpr.ctr"
      back = dk3fig_bb_add_ellipse(
        &mybb, &((obj->dt).ell), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_POLYLINE: {	

#line 748 "dk3figpr.ctr"
      back = dk3fig_bb_add_polyline(
        &mybb, &((obj->dt).pol), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_SPLINE: {		

#line 753 "dk3figpr.ctr"
      back = dk3fig_bb_add_spline(
        drw,
        &mybb, &((obj->dt).spl),
	(0.5 * dk3fig_tool_get_lw(drw, obj, NULL)), primobj,
	((obj->cl) ? 1 : 0)
      );
    } break;
    case DK3_FIG_OBJ_TEXT: {		

#line 761 "dk3figpr.ctr"
      back = dk3fig_bb_add_text(
        &mybb, &((obj->dt).txt), drw->res, drw->bbts
      );
    } break;
    case DK3_FIG_OBJ_ARC: {		

#line 766 "dk3figpr.ctr"
      back = dk3fig_bb_add_arc(
        &mybb, &((obj->dt).arc),
	((1 != obj->st) ? 1 : 0),
	(0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE: {
      back = dk3fig_bb_add_hci(
        &mybb, &(obj->dt).hci, (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    default: {				

#line 778 "dk3figpr.ctr"
    } break;
  } 

#line 780 "dk3figpr.ctr"
  dk3bb_merge(&(drw->bb), &mybb);
  if(primobj) {
    if(!dk3fig_prepare_arrowhead_object(drw, obj, obj->af)) { back = 0; }
    if(!dk3fig_prepare_arrowhead_object(drw, obj, obj->ab)) { back = 0; }
  }
  if(!(back)) {
    /* ERROR: Math overflow */
    dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
    dk3app_log_i1(drw->app, DK3_LL_ERROR, 260);
  }
  

#line 791 "dk3figpr.ctr"
  return back;
#else
  int		 back = 0;
  

#line 795 "dk3figpr.ctr"
  switch(obj->ot) {
    case DK3_FIG_OBJ_ELLIPSE: {		

#line 797 "dk3figpr.ctr"
      back = dk3fig_bb_add_ellipse(
        &(drw->bb), &((obj->dt).ell), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_POLYLINE: {	

#line 802 "dk3figpr.ctr"
      back = dk3fig_bb_add_polyline(
        &(drw->bb), &((obj->dt).pol), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_SPLINE: {		

#line 807 "dk3figpr.ctr"
      back = dk3fig_bb_add_spline(
        drw,
        &(drw->bb), &((obj->dt).spl),
	(0.5 * dk3fig_tool_get_lw(drw, obj, NULL)), primobj,
	((obj->cl) ? 1 : 0)
      );
    } break;
    case DK3_FIG_OBJ_TEXT: {		

#line 815 "dk3figpr.ctr"
      back = dk3fig_bb_add_text(
        &(drw->bb), &((obj->dt).txt), drw->res, drw->bbts
      );
    } break;
    case DK3_FIG_OBJ_ARC: {		

#line 820 "dk3figpr.ctr"
      back = dk3fig_bb_add_arc(
        &(drw->bb), &((obj->dt).arc),
	((1 != obj->st) ? 1 : 0),
	(0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    case DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE: {
      back = dk3fig_bb_add_hci(
        &(drw->bb), &((obj->dt).hci), (0.5 * dk3fig_tool_get_lw(drw, obj, NULL))
      );
    } break;
    default: {				

#line 832 "dk3figpr.ctr"
    } break;
  }
  if(primobj) {
    if(!dk3fig_prepare_arrowhead_object(drw, obj, obj->af)) { back = 0; }
    if(!dk3fig_prepare_arrowhead_object(drw, obj, obj->ab)) { back = 0; }
  }
  if(!(back)) {
    /* ERROR: Math overflow */
    dk3fig_set_ec(drw,  DK3_ERROR_MATH_OVERFLOW);
    dk3app_log_i1(drw->app, DK3_LL_ERROR, 260);
  }
  

#line 844 "dk3figpr.ctr"
  return back;
#endif
}



#if TRACE_DEBUG
/**	Report object to trace file.
	@param	obj	Object to report.
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
*/
static
void
dk3fig_prepare_report_object(dk3_fig_obj_t *obj, int primobj);

/**	Report one arrowhead to trace file.
	@param	ah	Arrowhead to report.
*/
static
void
dk3fig_prepare_report_ah(dk3_fig_ah_t *ah)
{
  if(ah) {
    

#line 868 "dk3figpr.ctr"
    if(ah->o1) {
      dk3fig_prepare_report_object((dk3_fig_obj_t *)(ah->o1), 0);
    }
    if(ah->o2) {
      dk3fig_prepare_report_object((dk3_fig_obj_t *)(ah->o2), 0);
    }
    

#line 875 "dk3figpr.ctr"
  }
}



static
void
dk3fig_prepare_report_object(dk3_fig_obj_t *obj, int primobj)
{
  FILE				*fipo;
  dk3_fig_poly_point_t		*pp;
  dk3_fig_spline_point_t	*sp;
  size_t			 i;
  

#line 889 "dk3figpr.ctr"
  fipo = dktrace_file();
  if(fipo) {
    switch(obj->ot) {
      case DK3_FIG_OBJ_ELLIPSE: {
        fputs("Ellipse\n", fipo);
	switch(obj->st) {
	  case 1: {
	    fputs("Ellipse by radii\n", fipo);
	  } break;
	  case 2: {
	    fputs("Ellipse by diameter\n", fipo);
	  } break;
	  case 3: {
	    fputs("Circle by radius\n", fipo);
	  } break;
	  case 4: {
	    fputs("Circle by diameter\n", fipo);
	  } break;
	  default: {
	    fputs("UNKNOWN SUB-TYPE\n", fipo);
	  } break;
	}
      } break;
      case DK3_FIG_OBJ_POLYLINE: {
        fputs("Polyline\n", fipo);
	switch(obj->st) {
	  case 1: {
	    fputs("Polyline\n", fipo);
	  } break;
	  case 2: {
	    fputs("Box\n", fipo);
	  } break;
	  case 3: {
	    fputs("Polygon\n", fipo);
	  } break;
	  case 4: {
	    fputs("Arc-box\n", fipo);
	  } break;
	  case 5: {
	    fputs("Imported image\n", fipo);
	  } break;
	  default: {
	    fputs("UNKNOWN SUBTYPE\n", fipo);
	  } break;
	}
      } break;
      case DK3_FIG_OBJ_SPLINE: {
        fputs("Spline\n", fipo);
	switch(obj->st) {
	  case 0: {
	    fputs("Open approximated\n", fipo);
	  } break;
	  case 1: {
	    fputs("Closed approximated\n", fipo);
	  } break;
	  case 2: {
	    fputs("Open interpolated\n", fipo);
	  } break;
	  case 3: {
	    fputs("Closed interpolated\n", fipo);
	  } break;
	  case 4: {
	    fputs("Open X-spline\n", fipo);
	  } break;
	  case 5: {
	    fputs("Closed X-spline\n", fipo);
	  } break;
	  default: {
	    fputs("UNKNOWN SUBTYPE\n", fipo);
	  } break;
	}
      } break;
      case DK3_FIG_OBJ_TEXT: {
        fputs("Text\n", fipo);
	switch(obj->st) {
	  case 0: {
	    fputs("Left-aligned\n", fipo);
	  } break;
	  case 1: {
	    fputs("Centered\n", fipo);
	  } break;
	  case 2: {
	    fputs("Right-aligned\n", fipo);
	  } break;
	  default: {
	    fputs("UNKNOWN SUB-TYPE\n", fipo);
	  } break;
	}
      } break;
      case DK3_FIG_OBJ_ARC: {
        fputs("Arc\n", fipo);
	switch(obj->st) {
	  case 1: {
	    fputs("Open arc\n", fipo);
	  } break;
	  case 2: {
	    fputs("Closed arc\n", fipo);
	  } break;
	  default: {
	    fputs("UNKNOWN SUB-TYPE\n", fipo);
	  } break;
	}
      } break;
      case DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE: {
        fputs("Half-circle\n", fipo);
	if(obj->st) {
	  fputs("Closed filled half-circle\n", fipo);
	} else {
	  fputs("Open half-circle\n", fipo);
	}
      } break;
      default: {
        fputs("UNKNOWN OBJECT TYPE\n", fipo);
      } break;
    }
    fprintf(fipo, "Layer:       %d\n", obj->la);
    fprintf(fipo, "Line number: %lu\n", obj->li);
    fprintf(fipo, "Closed:      %d\n", obj->cl);
    fprintf(fipo, "Line width:  %d\n", obj->lw);
    fprintf(fipo, "Pen color:   %d\n", obj->pc);
    fprintf(fipo, "Fill color:  %d\n", obj->fc);
    fprintf(fipo, "Fill type:   %d\n", obj->fi);
    fprintf(fipo, "Line cap:    %d\n", obj->cs);
    fprintf(fipo, "Line join:   %d\n", obj->js);
    fprintf(fipo, "Line style:  %d\n", obj->ls);
    fprintf(fipo, "Style value: %lg\n", obj->sv);
    switch(obj->ot) {
    case DK3_FIG_OBJ_ELLIPSE: {
    fprintf(fipo, "Center x:    %lg\n", (obj->dt).ell.cx);
    fprintf(fipo, "Center y:    %lg\n", (obj->dt).ell.cy);
    fprintf(fipo, "Radius x:    %lg\n", (obj->dt).ell.rx);
    fprintf(fipo, "Radius y:    %lg\n", (obj->dt).ell.ry);
    fprintf(fipo, "Angle:       %lg\n", (180.0 * (obj->dt).ell.an / M_PI));
    } break;
    case DK3_FIG_OBJ_POLYLINE: {
    fprintf(fipo, "Radius:      %lg\n", (obj->dt).pol.ra);
    fprintf(fipo, "Start x:     %lg\n", (obj->dt).pol.xs);
    fprintf(fipo, "Start y:     %lg\n", (obj->dt).pol.ys);
    fprintf(fipo, "End   x:     %lg\n", (obj->dt).pol.xe);
    fprintf(fipo, "End   y:     %lg\n", (obj->dt).pol.ye);
    if(5 == obj->st) {
    fprintf(fipo, "Flip:        %d\n", (obj->dt).pol.flf);
    fprintf(fipo, "Image:       \"%s\"", TR_STR((obj->dt).pol.fn));
    }
    fprintf(fipo, "Points:      %lu\n", (unsigned long)((obj->dt).pol.np));
    if((obj->dt).pol.po) {
    pp = (obj->dt).pol.po; i = (obj->dt).pol.np;
    while(i--) {
      fprintf(fipo, "%lg %lg\n", pp->x, pp->y);
      pp++;
    }
    } else {
    fprintf(fipo, "ERROR: NO POINTS!\n");
    }
    } break;
    case DK3_FIG_OBJ_SPLINE: {
    fprintf(fipo, "Start t:     %lg\n", (obj->dt).spl.ts);
    fprintf(fipo, "End t:       %lg\n", (obj->dt).spl.te);
    fprintf(fipo, "Points:      %lu\n", (unsigned long)((obj->dt).spl.np));
    if((obj->dt).spl.po) {
    sp = (obj->dt).spl.po; i = (obj->dt).spl.np;
    while(i--) {
      fprintf(fipo, "%lg %lg %lg\n", sp->x, sp->y, sp->s);
      sp++;
    }
    } else {
    fprintf(fipo, "ERROR: NO POINTS!\n");
    }
    } break;
    case DK3_FIG_OBJ_TEXT: {
    fprintf(fipo, "Position x:  %lg\n", (obj->dt).txt.x);
    fprintf(fipo, "Position y:  %lg\n", (obj->dt).txt.y);
    fprintf(fipo, "Angle:       %lg\n", (obj->dt).txt.an);
    fprintf(fipo, "Text:        \"%s\"\n", TR_STR((obj->dt).txt.st));
    fprintf(fipo, "Font flags:  %d\n", (obj->dt).txt.ff);
    fprintf(fipo, "Font:        %d\n", (obj->dt).txt.fo);
    fprintf(fipo, "Font size:   %lg\n", (obj->dt).txt.fs);
    } break;
    case DK3_FIG_OBJ_ARC: {
    fprintf(fipo, "Center x:    %lg\n", (obj->dt).arc.xc);
    fprintf(fipo, "Center y:    %lg\n", (obj->dt).arc.yc);
    fprintf(fipo, "Radius:      %lg\n", (obj->dt).arc.ra);
    fprintf(fipo, "Start:       %lg\n", (180.0 * (obj->dt).arc.as / M_PI));
    fprintf(fipo, "End:         %lg\n", (180.0 * (obj->dt).arc.ae / M_PI));
    fprintf(fipo, "Direction:   %d", (int)((obj->dt).arc.di));
    fprintf(fipo, "Point 1 x:   %lg\n", (obj->dt).arc.x1);
    fprintf(fipo, "Point 1 y:   %lg\n", (obj->dt).arc.y1);
    fprintf(fipo, "Point 2 x:   %lg\n", (obj->dt).arc.x2);
    fprintf(fipo, "Point 2 y:   %lg\n", (obj->dt).arc.y2);
    fprintf(fipo, "Point 3 x:   %lg\n", (obj->dt).arc.x3);
    fprintf(fipo, "Point 3 y:   %lg\n", (obj->dt).arc.y3);
    } break;
    }
    if(primobj) {
      if(obj->af) {
        fprintf(fipo, "ARROWHEAD FORWARD\n");
        dk3fig_prepare_report_ah(obj->af);
      }
      if(obj->ab) {
        fprintf(fipo, "ARROWHEAD BACKWARD\n");
        dk3fig_prepare_report_ah(obj->ab);
      }
    }
  } 

#line 1093 "dk3figpr.ctr"
}
#endif



/**	Check whether the object is an open path and filling is
	required, change subtype to closed path if necessary.
	@param	drw	Drawing containing the object.
	@param	obj	Object to check.
*/
static
void
dk3fig_prepare_check_fill_open_path(dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj)
{
  switch(obj->ot) {
    case DK3_FIG_OBJ_POLYLINE: {
      if((-1 != obj->fi) && (drw->transcol != obj->fc)) {
        switch(obj->st) {
	  case 1: {
	    if(drw->cofop) {
	      obj->st = 3;
	      obj->cl = 1;
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_DEBUG, drw->msg, 10);
	      }
	    } else {
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_WARNING, drw->msg, 9);
	      }
	    }
	  } break;
	}
      }
    } break;
    case DK3_FIG_OBJ_SPLINE: {
      if((-1 != obj->fi) && (drw->transcol != obj->fc)) {
        switch(obj->st) {
	  case 0: {
	    if(drw->cofop) {
	      obj->st = 1;
	      obj->cl = 1;
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_DEBUG, drw->msg, 10);
	      }
	    } else {
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_WARNING, drw->msg, 9);
	      }
	    }
	  } break;
	  case 2: {
	    if(drw->cofop) {
	      obj->st = 3;
	      obj->cl = 1;
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_DEBUG, drw->msg, 10);
	      }
	    } else {
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_WARNING, drw->msg, 9);
	      }
	    }
	  } break;
	  case 4: {
	    if(drw->cofop) {
	      obj->st = 5;
	      obj->cl = 1;
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_DEBUG, drw->msg, 10);
	      }
	    } else {
	      if((drw->app) && (drw->msg)) {
	        dk3app_log_1(drw->app, DK3_LL_WARNING, drw->msg, 9);
	      }
	    }
	  } break;
	}
      }
    } break;
  }
}



/**	Prepare one object.
	@param	drw	Drawing.
	@param	obj	Object to prepare.
	@param	objno	Object number (starting at 0).
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_prepare_object(
  dk3_fig_drawing_t *drw, dk3_fig_obj_t *obj, unsigned long objno
)
{
  int		 back = 1;
  

#line 1191 "dk3figpr.ctr"
  /*
  	For object 0 check whether it is a background rectangle.
	Set srctype.
  */
  dk3fig_prepare_check_bgrect(drw, obj, objno);
  /*	Check for open path to fill.
  */
  dk3fig_prepare_check_fill_open_path(drw, obj);
  /*
  	Object type specific initialization.
  	For arcs calculate center point and radius.
  */
  if(!dk3fig_prepare_initialize_object(drw, obj, objno, 1)) {
    back = 0;	

#line 1205 "dk3figpr.ctr"
  }
  /*
  	For open objects calculate arrowheads.
  */
  if(back) {
    if(!dk3figah_calculate_arrowheads(drw, obj, objno)) {
      back = 0;
      

#line 1213 "dk3figpr.ctr"
    }
  }
  /*
  	Add object to bounding box. For open objects add
	arrowheads to bounding box too.
  */
  if(back) { 

#line 1220 "dk3figpr.ctr"
  if(!dk3fig_prepare_add_to_bb(drw, obj, 1)) {
    back = 0;	

#line 1222 "dk3figpr.ctr"
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 4);
  }
  } 

#line 1225 "dk3figpr.ctr"
  return back;
}



int
dk3fig_prepare(dk3_fig_drawing_t *drw)
{
  dk3_fig_obj_t		*obj;
  unsigned long		 oldsourceline = 0UL;
  unsigned long		 objno = 0UL;
  int			 back = 1;
  

#line 1238 "dk3figpr.ctr"
  /*
  	Reset bounding box.
  */
  dk3bb_reset(&(drw->bb));
  /*
  	Prepare all drawing elements.
  */
  oldsourceline = dk3app_get_source_line(drw->app);
  dk3sto_it_reset(drw->iobj);
  while(NULL != (obj = (dk3_fig_obj_t *)dk3sto_it_next(drw->iobj))) {
    dk3app_set_source_line(drw->app, obj->li);
    if(!dk3fig_prepare_object(drw, obj, objno++)) {
      back = 0;
    }
  }
  dk3app_set_source_line(drw->app, oldsourceline);
  

#line 1255 "dk3figpr.ctr"
  

#line 1256 "dk3figpr.ctr"
  return back;
}


