/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figbb.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figbb.h Header file for the dk3figbb module.
*/

#ifndef DK3FIGBB_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3FIGBB_H_INCLUDED 1


#line 10 "dk3figbb.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Calculate distance between a given point and a line through
	the origin.
	@param	xp	X coordinate of given point.
	@param	yp	Y coordinate of given point.
	@param	beta	Angle of line.
	@param	ec	Pointer to error code variable.
	@return	Distance value.
*/
double
dk3figbb_distance_point_line(
  double	 xp,
  double	 yp,
  double	 beta,
  int		*ec
);

/**	Add ellipse data to bounding box.
	@param	bb	Bounding box data to modify.
	@param	elli	Details of ellipse to add.
	@param	lw	Half line width.
	@return	1 on success, 0 on error.
*/
int
dk3fig_bb_add_ellipse(
  dk3_bb_t			*bb,
  dk3_fig_det_ell_t const	*elli,
  double			 lw
);

/**	Add arc data to bounding box.
	@param	bb	Bounding box data to modify.
	@param	arc	Details of arc to add.
	@param	cl	Flag: Closed arc.
	@param	lw	Half line width.
	@return	1 on success, 0 on error.
*/
int
dk3fig_bb_add_arc(
  dk3_bb_t			*bb,
  dk3_fig_det_arc_t const	*arc,
  int				 cl,
  double			 lw
);

/**	Add polyline data to bounding box.
	@param	bb	Bounding box data to modify.
	@param	pol	Details of polyline to add.
	@param	lw	Half line width.
	@return	1 on success, 0 on error.
*/
int
dk3fig_bb_add_polyline(
  dk3_bb_t			*bb,
  dk3_fig_det_pol_t const	*pol,
  double			 lw
);

/**	Add spline data to bounding box.
	@param	drw	Drawing structure.
	@param	bb	Bounding box data to modify.
	@param	spl	Details of spline object to add.
	@param	lw	Half line width.
	@param	primobj	Flag: Primary object (1=object, 0=arrowhead).
	@param	iscl	Flag: Closed spline (1=closed, 0=open).
	@return	1 on success, 0 on error.
*/
int
dk3fig_bb_add_spline(
  dk3_fig_drawing_t		*drw,
  dk3_bb_t			*bb,
  dk3_fig_det_spl_t const	*spl,
  double			 lw,
  int				 primobj,
  int				 iscl
);

/**	Add text data to bounding box.
	@param	bb	Bounding box data to modify.
	@param	txt	Details of text object to add.
	@param	res	Fig file resolution.
	@param	bbts	Flag: Use text size when calculating bounding box.
	@return	1 on success, 0 on error.
*/
int
dk3fig_bb_add_text(
  dk3_bb_t			*bb,
  dk3_fig_det_txt_t const	*txt,
  double			 res,
  int				 bbts
);

/**	Calculate bounding box for half-circle.
	@param	outbb	Destination bounding box.
	@param	hci	Half-circle details.
	@param	ra	Radius around points.
	@return	1 on success, 0 on error.
*/
int
dk3fig_bb_add_hci(
  dk3_bb_t			*outbb,
  dk3_fig_det_hci_t const	*hci,
  double			 ra
);

#ifdef __cplusplus
}
#endif




#endif
