/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figbb.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figbb.c The dk3figbb module.
*/


#line 126 "dk3figbb.ctr"

#include "dk3all.h"
#include "dk3fig.h"
#include "dk3bb.h"
#include "dk3xsp.h"
#include "dk3bezcu.h"
#include "dk3figto.h"
#include "dk3figbb.h"





#line 138 "dk3figbb.ctr"



/**	Check whether a value is in a given range.
	@param	min	Interval minimum.
	@param	max	Interval maximum.
	@param	val	Value to check.
	@return	1 if the value is in the interval, 0 otherwise.
*/
static
int
dk3fig_bb_in_range(double min, double max, double val)
{
  int		 back = 0;
  if(min <= val) {
    if(max >= val) {
      back = 1;
    }
  }
  return back;
}



double
dk3figbb_distance_point_line(
  double	 xp,
  double	 yp,
  double	 beta,
  int		*ec
)
{
  double	 sinbeta;	/* Sinus of angle. */
  double	 cosbeta;	/* Cosinus of angle. */
  double	 deltax;	/* X difference. */
  double	 deltay;	/* Y difference. */
  double	 back;
  

#line 176 "dk3figbb.ctr"
  sinbeta = sin(beta);
  cosbeta = cos(beta);
  deltax = dk3ma_d_sub_ok(
    xp,
    (dk3ma_d_add_ok((yp * sinbeta), (xp * cosbeta), ec) * cosbeta),
    ec
  );
  deltay = dk3ma_d_sub_ok(
    yp,
    (dk3ma_d_add_ok((yp * sinbeta), (xp * cosbeta), ec) * sinbeta),
    ec
  );
  back = sqrt(
    dk3ma_d_add_ok(
      dk3ma_d_mul_ok(deltax, deltax, ec),
      dk3ma_d_mul_ok(deltay, deltay, ec),
      ec
    )
  ); 

#line 195 "dk3figbb.ctr"
  return back;
}



int
dk3fig_bb_add_ellipse(
  dk3_bb_t			*bb,
  dk3_fig_det_ell_t const	*elli,
  double			 lw
)
{
  double		 h;		/* Height. */
  double		 w;		/* Width. */
  double		 x;		/* X coordinate of point. */
  double		 y;		/* Y coordinate of point. */
  double		 th;		/* Parameter t for Ph. */
  double		 tw;		/* Parameter t for Pw. */
  double		 pma;		/* Pi minus alpha. */
  double		 hpma;		/* Half pi minus alpha. */
  int			 back = 0;
  int			 ec = 0;	/* Error code for math. */
  int			 r;		/* Result from dk3bb_add. */
  

#line 219 "dk3figbb.ctr"
  if((bb) && (elli)) {
    back = 1;
    

#line 222 "dk3figbb.ctr"
    

#line 223 "dk3figbb.ctr"
    

#line 224 "dk3figbb.ctr"
    

#line 225 "dk3figbb.ctr"
    

#line 226 "dk3figbb.ctr"
    if(fabs(elli->an) > 1.0e-6) {	

#line 227 "dk3figbb.ctr"
      pma = dk3ma_d_sub_ok(M_PI, elli->an, &ec);
      hpma = dk3ma_d_sub_ok(M_PI_2, elli->an, &ec);
      th = dk3ma_d_atan2(
        (-1.0 * (elli->ry) * cos(pma)),
        ((elli->rx) * sin(pma))
      );			

#line 233 "dk3figbb.ctr"
      x = (elli->rx) * cos(th);	
      y = (elli->ry) * sin(th);	

#line 235 "dk3figbb.ctr"
      h = dk3figbb_distance_point_line(
        x, y, (-1.0 * (elli->an)), &ec
      );			

#line 238 "dk3figbb.ctr"
      tw = dk3ma_d_atan2(
        (-1.0 * (elli->ry) * cos(hpma)),
        ((elli->rx) * sin(hpma))
      );			

#line 242 "dk3figbb.ctr"
      x = (elli->rx) * cos(tw);
      y = (elli->ry) * cos(tw);	

#line 244 "dk3figbb.ctr"
      w = dk3figbb_distance_point_line(
        x, y, dk3ma_d_sub_ok(M_PI_2, (elli->an), &ec), &ec
      );			

#line 247 "dk3figbb.ctr"
      r = dk3bb_add_y_width(
        bb,
	dk3ma_d_sub_ok(elli->cy, h, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
      r = dk3bb_add_y_width(
        bb,
	dk3ma_d_add_ok(elli->cy, h, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
      r = dk3bb_add_x_width(
        bb,
	dk3ma_d_sub_ok(elli->cx, w, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
      r = dk3bb_add_x_width(
        bb,
	dk3ma_d_add_ok(elli->cx, w, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
    } else {				

#line 272 "dk3figbb.ctr"
      r = dk3bb_add_y_width(
        bb,
	dk3ma_d_sub_ok(elli->cy, elli->ry, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
      r = dk3bb_add_y_width(
        bb,
	dk3ma_d_add_ok(elli->cy, elli->ry, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
      r = dk3bb_add_x_width(
        bb,
	dk3ma_d_sub_ok(elli->cx, elli->rx, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
      r = dk3bb_add_x_width(
        bb,
	dk3ma_d_add_ok(elli->cx, elli->rx, &ec),
	(0.5 * lw)
      );
      if(!(r)) { back = 0; }
    }
  }
  if(ec) { back = 0; } 

#line 299 "dk3figbb.ctr"
  return back;
}



int
dk3fig_bb_add_arc(
  dk3_bb_t			*bb,
  dk3_fig_det_arc_t const	*arc,
  int				 cl,
  double			 lw
)
{
  double		min;		/* Minimum angle. */
  double		max;		/* Maximum angle. */
  int			back = 0;
  int			ec = 0;		/* Mathematical error code. */
  

#line 317 "dk3figbb.ctr"
  if((bb) && (arc)) {
    back = 1;
    if(!dk3bb_point_width(bb, arc->x1, arc->y1, lw)) { back = 0; }
    if(!dk3bb_point_width(bb, arc->x2, arc->y2, lw)) { back = 0; }
    if(!dk3bb_point_width(bb, arc->x3, arc->y3, lw)) { back = 0; }
    if(cl) { if(!dk3bb_point_width(bb, arc->xc, arc->yc, lw)) { back = 0; } }
    if(arc->ae >= arc->as) {
      min = arc->as; max = arc->ae;
    } else {
      min = arc->ae; max = arc->as;
    }	

#line 328 "dk3figbb.ctr"
    if(dk3fig_bb_in_range(min, max, 0.0)) {	

#line 329 "dk3figbb.ctr"
      if(!dk3bb_add_x_width(bb, dk3ma_d_add_ok(arc->xc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, M_PI_2)) {	

#line 334 "dk3figbb.ctr"
      if(!dk3bb_add_y_width(bb, dk3ma_d_add_ok(arc->yc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, M_PI)) {	

#line 339 "dk3figbb.ctr"
      if(!dk3bb_add_x_width(bb, dk3ma_d_sub_ok(arc->xc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, (3.0 * M_PI_2))) {	

#line 344 "dk3figbb.ctr"
      if(!dk3bb_add_y_width(bb, dk3ma_d_sub_ok(arc->yc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, (2.0 * M_PI))) {	

#line 349 "dk3figbb.ctr"
      if(!dk3bb_add_x_width(bb, dk3ma_d_add_ok(arc->xc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, (5.0 * M_PI_2))) {	

#line 354 "dk3figbb.ctr"
      if(!dk3bb_add_y_width(bb, dk3ma_d_add_ok(arc->yc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, (3.0 * M_PI))) {	

#line 359 "dk3figbb.ctr"
      if(!dk3bb_add_x_width(bb, dk3ma_d_sub_ok(arc->xc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, (7.0 * M_PI_2))) {	

#line 364 "dk3figbb.ctr"
      if(!dk3bb_add_y_width(bb, dk3ma_d_sub_ok(arc->yc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
    if(dk3fig_bb_in_range(min, max, (4.0 * M_PI))) {	

#line 369 "dk3figbb.ctr"
      if(!dk3bb_add_x_width(bb, dk3ma_d_add_ok(arc->xc, arc->ra, &ec), lw)) {
        back = 0;
      }
    }
  }
  if(ec) {
    back = 0;
  } 

#line 377 "dk3figbb.ctr"
  return back;
}




int
dk3fig_bb_add_polyline(
  dk3_bb_t			*bb,
  dk3_fig_det_pol_t const	*pol,
  double			 lw
)
{
  dk3_fig_poly_point_t const	*ptr;		/* Current point. */
  size_t			 num;		/* Index of current point. */
  int				 back = 0;
  

#line 394 "dk3figbb.ctr"
  if((bb) && (pol)) {
    if((pol->po) && (0 < pol->np)) {
      back = 1;
      ptr = pol->po;
      num = pol->np;
      while(num--) {
        if(!dk3bb_point_width(bb, ptr->x, ptr->y, lw)) { back = 0; }
        ptr++;
      }
    }
  } 

#line 405 "dk3figbb.ctr"
  return back;
}



int
dk3fig_bb_add_text(
  dk3_bb_t			*bb,
  dk3_fig_det_txt_t const	*txt,
  double			 res,
  int				 bbts
)
{
  double 	 ymax;		/* Maximum y. */
  int		 back = 0;
  int		 ec = 0;	/* Mathematical error code. */
  

#line 422 "dk3figbb.ctr"
  if((bb) && (txt)) {
    back = 1;
    dk3bb_point(bb, txt->x, txt->y);
    /*	2013-02-03: Y value is used only if bbts is set.
    */
    /*	2012-12-01: Y values grow downwards in Fig space, so we
    	must substract instead of add.
    */
    if(bbts) {
      ymax = dk3ma_d_sub_ok(
        txt->y,
        dk3ma_d_mul_ok(res, (txt->fs / 72.72), &ec),
        &ec
      ); 

#line 436 "dk3figbb.ctr"
      dk3bb_point(bb, txt->x, ymax);
    }
    if(ec) {
      back = 0;
    }
  } 

#line 442 "dk3figbb.ctr"
  return back;
}



/**	Add X-spline segment to bounding box.
	@param	bb	Bounding box structure to modify.
	@param	pa	Point A (left neighbour of segment).
	@param	pb	Point B (start of segment).
	@param	pc	Point C (end of segment).
	@param	pd	Point D (right neighbour of segment).
	@param	xssbs	Number of Bezier spline segments per X-spline segment.
	@param	cb	Flag: Compatibility to XFig interpolated spline bug.
	@param	ra	Radius of points.
	@return	1 on success, 0 on error.
*/
static
int
dk3fig_bb_add_xpline_segment(
  dk3_bb_t			*bb,
  dk3_fig_spline_point_t	*pa,
  dk3_fig_spline_point_t	*pb,
  dk3_fig_spline_point_t	*pc,
  dk3_fig_spline_point_t	*pd,
  size_t			 xssbs,
  int				 cb,
  double			 ra
)
{
  dk3_xspline_segment_t	 xseg;		/* Spline segment. */
  double		 x;		/* Current x. */
  double		 y;		/* Current y. */
  double		 lastx;		/* Previous x. */
  double		 lasty;		/* Previous y. */
  double		 dxdt;		/* X derived. */
  double		 dydt;		/* Y derived. */
  double		 lastdxdt;	/* X derived, previous value. */
  double		 lastdydt;	/* Y derived, previous value. */
  double		 xp;		/* Start control point x. */
  double		 yp;		/* Start control point y. */
  double		 xm;		/* End control point x. */
  double		 ym;		/* End control point y. */
  double		 t;		/* Current t value. */
  double		 dxssbs;	/* Number of sub segments. */
  double		 d3;		/* Scale factor for derivatives. */
  size_t		 i;		/* Current sub segment. */
  int			 back = 1;
  int			 mec = 0;	/* Mathematical error code. */
  

#line 491 "dk3figbb.ctr"
  dk3xsp_reset(&xseg);
  if(cb) { dk3xsp_set_cb(&xseg, cb); }
  dk3xsp_set(&xseg, pa, pb, pc, pd);
  if(dk3xsp_calculate(&xseg, 0.0, 1)) {		

#line 495 "dk3figbb.ctr"
    dxssbs = (double)xssbs;
    d3 = dk3ma_d_mul_ok(3.0, dxssbs, &mec);
    lastx = dk3xsp_get_x(&xseg);
    lasty = dk3xsp_get_y(&xseg);
    lastdxdt = dk3xsp_get_dxdt(&xseg);
    lastdydt = dk3xsp_get_dydt(&xseg);
    for(i = 1; i <= xssbs; i++) {
      if(i < xssbs) {
        t = (double)i / dxssbs;
      } else {
        t = 1.0;
      }
      if(dk3xsp_calculate(&xseg, t, 1)) {
        x = dk3xsp_get_x(&xseg);
	y = dk3xsp_get_y(&xseg);
	dxdt = dk3xsp_get_dxdt(&xseg);
	dydt = dk3xsp_get_dydt(&xseg);
	xp = dk3ma_d_add_ok(
	  lastx,
	  dk3ma_d_div_ok(lastdxdt, d3, &mec),
	  &mec
	);
	yp = dk3ma_d_add_ok(
	  lasty,
	  dk3ma_d_div_ok(lastdydt, d3, &mec),
	  &mec
	);
	xm = dk3ma_d_sub_ok(
	  x,
	  dk3ma_d_div_ok(dxdt, d3, &mec),
	  &mec
	);
	ym = dk3ma_d_sub_ok(
	  y,
	  dk3ma_d_div_ok(dydt, d3, &mec),
	  &mec
	);
	if(!dk3bezier_bb(bb, lastx, lasty, xp, yp, xm, ym, x, y, ra, &mec)) {
	  back = 0;				

#line 534 "dk3figbb.ctr"
	}
	lastx = x;
	lasty = y;
	lastdxdt = dxdt;
	lastdydt = dydt;
      } else {					

#line 540 "dk3figbb.ctr"
        back = 0;
      }
    }
  } else {					

#line 544 "dk3figbb.ctr"
    back = 0;
  }
  if(mec) {					

#line 547 "dk3figbb.ctr"
    back = 0;
  } 

#line 549 "dk3figbb.ctr"
  return back;
}



int
dk3fig_bb_add_spline(
  dk3_fig_drawing_t		*drw,
  dk3_bb_t			*bb,
  dk3_fig_det_spl_t const	*spl,
  double			 lw,
  int				 primobj,
  int				 iscl
)
{
  dk3_fig_spline_point_t	*pa;	/* Point A. */
  dk3_fig_spline_point_t	*pb;	/* Point B. */
  dk3_fig_spline_point_t	*pc;	/* Point C. */
  dk3_fig_spline_point_t	*pd;	/* Point D. */
  size_t	 xssbs;		/* Bezier segments per X-spline segment. */
  size_t	 cs;		/* Current X-spline segment. */
  int		 back = 0;
  

#line 572 "dk3figbb.ctr"
  if((bb) && (spl)) {
    if((spl->po) && (((iscl) ? (size_t)2 : (size_t)1) < spl->np)) {
      back = 1;
      xssbs = dk3fig_tool_xssbs(drw, primobj);
      if(iscl) {			

#line 577 "dk3figbb.ctr"
        for(cs = 0; cs < (spl->np); cs++) {
	  pb = &((spl->po)[cs]);
	  pc = &((spl->po)[((cs < (spl->np - 1)) ? (cs + 1) : 0)]);
	  pa = &((spl->po)[(cs > 0) ? (cs - 1) : ((spl->np) - 1)]);
	  pd = &((spl->po)[(cs < (spl->np - 2))?(cs + 2):(cs + 2 - spl->np)]);
	  if(!dk3fig_bb_add_xpline_segment(bb,pa,pb,pc,pd,xssbs,drw->cosp,lw)) {
	    back = 0;
	  }
	}
      } else {				

#line 587 "dk3figbb.ctr"
        for(cs = 0; cs < ((spl->np) - 1); cs++) {
	  pa = pd = NULL;
	  pb = &((spl->po)[cs]);
	  pc = &((spl->po)[cs + 1]);
	  if(0 < cs) { pa = &((spl->po)[cs - 1]); }
	  if(cs < ((spl->np) - 2)) { pd = &((spl->po)[cs + 2]); }
	  if(!dk3fig_bb_add_xpline_segment(bb,pa,pb,pc,pd,xssbs,drw->cosp,lw)) {
	    back = 0;
	  }
	}
      }
    } else {			

#line 599 "dk3figbb.ctr"
    }
  } 

#line 601 "dk3figbb.ctr"
  return back;
}



int
dk3fig_bb_add_hci(
  dk3_bb_t		 	*outbb,
  dk3_fig_det_hci_t const	*hci,
  double			 ra
)
{
  dk3_fig_poly_point_t	po[3];		/* End and middle point of arc. */
  size_t		i;		/* Used as index when rotating. */
  int		 	back = 0;
  int			mec = 0;	/* Mathematical error code. */
  if((outbb) && (hci)) {
    po[0].x = 0.0;
    po[0].y = hci->ra;
    po[1].x = -1.0 * hci->ra;
    po[1].y = 0.0;
    po[2].x = 0.0;
    po[2].y = -1.0 * hci->ra;
    for(i = 0; i < 3; i++) {
      dk3fig_tool_rotate_point(&(po[i]), hci->an, &mec);
      dk3fig_tool_shift_point(
	&(po[i]), hci->cx, hci->cy, &mec
      );
    }
    if(0 == mec) { 
      back = 1;
      if(!dk3bb_point_width(outbb, po[0].x, po[0].y, ra)) { back = 0; }
      if(!dk3bb_point_width(outbb, po[1].x, po[1].y, ra)) { back = 0; }
      if(!dk3bb_point_width(outbb, po[2].x, po[2].y, ra)) { back = 0; }
      /* ##### HIER WEITER: Weitere Punkte je nach Drehung */
    }
  }
  return back;
}


