/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3figah.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3figah.c The dk3figah module.
*/


#line 40 "dk3figah.ctr"

#include "dk3all.h"
#include "dk3fig.h"
#include "dk3figto.h"
#include "dk3figpr.h"
#include "dk3figbb.h"
#include "dk3figah.h"
#include "dk3xsp.h"




#line 51 "dk3figah.ctr"



/**	Calculate c_min (minimum length to cut).
	@param	drw	Drawing.
	@param	obj	Object to calculate arrowheads for.
	@param	ah	Arrowhead data.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	The c_min value.
*/
static
double
dk3figah_cmin(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		back;
  double		h;
  double		w;
  double		lw;	/* Line width. */
  

#line 75 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  h  = ah->he;
  w  = ah->wi;
  switch(ah->as) {
    case DK3_FIG_AS_INDENTED:
    case DK3_FIG_AS_INDENTED_FILLED_HALF:
    {
      h = dk3ma_d_mul_ok(1.25, h, ec);
    } break;
    case DK3_FIG_AS_POINTED: {
      h = 0.75 * h;
    } break;
    case DK3_FIG_AS_RHOMBUS: {
      h = 0.5 * h;
    } break;
  }
  back = dk3ma_d_div_ok(dk3ma_d_mul_ok(lw, h, ec), w, ec);
  

#line 93 "dk3figah.ctr"
  return back;
}



/**	Calculate s value for arrowhead.
	@param	drw	Drawing.
	@param	obj	Object to calculate arrowheads for.
	@param	ah	Arrowhead data.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	The s value.
*/
static
double
dk3figah_s(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		back;
  double		lw;	/* Line width. */
  double		h;	/* Arrow height (length). */
  double		w;	/* Arrow width. */
  

#line 119 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  h  = ah->he;
  w  = ah->wi;
  switch(ah->as) {
    case DK3_FIG_AS_INDENTED:
    case DK3_FIG_AS_INDENTED_FILLED_HALF:
    {
      h = dk3ma_d_mul_ok(1.25, h, ec);		

#line 127 "dk3figah.ctr"
    } break;
    case DK3_FIG_AS_POINTED: {
      h = 0.75 * h;				

#line 130 "dk3figah.ctr"
    } break;
    case DK3_FIG_AS_RHOMBUS: {
      h = 0.5 * h;				

#line 133 "dk3figah.ctr"
    } break;
  }
  back = dk3ma_d_mul_ok(
    dk3ma_d_div_ok(lw, w, ec),
    sqrt(
      dk3ma_d_add_ok(
	dk3ma_d_square_ok(h, ec),
	dk3ma_d_div_ok(
	  dk3ma_d_square_ok(w, ec),
	  4.0,
	  ec
	),
	ec
      )
    ),
    ec
  ); 

#line 150 "dk3figah.ctr"
  return back;
}



/**	Calculate s value for half arrowhead.
	@param	drw	Drawing.
	@param	obj	Object to calculate arrowheads for.
	@param	ah	Arrowhead data.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	The s value.
*/
static
double
dk3figah_half_arrow_s(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		back;
  double		lw;	/* Line width. */
  double		h;	/* Arrow height (length). */
  double		w;	/* Arrow width. */
  

#line 176 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  h  = ah->he;
  w  = ah->wi;
  switch(ah->as) {
    case DK3_FIG_AS_INDENTED_HALF:
    {
      h = dk3ma_d_mul_ok(1.25, h, ec);		

#line 183 "dk3figah.ctr"
    } break;
    case DK3_FIG_AS_BUTTED_HALF: {
      h = 0.75 * h;				

#line 186 "dk3figah.ctr"
    } break;
  }
  back = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(2.0, dk3ma_d_mul_ok(h, lw, ec), ec), w, ec
  );
  

#line 192 "dk3figah.ctr"
  return back;
}



#if 0
/**	Calculate c_max value for arrowhead.
	@param	drw	Drawing.
	@param	obj	Object to calculate arrowheads for.
	@param	ah	Arrowhead data.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	The c_max value.
*/
static
double
dk3figah_cmax(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		back;
  

#line 216 "dk3figah.ctr"
  back = dk3ma_d_mul_ok(
    2.0,
    dk3figah_s(drw, obj, ah, ec),
    ec
  ); 

#line 221 "dk3figah.ctr"
  return back;
}
#endif



/**	Calculate length correction for normal arrows.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_normal_arrow_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double	 back = 0.0;
  double	 cmin;
  double	 s;
  

#line 247 "dk3figah.ctr"
  cmin = dk3figah_cmin(drw, obj, ah, ec);
  s    = dk3figah_s(drw, obj, ah, ec);
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING:
    case DK3_FIG_LC_ROUND: {
      back = dk3ma_d_add_ok(
        dk3ma_d_mul_ok(1.5, s, ec),
	(0.5 * cmin),
	ec
      );
    } break;
    default: {
      back = dk3ma_d_add_ok(s, (0.5 * cmin), ec);
    } break;
  } 

#line 262 "dk3figah.ctr"
  return back;
}




/**	Calculate length correction tolerance for normal arrows.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_normal_arrow_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double	 back;
  double	 cmin;
  double	 s;
  

#line 288 "dk3figah.ctr"
  cmin = dk3figah_cmin(drw, obj, ah, ec);
  s    = dk3figah_s(drw, obj, ah, ec);
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING:
    case DK3_FIG_LC_ROUND: {
      back = 0.25 * dk3ma_d_sub_ok(s, cmin, ec);
    } break;
    default: {
      back = dk3ma_d_sub_ok((0.5 * s), (0.25 * cmin), ec);
    } break;
  } 

#line 299 "dk3figah.ctr"
  return back;
}



/**	Calculate length correction for blocking line arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_block_line_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		 back = 0.0;
  

#line 322 "dk3figah.ctr"
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING:
    case DK3_FIG_LC_ROUND: {
      back = 0.75 * dk3fig_tool_get_lw(drw, obj, ec);
    } break;
    default: {
      back = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
    } break;
  } 

#line 331 "dk3figah.ctr"
  return back;
}



/**	Calculate length correction tolerance for blocking line arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_block_line_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		 back = 0.0;
  

#line 354 "dk3figah.ctr"
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING:
    case DK3_FIG_LC_ROUND: {
      back = 0.125 * dk3fig_tool_get_lw(drw, obj, ec);
    } break;
    default: {
      back = 0.25 * dk3fig_tool_get_lw(drw, obj, ec);
    } break;
  } 

#line 363 "dk3figah.ctr"
  return back;
}



/**	Length correction for inverted open arrow.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_anti_arrow_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		 back;
  double		 sqv;
  double		 lw;
  double		 cmin;
  double		 cmax;
  

#line 390 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  sqv = sqrt(
    dk3ma_d_add_ok(
      dk3ma_d_square_ok(ah->wi, ec),
      dk3ma_d_mul_ok(
        4.0,
	dk3ma_d_square_ok(ah->he, ec),
	ec
      ),
      ec
    )
  );
  sqv = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(lw, sqv, ec),
    dk3ma_d_mul_ok(2.0, ah->wi, ec),
    ec
  );
  cmin = dk3ma_d_sub_ok(ah->he, sqv, ec);
  cmax = dk3ma_d_sub_ok(
    dk3ma_d_add_ok(ah->he, sqv, ec),
    dk3ma_d_div_ok(
      dk3ma_d_mul_ok(lw, ah->he, ec),
      ah->wi,
      ec
    ),
    ec
  );
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      sqv = dk3ma_d_sub_ok(
        dk3ma_d_sub_ok(cmax, cmin, ec),
	(0.5 * lw),
	ec
      );
      back = dk3ma_d_sub_ok(
        cmax,
	(0.5 * sqv),
	ec
      );
    } break;
    default: {
      back = 0.5 * dk3ma_d_add_ok(cmin, cmax, ec);
    } break;
  } 

#line 434 "dk3figah.ctr"
  return back;
}



/**	Length correction tolerance for inverted open arrow.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_anti_arrow_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		 back;
  double		 sqv;
  double		 lw;
  double		 cmin;
  double		 cmax;
  

#line 461 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  sqv = sqrt(
    dk3ma_d_add_ok(
      dk3ma_d_square_ok(ah->wi, ec),
      dk3ma_d_mul_ok(
        4.0,
	dk3ma_d_square_ok(ah->he, ec),
	ec
      ),
      ec
    )
  );
  sqv = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(lw, sqv, ec),
    dk3ma_d_mul_ok(2.0, ah->wi, ec),
    ec
  );
  cmin = dk3ma_d_sub_ok(ah->he, sqv, ec);
  cmax = dk3ma_d_sub_ok(
    dk3ma_d_add_ok(ah->he, sqv, ec),
    dk3ma_d_div_ok(
      dk3ma_d_mul_ok(lw, ah->he, ec),
      ah->wi,
      ec
    ),
    ec
  );
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = 0.25 * dk3ma_d_sub_ok(
        dk3ma_d_sub_ok(cmax, cmin, ec),
	(0.5 * lw),
	ec
      );
    } break;
    default: {
      back = 0.25 * dk3ma_d_sub_ok(cmax, cmin, ec);
    } break;
  } 

#line 500 "dk3figah.ctr"
  return back;
}



/**	Length correction for full circle arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_full_circle_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double back;
  double lw;
  double cmin;
  double cmax;
  

#line 526 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  cmin = 0.5 * dk3ma_d_mul_ok(
    dk3ma_d_add_ok(ah->he, lw, ec),
    dk3ma_d_sub_ok(
      1.0,
      sqrt(
        dk3ma_d_sub_ok(
	  1.0,
	  dk3ma_d_square_ok(
	    dk3ma_d_div_ok(
	      lw,
	      dk3ma_d_add_ok(lw, ah->he, ec),
	      ec
	    ),
	    ec
	  ),
	  ec
	)
      ),
      ec
    ),
    ec
  );
  cmax = lw;
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = dk3ma_d_sub_ok(
        cmax,
	(0.5 * dk3ma_d_sub_ok(dk3ma_d_sub_ok(cmax, cmin, ec), (0.5 * lw), ec)),
	ec
      );
    } break;
    default: {
      back = 0.5 * dk3ma_d_add_ok(cmax, cmin, ec);
    } break;
  } 

#line 562 "dk3figah.ctr"
  return back;
}



/**	Length correction tolerance for full circle arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_full_circle_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double back;
  double lw;
  double cmin;
  double cmax;
  

#line 588 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  cmin = 0.5 * dk3ma_d_mul_ok(
    dk3ma_d_add_ok(ah->he, lw, ec),
    dk3ma_d_sub_ok(
      1.0,
      sqrt(
        dk3ma_d_sub_ok(
	  1.0,
	  dk3ma_d_square_ok(
	    dk3ma_d_div_ok(
	      lw,
	      dk3ma_d_add_ok(lw, ah->he, ec),
	      ec
	    ),
	    ec
	  ),
	  ec
	)
      ),
      ec
    ),
    ec
  );
  cmax = lw;
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = 0.25 * dk3ma_d_sub_ok(
        dk3ma_d_sub_ok(cmax, cmin, ec),
	(0.5 * lw),
	ec
      );
    } break;
    default: {
      back = 0.25 * dk3ma_d_sub_ok(cmax, cmin, ec);
    } break;
  } 

#line 624 "dk3figah.ctr"
  return back;
}



/**	Length correction for half circle arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length correction value.
*/
static
double
dk3figah_half_circle_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double back;
  double lw;
  double cmin;
  double cmax;
  

#line 650 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  cmin = dk3ma_d_sub_ok(
    (0.5 * ah->he),
    (0.5 * lw),
    ec
  );
  cmax = dk3ma_d_add_ok(
    (0.5 * ah->he),
    (0.5 * lw),
    ec
  );
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = dk3ma_d_add_ok(
        (0.5 * ah->he),
	(0.25 * lw),
	ec
      );
    } break;
    default: {
      back = 0.5 * ah->he;
    } break;
  } 

#line 673 "dk3figah.ctr"
  return back;
}




#if VERSION_BEFORE_20121215
/**	Length correction for half-arrow arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	incr	Flag: Increase (1=increase, 0=no op, -1=decrease).
	@return	Length correction value.
*/
static
double
dk3figah_half_arrow_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec,
  int			 incr
)
{
  double	 back;
  double	 lw;
  double	 cmin;
  double	 d;
  double	 cmax;
  

#line 704 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  cmin = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(
      dk3ma_d_mul_ok(lw, ah->he, ec),
      2.0,
      ec
    ),
    ah->wi,
    ec
  );
  d = dk3ma_d_div_ok(
    lw,
    dk3ma_d_mul_ok(
      2.0,
      tan(
        0.5 * atan(
	  dk3ma_d_div_ok(
	    ah->wi,
	    dk3ma_d_mul_ok(2.0, ah->he, ec),
	    ec
	  )
	)
      ),
      ec
    ),
    ec
  );
  cmax = dk3ma_d_add_ok(d, (0.5 * lw), ec);
  cmax = dk3ma_d_add_ok(
    cmax,
    dk3ma_d_mul_ok(
      ((incr > 0) ? 1.25 : ((incr < 0) ? 0.75 : 1.0)),
      ah->he,
      ec
    ),
    ec
  );
  if(cmax > dk3ma_d_add_ok(cmin, lw, ec)) {
    cmax = dk3ma_d_add_ok(cmin, lw, ec);
  }
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = dk3ma_d_sub_ok(
        cmax,
	(0.5 * dk3ma_d_sub_ok(dk3ma_d_sub_ok(cmax, cmin, ec), (0.5*lw), ec)),
	ec
      );
    } break;
    default: {
      back = 0.5 * dk3ma_d_add_ok(cmax, cmin, ec);
    } break;
  } 

#line 756 "dk3figah.ctr"
  return back;
}
#else
/**	Length correction for half-arrow arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	incr	Flag: Increase (1=increase, 0=no op, -1=decrease).
	@return	Length correction value.
*/
static
double
dk3figah_half_arrow_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec,
  int			 incr
)
{
  double	 back;
  double	 lw;		/* Line width. */
  double	 cmin;		/* Minimum correction. */
  double	 cmax;		/* Maximum correction. */
  double	 d;		/* Shift value. */
  double	 w;		/* Arrowhead width. */
  double	 h;		/* Arrowhead height. */

  

#line 786 "dk3figah.ctr"
  w  = ah->wi;
  h  = ah->he;
  switch(incr) {
    case -1: {		/* indented */
      h = dk3ma_d_mul_ok(1.25, h, ec);
    } break;
    case  1: {		/* butted */
      h = 0.75 * h;
    } break;
  }
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  

#line 798 "dk3figah.ctr"
  cmin = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(2.0, dk3ma_d_mul_ok(h, lw, ec), ec), w, ec
  );
  d = dk3ma_d_div_ok(
    lw,
    dk3ma_d_mul_ok(
      2.0,tan(0.5 * atan(dk3ma_d_div_ok(w, dk3ma_d_mul_ok(2.0, h, ec), ec))),ec
    ),
    ec
  );
  cmax = dk3ma_d_mul_ok(2.0, d, ec);
  

#line 810 "dk3figah.ctr"
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = dk3ma_d_sub_ok(
        (0.5 * lw),
	(0.5 * dk3ma_d_sub_ok(dk3ma_d_sub_ok(cmax, cmin, ec), (0.5*lw), ec)),
	ec
      );
    } break;
    default: {
      back = 0.5 * dk3ma_d_add_ok(cmax, cmin, ec);
    } break;
  } 

#line 822 "dk3figah.ctr"
  return back;
}
#endif


#if VERSION_BEFORE_20121215
/**	Length correction tolerance for half-arrow arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	incr	Flag: Increase (1=increase, 0=no op, -1=decrease).
	@return	Length correction tolerance value.
*/
static
double
dk3figah_half_arrow_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec,
  int			 incr
)
{
  double	 back;
  double	 lw;
  double	 cmin;
  double	 d;
  double	 cmax;
  

#line 852 "dk3figah.ctr"
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  cmin = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(
      dk3ma_d_mul_ok(lw, ah->he, ec),
      2.0,
      ec
    ),
    ah->wi,
    ec
  );
  d = dk3ma_d_div_ok(
    lw,
    dk3ma_d_mul_ok(
      2.0,
      tan(
        0.5 * atan(
	  dk3ma_d_div_ok(
	    ah->wi,
	    dk3ma_d_mul_ok(2.0, ah->he, ec),
	    ec
	  )
	)
      ),
      ec
    ),
    ec
  );
  cmax = dk3ma_d_add_ok(d, (0.5 * lw), ec);
  cmax = dk3ma_d_add_ok(
    cmax,
    dk3ma_d_mul_ok(
      ((incr > 0) ? 1.25 : ((incr < 0) ? 0.75 : 1.0)),
      ah->he,
      ec
    ),
    ec
  );
  if(cmax > dk3ma_d_add_ok(cmin, lw, ec)) {
    cmax = dk3ma_d_add_ok(cmin, lw, ec);
  }
  switch(obj->cs) {
    case DK3_FIG_LC_PROJECTING: case DK3_FIG_LC_ROUND: {
      back = 0.25 * dk3ma_d_sub_ok(dk3ma_d_sub_ok(cmax,cmin,ec),(0.5 * lw),ec);
    } break;
    default: {
      back = 0.25 * dk3ma_d_sub_ok(cmax, cmin, ec);
    } break;
  } 

#line 900 "dk3figah.ctr"
  return back;
}
#else

/**	Length correction tolerance for half-arrow arrowhead.
	@param	drw	Drawing structure.
	@param	obj	Object to modify.
	@param	ah	Arrowhead to calculate length correction for.
	@param	ec	Pointer to error code variable, may be NULL.
	@param	incr	Flag: Increase (1=increase, 0=no op, -1=decrease).
	@return	Length correction tolerance value.
*/
static
double
dk3figah_half_arrow_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec,
  int			 incr
)
{
  double	 back;
  double	 lw;		/* Line width. */
  double	 cmin;		/* Minimum correction. */
  double	 cmax;		/* Maximum correction. */
  double	 d;		/* Shift value. */
  double	 w;		/* Arrowhead width. */
  double	 h;		/* Arrowhead height. */

  

#line 931 "dk3figah.ctr"
  w  = ah->wi;
  h  = ah->he;
  switch(incr) {
    case -1: {		/* indented */
      h = dk3ma_d_mul_ok(1.25, h, ec);
    } break;
    case  1: {		/* butted */
      h = 0.75 * h;
    } break;
  }
  lw = dk3fig_tool_get_lw(drw, obj, ec);
  

#line 943 "dk3figah.ctr"
  cmin = dk3ma_d_div_ok(
    dk3ma_d_mul_ok(2.0, dk3ma_d_mul_ok(h, lw, ec), ec), w, ec
  );
  d = dk3ma_d_div_ok(
    lw,
    dk3ma_d_mul_ok(
      2.0,tan(0.5 * atan(dk3ma_d_div_ok(w, dk3ma_d_mul_ok(2.0, h, ec), ec))),ec
    ),
    ec
  );
  cmax = dk3ma_d_mul_ok(2.0, d, ec);
  

#line 955 "dk3figah.ctr"
  back = 0.25 * fabs(dk3ma_d_sub_ok(cmax, cmin, ec));
  

#line 957 "dk3figah.ctr"
  return back;
}
#endif



/**	Calculate length correction for arrowhead.
	Amount to cut the original line.
	@param	drw	Drawing.
	@param	obj	Object to calculate arrowheads for.
	@param	ah	Arrowhead data.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Length to cut from line.
*/
static
double
dk3figah_length_correction(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		 back = 0.0;
  

#line 982 "dk3figah.ctr"
  switch(ah->as) {
    case DK3_FIG_AS_RHOMBUS: {			/*  4 */
      if((1 == ah->af) && (DK3_FIG_SRCTYPE_JFIG == drw->srctype)) {
	back = 0.0;
      } else {
        back = dk3figah_normal_arrow_length_correction(drw, obj, ah, ec);
      }
    } break;
    case DK3_FIG_AS_FULL_CIRCLE_END: {		/*  5 */
      back = dk3figah_full_circle_length_correction(drw, obj, ah, ec);
    } break;
    case DK3_FIG_AS_RECTANGLE:			/*  7 */
    case DK3_FIG_AS_INVERSE:			/*  8 */
    {
      back = dk3figah_block_line_length_correction(drw, obj, ah, ec);
    } break;
    case DK3_FIG_AS_HALF_CIRCLE_END: {		/*  6 */
      if(1 == ah->af) {
        back = dk3figah_block_line_length_correction(drw, obj, ah, ec);
      } else {
        back = dk3figah_half_circle_length_correction(drw, obj, ah, ec);
      }
    } break;
    case DK3_FIG_AS_CLOSED_HALF: {		/* 10 */
      back = dk3figah_half_arrow_length_correction(drw, obj, ah, ec, 0);
    } break;
    case DK3_FIG_AS_INDENTED_HALF: {		/* 11 */
      back = dk3figah_half_arrow_length_correction(drw, obj, ah, ec, -1);
    } break;
    case DK3_FIG_AS_BUTTED_HALF: {		/* 12 */
      back = dk3figah_half_arrow_length_correction(drw, obj, ah, ec, 1);
    } break;
    case DK3_FIG_AS_TRIANGLE_FORK: {		/* 13 */
      if(1 == ah->af) {
        back = dk3figah_block_line_length_correction(drw, obj, ah, ec);
      } else {
        back = dk3figah_anti_arrow_length_correction(drw, obj, ah, ec);
      }
    } break;
    case DK3_FIG_AS_RECTANGLE_FORK: {		/* 14 */
      if(1 == ah->af) {
        back = dk3figah_block_line_length_correction(drw, obj, ah, ec);
      } else {
#if 0
	back = dk3figah_block_line_length_correction(drw, obj, ah, ec);
#endif
	back = dk3ma_d_add_ok(back, ah->he, ec);	

#line 1029 "dk3figah.ctr"
      }
    } break;
    default: {
      back = dk3figah_normal_arrow_length_correction(drw, obj, ah, ec);
    } break;
  } 

#line 1035 "dk3figah.ctr"
  return back;
}



/**	Calculate length correction tolerance for arrowhead.
	@param	drw	Drawing.
	@param	obj	Object to calculate arrowheads for.
	@param	ah	Arrowhead data.
	@param	ec	Pointer to error code variable, may be NULL.
	@return	Tolerance for length to cut from line.
*/
static
double
dk3figah_length_correction_tolerance(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			*ec
)
{
  double		 back;
  

#line 1058 "dk3figah.ctr"
  switch(ah->as) {
    case DK3_FIG_AS_RHOMBUS: {			/*  4 */
      if((1 == ah->af) && (DK3_FIG_SRCTYPE_JFIG == drw->srctype)) {
        back = 0.0;
      } else {
        back = dk3figah_normal_arrow_length_correction_tolerance(drw,obj,ah,ec);
      }
    } break;
    case DK3_FIG_AS_FULL_CIRCLE_END: {		/*  5 */
      back = dk3figah_full_circle_length_correction_tolerance(drw,obj,ah,ec);
    } break;
    case DK3_FIG_AS_RECTANGLE:			/*  7 */
    case DK3_FIG_AS_INVERSE:			/*  8 */
    {
      back = dk3figah_block_line_length_correction_tolerance(drw,obj,ah,ec);
    } break;
    case DK3_FIG_AS_HALF_CIRCLE_END: {		/*  6 */
      back = dk3figah_block_line_length_correction_tolerance(drw,obj,ah,ec);
    } break;
    case DK3_FIG_AS_CLOSED_HALF: {		/* 10 */
      back = dk3figah_half_arrow_length_correction_tolerance(drw,obj,ah,ec,0);
    } break;
    case DK3_FIG_AS_INDENTED_HALF: {		/* 11 */
      back = dk3figah_half_arrow_length_correction_tolerance(drw,obj,ah,ec,-1);
    } break;
    case DK3_FIG_AS_BUTTED_HALF: {		/* 12 */
      back = dk3figah_half_arrow_length_correction_tolerance(drw,obj,ah,ec,1);
    } break;
    case DK3_FIG_AS_TRIANGLE_FORK: {		/* 13 */
      if(1 == ah->af) {
        back = dk3figah_block_line_length_correction_tolerance(drw,obj,ah,ec);
      } else {
        back = dk3figah_anti_arrow_length_correction_tolerance(drw,obj,ah,ec);
      }
    } break;
    case DK3_FIG_AS_RECTANGLE_FORK: {		/* 14 */
      back = dk3figah_block_line_length_correction_tolerance(drw,obj,ah,ec);
    } break;
    default: {
      back = dk3figah_normal_arrow_length_correction_tolerance(drw,obj,ah,ec);
    } break;
  } 

#line 1100 "dk3figah.ctr"
  return back;
}



int
dk3figah_candidate(dk3_fig_obj_t *obj)
{
  int		 back = 0;
  

#line 1110 "dk3figah.ctr"
  if(obj) {
    switch(obj->ot) {
      case DK3_FIG_OBJ_POLYLINE: {
        switch(obj->st) {
	  case 1: { back = 1; } break;
	}
      } break;
      case DK3_FIG_OBJ_SPLINE: {
        switch(obj->st) {
	  case 0: case 2: case 4: { back = 1; } break;
	}
      } break;
      case DK3_FIG_OBJ_ARC: {
        switch(obj->st) {
	  case 1: { back = 1; } break;
	}
      } break;
    }
    if(back) {
      if(!((obj->af) || (obj->ab))) {
        back = 0;
      }
    }
  } 

#line 1134 "dk3figah.ctr"
  return back;
}



/**	Find distance to shift arrowhead polygon point from end point.
	@param	drw	Drawing structure.
	@param	obj	Object containing the arrowhead.
	@param	ah	Arrowhead.
	@param	ec	Pointer to error code variable.
	@return	Non-negative distance on success, negative value on error.
*/
static
double
dk3figah_find_shift_length(
  dk3_fig_drawing_t		*drw,
  dk3_fig_obj_t			*obj,
  dk3_fig_ah_t			*ah,
  int				*ec
)
{
  double		back = 0.0;
  

#line 1157 "dk3figah.ctr"
  switch(ah->as) {
    case DK3_FIG_AS_TRIANGLE_FORK: {
      if(ah->af) {
        back = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
      } else {
      }
    } break;
    case DK3_FIG_AS_RECTANGLE_FORK: {
      if(ah->af) {
        back = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
      }
    } break;
    case DK3_FIG_AS_FULL_CIRCLE_END:
    case DK3_FIG_AS_HALF_CIRCLE_END:
    case DK3_FIG_AS_RECTANGLE:
    case DK3_FIG_AS_INVERSE:
    {
      back = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
    } break;
    case DK3_FIG_AS_INDENTED_FILLED_HALF:
    case DK3_FIG_AS_STICK:
    case DK3_FIG_AS_CLOSED:
    case DK3_FIG_AS_INDENTED:
    case DK3_FIG_AS_POINTED:
    case DK3_FIG_AS_RHOMBUS:
    {
      back = dk3figah_s(drw, obj, ah, ec);
    } break;
    case DK3_FIG_AS_CLOSED_HALF:
    case DK3_FIG_AS_INDENTED_HALF:
    case DK3_FIG_AS_BUTTED_HALF: {
      back = dk3figah_half_arrow_s(drw, obj, ah, ec);
    } break;
  } 

#line 1191 "dk3figah.ctr"
  return back;
}



/**	Arrowhead for polylines or compatible arrowheads.
	@param	drw		Drawing structure.
	@param	obj		Fig object.
	@param	ah		Arrowhead to modify.
	@param	ep		Endpoint of the arrowhead.
	@param	rotation	Arrowhead direction in radians.
	@param	ec		Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_straight_arrowhead(
  dk3_fig_drawing_t		*drw,
  dk3_fig_obj_t			*obj,
  dk3_fig_ah_t			*ah,
  dk3_fig_poly_point_t		*ep,
  double			 rotation,
  int				*ec
)
{
  dk3_fig_poly_point_t	 aep;
  dk3_fig_poly_point_t	 po[8];
  double		 s;		/* Shifting the first point */
  size_t		 i;
  int			 back = 0;
  

#line 1222 "dk3figah.ctr"
  dk3mem_cpy((void *)(&aep), (void *)ep, sizeof(dk3_fig_poly_point_t));
  switch(ah->as) {
    case DK3_FIG_AS_STICK: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
        aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y = 0.5 * ah->wi;
      po[1].x = 0.0;
      po[1].y = 0.0;
      po[2].x = po[0].x;
      po[2].y = -0.5 * ah->wi;
      for(i = 0; i < 3; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      ah->o1 = dk3fig_obj_new(
        obj->li, obj->la,		/* Line number, layer */
	DK3_FIG_OBJ_POLYLINE, 1,	/* Object type, subtype */
	obj->lw, obj->pc, obj->pc, -1,	/* line width, pen, fill, style */
	DK3_FIG_LC_BUTT,		/* line cap */
	DK3_FIG_LJ_MITER,		/* line join */
	DK3_FIG_LS_SOLID,		/* line style */
	1.0,				/* style value, unused */
	0, 0,				/* arrowheads flags */
	3,				/* Number of points */
	NULL,				/* Text */
	drw->app			/* Application */
      );
      if(ah->o1) {
	if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    (void *)po,
	    (3 * sizeof(dk3_fig_poly_point_t))
	  );
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_CLOSED: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
        aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y = 0.5 * ah->wi;
      po[1].x = 0.0;
      po[1].y = 0.0;
      po[2].x = po[0].x;
      po[2].y = -0.5 * ah->wi;
      for(i = 0; i < 3; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
	if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    (void *)po,
	    (3 * sizeof(dk3_fig_poly_point_t))
	  );
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_INDENTED: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
        aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = dk3ma_d_mul_ok(-1.25, ah->he, ec);
      po[0].y = 0.5 * ah->wi;
      po[1].x = 0.0;
      po[1].y = 0.0;
      po[2].x = po[0].x;
      po[2].y = -0.5 * ah->wi;
      po[3].x = -1.0 * ah->he;
      po[3].y = 0.0;
      for(i = 0; i < 4; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  4,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  4,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
	if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    (void *)po,
	    (4 * sizeof(dk3_fig_poly_point_t))
	  );
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_POINTED: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
        aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -0.75 * ah->he;
      po[0].y = 0.5 * ah->wi;
      po[1].x = 0.0;
      po[1].y = 0.0;
      po[2].x = po[0].x;
      po[2].y = -0.5 * ah->wi;
      po[3].x = -1.0 * ah->he;
      po[3].y = 0.0;
      for(i = 0; i < 4; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  4,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  4,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
	if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    (void *)po,
	    (4 * sizeof(dk3_fig_poly_point_t))
	  );
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_RHOMBUS: {
      if((DK3_FIG_SRCTYPE_JFIG == drw->srctype) && (ah->af)) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_ELLIPSE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  0,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
	if(ah->o1) {
	  (((dk3_fig_obj_t *)(ah->o1))->dt).ell.an = 0.0;
	  (((dk3_fig_obj_t *)(ah->o1))->dt).ell.cx = aep.x;
	  (((dk3_fig_obj_t *)(ah->o1))->dt).ell.cy = aep.y;
	  (((dk3_fig_obj_t *)(ah->o1))->dt).ell.rx = ah->he;
	  (((dk3_fig_obj_t *)(ah->o1))->dt).ell.ry = ah->he;
	  back = 1;
	} else {
          dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	}
      } else {
        if(!(drw->coah)) {
          s = dk3figah_s(drw, obj, ah, ec);
	  aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	  aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
	}
        po[0].x = -1.0 * ah->he;
        po[0].y =  0.0;
        po[1].x = -0.5 * ah->he;
        po[1].y =  0.5 * ah->wi;
        po[2].x =  0.0;
        po[2].y =  0.0;
        po[3].x = -0.5 * ah->he;
        po[3].y = -0.5 * ah->wi;
        for(i = 0; i < 4; i++) {
          dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	  dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
        }
        if(ah->af) {
          ah->o1 = dk3fig_obj_new(
            obj->li, obj->la,		/* Line number, layer */
	    DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	    obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	    DK3_FIG_LC_BUTT,		/* line cap */
	    DK3_FIG_LJ_MITER,		/* line join */
	    DK3_FIG_LS_SOLID,		/* line style */
	    1.0,				/* style value, unused */
	    0, 0,				/* arrowheads flags */
	    4,				/* Number of points */
	    NULL,				/* Text */
	    drw->app			/* Application */
          );
	} else {
          ah->o1 = dk3fig_obj_new(
            obj->li, obj->la,		/* Line number, layer */
	    DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	    obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	    DK3_FIG_LC_BUTT,		/* line cap */
	    DK3_FIG_LJ_MITER,		/* line join */
	    DK3_FIG_LS_SOLID,		/* line style */
	    1.0,				/* style value, unused */
	    0, 0,				/* arrowheads flags */
	    4,				/* Number of points */
	    NULL,				/* Text */
	    drw->app			/* Application */
          );
	}
        if(ah->o1) {
	  if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	    dk3mem_cpy(
	      (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	      (void *)po,
	      (4 * sizeof(dk3_fig_poly_point_t))
	    );
	    back = 1;
	  }
        } else {
          dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	}
      }
    } break;
    case DK3_FIG_AS_FULL_CIRCLE_END: {
      s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
      aep.x = dk3ma_d_sub_ok(aep.x, (0.5 * ah->he * cos(rotation)), ec);
      aep.y = dk3ma_d_sub_ok(aep.y, (0.5 * ah->he * sin(rotation)), ec);
      if(!(drw->coah)) {
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_ELLIPSE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  0,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_ELLIPSE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  0,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
	(((dk3_fig_obj_t *)(ah->o1))->dt).ell.an = 0.0;
	(((dk3_fig_obj_t *)(ah->o1))->dt).ell.cx = aep.x;
	(((dk3_fig_obj_t *)(ah->o1))->dt).ell.cy = aep.y;
	(((dk3_fig_obj_t *)(ah->o1))->dt).ell.rx = 0.5 * ah->he;
	(((dk3_fig_obj_t *)(ah->o1))->dt).ell.ry = 0.5 * ah->he;
	back = 1;
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_HALF_CIRCLE_END: {
      if(ah->af) {
        if(!(drw->coah)) {
	  s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
	  aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	  aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
	}
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE, 1,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  0,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE, 0,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, -1, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  0,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {		

#line 1616 "dk3figah.ctr"
        (((dk3_fig_obj_t *)(ah->o1))->dt).hci.cx = aep.x;
	(((dk3_fig_obj_t *)(ah->o1))->dt).hci.cy = aep.y;
	(((dk3_fig_obj_t *)(ah->o1))->dt).hci.ra = 0.5 * ah->he;
	(((dk3_fig_obj_t *)(ah->o1))->dt).hci.an = rotation;
	back = 1;
      } else {			

#line 1622 "dk3figah.ctr"
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_RECTANGLE: {
      if(!(drw->coah)) {
        s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
	aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y =  0.5 * ah->wi;
      po[1].x =  0.0;
      po[1].y =  po[0].y;
      po[2].x =  0.0;
      po[2].y = -0.5 * ah->wi;
      po[3].x =  po[0].x;
      po[3].y = po[2].y;
      for(i = 0; i < 4; i++) {
	dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  4,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  4,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    po,
	    (4 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 4;
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_INVERSE: {
      if(!(drw->coah)) {
        s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
	aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y =  0.0;
      po[1].x =  0.0;
      po[1].y =  0.5 * ah->wi;
      po[2].x =  0.0;
      po[2].y = -0.5 * ah->wi;
      for(i = 0; i < 3; i++) {
	dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    po,
	    (3 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 3;
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_INDENTED_FILLED_HALF: {
#if 0
      s = 0.0;
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
	aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y =  0.0;
      po[1].x = -1.25 * ah->he;
      if(ah->af) {
        po[1].y =  0.5 * ah->wi;
      } else {
        po[1].y = -0.5 * ah->wi;
      } 
      po[2].x = 0.0;
      po[2].y = 0.0;
      po[3].x = po[1].x;
      if(ah->af) {
        po[3].y = -0.5 * ah->wi;
      } else {
        po[3].y =  0.5 * ah->wi;
      }
      for(i = 0; i < 4; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      ah->o1 = dk3fig_obj_new(
        obj->li, obj->la,		/* Line number, layer */
	DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	DK3_FIG_LC_BUTT,		/* line cap */
	DK3_FIG_LJ_MITER,		/* line join */
	DK3_FIG_LS_SOLID,		/* line style */
	1.0,				/* style value, unused */
	0, 0,				/* arrowheads flags */
	4,				/* Number of points */
	NULL,				/* Text */
	drw->app			/* Application */
      );
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    po,
	    (4 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 4;
          ah->o2 = dk3fig_obj_new(
            obj->li, obj->la,		/* Line number, layer */
	    DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	    obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	    DK3_FIG_LC_BUTT,		/* line cap */
	    DK3_FIG_LJ_MITER,		/* line join */
	    DK3_FIG_LS_SOLID,		/* line style */
	    1.0,				/* style value, unused */
	    0, 0,				/* arrowheads flags */
	    3,				/* Number of points */
	    NULL,				/* Text */
	    drw->app			/* Application */
	  );
	  if(ah->o2) {
	    if((((dk3_fig_obj_t *)(ah->o2))->dt).pol.po) {
	      dk3mem_cpy(
	        (void *)((((dk3_fig_obj_t *)(ah->o2))->dt).pol.po),
	        po,
	        (3 * sizeof(dk3_fig_poly_point_t))
	      );
	      (((dk3_fig_obj_t *)(ah->o2))->dt).pol.np = 3;
	      back = 1;
	    }
	  }
	}
      }
#else
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
        aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y = 0.0;
      po[1].x = dk3ma_d_mul_ok(-1.25, ah->he, ec);
      if(ah->af) {
        po[1].y =  0.5 * ah->wi;
      } else {
        po[1].y = -0.5 * ah->wi;
      }
      po[2].x = 0.0;
      po[2].y = 0.0;
      po[3].x = dk3ma_d_mul_ok(-1.25, ah->he, ec);
      if(ah->af) {
        po[3].y = -0.5 * ah->wi;
      } else {
        po[3].y =  0.5 * ah->wi;
      }
      for(i = 0; i < 4; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      ah->o1 = dk3fig_obj_new(
        obj->li, obj->la,		/* Line number, layer */
	DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	DK3_FIG_LC_BUTT,		/* line cap */
	DK3_FIG_LJ_MITER,		/* line join */
	DK3_FIG_LS_SOLID,		/* line style */
	1.0,				/* style value, unused */
	0, 0,				/* arrowheads flags */
	4,				/* Number of points */
	NULL,				/* Text */
	drw->app			/* Application */
      );
      if(ah->o1) {
	if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    (void *)po,
	    (4 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 4;
          ah->o2 = dk3fig_obj_new(
            obj->li, obj->la,		/* Line number, layer */
	    DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	    0, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	    DK3_FIG_LC_BUTT,		/* line cap */
	    DK3_FIG_LJ_MITER,		/* line join */
	    DK3_FIG_LS_SOLID,		/* line style */
	    1.0,			/* style value, unused */
	    0, 0,			/* arrowheads flags */
	    3,				/* Number of points */
	    NULL,			/* Text */
	    drw->app			/* Application */
          );
	  if(ah->o2) {
	    if((((dk3_fig_obj_t *)(ah->o2))->dt).pol.po) {
	      dk3mem_cpy(
	        (void *)((((dk3_fig_obj_t *)(ah->o2))->dt).pol.po),
	        (void *)po,
	        (3 * sizeof(dk3_fig_poly_point_t))
	      );
	      (((dk3_fig_obj_t *)(ah->o2))->dt).pol.np = 3;
	      back = 1;
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
#endif
    } break;
    case DK3_FIG_AS_CLOSED_HALF: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
        aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
        aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y =	 0.0;
      po[1].x = -1.0 * ah->he;
      po[1].y =  0.5 * ah->wi;
      po[2].x =  0.0;
      po[2].y =  0.0;
      for(i = 0; i < 3; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    po,
	    (3 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 3;
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_INDENTED_HALF: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
	aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y =	 0.0;
      po[1].x = -1.25 * ah->he;
      po[1].y =  0.5 * ah->wi;
      po[2].x =  0.0;
      po[2].y =  0.0;
      for(i = 0; i < 3; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    po,
	    (3 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 3;
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_BUTTED_HALF: {
      if(!(drw->coah)) {
        s = dk3figah_s(drw, obj, ah, ec);
	aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
      }
      po[0].x = -1.0 * ah->he;
      po[0].y =	 0.0;
      po[1].x = -0.75 * ah->he;
      po[1].y =  0.5 * ah->wi;
      po[2].x =  0.0;
      po[2].y =  0.0;
      for(i = 0; i < 3; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      if(ah->af) {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      } else {
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 3,	/* Object type, subtype */
	  obj->lw, obj->pc, 7, 20, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
      }
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	  dk3mem_cpy(
	    (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	    po,
	    (3 * sizeof(dk3_fig_poly_point_t))
	  );
	  (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 3;
	  back = 1;
	}
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
    case DK3_FIG_AS_TRIANGLE_FORK: {
      if(ah->af) {
        if(!(drw->coah)) {
          s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
	  aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	  aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
        }
        po[0].x =  0.0;
	po[0].y =  0.5 * ah->wi;
	po[1].x =  0.0;
	po[1].y = -0.5 * ah->wi;
	for(i = 0; i < 2; i++) {
	  dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	  dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
	}
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 1,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, -1, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  2,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
	if(ah->o1) {
	  if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	    dk3mem_cpy(
	      (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	      po,
	      (2 * sizeof(dk3_fig_poly_point_t))
	    );
	    (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 2;
	    back = 1;
	  }
	} else {
          dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	}
      } else {
        po[0].x =  0.0;
	po[0].y =  0.5 * ah->wi;
	po[1].x = -1.0 * ah->he;
	po[1].y =  0.0;
	po[2].x =  0.0;
	po[2].y = -0.5 * ah->wi;
	for(i = 0; i < 3; i++) {
	  dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
	  dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
	}
        ah->o1 = dk3fig_obj_new(
          obj->li, obj->la,		/* Line number, layer */
	  DK3_FIG_OBJ_POLYLINE, 1,	/* Object type, subtype */
	  obj->lw, obj->pc, obj->pc, -1, /* line width, pen, fill, style */
	  DK3_FIG_LC_BUTT,		/* line cap */
	  DK3_FIG_LJ_MITER,		/* line join */
	  DK3_FIG_LS_SOLID,		/* line style */
	  1.0,				/* style value, unused */
	  0, 0,				/* arrowheads flags */
	  3,				/* Number of points */
	  NULL,				/* Text */
	  drw->app			/* Application */
        );
	if(ah->o1) {
	  if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
	    dk3mem_cpy(
	      (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
	      po,
	      (3 * sizeof(dk3_fig_poly_point_t))
	    );
	    (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 3;
	    back = 1;
	  }
	} else {
          dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	}
      }
    } break;
    case DK3_FIG_AS_RECTANGLE_FORK: {
      if(ah->af) {
        if(!(drw->coah)) {
          s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
	  aep.x = dk3ma_d_sub_ok(aep.x, (s * cos(rotation)), ec);
	  aep.y = dk3ma_d_sub_ok(aep.y, (s * sin(rotation)), ec);
        }
	po[0].x = -1.0 * ah->he;
	po[0].y =  0.5 * ah->wi;
	po[1].x =  0.0;
	po[1].y =  0.5 * ah->wi;
	po[2].x =  0.0;
	po[2].y = -0.5 * ah->wi;
	po[3].x = -1.0 * ah->he;
	po[3].y = -0.5 * ah->wi;
      } else {
	po[0].x =  0.0;
	po[0].y =  0.5 * ah->wi;
	po[1].x = -1.0 * ah->he;
	po[1].y =  0.5 * ah->wi;
	po[2].x = -1.0 * ah->he;
	po[2].y = -0.5 * ah->wi;
	po[3].x =  0.0;
	po[3].y = -0.5 * ah->wi;
      }
      for(i = 0; i < 4; i++) {
        dk3fig_tool_rotate_point(&(po[i]), rotation, ec);
        dk3fig_tool_shift_point(&(po[i]), aep.x, aep.y, ec);
      }
      ah->o1 = dk3fig_obj_new(
        obj->li, obj->la,		/* Line number, layer */
	DK3_FIG_OBJ_POLYLINE, 1,	/* Object type, subtype */
	obj->lw, obj->pc, obj->pc, -1, /* line width, pen, fill, style */
	DK3_FIG_LC_BUTT,		/* line cap */
	DK3_FIG_LJ_MITER,		/* line join */
	DK3_FIG_LS_SOLID,		/* line style */
	1.0,				/* style value, unused */
	0, 0,				/* arrowheads flags */
	4,				/* Number of points */
	NULL,				/* Text */
	drw->app			/* Application */
      );
      if(ah->o1) {
        if((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po) {
          dk3mem_cpy(
            (void *)((((dk3_fig_obj_t *)(ah->o1))->dt).pol.po),
            po,
            (4 * sizeof(dk3_fig_poly_point_t))
          );
          (((dk3_fig_obj_t *)(ah->o1))->dt).pol.np = 4;
          back = 1;
        }
      } else {
        dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
      }
    } break;
  }
  

#line 2214 "dk3figah.ctr"
  return back;
}



/**	Calculate arrowheads for polyline.
	@param	drw	Drawing to modify.
	@param	obj	Object to modify.
	@param	objno	Object number.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_calculate_polyline(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 objno
)
{
  dk3_fig_poly_point_t	*po;		/* Points of the polyline. */
  double		 cuts = -1.0;	/* Cut at start. */
  double		 cute = -1.0;	/* Cut at end. */
  double		 alphaf = 0.0;	/* Direction of forward arrowhead. */
  double		 alphab = 0.0;	/* Direction of backward arrowhead. */
  size_t		 np;		/* Number of points in polyline. */
  int			 mec  = 0;	/* Math error code. */
  int			 res  = 0;	/* Arrowhead creation result. */
  int			 back = 1;
  

#line 2243 "dk3figah.ctr"
  np = (obj->dt).pol.np;
  po = (obj->dt).pol.po;
  if((1 < np) && (po)) {
    /*
    	Calculate line cuttings for arrowhead.
    */
    if(obj->af) {
      cute = dk3figah_length_correction(drw, obj, obj->af, &mec);
    }
    if(obj->ab) {
      cuts = dk3figah_length_correction(drw, obj, obj->ab, &mec);
    } 

#line 2255 "dk3figah.ctr"
    /*
    	Create arrowhead objects.
    */
    if(obj->af) {
      alphaf = dk3ma_d_atan2(
        dk3ma_d_sub_ok(po[np - 1].y, po[np - 2].y, &mec),
	dk3ma_d_sub_ok(po[np - 1].x, po[np - 2].x, &mec)
      );
    }
    if(obj->ab) {
      alphab = dk3ma_d_atan2(
        dk3ma_d_sub_ok(po[0].y, po[1].y, &mec),
	dk3ma_d_sub_ok(po[0].x, po[1].x, &mec)
      );
    }
    if(obj->af) {
        res = dk3figah_straight_arrowhead(
	  drw, obj, obj->af, &(po[np - 1]), alphaf, &mec
	);
	if(!(res)) { back = 0; }
    }
    if(obj->ab) {
        res = dk3figah_straight_arrowhead(
	  drw, obj, obj->ab, &(po[0]), alphab, &mec
	);
	if(!(res)) { back = 0; }
    }
    /*
    	Cut first and last segment if necessary when not using compatible
	arrowheads.
    */
    if(!(drw->coah)) {
      if(0.0 < cuts) {
        if(0 == dk3fig_tool_cut_segment(&(po[0]), &(po[1]), cuts, &mec)) {
          np = (obj->dt).pol.np = np - 1;
	  dk3fig_tool_poly_point_move_left(&(po[0]), &(po[1]), np);
        }
      }
      if((0.0 < cute) && (1 < np)) {
        if(0 == dk3fig_tool_cut_segment(&(po[np - 1]),&(po[np - 2]),cute,&mec))
        {
          (obj->dt).pol.np = np - 1;
        }
      }
    }
  }
  if(mec) {
    back = 0;
    /* ERROR: Math error in object! */
    dk3app_log_i1(drw->app, DK3_LL_ERROR, 260);
    dk3fig_set_ec(drw, DK3_ERROR_MATH_OVERFLOW);
  }
  

#line 2308 "dk3figah.ctr"
  return back;
}



/**	Calculate values for a given t.
	@param	drw	Drawing object.
	@param	obj	Fig object.
	@param	ah	Arrowhead to modify.
	@param	xpos	Pointer to x position variable.
	@param	ypos	Pointer to y position variable.
	@param	phi	Pointer to direction variable.
	@param	ab	Flag: Is backward arrowhead (0=forward, 1=backward).
	@param	t	The t value.
	@param	ec	Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_spline_values(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  double		*xpos,
  double		*ypos,
  double		*phi,
  int			 ab,
  double		 t,
  int			*ec
)
{
  double		 p;
  int			 back = 0;
  int			 mec = 0;
  p = dk3xsp_direction_and_position(
    xpos, ypos, (obj->dt).spl.po, (obj->dt).spl.np, t, drw->cosp, &mec
  );
  if(0.0 <= p) {
    back = 1;
    if(ab) {
      p = p + M_PI;
      while((2.0 * M_PI) < p) { p = p - (2.0 * M_PI);}
    }
    *phi = p;
    if(mec) {
      back = 0;
      if(ec) { *ec = mec; }
    }
  }
  return back;
}



#if TRACE_DEBUG
/**	Report spline points to debug file.
	@param	sp	Spline points to report.
	@param	np	Number of points to report.
*/
static
void
dk3figah_report_spline_points(
  dk3_fig_spline_point_t	*sp,
  size_t			 np
)
{
  FILE		*fipo;
  size_t	 i;
  if((sp) && (np)) {
    fipo = dktrace_file();
    if(fipo) {
      fputs("Spline points report:\n", fipo);
      for(i = 0; i < np; i++) {
        fprintf(
	  fipo,
	  "Point %5u:\tx = %lg  \ty = %lg  \ts = %lg\n",
	  (unsigned)i, sp[i].x, sp[i].y, sp[i].s
	);
      }
    }
  }
}
#endif



/**	Create arrowhead object on end of open spline.
	@param	drw	Drawing object.
	@param	obj	Fig object.
	@param	ah	Arrowhead to modify.
	@param	ab	Flag: Is backward arrowhead (0=forward, 1=backward).
	@param	ec	Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_one_spline_arrowhead(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  dk3_fig_ah_t		*ah,
  int			 ab,
  int			*ec
)
{
  dk3_xspline_segment_t		 seg;		/* Segment for calculations. */
  dk3_fig_poly_point_t		 pp[2];		/* For calculation. */
  dk3_fig_poly_point_t		*po;		/* New polyline points. */
  dk3_fig_obj_t			*ao1 = NULL;	/* Arrowhead object 1. */
  dk3_fig_obj_t			*ao2 = NULL;	/* Arrowhead object 2. */
  dk3_fig_spline_point_t	*osp = NULL;	/* Original spline points. */
  dk3_fig_spline_point_t	*sp  = NULL;	/* New spline points. */
  dk3_fig_spline_point_t	*sp2 = NULL;	/* Spline points obj 2. */
  double			 t0 = 0.0;	/* Front point t. */
  double			 t1 = 0.0;	/* Current t. */
  double			 t2 = 0.0;	/* Arrow end point t. */
  double			 t;		/* Current t. */
  double			 s  = 0.0;	/* Shift for front point. */
  double			 l1 = 0.0;	/* Segment 1 length. */
  double			 l2 = 0.0;	/* Segment 2 length. */
  double			 xpos = 0.0;	/* X position. */
  double			 ypos = 0.0;	/* Y position. */
  double			 phi  = 0.0;	/* Angle at position. */
  double			 lw   = 0.0;	/* Line width. */
  double			 dist = 0.0;	/* Distance to end point. */
  size_t			 onp = 0;	/* Object number of points. */
  size_t			 n1 = 0;	/* Number of sub-segments 1. */
  size_t			 n2 = 0;	/* Number of sub-segments 2. */
  size_t			 n3 = 0;	/* Number of sub-segments 3. */
  size_t			 np = 0;	/* Number of points. */
  size_t			 nq = 0;	/* Number of points obj 2. */
  size_t			 i;
  size_t			 j;
  int				 res = 0;	/* Operation result. */
  int				 mec = 0;	/* Mathematical error code. */
  int		 		 back = 0;
  

#line 2444 "dk3figah.ctr"
  osp = (obj->dt).spl.po;
  onp = (obj->dt).spl.np;
  t0 = ((ab) ? 0.0 : (double)(onp - 1));
  lw = dk3fig_tool_get_lw(drw, obj, &mec);
  s = dk3figah_find_shift_length(drw, obj, ah, &mec);
  switch(ah->as) {
    case DK3_FIG_AS_STICK:
    case DK3_FIG_AS_CLOSED: {			

#line 2452 "dk3figah.ctr"
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if(0.0 <= t0) {
        t1 = dk3xsp_get_t_for_distance(
	  osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	  drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	);
	if(0.0 <= t1) {		

#line 2461 "dk3figah.ctr"
	  n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(fabs(t1 - t0), drw->splspp, &mec)), &mec
	  );
	  if(n1 < drw->minspp) { n1 = drw->minspp; }
	  np = dk3mem_add_size_t(dk3mem_mul_size_t(2, n1, &mec), 1, &mec);
	  if(0 == mec) {
	    ao1 = dk3fig_obj_new(
	      obj->li, obj->la,
	      DK3_FIG_OBJ_SPLINE, 
	      ((DK3_FIG_AS_CLOSED == ah->as) ? 5 : 4),
	      obj->lw, obj->pc, ((ah->af) ? obj->pc : 7),
	      ((DK3_FIG_AS_CLOSED == ah->as) ? 20 : -1),
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
	    );
	    if(ao1) {
	      ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
		res = dk3xsp_calculate_position(
		  &seg, osp, onp, t0, drw->cosp, 0, &mec
		);
		if(res) {		

#line 2485 "dk3figah.ctr"
		  sp[n1].x = dk3xsp_get_x(&seg);
		  sp[n1].y = dk3xsp_get_y(&seg);
		  sp[n1].s = 0.0; 

#line 2488 "dk3figah.ctr"
		  for(i = 0; i < n1; i++) {
		    j = i + 1;	

#line 2490 "dk3figah.ctr"
		    if(j == n1) {
		      t = t1;
		    } else {
		      dist = dk3ma_d_add_ok(
		        s, (((double)j / (double)n1) * ah->he), &mec
		      );	

#line 2496 "dk3figah.ctr"
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
			drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );	

#line 2500 "dk3figah.ctr"
		      

#line 2501 "dk3figah.ctr"
		    }
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
			  drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      ); 

#line 2506 "dk3figah.ctr"
		      if(res) {
			pp[0].x = pp[1].x = 0.0;
			if(j == n1) {
			  pp[0].y = 0.5 * ah->wi;
			} else {
			  pp[0].y = 0.5 * ah->wi * ((double)j / (double)n1);
			}
			pp[1].y = -1.0 * pp[0].y;
			dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
			sp[n1 - j].x = pp[0].x; 

#line 2519 "dk3figah.ctr"
			sp[n1 - j].y = pp[0].y; 

#line 2520 "dk3figah.ctr"
			sp[n1 + j].x = pp[1].x;
			sp[n1 + j].y = pp[1].y;
			sp[n1 - j].s = sp[n1 + j].s =
			((j == n1) ? 0.0 : (-1.0));
		      } else {
			back = 0; i = n1;	

#line 2526 "dk3figah.ctr"
			/* ##### ERROR: Spline calculation failed! */
		      }
		    } else {			

#line 2529 "dk3figah.ctr"
		      back = 0; i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		} else {			

#line 2534 "dk3figah.ctr"
		  back = 0;
		  /* ##### ERROR: Spline calculation failed! */
		}	

#line 2537 "dk3figah.ctr"
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  }
	}
      }
    } break;
    case DK3_FIG_AS_INDENTED: {			

#line 2546 "dk3figah.ctr"
      l1 = dk3ma_d_mul_ok(1.25, ah->he, &mec);
      l2 = 0.25 * ah->he;
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, l1, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t2 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1) && (0.0 <= t2)) {	

#line 2560 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	);						

#line 2563 "dk3figah.ctr"
	n2 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t2), &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	if(n2 < drw->minspp) { n2 = drw->minspp; }
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, n2, &mec), &mec);
	if(0 == mec) {	

#line 2570 "dk3figah.ctr"
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      res = dk3xsp_calculate_position(
	        &seg, osp, onp, t0, drw->cosp, 0, &mec
	      );
	      if(res) {		

#line 2585 "dk3figah.ctr"
	        sp[n1 + n2 - 1].x = dk3xsp_get_x(&seg);
		sp[n1 + n2 - 1].y = dk3xsp_get_y(&seg);
		sp[n1 + n2 - 1].s = 0.0;	

#line 2588 "dk3figah.ctr"
		for(i = 0; i < n1; i++) {
		  j = i + 1;
		  if(j == n1) {
		    t = t1;
		  } else {
		    dist = dk3ma_d_add_ok(
		      s, (((double)j / (double)n1) * l1), &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      pp[0].x = pp[1].x = 0.0;
		      if(j == n1) {
		        pp[0].y = 0.5 * ah->wi;
		      } else {
		        pp[0].y = 0.5 * ah->wi * ((double)j / (double)n1);
		      }
		      pp[1].y = -1.0 * pp[0].y;
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		      sp[n1 + n2 - 1 - j].x = pp[0].x;
		      sp[n1 + n2 - 1 - j].y = pp[0].y;
		      

#line 2620 "dk3figah.ctr"
		      sp[n1 + n2 - 1 + j].x = pp[1].x;
		      sp[n1 + n2 - 1 + j].y = pp[1].y;
		      

#line 2623 "dk3figah.ctr"
		      sp[n1 + n2 - 1 - j].s = sp[n1 + n2 - 1 + j].s =
		      ((j == n1) ? 0.0 : (-1.0));
		    } else {
		      back = 0; i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  } else {
		    back = 0; i = n1;
		    /* ##### ERROR: Spline calculation failed! */
		  }
		}
		if(back) {
		  for(i = 0; i < (n2 - 1); i++) {
		    j = i + 1;
		    dist = dk3ma_d_sub_ok(
		      dk3ma_d_add_ok(s, l1, &mec),
		      (l2 * ((double)j / (double)n2)),
		      &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      );
		      if(res) {
		        pp[0].x = pp[1].x = 0.0;
			pp[0].y = 0.5 * ah->wi * (1.0 - ((double)j/(double)n2));
			pp[1].y = -1.0 * pp[0].y;
			dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		        sp[n2 - 1 - j].x = pp[0].x;
		        sp[n2 - 1 - j].y = pp[0].y;
			

#line 2661 "dk3figah.ctr"
		        sp[2 * n1 + n2 - 1 + j].x = pp[1].x;
		        sp[2 * n1 + n2 - 1 + j].y = pp[1].y;
			

#line 2664 "dk3figah.ctr"
		        sp[n2 - 1 - j].s = sp[2 * n1 + n2 - 1 + j].s =
		        ((j == n1) ? 0.0 : (-1.0));
		      } else {
		        back = 0; i = n2;
			/* ##### ERROR: Spline calculation failed! */
		      }
		    } else {
		      back = 0; i = n2;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		  res = dk3figah_spline_values(
		    drw, obj, ah, &xpos, &ypos, &phi, ab, t2, &mec
		  );
		  if(res) {
		    sp[np - 1].x = xpos;
		    sp[np - 1].y = ypos;
		    sp[np - 1].s = 0.0; 

#line 2682 "dk3figah.ctr"
		  } else {
		    back = 0;
		    /* ##### ERROR: Spline calculation failed! */
		  }
		}
	      } else {
	        back = 0;
		/* ##### ERROR: Spline calculation failed! */
	      }	

#line 2691 "dk3figah.ctr"
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	} else {
	  /* ##### ERROR: Spline calculation failed! */
	}
      } else {
        /* ##### ERROR: Spline calculation failed! */
      }
    } break;
    case DK3_FIG_AS_POINTED: {			

#line 2703 "dk3figah.ctr"
      l1 = 0.75 * ah->he;
      l2 = 0.25 * ah->he;
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, l1, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t2 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1) && (0.0 <= t2)) {	

#line 2717 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	);						

#line 2720 "dk3figah.ctr"
	n2 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t2), &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	if(n2 < drw->minspp) { n2 = drw->minspp; }
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, n2, &mec), &mec);
	if(0 == mec) {	

#line 2727 "dk3figah.ctr"
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      res = dk3xsp_calculate_position(
	        &seg, osp, onp, t0, drw->cosp, 0, &mec
	      );
	      if(res) {		

#line 2742 "dk3figah.ctr"
	        sp[n1 + n2 - 1].x = dk3xsp_get_x(&seg);
		sp[n1 + n2 - 1].y = dk3xsp_get_y(&seg);
		sp[n1 + n2 - 1].s = 0.0;	

#line 2745 "dk3figah.ctr"
		for(i = 0; i < n1; i++) {
		  j = i + 1;
		  if(j == n1) {
		    t = t1;
		  } else {
		    dist = dk3ma_d_add_ok(
		      s, (((double)j / (double)n1) * l1), &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      pp[0].x = pp[1].x = 0.0;
		      if(j == n1) {
		        pp[0].y = 0.5 * ah->wi;
		      } else {
		        pp[0].y = 0.5 * ah->wi * ((double)j / (double)n1);
		      }
		      pp[1].y = -1.0 * pp[0].y;
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		      sp[n1 + n2 - 1 - j].x = pp[0].x;
		      sp[n1 + n2 - 1 - j].y = pp[0].y;
		      

#line 2777 "dk3figah.ctr"
		      sp[n1 + n2 - 1 + j].x = pp[1].x;
		      sp[n1 + n2 - 1 + j].y = pp[1].y;
		      

#line 2780 "dk3figah.ctr"
		      sp[n1 + n2 - 1 - j].s = sp[n1 + n2 - 1 + j].s =
		      ((j == n1) ? 0.0 : (-1.0));
		    } else {
		      back = 0; i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  } else {
		    back = 0; i = n1;
		    /* ##### ERROR: Spline calculation failed! */
		  }
		}
		if(back) {
		  for(i = 0; i < (n2 - 1); i++) {
		    j = i + 1;
		    dist = dk3ma_d_add_ok(
		      dk3ma_d_add_ok(s, l1, &mec),
		      (l2 * ((double)j / (double)n2)),
		      &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      );
		      if(res) {
		        pp[0].x = pp[1].x = 0.0;
			pp[0].y = 0.5 * ah->wi * (1.0 - ((double)j/(double)n2));
			pp[1].y = -1.0 * pp[0].y;
			dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		        sp[n2 - 1 - j].x = pp[0].x;
		        sp[n2 - 1 - j].y = pp[0].y;
			

#line 2818 "dk3figah.ctr"
		        sp[2 * n1 + n2 - 1 + j].x = pp[1].x;
		        sp[2 * n1 + n2 - 1 + j].y = pp[1].y;
			

#line 2821 "dk3figah.ctr"
		        sp[n2 - 1 - j].s = sp[2 * n1 + n2 - 1 + j].s =
		        ((j == n1) ? 0.0 : (-1.0));
		      } else {
		        back = 0; i = n2;
			/* ##### ERROR: Spline calculation failed! */
		      }
		    } else {
		      back = 0; i = n2;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		  res = dk3figah_spline_values(
		    drw, obj, ah, &xpos, &ypos, &phi, ab, t2, &mec
		  );
		  if(res) {
		    sp[np - 1].x = xpos;
		    sp[np - 1].y = ypos;
		    sp[np - 1].s = 0.0; 

#line 2839 "dk3figah.ctr"
		  } else {
		    back = 0;
		    /* ##### ERROR: Spline calculation failed! */
		  }
		}
	      } else {
	        back = 0;
		/* ##### ERROR: Spline calculation failed! */
	      }	

#line 2848 "dk3figah.ctr"
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	} else {
	  /* ##### ERROR: Spline calculation failed! */
	}
      } else {
        /* ##### ERROR: Spline calculation failed! */
      }
    } break;
    case DK3_FIG_AS_RHOMBUS: {
      if((1 == ah->af) && (DK3_FIG_SRCTYPE_JFIG == drw->srctype)) { 

#line 2861 "dk3figah.ctr"
        if(dk3xsp_calculate_position(&seg, osp, onp, t0, drw->cosp, 0, &mec)) {
          ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_ELLIPSE, 3,
	    obj->lw, obj->pc, obj->pc, 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, 0, NULL, drw->app
	  );
	  if(ao1) {
	    back = 1;
	    ah->o1 = (void *)ao1;
	    (ao1->dt).ell.an = 0.0;
	    (ao1->dt).ell.cx = dk3xsp_get_x(&seg);
	    (ao1->dt).ell.cy = dk3xsp_get_y(&seg);
	    (ao1->dt).ell.rx = dk3ma_d_mul_ok(2.0, ah->wi, &mec);
	    (ao1->dt).ell.ry = (ao1->dt).ell.rx;
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	} else {		

#line 2880 "dk3figah.ctr"
	  /* ##### ERROR: Spline calculation failed! */
	}
      } else {		

#line 2883 "dk3figah.ctr"
        l1 = 0.5 * ah->he;
        l2 = l1;
        t0 = dk3xsp_get_t_for_distance(
          osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
        );
        t1 = dk3xsp_get_t_for_distance(
          osp, onp, dk3ma_d_add_ok(s, l1, &mec),
	  drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
        );
        t2 = dk3xsp_get_t_for_distance(
          osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	  drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
        );
        if((0.0 <= t0) && (0.0 <= t1) && (0.0 <= t2)) {	

#line 2897 "dk3figah.ctr"
          n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	  );						

#line 2900 "dk3figah.ctr"
	  n2 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t2), &mec)), &mec
	  );
	  if(n1 < drw->minspp) { n1 = drw->minspp; }
	  if(n2 < drw->minspp) { n2 = drw->minspp; }
	  np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, n2, &mec), &mec);
	  if(0 == mec) {	

#line 2907 "dk3figah.ctr"
	    ao1 = dk3fig_obj_new(
	      obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	      obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
	    );
	    if(ao1) {
	      ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
	        res = dk3xsp_calculate_position(
	          &seg, osp, onp, t0, drw->cosp, 0, &mec
	        );
	        if(res) {		

#line 2922 "dk3figah.ctr"
	          sp[n1 + n2 - 1].x = dk3xsp_get_x(&seg);
		  sp[n1 + n2 - 1].y = dk3xsp_get_y(&seg);
		  sp[n1 + n2 - 1].s = 0.0;	

#line 2925 "dk3figah.ctr"
		  for(i = 0; i < n1; i++) {
		    j = i + 1;
		    if(j == n1) {
		      t = t1;
		    } else {
		      dist = dk3ma_d_add_ok(
		        s, (((double)j / (double)n1) * l1), &mec
		      );
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
		        drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );
		    }
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      );
		      if(res) {
		        pp[0].x = pp[1].x = 0.0;
		        if(j == n1) {
		          pp[0].y = 0.5 * ah->wi;
		        } else {
		          pp[0].y = 0.5 * ah->wi * ((double)j / (double)n1);
		        }
		        pp[1].y = -1.0 * pp[0].y;
		        dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		        dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		        dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		        dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		        sp[n1 + n2 - 1 - j].x = pp[0].x;
		        sp[n1 + n2 - 1 - j].y = pp[0].y;
		        

#line 2957 "dk3figah.ctr"
		        sp[n1 + n2 - 1 + j].x = pp[1].x;
		        sp[n1 + n2 - 1 + j].y = pp[1].y;
		        

#line 2960 "dk3figah.ctr"
		        sp[n1 + n2 - 1 - j].s = sp[n1 + n2 - 1 + j].s =
		        ((j == n1) ? 0.0 : (-1.0));
		      } else {
		        back = 0; i = n1;
		        /* ##### ERROR: Spline calculation failed! */
		      }
		    } else {
		      back = 0; i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		  if(back) {
		    for(i = 0; i < (n2 - 1); i++) {
		      j = i + 1;
		      dist = dk3ma_d_add_ok(
		        dk3ma_d_add_ok(s, l1, &mec),
		        (l2 * ((double)j / (double)n2)),
		        &mec
		      );
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
		        drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );
		      if(0.0 <= t) {
		        res = dk3figah_spline_values(
		          drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		        );
		        if(res) {
		          pp[0].x = pp[1].x = 0.0;
			  pp[0].y = 0.5 * ah->wi * (1.0 - ((double)j/(double)n2));
			  pp[1].y = -1.0 * pp[0].y;
			  dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			  dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			  dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			  dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		          sp[n2 - 1 - j].x = pp[0].x;
		          sp[n2 - 1 - j].y = pp[0].y;
			  

#line 2998 "dk3figah.ctr"
		          sp[2 * n1 + n2 - 1 + j].x = pp[1].x;
		          sp[2 * n1 + n2 - 1 + j].y = pp[1].y;
			  

#line 3001 "dk3figah.ctr"
		          sp[n2 - 1 - j].s = sp[2 * n1 + n2 - 1 + j].s =
		          ((j == n1) ? 0.0 : (-1.0));
		        } else {
		          back = 0; i = n2;
			  /* ##### ERROR: Spline calculation failed! */
		        }
		      } else {
		        back = 0; i = n2;
		        /* ##### ERROR: Spline calculation failed! */
		      }
		    }
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t2, &mec
		    );
		    if(res) {
		      sp[np - 1].x = xpos;
		      sp[np - 1].y = ypos;
		      sp[np - 1].s = 0.0; 

#line 3019 "dk3figah.ctr"
		    } else {
		      back = 0;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
	        } else {
	          back = 0;
		  /* ##### ERROR: Spline calculation failed! */
	        }	

#line 3028 "dk3figah.ctr"
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  } else {
	    /* ##### ERROR: Spline calculation failed! */
	  }
        } else {
          /* ##### ERROR: Spline calculation failed! */
        }
      }
    } break;
    case DK3_FIG_AS_FULL_CIRCLE_END: {		

#line 3041 "dk3figah.ctr"
      res = dk3figah_spline_values(
        drw, obj, ah, &xpos, &ypos, &phi, ab, t0, &mec
      );
      if(res) {
#if VERSION_BEFORE_20121220
        xpos = dk3ma_d_sub_ok(
	  xpos,
	  (0.5 * cos(phi) * dk3ma_d_add_ok((0.5 * ah->he), (0.5 * lw), &mec)),
	  &mec
	);
	ypos = dk3ma_d_sub_ok(
	  ypos,
	  (0.5 * sin(phi) * dk3ma_d_add_ok((0.5 * ah->he), (0.5 * lw), &mec)),
	  &mec
	);
#else
        xpos = dk3ma_d_sub_ok(
	  xpos,
	  (cos(phi) * dk3ma_d_add_ok((0.5 * ah->he), (0.5 * lw), &mec)),
	  &mec
	);
	ypos = dk3ma_d_sub_ok(
	  ypos,
	  (sin(phi) * dk3ma_d_add_ok((0.5 * ah->he), (0.5 * lw), &mec)),
	  &mec
	);
#endif
	if(0 == mec) {
          ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_ELLIPSE, 3,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, 0, NULL, drw->app
	  );
	  if(ao1) {
	    back = 1;
	    ah->o1 = (void *)ao1;
	    (ao1->dt).ell.an = 0.0;
	    (ao1->dt).ell.cx = xpos;
	    (ao1->dt).ell.cy = ypos;
	    (ao1->dt).ell.rx = 0.5 * ah->he;
	    (ao1->dt).ell.ry = (ao1->dt).ell.rx;
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      }
    } break;
    case DK3_FIG_AS_HALF_CIRCLE_END: {		

#line 3090 "dk3figah.ctr"
      if(ah->af) {
        res = dk3figah_spline_values(
          drw, obj, ah, &xpos, &ypos, &phi, ab, t0, &mec
        );
        if(res) {
          xpos = dk3ma_d_sub_ok(xpos, (0.5 * lw * cos(phi)), &mec);
	  ypos = dk3ma_d_sub_ok(ypos, (0.5 * lw * sin(phi)), &mec);
	  if(0 == mec) {
            ao1 = dk3fig_obj_new(
	      obj->li, obj->la, DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE, 1,
	      obj->lw, obj->pc, obj->pc, 20,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, 0, NULL, drw->app
	    );
	    if(ao1) {
	      back = 1;
	      ah->o1 = (void *)ao1;
	      (ao1->dt).hci.cx = xpos;
	      (ao1->dt).hci.cy = ypos;
	      (ao1->dt).hci.ra = 0.5 * ah->he;
	      (ao1->dt).hci.an = phi;
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  }
        }
      } else {
	t1 = dk3xsp_get_t_for_distance(
	  osp, onp, (0.5 * ah->he),
	  drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	);
	if(0.0 <= t1) {
	  dist = fabs(dk3ma_d_sub_ok(t1, t0, &mec));	

#line 3123 "dk3figah.ctr"
	  n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(dist, drw->splspp, &mec)),
	    &mec
	  );	

#line 3127 "dk3figah.ctr"
	  /*	2013-11-23
	  	If we want to correct n1, we have to use ceil() in
		the comparison too.
	  */
	  if(n1 < dk3ma_d_to_sz_ok(ceil(drw->arcspp), &mec)) { 

#line 3132 "dk3figah.ctr"
	    n1 = dk3ma_d_to_sz_ok(ceil(drw->arcspp), &mec);
	  }	

#line 3134 "dk3figah.ctr"
	  if(n1 < drw->minspp) {
	    n1 = drw->minspp;
	  }	

#line 3137 "dk3figah.ctr"
	  np = dk3mem_add_size_t(dk3mem_mul_size_t(2, n1, &mec), 1, &mec);
	  if(0 == mec) {
            ao1 = dk3fig_obj_new(
              obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 4,
	      obj->lw, obj->pc, 7, -1,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
            );
	    if(ao1) {
	      ah->o1 = ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
		res = dk3xsp_calculate_position(
		  &seg, osp, onp, t1, drw->cosp, 0, &mec
		);
		if(res) {		

#line 3154 "dk3figah.ctr"
		  sp[n1].x = dk3xsp_get_x(&seg);
		  sp[n1].y = dk3xsp_get_y(&seg);
		  sp[n1].s = -1.0;	

#line 3157 "dk3figah.ctr"
		  for(i = 0; i < n1; i++) {
		    j = i + 1;
		    t1 = dk3xsp_get_t_for_distance(
		      osp, onp,
		      (0.5 * ah->he * cos(M_PI_2 * ((double)j / (double)n1))),
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		    if(0.0 <= t1) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t1, &mec
		      );
		      if(res) {
		        pp[0].x = 0.0;
			pp[1].x = 0.0;
			pp[0].y = 0.5 * ah->he
				  * sin(M_PI_2 * ((double)j / (double)n1));
			pp[1].y = -1.0 * pp[0].y;
			dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
			sp[n1 - j].x = pp[0].x;
			sp[n1 - j].y = pp[0].y;	

#line 3180 "dk3figah.ctr"
			sp[n1 + j].x = pp[1].x; 

#line 3181 "dk3figah.ctr"
			sp[n1 + j].y = pp[1].y;
			sp[n1 - j].s = sp[n1 + j].s =
			((j == n1) ? 0.0 : (-1.0));
		      } else {
		        back = 0; i = n1;
			/* ##### ERROR: Spline calculation failed! */
		      }
		    } else {
		      back = 0;
		      i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		} else {
		  back = 0;
		  /* ##### ERROR: Calculation failed! */
		}
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  }
	}
      }
    } break;
    case DK3_FIG_AS_RECTANGLE: {		

#line 3207 "dk3figah.ctr"
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1)) {		

#line 3215 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(fabs(t1 - t0), drw->splspp, &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, 1, &mec), &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      res = dk3figah_spline_values(
	        drw, obj, ah, &xpos, &ypos, &phi, ab, t0, &mec
	      );
	      if(res) {	

#line 3236 "dk3figah.ctr"
	        pp[0].x = pp[1].x = 0;
		pp[0].y =  0.5 * ah->wi;
		pp[1].y = -0.5 * ah->wi;
		dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		sp[n1].x = pp[0].x; 

#line 3244 "dk3figah.ctr"
		sp[n1].y = pp[0].y; 

#line 3245 "dk3figah.ctr"
		sp[n1 + 1].x = pp[1].x;
		sp[n1 + 1].y = pp[1].y;
		sp[n1].s = sp[n1 + 1].s = 0.0;
		for(i = 0; i < n1; i++) {
		  j = i + 1;
		  if(j == n1) {
		    t = t1;
		  } else {
		    dist = dk3ma_d_add_ok(
		      s, (ah->he * ((double)j / (double)n1)), &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      pp[0].x = pp[1].x = 0.0;
		      pp[0].y =  0.5 * ah->wi;
		      pp[1].y = -0.5 * ah->wi;
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		      sp[n1 - j].x = pp[0].x;
		      sp[n1 - j].y = pp[0].y;
		      

#line 3276 "dk3figah.ctr"
		      sp[n1 + 1 + j].x = pp[1].x;
		      sp[n1 + 1 + j].y = pp[1].y;
		      

#line 3279 "dk3figah.ctr"
		      sp[n1 - j].s = sp[n1 + 1 + j].s =
		      ((j == n1) ? 0.0 : (-1.0));

		    } else {
		      back = 0; i = n1;
		    }
		  } else {
		    back = 0; i = n1;
		  }
		}
	      } else {
	        back = 0;
	      }
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      } else {
        /* ##### ERROR: Spline calculation failed! */
      }
    } break;
    case DK3_FIG_AS_INVERSE: {			

#line 3302 "dk3figah.ctr"
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1)) {		

#line 3310 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(fabs(t1 - t0), drw->splspp, &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_mul_size_t(2, n1, &mec), 1, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	     obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	     DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	     1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      res = dk3figah_spline_values(
	        drw, obj, ah, &xpos, &ypos, &phi, ab, t1, &mec
	      );
	      if(res) {		

#line 3331 "dk3figah.ctr"
	        sp[n1].x = xpos;
		sp[n1].y = ypos;
		sp[n1].s = 0.0;	

#line 3334 "dk3figah.ctr"
		for(i = 0; i < n1; i++) {
		  j = i + 1;
		  if(j == n1) {
		    t = t0;
		  } else {
		    dist = dk3ma_d_add_ok(
		      s, ((1.0 - ((double)j / (double)n1)) * ah->he), &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      pp[0].x = pp[1].x = 0.0;
		      pp[0].y = 0.5 * ((double)j / (double)n1) * ah->wi;
		      pp[1].y = -1.0 * pp[0].y;
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		      sp[n1 - j].x = pp[0].x; sp[n1 - j].y = pp[0].y;
		      sp[n1 + j].x = pp[1].x; sp[n1 + j].y = pp[1].y;
		      

#line 3362 "dk3figah.ctr"
		      

#line 3363 "dk3figah.ctr"
		      sp[n1 - j].s = sp[n1 + j].s = ((j == n1) ? 0.0 : (-1.0));
		    } else {
		    }
		  } else {
		    back = 0; i = n1;
		  }
		}
	      } else {
	        back = 0;
	      }
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      }
    } break;
    case DK3_FIG_AS_INDENTED_FILLED_HALF: {	

#line 3381 "dk3figah.ctr"
      l1 = dk3ma_d_mul_ok(1.25, ah->he, &mec);
      l2 = 0.25 * ah->he;
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, l1, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t2 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1) && (0.0 <= t2)) {	

#line 3395 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	);						

#line 3398 "dk3figah.ctr"
	n2 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t2), &mec)), &mec
	);						

#line 3401 "dk3figah.ctr"
	n3 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t2 - t0), &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	if(n2 < drw->minspp) { n2 = drw->minspp; }
	if(n3 < drw->minspp) { n3 = drw->minspp; }
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, n2, &mec), &mec);
	nq = dk3mem_add_size_t(dk3mem_add_size_t(n1, n2, &mec), n3, &mec);
	if(0 == mec) {	

#line 3410 "dk3figah.ctr"
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, 7, 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    ao2 = dk3fig_obj_new(
	      obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	      0, obj->pc, obj->pc, 20,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, nq, NULL, drw->app
	    );
	    if(ao2) {
	      ah->o2 = (void *)ao2;
	      sp2 = (ao2->dt).spl.po;
	      if((sp) && (sp2)) {
	        back = 1;
	        res = dk3xsp_calculate_position(
	          &seg, osp, onp, t0, drw->cosp, 0, &mec
	        );
	        if(res) {		

#line 3434 "dk3figah.ctr"
	          sp[n1 + n2 - 1].x = dk3xsp_get_x(&seg);
		  sp[n1 + n2 - 1].y = dk3xsp_get_y(&seg);
		  sp[n1 + n2 - 1].s = 0.0;	

#line 3437 "dk3figah.ctr"
		  sp2[0].x = dk3xsp_get_x(&seg);
		  sp2[0].y = dk3xsp_get_y(&seg);
		  sp2[0].s = 0.0; 

#line 3440 "dk3figah.ctr"
		  for(i = 0; i < n1; i++) {
		    j = i + 1;
		    if(j == n1) {
		      t = t1;
		    } else {
		      dist = dk3ma_d_add_ok(
		        s, (((double)j / (double)n1) * l1), &mec
		      );
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
		        drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );
		    }
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      );
		      if(res) {
		        pp[0].x = pp[1].x = 0.0;
		        if(j == n1) {
			  if(ah->af) {
		            pp[0].y =  0.5 * ah->wi;
			  } else {
			    pp[0].y = -0.5 * ah->wi;
			  }
		        } else {
			  if(ah->af) {
		            pp[0].y =  0.5 * ah->wi * ((double)j / (double)n1);
			  } else {
			    pp[0].y = -0.5 * ah->wi * ((double)j / (double)n1);
			  }
		        }
		        pp[1].y = -1.0 * pp[0].y;
		        dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		        dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		        dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		        dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		        sp[n1 + n2 - 1 - j].x = pp[0].x;
		        sp[n1 + n2 - 1 - j].y = pp[0].y;
		        

#line 3480 "dk3figah.ctr"
		        sp[n1 + n2 - 1 + j].x = pp[1].x;
		        sp[n1 + n2 - 1 + j].y = pp[1].y;
		        

#line 3483 "dk3figah.ctr"
		        sp[n1 + n2 - 1 - j].s = sp[n1 + n2 - 1 + j].s =
		        ((j == n1) ? 0.0 : (-1.0));
			sp2[j].x = pp[0].x;
			sp2[j].y = pp[0].y;
			sp2[j].s = ((j == n1) ? 0.0 : (-1.0));
			

#line 3489 "dk3figah.ctr"
		      } else {
		        back = 0; i = n1;
		        /* ##### ERROR: Spline calculation failed! */
		      }
		    } else {
		      back = 0; i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		  if(back) {
		    for(i = 0; i < (n2 - 1); i++) {
		      j = i + 1;
		      dist = dk3ma_d_sub_ok(
		        dk3ma_d_add_ok(s, l1, &mec),
		        (l2 * ((double)j / (double)n2)),
		        &mec
		      );
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
		        drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );
		      if(0.0 <= t) {
		        res = dk3figah_spline_values(
		          drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		        );
		        if(res) {
		          pp[0].x = pp[1].x = 0.0;
			  if(ah->af) {
			    pp[0].y =  0.5 * ah->wi
			    	      * (1.0 - ((double)j/(double)n2));
			  } else {
			    pp[0].y = -0.5 * ah->wi
			  	      * (1.0 - ((double)j/(double)n2));
			  }
			  pp[1].y = -1.0 * pp[0].y;
			  dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			  dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			  dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			  dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		          sp[n2 - 1 - j].x = pp[0].x;
		          sp[n2 - 1 - j].y = pp[0].y;
			  

#line 3531 "dk3figah.ctr"
		          sp[2 * n1 + n2 - 1 + j].x = pp[1].x;
		          sp[2 * n1 + n2 - 1 + j].y = pp[1].y;
			  

#line 3534 "dk3figah.ctr"
		          sp[n2 - 1 - j].s = sp[2 * n1 + n2 - 1 + j].s =
		          ((j == n1) ? 0.0 : (-1.0));
			  sp2[n1 + j].x = pp[0].x;
			  sp2[n1 + j].y = pp[0].y;
			  sp2[n1 + j].s = ((j == n1) ? 0.0 : (-1.0));
			  

#line 3540 "dk3figah.ctr"
		        } else {
		          back = 0; i = n2;
			  /* ##### ERROR: Spline calculation failed! */
		        }
		      } else {
		        back = 0; i = n2;
		        /* ##### ERROR: Spline calculation failed! */
		      }
		    }
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t2, &mec
		    );
		    if(res) {
		      sp[np - 1].x = xpos;
		      sp[np - 1].y = ypos;
		      sp[np - 1].s = 0.0; 

#line 3556 "dk3figah.ctr"
		      sp2[n1 + n2].x = xpos;
		      sp2[n1 + n2].y = ypos;
		      sp2[n1 + n2].s = 0.0; 

#line 3559 "dk3figah.ctr"
		    } else {
		      back = 0;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		    for(i = 0; i < (n3 - 1); i++) {
		      j = i + 1;
		      dist = dk3ma_d_add_ok(
		        s,
			((1.0 - ((double)j / (double)n3)) * ah->he),
			&mec
		      );
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
			drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );
		      if(0.0 <= t) {
		        res = dk3figah_spline_values(
			  drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
			);
			if(res) {
			  sp2[n1 + n2 + j].x = xpos;
			  sp2[n1 + n2 + j].y = ypos;
			  sp2[n1 + n2 + j].s = -1.0;
			  

#line 3583 "dk3figah.ctr"
			} else {
			  back = 0; i = n3;
			}
		      } else {
		        back = 0; i = n3;
		      }
		    }
		  }
	        } else {
	          back = 0;
		  /* ##### ERROR: Spline calculation failed! */
	        }	

#line 3595 "dk3figah.ctr"
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
            }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	} else {
	  /* ##### ERROR: Spline calculation failed! */
	}
      } else {
        /* ##### ERROR: Spline calculation failed! */
      }
    } break;
    case DK3_FIG_AS_CLOSED_HALF: {		

#line 3610 "dk3figah.ctr"
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if(0.0 <= t0) {
        t1 = dk3xsp_get_t_for_distance(
	  osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	  drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	);
	if(0.0 <= t1) {				

#line 3619 "dk3figah.ctr"
	  n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(fabs(t1 - t0), drw->splspp, &mec)), &mec
	  );
	  if(n1 < drw->minspp) { n1 = drw->minspp; }
	  np = dk3mem_add_size_t(dk3mem_mul_size_t(2, n1, &mec), 1, &mec);
	  if(0 == mec) {
	    ao1 = dk3fig_obj_new(
	      obj->li, obj->la,
	      DK3_FIG_OBJ_SPLINE, 5,
	      obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
	    );
	    if(ao1) {
	      ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
		res = dk3xsp_calculate_position(
		  &seg, osp, onp, t0, drw->cosp, 0, &mec
		);
		if(res) {		

#line 3641 "dk3figah.ctr"
		  sp[n1].x = dk3xsp_get_x(&seg);
		  sp[n1].y = dk3xsp_get_y(&seg);
		  sp[n1].s = 0.0; 

#line 3644 "dk3figah.ctr"
		  for(i = 0; i < n1; i++) {
		    j = i + 1;	

#line 3646 "dk3figah.ctr"
		    if(j == n1) {
		      t = t1;
		    } else {
		      dist = dk3ma_d_add_ok(
		        s, (((double)j / (double)n1) * ah->he), &mec
		      );	

#line 3652 "dk3figah.ctr"
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
			drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );	

#line 3656 "dk3figah.ctr"
		      

#line 3657 "dk3figah.ctr"
		    }
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
			  drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      ); 

#line 3662 "dk3figah.ctr"
		      if(res) {
			pp[0].x = pp[1].x = 0.0;
			if(j == n1) {
			  pp[0].y = 0.5 * ah->wi;
			} else {
			  pp[0].y = 0.5 * ah->wi * ((double)j / (double)n1);
			}
			pp[1].y = 0.0;
			dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
			sp[n1 - j].x = pp[0].x; 

#line 3675 "dk3figah.ctr"
			sp[n1 - j].y = pp[0].y; 

#line 3676 "dk3figah.ctr"
			sp[n1 + j].x = pp[1].x;
			sp[n1 + j].y = pp[1].y;
			sp[n1 - j].s = sp[n1 + j].s =
			((j == n1) ? 0.0 : (-1.0));
		      } else {
			back = 0; i = n1;	

#line 3682 "dk3figah.ctr"
			/* ##### ERROR: Spline calculation failed! */
		      }
		    } else {			

#line 3685 "dk3figah.ctr"
		      back = 0; i = n1;
		      /* ##### ERROR: Spline calculation failed! */
		    }
		  }
		} else {			

#line 3690 "dk3figah.ctr"
		  back = 0;
		  /* ##### ERROR: Spline calculation failed! */
		}	

#line 3693 "dk3figah.ctr"
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  }
	}
      }
    } break;
    case DK3_FIG_AS_INDENTED_HALF: {		

#line 3702 "dk3figah.ctr"
      l1 = dk3ma_d_mul_ok(1.25, ah->he, &mec);
      l2 = 0.25 * ah->he;
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, l1, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t2 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1) && (0.0 <= t2)) {	

#line 3716 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	);						

#line 3719 "dk3figah.ctr"
	n2 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t2), &mec)), &mec
	);						

#line 3722 "dk3figah.ctr"
	n3 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t2 - t0), &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	if(n2 < drw->minspp) { n2 = drw->minspp; }
	if(n3 < drw->minspp) { n3 = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_add_size_t(n1, n2, &mec), n3, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;	

#line 3741 "dk3figah.ctr"
	      for(i = 0; i < n1; i++) {
	        if(0 == i) {
		  t = t0;
		} else {
		  dist = dk3ma_d_add_ok(
		    s, (l1 * ((double)i / (double)(n1))), &mec
		  );
		  t = dk3xsp_get_t_for_distance(
		    osp, onp, dist,
		    drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		  );
		}
		if(0.0 <= t) {
		  res = dk3figah_spline_values(
		    drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		  );
		  if(res) {
		    pp[0].x = 0.0;
		    pp[0].y = 0.5 * ah->wi * ((double)i / (double)n1);
		    dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		    dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		    sp[i].x = pp[0].x;	

#line 3763 "dk3figah.ctr"
		    sp[i].y = pp[0].y;
		    sp[i].s = ((i == 0) ? 0.0 : (-1.0));
		  } else {
		    back = 0; i = n1;
		  }
		} else {
		  back = 0; i = n1;
		}
	      }
	      if(back) {
	        for(i = 0; i < n2; i++) {
		  if(0 == i) {
		    t = t1;
		  } else {
#if 0
		    dist = dk3ma_d_sub_ok(
		      l1, (l2 * ((double)i / (double)n2)), &mec
		    );
#endif
		    dist = dk3ma_d_add_ok(
		      s,
		      dk3ma_d_sub_ok(
		        l1, (l2 * ((double)i / (double)n2)), &mec
		      ),
		      &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      pp[0].x = 0.0;
		      pp[0].y = 0.5 * ah->wi * (1.0 - ((double)i / (double)n2));
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      sp[n1 + i].x = pp[0].x; 

#line 3804 "dk3figah.ctr"
		      sp[n1 + i].y = pp[0].y;
		      sp[n1 + i].s = ((0 == i) ? 0.0 : (-1.0));
		    } else {
		      back = 0; i = n2;
		    }
		  } else {
		    back = 0; i = n2;
		  }
		}
	      }
	      if(back) {
	        for(i = 0; i < n3; i++) {
		  if(0 == i) {
		    t = t2;
		  } else {
		    dist = dk3ma_d_add_ok(
		      s, (ah->he * (1.0 - ((double)i / (double)n3))), &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      sp[n1 + n2 + i].x = xpos;
		      sp[n1 + n2 + i].y = ypos;
		      sp[n1 + n2 + i].s = ((0 == i) ? 0.0 : (-1.0));
		      

#line 3836 "dk3figah.ctr"
		    } else {
		      back = 0; i = n3;
		    }
		  } else {
		    back = 0; i = n3;
		  }
		}
	      }
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      }
    } break;
    case DK3_FIG_AS_BUTTED_HALF: {		

#line 3852 "dk3figah.ctr"
      l1 = 0.75 * ah->he;
      l2 = 0.25 * ah->he;
      t0 = dk3xsp_get_t_for_distance(
        osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t1 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, l1, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      t2 = dk3xsp_get_t_for_distance(
        osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
      );
      if((0.0 <= t0) && (0.0 <= t1) && (0.0 <= t2)) {	

#line 3866 "dk3figah.ctr"
        n1 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	);						

#line 3869 "dk3figah.ctr"
	n2 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t2), &mec)), &mec
	);						

#line 3872 "dk3figah.ctr"
	n3 = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t2 - t0), &mec)), &mec
	);
	if(n1 < drw->minspp) { n1 = drw->minspp; }
	if(n2 < drw->minspp) { n2 = drw->minspp; }
	if(n3 < drw->minspp) { n3 = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_add_size_t(n1, n2, &mec), n3, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;	

#line 3891 "dk3figah.ctr"
	      for(i = 0; i < n1; i++) {
	        if(0 == i) {
		  t = t0;
		} else {
		  dist = dk3ma_d_add_ok(
		    s, (l1 * ((double)i / (double)(n1))), &mec
		  );
		  t = dk3xsp_get_t_for_distance(
		    osp, onp, dist,
		    drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		  );
		}
		if(0.0 <= t) {
		  res = dk3figah_spline_values(
		    drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		  );
		  if(res) {
		    pp[0].x = 0.0;
		    pp[0].y = 0.5 * ah->wi * ((double)i / (double)n1);
		    dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		    dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		    sp[i].x = pp[0].x;	

#line 3913 "dk3figah.ctr"
		    sp[i].y = pp[0].y;
		    sp[i].s = ((i == 0) ? 0.0 : (-1.0));
		  } else {
		    back = 0; i = n1;
		  }
		} else {
		  back = 0; i = n1;
		}
	      }
	      if(back) {
	        for(i = 0; i < n2; i++) {
		  if(0 == i) {
		    t = t1;
		  } else {
#if 0
		    dist = dk3ma_d_add_ok(
		      l1, (l2 * ((double)i / (double)n2)), &mec
		    );
#endif
		    dist = dk3ma_d_add_ok(
		      s,
		      dk3ma_d_add_ok(
		        l1, (l2 * ((double)i / (double)n2)), &mec
		      ),
		      &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      pp[0].x = 0.0;
		      pp[0].y = 0.5 * ah->wi * (1.0 - ((double)i / (double)n2));
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      sp[n1 + i].x = pp[0].x; 

#line 3954 "dk3figah.ctr"
		      sp[n1 + i].y = pp[0].y;
		      sp[n1 + i].s = ((0 == i) ? 0.0 : (-1.0));
		    } else {
		      back = 0; i = n2;
		    }
		  } else {
		    back = 0; i = n2;
		  }
		}
	      }
	      if(back) {
	        for(i = 0; i < n3; i++) {
		  if(0 == i) {
		    t = t2;
		  } else {
		    dist = dk3ma_d_add_ok(
		      s, (ah->he * (1.0 - ((double)i / (double)n3))), &mec
		    );
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    );
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    );
		    if(res) {
		      sp[n1 + n2 + i].x = xpos;
		      sp[n1 + n2 + i].y = ypos;
		      sp[n1 + n2 + i].s = ((0 == i) ? 0.0 : (-1.0));
		      

#line 3986 "dk3figah.ctr"
		    } else {
		      back = 0; i = n3;
		    }
		  } else {
		    back = 0; i = n3;
		  }
		}
	      }
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      }
    } break;
    case DK3_FIG_AS_TRIANGLE_FORK: {		

#line 4002 "dk3figah.ctr"
      if(ah->af) {
	t0 = dk3xsp_get_t_for_distance(
	  osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	);
	if(0.0 <= t0) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_POLYLINE, 1,
	    obj->lw, obj->pc, obj->pc, -1,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, 2, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    po = (ao1->dt).pol.po;
	    if(po) {
	      back = 1;
	      pp[0].x =  pp[1].x = 0.0;
	      pp[0].y =  0.5 * ah->wi;
	      pp[1].y = -0.5 * ah->wi;
	      res =  dk3figah_spline_values(
	        drw, obj, ah, &xpos, &ypos, &phi, ab, t0, &mec
	      );
	      if(res) {
	        dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		po[0].x = pp[0].x; po[0].y = pp[0].y;
		po[1].x = pp[1].x; po[1].y = pp[1].y;
	      } else {
	        back = 0;
	      }
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      } else {
        t0 = dk3xsp_get_t_for_distance(
          osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
        );
        t1 = dk3xsp_get_t_for_distance(
          osp, onp, dk3ma_d_add_ok(s, ah->he, &mec),
	  drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
        );
        if((0.0 <= t0) && (0.0 <= t1)) {		

#line 4048 "dk3figah.ctr"
          n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(fabs(t1 - t0), drw->splspp, &mec)), &mec
	  );
	  if(n1 < drw->minspp) { n1 = drw->minspp; }
	  np = dk3mem_add_size_t(dk3mem_mul_size_t(2, n1, &mec), 1, &mec);
	  if(0 == mec) {
	    ao1 = dk3fig_obj_new(
	      obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 4,
	      obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), -1,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
	    );
	    if(ao1) {
	      ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
	        res = dk3figah_spline_values(
	          drw, obj, ah, &xpos, &ypos, &phi, ab, t1, &mec
	        );
	        if(res) {		

#line 4069 "dk3figah.ctr"
	          sp[n1].x = xpos;
		  sp[n1].y = ypos;
		  sp[n1].s = 0.0;	

#line 4072 "dk3figah.ctr"
		  for(i = 0; i < n1; i++) {
		    j = i + 1;
		    if(j == n1) {
		      t = t0;
		    } else {
		      dist = dk3ma_d_add_ok(
		        s, ((1.0 - ((double)j / (double)n1)) * ah->he), &mec
		      );
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
		        drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      );
		    }
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      );
		      if(res) {
		        pp[0].x = pp[1].x = 0.0;
		        pp[0].y = 0.5 * ((double)j / (double)n1) * ah->wi;
		        pp[1].y = -1.0 * pp[0].y;
		        dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		        dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		        dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		        dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		        sp[n1 - j].x = pp[0].x; sp[n1 - j].y = pp[0].y;
		        sp[n1 + j].x = pp[1].x; sp[n1 + j].y = pp[1].y;
		        

#line 4100 "dk3figah.ctr"
		        

#line 4101 "dk3figah.ctr"
		        sp[n1 - j].s = sp[n1 + j].s =
			((j == n1) ? 0.0 : (-1.0));
		      } else {
		      }
		    } else {
		      back = 0; i = n1;
		    }
		  }
	        } else {
	          back = 0;
	        }
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  }
        }
      }
    } break;
    case DK3_FIG_AS_RECTANGLE_FORK: {		

#line 4121 "dk3figah.ctr"
      if(ah->af) {
        t0 = dk3xsp_get_t_for_distance(
	  osp, onp, s, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	);
	l1 = dk3ma_d_add_ok(s, ah->he, &mec);
	t1 = dk3xsp_get_t_for_distance(
	  osp, onp, l1, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	);
	if((0.0 <= t0) && (0.0 <= t1)) {		

#line 4130 "dk3figah.ctr"
	  n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	  );
	  if(n1 < drw->minspp) { n1 = drw->minspp; }
	  np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, 1, &mec), &mec);
	  if(0 == mec) {
	    ao1 = dk3fig_obj_new(
	      obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 4,
	      obj->lw, obj->pc, obj->pc, -1,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
	    );
	    if(ao1) {
	      ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
		res = dk3figah_spline_values(
		  drw, obj, ah, &xpos, &ypos, &phi, ab, t0, &mec
		);
		if(res) {	

#line 4151 "dk3figah.ctr"
		  pp[0].x = 0.0; pp[1].x = 0.0;
		  pp[0].y =  0.5 * ah->wi;
		  pp[1].y = -0.5 * ah->wi;
		  dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		  dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		  dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		  dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		  sp[n1].x = pp[0].x;
		  sp[n1].y = pp[0].y;
		  

#line 4161 "dk3figah.ctr"
		  sp[n1 + 1].x = pp[1].x;
		  sp[n1 + 1].y = pp[1].y;
		  

#line 4164 "dk3figah.ctr"
		  sp[n1].s = sp[n1 + 1].s = 0.0;
		  for(i = 0; i < n1; i++) {
		    j = i + 1;
		    if(j == n1) {
		      t = t1;
		    } else {
		      dist = dk3ma_d_add_ok(
		        s, (((double)j / (double)n1) * ah->he), &mec
		      ); 

#line 4173 "dk3figah.ctr"
		      t = dk3xsp_get_t_for_distance(
		        osp, onp, dist,
			drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		      ); 

#line 4177 "dk3figah.ctr"
		    }
		    if(0.0 <= t) {
		      res = dk3figah_spline_values(
		        drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		      ); 

#line 4182 "dk3figah.ctr"
		      if(res) {
	                pp[0].x = 0.0; pp[1].x = 0.0;
		        pp[0].y =  0.5 * ah->wi;
		        pp[1].y = -0.5 * ah->wi;
		        dk3fig_tool_rotate_point(&pp[0], phi, &mec);
			

#line 4188 "dk3figah.ctr"
		        dk3fig_tool_rotate_point(&pp[1], phi, &mec);
			

#line 4190 "dk3figah.ctr"
		        dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
			

#line 4192 "dk3figah.ctr"
		        dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
			

#line 4194 "dk3figah.ctr"
		        sp[n1 - j].x = pp[0].x;
		        sp[n1 - j].y = pp[0].y;
		        

#line 4197 "dk3figah.ctr"
		        sp[n1 + 1 + j].x = pp[1].x;
		        sp[n1 + 1 + j].y = pp[1].y;
		        

#line 4200 "dk3figah.ctr"
		        sp[n1 - j].s = sp[n1 + 1 + j].s =
		        ((j == n1) ? 0.0 : (-1.0));
		      } else {
		        back = 0; i = n1;
		      }
		    } else {
		      back = 0; i = n1; 
		    }
		  }
		} else {
		  back = 0;
		}
	      }
	    } else {
              dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	    }
	  }
	}
      } else {					

#line 4219 "dk3figah.ctr"
        t0 = ((ab) ? 0.0 : ((obj->dt).spl.np - 1));
	t1 = dk3xsp_get_t_for_distance(
	  osp, onp, ah->he, drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
	); 

#line 4223 "dk3figah.ctr"
	if((0.0 <= t0) && (0.0 <= t1)) {	

#line 4224 "dk3figah.ctr"
          n1 = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(drw->splspp, fabs(t1 - t0), &mec)), &mec
	  ); 

#line 4227 "dk3figah.ctr"
	  if(n1 < drw->minspp) { n1 = drw->minspp; }
	  np = dk3mem_mul_size_t(2, dk3mem_add_size_t(n1, 1, &mec), &mec);
	  

#line 4230 "dk3figah.ctr"
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 4,
	    obj->lw, obj->pc, obj->pc, -1,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {				

#line 4237 "dk3figah.ctr"
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {				

#line 4240 "dk3figah.ctr"
	      back = 1;	

#line 4241 "dk3figah.ctr"
	      res = dk3figah_spline_values(
	        drw, obj, ah, &xpos, &ypos, &phi, ab, t1, &mec
	      ); 

#line 4244 "dk3figah.ctr"
	      if(res) {				

#line 4245 "dk3figah.ctr"
	        pp[0].x = 0.0; pp[1].x = 0.0;
		pp[0].y =  0.5 * ah->wi;
		pp[1].y = -0.5 * ah->wi;
		dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		

#line 4250 "dk3figah.ctr"
		dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		

#line 4252 "dk3figah.ctr"
		dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		

#line 4254 "dk3figah.ctr"
		dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		

#line 4256 "dk3figah.ctr"
		sp[n1].x = pp[0].x;
		sp[n1].y = pp[0].y;
		

#line 4259 "dk3figah.ctr"
		sp[n1 + 1].x = pp[1].x;
		sp[n1 + 1].y = pp[1].y;
		

#line 4262 "dk3figah.ctr"
		sp[n1].s = sp[n1 + 1].s = 0.0;
		for(i = 0; i < n1; i++) {
		  j = i + 1;
		  if(j == n1) {
		    t = t0;
		  } else {
		    dist = (1.0 - ((double)j / (double)n1)) * ah->he;
		    t = dk3xsp_get_t_for_distance(
		      osp, onp, dist,
		      drw->xsprec, (obj->dt).spl.fslc, ab, drw->cosp, &mec
		    ); 

#line 4273 "dk3figah.ctr"
		  }
		  if(0.0 <= t) {
		    res = dk3figah_spline_values(
		      drw, obj, ah, &xpos, &ypos, &phi, ab, t, &mec
		    ); 

#line 4278 "dk3figah.ctr"
		    if(res) {
	              pp[0].x = 0.0; pp[1].x = 0.0;
		      pp[0].y =  0.5 * ah->wi;
		      pp[1].y = -0.5 * ah->wi;
		      dk3fig_tool_rotate_point(&pp[0], phi, &mec);
		      

#line 4284 "dk3figah.ctr"
		      dk3fig_tool_rotate_point(&pp[1], phi, &mec);
		      

#line 4286 "dk3figah.ctr"
		      dk3fig_tool_shift_point(&pp[0], xpos, ypos, &mec);
		      

#line 4288 "dk3figah.ctr"
		      dk3fig_tool_shift_point(&pp[1], xpos, ypos, &mec);
		      

#line 4290 "dk3figah.ctr"
		      sp[n1 - j].x = pp[0].x;
		      sp[n1 - j].y = pp[0].y;
		      

#line 4293 "dk3figah.ctr"
		      sp[n1 + 1 + j].x = pp[1].x;
		      sp[n1 + 1 + j].y = pp[1].y;
		      

#line 4296 "dk3figah.ctr"
		      sp[n1 - j].s = sp[n1 + 1 + j].s =
		      ((j == n1) ? 0.0 : (-1.0));
		    } else {
		      back = 0; i = n1;
		    }
		  } else {
		    back = 0; i = n1;
		  }
		}
	      } else {	

#line 4306 "dk3figah.ctr"
	        back = 0;
	      }
	    } else {	

#line 4309 "dk3figah.ctr"
	    }
	  } else {	

#line 4311 "dk3figah.ctr"
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	} else {	

#line 4314 "dk3figah.ctr"
	}
      }
    } break;
  }
  if(mec) {		

#line 4319 "dk3figah.ctr"
    back = 0;
    if(ec) { *ec = mec; }
    /* ##### ERROR: Mathematical error occured! */
  } else {
    if(!(back)) {
      /* ##### ERROR: Error in spline arrowhead calculation! */
    }
  } 

#line 4327 "dk3figah.ctr"
  return back;
}



/**	Calculate arrowheads for spline.
	@param	drw	Drawing to modify.
	@param	obj	Object to modify.
	@param	objno	Object number.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_calculate_spline(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 objno
)
{
  dk3_xspline_segment_t	 seg;
  dk3_fig_poly_point_t	 sp;
  double		 cuts = -1.0;
  double		 cute = -1.0;
  double		 alphaf	= 0.0;
  double		 alphab = 0.0;
  double		 t;
  int			 back = 1;
  int			 mec  = 0;
  int			 res  = 0;
  

#line 4357 "dk3figah.ctr"
  if((1 < (obj->dt).spl.np) && ((obj->dt).spl.po)) {
    /*
    	Defaults for start and end.
    */
    (obj->dt).spl.ts = 0.0;
    (obj->dt).spl.te = (double)((obj->dt).spl.np - 1);
    /*
  	  Calculate line cuts.
    */
    if(!(drw->coah)) {		

#line 4367 "dk3figah.ctr"
      if(obj->af) {		

#line 4368 "dk3figah.ctr"
        cute = dk3figah_length_correction(drw, obj, obj->af, &mec);
      }
      if(obj->ab) {		

#line 4371 "dk3figah.ctr"
        cuts = dk3figah_length_correction(drw, obj, obj->ab, &mec);
      } 

#line 4373 "dk3figah.ctr"
    }
    /*
  	  Construct arrowhead objects.
    */
    if(drw->coah) {
      back = 1;
      if(obj->af) {
        t = (double)((obj->dt).spl.np - 1);
        res = dk3xsp_calculate_position(
	  &seg, (obj->dt).spl.po, (obj->dt).spl.np, t, drw->cosp, 0, &mec
	);
	if((res) && (0 == mec)) {
	  alphaf = dk3xsp_direction(
	    (obj->dt).spl.po, (obj->dt).spl.np, t, drw->cosp, &mec
	  ); 

#line 4388 "dk3figah.ctr"
	  if((alphaf >= 0.0) && (0 == mec)) {
	    sp.x = dk3xsp_get_x(&seg);
	    sp.y = dk3xsp_get_y(&seg);
	    res = dk3figah_straight_arrowhead(
	      drw, obj, obj->af, &sp, alphaf, &mec
	    ); 

#line 4394 "dk3figah.ctr"
	    if(!(res)) { back = 0; }
	  } else {
	    /* ##### ERROR: Arrowhead calculation failed! */
	    back = 0;
	  }
	} else {
	  /* ##### ERROR: Arrowhead calculation failed! */
	  back = 0;
	}
      }
      if(obj->ab) {
        res = dk3xsp_calculate_position(
	  &seg, (obj->dt).spl.po, (obj->dt).spl.np, 0.0, drw->cosp, 0, &mec
	); 

#line 4408 "dk3figah.ctr"
	if((res) && (0 == mec)) {
	  alphab = dk3xsp_direction(
	    (obj->dt).spl.po, (obj->dt).spl.np, 0.0, drw->cosp, &mec
	  ); 

#line 4412 "dk3figah.ctr"
	  if((alphab >= 0.0) && (0 == mec)) {
	    alphab += M_PI;
	    sp.x = dk3xsp_get_x(&seg);
	    sp.y = dk3xsp_get_y(&seg);
	    res = dk3figah_straight_arrowhead(
	      drw, obj, obj->ab, &sp, alphab, &mec
	    ); 

#line 4419 "dk3figah.ctr"
	    if(!(res)) { back = 0; }
	  } else {
	    /* ##### ERROR: Arrowhead calculation failed! */
	    back = 0;
	  } 
	} else {
	  /* ##### ERROR: Arrowhead calculation failed! */
	  back = 0;
	}
      }
    } else {
      if(obj->af) {
        if(!dk3figah_one_spline_arrowhead(drw, obj, obj->af, 0, &mec)) {
	  back = 0;
	} 

#line 4434 "dk3figah.ctr"
      }
      if(obj->ab) {
        if(!dk3figah_one_spline_arrowhead(drw, obj, obj->ab, 1, &mec)) {
	  back = 0;
	} 

#line 4439 "dk3figah.ctr"
      }
    }
    /*
  	  Cut spline if necessary when not using compatible arrowheads.
    */
    back = 1;
    if(!(drw->coah)) {			

#line 4446 "dk3figah.ctr"
      if(0.0 < cuts) {			

#line 4447 "dk3figah.ctr"
        (obj->dt).spl.ts = dk3xsp_get_t_for_distance(
          (obj->dt).spl.po,
          (obj->dt).spl.np,
          cuts,
          dk3figah_length_correction_tolerance(drw, obj, obj->ab, &mec),
          (obj->dt).spl.fslc,
          1,
          drw->cosp,
          &mec
        ); 

#line 4457 "dk3figah.ctr"
        if(0.0 > (obj->dt).spl.ts) {	

#line 4458 "dk3figah.ctr"
          back = 0;
        }
      } else {				

#line 4461 "dk3figah.ctr"
      }
      if(0.0 < cute) {			

#line 4463 "dk3figah.ctr"
        (obj->dt).spl.te = dk3xsp_get_t_for_distance(
          (obj->dt).spl.po,
          (obj->dt).spl.np,
          cute,
          dk3figah_length_correction_tolerance(drw, obj, obj->af, &mec),
          (obj->dt).spl.fslc,
          0,
          drw->cosp,
          &mec
        ); 

#line 4473 "dk3figah.ctr"
        if(0.0 > (obj->dt).spl.te) {	

#line 4474 "dk3figah.ctr"
          back = 0;
        }
      } else {				

#line 4477 "dk3figah.ctr"
      }
    }
    if(mec) {				

#line 4480 "dk3figah.ctr"
      back = 0;
      /* ERROR: Math error */
      dk3app_log_i1(drw->app, DK3_LL_ERROR, 260);
    }
  }
  

#line 4486 "dk3figah.ctr"
  return back;
}



/**	For corrections on arcs check whether we have to
	use the full correction formula.
	@param	ah	Arrowhead to calculate correction for.
	@return	1 for correct formula, 0 for c/r.
*/
static
int
dk3figah_must_use_arc_correction(dk3_fig_ah_t *ah)
{
  int		 back = 0;
  if(ah) {
    if(!(ah->af)) {
      switch(ah->as) {
        case DK3_FIG_AS_HALF_CIRCLE_END: {
	  back = 1;
	} break;
      }
    }
  }
  return back;
}



/**	Calculate correction angle for arrowhead length correction on arcs.
	@param	r	Arc radius.
	@param	c	Correction length.
	@param	ec	Pointer to error code variable.
	@return	Non-negative number on success, -1.0 on error.
*/
static
double
dk3figah_arc_correction(double r, double c, int *ec)
{
  double		 back = -1.0;
  double		 val;
  val = dk3ma_d_sub_ok(
    1.0,
    dk3ma_d_div_ok(
      dk3ma_d_square_ok(c, ec),
      dk3ma_d_mul_ok(2.0, dk3ma_d_square_ok(r, ec), ec),
      ec
    ),
    ec
  );
  if((-1.0 <= val) && (1.0 >= val)) {
    back = acos(val);
  } else {
    if(ec) { *ec = DK3_ERROR_MATH_OUT_OF_RANGE; }
  }
  return back;
}



/**	Calculate one arrowhead on arc.
	@param	drw	Drawing structure.
	@param	obj	Arc object containing the arrowhead.
	@param	ah	Arrowhead structure.
	@param	ab	Flag: Backward arrow (0=forward, 1=backward).
	@param	ec	Pointer to error code variable.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_one_arc_arrowhead(
  dk3_fig_drawing_t		*drw,
  dk3_fig_obj_t			*obj,
  dk3_fig_ah_t			*ah,
  int				 ab,
  int				*ec
)
{
  dk3_fig_spline_point_t	*sp = NULL;
  dk3_fig_poly_point_t		*po;
  dk3_fig_poly_point_t		 pp;
  dk3_fig_obj_t			*ao1;		/* Arrowhead object 1. */
  dk3_fig_obj_t			*ao2;		/* Arrowhead object 2. */
  double			 s;		/* Shift length. */
  double			 a0;		/* Alpha at arrow front pt. */
  double			 a1;		/* Alpha at real front. */
  double			 phi;		/* Direction at front. */
  double			 b1;		/* Beta: Angle for arrowhead. */
  double			 b2;		/* Beta: Angle for part. */
  double			 b3;		/* Beta: Angle for inner. */
  double			 f = -1.0;	/* Factor. */
  double			 ga;		/* Current point angle. */
  double			 r1;
  double			 r2;
  size_t			 nsegs = 0;	/* Number of segments. */
  size_t			 ns2 = 0;	/* Number of segments 2. */
  size_t			 ns3 = 0;	/* Number of segments 3. */
  size_t			 np = 0;	/* Number of spline points. */
  size_t			 i;
  size_t			 j;
  int				 mec = 0;
  int				 back = 0;
  int				 mustadd = 0;
  

#line 4590 "dk3figah.ctr"
  if(ab) {
    a0 = (obj->dt).arc.as;
    if((obj->dt).arc.ae > (obj->dt).arc.as) {
      f = 1.0;
    } else {
      f = -1.0;
    }
  } else {
    a0 = (obj->dt).arc.ae;
    if((obj->dt).arc.ae > (obj->dt).arc.as) {
      f = -1.0;
    } else {
      f = 1.0;
    }
  }
  

#line 4606 "dk3figah.ctr"
  

#line 4607 "dk3figah.ctr"
  a1 = a0;			

#line 4608 "dk3figah.ctr"
  phi = a1 - f * M_PI_2;	

#line 4609 "dk3figah.ctr"
  s = dk3figah_find_shift_length(drw, obj, ah, &mec);
  a0 = dk3ma_d_add_ok(
    a0,
    (f * dk3ma_d_div_ok(s, (obj->dt).arc.ra, &mec)),
    &mec
  ); 

#line 4615 "dk3figah.ctr"
  

#line 4616 "dk3figah.ctr"
  switch(ah->as) {
    case DK3_FIG_AS_STICK:
    case DK3_FIG_AS_CLOSED: {			

#line 4619 "dk3figah.ctr"
      b1 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if(b1 < (2.0 * M_PI)) {			

#line 4621 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 4625 "dk3figah.ctr"
        if(drw->minspp > nsegs) { nsegs = drw->minspp; }
        np = 2 * nsegs + 1;
	np = dk3mem_add_size_t(dk3mem_mul_size_t(2, nsegs, &mec), 1, &mec);
	if(0 == mec) {
          ao1 = dk3fig_obj_new(
            obj->li, obj->la,
	    DK3_FIG_OBJ_SPLINE, 4,
	    obj->lw, obj->pc, -1, -1,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
          );
          if(ao1) {
            ah->o1 = (void *)ao1;
	    if(ao1) {
	      sp = (ao1->dt).spl.po;
	      if(sp) {				

#line 4641 "dk3figah.ctr"
	        back = 1;
	        sp[nsegs].x = (obj->dt).arc.ra * cos(a0);
	        sp[nsegs].y = (obj->dt).arc.ra * sin(a0);
	        sp[nsegs].s = 0.0;
	        for(i = 0; i < nsegs; i++) {	

#line 4646 "dk3figah.ctr"
	          j = i + 1;
	          if(j == nsegs) {
		    ga = a0 + f * b1;
		    

#line 4650 "dk3figah.ctr"
		    r1 = dk3ma_d_sub_ok(
		      (obj->dt).arc.ra, (0.5 * ah->wi), &mec
		    ); 

#line 4653 "dk3figah.ctr"
		    r2 = dk3ma_d_add_ok(
		      (obj->dt).arc.ra, (0.5 * ah->wi), &mec
		    ); 

#line 4656 "dk3figah.ctr"
		    sp[nsegs - j].s = 0.0;
		    sp[nsegs + j].s = 0.0;
	          } else {
		    ga = a0 + f * b1 * ((double)j / (double)nsegs);
		    

#line 4661 "dk3figah.ctr"
		    r1 = dk3ma_d_sub_ok(
		      (obj->dt).arc.ra,
		      (0.5 * ah->wi * ((double)j / (double)nsegs)),
		      &mec
		    ); 

#line 4666 "dk3figah.ctr"
		    r2 = dk3ma_d_add_ok(
		      (obj->dt).arc.ra,
		      (0.5 * ah->wi * ((double)j / (double)nsegs)),
		      &mec
		    ); 

#line 4671 "dk3figah.ctr"
		    sp[nsegs - j].s = -1.0;
		    sp[nsegs + j].s = -1.0;
	          }
	          sp[nsegs - j].x = r1 * cos(ga);
	          sp[nsegs - j].y = r1 * sin(ga);
	          sp[nsegs + j].x = r2 * cos(ga);
	          sp[nsegs + j].y = r2 * sin(ga);
	        }
	        for(i = 0; i < np; i++) {
	          dk3fig_tool_shift_spoint(
	            &(sp[i]), (obj->dt).arc.xc, (obj->dt).arc.yc, &mec
	          );  

#line 4683 "dk3figah.ctr"
	        }
	        if(DK3_FIG_AS_CLOSED == ah->as) {
	          ao1->st = 5;
	          if(ah->af) {
	            ao1->fc = obj->pc;
	          } else {
	            ao1->fc = 7;
	          }
	          ao1->fi = 20;
	          ao1->cl = 1;
	        } 

#line 4694 "dk3figah.ctr"
	      }
	    }
          } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_INDENTED: {
      b1 = dk3ma_d_div_ok(
        dk3ma_d_mul_ok(1.25, ah->he, &mec),
	(obj->dt).arc.ra, &mec
      );
      b2 = dk3ma_d_div_ok((0.25 * ah->he), (obj->dt).arc.ra, &mec);
      if((b1 < (2.0 * M_PI)) && (b2 < (2.0 * M_PI))) {	

#line 4711 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 4715 "dk3figah.ctr"
	ns2   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b2, drw->arcspp, &mec) / M_PI_2),
	  &mec
	); 

#line 4719 "dk3figah.ctr"
        if(drw->minspp > nsegs) { nsegs = drw->minspp; }
        if(drw->minspp > ns2) { ns2 = drw->minspp; }
        np = 2 * (nsegs + ns2); 

#line 4722 "dk3figah.ctr"
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(nsegs, ns2, &mec), &mec);
	if(0 == mec) {
          ao1 = dk3fig_obj_new(
            obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, 7, 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
          );
          if(ao1) {
            ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      /* Arrowhead front point */
	      sp[nsegs + ns2 - 1].x = (obj->dt).arc.ra * cos(a0);
	      sp[nsegs + ns2 - 1].y = (obj->dt).arc.ra * sin(a0);
	      sp[nsegs + ns2 - 1].s = 0.0;
	      

#line 4740 "dk3figah.ctr"
	      /* Outer edges of arrowhead */
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
	        if(j == nsegs) {
		  ga = a0 + f * b1;
	          r1 = dk3ma_d_sub_ok(
	            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	          );
	          r2 = dk3ma_d_add_ok(
	            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	          );
	          sp[nsegs + ns2 - 1 - j].s = 0.0;
	          sp[nsegs + ns2 - 1 + j].s = 0.0;
	        } else {
		  ga = a0 + f * b1 * ((double)j / (double)nsegs);
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ah->wi * ((double)j / (double)nsegs)),
		    &mec
		  );
		  r2 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ah->wi * ((double)j / (double)nsegs)),
		    &mec
		  );
	          sp[nsegs + ns2 - 1 - j].s = -1.0;
	          sp[nsegs + ns2 - 1 + j].s = -1.0;
	        }
	        sp[nsegs + ns2 - 1 - j].x = r1 * cos(ga);
	        sp[nsegs + ns2 - 1 - j].y = r1 * sin(ga);
	        sp[nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	        sp[nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	        

#line 4773 "dk3figah.ctr"
	        

#line 4774 "dk3figah.ctr"
	      }
	      /* Inner edges of arrowhead */
	      for(i = 0; i < (ns2 - 1); i++) {
	        j = i + 1;
	        ga = a0 + f * (b1 - b2 * ((double)j / (double)ns2));
	        r1 = dk3ma_d_sub_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		  &mec
	        );
	        r2 = dk3ma_d_add_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		  &mec
	        );
	        sp[ns2 - 1 - j].x = r1 * cos(ga);
	        sp[ns2 - 1 - j].y = r1 * sin(ga);
	        sp[ns2 - 1 - j].s = -1.0;
	        sp[2 * nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	        sp[2 * nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	        sp[2 * nsegs + ns2 - 1 + j].s = -1.0;
	        

#line 4796 "dk3figah.ctr"
	        

#line 4797 "dk3figah.ctr"
	      }
	      /* Inner arrowhead front point */
	      ga = a0 + f * (b1 - b2);
	      r1 = (obj->dt).arc.ra;
	      sp[2 * (nsegs + ns2) - 1].x = r1 * cos(ga);
	      sp[2 * (nsegs + ns2) - 1].y = r1 * sin(ga);
	      sp[2 * (nsegs + ns2) - 1].s = 0.0;
	      

#line 4805 "dk3figah.ctr"
	      /* Shift all points */
	      for(i = 0; i < np; i++) {
	        dk3fig_tool_shift_spoint(
	          &(sp[i]), (obj->dt).arc.xc, (obj->dt).arc.yc, &mec
	        );
	      }
	      if(ah->af) {
	        ao1->fc = obj->pc;
	      } 

#line 4814 "dk3figah.ctr"
	    }
          } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_POINTED: {
      b1 = dk3ma_d_div_ok(
        dk3ma_d_mul_ok(0.75, ah->he, &mec),
	(obj->dt).arc.ra, &mec
      );
      b2 = dk3ma_d_div_ok((0.25 * ah->he), (obj->dt).arc.ra, &mec);
      if((b1 < (2.0 * M_PI)) && (b2 < (2.0 * M_PI))) {	

#line 4830 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 4834 "dk3figah.ctr"
	ns2   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b2, drw->arcspp, &mec) / M_PI_2),
	  &mec
	); 

#line 4838 "dk3figah.ctr"
        if(drw->minspp > nsegs) { nsegs = drw->minspp; }
        if(drw->minspp > ns2) { ns2 = drw->minspp; }
        np = 2 * (nsegs + ns2); 

#line 4841 "dk3figah.ctr"
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(nsegs, ns2, &mec), &mec);
	if(0 == mec) {
          ao1 = dk3fig_obj_new(
            obj->li, obj->la,
	    DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, 7, 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
          );
          if(ao1) {
            ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      /* Arrowhead front point */
	      sp[nsegs + ns2 - 1].x = (obj->dt).arc.ra * cos(a0);
	      sp[nsegs + ns2 - 1].y = (obj->dt).arc.ra * sin(a0);
	      sp[nsegs + ns2 - 1].s = 0.0;
	      

#line 4860 "dk3figah.ctr"
	      /* Outer edges of arrowhead */
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
	        if(j == nsegs) {
		  ga = a0 + f * b1;
	          r1 = dk3ma_d_sub_ok(
	            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	          );
	          r2 = dk3ma_d_add_ok(
	            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	          );
	          sp[nsegs + ns2 - 1 - j].s = 0.0;
	          sp[nsegs + ns2 - 1 + j].s = 0.0;
	        } else {
		  ga = a0 + f * b1 * ((double)j / (double)nsegs);
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ah->wi * ((double)j / (double)nsegs)),
		    &mec
		  );
		  r2 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ah->wi * ((double)j / (double)nsegs)),
		    &mec
		  );
	          sp[nsegs + ns2 - 1 - j].s = -1.0;
	          sp[nsegs + ns2 - 1 + j].s = -1.0;
	        }
	        sp[nsegs + ns2 - 1 - j].x = r1 * cos(ga);
	        sp[nsegs + ns2 - 1 - j].y = r1 * sin(ga);
	        sp[nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	        sp[nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	        

#line 4893 "dk3figah.ctr"
	        

#line 4894 "dk3figah.ctr"
	      }
	      /* Inner edges of arrowhead */
	      for(i = 0; i < (ns2 - 1); i++) {
	        j = i + 1;
	        ga = a0 + f * (b1 + b2 * ((double)j / (double)ns2));
	        r1 = dk3ma_d_sub_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		  &mec
	        );
	        r2 = dk3ma_d_add_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		  &mec
	        );
	        sp[ns2 - 1 - j].x = r1 * cos(ga);
	        sp[ns2 - 1 - j].y = r1 * sin(ga);
	        sp[ns2 - 1 - j].s = -1.0;
	        sp[2 * nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	        sp[2 * nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	        sp[2 * nsegs + ns2 - 1 + j].s = -1.0;
	        

#line 4916 "dk3figah.ctr"
	        

#line 4917 "dk3figah.ctr"
	      }
	      /* Inner arrowhead front point */
	      ga = a0 + f * (b1 + b2);
	      r1 = (obj->dt).arc.ra;
	      sp[2 * (nsegs + ns2) - 1].x = r1 * cos(ga);
	      sp[2 * (nsegs + ns2) - 1].y = r1 * sin(ga);
	      sp[2 * (nsegs + ns2) - 1].s = 0.0;
	      

#line 4925 "dk3figah.ctr"
	      /* Shift all points */
	      for(i = 0; i < np; i++) {
	        dk3fig_tool_shift_spoint(
	          &(sp[i]), (obj->dt).arc.xc, (obj->dt).arc.yc, &mec
	        );
	      }
	      if(ah->af) {
	        ao1->fc = obj->pc;
	      } 

#line 4934 "dk3figah.ctr"
	    }
          }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_RHOMBUS: {
      if((1 == ah->af) && (DK3_FIG_SRCTYPE_JFIG == drw->srctype)) {
	ao1 = dk3fig_obj_new(
	  obj->li, obj->la,
	  DK3_FIG_OBJ_ELLIPSE, 3,
	  obj->lw, obj->pc, obj->pc, 20,
	  DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	  1.0, 0, 0, 0, NULL, drw->app
	);
	if(ao1) {
	  back = 1;
	  ah->o1 = (void *)ao1;
	  (ao1->dt).ell.an = 0.0;
	  (ao1->dt).ell.cx = dk3ma_d_add_ok(
	    (obj->dt).arc.xc,
	    ((obj->dt).arc.ra * cos(a0)),
	    &mec
	  );
	  (ao1->dt).ell.cy = dk3ma_d_add_ok(
	    (obj->dt).arc.yc,
	    ((obj->dt).arc.ra * sin(a0)),
	    &mec
	  );
	  (ao1->dt).ell.rx = dk3ma_d_mul_ok(2.0, ah->wi, &mec);
	  (ao1->dt).ell.ry = (ao1->dt).ell.rx;
	}
      } else {
        b1 = dk3ma_d_div_ok(
          dk3ma_d_mul_ok(0.5, ah->he, &mec),
	  (obj->dt).arc.ra, &mec
        );
        b2 = b1;
        if((b1 < (2.0 * M_PI)) && (b2 < (2.0 * M_PI))) {	

#line 4974 "dk3figah.ctr"
          nsegs = dk3ma_d_to_sz_ok(
            ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	    &mec
          ); 

#line 4978 "dk3figah.ctr"
	  ns2   = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(b2, drw->arcspp, &mec) / M_PI_2),
	    &mec
	  ); 

#line 4982 "dk3figah.ctr"
          if(drw->minspp > nsegs) { nsegs = drw->minspp; }
          if(drw->minspp > ns2) { ns2 = drw->minspp; }
          np = 2 * (nsegs + ns2); 

#line 4985 "dk3figah.ctr"
	  np = dk3mem_mul_size_t(2, dk3mem_add_size_t(nsegs, ns2, &mec), &mec);
	  if(0 == mec) {
            ao1 = dk3fig_obj_new(
              obj->li, obj->la,
	      DK3_FIG_OBJ_SPLINE, 5,
	      obj->lw, obj->pc, 7, 20,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
            );
            if(ao1) {
              ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
	        /* Arrowhead front point */
	        sp[nsegs + ns2 - 1].x = (obj->dt).arc.ra * cos(a0);
	        sp[nsegs + ns2 - 1].y = (obj->dt).arc.ra * sin(a0);
	        sp[nsegs + ns2 - 1].s = 0.0;
	        

#line 5004 "dk3figah.ctr"
	        /* Outer edges of arrowhead */
	        for(i = 0; i < nsegs; i++) {
	          j = i + 1;
	          if(j == nsegs) {
		    ga = a0 + f * b1;
	            r1 = dk3ma_d_sub_ok(
	              (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	            );
	            r2 = dk3ma_d_add_ok(
	              (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	            );
	            sp[nsegs + ns2 - 1 - j].s = 0.0;
	            sp[nsegs + ns2 - 1 + j].s = 0.0;
	          } else {
		    ga = a0 + f * b1 * ((double)j / (double)nsegs);
		    r1 = dk3ma_d_sub_ok(
		      (obj->dt).arc.ra,
		      (0.5 * ah->wi * ((double)j / (double)nsegs)),
		      &mec
		    );
		    r2 = dk3ma_d_add_ok(
		      (obj->dt).arc.ra,
		      (0.5 * ah->wi * ((double)j / (double)nsegs)),
		      &mec
		    );
	            sp[nsegs + ns2 - 1 - j].s = -1.0;
	            sp[nsegs + ns2 - 1 + j].s = -1.0;
	          }
	          sp[nsegs + ns2 - 1 - j].x = r1 * cos(ga);
	          sp[nsegs + ns2 - 1 - j].y = r1 * sin(ga);
	          sp[nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	          sp[nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	          

#line 5037 "dk3figah.ctr"
	          

#line 5038 "dk3figah.ctr"
	        }
	        /* Inner edges of arrowhead */
	        for(i = 0; i < (ns2 - 1); i++) {
	          j = i + 1;
	          ga = a0 + f * (b1 + b2 * ((double)j / (double)ns2));
	          r1 = dk3ma_d_sub_ok(
	            (obj->dt).arc.ra,
		    (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		    &mec
	          );
	          r2 = dk3ma_d_add_ok(
	            (obj->dt).arc.ra,
		    (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		    &mec
	          );
	          sp[ns2 - 1 - j].x = r1 * cos(ga);
	          sp[ns2 - 1 - j].y = r1 * sin(ga);
	          sp[ns2 - 1 - j].s = -1.0;
	          sp[2 * nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	          sp[2 * nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	          sp[2 * nsegs + ns2 - 1 + j].s = -1.0;
	          

#line 5060 "dk3figah.ctr"
	          

#line 5061 "dk3figah.ctr"
	        }
	        /* Inner arrowhead front point */
	        ga = a0 + f * (b1 + b2);
	        r1 = (obj->dt).arc.ra;
	        sp[2 * (nsegs + ns2) - 1].x = r1 * cos(ga);
	        sp[2 * (nsegs + ns2) - 1].y = r1 * sin(ga);
	        sp[2 * (nsegs + ns2) - 1].s = 0.0;
	        

#line 5069 "dk3figah.ctr"
	        /* Shift all points */
	        for(i = 0; i < np; i++) {
	          dk3fig_tool_shift_spoint(
	            &(sp[i]), (obj->dt).arc.xc, (obj->dt).arc.yc, &mec
	          );
	        }
	        if(ah->af) {
	          ao1->fc = obj->pc;
	        } 

#line 5078 "dk3figah.ctr"
	      }
            }
	  }
        } else {
          /* ##### ERROR: Arrowhead too long! */
        }
      }
    } break;
    case DK3_FIG_AS_FULL_CIRCLE_END: {
      b1 = dk3figah_arc_correction(
        (obj->dt).arc.ra, 
	dk3ma_d_add_ok(
	  (0.5 * ah->he),
	  (0.5 * dk3fig_tool_get_lw(drw, obj, &mec)),
	  &mec
	),
	&mec
      );
      if(0.0 <= b1) {
#if 0
        b1 = a0 + f * b1;
#else
	b1 = a1 + f * b1;
#endif
	ao1 = dk3fig_obj_new(
	  obj->li, obj->la,
	  DK3_FIG_OBJ_ELLIPSE, 3,
	  obj->lw, obj->pc, 7, 20,
	  DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	  1.0, 0, 0, 0, NULL, drw->app
	);
	if(ao1) {
	  back = 1;
	  ah->o1 = (void *)ao1;
	  (ao1->dt).ell.an = 0.0;
	  (ao1->dt).ell.cx = dk3ma_d_add_ok(
	    (obj->dt).arc.xc,
	    ((obj->dt).arc.ra * cos(b1)),
	    &mec
	  );
	  (ao1->dt).ell.cy = dk3ma_d_add_ok(
	    (obj->dt).arc.yc,
	    ((obj->dt).arc.ra * sin(b1)),
	    &mec
	  );
	  (ao1->dt).ell.rx = 0.5 * ah->he;
	  (ao1->dt).ell.ry = 0.5 * ah->he;
	  if(ah->af) {
	    ao1->fc = obj->pc;
	  }
	}
      } else {
	mec = DK3_ERROR_MATH_OUT_OF_RANGE;
      }
    } break;
    case DK3_FIG_AS_HALF_CIRCLE_END: {
      pp.x = (obj->dt).arc.ra * cos(a1);
      pp.y = (obj->dt).arc.ra * sin(a1);
      pp.x = dk3ma_d_add_ok(pp.x, (obj->dt).arc.xc, &mec);
      pp.y = dk3ma_d_add_ok(pp.y, (obj->dt).arc.yc, &mec);
      if(ah->af) {
        s = 0.5 * dk3fig_tool_get_lw(drw, obj, ec);
	pp.x = dk3ma_d_sub_ok(
	  pp.x,
	  (s * cos(phi)),
	  &mec
	);
	pp.y = dk3ma_d_sub_ok(
	  pp.y,
	  (s * sin(phi)),
	  &mec
	);
      }
      ao1 = dk3fig_obj_new(
        obj->li, obj->la,
	DK3_FIG_OBJ_PSEUDO_HALF_CIRCLE, ((ah->af) ? 1 : 0),
	obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	1.0, 0, 0, 0, NULL, drw->app
      );
      if(ao1) {
        ah->o1 = (void *)ao1;
	back = 1;
	(ao1->dt).hci.cx = pp.x;
	(ao1->dt).hci.cy = pp.y;
	(ao1->dt).hci.ra = 0.5 * ah->he;
	(ao1->dt).hci.an = phi;
      }
    } break;
    case DK3_FIG_AS_RECTANGLE: {
      b1 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if(b1 < (2.0 * M_PI)) {		

#line 5170 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
	);
	if(drw->minspp > nsegs) {
	  nsegs = drw->minspp;
	}			

#line 5177 "dk3figah.ctr"
	np = 2 * nsegs + 2;	

#line 5178 "dk3figah.ctr"
	np = dk3mem_add_size_t(dk3mem_mul_size_t(2, nsegs, &mec), 2, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la,
	    DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
	      r2 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
	      back = 1;
	      for(i = 0; i < nsegs; i++) {
	        if(0 == i) {
	          ga = a0;
		  sp[i].s = 0.0;
		  sp[np - 1 - i].s = 0.0;
	        } else {
	          ga = a0 + f * b1 * ((double)i / (double)nsegs);
		  sp[i].s = -1.0;
		  sp[np - 1 - i].s = -1.0;
	        }
	        sp[i].x = dk3ma_d_add_ok(
	          (obj->dt).arc.xc, (r1 * cos(ga)), &mec
	        );
	        sp[i].y = dk3ma_d_add_ok(
	          (obj->dt).arc.yc, (r1 * sin(ga)), &mec
	        );
	        sp[np - 1 - i].x = dk3ma_d_add_ok(
	          (obj->dt).arc.xc, (r2 * cos(ga)), &mec
	        );
	        sp[np - 1 - i].y = dk3ma_d_add_ok(
	          (obj->dt).arc.yc, (r2 * sin(ga)), &mec
	        );
	        

#line 5217 "dk3figah.ctr"
	        

#line 5218 "dk3figah.ctr"
	      }
	      ga = a0 + f * b1;
	      sp[nsegs].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, (r1 * cos(ga)), &mec
	      );
	      sp[nsegs].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, (r1 * sin(ga)), &mec
	      );
	      sp[nsegs].s = 0.0;
	      sp[nsegs + 1].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, (r2 * cos(ga)), &mec
	      );
	      sp[nsegs + 1].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, (r2 * sin(ga)), &mec
	      );
	      sp[nsegs + 1].s = 0.0;
	      

#line 5235 "dk3figah.ctr"
	      

#line 5236 "dk3figah.ctr"
	      

#line 5237 "dk3figah.ctr"
	    }
	  }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_INVERSE: {
      b1 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if(b1 < (2.0 * M_PI)) {	

#line 5247 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
	);			

#line 5251 "dk3figah.ctr"
	if(drw->minspp > nsegs) { nsegs = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_mul_size_t(2, nsegs, &mec), 1, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      sp[0].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(a0 + f * b1)), &mec
	      );
	      sp[0].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(a0 + f * b1)), &mec
	      );
	      sp[0].s = 0.0;	

#line 5272 "dk3figah.ctr"
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
	        r1 = dk3ma_d_add_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * ((double)j / (double)nsegs)),
		  &mec
	        );
	        r2 = dk3ma_d_sub_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * ((double)j / (double)nsegs)),
		  &mec
	        );
	        ga = (
	          (j == nsegs)
		  ? (a0)
		  : (a0 + f * b1 * (1.0 - ((double)j / (double)nsegs)))
	        );
	        sp[j].x = dk3ma_d_add_ok(
	          (obj->dt).arc.xc, (r1 * cos(ga)), &mec
	        );
	        sp[j].y = dk3ma_d_add_ok(
	          (obj->dt).arc.yc, (r1 * sin(ga)), &mec
	        );	

#line 5295 "dk3figah.ctr"
	        sp[j].s = ((j == nsegs) ? 0.0 : (-1.0));
	        sp[np - 1 - i].x = dk3ma_d_add_ok(
	          (obj->dt).arc.xc, (r2 * cos(ga)), &mec
	        );
	        sp[np - 1 - i].y = dk3ma_d_add_ok(
	          (obj->dt).arc.yc, (r2 * sin(ga)), &mec
	        );	

#line 5302 "dk3figah.ctr"
	        sp[np - 1 - i].s = ((j == nsegs) ? 0.0 : (-1.0));
	      } 

#line 5304 "dk3figah.ctr"
	    }
	  }
        }
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_INDENTED_FILLED_HALF: {
      if(ah->af) {
        if(ab) { mustadd = 1; }
      } else {
        if(!(ab)) { mustadd = 1; }
      }
      b1 = dk3ma_d_div_ok(
        dk3ma_d_mul_ok(1.25, ah->he, &mec),
	(obj->dt).arc.ra, &mec
      );
      b2 = dk3ma_d_div_ok((0.25 * ah->he), (obj->dt).arc.ra, &mec);
      b3 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if((b1 < (2.0 * M_PI)) && (b2 < (2.0 * M_PI)) && (b3 < (2.0 * M_PI))) {
        

#line 5325 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 5329 "dk3figah.ctr"
	ns2   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b2, drw->arcspp, &mec) / M_PI_2),
	  &mec
	); 

#line 5333 "dk3figah.ctr"
	ns3   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b3, drw->arcspp, &mec) / M_PI_2),
	  &mec
	);
        if(drw->minspp > nsegs) { nsegs = drw->minspp; }
        if(drw->minspp > ns2) { ns2 = drw->minspp; }
	if(drw->minspp > ns3) { ns3 = drw->minspp; }
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(nsegs, ns2, &mec), &mec);
	if(0 == mec) {
          ao1 = dk3fig_obj_new(
            obj->li, obj->la,
	    DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, 7, 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
          );
          if(ao1) {
            ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      /* Arrowhead front point */
	      sp[nsegs + ns2 - 1].x = (obj->dt).arc.ra * cos(a0);
	      sp[nsegs + ns2 - 1].y = (obj->dt).arc.ra * sin(a0);
	      sp[nsegs + ns2 - 1].s = 0.0;
	      

#line 5358 "dk3figah.ctr"
	      /* Outer edges of arrowhead */
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
	        if(j == nsegs) {
		  ga = a0 + f * b1;
	          r1 = dk3ma_d_sub_ok(
	            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	          );
	          r2 = dk3ma_d_add_ok(
	            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
	          );
	          sp[nsegs + ns2 - 1 - j].s = 0.0;
	          sp[nsegs + ns2 - 1 + j].s = 0.0;
	        } else {
		  ga = a0 + f * b1 * ((double)j / (double)nsegs);
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ah->wi * ((double)j / (double)nsegs)),
		    &mec
		  );
		  r2 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ah->wi * ((double)j / (double)nsegs)),
		    &mec
		  );
	          sp[nsegs + ns2 - 1 - j].s = -1.0;
	          sp[nsegs + ns2 - 1 + j].s = -1.0;
	        }
	        sp[nsegs + ns2 - 1 - j].x = r1 * cos(ga);
	        sp[nsegs + ns2 - 1 - j].y = r1 * sin(ga);
	        sp[nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	        sp[nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	        

#line 5391 "dk3figah.ctr"
	        

#line 5392 "dk3figah.ctr"
	      }
	      /* Inner edges of arrowhead */
	      for(i = 0; i < (ns2 - 1); i++) {
	        j = i + 1;
	        ga = a0 + f * (b1 - b2 * ((double)j / (double)ns2));
	        r1 = dk3ma_d_sub_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		  &mec
	        );
	        r2 = dk3ma_d_add_ok(
	          (obj->dt).arc.ra,
		  (0.5 * ah->wi * (1.0 - ((double)j / (double)ns2))),
		  &mec
	        );
	        sp[ns2 - 1 - j].x = r1 * cos(ga);
	        sp[ns2 - 1 - j].y = r1 * sin(ga);
	        sp[ns2 - 1 - j].s = -1.0;
	        sp[2 * nsegs + ns2 - 1 + j].x = r2 * cos(ga);
	        sp[2 * nsegs + ns2 - 1 + j].y = r2 * sin(ga);
	        sp[2 * nsegs + ns2 - 1 + j].s = -1.0;
	        

#line 5414 "dk3figah.ctr"
	        

#line 5415 "dk3figah.ctr"
	      }
	      /* Inner arrowhead front point */
	      ga = a0 + f * (b1 - b2);
	      r1 = (obj->dt).arc.ra;
	      sp[2 * (nsegs + ns2) - 1].x = r1 * cos(ga);
	      sp[2 * (nsegs + ns2) - 1].y = r1 * sin(ga);
	      sp[2 * (nsegs + ns2) - 1].s = 0.0;
	      

#line 5423 "dk3figah.ctr"
	      /* Shift all points */
	      for(i = 0; i < np; i++) {
	        dk3fig_tool_shift_spoint(
	          &(sp[i]), (obj->dt).arc.xc, (obj->dt).arc.yc, &mec
	        );
	      } 

#line 5429 "dk3figah.ctr"
	      np = dk3mem_add_size_t(nsegs, dk3mem_add_size_t(ns2, ns3, &mec), &mec);
	      if(0 == mec) {
	        ao2 = dk3fig_obj_new(
	          obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	          0, obj->pc, obj->pc, 20,
	          DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	          1.0, 0, 0, np, NULL, drw->app
	        );
	        if(ao2) {		

#line 5438 "dk3figah.ctr"
	          ah->o2 = (void *)ao2;
	          sp = (ao2->dt).spl.po;
	          if(sp) {
	            back = 1;
		    sp[0].x = dk3ma_d_add_ok(
		      (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(a0)), &mec
		    );
		    sp[0].y = dk3ma_d_add_ok(
		      (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(a0)), &mec
		    );
		    sp[0].s = 0.0;	

#line 5449 "dk3figah.ctr"
		    /* Outer edge */
		    for(i = 0; i < nsegs; i++) {
		      j = i + 1;
		      if(j == nsegs) {
		        if(mustadd) {
		          r1 = dk3ma_d_add_ok(
		            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
		          );
		        } else {
		          r1 = dk3ma_d_sub_ok(
		            (obj->dt).arc.ra, (0.5 * ah->wi), &mec
		          );
		        }
		        ga = a0 + f * b1;
		      } else {
		        if(mustadd) {
		          r1 = dk3ma_d_add_ok(
		            (obj->dt).arc.ra,
			    (0.5 * ((double)j / (double)nsegs) * ah->wi),
			    &mec
		          );
		        } else {
		          r1 = dk3ma_d_sub_ok(
		            (obj->dt).arc.ra,
			    (0.5 * ((double)j / (double)nsegs) * ah->wi),
			    &mec
		          );
		        }
		        ga = a0 + f * b1 * ((double)j / (double)nsegs);
		      }
		      sp[j].x = dk3ma_d_add_ok(
		        (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		      );
		      sp[j].y = dk3ma_d_add_ok(
		        (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		      ); 

#line 5485 "dk3figah.ctr"
		      sp[j].s = ((j == nsegs) ? 0.0 : (-1.0));
		    }
		    /* Indention edge */
		    for(i = 0; i < ns2; i++) {
		      j = i + 1;
		      if(j == ns2) {
		        r1 = (obj->dt).arc.ra;
		        ga = a0 + f * (b1 - b2);
		      } else {
		        if(mustadd) {
		          r1 = dk3ma_d_add_ok(
		            (obj->dt).arc.ra,
			    (0.5 * ah->wi * (1.0 - ((double)j / (double)nsegs))),
			    &mec
		          );
		        } else {
		          r1 = dk3ma_d_sub_ok(
		            (obj->dt).arc.ra,
			    (0.5 * ah->wi * (1.0 - ((double)j / (double)nsegs))),
			    &mec
		          );
		        }
		        ga = a0 + f * (b1 - ((double)j / (double)nsegs) * b2);
		      }
		      sp[nsegs + j].x = dk3ma_d_add_ok(
		        (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		      );
		      sp[nsegs + j].y = dk3ma_d_add_ok(
		        (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		      ); 

#line 5515 "dk3figah.ctr"
		      sp[nsegs + j].s = ((j == ns2) ? 0.0 : (-1.0));
		    }
		    /* Inner edge */
		    for(i = 0; i < (ns3 - 1); i++) {
		      j = i + 1;
		      ga = a0 + f *(b1 - b2 - b3 * ((double)j / (double)nsegs));
		      sp[nsegs + ns2 + j].x = dk3ma_d_add_ok(
		        (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(ga)), &mec
		      );
		      sp[nsegs + ns2 + j].y = dk3ma_d_add_ok(
		        (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(ga)), &mec
		      ); 

#line 5527 "dk3figah.ctr"
		      sp[nsegs + ns2 + j].s = -1.0;
		    } 

#line 5529 "dk3figah.ctr"
	          }
	        }
	      }
	    }
          }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_CLOSED_HALF: {
      b1 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if(b1 < (2.0 * M_PI)) {		

#line 5542 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
	);
	if(drw->minspp > nsegs) { nsegs = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_mul_size_t(2, nsegs, &mec), 1, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      sp[0].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(a0)), &mec
	      );
	      sp[0].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(a0)), &mec
	      );
	      sp[0].s = 0.0;
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
		if(j == nsegs) {
		  ga = a0 + f * b1;
		  if(ab) {
		    r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		  } else {
		    r1 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		  }
		} else {
		  if(ab) {
		    r1 = dk3ma_d_add_ok(
		      (obj->dt).arc.ra,
		      (0.5 * ((double)j / (double)nsegs) * ah->wi),
		      &mec
		    );
		  } else {
		    r1 = dk3ma_d_sub_ok(
		      (obj->dt).arc.ra,
		      (0.5 * ((double)j / (double)nsegs) * ah->wi),
		      &mec
		    );
		  }
		  ga = a0 + f * b1 * ((double)j / (double)nsegs);
		}
		sp[j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		);
		sp[j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		);
		sp[j].s = ((j == nsegs) ? 0.0 : (-1.0));
		sp[np - 1 - i].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(ga)), &mec
		);
		sp[np - 1 - i].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(ga)), &mec
		);
		sp[np - 1 - i].s = ((j == nsegs) ? 0.0 : (-1.0));
	      } 

#line 5607 "dk3figah.ctr"
	    }
	  }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
    case DK3_FIG_AS_INDENTED_HALF: {
      b1 = dk3ma_d_div_ok(
        dk3ma_d_mul_ok(1.25, ah->he, &mec), (obj->dt).arc.ra, &mec
      );
      b2 = dk3ma_d_div_ok((0.25 * ah->he), (obj->dt).arc.ra, &mec);
      b3 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if((b1 < (2.0 * M_PI)) && (b2 < (2.0 * M_PI)) && (b3 < (2.0 * M_PI))) {
        

#line 5622 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 5626 "dk3figah.ctr"
	ns2   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b2, drw->arcspp, &mec) / M_PI_2),
	  &mec
	); 

#line 5630 "dk3figah.ctr"
	ns3   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b3, drw->arcspp, &mec) / M_PI_2),
	  &mec
	);
        if(drw->minspp > nsegs) { nsegs = drw->minspp; }
        if(drw->minspp > ns2) { ns2 = drw->minspp; }
	if(drw->minspp > ns3) { ns3 = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_add_size_t(nsegs, ns2, &mec), ns3, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {			

#line 5649 "dk3figah.ctr"
	      back = 1;
	      /* front point */
	      sp[0].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(a0)), &mec
	      );
	      sp[0].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(a0)), &mec
	      );		

#line 5657 "dk3figah.ctr"
	      sp[0].s = 0.0;
	      /* outer edge */
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
		if(ab) {
		  r1 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ((double)j / (double)nsegs) * ah->wi),
		    &mec
		  );
		} else {
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ((double)j / (double)nsegs) * ah->wi),
		    &mec
		  );
		}
		ga = a0 + f * b1 * ((double)j / (double)nsegs);
		if(j == nsegs) {
		  if(ab) {
		    r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		  } else {
		    r1 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		  }
		  ga = a0 + f * b1;
		}
		sp[j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		);
		sp[j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		);		

#line 5689 "dk3figah.ctr"
		sp[j].s = ((j == nsegs) ? 0.0 : (-1.0));
	      }
	      /* indention edge */
	      for(i = 0; i < ns2; i++) {
	        j = i + 1;
		if(ab) {
		  r1 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * (1.0 - ((double)j / (double)ns2)) * ah->wi),
		    &mec
		  );
		} else {
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * (1.0 - ((double)j / (double)ns2)) * ah->wi),
		    &mec
		  );
		}
		ga = a0 + f * (b1 - b2 * ((double)j / (double)ns2));
		if(j == ns2) {
		  r1 = (obj->dt).arc.ra;
		  ga = a0 + f * (b1 - b2);
		}
		sp[nsegs + j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		);
		sp[nsegs + j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		);		

#line 5718 "dk3figah.ctr"
		sp[nsegs + j].s = ((j == ns2) ? 0.0 : (-1.0));
	      }
	      /* inner edge */
	      for(i = 0; i < (ns3 - 1); i++) {
	        j = i + 1;
		ga = a0 + f * (b1 - b2 - b3 * ((double)j / (double)ns3));
		sp[nsegs + ns2 + j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(ga)), &mec
		);
		sp[nsegs + ns2 + j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(ga)), &mec
		);		

#line 5730 "dk3figah.ctr"
		sp[nsegs + ns2 + j].s = -1.0;
	      } 

#line 5732 "dk3figah.ctr"
	    }
	  }
	}
      } else {
        /* ##### ERROR: Arrow too long */
      }
    } break;
    case DK3_FIG_AS_BUTTED_HALF: {
      b1 = dk3ma_d_div_ok(
        (0.75 * ah->he), (obj->dt).arc.ra, &mec
      );
      b2 = dk3ma_d_div_ok((0.25 * ah->he), (obj->dt).arc.ra, &mec);
      b3 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if((b1 < (2.0 * M_PI)) && (b2 < (2.0 * M_PI)) && (b3 < (2.0 * M_PI))) {
        

#line 5747 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 5751 "dk3figah.ctr"
	ns2   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b2, drw->arcspp, &mec) / M_PI_2),
	  &mec
	); 

#line 5755 "dk3figah.ctr"
	ns3   = dk3ma_d_to_sz_ok(
	  ceil(dk3ma_d_mul_ok(b3, drw->arcspp, &mec) / M_PI_2),
	  &mec
	);
        if(drw->minspp > nsegs) { nsegs = drw->minspp; }
        if(drw->minspp > ns2) { ns2 = drw->minspp; }
	if(drw->minspp > ns3) { ns3 = drw->minspp; }
	np = dk3mem_add_size_t(dk3mem_add_size_t(nsegs, ns2, &mec), ns3, &mec);
	if(0 == mec) {
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 5,
	    obj->lw, obj->pc, ((ah->af) ? obj->pc : 7), 20,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {			

#line 5774 "dk3figah.ctr"
	      back = 1;
	      /* front point */
	      sp[0].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(a0)), &mec
	      );
	      sp[0].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(a0)), &mec
	      );		

#line 5782 "dk3figah.ctr"
	      sp[0].s = 0.0;
	      /* outer edge */
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
		if(ab) {
		  r1 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ((double)j / (double)nsegs) * ah->wi),
		    &mec
		  );
		} else {
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ((double)j / (double)nsegs) * ah->wi),
		    &mec
		  );
		}
		ga = a0 + f * b1 * ((double)j / (double)nsegs);
		if(j == nsegs) {
		  if(ab) {
		    r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		  } else {
		    r1 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		  }
		  ga = a0 + f * b1;
		}
		sp[j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		);
		sp[j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		);		

#line 5814 "dk3figah.ctr"
		sp[j].s = ((j == nsegs) ? 0.0 : (-1.0));
	      }
	      /* indention edge */
	      for(i = 0; i < ns2; i++) {
	        j = i + 1;
		if(ab) {
		  r1 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * (1.0 - ((double)j / (double)ns2)) * ah->wi),
		    &mec
		  );
		} else {
		  r1 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * (1.0 - ((double)j / (double)ns2)) * ah->wi),
		    &mec
		  );
		}
		ga = a0 + f * (b1 + b2 * ((double)j / (double)ns2));
		if(j == ns2) {
		  r1 = (obj->dt).arc.ra;
		  ga = a0 + f * (b1 + b2);
		}
		sp[nsegs + j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		);
		sp[nsegs + j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		);		

#line 5843 "dk3figah.ctr"
		sp[nsegs + j].s = ((j == ns2) ? 0.0 : (-1.0));
	      }
	      /* inner edge */
	      for(i = 0; i < (ns3 - 1); i++) {
	        j = i + 1;
		ga = a0 + f * (b1 + b2 - b3 * ((double)j / (double)ns3));
		sp[nsegs + ns2 + j].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc, ((obj->dt).arc.ra * cos(ga)), &mec
		);
		sp[nsegs + ns2 + j].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc, ((obj->dt).arc.ra * sin(ga)), &mec
		);		

#line 5855 "dk3figah.ctr"
		sp[nsegs + ns2 + j].s = -1.0;
	      } 

#line 5857 "dk3figah.ctr"
	    }
	  }
	}
      } else {
        /* ##### ERROR: Arrow too long */
      }
    } break;
    case DK3_FIG_AS_TRIANGLE_FORK: {
      if(ah->af) {		

#line 5866 "dk3figah.ctr"
	ao1 = dk3fig_obj_new(
	  obj->li, obj->la, DK3_FIG_OBJ_POLYLINE, 1,
	  obj->lw, obj->pc, obj->pc, -1,
	  DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	  1.0, 0, 0, 2, NULL, drw->app
	);
	if(ao1) {		

#line 5873 "dk3figah.ctr"
	  ah->o1 = (void *)ao1;
	  po = (ao1->dt).pol.po;
	  if(po) {		

#line 5876 "dk3figah.ctr"
	    back = 1;
	    r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
	    r2 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
	    po[0].x = dk3ma_d_add_ok((obj->dt).arc.xc, (r1 * cos(a0)), &mec);
	    po[0].y = dk3ma_d_add_ok((obj->dt).arc.yc, (r1 * sin(a0)), &mec);
	    po[1].x = dk3ma_d_add_ok((obj->dt).arc.xc, (r2 * cos(a0)), &mec);
	    po[1].y = dk3ma_d_add_ok((obj->dt).arc.yc, (r2 * sin(a0)), &mec);
	    

#line 5884 "dk3figah.ctr"
	    

#line 5885 "dk3figah.ctr"
	  }
	}
      } else {
        b1 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
	if(b1 < (2.0 * M_PI)) {			

#line 5890 "dk3figah.ctr"
	  nsegs = dk3ma_d_to_sz_ok(
	    ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	    &mec
	  );
	  if(drw->minspp > nsegs) { nsegs = drw->minspp; }
	  np = dk3mem_add_size_t(dk3mem_mul_size_t(2, nsegs, &mec), 1, &mec);
	  if(0 == mec) {
	    ao1 = dk3fig_obj_new(
	      obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 4,
	      obj->lw, obj->pc, -1, -1,
	      DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	      1.0, 0, 0, np, NULL, drw->app
	    );
	    if(ao1) {
	      ah->o1 = (void *)ao1;
	      sp = (ao1->dt).spl.po;
	      if(sp) {
	        back = 1;
		ga = a0 + f * b1;
		sp[nsegs].x = dk3ma_d_add_ok(
		  (obj->dt).arc.xc,
		  ((obj->dt).arc.ra * cos(ga)),
		  &mec
		);
		sp[nsegs].y = dk3ma_d_add_ok(
		  (obj->dt).arc.yc,
		  ((obj->dt).arc.ra * sin(ga)),
		  &mec
		);
		sp[nsegs].s = 0.0;
		for(i = 0; i < nsegs; i++) {
		  j = i + 1;
		  r1 = dk3ma_d_add_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ((double)j / (double)nsegs) * ah->wi),
		    &mec
		  );
		  r2 = dk3ma_d_sub_ok(
		    (obj->dt).arc.ra,
		    (0.5 * ((double)j / (double)nsegs) * ah->wi),
		    &mec
		  );
		  ga = a0 + f * b1 * (1.0 - ((double)j / (double)nsegs));
		  if(j == nsegs) {
		    r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		    r2 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
		    ga = a0;
		  }
		  sp[nsegs + j].x = dk3ma_d_add_ok(
		    (obj->dt).arc.xc, (r1 * cos(ga)), &mec
		  );
		  sp[nsegs + j].y = dk3ma_d_add_ok(
		    (obj->dt).arc.yc, (r1 * sin(ga)), &mec
		  );
		  sp[nsegs + j].s = ((j == nsegs) ? 0.0 : (-1.0));
		  sp[nsegs - j].x = dk3ma_d_add_ok(
		    (obj->dt).arc.xc, (r2 * cos(ga)), &mec
		  );
		  sp[nsegs - j].y = dk3ma_d_add_ok(
		    (obj->dt).arc.yc, (r2 * sin(ga)), &mec
		  );
		  sp[nsegs - j].s = ((j == nsegs) ? 0.0 : (-1.0));
		}
	      }
	    }
	  }
	} else {
	  /* ##### ERROR: Arrow too long! */
	}
      }
    } break;
    case DK3_FIG_AS_RECTANGLE_FORK: {
      b1 = dk3ma_d_div_ok(ah->he, (obj->dt).arc.ra, &mec);
      if(b1 < (2.0 * M_PI)) {		

#line 5964 "dk3figah.ctr"
        nsegs = dk3ma_d_to_sz_ok(
          ceil(dk3ma_d_mul_ok(b1, drw->arcspp, &mec) / M_PI_2),
	  &mec
        ); 

#line 5968 "dk3figah.ctr"
	if(drw->minspp > nsegs) { nsegs = drw->minspp; }
	np = dk3mem_mul_size_t(2, dk3mem_add_size_t(nsegs, 1, &mec), &mec);
	if(0 == mec) {		

#line 5971 "dk3figah.ctr"
	  ao1 = dk3fig_obj_new(
	    obj->li, obj->la, DK3_FIG_OBJ_SPLINE, 4,
	    obj->lw, obj->pc, obj->pc, -1,
	    DK3_FIG_LC_BUTT, DK3_FIG_LJ_MITER, DK3_FIG_LS_SOLID,
	    1.0, 0, 0, np, NULL, drw->app
	  );
	  if(ao1) {
	    ah->o1 = (void *)ao1;
	    sp = (ao1->dt).spl.po;
	    if(sp) {
	      back = 1;
	      r1 = dk3ma_d_add_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
	      r2 = dk3ma_d_sub_ok((obj->dt).arc.ra, (0.5 * ah->wi), &mec);
	      if(ah->af) {			

#line 5985 "dk3figah.ctr"
	        ga = a0;
	      } else {				

#line 5987 "dk3figah.ctr"
	        ga = a0 + f * b1;
	      }
	      sp[nsegs].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, (r1 * cos(ga)), &mec
	      );
	      sp[nsegs].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, (r1 * sin(ga)), &mec
	      ); 

#line 5995 "dk3figah.ctr"
	      sp[nsegs].s = 0.0;
	      sp[nsegs + 1].x = dk3ma_d_add_ok(
	        (obj->dt).arc.xc, (r2 * cos(ga)), &mec
	      );
	      sp[nsegs + 1].y = dk3ma_d_add_ok(
	        (obj->dt).arc.yc, (r2 * sin(ga)), &mec
	      ); 

#line 6002 "dk3figah.ctr"
	      sp[nsegs + 1].s = 0.0;
	      for(i = 0; i < nsegs; i++) {
	        j = i + 1;
		if(ah->af) {
		  ga = a0 + f * b1 * ((double)j / (double)nsegs);
		} else {
		  ga = a0 + f * b1 * (1.0 - ((double)j / (double)nsegs));
		}
	        sp[nsegs - j].x = dk3ma_d_add_ok(
	          (obj->dt).arc.xc, (r1 * cos(ga)), &mec
	        );
	        sp[nsegs - j].y = dk3ma_d_add_ok(
	          (obj->dt).arc.yc, (r1 * sin(ga)), &mec
	        ); 

#line 6016 "dk3figah.ctr"
	        sp[nsegs - j].s = 0.0;
	        sp[nsegs + 1 + j].x = dk3ma_d_add_ok(
	          (obj->dt).arc.xc, (r2 * cos(ga)), &mec
	        );
	        sp[nsegs + 1 + j].y = dk3ma_d_add_ok(
	          (obj->dt).arc.yc, (r2 * sin(ga)), &mec
	        ); 

#line 6023 "dk3figah.ctr"
	        sp[nsegs + 1 + j].s = 0.0;
	      }
	    }
	  } else {
            dk3fig_set_ec(drw, DK3_ERROR_MEMORY);
	  }
	}
      } else {
        /* ##### ERROR: Arrowhead too long! */
      }
    } break;
  }
  if(mec) {					

#line 6036 "dk3figah.ctr"
    back = 0;
    if(ec) { *ec = mec; }
  }
  

#line 6040 "dk3figah.ctr"
  return  back;
}



/**	Calculate arrowheads for arc.
	@param	drw	Drawing to modify.
	@param	obj	Object to modify.
	@param	objno	Object number.
	@return	1 on success, 0 on error.
*/
static
int
dk3figah_calculate_arc(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 objno
)
{
  dk3_fig_poly_point_t	 sp;
  double		 cuts = -1.0;
  double		 cute = -1.0;
  double		 das  = 0.0;
  double		 dae  = 0.0;
  double		 newas = 0.0;
  double		 newae = 0.0;
  double		 alphaf = 0.0;
  double		 alphab = 0.0;
  int			 back = 1;
  int			 mec  = 0;
  int			 res = 0;
  

#line 6072 "dk3figah.ctr"
  /*
  	Construct arrowhead objects.
  */
  if(obj->af) {
    cute = dk3figah_length_correction(drw, obj, obj->af, &mec);
  }
  if(obj->ab) {
    cuts = dk3figah_length_correction(drw, obj, obj->ab, &mec);
  } 

#line 6081 "dk3figah.ctr"
  /*
  	Create arrowhead objects.
  */
  if((obj->dt).arc.ae >= (obj->dt).arc.as) {
    if(obj->af) {
        alphaf = (obj->dt).arc.ae + M_PI_2;
    }
    if(obj->ab) {
        alphab = (obj->dt).arc.as - M_PI_2;
    }
  } else {
    if(obj->af) {
        alphaf = (obj->dt).arc.ae - M_PI_2;
    }
    if(obj->ab) {
        alphab = (obj->dt).arc.as + M_PI_2;
    }
  }
  if(drw->coah) {
      if(obj->af) {
        sp.x = dk3ma_d_add_ok(
	  (obj->dt).arc.xc,
	  ((obj->dt).arc.ra * cos((obj->dt).arc.ae)),
	  &mec
	);
	sp.y = dk3ma_d_add_ok(
	  (obj->dt).arc.yc,
	  ((obj->dt).arc.ra * sin((obj->dt).arc.ae)),
	  &mec
	); 

#line 6111 "dk3figah.ctr"
        res = dk3figah_straight_arrowhead(
	  drw, obj, obj->af, &sp, alphaf, &mec
	);
	if(!(res)) { back = 0; }
      }
      if(obj->ab) {
        sp.x = dk3ma_d_add_ok(
	  (obj->dt).arc.xc,
	  ((obj->dt).arc.ra * cos((obj->dt).arc.as)),
	  &mec
	);
	sp.y = dk3ma_d_add_ok(
	  (obj->dt).arc.yc,
	  ((obj->dt).arc.ra * sin((obj->dt).arc.as)),
	  &mec
	); 

#line 6127 "dk3figah.ctr"
        res = dk3figah_straight_arrowhead(
	  drw, obj, obj->ab, &sp, alphab, &mec
	);
	if(!(res)) { back = 0; }
      }
      if(mec) { back = 0; }
  } else {
    if(obj->af) {
      if(!dk3figah_one_arc_arrowhead(drw, obj, obj->af, 0, &mec)) {
        back = 0;
      }
    }
    if(obj->ab) {
      if(!dk3figah_one_arc_arrowhead(drw, obj, obj->ab, 1, &mec)) {
        back = 0;
      }
    }
  }
  /*
  	Cut arc if necessary when not using compatible arrowheads.
  */
  if(!(drw->coah)) {
    newas = (obj->dt).arc.as;
    newae = (obj->dt).arc.ae;
    if(0.0 < cuts) {		

#line 6152 "dk3figah.ctr"
      if(dk3figah_must_use_arc_correction(obj->ab)) {
        das = dk3figah_arc_correction((obj->dt).arc.ra, cuts, &mec);
	if(0.0 <= das) {
	  if((obj->dt).arc.di) {	

#line 6156 "dk3figah.ctr"
	    newas = dk3ma_d_add_ok(newas, das, &mec);
	  } else {			

#line 6158 "dk3figah.ctr"
	    newas = dk3ma_d_sub_ok(newas, das, &mec);
	  }
	} else {
	  mec = DK3_ERROR_MATH_OUT_OF_RANGE;
	}
      } else {
        das = dk3ma_d_div_ok(cuts, (obj->dt).arc.ra, &mec);
	

#line 6166 "dk3figah.ctr"
        if((obj->dt).arc.di) {		

#line 6167 "dk3figah.ctr"
          newas = dk3ma_d_add_ok(newas, das, &mec);
        } else {			

#line 6169 "dk3figah.ctr"
          newas = dk3ma_d_sub_ok(newas, das, &mec);
        }
      }
    }
    if(0.0 < cute) {		

#line 6174 "dk3figah.ctr"
      if(dk3figah_must_use_arc_correction(obj->af)) {
        dae = dk3figah_arc_correction((obj->dt).arc.ra, cute, &mec);
	if(0.0 <= dae) {
	  if((obj->dt).arc.di) {	

#line 6178 "dk3figah.ctr"
	    newae = dk3ma_d_sub_ok(newae, dae, &mec);
	  } else {			

#line 6180 "dk3figah.ctr"
	    newae = dk3ma_d_add_ok(newae, dae, &mec);
	  }
	} else {
	  mec = DK3_ERROR_MATH_OUT_OF_RANGE;
	}
      } else {
        dae = dk3ma_d_div_ok(cute, (obj->dt).arc.ra, &mec);
	

#line 6188 "dk3figah.ctr"
        if((obj->dt).arc.di) {		

#line 6189 "dk3figah.ctr"
          newae = dk3ma_d_sub_ok(newae, dae, &mec);
        } else {			

#line 6191 "dk3figah.ctr"
          newae = dk3ma_d_add_ok(newae, dae, &mec);
        }
      }
    }
    if(0 == mec) {
      

#line 6197 "dk3figah.ctr"
      

#line 6198 "dk3figah.ctr"
      

#line 6199 "dk3figah.ctr"
      

#line 6200 "dk3figah.ctr"
      

#line 6201 "dk3figah.ctr"
      

#line 6202 "dk3figah.ctr"
      

#line 6203 "dk3figah.ctr"
      

#line 6204 "dk3figah.ctr"
      (obj->dt).arc.as = newas; (obj->dt).arc.ae = newae;
    } else {
      /* ##### ERROR: Math error */
      back = 0;
    }
  } else {
    if(0 != mec) {
      back = 0;
      dk3app_log_i1(drw->app, DK3_LL_ERROR, 260);
    }
  }
  

#line 6216 "dk3figah.ctr"
  return back;
}



int
dk3figah_calculate_arrowheads(
  dk3_fig_drawing_t	*drw,
  dk3_fig_obj_t		*obj,
  unsigned long		 objno
)
{
  int		 back = 0;
  int		 failed = 0;
  

#line 6231 "dk3figah.ctr"
  if((drw) && (obj)) {
    back = 1;
    if(dk3figah_candidate(obj)) {
      /*
      	Use butted line when arrowheads on both ends.
      */
      if((obj->af) && (obj->ab)) { obj->cs = DK3_FIG_LC_BUTT; }
      switch(obj->ot) {
        case DK3_FIG_OBJ_POLYLINE: {
	  back = dk3figah_calculate_polyline(drw, obj, objno);
	  if(!(back)) { failed = 1; }
	} break;
	case DK3_FIG_OBJ_SPLINE: {
	  back = dk3figah_calculate_spline(drw, obj, objno);
	  if(!(back)) { failed = 1; }
	} break;
	case DK3_FIG_OBJ_ARC: {
	  back = dk3figah_calculate_arc(drw, obj, objno);
	  if(!(back)) { failed = 1; }
        } break;
      }
      if(failed) {
        /* ##### ERROR: Arrowhead calculation failed! */
      }
    }
  }
  if(!(back)) {
    dk3app_log_1(drw->app, DK3_LL_ERROR, drw->msg, 5);
  }  

#line 6260 "dk3figah.ctr"
  return back;
}

