/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3enc.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3ENC_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3ENC_H_INCLUDED 1


#line 10 "dk3enc.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**	Convert long number from net to host representation.
	@param	x	Number to convert.
	@return Conversion result.
*/
unsigned long
dk3enc_ntohl(unsigned long x);

/**	Convert long number from host to net representation.
	@param	x	Number to convert.
	@return Conversion result.
*/
unsigned long
dk3enc_htonl(unsigned long x);

/**	Convert short  number from net to host representation.
	@param	x	Number to convert.
	@return Conversion result.
*/
unsigned short
dk3enc_ntohs(unsigned short x);

/**	Convert short  number from host to net representation.
	@param	x	Number to convert.
	@return Conversion result.
*/
unsigned short
dk3enc_htons(unsigned short x);

/**	Convert 32-bit character to UTF-8.
	@param	c	32-bit character to convert.
	@param	u8p	Pointer to result buffer.
	@param	u8l	Size of result buffer, should be 8 at least.
	@return	Number of bytes used in result buffer.
*/
size_t
dk3enc_uc2utf8(dk3_c32_t c, unsigned char *u8p, size_t u8l);

/**	Convert UTF-8 encoded text to 32-bit character.
	@param	ucp	Pointer to variable for result.
	@param	u8p	Buffer containing UTF-8 encoded text.
	@param	u8l	Number of bytes in buffer.
	@param	u8u	Pointer to variable to receive number of bytes used.
	@return	1 on success, 0 on error.
*/
int
dk3enc_utf82uc(dk3_c32_t *ucp, unsigned char const *u8p,size_t u8l,size_t *u8u);

/**	Convert IP address from 8-bit text string to long number
	in host representation.
	@param	str	Text string containing the IP address.
	@param	ul	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3enc_c8_ipaddr_to_ul_app(char const *str, unsigned long *ul, dk3_app_t *app);

/**	Convert IP address from string to long number
	in host representation.
	@param	str	Text string containing the IP address.
	@param	ul	Pointer to result variable.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3enc_ipaddr_to_ul_app(dkChar const *str, unsigned long *ul, dk3_app_t *app);

/**	Find size for result buffer needed to convert binary data to
	text using ASCII-85 encoding.
	@param	s	Size of binary data.
	@return	The required buffer length (includeing finalizing 0x00 byte).
*/
size_t
dk3enc_size_bin_to_a85(size_t s);

/**	Convert binary data to text using reverse ASCII-85 encoding.
	@param	dp	Destination buffer pointer.
	@param	ds	Size of \a dp.
	@param	sp	Binary (source) data.
	@param	ss	Number of bytes in \a sp.
	@param	app	Application structure, for diagnostics, may be NULL.
*/
int
dk3enc_bin_to_ra85_app(
  char *dp, size_t ds, char const *sp, size_t ss, dk3_app_t *app
);

/**	Find size for result buffer needed to convert ASCII-85 encoded
	data back to binary data.
	@param	s	Number of ASCII-85 text characters.
	@return	Length of resulting binary data.
*/
size_t
dk3enc_size_a85_to_bin(size_t s);

/**	Convert reverse ASCII-85 encoded data back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size in bytes.
	@param	sp	Source buffer pointer.
	@param	ss	Source buffer length.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Number of binary bytes decoded.
*/
size_t
dk3enc_ra85_to_bin_app(
  char *dp, size_t ds, char const *sp, size_t ss, dk3_app_t *app
);

#if 0
/**	Convert reverse ASCII-85 encoded data back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size in bytes.
	@param	sp	Source buffer pointer.
	@param	ss	Source buffer length.
	@return	Number of binary bytes decoded.
*/
size_t
dk3enc_ra85_to_bin(char *dp, size_t ds, char const *sp, size_t ss);
#endif

/**	Convert reverse ASCII-85 encoded data string back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size in bytes.
	@param	sp	Source buffer pointer.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Number of binary bytes decoded.
*/
size_t
dk3enc_ra85string_to_bin_app(
  char *dp, size_t ds, char const *sp, dk3_app_t *app
);

/**	Apply ASCII-85 encoding to binary data.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size.
	@param	sp	Source buffer pointer.
	@param	ss	Source buffer size.
	@param	app	Application structure for diagnostics, may be NULL.
*/
int
dk3enc_bin_to_a85_app(
  char *dp, size_t ds, char const *sp, size_t ss, dk3_app_t *app
);

/**	Decode ASCII-85 encoded data back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size.
	@param	sp	Source buffer pointer.
	@param	ss	Source buffer size.
	@param	app	Application structure for diagnostics, may be NULL.
*/
size_t
dk3enc_a85_to_bin_app(
  char *dp, size_t ds, char const *sp, size_t ss, dk3_app_t *app
);

/**	Decode ASCII-85 encoded data string back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size.
	@param	sp	Source buffer pointer.
	@param	app	Application structure for diagnostics, may be NULL.
*/
size_t
dk3enc_a85string_to_bin_app(char *dp, size_t ds, char const *sp, dk3_app_t *app);

/**	Calculate size for binary to hexadecimal conversion.
	@param	s	Size of binary data.
	@return	Size of hexadecimal encoding.
*/
size_t
dk3enc_size_bin_to_hex(size_t s);

/**	Calculate size for hexadecimal to binary conversion.
	@param	s	Size of hexadecimal data.
	@return	Size of binary data.
*/
size_t
dk3enc_size_hex_to_bin(size_t s);

/**	Apply hexadecimal encoding to binary data.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size.
	@param	sp	Source buffer pointer.
	@param	ss	Source buffer size.
	@param	app	Application structure for diagnostics, may be NULL.
*/
int
dk3enc_bin_to_hex_app(
  char *dp, size_t ds, char const *sp, size_t ss, dk3_app_t *app
);

/**	Convert hexadecimal encoded data back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size.
	@param	sp	Source buffer pointer.
	@param	ss	Source buffer size.
	@param	app	Application structure for diagnostics, may be NULL.
*/
size_t
dk3enc_hex_to_bin_app(
  char *dp, size_t ds, char const *sp, size_t ss, dk3_app_t *app
);

/**	Convert hexadecimal encoded data string back to binary.
	@param	dp	Destination buffer pointer.
	@param	ds	Destination buffer size.
	@param	sp	Source buffer pointer.
	@param	app	Application structure for diagnostics, may be NULL.
*/
size_t
dk3enc_hexstring_to_bin_app(
  char *dp, size_t ds, char const *sp, dk3_app_t *app
);

/**	Calculate size for hex decoding to binary.
	@param	s	String containing hexadecimal data.
	@return	Size of binary data.
*/
size_t
dk3enc_size_hexstring_to_bin(char const *s);

/**	Find size for conversion from ASCII-85 encoded data to binary.
 * 	@param	s	ASCII-85 encoded string.
 * 	@return	Size of binary data.
 */
size_t
dk3enc_size_a85string_to_bin(char const *s);

/**	Convert 32-bit character to UTF-16.
	If the value is 0xFFFF and below, the 16 bits are used ``as is''.
	For values \a c > 0xFFFF we have to build a surrogate pair.
	We substract 0x00010000, the result is a new character with
	20 significant bits. These 20 bits are splitted into two blocks of
	10 bits each. The high surrogate is built using the prefix
	bits 110110 and the higher 10-bits block. The low surrogate is built
	using the prefix bits 110111 and the lower 10-bits block.
	Order of surrogates in a surrogate pair is flexible, this function
	writes the high surrogate first.
	@param	c	The 32-bit character.
	@param	u16p	Buffer to receive UTF-16 encoded result.
	@param	u16l	Length of \a u16l in elements.
	@return	The number of dk3_c16_t characters produced.
*/
size_t
dk3enc_uc2utf16(dk3_c32_t c, dk3_c16_t *u16p, size_t u16l);

/**	Convert UTF-16 encoded characters to 32-bit character
	@param	ucp	Pointer to result variable.
	@param	u16p	Buffer containing UTF-16 encoded text.
	@param	u16l	Number of elements available in \a u16p.
	@param	u16u	Pointer to variable to receive number of dk3_c16_t used.
	@return	1 on success, 0 on error.
*/
int
dk3enc_utf162uc(dk3_c32_t *ucp, dk3_c16_t const *u16p, size_t u16l, size_t *u16u);

/**	Get data encoding type for name.
	@param	n	Data encoding name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Integer representation of data encoding on success, -1 on error.
*/
int
dk3enc_get_type_app(dkChar const *n, dk3_app_t *app);

/**	Get name for data encoding type.
	@param	t	Numeric type.
	@return	Name for type on success, NULL on error.
*/
dkChar const *
dk3enc_get_data_encoding_name(int t);

/**	Get numeric value for text encoding.
	@param	en	Encoding name.
	@param	app	Application structure, may be NULL.
	@return	Numeric representation of text encoding on success,
	-1 on error.
*/
int
dk3enc_get_text_encoding_app(dkChar const *en, dk3_app_t *app);

/**	Get the used encoding.
	@param	app	Application structure, may be NULL.
	@return	The encoding used for characters in memory.
*/
int
dk3enc_get_encoding(dk3_app_t *app);

#ifdef __cplusplus
}
#endif




#endif
