/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3echo.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3ECHO_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3ECHO_H_INCLUDED 1


#line 10 "dk3echo.ctr"

#include "dk3conf.h"



#if DK3_HAVE_TCGETATTR
/**	Terminal IO structure.
*/
typedef struct termios dk3_termios_t;
#else
#if defined(TCGETS)
/**	Terminal IO structure.
*/
typedef struct termios dk3_termios_t;
#else

#endif
#endif



/**	Keyboard echo configuration.
*/
typedef struct {
  
#if DK3_ON_WINDOWS

  /**	Handle for console.
  */
  HANDLE		consoleHandle;

  /**	Original console flags.
  */
  DWORD			ori;

#else
/* DK3_ON_WINDOWS */

#if DK3_HAVE_TCGETATTR

  /**	Original terminal settings.
  */
  dk3_termios_t		ori;

#else
/* DK3_HAVE_TCGETATTR */

#if defined(TCGETS)

  /**	Original terminal settings.
  */
  dk3_termios_t		ori;
#else
/* defined(TCGETS) */

#endif
/* defined(TCGETS) */

#endif
/* DK3_HAVE_TCGETATTR */

#endif
/* DK3_ON_WINDOWS */

  /**	Flag: Standard input is a terminal.
  */
  int			is_tty;

} dk3_echo_t;



#ifdef __cplusplus
extern "C" {
#endif

/**	Save current keyboard echo settings.
	@param	ep	Keyboard echo settings structure.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3echo_save_app(dk3_echo_t *ep, dk3_app_t *app);

/**	Restore keyboard echo settings.
	@param	ep	Keyboard echo settings structure.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3echo_restore_app(dk3_echo_t *ep, dk3_app_t *app);

/**	Disable keyboard echo.
	@param	ep	Keyboard echo settings structure.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3echo_off_app(dk3_echo_t *ep, dk3_app_t *app);

/**	Check whether standard input is from terminal for settings structure.
	@param	ep	Keyboard echo settings structure.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3echo_is_tty_app(dk3_echo_t const *ep, dk3_app_t *app);

/**	Check whether standard input is from terminal.
	@param	ep	Keyboard echo settings structure.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3echo_test_tty_app(dk3_echo_t *ep, dk3_app_t *app);

/**	Save current keyboard echo settings.
	@param	ep	Keyboard echo settings structure.
	@return	1 on success, 0 on error.
*/
int
dk3echo_save(dk3_echo_t *ep);

/**	Restore keyboard echo settings.
	@param	ep	Keyboard echo settings structure.
	@return	1 on success, 0 on error.
*/
int
dk3echo_restore(dk3_echo_t *ep);

/**	Disable keyboard echo.
	@param	ep	Keyboard echo settings structure.
	@return	1 on success, 0 on error.
*/
int
dk3echo_off(dk3_echo_t *ep);

/**	Check whether standard input is from terminal for settings structure.
	@param	ep	Keyboard echo settings structure.
	@return	1 on success, 0 on error.
*/
int
dk3echo_is_tty(dk3_echo_t *ep);

/**	Check whether standard input is from terminal.
	@param	ep	Keyboard echo settings structure.
	@return	1 on success, 0 on error.
*/
int
dk3echo_test_tty(dk3_echo_t *ep);

#ifdef __cplusplus
}
#endif




#endif
