/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3echo.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file dk3echo.c The dk3echo module.
*/


#line 168 "dk3echo.ctr"


#include "dk3all.h"
#include "dk3echo.h"




#line 175 "dk3echo.ctr"



int
dk3echo_save(dk3_echo_t *ep)
{
  int back;
  back = dk3echo_save_app(ep, NULL);
  return back;
}



int
dk3echo_save_app(dk3_echo_t *ep, dk3_app_t *app)
{
  int back = 0;
  if(ep) {
#if DK3_ON_WINDOWS
  ep->consoleHandle = GetStdHandle(STD_INPUT_HANDLE);
  if(ep->consoleHandle != INVALID_HANDLE_VALUE) {
    ep->is_tty = 1;
    if(GetConsoleMode(ep->consoleHandle, &(ep->ori))) {
      back = 1;
    } else {
      if(app) {
        /* ERROR: Failed to retrieve console settings! */
	dk3app_log_i1(app, DK3_LL_ERROR, 265);
      }
    }
  } else {
    if(app) {
      /* ERROR: Failed to obtain handle for standard input! */
      dk3app_log_i1(app, DK3_LL_ERROR, 265);
    }
  }
#else
#if DK3_HAVE_ISATTY
  ep->is_tty = isatty(0);
#else
  ep->is_tty = 1;
#endif
#if DK3_HAVE_TCGETATTR
  if(tcgetattr(0, &(ep->ori)) == 0) {
    back = 1;
  } else {
    if(app) {
      /* ERROR: Failed to retrieve console settings! */
      dk3app_log_i1(app, DK3_LL_ERROR, 265);
    }
  }
#else
#if defined(TCGETS)
  if(ioctl(0, TCGETS, &(ep->ori)) == 0) {
    back = 1;
  } else {
    if(app) {
      /* ERROR: Failed to retrieve console settings! */
      dk3app_log_i1(app, DK3_LL_ERROR, 265);
    }
  }
#else

#endif
#endif
#endif
  }
  return back;
}



int
dk3echo_restore(dk3_echo_t *ep)
{
  int back;
  back = dk3echo_restore_app(ep, NULL);
  return back;
}



int
dk3echo_restore_app(dk3_echo_t *ep, dk3_app_t *app)
{
  int back = 0;
  if(ep) {
#if DK3_ON_WINDOWS
    if(ep->consoleHandle != INVALID_HANDLE_VALUE) {
      if(SetConsoleMode(ep->consoleHandle, ep->ori)) {
        back = 1;
      } else {
        if(app) {
	  /* ERROR: Failed to restore console settings! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 266);
	}
      }
    }
#else
#if DK3_HAVE_TCGETATTR
    if(tcsetattr(0, TCSANOW, &(ep->ori)) == 0) {
      back = 1;
    } else {
      if(app) {
        /* ERROR: Failed to restore console settings! */
	dk3app_log_i1(app, DK3_LL_ERROR, 266);
      }
    }
#else
#if defined(TCGETS)
    if(ioctl(0, TCSETS, &(ep->ori)) == 0) {
      back = 1;
    } else {
      if(app) {
        /* ERROR: Failed to restore console settings! */
	dk3app_log_i1(app, DK3_LL_ERROR, 266);
      }
    }
#else

#endif
#endif
#endif
  }
  return back;
}



int
dk3echo_off(dk3_echo_t *ep)
{
  int back;
  back = dk3echo_off_app(ep, NULL);
  return back;
}



int
dk3echo_off_app(dk3_echo_t *ep, dk3_app_t *app)
{
  int back = 0;
  if(ep) {
#if DK3_ON_WINDOWS
    if(ep->consoleHandle != INVALID_HANDLE_VALUE) {
      if(SetConsoleMode(ep->consoleHandle,((ep->ori) & (~(ENABLE_ECHO_INPUT)))))
      {
        back = 1;
      }
      else
      {
        if(app) {
	  /* ERROR: Failed to modify console settings! */
	  dk3app_log_i1(app, DK3_LL_ERROR, 267);
	}
      }
    }
#else
#if DK3_HAVE_TCGETATTR
    dk3_termios_t	nti;
    dk3mem_cpy((void *)(&nti), (void *)(&(ep->ori)), sizeof(dk3_termios_t));
#if defined(ECHO)
    nti.c_lflag &= (~(ECHO));
#endif
#if defined(ECHONL)
    nti.c_lflag &= (~(ECHONL));
#endif
    if(tcsetattr(0, TCSANOW, &nti) == 0) {
      back = 1;
#if DK3_HAVE_TCFLUSH
      tcflush(0, TCIFLUSH);
#endif
    } else {
      if(app) {
        /* ERROR: Failed to modify terminal settings! */
	dk3app_log_i1(app, DK3_LL_ERROR, 267);
      }
    }
#else
#if defined(TCGETS)
    dk3_termios_t nti;
    dk3mem_cpy((void *)(&nti), (void *)(&(ep->ori)), sizeof(dk3_termios_t));
#if defined(ECHO)
    nti.c_lflag &= (~(ECHO));
#endif
#if defined(ECHONL)
    nti.c_lflag &= (~(ECHONL));
#endif
    if(ioctl(0, TCSETS, &nti) == 0) {
      back = 1;
      (void)ioctl(0, TCFLSH, 0);
    } else {
      if(app) {
        /* ERROR: Failed to modify terminal settings! */
	dk3app_log_i1(app, DK3_LL_ERROR, 267);
      }
    }
#else

#endif
#endif
#endif
  }
  return back;
}



int
dk3echo_is_tty(dk3_echo_t *ep)
{
  int back;
  back = dk3echo_is_tty_app(ep, NULL);
  return back;
}



int
dk3echo_is_tty_app(dk3_echo_t const *ep, dk3_app_t *app)
{
  int back = 0;
  if(ep) {
    back = ep->is_tty;
  }
  return back;
}



int
dk3echo_test_tty(dk3_echo_t *ep)
{
  int back;
  back = dk3echo_test_tty_app(ep, NULL);
  return back;
}



int
dk3echo_test_tty_app(dk3_echo_t *ep, dk3_app_t *app)
{
  int back = 0;
  if(ep) {
#if DK3_ON_WINDOWS
    if(GetStdHandle(STD_INPUT_HANDLE) != INVALID_HANDLE_VALUE) {
      back = 1;
    } else {
      if(app) {
        /* ERROR: Failed to retrieve console settings! */
	dk3app_log_i1(app, DK3_LL_ERROR, 265);
      }
    }
#else
#if DK3_HAVE_ISATTY
    back = isatty(0);
#endif
    dk3app_log_i1(app, DK3_LL_ERROR, 265);
#endif
  }
  return back;
}


/* vim: set ai sw=2 : */
