/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: dk3dir.ctr
*/

/*
Copyright (C) 2011-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file */

#ifndef DK3DIR_H_INCLUDED
/** Avoid multiple inclusions. */
#define DK3DIR_H_INCLUDED 1


#line 10 "dk3dir.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#ifdef __cplusplus
extern "C" {
#endif


/**	Open a directory.
	@param	dn	Directory name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to directory structure on success, NULL on error.
*/
dk3_dir_t *
dk3dir_open_app(dkChar const *dn, dk3_app_t *app);

/**	Open directory structure to expand a file name.
	@param	fn	File name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	Pointer to directory structure on success, NULL on errror.
*/
dk3_dir_t *
dk3dir_fne_open_app(dkChar const *fn, dk3_app_t *app);

/**	Close directory.
	@param	dp	Directory to close.
*/
void
dk3dir_close(dk3_dir_t *dp);

/**	Get number of subdirectories.
	@param	d	Directory structure.
	@return	Number of subdirectories.
*/
dk3_um_t
dk3dir_get_number_of_directories(dk3_dir_t const *d);

/**	Get number of files.
	@param	d	Directory structure.
	@return	Number of non-directory entries in directory.
*/
dk3_um_t
dk3dir_get_number_of_files(dk3_dir_t const *d);

/**	Attempt to retrieve information about the next sub-directory.
	@param	d	Directory structure.
	@return	1 on success, 0 on error.
*/
int
dk3dir_get_next_directory(dk3_dir_t *d);

/**	Attempt to retrieve information about the next non-sub-directory entry.
	@param	d	Directory structure.
	@return	1 on success, 0 on error.
*/
int
dk3dir_get_next_file(dk3_dir_t *d);

/**	Retrieve short file name of entry found.
	May be used after a successful call to dk3dir_get_next_directory() or
	dk3dir_get_next_file() only.
	@param	d	Directory structure.
	@return	Pointer to file name on success, NULL on error.
*/
dkChar const *
dk3dir_get_shortname(dk3_dir_t const *d);

/**	Retrieve full file name of entry found.
	May be used after a successful call to dk3dir_get_next_directory() or
	dk3dir_get_next_file() only.
	@param	d	Directory structure.
	@return	Pointer to file name on success, NULL on error.
*/
dkChar const *
dk3dir_get_fullname(dk3_dir_t const *d);

/**	Retrieve file status information.
	May be used after a successful call to dk3dir_get_next_directory() or
	dk3dir_get_next_file() only.
	@param	d	Directory structure.
	@return	Pointer to file name on success, NULL on error.
*/
dk3_stat_t const *
dk3dir_get_stat(dk3_dir_t *d);

/**	Reset directory for new traversal.
	@param	d	Directory structure.
*/
void
dk3dir_reset(dk3_dir_t *d);

/**	Retrieve directory name.
	@param	dir	Directory structure.
	@return	Directory path name.
*/
dkChar const *
dk3dir_get_directory_name(dk3_dir_t const *dir);

/**	Remove directory recursively, including all contents.
	@param	dn	Directory name.
	@param	app	Application structure for diagnostics, may be NULL.
	@return	1 on success, 0 on error.
*/
int
dk3dir_remove_app(dkChar const *dn, dk3_app_t *app);

#ifdef __cplusplus
}
#endif




#endif
